<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;

class Member extends Model implements Sortable
{
    use SortableTrait;

    protected $table = 'members';
    protected $fillable = [
        // 'user_id',
        // 'page_id',
        'member_id',
        'team_id',
        'card_type',
        'order',
        'custom_card_link',
        'note'
    ];

    public function members()
    {
        return $this->belongsTo(Button::class, 'team_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'member_id'); // use member_id, not id
    }

    public function subcard()
    {
        return $this->belongsTo(SubCard::class, 'member_id'); // use member_id, not id
    }
}
