<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Product;

class OrderRecord extends Model
{
    protected $table = 'order_record';

    protected $fillable = [
        'user_id',
        'page_id',
        'products',
        'price',
        'receipt',
        'firstname',
        'lastname',
        'phone',
        'email',
        'special_note',
        'shipping_address',
    ];

    protected $casts = [
        'products' => 'array',
    ];

    protected static function booted()
    {
        // if deleting, delete receipt from the server
        static::deleting(function ($order) {
            if ($order->receipt) {
                $path = 'app/public/' . $order->receipt;
                unlink(storage_path($path));
            }
        });
    }
}
