<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\User;
use App\Models\SubCard;

class Referral extends Model
{
    protected $table = 'referrals';

    protected $fillable = [
        'referrer_id_main',
        'referrer_id_sub',
        'referrer_type',
        'referred_id',
    ];

    public function referredUser()
    {
        return $this->belongsTo(User::class, 'referred_id');
    }

    public function referrer_main()
    {
        return $this->belongsTo(User::class, 'referrer_id_main');
    }

    public function referrer_sub()
    {
        return $this->belongsTo(SubCard::class, 'referrer_id_sub');
    }
}
