<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;
use App\Models\User;
use App\Models\SubCard;

class Review extends Model implements Sortable
{
    use SortableTrait;

    protected $fillable = [
        'user_id',
        'page_id',
        'title',
        'video_link',
        'review_text',
        'cta_text',
        'cta_link',
        'order',
        'is_active',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function subcard()
    {
        return $this->belongsTo(SubCard::class, 'page_id');
    }
}
