<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Sale;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;

class SaleImage extends Model implements Sortable
{
    use SortableTrait;

    protected $table = 'sales_images';

    protected $fillable = [
        'sales_id',
        'product_name',
        'description',
        'stock',
        'price',
        'image_path',
        'order',
        'is_active',
        'shop_online_button',
        'shop_online_link'
    ];

    public function sale()
    {
        return $this->belongsTo(Sale::class, 'sales_id');
    }

    protected static function booted()
    {
        // static::creating(function ($sale_image) {});

        // static::saving(function ($sale_image) {});

        static::updating(function ($sale_image) {
            if ($sale_image->isDirty('image_path') && $sale_image->getOriginal('image_path')) {
                $path = 'app/public/' . $sale_image->getOriginal('image_path');
                @unlink(storage_path($path));
            }
        });

        static::deleting(function ($sale_image) {
            $path = 'app/public/' . $sale_image->image_path;
            if ($sale_image->image_path) {
                @unlink(storage_path($path));
            }
        });
    }
}
