<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Helpers\SavingLinkHelpers;
use App\Observers\SendCardObserver;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;

#[ObservedBy([SendCardObserver::class])]

class SendCard extends Model
{
    protected $table = 'send_card';
    protected $fillable = [
        'firstname',
        'lastname',
        'email',
        'phone',
        'profile_pic',
        'digital_card',
        'physical_card',
        'physical_card_back',
        'preferred_way_to_connect',
    ];

    protected static function booted()
    {
        static::saving(function ($card) {
            if ($card->phone) {
                try {
                    $contactNumber = SavingLinkHelpers::saveContactNumber($card['phone']);
                    $card['phone'] = $contactNumber;
                } catch (\InvalidArgumentException $e) {
                    throw new \InvalidArgumentException('Invalid input. Please enter a valid number.');
                }
            }

            if ($card->digital_card) {
                try {
                    $digitalCard = SavingLinkHelpers::saveSecureLink($card['digital_card']);
                    $card['digital_card'] = $digitalCard;
                } catch (\InvalidArgumentException $e) {
                    throw new \InvalidArgumentException('Invalid input. Please enter a valid card link/website.');
                }
            }
        });

        static::deleting(function ($card) {
            if ($card->profile_pic) {
                $path = 'app/public/' . $card->profile_pic;
                unlink(storage_path($path));
            }

            if ($card->physical_card) {
                $path = 'app/public/' . $card->physical_card;
                unlink(storage_path($path));
            }

            if ($card->physical_card_back) {
                $path = 'app/public/' . $card->physical_card_back;
                unlink(storage_path($path));
            }
        });
    }
}
