<?php

namespace App\Models;

use App\Models\User;
use App\Models\SubCard;
use Illuminate\Database\Eloquent\Model;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;
use App\Helpers\SavingLinkHelpers;

class Social extends Model implements Sortable
{
    use SortableTrait;
    protected $table = 'socials';
    protected $fillable = [
        'link',
        'type',
        'user_id',
        'order',
        'is_active',
        'page_id'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function subcards()
    {
        return $this->belongsTo(SubCard::class);
    }

    protected static function booted()
    {
        static::saving(function ($social) {
            static::handleLinkFormatting($social);
        });
    }

    protected static function handleLinkFormatting($social)
    {
        if ($social['type'] == 'fanbase') {
            try {
                $fanbaseLink = SavingLinkHelpers::normalizeFanbaseLink($social['link']);
                $social['link'] = $fanbaseLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid Fanbase link or username.');
            }
        } else if ($social['type'] == 'snapchat') {
            try {
                $snapchatLink = SavingLinkHelpers::normalizeSnapchatLink($social['link']);
                $social['link'] = $snapchatLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid snapchat link or username.');
            }
        } else if ($social['type'] == 'pinterest') {
            try {
                $pinterestLink = SavingLinkHelpers::savePinterestLink($social['link']);
                $social['link'] = $pinterestLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid pinterest link or username.');
            }
        } else if ($social['type'] == 'clubhouse') {
            try {
                $clubhouseLink = SavingLinkHelpers::saveClubhouseLink($social['link']);
                $social['link'] = $clubhouseLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid Clubhouse link, username, or club name.');
            }
        } else if ($social['type'] == 'facebook') {
            try {
                $facebookLink = SavingLinkHelpers::saveFacebookLink($social['link']);
                $social['link'] = $facebookLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid Facebook link or username.');
            }
        } else if ($social['type'] == 'threads') {
            try {
                $threadsLink = SavingLinkHelpers::saveThreadsLink($social['link']);
                $social['link'] = $threadsLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid threads link or username.');
            }
        } else if ($social['type'] == 'instagram') {
            try {
                $instagramLink = SavingLinkHelpers::saveInstagramLink($social['link']);
                $social['link'] = $instagramLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid instagram link or username.');
            }
        } else if ($social['type'] == 'x') {
            try {
                $twitterLink = SavingLinkHelpers::saveTwitterXLink($social['link']);
                $social['link'] = $twitterLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid Twitter/X link or username.');
            }
        } else if ($social['type'] == 'youtube') {
            try {
                $youtubeLink = SavingLinkHelpers::saveYoutubeChannel($social['link']);
                $social['link'] = $youtubeLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid youtube channel link or username.');
            }
        } else if ($social['type'] == 'tiktok') {
            try {
                $tiktokLink = SavingLinkHelpers::saveTiktokLink($social['link']);
                $social['link'] = $tiktokLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid tiktok link or username.');
            }
        } else if ($social['type'] == 'linkedin') {
            try {
                $linkedinLink = SavingLinkHelpers::saveLinkedinLink($social['link']);
                $social['link'] = $linkedinLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid linkedin link or username.');
            }
        } else if ($social['type'] == 'soundcloud') {
            try {
                $soundcloudLink = SavingLinkHelpers::normalizeSoundCloudLink($social['link']);
                $social['link'] = $soundcloudLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. The input must be a valid SoundCloud link.');
            }
        } else if ($social['type'] == 'apple_podcasts') {
            try {
                $applePodcastsLink = SavingLinkHelpers::normalizeApplePodcastsLink($social['link']);
                $social['link'] = $applePodcastsLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. The input must be a valid Apple Podcasts link.');
            }
        } else if ($social['type'] == 'spotify') {
            try {
                $spotifyLink = SavingLinkHelpers::normalizeSpotifyLink($social['link']);
                $social['link'] = $spotifyLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. The input must be a valid Spotify link.');
            }
        } else if ($social['type'] == 'discord') {
            try {
                $discordLink = SavingLinkHelpers::normalizeDiscordLink($social['link']);
                $social['link'] = $discordLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. The input must be a valid Discord link.');
            }
        }
    }
}
