<?php

namespace App\Models;

use App\Models\Ad;
use App\Models\SponsorButton;
use App\Models\SponsorSocial;
use Illuminate\Database\Eloquent\Model;

class Sponsor extends Model
{
    protected $table = 'sponsors';
    protected $fillable = [
        'user_id',
        'page_id',
        'sponsor_name',
        'sponsor_type',
        'is_active'
    ];

    // public function ads()
    // {
    //     return $this->belongsTo(Ad::class, 'sponsor_id');
    // }

    public function ads()
    {
        return $this->hasMany(Ad::class, 'sponsor_id');
    }

    public function buttons()
    {
        return $this->hasMany(SponsorButton::class);
    }

    public function socials()
    {
        return $this->hasMany(SponsorSocial::class);
    }
}
