<?php

namespace App\Models;

use App\Models\User;
use App\Models\SubCard;
use Illuminate\Database\Eloquent\Model;

class UserSettings extends Model
{
    protected $table = 'user_settings';
    protected $fillable = [
        'user_id',
        'setting_key',
        'setting_value',
        'page_id'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function subcard()
    {
        return $this->belongsTo(SubCard::class);
    }
}
