<?php

namespace App\Models;

use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;
use Illuminate\Database\Eloquent\Model;

class Video extends Model implements Sortable
{
    use SortableTrait;

    protected $fillable = [
        'user_id',
        'title',
        'link',
        'video_type',
        'thumbnail',
        'order',
        'is_active',
        'page_id',
        'button_title',
        'button_link',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    protected static function booted()
    {
        static::updating(function ($video) {
            if ($video->isDirty('thumbnail') && $video->getOriginal('thumbnail')) {
                $path = 'app/public/' . $video->getOriginal('thumbnail');
                @unlink(storage_path($path));
            }
        });

        static::deleting(function ($video) {
            $path = 'app/public/' . $video->thumbnail;
            if ($video->thumbnail) {
                @unlink(storage_path($path));
            }
        });
    }
}
