<?php

namespace App\Policies;

use App\Models\Button;
use App\Models\SubCard;
use App\Models\User;

class ButtonPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->is_admin;
    }

    public function view(User $user): bool
    {
        return true;
    }

    public function create(User $user): bool
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $condition = ['page_id' => $page_id];
        }

        $button_count = auth()->user()
            ->buttons()
            ->where('view', 'links')
            ->when(!in_array(auth()->user()->user_type, ['Platinum']), fn($q) => $q->whereNot('type', 'trusted_network'))
            ->when(!in_array(auth()->user()->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'reviews'))
            ->when(!in_array(auth()->user()->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'zoom_replay'))
            ->when(!in_array(auth()->user()->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'team'))
            ->when(!in_array(auth()->user()->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'services'))
            ->when(!in_array(auth()->user()->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'shop'))
            ->when(!in_array(auth()->user()->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'bio'))
            ->when(!in_array(auth()->user()->user_type, ['Basic', 'Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'events'))
            ->when(!in_array(auth()->user()->user_type, ['Basic', 'Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'feedback'))
            ->when(!in_array(auth()->user()->user_type, ['Basic', 'Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'help'))
            ->when(!in_array(auth()->user()->user_type, ['Basic', 'Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'exchange'))
            ->where($condition)
            ->count();

        // Handle Community buttons
        $isCommunity = request()->routeIs('dashboard.communities.*') || request()->routeIs('communities.*');

        if ($isCommunity) {
            // $checkMain = User::where('id', $user->id)->count();
            // $checkSub = SubCard::where('user_id', $user->id)->where('active_card', true)->count();
            // $page_id = null;
            $community = collect();

            // if ($checkMain > 0) {
            //     $community = Button::where('user_id', $user->id)
            //         ->where('view', 'communities')
            //         ->whereNull('page_id')
            //         ->get();
            // }

            // if ($checkSub > 0) {
            //     $page_id = SubCard::where('user_id', $user->id)
            //         ->where('active_card', true)
            //         ->value('id');

            //     $community = Button::where('user_id', $user->id)
            //         ->where('view', 'communities')
            //         ->where('page_id', $page_id)
            //         ->get();
            // }

            $community = Button::where('user_id', $user->id)
                ->where('view', 'communities')
                ->where($condition)
                ->get();

            return (in_array($user->user_type, ['Basic', 'Sponsored', 'Influencer', 'Platinum', 'Gold']) || $user->is_admin)
                && $community->count() < 5;
        }

        return (
            $user->user_type == 'Free' &&
            ($button_count < 6 ||
                $user->buttons()->where('view', 'contacts')->count() < 3)
        ) || in_array($user->user_type, ['Basic', 'Gold', 'Platinum', 'Sponsored', 'Influencer']) || $user->is_admin;
    }

    public function update(User $user, Button $button): bool
    {
        return $this->create($user);
    }

    public function delete(User $user, Button $button): bool
    {
        return $this->create($user);
    }

    public function restore(User $user, Button $button): bool
    {
        return $this->create($user);
    }

    public function forceDelete(User $user, Button $button): bool
    {
        return $this->create($user);
    }
}
