<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Event;
use App\Models\SubCard;

class EventPolicy
{
    public $events;
    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;

    public function viewAny(User $user): bool
    {
        if ($user->is_admin) {
            return true;
        }

        // Return false for all other users
        return false;
    }

    public function view(User $user): bool
    {
        return in_array($user->user_type, ['Platinum', 'Gold', 'Basic']) || $user->is_admin == true;
    }

    public function create(User $user): bool
    {
        $this->checkMain = User::where('id', auth()->user()->id)->count();
        $this->checkSub = SubCard::where('user_id', auth()->user()->id)->where('active_card', true)->count();

        if ($this->checkMain > 0) {
            $this->events = Event::where('user_id', $user->id)->where('page_id', NULL)->get();
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->first();
            $this->events = Event::where('user_id', $user->id)->where('page_id', $this->page_id)->get();
        }

        return (($user->user_type == 'Platinum' ||
            $user->is_admin) && $this->events->count() < 20) ||
            $user->user_type == 'Gold' && $this->events->count() < 3 ||
            $user->user_type == 'Basic' && $this->events->count() < 1;
    }

    public function update(User $user): bool
    {
        return in_array($user->user_type, ['Platinum', 'Gold', 'Basic']) || $user->is_admin == true;
    }

    public function delete(User $user): bool
    {
        return in_array($user->user_type, ['Platinum', 'Gold', 'Basic']) || $user->is_admin == true;
    }

    public function restore(User $user, Event $event): bool
    {
        return in_array($user->user_type, ['Platinum', 'Gold', 'Basic']) || $user->is_admin == true;
    }

    public function forceDelete(User $user, Event $event): bool
    {
        return in_array($user->user_type, ['Platinum', 'Gold', 'Basic']) || $user->is_admin == true;
    }
}
