<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Sale;
use App\Models\SubCard;

class MemberPolicy
{
    public $sales;
    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;

    public function viewAny(User $user): bool
    {
        if ($user->is_admin) {
            return true;
        }

        // Return false for all other users
        return false;
    }

    public function view(User $user): bool
    {
        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }

    public function create(User $user): bool
    {
        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }

    public function update(User $user): bool
    {
        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }

    public function delete(User $user): bool
    {
        return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;
    }

    public function restore(User $user): bool
    {
        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }

    public function forceDelete(User $user): bool
    {
        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }
}
