<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Partnership;

class PartnershipPolicy
{
    public function viewAny(User $user): bool
    {
        if ($user->is_admin) {
            return true;
        }

        // Return false for all other users
        return false;
    }

    public function view(User $user): bool
    {
        return (in_array($user->user_type, ['Sponsored', 'Influencer', 'Gold', 'Platinum']) && $user->partnership_level != 'senior') || $user->is_admin == true;
    }
}
