<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Sale;
use App\Models\SubCard;

class SalePolicy
{
    public $sales;
    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;

    public function viewAny(User $user): bool
    {
        if ($user->is_admin) {
            return true;
        }

        // Return false for all other users
        return false;
    }

    public function view(User $user): bool
    {
        // return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
        // return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;

        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }

    public function create(User $user): bool
    {
        $this->checkMain = User::where('id', auth()->user()->id)->count();
        $this->checkSub = SubCard::where('user_id', auth()->user()->id)->where('active_card', true)->count();

        if ($this->checkMain > 0) {
            $this->sales = Sale::where('user_id', $user->id)->where('page_id', NULL)->get();
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->first();
            $this->sales = Sale::where('user_id', $user->id)->where('page_id', $this->page_id)->get();
        }

        return (($user->user_type == 'Platinum' ||
            $user->is_admin) && $this->sales->count() < 6) ||
            ($user->user_type == 'Gold' || $user->is_admin) && $this->sales->count() < 3;

        // return (($user->user_type == 'Platinum' && $user->active_card ||
        //     $user->is_admin) && $this->sales->count() < 6) ||
        //     ($user->user_type == 'Gold' && $user->active_card || $user->is_admin) && $this->sales->count() < 3;
    }

    public function update(User $user): bool
    {
        // return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;

        // return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;

        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }

    public function delete(User $user): bool
    {
        // return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
        return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;
    }

    public function restore(User $user): bool
    {
        // return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
        // return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;

        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }

    public function forceDelete(User $user): bool
    {
        // return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
        // return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;

        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }
}
