<?php

namespace App\Policies;

use App\Models\User;
use App\Models\SaleImage;

class SalesImagePolicy
{
    public $video;

    public function viewAny(User $user): bool
    {
        if ($user->is_admin) {
            return true;
        }

        // Return false for all other users
        return false;
    }

    public function view(User $user): bool
    {
        // return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;
        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }

    public function create(User $user): bool
    {
        $images = $user->sales()->with('sale_images')->get()
            ->pluck('sale_images')
            ->flatten();

        $imagesCount = $images->count();

        // return (in_array($user->user_type, ['Platinum', 'Gold'])
        // || $user->is_admin) && $imagesCount < 10;


        // return ((in_array($user->user_type, ['Platinum', 'Gold'])  && $user->active_card)
        //     || $user->is_admin) && $imagesCount < 10;

        return (in_array($user->user_type, ['Platinum', 'Gold'])
            || $user->is_admin) && $imagesCount < 10;
    }

    public function update(User $user): bool
    {
        // return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
        // return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;

        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }

    public function delete(User $user): bool
    {
        // return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
        // return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;

        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }

    public function restore(User $user): bool
    {
        // return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
        // return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;

        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }

    public function forceDelete(User $user): bool
    {
        // return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
        // return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;

        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }
}
