<?php

namespace App\Policies;

use App\Models\Video;
use App\Models\User;
use App\Models\SubCard;

class VideoPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public $videos;

    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;

    public function viewAny(User $user): bool
    {
        if ($user->is_admin) {
            return true;
        }

        // Return false for all other users
        return false;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user): bool
    {
        // Check if the user is platinum card holder before accessing the videos tab
        return in_array($user->user_type, ['Platinum', 'Sponsored', 'Influencer', 'Gold', 'Basic']) || $user->is_admin == true;
        // return in_array($user->user_type, ['Gold', 'Platinum']) || $user->is_admin == true;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        $this->checkMain = User::where('id', auth()->user()->id)->count();
        $this->checkSub = SubCard::where('user_id', auth()->user()->id)->where('active_card', true)->count();

        if ($this->checkMain > 0) {
            $this->videos = Video::where('user_id', $user->id)->where('page_id', NULL)->get();
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->first();
            $this->videos = Video::where('user_id', $user->id)->where('page_id', $this->page_id)->get();
        }

        return (($user->user_type == 'Platinum' ||
            $user->is_admin) && $this->videos->count() < 5) ||
            (in_array($user->user_type, ['Sponsored', 'Influencer', 'Gold', 'Basic']) && $this->videos->count() < 1);
        // return true;
    }

    /**
     * Determine whether the user can update the model.
     */
    // public function update(User $user, Video $video): bool
    public function update(User $user): bool
    {
        return in_array($user->user_type, ['Platinum', 'Sponsored', 'Gold', 'Basic']) || $user->is_admin == true;
    }

    /**
     * Determine whether the user can delete the model.
     */
    // public function delete(User $user, Video $video): bool
    public function delete(User $user): bool
    {
        return in_array($user->user_type, ['Platinum', 'Sponsored', 'Influencer', 'Gold', 'Basic']) || $user->is_admin == true;
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, Video $video): bool
    {
        return in_array($user->user_type, ['Platinum', 'Sponsored', 'Influencer', 'Gold', 'Basic']) || $user->is_admin == true;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, Video $video): bool
    {
        return in_array($user->user_type, ['Platinum', 'Sponsored', 'Influencer', 'Gold', 'Basic']) || $user->is_admin == true;
    }
}
