<?php

namespace App\Policies;

use App\Models\User;
use App\Settings\CardDefaultsSetting;

class ZoomReplayPolicy
{
    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;
    public $replays_functionality;

    public function __construct()
    {
        $this->replays_functionality = app(CardDefaultsSetting::class)->replays_functionality;
    }

    public function viewAny(User $user): bool
    {
        if ($user->is_admin) {
            return true;
        }

        // Return false for all other users
        return false;
    }

    public function view(User $user): bool
    {
        return (in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true) && $this->replays_functionality === true;
    }
}
