<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Auth\Notifications\VerifyEmail;
use Illuminate\Notifications\Messages\MailMessage;
use Laravel\Cashier\Events\WebhookReceived;
use Illuminate\Support\Facades\Event;
use Filament\Support\Colors\Color;
use Filament\Support\Facades\FilamentColor;

use App\Listeners\HandleSubscriptionEnded;
use App\Listeners\SyncUserSubscriptionType;
use App\Listeners\HandleCommissionAfterInvoice;

class AppServiceProvider extends ServiceProvider
{

    public function register(): void
    {
        //
    }

    public function boot(): void
    {
        FilamentColor::register([
            'indigo' => Color::Indigo,
            'influencer' => Color::hex('#f368e0'),
        ]);

        Event::listen(WebhookReceived::class, HandleSubscriptionEnded::class);
        Event::listen(WebhookReceived::class, SyncUserSubscriptionType::class);
        Event::listen(WebhookReceived::class, HandleCommissionAfterInvoice::class);

        VerifyEmail::toMailUsing(function (object $notifiable, string $url) {
            return (new MailMessage)
                ->subject('Verify Email Address')
                ->line('Click the button below to verify your email address.')
                ->action('Verify Email Address', $url);
        });
    }
}
