<?php

namespace App\Providers;

// use Illuminate\Support\ServiceProvider;

use App\Models\Ad;
use App\Models\Analytics;
use App\Models\Button;
use App\Models\Product;
use App\Models\Service;
use App\Models\Social;
use App\Models\Video;
use App\Models\SubCard;
use App\Models\Image;
use App\Models\User;
use App\Models\Event;
use App\Models\Replay;
use App\Models\Sale;
use App\Models\SaleVideo;
use App\Models\SaleImage;
use App\Models\TrustedNetwork;
use App\Models\LeadCaptureForm;

use App\Policies\SalePolicy;
use App\Policies\SalesVideoPolicy;
use App\Policies\SalesImagePolicy;
use App\Policies\ButtonPolicy;
use App\Policies\ProductPolicy;
use App\Policies\ServicePolicy;
use App\Policies\SocialPolicy;
use App\Policies\VideoPolicy;
use App\Policies\AddNewPagesPolicy;
use App\Policies\AdPolicy;
use App\Policies\AnalyticsPolicy;
use App\Policies\ImagePolicy;
use App\Policies\SubscriptionPolicy;
use App\Policies\EventPolicy;
use App\Policies\TrustedNetworkPolicy;
use App\Policies\ZoomReplayPolicy;
use App\Policies\LeadCaptureFormPolicy;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    protected $policies = [
        Sale::class => SalePolicy::class,
        SaleVideo::class => SalesVideoPolicy::class,
        SaleImage::class => SalesImagePolicy::class,
        Event::class => EventPolicy::class,
        Product::class => ProductPolicy::class,
        Service::class => ServicePolicy::class,
        User::class => SubscriptionPolicy::class,
        Video::class => VideoPolicy::class,
        Button::class => ButtonPolicy::class,
        Social::class => SocialPolicy::class,
        SubCard::class => AddNewPagesPolicy::class,
        Analytics::class => AnalyticsPolicy::class,
        Ad::class => AdPolicy::class,
        Image::class => ImagePolicy::class,
        TrustedNetwork::class => TrustedNetworkPolicy::class,
        Replay::class => ZoomReplayPolicy::class,
        LeadCaptureForm::class => LeadCaptureFormPolicy::class
    ];
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        $this->registerPolicies();
    }
}
