<?php

namespace App\Settings;

use Spatie\LaravelSettings\Settings;

class CardDefaultsSetting extends Settings
{
    //Site defaults
    public ?string $app_name = "10kcards";
    public ?string $site_name = "10k Cards";
    public ?string $site_url = "https://10kcards.site/";
    public ?string $site_button_color = "#facc15";
    public ?string $site_button_text_color = "#000000";
    public ?string $site_link_color = "#ca8a04";
    public ?string $site_slogan = "Connect Smarter, Not Harder.";
    public ?string $site_slogan_color_1 = "#133a9d";
    public ?string $site_slogan_color_2 = "#D91656";
    public ?string $site_desc = "The modern approach to business cards. Leave a lasting impression on your clients with the new way to present yourself.";

    public string $thumbnail = '/img/default-thumbnail.jpg';
    public string $logo = '/img/10kcards-black-logo.webp';
    public string $mockup = '/img/mockup.png';

    // Footer Defaults
    public ?string $footer_text = "Get your 10kcards today!";
    public ?string $footer_link = "https://10kcards.com";

    // Account Defaults
    public ?string $default_password = "10kcards123";

    // maintenance
    public ?bool $maintenance_mode = false;

    // Legal & Compliance
    public ?string $privacy_policy = "";
    public ?string $cookie_consent = "";
    public ?string $terms_conditions = "";
    //images dimension defaults

    //profile ficture dimension
    public ?string $profile_picture_dimension = "512";

    //ad banner
    public ?int $ad_banner_w = 2020;
    public ?int $ad_banner_h = 300;

    public $test_mode;

    // test mode
    public $test_basic_monthly;
    public $test_basic_yearly;

    public $test_gold_monthly;
    public $test_gold_yearly;

    public $test_platinum_monthly;
    public $test_platinum_yearly;

    // live mode
    public $live_basic_monthly;
    public $live_basic_yearly;

    public $live_gold_monthly;
    public $live_gold_yearly;

    public $live_platinum_monthly;
    public $live_platinum_yearly;

    //manual capture link
    public $manual_basic_card_link;
    public $manual_basic_card_monthly_link;

    public $manual_gold_card_link;
    public $manual_gold_card_monthly_link;

    public $manual_platinum_card_link;
    public $manual_platinum_card_monthly_link;

    //for computation;
    public $price_basic_monthly = 10;
    public $price_basic_yearly = 100;

    public $price_gold_monthly = 30;
    public $price_gold_yearly = 300;

    public $price_platinum_monthly = 60;
    public $price_platinum_yearly = 600;

    //membership
    public ?bool $free_trial_enabled = true;
    public int $free_trial_duration = 7;
    public ?bool $platinum_enabled = true;
    public ?bool $influencer_enabled = true;
    public ?bool $sponsored_enabled = true;

    //terminologies
    public ?string $term_basic = "Basic";
    public ?string $term_gold = "Gold";
    public ?string $term_platinum = "Platinum";

    // Description/Tiers
    public $term_description_basic;
    public $term_description_gold;
    public $term_description_platinum;

    // PARTNERSHIP
    //manual capture link
    public $manual_junior_partnership_link;
    public $manual_senior_partnership_link;

    // Description/Tiers
    public $term_description_junior_partner;
    public $term_description_senior_partner;

    // menu
    public ?bool $menu_enabled = false;
    public ?string $menu_position_position = 'left';
    public ?array $menu_items = [];

    // menu
    public ?bool $landing_page_menu_enabled = false;
    public ?string $landing_page_menu_position = 'left';
    public ?array $landing_page_menu_items = [];

    //card default contents
    public ?array $community_links = [];

    public ?bool $default_ads_enabled = false;
    public ?string $ads_heading = "";
    public ?string $ads_description = "";
    public ?array $ad_items = [];

    // site functionality
    public ?bool $affiliate_functionality = true;
    public ?bool $replays_functionality = false;
    public ?bool $reviews_functionality = false;
    public ?bool $manual_capture_mode = false;
    public ?bool $manual_capture_mode_annual_only = false;

    // Admin SMS notification
    public ?bool $admin_sms_notification = false;
    public ?string $admin_sms_number = '+19344446611';

    // Admin SMS notification
    public ?bool $admin_whatsapp_notification = false;
    public ?string $admin_whatsapp_number = '+19344446611';

    // Admin email notification
    public ?bool $admin_email_notification = false;
    public ?string $admin_email = 'gbrasileno99@gmail.com,MelizaL@icloud.com,CEOSean@outlook.com,SDL2005@icloud.com';
    public ?string $sender_email = 'noreply@10kcards.site';

    public static function group(): string
    {
        return 'default';
    }
}
