<?php

use App\Http\Middleware\CheckActiveUser;
use App\Http\Middleware\CheckUserAffiliate;
use App\Http\Middleware\CheckIfMaintenance;
use App\Http\Middleware\CanManageNetwork;
use App\Http\Middleware\CheckIfAdmin;
use App\Http\Middleware\checkIfVerified;
use App\Http\Middleware\CheckIfUserHaveUserType;

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'is_admin' => CheckIfAdmin::class,
            'have_user_type' => CheckIfUserHaveUserType::class,
            'verified' => checkIfVerified::class,
            'maintenance' => CheckIfMaintenance::class,
            'is_active' => CheckActiveUser::class,
            'is_footer' => CheckUserAffiliate::class,
            'can_manage_network' => CanManageNetwork::class,

        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
