<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('name');
            $table->dropColumn('email');

            $table->string('username')->unique();
            $table->string('firstname')->nullable();
            $table->string('lastname')->nullable();
            $table->string('phone')->nullable();
            $table->enum('gender', ['Male', 'Female'])->nullable();
            $table->string('email')->unique()->nullable();
            $table->string('profile_pic')->nullable();
            $table->string('cover_pic')->nullable();
            $table->string('company_pic')->nullable();
            $table->string('job_title')->nullable();
            $table->text('bio')->nullable();
            $table->text('bio_long')->nullable();
            $table->string('company')->nullable();
            $table->string('company_website')->nullable();
            $table->string('language')->nullable();
            $table->string('address')->nullable();
            $table->string('country')->nullable();
            $table->enum('user_type', ['Free', 'Basic', 'Gold', 'Platinum', 'Sponsored'])->nullable();
            $table->boolean('is_active')->default(true);
            $table->boolean('is_admin')->default(false);
            $table->boolean('active_card')->default(true);
            $table->enum('access', ['Trial', 'Lifetime'])
                ->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            //
        });
    }
};
