<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('socials', function (Blueprint $table) {
            $table->id();
            $table->string('link');
            $table->enum('type', ['facebook', 'x', 'linkedin', 'instagram', 'tiktok', 'youtube', 'clubhouse', 'threads', 'fanbase', 'snapchat', 'pinterest'])->default('facebook');
            // $table->foreignId('user_id')->constraint('user_id')->onDelete('cascade'); // owner
            $table->unsignedBigInteger('user_id')->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade'); // owner
            $table->integer('order')->nullable();
            $table->boolean('is_active')->default(true);
            // $table->unsignedBigInteger('page_id')->nullable();
            // $table->foreign('page_id')->references('id')->on('subcards')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('socials');
    }
};
