<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            // $table->foreignId('user_id')->constraint('user_id')->onDelete('cascade'); // owner
            $table->unsignedBigInteger('user_id')->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade'); // owner
            $table->string('title');
            $table->text('description');
            $table->decimal('price', 10, 2);
            $table->string('payment_link');
            $table->string('product_image')->nullable();
            $table->integer('order')->nullable(); //new
            $table->boolean('is_active')->default(true); //new
            // $table->unsignedBigInteger('page_id')->nullable();
            // $table->foreign('page_id')->references('id')->on('subcards')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
