<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ads', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable()->default(null);
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            // $table->unsignedBigInteger('sponsor_id')->nullable();
            // $table->foreign('sponsor_id')->references('id')->on('sponsors')->onDelete('cascade');
            $table->string('image');
            $table->string('link');
            $table->string('caption')->nullable();
            $table->enum('position', ['top', 'bottom'])->default('top');
            $table->enum('display_in', ['Free', 'Sponsored'])->nullable();
            $table->integer('order')->default(0);
            $table->unsignedBigInteger('page_id')->nullable();
            $table->foreign('page_id')->references('id')->on('subcards')->onDelete('cascade');
            $table->boolean('is_active')->default(true);
            $table->boolean('is_admin')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ads');
    }
};
