<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('socials', function (Blueprint $table) {
            $table->text('link')->change();
            $table->unsignedBigInteger('page_id')->nullable();
            $table->foreign('page_id')->references('id')->on('subcards')->onDelete('cascade');
        });

        // 1. Rename old column
        // Schema::table('socials', function (Blueprint $table) {
        //     $table->renameColumn('page_id', 'old_page_id');
        // });

        // 2. Add the new column WITHOUT the foreign key yet
        // Schema::table('socials', function (Blueprint $table) {
        //     $table->unsignedBigInteger('page_id')->nullable();
        // });

        // 3. Migrate valid data only — avoid integrity errors
        // DB::table('socials')
        //     ->whereIn('old_page_id', function ($query) {
        //         $query->select('id')->from('subcards');
        //     })
        //     ->update([
        //         'page_id' => DB::raw('old_page_id')
        //     ]);

        // 4. Now safely add the foreign key constraint
        // Schema::table('socials', function (Blueprint $table) {
        //     $table->foreign('page_id')->references('id')->on('subcards')->onDelete('cascade');
        // });

        // 5. Optional: drop old_page_id column
        // Schema::table('socials', function (Blueprint $table) {
        //     $table->dropColumn('old_page_id');
        // });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
