<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('referrals', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('referrer_id_main')->nullable();
            $table->unsignedBigInteger('referrer_id_sub')->nullable();
            $table->unsignedBigInteger('referred_id');

            $table->foreign('referrer_id_main')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('referrer_id_sub')->references('id')->on('subcards')->onDelete('cascade');
            $table->foreign('referred_id')->references('id')->on('users')->onDelete('cascade');

            $table->enum('referrer_type', ['main', 'sub'])->default('main');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
