<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('commissions', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('page_id')->nullable();

            $table->foreign('user_id')->references('id')->on('users');
            $table->foreign('page_id')->references('id')->on('subcards');

            $table->unsignedBigInteger('referred_id');
            $table->foreign('referred_id')->references('id')->on('users')->onDelete('cascade');

            $table->string('stripe_invoice_id');
            $table->decimal('commission_rate', 5, 2); // e.g. 10.00, 25.00, 50.00
            $table->decimal('amount', 10, 2); // commission earned
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('commissions');
    }
};
