<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        DB::table('users')
            ->whereNull('partnership_level')
            ->whereIn('user_type', ['Gold', 'Platinum'])
            ->update(['partnership_level' => 'default']);
    }

    public function down(): void
    {
        // Optional rollback logic: revert the update
        DB::table('users')
            ->where('partnership_level', 'default')
            ->whereIn('user_type', ['Gold', 'Platinum'])
            ->update(['partnership_level' => null]);
    }
};
