<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->renameColumn('title', 'product_name');
            $table->renameColumn('payment_link', 'shop_online_link');
            $table->renameColumn('product_image', 'featured_image');
            $table->string('shop_online_button')->nullable();
            $table->integer('stock');
            $table->unsignedBigInteger('user_id')->nullable()->change();
            $table->text('description')->nullable()->change();
        });

        Schema::create('products_media', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')
                ->nullable()
                ->constrained('products')
                ->cascadeOnDelete();
            $table->enum('type', ['image', 'video']);
            $table->string('path');
            $table->integer('order')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->index(['product_id', 'order']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {}
};
