<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {

        Schema::create('product_categories', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('page_id')->nullable();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('page_id')->references('id')->on('subcards')->onDelete('cascade');
            $table->string('title');
            $table->text('description')->nullable();

            $table->integer('order')->nullable();
            $table->boolean('is_active')->default(true);

            $table->timestamps();
        });

        Schema::table('products', function (Blueprint $table) {
            // $table->foreignId('category_id')->nullable()->constrained()->nullOnDelete();

            $table->unsignedBigInteger('category_id')->nullable();

            $table->foreign('category_id')
                ->references('id')
                ->on('product_categories')
                ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_category');
    }
};
