<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Product;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {

            // Drop foreign keys first
            $table->dropForeign(['collection_id']);
            $table->dropForeign(['category_id']);

            $table->json('collection_id')->nullable()->change();
            $table->json('category_id')->nullable()->change();
        });

        Product::query()->chunk(100, function ($products) {
            foreach ($products as $product) {
                // Decode in case it's already JSON
                $collection = json_decode($product->collection_id, true);
                $category = json_decode($product->category_id, true);

                if (!is_array($collection)) {
                    $product->collection_id = [$product->collection_id];
                }

                if (!is_array($category)) {
                    $product->category_id = [$product->category_id];
                }

                $product->save();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
