import {
  __commonJS
} from "./chunk-HKJ2B2AA.js";

// node_modules/tinymce/tinymce.js
var require_tinymce = __commonJS({
  "node_modules/tinymce/tinymce.js"(exports, module) {
    (function() {
      "use strict";
      var typeOf$1 = function(x) {
        if (x === null) {
          return "null";
        }
        if (x === void 0) {
          return "undefined";
        }
        var t = typeof x;
        if (t === "object" && (Array.prototype.isPrototypeOf(x) || x.constructor && x.constructor.name === "Array")) {
          return "array";
        }
        if (t === "object" && (String.prototype.isPrototypeOf(x) || x.constructor && x.constructor.name === "String")) {
          return "string";
        }
        return t;
      };
      var isEquatableType = function(x) {
        return [
          "undefined",
          "boolean",
          "number",
          "string",
          "function",
          "xml",
          "null"
        ].indexOf(x) !== -1;
      };
      var sort$1 = function(xs, compareFn) {
        var clone2 = Array.prototype.slice.call(xs);
        return clone2.sort(compareFn);
      };
      var contramap = function(eqa, f) {
        return eq$2(function(x, y) {
          return eqa.eq(f(x), f(y));
        });
      };
      var eq$2 = function(f) {
        return { eq: f };
      };
      var tripleEq = eq$2(function(x, y) {
        return x === y;
      });
      var eqString = tripleEq;
      var eqArray = function(eqa) {
        return eq$2(function(x, y) {
          if (x.length !== y.length) {
            return false;
          }
          var len = x.length;
          for (var i = 0; i < len; i++) {
            if (!eqa.eq(x[i], y[i])) {
              return false;
            }
          }
          return true;
        });
      };
      var eqSortedArray = function(eqa, compareFn) {
        return contramap(eqArray(eqa), function(xs) {
          return sort$1(xs, compareFn);
        });
      };
      var eqRecord = function(eqa) {
        return eq$2(function(x, y) {
          var kx = Object.keys(x);
          var ky = Object.keys(y);
          if (!eqSortedArray(eqString).eq(kx, ky)) {
            return false;
          }
          var len = kx.length;
          for (var i = 0; i < len; i++) {
            var q = kx[i];
            if (!eqa.eq(x[q], y[q])) {
              return false;
            }
          }
          return true;
        });
      };
      var eqAny = eq$2(function(x, y) {
        if (x === y) {
          return true;
        }
        var tx = typeOf$1(x);
        var ty = typeOf$1(y);
        if (tx !== ty) {
          return false;
        }
        if (isEquatableType(tx)) {
          return x === y;
        } else if (tx === "array") {
          return eqArray(eqAny).eq(x, y);
        } else if (tx === "object") {
          return eqRecord(eqAny).eq(x, y);
        }
        return false;
      });
      const getPrototypeOf$2 = Object.getPrototypeOf;
      const hasProto = (v, constructor, predicate) => {
        var _a;
        if (predicate(v, constructor.prototype)) {
          return true;
        } else {
          return ((_a = v.constructor) === null || _a === void 0 ? void 0 : _a.name) === constructor.name;
        }
      };
      const typeOf = (x) => {
        const t = typeof x;
        if (x === null) {
          return "null";
        } else if (t === "object" && Array.isArray(x)) {
          return "array";
        } else if (t === "object" && hasProto(x, String, (o, proto) => proto.isPrototypeOf(o))) {
          return "string";
        } else {
          return t;
        }
      };
      const isType$1 = (type2) => (value2) => typeOf(value2) === type2;
      const isSimpleType = (type2) => (value2) => typeof value2 === type2;
      const eq$1 = (t) => (a) => t === a;
      const is$4 = (value2, constructor) => isObject(value2) && hasProto(value2, constructor, (o, proto) => getPrototypeOf$2(o) === proto);
      const isString = isType$1("string");
      const isObject = isType$1("object");
      const isPlainObject = (value2) => is$4(value2, Object);
      const isArray$1 = isType$1("array");
      const isNull = eq$1(null);
      const isBoolean = isSimpleType("boolean");
      const isUndefined = eq$1(void 0);
      const isNullable = (a) => a === null || a === void 0;
      const isNonNullable = (a) => !isNullable(a);
      const isFunction = isSimpleType("function");
      const isNumber = isSimpleType("number");
      const isArrayOf = (value2, pred) => {
        if (isArray$1(value2)) {
          for (let i = 0, len = value2.length; i < len; ++i) {
            if (!pred(value2[i])) {
              return false;
            }
          }
          return true;
        }
        return false;
      };
      const noop = () => {
      };
      const compose = (fa, fb) => {
        return (...args) => {
          return fa(fb.apply(null, args));
        };
      };
      const compose1 = (fbc, fab) => (a) => fbc(fab(a));
      const constant = (value2) => {
        return () => {
          return value2;
        };
      };
      const identity = (x) => {
        return x;
      };
      const tripleEquals = (a, b) => {
        return a === b;
      };
      function curry(fn, ...initialArgs) {
        return (...restArgs) => {
          const all2 = initialArgs.concat(restArgs);
          return fn.apply(null, all2);
        };
      }
      const not = (f) => (t) => !f(t);
      const die = (msg) => {
        return () => {
          throw new Error(msg);
        };
      };
      const apply$1 = (f) => {
        return f();
      };
      const call = (f) => {
        f();
      };
      const never = constant(false);
      const always = constant(true);
      class Optional {
        constructor(tag, value2) {
          this.tag = tag;
          this.value = value2;
        }
        static some(value2) {
          return new Optional(true, value2);
        }
        static none() {
          return Optional.singletonNone;
        }
        fold(onNone, onSome) {
          if (this.tag) {
            return onSome(this.value);
          } else {
            return onNone();
          }
        }
        isSome() {
          return this.tag;
        }
        isNone() {
          return !this.tag;
        }
        map(mapper) {
          if (this.tag) {
            return Optional.some(mapper(this.value));
          } else {
            return Optional.none();
          }
        }
        bind(binder2) {
          if (this.tag) {
            return binder2(this.value);
          } else {
            return Optional.none();
          }
        }
        exists(predicate) {
          return this.tag && predicate(this.value);
        }
        forall(predicate) {
          return !this.tag || predicate(this.value);
        }
        filter(predicate) {
          if (!this.tag || predicate(this.value)) {
            return this;
          } else {
            return Optional.none();
          }
        }
        getOr(replacement) {
          return this.tag ? this.value : replacement;
        }
        or(replacement) {
          return this.tag ? this : replacement;
        }
        getOrThunk(thunk) {
          return this.tag ? this.value : thunk();
        }
        orThunk(thunk) {
          return this.tag ? this : thunk();
        }
        getOrDie(message) {
          if (!this.tag) {
            throw new Error(message !== null && message !== void 0 ? message : "Called getOrDie on None");
          } else {
            return this.value;
          }
        }
        static from(value2) {
          return isNonNullable(value2) ? Optional.some(value2) : Optional.none();
        }
        getOrNull() {
          return this.tag ? this.value : null;
        }
        getOrUndefined() {
          return this.value;
        }
        each(worker) {
          if (this.tag) {
            worker(this.value);
          }
        }
        toArray() {
          return this.tag ? [this.value] : [];
        }
        toString() {
          return this.tag ? `some(${this.value})` : "none()";
        }
      }
      Optional.singletonNone = new Optional(false);
      const nativeSlice = Array.prototype.slice;
      const nativeIndexOf = Array.prototype.indexOf;
      const nativePush = Array.prototype.push;
      const rawIndexOf = (ts, t) => nativeIndexOf.call(ts, t);
      const indexOf$1 = (xs, x) => {
        const r2 = rawIndexOf(xs, x);
        return r2 === -1 ? Optional.none() : Optional.some(r2);
      };
      const contains$2 = (xs, x) => rawIndexOf(xs, x) > -1;
      const exists = (xs, pred) => {
        for (let i = 0, len = xs.length; i < len; i++) {
          const x = xs[i];
          if (pred(x, i)) {
            return true;
          }
        }
        return false;
      };
      const map$3 = (xs, f) => {
        const len = xs.length;
        const r2 = new Array(len);
        for (let i = 0; i < len; i++) {
          const x = xs[i];
          r2[i] = f(x, i);
        }
        return r2;
      };
      const each$e = (xs, f) => {
        for (let i = 0, len = xs.length; i < len; i++) {
          const x = xs[i];
          f(x, i);
        }
      };
      const eachr = (xs, f) => {
        for (let i = xs.length - 1; i >= 0; i--) {
          const x = xs[i];
          f(x, i);
        }
      };
      const partition$2 = (xs, pred) => {
        const pass = [];
        const fail = [];
        for (let i = 0, len = xs.length; i < len; i++) {
          const x = xs[i];
          const arr = pred(x, i) ? pass : fail;
          arr.push(x);
        }
        return {
          pass,
          fail
        };
      };
      const filter$5 = (xs, pred) => {
        const r2 = [];
        for (let i = 0, len = xs.length; i < len; i++) {
          const x = xs[i];
          if (pred(x, i)) {
            r2.push(x);
          }
        }
        return r2;
      };
      const foldr = (xs, f, acc) => {
        eachr(xs, (x, i) => {
          acc = f(acc, x, i);
        });
        return acc;
      };
      const foldl = (xs, f, acc) => {
        each$e(xs, (x, i) => {
          acc = f(acc, x, i);
        });
        return acc;
      };
      const findUntil$1 = (xs, pred, until) => {
        for (let i = 0, len = xs.length; i < len; i++) {
          const x = xs[i];
          if (pred(x, i)) {
            return Optional.some(x);
          } else if (until(x, i)) {
            break;
          }
        }
        return Optional.none();
      };
      const find$2 = (xs, pred) => {
        return findUntil$1(xs, pred, never);
      };
      const findIndex$2 = (xs, pred) => {
        for (let i = 0, len = xs.length; i < len; i++) {
          const x = xs[i];
          if (pred(x, i)) {
            return Optional.some(i);
          }
        }
        return Optional.none();
      };
      const flatten = (xs) => {
        const r2 = [];
        for (let i = 0, len = xs.length; i < len; ++i) {
          if (!isArray$1(xs[i])) {
            throw new Error("Arr.flatten item " + i + " was not an array, input: " + xs);
          }
          nativePush.apply(r2, xs[i]);
        }
        return r2;
      };
      const bind$3 = (xs, f) => flatten(map$3(xs, f));
      const forall = (xs, pred) => {
        for (let i = 0, len = xs.length; i < len; ++i) {
          const x = xs[i];
          if (pred(x, i) !== true) {
            return false;
          }
        }
        return true;
      };
      const reverse = (xs) => {
        const r2 = nativeSlice.call(xs, 0);
        r2.reverse();
        return r2;
      };
      const difference = (a1, a2) => filter$5(a1, (x) => !contains$2(a2, x));
      const mapToObject = (xs, f) => {
        const r2 = {};
        for (let i = 0, len = xs.length; i < len; i++) {
          const x = xs[i];
          r2[String(x)] = f(x, i);
        }
        return r2;
      };
      const sort = (xs, comparator) => {
        const copy2 = nativeSlice.call(xs, 0);
        copy2.sort(comparator);
        return copy2;
      };
      const get$b = (xs, i) => i >= 0 && i < xs.length ? Optional.some(xs[i]) : Optional.none();
      const head = (xs) => get$b(xs, 0);
      const last$2 = (xs) => get$b(xs, xs.length - 1);
      const from = isFunction(Array.from) ? Array.from : (x) => nativeSlice.call(x);
      const findMap = (arr, f) => {
        for (let i = 0; i < arr.length; i++) {
          const r2 = f(arr[i], i);
          if (r2.isSome()) {
            return r2;
          }
        }
        return Optional.none();
      };
      const unique$1 = (xs, comparator) => {
        const r2 = [];
        const isDuplicated2 = isFunction(comparator) ? (x) => exists(r2, (i) => comparator(i, x)) : (x) => contains$2(r2, x);
        for (let i = 0, len = xs.length; i < len; i++) {
          const x = xs[i];
          if (!isDuplicated2(x)) {
            r2.push(x);
          }
        }
        return r2;
      };
      const keys = Object.keys;
      const hasOwnProperty$1 = Object.hasOwnProperty;
      const each$d = (obj, f) => {
        const props = keys(obj);
        for (let k = 0, len = props.length; k < len; k++) {
          const i = props[k];
          const x = obj[i];
          f(x, i);
        }
      };
      const map$2 = (obj, f) => {
        return tupleMap(obj, (x, i) => ({
          k: i,
          v: f(x, i)
        }));
      };
      const tupleMap = (obj, f) => {
        const r2 = {};
        each$d(obj, (x, i) => {
          const tuple = f(x, i);
          r2[tuple.k] = tuple.v;
        });
        return r2;
      };
      const objAcc = (r2) => (x, i) => {
        r2[i] = x;
      };
      const internalFilter = (obj, pred, onTrue, onFalse) => {
        each$d(obj, (x, i) => {
          (pred(x, i) ? onTrue : onFalse)(x, i);
        });
      };
      const bifilter = (obj, pred) => {
        const t = {};
        const f = {};
        internalFilter(obj, pred, objAcc(t), objAcc(f));
        return {
          t,
          f
        };
      };
      const filter$4 = (obj, pred) => {
        const t = {};
        internalFilter(obj, pred, objAcc(t), noop);
        return t;
      };
      const mapToArray = (obj, f) => {
        const r2 = [];
        each$d(obj, (value2, name2) => {
          r2.push(f(value2, name2));
        });
        return r2;
      };
      const values = (obj) => {
        return mapToArray(obj, identity);
      };
      const get$a = (obj, key) => {
        return has$2(obj, key) ? Optional.from(obj[key]) : Optional.none();
      };
      const has$2 = (obj, key) => hasOwnProperty$1.call(obj, key);
      const hasNonNullableKey = (obj, key) => has$2(obj, key) && obj[key] !== void 0 && obj[key] !== null;
      const equal$1 = (a1, a2, eq2 = eqAny) => eqRecord(eq2).eq(a1, a2);
      const stringArray = (a) => {
        const all2 = {};
        each$e(a, (key) => {
          all2[key] = {};
        });
        return keys(all2);
      };
      const isArrayLike = (o) => o.length !== void 0;
      const isArray = Array.isArray;
      const toArray$1 = (obj) => {
        if (!isArray(obj)) {
          const array = [];
          for (let i = 0, l = obj.length; i < l; i++) {
            array[i] = obj[i];
          }
          return array;
        } else {
          return obj;
        }
      };
      const each$c = (o, cb, s) => {
        if (!o) {
          return false;
        }
        s = s || o;
        if (isArrayLike(o)) {
          for (let n = 0, l = o.length; n < l; n++) {
            if (cb.call(s, o[n], n, o) === false) {
              return false;
            }
          }
        } else {
          for (const n in o) {
            if (has$2(o, n)) {
              if (cb.call(s, o[n], n, o) === false) {
                return false;
              }
            }
          }
        }
        return true;
      };
      const map$1 = (array, callback) => {
        const out = [];
        each$c(array, (item, index) => {
          out.push(callback(item, index, array));
        });
        return out;
      };
      const filter$3 = (a, f) => {
        const o = [];
        each$c(a, (v, index) => {
          if (!f || f(v, index, a)) {
            o.push(v);
          }
        });
        return o;
      };
      const indexOf = (a, v) => {
        if (a) {
          for (let i = 0, l = a.length; i < l; i++) {
            if (a[i] === v) {
              return i;
            }
          }
        }
        return -1;
      };
      const reduce = (collection, iteratee, accumulator, thisArg) => {
        let acc = isUndefined(accumulator) ? collection[0] : accumulator;
        for (let i = 0; i < collection.length; i++) {
          acc = iteratee.call(thisArg, acc, collection[i], i);
        }
        return acc;
      };
      const findIndex$1 = (array, predicate, thisArg) => {
        for (let i = 0, l = array.length; i < l; i++) {
          if (predicate.call(thisArg, array[i], i, array)) {
            return i;
          }
        }
        return -1;
      };
      const last$1 = (collection) => collection[collection.length - 1];
      const cached = (f) => {
        let called = false;
        let r2;
        return (...args) => {
          if (!called) {
            called = true;
            r2 = f.apply(null, args);
          }
          return r2;
        };
      };
      const DeviceType = (os2, browser2, userAgent2, mediaMatch2) => {
        const isiPad = os2.isiOS() && /ipad/i.test(userAgent2) === true;
        const isiPhone = os2.isiOS() && !isiPad;
        const isMobile = os2.isiOS() || os2.isAndroid();
        const isTouch2 = isMobile || mediaMatch2("(pointer:coarse)");
        const isTablet2 = isiPad || !isiPhone && isMobile && mediaMatch2("(min-device-width:768px)");
        const isPhone2 = isiPhone || isMobile && !isTablet2;
        const iOSwebview = browser2.isSafari() && os2.isiOS() && /safari/i.test(userAgent2) === false;
        const isDesktop = !isPhone2 && !isTablet2 && !iOSwebview;
        return {
          isiPad: constant(isiPad),
          isiPhone: constant(isiPhone),
          isTablet: constant(isTablet2),
          isPhone: constant(isPhone2),
          isTouch: constant(isTouch2),
          isAndroid: os2.isAndroid,
          isiOS: os2.isiOS,
          isWebView: constant(iOSwebview),
          isDesktop: constant(isDesktop)
        };
      };
      const firstMatch = (regexes, s) => {
        for (let i = 0; i < regexes.length; i++) {
          const x = regexes[i];
          if (x.test(s)) {
            return x;
          }
        }
        return void 0;
      };
      const find$1 = (regexes, agent) => {
        const r2 = firstMatch(regexes, agent);
        if (!r2) {
          return {
            major: 0,
            minor: 0
          };
        }
        const group = (i) => {
          return Number(agent.replace(r2, "$" + i));
        };
        return nu$3(group(1), group(2));
      };
      const detect$4 = (versionRegexes, agent) => {
        const cleanedAgent = String(agent).toLowerCase();
        if (versionRegexes.length === 0) {
          return unknown$2();
        }
        return find$1(versionRegexes, cleanedAgent);
      };
      const unknown$2 = () => {
        return nu$3(0, 0);
      };
      const nu$3 = (major, minor) => {
        return {
          major,
          minor
        };
      };
      const Version = {
        nu: nu$3,
        detect: detect$4,
        unknown: unknown$2
      };
      const detectBrowser$1 = (browsers2, userAgentData) => {
        return findMap(userAgentData.brands, (uaBrand) => {
          const lcBrand = uaBrand.brand.toLowerCase();
          return find$2(browsers2, (browser2) => {
            var _a;
            return lcBrand === ((_a = browser2.brand) === null || _a === void 0 ? void 0 : _a.toLowerCase());
          }).map((info) => ({
            current: info.name,
            version: Version.nu(parseInt(uaBrand.version, 10), 0)
          }));
        });
      };
      const detect$3 = (candidates, userAgent2) => {
        const agent = String(userAgent2).toLowerCase();
        return find$2(candidates, (candidate) => {
          return candidate.search(agent);
        });
      };
      const detectBrowser = (browsers2, userAgent2) => {
        return detect$3(browsers2, userAgent2).map((browser2) => {
          const version = Version.detect(browser2.versionRegexes, userAgent2);
          return {
            current: browser2.name,
            version
          };
        });
      };
      const detectOs = (oses2, userAgent2) => {
        return detect$3(oses2, userAgent2).map((os2) => {
          const version = Version.detect(os2.versionRegexes, userAgent2);
          return {
            current: os2.name,
            version
          };
        });
      };
      const removeFromStart = (str, numChars) => {
        return str.substring(numChars);
      };
      const checkRange = (str, substr, start2) => substr === "" || str.length >= substr.length && str.substr(start2, start2 + substr.length) === substr;
      const removeLeading = (str, prefix) => {
        return startsWith(str, prefix) ? removeFromStart(str, prefix.length) : str;
      };
      const contains$1 = (str, substr, start2 = 0, end2) => {
        const idx = str.indexOf(substr, start2);
        if (idx !== -1) {
          return isUndefined(end2) ? true : idx + substr.length <= end2;
        } else {
          return false;
        }
      };
      const startsWith = (str, prefix) => {
        return checkRange(str, prefix, 0);
      };
      const endsWith = (str, suffix) => {
        return checkRange(str, suffix, str.length - suffix.length);
      };
      const blank = (r2) => (s) => s.replace(r2, "");
      const trim$4 = blank(/^\s+|\s+$/g);
      const lTrim = blank(/^\s+/g);
      const rTrim = blank(/\s+$/g);
      const isNotEmpty = (s) => s.length > 0;
      const isEmpty$3 = (s) => !isNotEmpty(s);
      const repeat = (s, count2) => count2 <= 0 ? "" : new Array(count2 + 1).join(s);
      const toInt = (value2, radix = 10) => {
        const num = parseInt(value2, radix);
        return isNaN(num) ? Optional.none() : Optional.some(num);
      };
      const normalVersionRegex = /.*?version\/\ ?([0-9]+)\.([0-9]+).*/;
      const checkContains = (target) => {
        return (uastring) => {
          return contains$1(uastring, target);
        };
      };
      const browsers = [
        {
          name: "Edge",
          versionRegexes: [/.*?edge\/ ?([0-9]+)\.([0-9]+)$/],
          search: (uastring) => {
            return contains$1(uastring, "edge/") && contains$1(uastring, "chrome") && contains$1(uastring, "safari") && contains$1(uastring, "applewebkit");
          }
        },
        {
          name: "Chromium",
          brand: "Chromium",
          versionRegexes: [
            /.*?chrome\/([0-9]+)\.([0-9]+).*/,
            normalVersionRegex
          ],
          search: (uastring) => {
            return contains$1(uastring, "chrome") && !contains$1(uastring, "chromeframe");
          }
        },
        {
          name: "IE",
          versionRegexes: [
            /.*?msie\ ?([0-9]+)\.([0-9]+).*/,
            /.*?rv:([0-9]+)\.([0-9]+).*/
          ],
          search: (uastring) => {
            return contains$1(uastring, "msie") || contains$1(uastring, "trident");
          }
        },
        {
          name: "Opera",
          versionRegexes: [
            normalVersionRegex,
            /.*?opera\/([0-9]+)\.([0-9]+).*/
          ],
          search: checkContains("opera")
        },
        {
          name: "Firefox",
          versionRegexes: [/.*?firefox\/\ ?([0-9]+)\.([0-9]+).*/],
          search: checkContains("firefox")
        },
        {
          name: "Safari",
          versionRegexes: [
            normalVersionRegex,
            /.*?cpu os ([0-9]+)_([0-9]+).*/
          ],
          search: (uastring) => {
            return (contains$1(uastring, "safari") || contains$1(uastring, "mobile/")) && contains$1(uastring, "applewebkit");
          }
        }
      ];
      const oses = [
        {
          name: "Windows",
          search: checkContains("win"),
          versionRegexes: [/.*?windows\ nt\ ?([0-9]+)\.([0-9]+).*/]
        },
        {
          name: "iOS",
          search: (uastring) => {
            return contains$1(uastring, "iphone") || contains$1(uastring, "ipad");
          },
          versionRegexes: [
            /.*?version\/\ ?([0-9]+)\.([0-9]+).*/,
            /.*cpu os ([0-9]+)_([0-9]+).*/,
            /.*cpu iphone os ([0-9]+)_([0-9]+).*/
          ]
        },
        {
          name: "Android",
          search: checkContains("android"),
          versionRegexes: [/.*?android\ ?([0-9]+)\.([0-9]+).*/]
        },
        {
          name: "macOS",
          search: checkContains("mac os x"),
          versionRegexes: [/.*?mac\ os\ x\ ?([0-9]+)_([0-9]+).*/]
        },
        {
          name: "Linux",
          search: checkContains("linux"),
          versionRegexes: []
        },
        {
          name: "Solaris",
          search: checkContains("sunos"),
          versionRegexes: []
        },
        {
          name: "FreeBSD",
          search: checkContains("freebsd"),
          versionRegexes: []
        },
        {
          name: "ChromeOS",
          search: checkContains("cros"),
          versionRegexes: [/.*?chrome\/([0-9]+)\.([0-9]+).*/]
        }
      ];
      const PlatformInfo = {
        browsers: constant(browsers),
        oses: constant(oses)
      };
      const edge = "Edge";
      const chromium = "Chromium";
      const ie = "IE";
      const opera = "Opera";
      const firefox = "Firefox";
      const safari = "Safari";
      const unknown$1 = () => {
        return nu$2({
          current: void 0,
          version: Version.unknown()
        });
      };
      const nu$2 = (info) => {
        const current = info.current;
        const version = info.version;
        const isBrowser = (name2) => () => current === name2;
        return {
          current,
          version,
          isEdge: isBrowser(edge),
          isChromium: isBrowser(chromium),
          isIE: isBrowser(ie),
          isOpera: isBrowser(opera),
          isFirefox: isBrowser(firefox),
          isSafari: isBrowser(safari)
        };
      };
      const Browser = {
        unknown: unknown$1,
        nu: nu$2,
        edge: constant(edge),
        chromium: constant(chromium),
        ie: constant(ie),
        opera: constant(opera),
        firefox: constant(firefox),
        safari: constant(safari)
      };
      const windows = "Windows";
      const ios = "iOS";
      const android = "Android";
      const linux = "Linux";
      const macos = "macOS";
      const solaris = "Solaris";
      const freebsd = "FreeBSD";
      const chromeos = "ChromeOS";
      const unknown = () => {
        return nu$1({
          current: void 0,
          version: Version.unknown()
        });
      };
      const nu$1 = (info) => {
        const current = info.current;
        const version = info.version;
        const isOS = (name2) => () => current === name2;
        return {
          current,
          version,
          isWindows: isOS(windows),
          isiOS: isOS(ios),
          isAndroid: isOS(android),
          isMacOS: isOS(macos),
          isLinux: isOS(linux),
          isSolaris: isOS(solaris),
          isFreeBSD: isOS(freebsd),
          isChromeOS: isOS(chromeos)
        };
      };
      const OperatingSystem = {
        unknown,
        nu: nu$1,
        windows: constant(windows),
        ios: constant(ios),
        android: constant(android),
        linux: constant(linux),
        macos: constant(macos),
        solaris: constant(solaris),
        freebsd: constant(freebsd),
        chromeos: constant(chromeos)
      };
      const detect$2 = (userAgent2, userAgentDataOpt, mediaMatch2) => {
        const browsers2 = PlatformInfo.browsers();
        const oses2 = PlatformInfo.oses();
        const browser2 = userAgentDataOpt.bind((userAgentData) => detectBrowser$1(browsers2, userAgentData)).orThunk(() => detectBrowser(browsers2, userAgent2)).fold(Browser.unknown, Browser.nu);
        const os2 = detectOs(oses2, userAgent2).fold(OperatingSystem.unknown, OperatingSystem.nu);
        const deviceType2 = DeviceType(os2, browser2, userAgent2, mediaMatch2);
        return {
          browser: browser2,
          os: os2,
          deviceType: deviceType2
        };
      };
      const PlatformDetection = { detect: detect$2 };
      const mediaMatch = (query) => window.matchMedia(query).matches;
      let platform$4 = cached(() => PlatformDetection.detect(window.navigator.userAgent, Optional.from(window.navigator.userAgentData), mediaMatch));
      const detect$1 = () => platform$4();
      const userAgent = window.navigator.userAgent;
      const platform$3 = detect$1();
      const browser$3 = platform$3.browser;
      const os$1 = platform$3.os;
      const deviceType = platform$3.deviceType;
      const windowsPhone = userAgent.indexOf("Windows Phone") !== -1;
      const Env = {
        transparentSrc: "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7",
        documentMode: browser$3.isIE() ? document.documentMode || 7 : 10,
        cacheSuffix: null,
        container: null,
        canHaveCSP: !browser$3.isIE(),
        windowsPhone,
        browser: {
          current: browser$3.current,
          version: browser$3.version,
          isChromium: browser$3.isChromium,
          isEdge: browser$3.isEdge,
          isFirefox: browser$3.isFirefox,
          isIE: browser$3.isIE,
          isOpera: browser$3.isOpera,
          isSafari: browser$3.isSafari
        },
        os: {
          current: os$1.current,
          version: os$1.version,
          isAndroid: os$1.isAndroid,
          isChromeOS: os$1.isChromeOS,
          isFreeBSD: os$1.isFreeBSD,
          isiOS: os$1.isiOS,
          isLinux: os$1.isLinux,
          isMacOS: os$1.isMacOS,
          isSolaris: os$1.isSolaris,
          isWindows: os$1.isWindows
        },
        deviceType: {
          isDesktop: deviceType.isDesktop,
          isiPad: deviceType.isiPad,
          isiPhone: deviceType.isiPhone,
          isPhone: deviceType.isPhone,
          isTablet: deviceType.isTablet,
          isTouch: deviceType.isTouch,
          isWebView: deviceType.isWebView
        }
      };
      const whiteSpaceRegExp$1 = /^\s*|\s*$/g;
      const trim$3 = (str) => {
        return isNullable(str) ? "" : ("" + str).replace(whiteSpaceRegExp$1, "");
      };
      const is$3 = (obj, type2) => {
        if (!type2) {
          return obj !== void 0;
        }
        if (type2 === "array" && isArray(obj)) {
          return true;
        }
        return typeof obj === type2;
      };
      const makeMap$4 = (items, delim, map2 = {}) => {
        const resolvedItems = isString(items) ? items.split(delim || ",") : items || [];
        let i = resolvedItems.length;
        while (i--) {
          map2[resolvedItems[i]] = {};
        }
        return map2;
      };
      const hasOwnProperty = has$2;
      const extend$3 = (obj, ...exts) => {
        for (let i = 0; i < exts.length; i++) {
          const ext = exts[i];
          for (const name2 in ext) {
            if (has$2(ext, name2)) {
              const value2 = ext[name2];
              if (value2 !== void 0) {
                obj[name2] = value2;
              }
            }
          }
        }
        return obj;
      };
      const walk$4 = function(o, f, n, s) {
        s = s || this;
        if (o) {
          if (n) {
            o = o[n];
          }
          each$c(o, (o2, i) => {
            if (f.call(s, o2, i, n) === false) {
              return false;
            } else {
              walk$4(o2, f, n, s);
              return true;
            }
          });
        }
      };
      const resolve$3 = (n, o = window) => {
        const path2 = n.split(".");
        for (let i = 0, l = path2.length; i < l; i++) {
          o = o[path2[i]];
          if (!o) {
            break;
          }
        }
        return o;
      };
      const explode$3 = (s, d) => {
        if (isArray$1(s)) {
          return s;
        } else if (s === "") {
          return [];
        } else {
          return map$1(s.split(d || ","), trim$3);
        }
      };
      const _addCacheSuffix = (url) => {
        const cacheSuffix = Env.cacheSuffix;
        if (cacheSuffix) {
          url += (url.indexOf("?") === -1 ? "?" : "&") + cacheSuffix;
        }
        return url;
      };
      const Tools = {
        trim: trim$3,
        isArray,
        is: is$3,
        toArray: toArray$1,
        makeMap: makeMap$4,
        each: each$c,
        map: map$1,
        grep: filter$3,
        inArray: indexOf,
        hasOwn: hasOwnProperty,
        extend: extend$3,
        walk: walk$4,
        resolve: resolve$3,
        explode: explode$3,
        _addCacheSuffix
      };
      const is$2 = (lhs, rhs, comparator = tripleEquals) => lhs.exists((left) => comparator(left, rhs));
      const equals = (lhs, rhs, comparator = tripleEquals) => lift2(lhs, rhs, comparator).getOr(lhs.isNone() && rhs.isNone());
      const cat = (arr) => {
        const r2 = [];
        const push = (x) => {
          r2.push(x);
        };
        for (let i = 0; i < arr.length; i++) {
          arr[i].each(push);
        }
        return r2;
      };
      const lift2 = (oa, ob, f) => oa.isSome() && ob.isSome() ? Optional.some(f(oa.getOrDie(), ob.getOrDie())) : Optional.none();
      const lift3 = (oa, ob, oc, f) => oa.isSome() && ob.isSome() && oc.isSome() ? Optional.some(f(oa.getOrDie(), ob.getOrDie(), oc.getOrDie())) : Optional.none();
      const someIf = (b, a) => b ? Optional.some(a) : Optional.none();
      const Global = typeof window !== "undefined" ? window : Function("return this;")();
      const path = (parts, scope) => {
        let o = scope !== void 0 && scope !== null ? scope : Global;
        for (let i = 0; i < parts.length && o !== void 0 && o !== null; ++i) {
          o = o[parts[i]];
        }
        return o;
      };
      const resolve$2 = (p, scope) => {
        const parts = p.split(".");
        return path(parts, scope);
      };
      const unsafe = (name2, scope) => {
        return resolve$2(name2, scope);
      };
      const getOrDie = (name2, scope) => {
        const actual = unsafe(name2, scope);
        if (actual === void 0 || actual === null) {
          throw new Error(name2 + " not available on this browser");
        }
        return actual;
      };
      const getPrototypeOf$1 = Object.getPrototypeOf;
      const sandHTMLElement = (scope) => {
        return getOrDie("HTMLElement", scope);
      };
      const isPrototypeOf = (x) => {
        const scope = resolve$2("ownerDocument.defaultView", x);
        return isObject(x) && (sandHTMLElement(scope).prototype.isPrototypeOf(x) || /^HTML\w*Element$/.test(getPrototypeOf$1(x).constructor.name));
      };
      const COMMENT = 8;
      const DOCUMENT = 9;
      const DOCUMENT_FRAGMENT = 11;
      const ELEMENT = 1;
      const TEXT = 3;
      const name = (element) => {
        const r2 = element.dom.nodeName;
        return r2.toLowerCase();
      };
      const type$1 = (element) => element.dom.nodeType;
      const isType = (t) => (element) => type$1(element) === t;
      const isComment$1 = (element) => type$1(element) === COMMENT || name(element) === "#comment";
      const isHTMLElement$1 = (element) => isElement$7(element) && isPrototypeOf(element.dom);
      const isElement$7 = isType(ELEMENT);
      const isText$c = isType(TEXT);
      const isDocument$2 = isType(DOCUMENT);
      const isDocumentFragment$1 = isType(DOCUMENT_FRAGMENT);
      const isTag = (tag) => (e) => isElement$7(e) && name(e) === tag;
      const rawSet = (dom2, key, value2) => {
        if (isString(value2) || isBoolean(value2) || isNumber(value2)) {
          dom2.setAttribute(key, value2 + "");
        } else {
          console.error("Invalid call to Attribute.set. Key ", key, ":: Value ", value2, ":: Element ", dom2);
          throw new Error("Attribute value was not simple");
        }
      };
      const set$4 = (element, key, value2) => {
        rawSet(element.dom, key, value2);
      };
      const setAll$1 = (element, attrs) => {
        const dom2 = element.dom;
        each$d(attrs, (v, k) => {
          rawSet(dom2, k, v);
        });
      };
      const get$9 = (element, key) => {
        const v = element.dom.getAttribute(key);
        return v === null ? void 0 : v;
      };
      const getOpt = (element, key) => Optional.from(get$9(element, key));
      const has$1 = (element, key) => {
        const dom2 = element.dom;
        return dom2 && dom2.hasAttribute ? dom2.hasAttribute(key) : false;
      };
      const remove$9 = (element, key) => {
        element.dom.removeAttribute(key);
      };
      const hasNone = (element) => {
        const attrs = element.dom.attributes;
        return attrs === void 0 || attrs === null || attrs.length === 0;
      };
      const clone$4 = (element) => foldl(element.dom.attributes, (acc, attr) => {
        acc[attr.name] = attr.value;
        return acc;
      }, {});
      const read$4 = (element, attr) => {
        const value2 = get$9(element, attr);
        return value2 === void 0 || value2 === "" ? [] : value2.split(" ");
      };
      const add$4 = (element, attr, id) => {
        const old = read$4(element, attr);
        const nu2 = old.concat([id]);
        set$4(element, attr, nu2.join(" "));
        return true;
      };
      const remove$8 = (element, attr, id) => {
        const nu2 = filter$5(read$4(element, attr), (v) => v !== id);
        if (nu2.length > 0) {
          set$4(element, attr, nu2.join(" "));
        } else {
          remove$9(element, attr);
        }
        return false;
      };
      const supports = (element) => element.dom.classList !== void 0;
      const get$8 = (element) => read$4(element, "class");
      const add$3 = (element, clazz) => add$4(element, "class", clazz);
      const remove$7 = (element, clazz) => remove$8(element, "class", clazz);
      const toggle$2 = (element, clazz) => {
        if (contains$2(get$8(element), clazz)) {
          return remove$7(element, clazz);
        } else {
          return add$3(element, clazz);
        }
      };
      const add$2 = (element, clazz) => {
        if (supports(element)) {
          element.dom.classList.add(clazz);
        } else {
          add$3(element, clazz);
        }
      };
      const cleanClass = (element) => {
        const classList = supports(element) ? element.dom.classList : get$8(element);
        if (classList.length === 0) {
          remove$9(element, "class");
        }
      };
      const remove$6 = (element, clazz) => {
        if (supports(element)) {
          const classList = element.dom.classList;
          classList.remove(clazz);
        } else {
          remove$7(element, clazz);
        }
        cleanClass(element);
      };
      const toggle$1 = (element, clazz) => {
        const result = supports(element) ? element.dom.classList.toggle(clazz) : toggle$2(element, clazz);
        cleanClass(element);
        return result;
      };
      const has = (element, clazz) => supports(element) && element.dom.classList.contains(clazz);
      const fromHtml$1 = (html2, scope) => {
        const doc = scope || document;
        const div = doc.createElement("div");
        div.innerHTML = html2;
        if (!div.hasChildNodes() || div.childNodes.length > 1) {
          const message = "HTML does not have a single root node";
          console.error(message, html2);
          throw new Error(message);
        }
        return fromDom$2(div.childNodes[0]);
      };
      const fromTag = (tag, scope) => {
        const doc = scope || document;
        const node = doc.createElement(tag);
        return fromDom$2(node);
      };
      const fromText = (text2, scope) => {
        const doc = scope || document;
        const node = doc.createTextNode(text2);
        return fromDom$2(node);
      };
      const fromDom$2 = (node) => {
        if (node === null || node === void 0) {
          throw new Error("Node cannot be null or undefined");
        }
        return { dom: node };
      };
      const fromPoint$2 = (docElm, x, y) => Optional.from(docElm.dom.elementFromPoint(x, y)).map(fromDom$2);
      const SugarElement = {
        fromHtml: fromHtml$1,
        fromTag,
        fromText,
        fromDom: fromDom$2,
        fromPoint: fromPoint$2
      };
      const toArray = (target, f) => {
        const r2 = [];
        const recurse = (e) => {
          r2.push(e);
          return f(e);
        };
        let cur = f(target);
        do {
          cur = cur.bind(recurse);
        } while (cur.isSome());
        return r2;
      };
      const is$1 = (element, selector) => {
        const dom2 = element.dom;
        if (dom2.nodeType !== ELEMENT) {
          return false;
        } else {
          const elem = dom2;
          if (elem.matches !== void 0) {
            return elem.matches(selector);
          } else if (elem.msMatchesSelector !== void 0) {
            return elem.msMatchesSelector(selector);
          } else if (elem.webkitMatchesSelector !== void 0) {
            return elem.webkitMatchesSelector(selector);
          } else if (elem.mozMatchesSelector !== void 0) {
            return elem.mozMatchesSelector(selector);
          } else {
            throw new Error("Browser lacks native selectors");
          }
        }
      };
      const bypassSelector = (dom2) => dom2.nodeType !== ELEMENT && dom2.nodeType !== DOCUMENT && dom2.nodeType !== DOCUMENT_FRAGMENT || dom2.childElementCount === 0;
      const all = (selector, scope) => {
        const base = scope === void 0 ? document : scope.dom;
        return bypassSelector(base) ? [] : map$3(base.querySelectorAll(selector), SugarElement.fromDom);
      };
      const one = (selector, scope) => {
        const base = scope === void 0 ? document : scope.dom;
        return bypassSelector(base) ? Optional.none() : Optional.from(base.querySelector(selector)).map(SugarElement.fromDom);
      };
      const eq = (e1, e2) => e1.dom === e2.dom;
      const contains = (e1, e2) => {
        const d1 = e1.dom;
        const d2 = e2.dom;
        return d1 === d2 ? false : d1.contains(d2);
      };
      const owner$1 = (element) => SugarElement.fromDom(element.dom.ownerDocument);
      const documentOrOwner = (dos) => isDocument$2(dos) ? dos : owner$1(dos);
      const documentElement = (element) => SugarElement.fromDom(documentOrOwner(element).dom.documentElement);
      const defaultView = (element) => SugarElement.fromDom(documentOrOwner(element).dom.defaultView);
      const parent = (element) => Optional.from(element.dom.parentNode).map(SugarElement.fromDom);
      const parentElement = (element) => Optional.from(element.dom.parentElement).map(SugarElement.fromDom);
      const parents$1 = (element, isRoot2) => {
        const stop2 = isFunction(isRoot2) ? isRoot2 : never;
        let dom2 = element.dom;
        const ret = [];
        while (dom2.parentNode !== null && dom2.parentNode !== void 0) {
          const rawParent = dom2.parentNode;
          const p = SugarElement.fromDom(rawParent);
          ret.push(p);
          if (stop2(p) === true) {
            break;
          } else {
            dom2 = rawParent;
          }
        }
        return ret;
      };
      const siblings = (element) => {
        const filterSelf = (elements) => filter$5(elements, (x) => !eq(element, x));
        return parent(element).map(children$1).map(filterSelf).getOr([]);
      };
      const prevSibling = (element) => Optional.from(element.dom.previousSibling).map(SugarElement.fromDom);
      const nextSibling = (element) => Optional.from(element.dom.nextSibling).map(SugarElement.fromDom);
      const prevSiblings = (element) => reverse(toArray(element, prevSibling));
      const nextSiblings = (element) => toArray(element, nextSibling);
      const children$1 = (element) => map$3(element.dom.childNodes, SugarElement.fromDom);
      const child$1 = (element, index) => {
        const cs = element.dom.childNodes;
        return Optional.from(cs[index]).map(SugarElement.fromDom);
      };
      const firstChild = (element) => child$1(element, 0);
      const lastChild = (element) => child$1(element, element.dom.childNodes.length - 1);
      const childNodesCount = (element) => element.dom.childNodes.length;
      const getHead = (doc) => {
        const b = doc.dom.head;
        if (b === null || b === void 0) {
          throw new Error("Head is not available yet");
        }
        return SugarElement.fromDom(b);
      };
      const isShadowRoot = (dos) => isDocumentFragment$1(dos) && isNonNullable(dos.dom.host);
      const getRootNode = (e) => SugarElement.fromDom(e.dom.getRootNode());
      const getStyleContainer = (dos) => isShadowRoot(dos) ? dos : getHead(documentOrOwner(dos));
      const getContentContainer = (dos) => isShadowRoot(dos) ? dos : SugarElement.fromDom(documentOrOwner(dos).dom.body);
      const getShadowRoot = (e) => {
        const r2 = getRootNode(e);
        return isShadowRoot(r2) ? Optional.some(r2) : Optional.none();
      };
      const getShadowHost = (e) => SugarElement.fromDom(e.dom.host);
      const getOriginalEventTarget = (event) => {
        if (isNonNullable(event.target)) {
          const el = SugarElement.fromDom(event.target);
          if (isElement$7(el) && isOpenShadowHost(el)) {
            if (event.composed && event.composedPath) {
              const composedPath = event.composedPath();
              if (composedPath) {
                return head(composedPath);
              }
            }
          }
        }
        return Optional.from(event.target);
      };
      const isOpenShadowHost = (element) => isNonNullable(element.dom.shadowRoot);
      const inBody = (element) => {
        const dom2 = isText$c(element) ? element.dom.parentNode : element.dom;
        if (dom2 === void 0 || dom2 === null || dom2.ownerDocument === null) {
          return false;
        }
        const doc = dom2.ownerDocument;
        return getShadowRoot(SugarElement.fromDom(dom2)).fold(() => doc.body.contains(dom2), compose1(inBody, getShadowHost));
      };
      var ClosestOrAncestor = (is2, ancestor2, scope, a, isRoot2) => {
        if (is2(scope, a)) {
          return Optional.some(scope);
        } else if (isFunction(isRoot2) && isRoot2(scope)) {
          return Optional.none();
        } else {
          return ancestor2(scope, a, isRoot2);
        }
      };
      const ancestor$4 = (scope, predicate, isRoot2) => {
        let element = scope.dom;
        const stop2 = isFunction(isRoot2) ? isRoot2 : never;
        while (element.parentNode) {
          element = element.parentNode;
          const el = SugarElement.fromDom(element);
          if (predicate(el)) {
            return Optional.some(el);
          } else if (stop2(el)) {
            break;
          }
        }
        return Optional.none();
      };
      const closest$4 = (scope, predicate, isRoot2) => {
        const is2 = (s, test) => test(s);
        return ClosestOrAncestor(is2, ancestor$4, scope, predicate, isRoot2);
      };
      const sibling$1 = (scope, predicate) => {
        const element = scope.dom;
        if (!element.parentNode) {
          return Optional.none();
        }
        return child(SugarElement.fromDom(element.parentNode), (x) => !eq(scope, x) && predicate(x));
      };
      const child = (scope, predicate) => {
        const pred = (node) => predicate(SugarElement.fromDom(node));
        const result = find$2(scope.dom.childNodes, pred);
        return result.map(SugarElement.fromDom);
      };
      const descendant$2 = (scope, predicate) => {
        const descend2 = (node) => {
          for (let i = 0; i < node.childNodes.length; i++) {
            const child2 = SugarElement.fromDom(node.childNodes[i]);
            if (predicate(child2)) {
              return Optional.some(child2);
            }
            const res = descend2(node.childNodes[i]);
            if (res.isSome()) {
              return res;
            }
          }
          return Optional.none();
        };
        return descend2(scope.dom);
      };
      const ancestor$3 = (scope, selector, isRoot2) => ancestor$4(scope, (e) => is$1(e, selector), isRoot2);
      const descendant$1 = (scope, selector) => one(selector, scope);
      const closest$3 = (scope, selector, isRoot2) => {
        const is2 = (element, selector2) => is$1(element, selector2);
        return ClosestOrAncestor(is2, ancestor$3, scope, selector, isRoot2);
      };
      const closest$2 = (target) => closest$3(target, "[contenteditable]");
      const isEditable$2 = (element, assumeEditable = false) => {
        if (inBody(element)) {
          return element.dom.isContentEditable;
        } else {
          return closest$2(element).fold(constant(assumeEditable), (editable) => getRaw$1(editable) === "true");
        }
      };
      const getRaw$1 = (element) => element.dom.contentEditable;
      const set$3 = (element, editable) => {
        element.dom.contentEditable = editable ? "true" : "false";
      };
      const isSupported = (dom2) => dom2.style !== void 0 && isFunction(dom2.style.getPropertyValue);
      const internalSet = (dom2, property, value2) => {
        if (!isString(value2)) {
          console.error("Invalid call to CSS.set. Property ", property, ":: Value ", value2, ":: Element ", dom2);
          throw new Error("CSS value must be a string: " + value2);
        }
        if (isSupported(dom2)) {
          dom2.style.setProperty(property, value2);
        }
      };
      const internalRemove = (dom2, property) => {
        if (isSupported(dom2)) {
          dom2.style.removeProperty(property);
        }
      };
      const set$2 = (element, property, value2) => {
        const dom2 = element.dom;
        internalSet(dom2, property, value2);
      };
      const setAll = (element, css) => {
        const dom2 = element.dom;
        each$d(css, (v, k) => {
          internalSet(dom2, k, v);
        });
      };
      const get$7 = (element, property) => {
        const dom2 = element.dom;
        const styles = window.getComputedStyle(dom2);
        const r2 = styles.getPropertyValue(property);
        return r2 === "" && !inBody(element) ? getUnsafeProperty(dom2, property) : r2;
      };
      const getUnsafeProperty = (dom2, property) => isSupported(dom2) ? dom2.style.getPropertyValue(property) : "";
      const getRaw = (element, property) => {
        const dom2 = element.dom;
        const raw = getUnsafeProperty(dom2, property);
        return Optional.from(raw).filter((r2) => r2.length > 0);
      };
      const getAllRaw = (element) => {
        const css = {};
        const dom2 = element.dom;
        if (isSupported(dom2)) {
          for (let i = 0; i < dom2.style.length; i++) {
            const ruleName = dom2.style.item(i);
            css[ruleName] = dom2.style[ruleName];
          }
        }
        return css;
      };
      const remove$5 = (element, property) => {
        const dom2 = element.dom;
        internalRemove(dom2, property);
        if (is$2(getOpt(element, "style").map(trim$4), "")) {
          remove$9(element, "style");
        }
      };
      const reflow = (e) => e.dom.offsetWidth;
      const before$3 = (marker, element) => {
        const parent$1 = parent(marker);
        parent$1.each((v) => {
          v.dom.insertBefore(element.dom, marker.dom);
        });
      };
      const after$4 = (marker, element) => {
        const sibling2 = nextSibling(marker);
        sibling2.fold(() => {
          const parent$1 = parent(marker);
          parent$1.each((v) => {
            append$1(v, element);
          });
        }, (v) => {
          before$3(v, element);
        });
      };
      const prepend = (parent2, element) => {
        const firstChild$1 = firstChild(parent2);
        firstChild$1.fold(() => {
          append$1(parent2, element);
        }, (v) => {
          parent2.dom.insertBefore(element.dom, v.dom);
        });
      };
      const append$1 = (parent2, element) => {
        parent2.dom.appendChild(element.dom);
      };
      const wrap$2 = (element, wrapper) => {
        before$3(element, wrapper);
        append$1(wrapper, element);
      };
      const after$3 = (marker, elements) => {
        each$e(elements, (x, i) => {
          const e = i === 0 ? marker : elements[i - 1];
          after$4(e, x);
        });
      };
      const append = (parent2, elements) => {
        each$e(elements, (x) => {
          append$1(parent2, x);
        });
      };
      const empty = (element) => {
        element.dom.textContent = "";
        each$e(children$1(element), (rogue) => {
          remove$4(rogue);
        });
      };
      const remove$4 = (element) => {
        const dom2 = element.dom;
        if (dom2.parentNode !== null) {
          dom2.parentNode.removeChild(dom2);
        }
      };
      const unwrap = (wrapper) => {
        const children2 = children$1(wrapper);
        if (children2.length > 0) {
          after$3(wrapper, children2);
        }
        remove$4(wrapper);
      };
      const fromHtml = (html2, scope) => {
        const doc = scope || document;
        const div = doc.createElement("div");
        div.innerHTML = html2;
        return children$1(SugarElement.fromDom(div));
      };
      const fromDom$1 = (nodes) => map$3(nodes, SugarElement.fromDom);
      const get$6 = (element) => element.dom.innerHTML;
      const set$1 = (element, content) => {
        const owner2 = owner$1(element);
        const docDom = owner2.dom;
        const fragment = SugarElement.fromDom(docDom.createDocumentFragment());
        const contentElements = fromHtml(content, docDom);
        append(fragment, contentElements);
        empty(element);
        append$1(element, fragment);
      };
      const getOuter = (element) => {
        const container = SugarElement.fromTag("div");
        const clone2 = SugarElement.fromDom(element.dom.cloneNode(true));
        append$1(container, clone2);
        return get$6(container);
      };
      const mkEvent = (target, x, y, stop2, prevent, kill, raw) => ({
        target,
        x,
        y,
        stop: stop2,
        prevent,
        kill,
        raw
      });
      const fromRawEvent = (rawEvent) => {
        const target = SugarElement.fromDom(getOriginalEventTarget(rawEvent).getOr(rawEvent.target));
        const stop2 = () => rawEvent.stopPropagation();
        const prevent = () => rawEvent.preventDefault();
        const kill = compose(prevent, stop2);
        return mkEvent(target, rawEvent.clientX, rawEvent.clientY, stop2, prevent, kill, rawEvent);
      };
      const handle$1 = (filter2, handler) => (rawEvent) => {
        if (filter2(rawEvent)) {
          handler(fromRawEvent(rawEvent));
        }
      };
      const binder = (element, event, filter2, handler, useCapture) => {
        const wrapped = handle$1(filter2, handler);
        element.dom.addEventListener(event, wrapped, useCapture);
        return { unbind: curry(unbind, element, event, wrapped, useCapture) };
      };
      const bind$2 = (element, event, filter2, handler) => binder(element, event, filter2, handler, false);
      const unbind = (element, event, handler, useCapture) => {
        element.dom.removeEventListener(event, handler, useCapture);
      };
      const r = (left, top) => {
        const translate2 = (x, y) => r(left + x, top + y);
        return {
          left,
          top,
          translate: translate2
        };
      };
      const SugarPosition = r;
      const boxPosition = (dom2) => {
        const box = dom2.getBoundingClientRect();
        return SugarPosition(box.left, box.top);
      };
      const firstDefinedOrZero = (a, b) => {
        if (a !== void 0) {
          return a;
        } else {
          return b !== void 0 ? b : 0;
        }
      };
      const absolute = (element) => {
        const doc = element.dom.ownerDocument;
        const body = doc.body;
        const win = doc.defaultView;
        const html2 = doc.documentElement;
        if (body === element.dom) {
          return SugarPosition(body.offsetLeft, body.offsetTop);
        }
        const scrollTop = firstDefinedOrZero(win === null || win === void 0 ? void 0 : win.pageYOffset, html2.scrollTop);
        const scrollLeft2 = firstDefinedOrZero(win === null || win === void 0 ? void 0 : win.pageXOffset, html2.scrollLeft);
        const clientTop = firstDefinedOrZero(html2.clientTop, body.clientTop);
        const clientLeft = firstDefinedOrZero(html2.clientLeft, body.clientLeft);
        return viewport(element).translate(scrollLeft2 - clientLeft, scrollTop - clientTop);
      };
      const viewport = (element) => {
        const dom2 = element.dom;
        const doc = dom2.ownerDocument;
        const body = doc.body;
        if (body === dom2) {
          return SugarPosition(body.offsetLeft, body.offsetTop);
        }
        if (!inBody(element)) {
          return SugarPosition(0, 0);
        }
        return boxPosition(dom2);
      };
      const get$5 = (_DOC) => {
        const doc = _DOC !== void 0 ? _DOC.dom : document;
        const x = doc.body.scrollLeft || doc.documentElement.scrollLeft;
        const y = doc.body.scrollTop || doc.documentElement.scrollTop;
        return SugarPosition(x, y);
      };
      const to = (x, y, _DOC) => {
        const doc = _DOC !== void 0 ? _DOC.dom : document;
        const win = doc.defaultView;
        if (win) {
          win.scrollTo(x, y);
        }
      };
      const intoView = (element, alignToTop) => {
        const isSafari2 = detect$1().browser.isSafari();
        if (isSafari2 && isFunction(element.dom.scrollIntoViewIfNeeded)) {
          element.dom.scrollIntoViewIfNeeded(false);
        } else {
          element.dom.scrollIntoView(alignToTop);
        }
      };
      const get$4 = (_win) => {
        const win = _win === void 0 ? window : _win;
        if (detect$1().browser.isFirefox()) {
          return Optional.none();
        } else {
          return Optional.from(win.visualViewport);
        }
      };
      const bounds = (x, y, width, height) => ({
        x,
        y,
        width,
        height,
        right: x + width,
        bottom: y + height
      });
      const getBounds = (_win) => {
        const win = _win === void 0 ? window : _win;
        const doc = win.document;
        const scroll = get$5(SugarElement.fromDom(doc));
        return get$4(win).fold(() => {
          const html2 = win.document.documentElement;
          const width = html2.clientWidth;
          const height = html2.clientHeight;
          return bounds(scroll.left, scroll.top, width, height);
        }, (visualViewport) => bounds(Math.max(visualViewport.pageLeft, scroll.left), Math.max(visualViewport.pageTop, scroll.top), visualViewport.width, visualViewport.height));
      };
      const children = (scope, predicate) => filter$5(children$1(scope), predicate);
      const descendants$1 = (scope, predicate) => {
        let result = [];
        each$e(children$1(scope), (x) => {
          if (predicate(x)) {
            result = result.concat([x]);
          }
          result = result.concat(descendants$1(x, predicate));
        });
        return result;
      };
      const descendants = (scope, selector) => all(selector, scope);
      const ancestor$2 = (scope, predicate, isRoot2) => ancestor$4(scope, predicate, isRoot2).isSome();
      const sibling = (scope, predicate) => sibling$1(scope, predicate).isSome();
      const descendant = (scope, predicate) => descendant$2(scope, predicate).isSome();
      class DomTreeWalker {
        constructor(startNode, rootNode) {
          this.node = startNode;
          this.rootNode = rootNode;
          this.current = this.current.bind(this);
          this.next = this.next.bind(this);
          this.prev = this.prev.bind(this);
          this.prev2 = this.prev2.bind(this);
        }
        current() {
          return this.node;
        }
        next(shallow2) {
          this.node = this.findSibling(this.node, "firstChild", "nextSibling", shallow2);
          return this.node;
        }
        prev(shallow2) {
          this.node = this.findSibling(this.node, "lastChild", "previousSibling", shallow2);
          return this.node;
        }
        prev2(shallow2) {
          this.node = this.findPreviousNode(this.node, shallow2);
          return this.node;
        }
        findSibling(node, startName, siblingName, shallow2) {
          if (node) {
            if (!shallow2 && node[startName]) {
              return node[startName];
            }
            if (node !== this.rootNode) {
              let sibling2 = node[siblingName];
              if (sibling2) {
                return sibling2;
              }
              for (let parent2 = node.parentNode; parent2 && parent2 !== this.rootNode; parent2 = parent2.parentNode) {
                sibling2 = parent2[siblingName];
                if (sibling2) {
                  return sibling2;
                }
              }
            }
          }
          return void 0;
        }
        findPreviousNode(node, shallow2) {
          if (node) {
            const sibling2 = node.previousSibling;
            if (this.rootNode && sibling2 === this.rootNode) {
              return;
            }
            if (sibling2) {
              if (!shallow2) {
                for (let child2 = sibling2.lastChild; child2; child2 = child2.lastChild) {
                  if (!child2.lastChild) {
                    return child2;
                  }
                }
              }
              return sibling2;
            }
            const parent2 = node.parentNode;
            if (parent2 && parent2 !== this.rootNode) {
              return parent2;
            }
          }
          return void 0;
        }
      }
      const zeroWidth = "\uFEFF";
      const nbsp = " ";
      const isZwsp$2 = (char) => char === zeroWidth;
      const removeZwsp = (s) => s.replace(/\uFEFF/g, "");
      const whiteSpaceRegExp = /^[ \t\r\n]*$/;
      const isWhitespaceText = (text2) => whiteSpaceRegExp.test(text2);
      const isZwsp$1 = (text2) => {
        for (const c of text2) {
          if (!isZwsp$2(c)) {
            return false;
          }
        }
        return true;
      };
      const isCollapsibleWhitespace$1 = (c) => " \f	\v".indexOf(c) !== -1;
      const isNewLineChar = (c) => c === "\n" || c === "\r";
      const isNewline = (text2, idx) => idx < text2.length && idx >= 0 ? isNewLineChar(text2[idx]) : false;
      const normalize$4 = (text2, tabSpaces = 4, isStartOfContent = true, isEndOfContent = true) => {
        const tabSpace = repeat(" ", tabSpaces);
        const normalizedText = text2.replace(/\t/g, tabSpace);
        const result = foldl(normalizedText, (acc, c) => {
          if (isCollapsibleWhitespace$1(c) || c === nbsp) {
            if (acc.pcIsSpace || acc.str === "" && isStartOfContent || acc.str.length === normalizedText.length - 1 && isEndOfContent || isNewline(normalizedText, acc.str.length + 1)) {
              return {
                pcIsSpace: false,
                str: acc.str + nbsp
              };
            } else {
              return {
                pcIsSpace: true,
                str: acc.str + " "
              };
            }
          } else {
            return {
              pcIsSpace: isNewLineChar(c),
              str: acc.str + c
            };
          }
        }, {
          pcIsSpace: false,
          str: ""
        });
        return result.str;
      };
      const isNodeType = (type2) => {
        return (node) => {
          return !!node && node.nodeType === type2;
        };
      };
      const isRestrictedNode = (node) => !!node && !Object.getPrototypeOf(node);
      const isElement$6 = isNodeType(1);
      const isHTMLElement = (node) => isElement$6(node) && isHTMLElement$1(SugarElement.fromDom(node));
      const isSVGElement = (node) => isElement$6(node) && node.namespaceURI === "http://www.w3.org/2000/svg";
      const matchNodeName = (name2) => {
        const lowerCasedName = name2.toLowerCase();
        return (node) => isNonNullable(node) && node.nodeName.toLowerCase() === lowerCasedName;
      };
      const matchNodeNames = (names) => {
        const lowerCasedNames = names.map((s) => s.toLowerCase());
        return (node) => {
          if (node && node.nodeName) {
            const nodeName = node.nodeName.toLowerCase();
            return contains$2(lowerCasedNames, nodeName);
          }
          return false;
        };
      };
      const matchStyleValues = (name2, values2) => {
        const items = values2.toLowerCase().split(" ");
        return (node) => {
          if (isElement$6(node)) {
            const win = node.ownerDocument.defaultView;
            if (win) {
              for (let i = 0; i < items.length; i++) {
                const computed = win.getComputedStyle(node, null);
                const cssValue = computed ? computed.getPropertyValue(name2) : null;
                if (cssValue === items[i]) {
                  return true;
                }
              }
            }
          }
          return false;
        };
      };
      const hasAttribute = (attrName) => {
        return (node) => {
          return isElement$6(node) && node.hasAttribute(attrName);
        };
      };
      const isBogus$1 = (node) => isElement$6(node) && node.hasAttribute("data-mce-bogus");
      const isBogusAll = (node) => isElement$6(node) && node.getAttribute("data-mce-bogus") === "all";
      const isTable$2 = (node) => isElement$6(node) && node.tagName === "TABLE";
      const hasContentEditableState = (value2) => {
        return (node) => {
          if (isHTMLElement(node)) {
            if (node.contentEditable === value2) {
              return true;
            }
            if (node.getAttribute("data-mce-contenteditable") === value2) {
              return true;
            }
          }
          return false;
        };
      };
      const isTextareaOrInput = matchNodeNames([
        "textarea",
        "input"
      ]);
      const isText$b = isNodeType(3);
      const isCData = isNodeType(4);
      const isPi = isNodeType(7);
      const isComment = isNodeType(8);
      const isDocument$1 = isNodeType(9);
      const isDocumentFragment = isNodeType(11);
      const isBr$6 = matchNodeName("br");
      const isImg = matchNodeName("img");
      const isContentEditableTrue$3 = hasContentEditableState("true");
      const isContentEditableFalse$b = hasContentEditableState("false");
      const isEditingHost = (node) => isHTMLElement(node) && node.isContentEditable && isNonNullable(node.parentElement) && !node.parentElement.isContentEditable;
      const isTableCell$3 = matchNodeNames([
        "td",
        "th"
      ]);
      const isTableCellOrCaption = matchNodeNames([
        "td",
        "th",
        "caption"
      ]);
      const isMedia$2 = matchNodeNames([
        "video",
        "audio",
        "object",
        "embed"
      ]);
      const isListItem$2 = matchNodeName("li");
      const isDetails = matchNodeName("details");
      const isSummary$1 = matchNodeName("summary");
      const defaultOptionValues = {
        skipBogus: true,
        includeZwsp: false,
        checkRootAsContent: false
      };
      const hasWhitespacePreserveParent = (node, rootNode, schema) => {
        const rootElement = SugarElement.fromDom(rootNode);
        const startNode = SugarElement.fromDom(node);
        const whitespaceElements = schema.getWhitespaceElements();
        const predicate = (node2) => has$2(whitespaceElements, name(node2));
        return ancestor$2(startNode, predicate, curry(eq, rootElement));
      };
      const isNamedAnchor = (node) => {
        return isElement$6(node) && node.nodeName === "A" && !node.hasAttribute("href") && (node.hasAttribute("name") || node.hasAttribute("id"));
      };
      const isNonEmptyElement$1 = (node, schema) => {
        return isElement$6(node) && has$2(schema.getNonEmptyElements(), node.nodeName);
      };
      const isBookmark = hasAttribute("data-mce-bookmark");
      const hasNonEditableParent = (node) => parentElement(SugarElement.fromDom(node)).exists((parent2) => !isEditable$2(parent2));
      const isWhitespace$1 = (node, rootNode, schema) => isWhitespaceText(node.data) && !hasWhitespacePreserveParent(node, rootNode, schema);
      const isText$a = (node, rootNode, schema, options) => isText$b(node) && !isWhitespace$1(node, rootNode, schema) && (!options.includeZwsp || !isZwsp$1(node.data));
      const isContentNode = (schema, node, rootNode, options) => {
        return isFunction(options.isContent) && options.isContent(node) || isNonEmptyElement$1(node, schema) || isBookmark(node) || isNamedAnchor(node) || isText$a(node, rootNode, schema, options) || isContentEditableFalse$b(node) || isContentEditableTrue$3(node) && hasNonEditableParent(node);
      };
      const isEmptyNode = (schema, targetNode, opts) => {
        const options = {
          ...defaultOptionValues,
          ...opts
        };
        if (options.checkRootAsContent) {
          if (isContentNode(schema, targetNode, targetNode, options)) {
            return false;
          }
        }
        let node = targetNode.firstChild;
        let brCount = 0;
        if (!node) {
          return true;
        }
        const walker = new DomTreeWalker(node, targetNode);
        do {
          if (options.skipBogus && isElement$6(node)) {
            const bogusValue = node.getAttribute("data-mce-bogus");
            if (bogusValue) {
              node = walker.next(bogusValue === "all");
              continue;
            }
          }
          if (isComment(node)) {
            node = walker.next(true);
            continue;
          }
          if (isBr$6(node)) {
            brCount++;
            node = walker.next();
            continue;
          }
          if (isContentNode(schema, node, targetNode, options)) {
            return false;
          }
          node = walker.next();
        } while (node);
        return brCount <= 1;
      };
      const isEmpty$2 = (schema, elm, options) => {
        return isEmptyNode(schema, elm.dom, {
          checkRootAsContent: true,
          ...options
        });
      };
      const isContent$1 = (schema, node, options) => {
        return isContentNode(schema, node, node, {
          includeZwsp: defaultOptionValues.includeZwsp,
          ...options
        });
      };
      const Cell = (initial) => {
        let value2 = initial;
        const get2 = () => {
          return value2;
        };
        const set2 = (v) => {
          value2 = v;
        };
        return {
          get: get2,
          set: set2
        };
      };
      const singleton = (doRevoke) => {
        const subject = Cell(Optional.none());
        const revoke = () => subject.get().each(doRevoke);
        const clear2 = () => {
          revoke();
          subject.set(Optional.none());
        };
        const isSet = () => subject.get().isSome();
        const get2 = () => subject.get();
        const set2 = (s) => {
          revoke();
          subject.set(Optional.some(s));
        };
        return {
          clear: clear2,
          isSet,
          get: get2,
          set: set2
        };
      };
      const repeatable = (delay) => {
        const intervalId = Cell(Optional.none());
        const revoke = () => intervalId.get().each((id) => clearInterval(id));
        const clear2 = () => {
          revoke();
          intervalId.set(Optional.none());
        };
        const isSet = () => intervalId.get().isSome();
        const get2 = () => intervalId.get();
        const set2 = (functionToRepeat) => {
          revoke();
          intervalId.set(Optional.some(setInterval(functionToRepeat, delay)));
        };
        return {
          clear: clear2,
          isSet,
          get: get2,
          set: set2
        };
      };
      const value$2 = () => {
        const subject = singleton(noop);
        const on2 = (f) => subject.get().each(f);
        return {
          ...subject,
          on: on2
        };
      };
      const nodeNameToNamespaceType = (name2) => {
        const lowerCaseName = name2.toLowerCase();
        if (lowerCaseName === "svg") {
          return "svg";
        } else if (lowerCaseName === "math") {
          return "math";
        } else {
          return "html";
        }
      };
      const isNonHtmlElementRootName = (name2) => nodeNameToNamespaceType(name2) !== "html";
      const isNonHtmlElementRoot = (node) => isNonHtmlElementRootName(node.nodeName);
      const toScopeType = (node) => nodeNameToNamespaceType(node.nodeName);
      const namespaceElements = [
        "svg",
        "math"
      ];
      const createNamespaceTracker = () => {
        const currentScope = value$2();
        const current = () => currentScope.get().map(toScopeType).getOr("html");
        const track = (node) => {
          if (isNonHtmlElementRoot(node)) {
            currentScope.set(node);
          } else if (currentScope.get().exists((scopeNode) => !scopeNode.contains(node))) {
            currentScope.clear();
          }
          return current();
        };
        const reset2 = () => {
          currentScope.clear();
        };
        return {
          track,
          current,
          reset: reset2
        };
      };
      const transparentBlockAttr = "data-mce-block";
      const elementNames = (map2) => filter$5(keys(map2), (key) => !/[A-Z]/.test(key));
      const makeSelectorFromSchemaMap = (map2) => map$3(elementNames(map2), (name2) => {
        const escapedName = CSS.escape(name2);
        return `${escapedName}:` + map$3(namespaceElements, (ns) => `not(${ns} ${escapedName})`).join(":");
      }).join(",");
      const updateTransparent = (blocksSelector, transparent) => {
        if (isNonNullable(transparent.querySelector(blocksSelector))) {
          transparent.setAttribute(transparentBlockAttr, "true");
          if (transparent.getAttribute("data-mce-selected") === "inline-boundary") {
            transparent.removeAttribute("data-mce-selected");
          }
          return true;
        } else {
          transparent.removeAttribute(transparentBlockAttr);
          return false;
        }
      };
      const updateBlockStateOnChildren = (schema, scope) => {
        const transparentSelector = makeSelectorFromSchemaMap(schema.getTransparentElements());
        const blocksSelector = makeSelectorFromSchemaMap(schema.getBlockElements());
        return filter$5(scope.querySelectorAll(transparentSelector), (transparent) => updateTransparent(blocksSelector, transparent));
      };
      const trimEdge = (schema, el, leftSide) => {
        var _a;
        const childPropertyName = leftSide ? "lastChild" : "firstChild";
        for (let child2 = el[childPropertyName]; child2; child2 = child2[childPropertyName]) {
          if (isEmptyNode(schema, child2, { checkRootAsContent: true })) {
            (_a = child2.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(child2);
            return;
          }
        }
      };
      const split$2 = (schema, parentElm, splitElm) => {
        const range2 = document.createRange();
        const parentNode = parentElm.parentNode;
        if (parentNode) {
          range2.setStartBefore(parentElm);
          range2.setEndBefore(splitElm);
          const beforeFragment = range2.extractContents();
          trimEdge(schema, beforeFragment, true);
          range2.setStartAfter(splitElm);
          range2.setEndAfter(parentElm);
          const afterFragment = range2.extractContents();
          trimEdge(schema, afterFragment, false);
          if (!isEmptyNode(schema, beforeFragment, { checkRootAsContent: true })) {
            parentNode.insertBefore(beforeFragment, parentElm);
          }
          if (!isEmptyNode(schema, splitElm, { checkRootAsContent: true })) {
            parentNode.insertBefore(splitElm, parentElm);
          }
          if (!isEmptyNode(schema, afterFragment, { checkRootAsContent: true })) {
            parentNode.insertBefore(afterFragment, parentElm);
          }
          parentNode.removeChild(parentElm);
        }
      };
      const splitInvalidChildren = (schema, scope, transparentBlocks) => {
        const blocksElements = schema.getBlockElements();
        const rootNode = SugarElement.fromDom(scope);
        const isBlock2 = (el) => name(el) in blocksElements;
        const isRoot2 = (el) => eq(el, rootNode);
        each$e(fromDom$1(transparentBlocks), (transparentBlock) => {
          ancestor$4(transparentBlock, isBlock2, isRoot2).each((parentBlock) => {
            const invalidChildren = children(transparentBlock, (el) => isBlock2(el) && !schema.isValidChild(name(parentBlock), name(el)));
            if (invalidChildren.length > 0) {
              const stateScope = parentElement(parentBlock);
              each$e(invalidChildren, (child2) => {
                ancestor$4(child2, isBlock2, isRoot2).each((parentBlock2) => {
                  split$2(schema, parentBlock2.dom, child2.dom);
                });
              });
              stateScope.each((scope2) => updateBlockStateOnChildren(schema, scope2.dom));
            }
          });
        });
      };
      const unwrapInvalidChildren = (schema, scope, transparentBlocks) => {
        each$e([
          ...transparentBlocks,
          ...isTransparentBlock(schema, scope) ? [scope] : []
        ], (block) => each$e(descendants(SugarElement.fromDom(block), block.nodeName.toLowerCase()), (elm) => {
          if (isTransparentInline(schema, elm.dom)) {
            unwrap(elm);
          }
        }));
      };
      const updateChildren = (schema, scope) => {
        const transparentBlocks = updateBlockStateOnChildren(schema, scope);
        splitInvalidChildren(schema, scope, transparentBlocks);
        unwrapInvalidChildren(schema, scope, transparentBlocks);
      };
      const updateElement = (schema, target) => {
        if (isTransparentElement(schema, target)) {
          const blocksSelector = makeSelectorFromSchemaMap(schema.getBlockElements());
          updateTransparent(blocksSelector, target);
        }
      };
      const updateCaret = (schema, root, caretParent) => {
        const isRoot2 = (el) => eq(el, SugarElement.fromDom(root));
        const parents2 = parents$1(SugarElement.fromDom(caretParent), isRoot2);
        get$b(parents2, parents2.length - 2).filter(isElement$7).fold(() => updateChildren(schema, root), (scope) => updateChildren(schema, scope.dom));
      };
      const hasBlockAttr = (el) => el.hasAttribute(transparentBlockAttr);
      const isTransparentElementName = (schema, name2) => has$2(schema.getTransparentElements(), name2);
      const isTransparentElement = (schema, node) => isElement$6(node) && isTransparentElementName(schema, node.nodeName);
      const isTransparentBlock = (schema, node) => isTransparentElement(schema, node) && hasBlockAttr(node);
      const isTransparentInline = (schema, node) => isTransparentElement(schema, node) && !hasBlockAttr(node);
      const isTransparentAstBlock = (schema, node) => node.type === 1 && isTransparentElementName(schema, node.name) && isString(node.attr(transparentBlockAttr));
      const browser$2 = detect$1().browser;
      const firstElement = (nodes) => find$2(nodes, isElement$7);
      const getTableCaptionDeltaY = (elm) => {
        if (browser$2.isFirefox() && name(elm) === "table") {
          return firstElement(children$1(elm)).filter((elm2) => {
            return name(elm2) === "caption";
          }).bind((caption) => {
            return firstElement(nextSiblings(caption)).map((body) => {
              const bodyTop = body.dom.offsetTop;
              const captionTop = caption.dom.offsetTop;
              const captionHeight = caption.dom.offsetHeight;
              return bodyTop <= captionTop ? -captionHeight : 0;
            });
          }).getOr(0);
        } else {
          return 0;
        }
      };
      const hasChild = (elm, child2) => elm.children && contains$2(elm.children, child2);
      const getPos = (body, elm, rootElm) => {
        let x = 0, y = 0;
        const doc = body.ownerDocument;
        rootElm = rootElm ? rootElm : body;
        if (elm) {
          if (rootElm === body && elm.getBoundingClientRect && get$7(SugarElement.fromDom(body), "position") === "static") {
            const pos = elm.getBoundingClientRect();
            x = pos.left + (doc.documentElement.scrollLeft || body.scrollLeft) - doc.documentElement.clientLeft;
            y = pos.top + (doc.documentElement.scrollTop || body.scrollTop) - doc.documentElement.clientTop;
            return {
              x,
              y
            };
          }
          let offsetParent = elm;
          while (offsetParent && offsetParent !== rootElm && offsetParent.nodeType && !hasChild(offsetParent, rootElm)) {
            const castOffsetParent = offsetParent;
            x += castOffsetParent.offsetLeft || 0;
            y += castOffsetParent.offsetTop || 0;
            offsetParent = castOffsetParent.offsetParent;
          }
          offsetParent = elm.parentNode;
          while (offsetParent && offsetParent !== rootElm && offsetParent.nodeType && !hasChild(offsetParent, rootElm)) {
            x -= offsetParent.scrollLeft || 0;
            y -= offsetParent.scrollTop || 0;
            offsetParent = offsetParent.parentNode;
          }
          y += getTableCaptionDeltaY(SugarElement.fromDom(elm));
        }
        return {
          x,
          y
        };
      };
      const StyleSheetLoader = (documentOrShadowRoot, settings = {}) => {
        let idCount = 0;
        const loadedStates = {};
        const edos = SugarElement.fromDom(documentOrShadowRoot);
        const doc = documentOrOwner(edos);
        const _setReferrerPolicy = (referrerPolicy) => {
          settings.referrerPolicy = referrerPolicy;
        };
        const _setContentCssCors = (contentCssCors) => {
          settings.contentCssCors = contentCssCors;
        };
        const addStyle = (element) => {
          append$1(getStyleContainer(edos), element);
        };
        const removeStyle = (id) => {
          const styleContainer = getStyleContainer(edos);
          descendant$1(styleContainer, "#" + id).each(remove$4);
        };
        const getOrCreateState = (url) => get$a(loadedStates, url).getOrThunk(() => ({
          id: "mce-u" + idCount++,
          passed: [],
          failed: [],
          count: 0
        }));
        const load = (url) => new Promise((success, failure) => {
          let link;
          const urlWithSuffix = Tools._addCacheSuffix(url);
          const state = getOrCreateState(urlWithSuffix);
          loadedStates[urlWithSuffix] = state;
          state.count++;
          const resolve2 = (callbacks, status) => {
            each$e(callbacks, call);
            state.status = status;
            state.passed = [];
            state.failed = [];
            if (link) {
              link.onload = null;
              link.onerror = null;
              link = null;
            }
          };
          const passed = () => resolve2(state.passed, 2);
          const failed = () => resolve2(state.failed, 3);
          if (success) {
            state.passed.push(success);
          }
          if (failure) {
            state.failed.push(failure);
          }
          if (state.status === 1) {
            return;
          }
          if (state.status === 2) {
            passed();
            return;
          }
          if (state.status === 3) {
            failed();
            return;
          }
          state.status = 1;
          const linkElem = SugarElement.fromTag("link", doc.dom);
          setAll$1(linkElem, {
            rel: "stylesheet",
            type: "text/css",
            id: state.id
          });
          if (settings.contentCssCors) {
            set$4(linkElem, "crossOrigin", "anonymous");
          }
          if (settings.referrerPolicy) {
            set$4(linkElem, "referrerpolicy", settings.referrerPolicy);
          }
          link = linkElem.dom;
          link.onload = passed;
          link.onerror = failed;
          addStyle(linkElem);
          set$4(linkElem, "href", urlWithSuffix);
        });
        const loadRawCss = (key, css) => {
          const state = getOrCreateState(key);
          loadedStates[key] = state;
          state.count++;
          const styleElem = SugarElement.fromTag("style", doc.dom);
          setAll$1(styleElem, {
            "rel": "stylesheet",
            "type": "text/css",
            "id": state.id,
            "data-mce-key": key
          });
          styleElem.dom.innerHTML = css;
          addStyle(styleElem);
        };
        const loadAll = (urls) => {
          const loadedUrls = Promise.allSettled(map$3(urls, (url) => load(url).then(constant(url))));
          return loadedUrls.then((results) => {
            const parts = partition$2(results, (r2) => r2.status === "fulfilled");
            if (parts.fail.length > 0) {
              return Promise.reject(map$3(parts.fail, (result) => result.reason));
            } else {
              return map$3(parts.pass, (result) => result.value);
            }
          });
        };
        const unload = (url) => {
          const urlWithSuffix = Tools._addCacheSuffix(url);
          get$a(loadedStates, urlWithSuffix).each((state) => {
            const count2 = --state.count;
            if (count2 === 0) {
              delete loadedStates[urlWithSuffix];
              removeStyle(state.id);
            }
          });
        };
        const unloadRawCss = (key) => {
          get$a(loadedStates, key).each((state) => {
            const count2 = --state.count;
            if (count2 === 0) {
              delete loadedStates[key];
              removeStyle(state.id);
            }
          });
        };
        const unloadAll = (urls) => {
          each$e(urls, (url) => {
            unload(url);
          });
        };
        return {
          load,
          loadRawCss,
          loadAll,
          unload,
          unloadRawCss,
          unloadAll,
          _setReferrerPolicy,
          _setContentCssCors
        };
      };
      const create$c = () => {
        const map2 = /* @__PURE__ */ new WeakMap();
        const forElement = (referenceElement, settings) => {
          const root = getRootNode(referenceElement);
          const rootDom = root.dom;
          return Optional.from(map2.get(rootDom)).getOrThunk(() => {
            const sl = StyleSheetLoader(rootDom, settings);
            map2.set(rootDom, sl);
            return sl;
          });
        };
        return { forElement };
      };
      const instance = create$c();
      const isSpan = (node) => node.nodeName.toLowerCase() === "span";
      const isInlineContent = (node, schema) => isNonNullable(node) && (isContent$1(schema, node) || schema.isInline(node.nodeName.toLowerCase()));
      const surroundedByInlineContent = (node, root, schema) => {
        const prev2 = new DomTreeWalker(node, root).prev(false);
        const next2 = new DomTreeWalker(node, root).next(false);
        const prevIsInline = isUndefined(prev2) || isInlineContent(prev2, schema);
        const nextIsInline = isUndefined(next2) || isInlineContent(next2, schema);
        return prevIsInline && nextIsInline;
      };
      const isBookmarkNode$2 = (node) => isSpan(node) && node.getAttribute("data-mce-type") === "bookmark";
      const isKeepTextNode = (node, root, schema) => isText$b(node) && node.data.length > 0 && surroundedByInlineContent(node, root, schema);
      const isKeepElement = (node) => isElement$6(node) ? node.childNodes.length > 0 : false;
      const isDocument = (node) => isDocumentFragment(node) || isDocument$1(node);
      const trimNode = (dom2, node, schema, root) => {
        var _a;
        const rootNode = root || node;
        if (isElement$6(node) && isBookmarkNode$2(node)) {
          return node;
        }
        const children2 = node.childNodes;
        for (let i = children2.length - 1; i >= 0; i--) {
          trimNode(dom2, children2[i], schema, rootNode);
        }
        if (isElement$6(node)) {
          const currentChildren = node.childNodes;
          if (currentChildren.length === 1 && isBookmarkNode$2(currentChildren[0])) {
            (_a = node.parentNode) === null || _a === void 0 ? void 0 : _a.insertBefore(currentChildren[0], node);
          }
        }
        if (!isDocument(node) && !isContent$1(schema, node) && !isKeepElement(node) && !isKeepTextNode(node, rootNode, schema)) {
          dom2.remove(node);
        }
        return node;
      };
      const makeMap$3 = Tools.makeMap;
      const attrsCharsRegExp = /[&<>\"\u0060\u007E-\uD7FF\uE000-\uFFEF]|[\uD800-\uDBFF][\uDC00-\uDFFF]/g;
      const textCharsRegExp = /[<>&\u007E-\uD7FF\uE000-\uFFEF]|[\uD800-\uDBFF][\uDC00-\uDFFF]/g;
      const rawCharsRegExp = /[<>&\"\']/g;
      const entityRegExp = /&#([a-z0-9]+);?|&([a-z0-9]+);/gi;
      const asciiMap = {
        128: "€",
        130: "‚",
        131: "ƒ",
        132: "„",
        133: "…",
        134: "†",
        135: "‡",
        136: "ˆ",
        137: "‰",
        138: "Š",
        139: "‹",
        140: "Œ",
        142: "Ž",
        145: "‘",
        146: "’",
        147: "“",
        148: "”",
        149: "•",
        150: "–",
        151: "—",
        152: "˜",
        153: "™",
        154: "š",
        155: "›",
        156: "œ",
        158: "ž",
        159: "Ÿ"
      };
      const baseEntities = {
        '"': "&quot;",
        "'": "&#39;",
        "<": "&lt;",
        ">": "&gt;",
        "&": "&amp;",
        "`": "&#96;"
      };
      const reverseEntities = {
        "&lt;": "<",
        "&gt;": ">",
        "&amp;": "&",
        "&quot;": '"',
        "&apos;": `'`
      };
      const nativeDecode = (text2) => {
        const elm = SugarElement.fromTag("div").dom;
        elm.innerHTML = text2;
        return elm.textContent || elm.innerText || text2;
      };
      const buildEntitiesLookup = (items, radix) => {
        const lookup2 = {};
        if (items) {
          const itemList = items.split(",");
          radix = radix || 10;
          for (let i = 0; i < itemList.length; i += 2) {
            const chr = String.fromCharCode(parseInt(itemList[i], radix));
            if (!baseEntities[chr]) {
              const entity = "&" + itemList[i + 1] + ";";
              lookup2[chr] = entity;
              lookup2[entity] = chr;
            }
          }
          return lookup2;
        } else {
          return void 0;
        }
      };
      const namedEntities = buildEntitiesLookup("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro", 32);
      const encodeRaw = (text2, attr) => text2.replace(attr ? attrsCharsRegExp : textCharsRegExp, (chr) => {
        return baseEntities[chr] || chr;
      });
      const encodeAllRaw = (text2) => ("" + text2).replace(rawCharsRegExp, (chr) => {
        return baseEntities[chr] || chr;
      });
      const encodeNumeric = (text2, attr) => text2.replace(attr ? attrsCharsRegExp : textCharsRegExp, (chr) => {
        if (chr.length > 1) {
          return "&#" + ((chr.charCodeAt(0) - 55296) * 1024 + (chr.charCodeAt(1) - 56320) + 65536) + ";";
        }
        return baseEntities[chr] || "&#" + chr.charCodeAt(0) + ";";
      });
      const encodeNamed = (text2, attr, entities) => {
        const resolveEntities = entities || namedEntities;
        return text2.replace(attr ? attrsCharsRegExp : textCharsRegExp, (chr) => {
          return baseEntities[chr] || resolveEntities[chr] || chr;
        });
      };
      const getEncodeFunc = (name2, entities) => {
        const entitiesMap = buildEntitiesLookup(entities) || namedEntities;
        const encodeNamedAndNumeric = (text2, attr) => text2.replace(attr ? attrsCharsRegExp : textCharsRegExp, (chr) => {
          if (baseEntities[chr] !== void 0) {
            return baseEntities[chr];
          }
          if (entitiesMap[chr] !== void 0) {
            return entitiesMap[chr];
          }
          if (chr.length > 1) {
            return "&#" + ((chr.charCodeAt(0) - 55296) * 1024 + (chr.charCodeAt(1) - 56320) + 65536) + ";";
          }
          return "&#" + chr.charCodeAt(0) + ";";
        });
        const encodeCustomNamed = (text2, attr) => {
          return encodeNamed(text2, attr, entitiesMap);
        };
        const nameMap = makeMap$3(name2.replace(/\+/g, ","));
        if (nameMap.named && nameMap.numeric) {
          return encodeNamedAndNumeric;
        }
        if (nameMap.named) {
          if (entities) {
            return encodeCustomNamed;
          }
          return encodeNamed;
        }
        if (nameMap.numeric) {
          return encodeNumeric;
        }
        return encodeRaw;
      };
      const decode = (text2) => text2.replace(entityRegExp, (all2, numeric) => {
        if (numeric) {
          if (numeric.charAt(0).toLowerCase() === "x") {
            numeric = parseInt(numeric.substr(1), 16);
          } else {
            numeric = parseInt(numeric, 10);
          }
          if (numeric > 65535) {
            numeric -= 65536;
            return String.fromCharCode(55296 + (numeric >> 10), 56320 + (numeric & 1023));
          }
          return asciiMap[numeric] || String.fromCharCode(numeric);
        }
        return reverseEntities[all2] || namedEntities[all2] || nativeDecode(all2);
      });
      const Entities = {
        encodeRaw,
        encodeAllRaw,
        encodeNumeric,
        encodeNamed,
        getEncodeFunc,
        decode
      };
      const split$1 = (items, delim) => {
        items = Tools.trim(items);
        return items ? items.split(delim || " ") : [];
      };
      const patternToRegExp = (str) => new RegExp("^" + str.replace(/([?+*])/g, ".$1") + "$");
      const isRegExp$1 = (obj) => isObject(obj) && obj.source && Object.prototype.toString.call(obj) === "[object RegExp]";
      const deepCloneElementRule = (obj) => {
        const helper = (value2) => {
          if (isArray$1(value2)) {
            return map$3(value2, helper);
          } else if (isRegExp$1(value2)) {
            return new RegExp(value2.source, value2.flags);
          } else if (isObject(value2)) {
            return map$2(value2, helper);
          } else {
            return value2;
          }
        };
        return helper(obj);
      };
      const parseCustomElementsRules = (value2) => {
        const customElementRegExp = /^(~)?(.+)$/;
        return bind$3(split$1(value2, ","), (rule) => {
          const matches = customElementRegExp.exec(rule);
          if (matches) {
            const inline = matches[1] === "~";
            const cloneName = inline ? "span" : "div";
            const name2 = matches[2];
            return [{
              cloneName,
              name: name2
            }];
          } else {
            return [];
          }
        });
      };
      const getGlobalAttributeSet = (type2) => {
        return Object.freeze([
          "id",
          "accesskey",
          "class",
          "dir",
          "lang",
          "style",
          "tabindex",
          "title",
          "role",
          ...type2 !== "html4" ? [
            "contenteditable",
            "contextmenu",
            "draggable",
            "dropzone",
            "hidden",
            "spellcheck",
            "translate",
            "itemprop",
            "itemscope",
            "itemtype"
          ] : [],
          ...type2 !== "html5-strict" ? ["xml:lang"] : []
        ]);
      };
      const getElementSetsAsStrings = (type2) => {
        let blockContent;
        let phrasingContent;
        blockContent = "address blockquote div dl fieldset form h1 h2 h3 h4 h5 h6 hr menu ol p pre table ul";
        phrasingContent = "a abbr b bdo br button cite code del dfn em embed i iframe img input ins kbd label map noscript object q s samp script select small span strong sub sup textarea u var #text #comment";
        if (type2 !== "html4") {
          const transparentContent = "a ins del canvas map";
          blockContent += " article aside details dialog figure main header footer hgroup section nav " + transparentContent;
          phrasingContent += " audio canvas command data datalist mark meter output picture progress time wbr video ruby bdi keygen svg";
        }
        if (type2 !== "html5-strict") {
          const html4PhrasingContent = "acronym applet basefont big font strike tt";
          phrasingContent = [
            phrasingContent,
            html4PhrasingContent
          ].join(" ");
          const html4BlockContent = "center dir isindex noframes";
          blockContent = [
            blockContent,
            html4BlockContent
          ].join(" ");
        }
        const flowContent = [
          blockContent,
          phrasingContent
        ].join(" ");
        return {
          blockContent,
          phrasingContent,
          flowContent
        };
      };
      const getElementSets = (type2) => {
        const { blockContent, phrasingContent, flowContent } = getElementSetsAsStrings(type2);
        const toArr = (value2) => {
          return Object.freeze(value2.split(" "));
        };
        return Object.freeze({
          blockContent: toArr(blockContent),
          phrasingContent: toArr(phrasingContent),
          flowContent: toArr(flowContent)
        });
      };
      const cachedSets = {
        "html4": cached(() => getElementSets("html4")),
        "html5": cached(() => getElementSets("html5")),
        "html5-strict": cached(() => getElementSets("html5-strict"))
      };
      const getElementsPreset = (type2, name2) => {
        const { blockContent, phrasingContent, flowContent } = cachedSets[type2]();
        if (name2 === "blocks") {
          return Optional.some(blockContent);
        } else if (name2 === "phrasing") {
          return Optional.some(phrasingContent);
        } else if (name2 === "flow") {
          return Optional.some(flowContent);
        } else {
          return Optional.none();
        }
      };
      const makeSchema = (type2) => {
        const globalAttributes = getGlobalAttributeSet(type2);
        const { phrasingContent, flowContent } = getElementSetsAsStrings(type2);
        const schema = {};
        const addElement = (name2, attributes, children2) => {
          schema[name2] = {
            attributes: mapToObject(attributes, constant({})),
            attributesOrder: attributes,
            children: mapToObject(children2, constant({}))
          };
        };
        const add2 = (name2, attributes = "", children2 = "") => {
          const childNames = split$1(children2);
          const names = split$1(name2);
          let ni = names.length;
          const allAttributes = [
            ...globalAttributes,
            ...split$1(attributes)
          ];
          while (ni--) {
            addElement(names[ni], allAttributes.slice(), childNames);
          }
        };
        const addAttrs = (name2, attributes) => {
          const names = split$1(name2);
          const attrs = split$1(attributes);
          let ni = names.length;
          while (ni--) {
            const schemaItem = schema[names[ni]];
            for (let i = 0, l = attrs.length; i < l; i++) {
              schemaItem.attributes[attrs[i]] = {};
              schemaItem.attributesOrder.push(attrs[i]);
            }
          }
        };
        if (type2 !== "html5-strict") {
          const html4PhrasingContent = "acronym applet basefont big font strike tt";
          each$e(split$1(html4PhrasingContent), (name2) => {
            add2(name2, "", phrasingContent);
          });
          const html4BlockContent = "center dir isindex noframes";
          each$e(split$1(html4BlockContent), (name2) => {
            add2(name2, "", flowContent);
          });
        }
        add2("html", "manifest", "head body");
        add2("head", "", "base command link meta noscript script style title");
        add2("title hr noscript br");
        add2("base", "href target");
        add2("link", "href rel media hreflang type sizes hreflang");
        add2("meta", "name http-equiv content charset");
        add2("style", "media type scoped");
        add2("script", "src async defer type charset");
        add2("body", "onafterprint onbeforeprint onbeforeunload onblur onerror onfocus onhashchange onload onmessage onoffline ononline onpagehide onpageshow onpopstate onresize onscroll onstorage onunload", flowContent);
        add2("dd div", "", flowContent);
        add2("address dt caption", "", type2 === "html4" ? phrasingContent : flowContent);
        add2("h1 h2 h3 h4 h5 h6 pre p abbr code var samp kbd sub sup i b u bdo span legend em strong small s cite dfn", "", phrasingContent);
        add2("blockquote", "cite", flowContent);
        add2("ol", "reversed start type", "li");
        add2("ul", "", "li");
        add2("li", "value", flowContent);
        add2("dl", "", "dt dd");
        add2("a", "href target rel media hreflang type", type2 === "html4" ? phrasingContent : flowContent);
        add2("q", "cite", phrasingContent);
        add2("ins del", "cite datetime", flowContent);
        add2("img", "src sizes srcset alt usemap ismap width height");
        add2("iframe", "src name width height", flowContent);
        add2("embed", "src type width height");
        add2("object", "data type typemustmatch name usemap form width height", [
          flowContent,
          "param"
        ].join(" "));
        add2("param", "name value");
        add2("map", "name", [
          flowContent,
          "area"
        ].join(" "));
        add2("area", "alt coords shape href target rel media hreflang type");
        add2("table", "border", "caption colgroup thead tfoot tbody tr" + (type2 === "html4" ? " col" : ""));
        add2("colgroup", "span", "col");
        add2("col", "span");
        add2("tbody thead tfoot", "", "tr");
        add2("tr", "", "td th");
        add2("td", "colspan rowspan headers", flowContent);
        add2("th", "colspan rowspan headers scope abbr", flowContent);
        add2("form", "accept-charset action autocomplete enctype method name novalidate target", flowContent);
        add2("fieldset", "disabled form name", [
          flowContent,
          "legend"
        ].join(" "));
        add2("label", "form for", phrasingContent);
        add2("input", "accept alt autocomplete checked dirname disabled form formaction formenctype formmethod formnovalidate formtarget height list max maxlength min multiple name pattern readonly required size src step type value width");
        add2("button", "disabled form formaction formenctype formmethod formnovalidate formtarget name type value", type2 === "html4" ? flowContent : phrasingContent);
        add2("select", "disabled form multiple name required size", "option optgroup");
        add2("optgroup", "disabled label", "option");
        add2("option", "disabled label selected value");
        add2("textarea", "cols dirname disabled form maxlength name readonly required rows wrap");
        add2("menu", "type label", [
          flowContent,
          "li"
        ].join(" "));
        add2("noscript", "", flowContent);
        if (type2 !== "html4") {
          add2("wbr");
          add2("ruby", "", [
            phrasingContent,
            "rt rp"
          ].join(" "));
          add2("figcaption", "", flowContent);
          add2("mark rt rp bdi", "", phrasingContent);
          add2("summary", "", [
            phrasingContent,
            "h1 h2 h3 h4 h5 h6"
          ].join(" "));
          add2("canvas", "width height", flowContent);
          add2("data", "value", phrasingContent);
          add2("video", "src crossorigin poster preload autoplay mediagroup loop muted controls width height buffered", [
            flowContent,
            "track source"
          ].join(" "));
          add2("audio", "src crossorigin preload autoplay mediagroup loop muted controls buffered volume", [
            flowContent,
            "track source"
          ].join(" "));
          add2("picture", "", "img source");
          add2("source", "src srcset type media sizes");
          add2("track", "kind src srclang label default");
          add2("datalist", "", [
            phrasingContent,
            "option"
          ].join(" "));
          add2("article section nav aside main header footer", "", flowContent);
          add2("hgroup", "", "h1 h2 h3 h4 h5 h6");
          add2("figure", "", [
            flowContent,
            "figcaption"
          ].join(" "));
          add2("time", "datetime", phrasingContent);
          add2("dialog", "open", flowContent);
          add2("command", "type label icon disabled checked radiogroup command");
          add2("output", "for form name", phrasingContent);
          add2("progress", "value max", phrasingContent);
          add2("meter", "value min max low high optimum", phrasingContent);
          add2("details", "open", [
            flowContent,
            "summary"
          ].join(" "));
          add2("keygen", "autofocus challenge disabled form keytype name");
          addElement("svg", "id tabindex lang xml:space class style x y width height viewBox preserveAspectRatio zoomAndPan transform".split(" "), []);
        }
        if (type2 !== "html5-strict") {
          addAttrs("script", "language xml:space");
          addAttrs("style", "xml:space");
          addAttrs("object", "declare classid code codebase codetype archive standby align border hspace vspace");
          addAttrs("embed", "align name hspace vspace");
          addAttrs("param", "valuetype type");
          addAttrs("a", "charset name rev shape coords");
          addAttrs("br", "clear");
          addAttrs("applet", "codebase archive code object alt name width height align hspace vspace");
          addAttrs("img", "name longdesc align border hspace vspace");
          addAttrs("iframe", "longdesc frameborder marginwidth marginheight scrolling align");
          addAttrs("font basefont", "size color face");
          addAttrs("input", "usemap align");
          addAttrs("select");
          addAttrs("textarea");
          addAttrs("h1 h2 h3 h4 h5 h6 div p legend caption", "align");
          addAttrs("ul", "type compact");
          addAttrs("li", "type");
          addAttrs("ol dl menu dir", "compact");
          addAttrs("pre", "width xml:space");
          addAttrs("hr", "align noshade size width");
          addAttrs("isindex", "prompt");
          addAttrs("table", "summary width frame rules cellspacing cellpadding align bgcolor");
          addAttrs("col", "width align char charoff valign");
          addAttrs("colgroup", "width align char charoff valign");
          addAttrs("thead", "align char charoff valign");
          addAttrs("tr", "align char charoff valign bgcolor");
          addAttrs("th", "axis align char charoff valign nowrap bgcolor width height");
          addAttrs("form", "accept");
          addAttrs("td", "abbr axis scope align char charoff valign nowrap bgcolor width height");
          addAttrs("tfoot", "align char charoff valign");
          addAttrs("tbody", "align char charoff valign");
          addAttrs("area", "nohref");
          addAttrs("body", "background bgcolor text link vlink alink");
        }
        if (type2 !== "html4") {
          addAttrs("input button select textarea", "autofocus");
          addAttrs("input textarea", "placeholder");
          addAttrs("a", "download");
          addAttrs("link script img", "crossorigin");
          addAttrs("img", "loading");
          addAttrs("iframe", "sandbox seamless allow allowfullscreen loading referrerpolicy");
        }
        if (type2 !== "html4") {
          each$e([
            schema.video,
            schema.audio
          ], (item) => {
            delete item.children.audio;
            delete item.children.video;
          });
        }
        each$e(split$1("a form meter progress dfn"), (name2) => {
          if (schema[name2]) {
            delete schema[name2].children[name2];
          }
        });
        delete schema.caption.children.table;
        delete schema.script;
        return schema;
      };
      const prefixToOperation = (prefix) => prefix === "-" ? "remove" : "add";
      const parseValidChild = (name2) => {
        const validChildRegExp = /^(@?)([A-Za-z0-9_\-.\u00b7\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u037d\u037f-\u1fff\u200c-\u200d\u203f-\u2040\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]+)$/;
        return Optional.from(validChildRegExp.exec(name2)).map((matches) => ({
          preset: matches[1] === "@",
          name: matches[2]
        }));
      };
      const parseValidChildrenRules = (value2) => {
        const childRuleRegExp = /^([+\-]?)([A-Za-z0-9_\-.\u00b7\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u037d\u037f-\u1fff\u200c-\u200d\u203f-\u2040\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]+)\[([^\]]+)]$/;
        return bind$3(split$1(value2, ","), (rule) => {
          const matches = childRuleRegExp.exec(rule);
          if (matches) {
            const prefix = matches[1];
            const operation = prefix ? prefixToOperation(prefix) : "replace";
            const name2 = matches[2];
            const validChildren = bind$3(split$1(matches[3], "|"), (validChild) => parseValidChild(validChild).toArray());
            return [{
              operation,
              name: name2,
              validChildren
            }];
          } else {
            return [];
          }
        });
      };
      const parseValidElementsAttrDataIntoElement = (attrData, targetElement) => {
        const attrRuleRegExp = /^([!\-])?(\w+[\\:]:\w+|[^=~<]+)?(?:([=~<])(.*))?$/;
        const hasPatternsRegExp = /[*?+]/;
        const { attributes, attributesOrder } = targetElement;
        return each$e(split$1(attrData, "|"), (rule) => {
          const matches = attrRuleRegExp.exec(rule);
          if (matches) {
            const attr = {};
            const attrType = matches[1];
            const attrName = matches[2].replace(/[\\:]:/g, ":");
            const attrPrefix = matches[3];
            const value2 = matches[4];
            if (attrType === "!") {
              targetElement.attributesRequired = targetElement.attributesRequired || [];
              targetElement.attributesRequired.push(attrName);
              attr.required = true;
            }
            if (attrType === "-") {
              delete attributes[attrName];
              attributesOrder.splice(Tools.inArray(attributesOrder, attrName), 1);
              return;
            }
            if (attrPrefix) {
              if (attrPrefix === "=") {
                targetElement.attributesDefault = targetElement.attributesDefault || [];
                targetElement.attributesDefault.push({
                  name: attrName,
                  value: value2
                });
                attr.defaultValue = value2;
              } else if (attrPrefix === "~") {
                targetElement.attributesForced = targetElement.attributesForced || [];
                targetElement.attributesForced.push({
                  name: attrName,
                  value: value2
                });
                attr.forcedValue = value2;
              } else if (attrPrefix === "<") {
                attr.validValues = Tools.makeMap(value2, "?");
              }
            }
            if (hasPatternsRegExp.test(attrName)) {
              const attrPattern = attr;
              targetElement.attributePatterns = targetElement.attributePatterns || [];
              attrPattern.pattern = patternToRegExp(attrName);
              targetElement.attributePatterns.push(attrPattern);
            } else {
              if (!attributes[attrName]) {
                attributesOrder.push(attrName);
              }
              attributes[attrName] = attr;
            }
          }
        });
      };
      const cloneAttributesInto = (from2, to2) => {
        each$d(from2.attributes, (value2, key) => {
          to2.attributes[key] = value2;
        });
        to2.attributesOrder.push(...from2.attributesOrder);
      };
      const parseValidElementsRules = (globalElement, validElements) => {
        const elementRuleRegExp = /^([#+\-])?([^\[!\/]+)(?:\/([^\[!]+))?(?:(!?)\[([^\]]+)])?$/;
        return bind$3(split$1(validElements, ","), (rule) => {
          const matches = elementRuleRegExp.exec(rule);
          if (matches) {
            const prefix = matches[1];
            const elementName = matches[2];
            const outputName = matches[3];
            const attrsPrefix = matches[4];
            const attrData = matches[5];
            const element = {
              attributes: {},
              attributesOrder: []
            };
            globalElement.each((el) => cloneAttributesInto(el, element));
            if (prefix === "#") {
              element.paddEmpty = true;
            } else if (prefix === "-") {
              element.removeEmpty = true;
            }
            if (attrsPrefix === "!") {
              element.removeEmptyAttrs = true;
            }
            if (attrData) {
              parseValidElementsAttrDataIntoElement(attrData, element);
            }
            if (outputName) {
              element.outputName = elementName;
            }
            if (elementName === "@") {
              if (globalElement.isNone()) {
                globalElement = Optional.some(element);
              } else {
                return [];
              }
            }
            return [outputName ? {
              name: elementName,
              element,
              aliasName: outputName
            } : {
              name: elementName,
              element
            }];
          } else {
            return [];
          }
        });
      };
      const mapCache = {};
      const makeMap$2 = Tools.makeMap, each$b = Tools.each, extend$2 = Tools.extend, explode$2 = Tools.explode;
      const createMap = (defaultValue, extendWith = {}) => {
        const value2 = makeMap$2(defaultValue, " ", makeMap$2(defaultValue.toUpperCase(), " "));
        return extend$2(value2, extendWith);
      };
      const getTextRootBlockElements = (schema) => createMap("td th li dt dd figcaption caption details summary", schema.getTextBlockElements());
      const compileElementMap = (value2, mode) => {
        if (value2) {
          const styles = {};
          if (isString(value2)) {
            value2 = { "*": value2 };
          }
          each$b(value2, (value3, key) => {
            styles[key] = styles[key.toUpperCase()] = mode === "map" ? makeMap$2(value3, /[, ]/) : explode$2(value3, /[, ]/);
          });
          return styles;
        } else {
          return void 0;
        }
      };
      const Schema = (settings = {}) => {
        var _a;
        const elements = {};
        const children2 = {};
        let patternElements = [];
        const customElementsMap = {};
        const specialElements = {};
        const createLookupTable = (option2, defaultValue, extendWith) => {
          const value2 = settings[option2];
          if (!value2) {
            let newValue = mapCache[option2];
            if (!newValue) {
              newValue = createMap(defaultValue, extendWith);
              mapCache[option2] = newValue;
            }
            return newValue;
          } else {
            return makeMap$2(value2, /[, ]/, makeMap$2(value2.toUpperCase(), /[, ]/));
          }
        };
        const schemaType = (_a = settings.schema) !== null && _a !== void 0 ? _a : "html5";
        const schemaItems = makeSchema(schemaType);
        if (settings.verify_html === false) {
          settings.valid_elements = "*[*]";
        }
        const validStyles = compileElementMap(settings.valid_styles);
        const invalidStyles = compileElementMap(settings.invalid_styles, "map");
        const validClasses = compileElementMap(settings.valid_classes, "map");
        const whitespaceElementsMap = createLookupTable("whitespace_elements", "pre script noscript style textarea video audio iframe object code");
        const selfClosingElementsMap = createLookupTable("self_closing_elements", "colgroup dd dt li option p td tfoot th thead tr");
        const voidElementsMap = createLookupTable("void_elements", "area base basefont br col frame hr img input isindex link meta param embed source wbr track");
        const boolAttrMap = createLookupTable("boolean_attributes", "checked compact declare defer disabled ismap multiple nohref noresize noshade nowrap readonly selected autoplay loop controls allowfullscreen");
        const nonEmptyOrMoveCaretBeforeOnEnter = "td th iframe video audio object script code";
        const nonEmptyElementsMap = createLookupTable("non_empty_elements", nonEmptyOrMoveCaretBeforeOnEnter + " pre svg textarea summary", voidElementsMap);
        const moveCaretBeforeOnEnterElementsMap = createLookupTable("move_caret_before_on_enter_elements", nonEmptyOrMoveCaretBeforeOnEnter + " table", voidElementsMap);
        const headings = "h1 h2 h3 h4 h5 h6";
        const textBlockElementsMap = createLookupTable("text_block_elements", headings + " p div address pre form blockquote center dir fieldset header footer article section hgroup aside main nav figure");
        const blockElementsMap = createLookupTable("block_elements", "hr table tbody thead tfoot th tr td li ol ul caption dl dt dd noscript menu isindex option datalist select optgroup figcaption details summary html body multicol listing", textBlockElementsMap);
        const textInlineElementsMap = createLookupTable("text_inline_elements", "span strong b em i font s strike u var cite dfn code mark q sup sub samp");
        const transparentElementsMap = createLookupTable("transparent_elements", "a ins del canvas map");
        const wrapBlockElementsMap = createLookupTable("wrap_block_elements", "pre " + headings);
        each$b("script noscript iframe noframes noembed title style textarea xmp plaintext".split(" "), (name2) => {
          specialElements[name2] = new RegExp("</" + name2 + "[^>]*>", "gi");
        });
        const addValidElements = (validElements) => {
          const globalElement = Optional.from(elements["@"]);
          const hasPatternsRegExp = /[*?+]/;
          each$e(parseValidElementsRules(globalElement, validElements !== null && validElements !== void 0 ? validElements : ""), ({ name: name2, element, aliasName }) => {
            if (aliasName) {
              elements[aliasName] = element;
            }
            if (hasPatternsRegExp.test(name2)) {
              const patternElement = element;
              patternElement.pattern = patternToRegExp(name2);
              patternElements.push(patternElement);
            } else {
              elements[name2] = element;
            }
          });
        };
        const setValidElements = (validElements) => {
          patternElements = [];
          each$e(keys(elements), (name2) => {
            delete elements[name2];
          });
          addValidElements(validElements);
        };
        const addCustomElement = (name2, spec) => {
          var _a2, _b;
          delete mapCache.text_block_elements;
          delete mapCache.block_elements;
          const inline = spec.extends ? !isBlock2(spec.extends) : false;
          const cloneName = spec.extends;
          children2[name2] = cloneName ? children2[cloneName] : {};
          customElementsMap[name2] = cloneName !== null && cloneName !== void 0 ? cloneName : name2;
          nonEmptyElementsMap[name2.toUpperCase()] = {};
          nonEmptyElementsMap[name2] = {};
          if (!inline) {
            blockElementsMap[name2.toUpperCase()] = {};
            blockElementsMap[name2] = {};
          }
          if (cloneName && !elements[name2] && elements[cloneName]) {
            const customRule = deepCloneElementRule(elements[cloneName]);
            delete customRule.removeEmptyAttrs;
            delete customRule.removeEmpty;
            elements[name2] = customRule;
          } else {
            elements[name2] = {
              attributesOrder: [],
              attributes: {}
            };
          }
          if (isArray$1(spec.attributes)) {
            const processAttrName = (name3) => {
              customRule.attributesOrder.push(name3);
              customRule.attributes[name3] = {};
            };
            const customRule = (_a2 = elements[name2]) !== null && _a2 !== void 0 ? _a2 : {};
            delete customRule.attributesDefault;
            delete customRule.attributesForced;
            delete customRule.attributePatterns;
            delete customRule.attributesRequired;
            customRule.attributesOrder = [];
            customRule.attributes = {};
            each$e(spec.attributes, (attrName) => {
              const globalAttrs = getGlobalAttributeSet(schemaType);
              parseValidChild(attrName).each(({ preset, name: name3 }) => {
                if (preset) {
                  if (name3 === "global") {
                    each$e(globalAttrs, processAttrName);
                  }
                } else {
                  processAttrName(name3);
                }
              });
            });
            elements[name2] = customRule;
          }
          if (isBoolean(spec.padEmpty)) {
            const customRule = (_b = elements[name2]) !== null && _b !== void 0 ? _b : {};
            customRule.paddEmpty = spec.padEmpty;
            elements[name2] = customRule;
          }
          if (isArray$1(spec.children)) {
            const customElementChildren = {};
            const processNodeName = (name3) => {
              customElementChildren[name3] = {};
            };
            const processPreset = (name3) => {
              getElementsPreset(schemaType, name3).each((names) => {
                each$e(names, processNodeName);
              });
            };
            each$e(spec.children, (child2) => {
              parseValidChild(child2).each(({ preset, name: name3 }) => {
                if (preset) {
                  processPreset(name3);
                } else {
                  processNodeName(name3);
                }
              });
            });
            children2[name2] = customElementChildren;
          }
          if (cloneName) {
            each$d(children2, (element, elmName) => {
              if (element[cloneName]) {
                children2[elmName] = element = extend$2({}, children2[elmName]);
                element[name2] = element[cloneName];
              }
            });
          }
        };
        const addCustomElementsFromString = (customElements) => {
          each$e(parseCustomElementsRules(customElements !== null && customElements !== void 0 ? customElements : ""), ({ name: name2, cloneName }) => {
            addCustomElement(name2, { extends: cloneName });
          });
        };
        const addCustomElements = (customElements) => {
          if (isObject(customElements)) {
            each$d(customElements, (spec, name2) => addCustomElement(name2, spec));
          } else if (isString(customElements)) {
            addCustomElementsFromString(customElements);
          }
        };
        const addValidChildren = (validChildren) => {
          each$e(parseValidChildrenRules(validChildren !== null && validChildren !== void 0 ? validChildren : ""), ({ operation, name: name2, validChildren: validChildren2 }) => {
            const parent2 = operation === "replace" ? { "#comment": {} } : children2[name2];
            const processNodeName = (name3) => {
              if (operation === "remove") {
                delete parent2[name3];
              } else {
                parent2[name3] = {};
              }
            };
            const processPreset = (name3) => {
              getElementsPreset(schemaType, name3).each((names) => {
                each$e(names, processNodeName);
              });
            };
            each$e(validChildren2, ({ preset, name: name3 }) => {
              if (preset) {
                processPreset(name3);
              } else {
                processNodeName(name3);
              }
            });
            children2[name2] = parent2;
          });
        };
        const getElementRule = (name2) => {
          const element = elements[name2];
          if (element) {
            return element;
          }
          let i = patternElements.length;
          while (i--) {
            const patternElement = patternElements[i];
            if (patternElement.pattern.test(name2)) {
              return patternElement;
            }
          }
          return void 0;
        };
        const setup2 = () => {
          if (!settings.valid_elements) {
            each$b(schemaItems, (element, name2) => {
              elements[name2] = {
                attributes: element.attributes,
                attributesOrder: element.attributesOrder
              };
              children2[name2] = element.children;
            });
            each$b(split$1("strong/b em/i"), (item) => {
              const items = split$1(item, "/");
              elements[items[1]].outputName = items[0];
            });
            each$b(textInlineElementsMap, (_val, name2) => {
              if (elements[name2]) {
                if (settings.padd_empty_block_inline_children) {
                  elements[name2].paddInEmptyBlock = true;
                }
                elements[name2].removeEmpty = true;
              }
            });
            each$b(split$1("ol ul blockquote a table tbody"), (name2) => {
              if (elements[name2]) {
                elements[name2].removeEmpty = true;
              }
            });
            each$b(split$1("p h1 h2 h3 h4 h5 h6 th td pre div address caption li summary"), (name2) => {
              if (elements[name2]) {
                elements[name2].paddEmpty = true;
              }
            });
            each$b(split$1("span"), (name2) => {
              elements[name2].removeEmptyAttrs = true;
            });
          } else {
            setValidElements(settings.valid_elements);
            each$b(schemaItems, (element, name2) => {
              children2[name2] = element.children;
            });
          }
          delete elements.svg;
          addCustomElements(settings.custom_elements);
          addValidChildren(settings.valid_children);
          addValidElements(settings.extended_valid_elements);
          addValidChildren("+ol[ul|ol],+ul[ul|ol]");
          each$b({
            dd: "dl",
            dt: "dl",
            li: "ul ol",
            td: "tr",
            th: "tr",
            tr: "tbody thead tfoot",
            tbody: "table",
            thead: "table",
            tfoot: "table",
            legend: "fieldset",
            area: "map",
            param: "video audio object"
          }, (parents2, item) => {
            if (elements[item]) {
              elements[item].parentsRequired = split$1(parents2);
            }
          });
          if (settings.invalid_elements) {
            each$b(explode$2(settings.invalid_elements), (item) => {
              if (elements[item]) {
                delete elements[item];
              }
            });
          }
          if (!getElementRule("span")) {
            addValidElements("span[!data-mce-type|*]");
          }
        };
        const getValidStyles = constant(validStyles);
        const getInvalidStyles = constant(invalidStyles);
        const getValidClasses = constant(validClasses);
        const getBoolAttrs = constant(boolAttrMap);
        const getBlockElements = constant(blockElementsMap);
        const getTextBlockElements = constant(textBlockElementsMap);
        const getTextInlineElements = constant(textInlineElementsMap);
        const getVoidElements = constant(Object.seal(voidElementsMap));
        const getSelfClosingElements = constant(selfClosingElementsMap);
        const getNonEmptyElements = constant(nonEmptyElementsMap);
        const getMoveCaretBeforeOnEnterElements = constant(moveCaretBeforeOnEnterElementsMap);
        const getWhitespaceElements = constant(whitespaceElementsMap);
        const getTransparentElements = constant(transparentElementsMap);
        const getWrapBlockElements = constant(wrapBlockElementsMap);
        const getSpecialElements = constant(Object.seal(specialElements));
        const isValidChild = (name2, child2) => {
          const parent2 = children2[name2.toLowerCase()];
          return !!(parent2 && parent2[child2.toLowerCase()]);
        };
        const isValid2 = (name2, attr) => {
          const rule = getElementRule(name2);
          if (rule) {
            if (attr) {
              if (rule.attributes[attr]) {
                return true;
              }
              const attrPatterns = rule.attributePatterns;
              if (attrPatterns) {
                let i = attrPatterns.length;
                while (i--) {
                  if (attrPatterns[i].pattern.test(attr)) {
                    return true;
                  }
                }
              }
            } else {
              return true;
            }
          }
          return false;
        };
        const isBlock2 = (name2) => has$2(getBlockElements(), name2);
        const isInline2 = (name2) => !startsWith(name2, "#") && isValid2(name2) && !isBlock2(name2);
        const isWrapper = (name2) => has$2(getWrapBlockElements(), name2) || isInline2(name2);
        const getCustomElements = constant(customElementsMap);
        setup2();
        return {
          type: schemaType,
          children: children2,
          elements,
          getValidStyles,
          getValidClasses,
          getBlockElements,
          getInvalidStyles,
          getVoidElements,
          getTextBlockElements,
          getTextInlineElements,
          getBoolAttrs,
          getElementRule,
          getSelfClosingElements,
          getNonEmptyElements,
          getMoveCaretBeforeOnEnterElements,
          getWhitespaceElements,
          getTransparentElements,
          getSpecialElements,
          isValidChild,
          isValid: isValid2,
          isBlock: isBlock2,
          isInline: isInline2,
          isWrapper,
          getCustomElements,
          addValidElements,
          setValidElements,
          addCustomElements,
          addValidChildren
        };
      };
      const hexColour = (value2) => ({ value: normalizeHex(value2) });
      const normalizeHex = (hex) => removeLeading(hex, "#").toUpperCase();
      const toHex = (component) => {
        const hex = component.toString(16);
        return (hex.length === 1 ? "0" + hex : hex).toUpperCase();
      };
      const fromRgba = (rgbaColour2) => {
        const value2 = toHex(rgbaColour2.red) + toHex(rgbaColour2.green) + toHex(rgbaColour2.blue);
        return hexColour(value2);
      };
      const rgbRegex = /^\s*rgb\s*\(\s*(\d+)\s*[,\s]\s*(\d+)\s*[,\s]\s*(\d+)\s*\)\s*$/i;
      const rgbaRegex = /^\s*rgba\s*\(\s*(\d+)\s*[,\s]\s*(\d+)\s*[,\s]\s*(\d+)\s*[,\s]\s*((?:\d?\.\d+|\d+)%?)\s*\)\s*$/i;
      const rgbaColour = (red, green, blue, alpha) => ({
        red,
        green,
        blue,
        alpha
      });
      const fromStringValues = (red, green, blue, alpha) => {
        const r2 = parseInt(red, 10);
        const g = parseInt(green, 10);
        const b = parseInt(blue, 10);
        const a = parseFloat(alpha);
        return rgbaColour(r2, g, b, a);
      };
      const getColorFormat = (colorString) => {
        if (rgbRegex.test(colorString)) {
          return "rgb";
        } else if (rgbaRegex.test(colorString)) {
          return "rgba";
        }
        return "other";
      };
      const fromString = (rgbaString) => {
        const rgbMatch = rgbRegex.exec(rgbaString);
        if (rgbMatch !== null) {
          return Optional.some(fromStringValues(rgbMatch[1], rgbMatch[2], rgbMatch[3], "1"));
        }
        const rgbaMatch = rgbaRegex.exec(rgbaString);
        if (rgbaMatch !== null) {
          return Optional.some(fromStringValues(rgbaMatch[1], rgbaMatch[2], rgbaMatch[3], rgbaMatch[4]));
        }
        return Optional.none();
      };
      const toString = (rgba) => `rgba(${rgba.red},${rgba.green},${rgba.blue},${rgba.alpha})`;
      const rgbaToHexString = (color) => fromString(color).map(fromRgba).map((h) => "#" + h.value).getOr(color);
      const Styles = (settings = {}, schema) => {
        const urlOrStrRegExp = /(?:url(?:(?:\(\s*\"([^\"]+)\"\s*\))|(?:\(\s*\'([^\']+)\'\s*\))|(?:\(\s*([^)\s]+)\s*\))))|(?:\'([^\']+)\')|(?:\"([^\"]+)\")/gi;
        const styleRegExp = /\s*([^:]+):\s*([^;]+);?/g;
        const trimRightRegExp = /\s+$/;
        const encodingLookup = {};
        let validStyles;
        let invalidStyles;
        const invisibleChar = zeroWidth;
        if (schema) {
          validStyles = schema.getValidStyles();
          invalidStyles = schema.getInvalidStyles();
        }
        const encodingItems = (`\\" \\' \\; \\: ; : ` + invisibleChar).split(" ");
        for (let i = 0; i < encodingItems.length; i++) {
          encodingLookup[encodingItems[i]] = invisibleChar + i;
          encodingLookup[invisibleChar + i] = encodingItems[i];
        }
        const self = {
          parse: (css) => {
            const styles = {};
            let isEncoded = false;
            const urlConverter = settings.url_converter;
            const urlConverterScope = settings.url_converter_scope || self;
            const compress = (prefix, suffix, noJoin) => {
              const top = styles[prefix + "-top" + suffix];
              if (!top) {
                return;
              }
              const right = styles[prefix + "-right" + suffix];
              if (!right) {
                return;
              }
              const bottom = styles[prefix + "-bottom" + suffix];
              if (!bottom) {
                return;
              }
              const left = styles[prefix + "-left" + suffix];
              if (!left) {
                return;
              }
              const box = [
                top,
                right,
                bottom,
                left
              ];
              let i = box.length - 1;
              while (i--) {
                if (box[i] !== box[i + 1]) {
                  break;
                }
              }
              if (i > -1 && noJoin) {
                return;
              }
              styles[prefix + suffix] = i === -1 ? box[0] : box.join(" ");
              delete styles[prefix + "-top" + suffix];
              delete styles[prefix + "-right" + suffix];
              delete styles[prefix + "-bottom" + suffix];
              delete styles[prefix + "-left" + suffix];
            };
            const canCompress = (key) => {
              const value2 = styles[key];
              if (!value2) {
                return;
              }
              const values2 = value2.indexOf(",") > -1 ? [value2] : value2.split(" ");
              let i = values2.length;
              while (i--) {
                if (values2[i] !== values2[0]) {
                  return false;
                }
              }
              styles[key] = values2[0];
              return true;
            };
            const compress2 = (target, a, b, c) => {
              if (!canCompress(a)) {
                return;
              }
              if (!canCompress(b)) {
                return;
              }
              if (!canCompress(c)) {
                return;
              }
              styles[target] = styles[a] + " " + styles[b] + " " + styles[c];
              delete styles[a];
              delete styles[b];
              delete styles[c];
            };
            const encode = (str) => {
              isEncoded = true;
              return encodingLookup[str];
            };
            const decode2 = (str, keepSlashes) => {
              if (isEncoded) {
                str = str.replace(/\uFEFF[0-9]/g, (str2) => {
                  return encodingLookup[str2];
                });
              }
              if (!keepSlashes) {
                str = str.replace(/\\([\'\";:])/g, "$1");
              }
              return str;
            };
            const decodeSingleHexSequence = (escSeq) => {
              return String.fromCharCode(parseInt(escSeq.slice(1), 16));
            };
            const decodeHexSequences = (value2) => {
              return value2.replace(/\\[0-9a-f]+/gi, decodeSingleHexSequence);
            };
            const processUrl = (match2, url, url2, url3, str, str2) => {
              str = str || str2;
              if (str) {
                str = decode2(str);
                return `'` + str.replace(/\'/g, `\\'`) + `'`;
              }
              url = decode2(url || url2 || url3 || "");
              if (!settings.allow_script_urls) {
                const scriptUrl = url.replace(/[\s\r\n]+/g, "");
                if (/(java|vb)script:/i.test(scriptUrl)) {
                  return "";
                }
                if (!settings.allow_svg_data_urls && /^data:image\/svg/i.test(scriptUrl)) {
                  return "";
                }
              }
              if (urlConverter) {
                url = urlConverter.call(urlConverterScope, url, "style");
              }
              return `url('` + url.replace(/\'/g, `\\'`) + `')`;
            };
            if (css) {
              css = css.replace(/[\u0000-\u001F]/g, "");
              css = css.replace(/\\[\"\';:\uFEFF]/g, encode).replace(/\"[^\"]+\"|\'[^\']+\'/g, (str) => {
                return str.replace(/[;:]/g, encode);
              });
              let matches;
              while (matches = styleRegExp.exec(css)) {
                styleRegExp.lastIndex = matches.index + matches[0].length;
                let name2 = matches[1].replace(trimRightRegExp, "").toLowerCase();
                let value2 = matches[2].replace(trimRightRegExp, "");
                if (name2 && value2) {
                  name2 = decodeHexSequences(name2);
                  value2 = decodeHexSequences(value2);
                  if (name2.indexOf(invisibleChar) !== -1 || name2.indexOf('"') !== -1) {
                    continue;
                  }
                  if (!settings.allow_script_urls && (name2 === "behavior" || /expression\s*\(|\/\*|\*\//.test(value2))) {
                    continue;
                  }
                  if (name2 === "font-weight" && value2 === "700") {
                    value2 = "bold";
                  } else if (name2 === "color" || name2 === "background-color") {
                    value2 = value2.toLowerCase();
                  }
                  if (getColorFormat(value2) === "rgb") {
                    fromString(value2).each((rgba) => {
                      value2 = rgbaToHexString(toString(rgba)).toLowerCase();
                    });
                  }
                  value2 = value2.replace(urlOrStrRegExp, processUrl);
                  styles[name2] = isEncoded ? decode2(value2, true) : value2;
                }
              }
              compress("border", "", true);
              compress("border", "-width");
              compress("border", "-color");
              compress("border", "-style");
              compress("padding", "");
              compress("margin", "");
              compress2("border", "border-width", "border-style", "border-color");
              if (styles.border === "medium none") {
                delete styles.border;
              }
              if (styles["border-image"] === "none") {
                delete styles["border-image"];
              }
            }
            return styles;
          },
          serialize: (styles, elementName) => {
            let css = "";
            const serializeStyles = (elemName, validStyleList) => {
              const styleList = validStyleList[elemName];
              if (styleList) {
                for (let i = 0, l = styleList.length; i < l; i++) {
                  const name2 = styleList[i];
                  const value2 = styles[name2];
                  if (value2) {
                    css += (css.length > 0 ? " " : "") + name2 + ": " + value2 + ";";
                  }
                }
              }
            };
            const isValid2 = (name2, elemName) => {
              if (!invalidStyles || !elemName) {
                return true;
              }
              let styleMap = invalidStyles["*"];
              if (styleMap && styleMap[name2]) {
                return false;
              }
              styleMap = invalidStyles[elemName];
              return !(styleMap && styleMap[name2]);
            };
            if (elementName && validStyles) {
              serializeStyles("*", validStyles);
              serializeStyles(elementName, validStyles);
            } else {
              each$d(styles, (value2, name2) => {
                if (value2 && isValid2(name2, elementName)) {
                  css += (css.length > 0 ? " " : "") + name2 + ": " + value2 + ";";
                }
              });
            }
            return css;
          }
        };
        return self;
      };
      const deprecated = {
        keyLocation: true,
        layerX: true,
        layerY: true,
        returnValue: true,
        webkitMovementX: true,
        webkitMovementY: true,
        keyIdentifier: true,
        mozPressure: true
      };
      const isNativeEvent = (event) => event instanceof Event || isFunction(event.initEvent);
      const hasIsDefaultPrevented = (event) => event.isDefaultPrevented === always || event.isDefaultPrevented === never;
      const needsNormalizing = (event) => isNullable(event.preventDefault) || isNativeEvent(event);
      const clone$3 = (originalEvent, data2) => {
        const event = data2 !== null && data2 !== void 0 ? data2 : {};
        for (const name2 in originalEvent) {
          if (!has$2(deprecated, name2)) {
            event[name2] = originalEvent[name2];
          }
        }
        if (isNonNullable(originalEvent.composedPath)) {
          event.composedPath = () => originalEvent.composedPath();
        }
        if (isNonNullable(originalEvent.getModifierState)) {
          event.getModifierState = (keyArg) => originalEvent.getModifierState(keyArg);
        }
        if (isNonNullable(originalEvent.getTargetRanges)) {
          event.getTargetRanges = () => originalEvent.getTargetRanges();
        }
        return event;
      };
      const normalize$3 = (type2, originalEvent, fallbackTarget, data2) => {
        var _a;
        const event = clone$3(originalEvent, data2);
        event.type = type2;
        if (isNullable(event.target)) {
          event.target = (_a = event.srcElement) !== null && _a !== void 0 ? _a : fallbackTarget;
        }
        if (needsNormalizing(originalEvent)) {
          event.preventDefault = () => {
            event.defaultPrevented = true;
            event.isDefaultPrevented = always;
            if (isFunction(originalEvent.preventDefault)) {
              originalEvent.preventDefault();
            }
          };
          event.stopPropagation = () => {
            event.cancelBubble = true;
            event.isPropagationStopped = always;
            if (isFunction(originalEvent.stopPropagation)) {
              originalEvent.stopPropagation();
            }
          };
          event.stopImmediatePropagation = () => {
            event.isImmediatePropagationStopped = always;
            event.stopPropagation();
          };
          if (!hasIsDefaultPrevented(event)) {
            event.isDefaultPrevented = event.defaultPrevented === true ? always : never;
            event.isPropagationStopped = event.cancelBubble === true ? always : never;
            event.isImmediatePropagationStopped = never;
          }
        }
        return event;
      };
      const eventExpandoPrefix = "mce-data-";
      const mouseEventRe = /^(?:mouse|contextmenu)|click/;
      const addEvent = (target, name2, callback, capture) => {
        target.addEventListener(name2, callback, capture || false);
      };
      const removeEvent = (target, name2, callback, capture) => {
        target.removeEventListener(name2, callback, capture || false);
      };
      const isMouseEvent = (event) => isNonNullable(event) && mouseEventRe.test(event.type);
      const fix = (originalEvent, data2) => {
        const event = normalize$3(originalEvent.type, originalEvent, document, data2);
        if (isMouseEvent(originalEvent) && isUndefined(originalEvent.pageX) && !isUndefined(originalEvent.clientX)) {
          const eventDoc = event.target.ownerDocument || document;
          const doc = eventDoc.documentElement;
          const body = eventDoc.body;
          const mouseEvent = event;
          mouseEvent.pageX = originalEvent.clientX + (doc && doc.scrollLeft || body && body.scrollLeft || 0) - (doc && doc.clientLeft || body && body.clientLeft || 0);
          mouseEvent.pageY = originalEvent.clientY + (doc && doc.scrollTop || body && body.scrollTop || 0) - (doc && doc.clientTop || body && body.clientTop || 0);
        }
        return event;
      };
      const bindOnReady = (win, callback, eventUtils) => {
        const doc = win.document, event = { type: "ready" };
        if (eventUtils.domLoaded) {
          callback(event);
          return;
        }
        const isDocReady = () => {
          return doc.readyState === "complete" || doc.readyState === "interactive" && doc.body;
        };
        const readyHandler = () => {
          removeEvent(win, "DOMContentLoaded", readyHandler);
          removeEvent(win, "load", readyHandler);
          if (!eventUtils.domLoaded) {
            eventUtils.domLoaded = true;
            callback(event);
          }
          win = null;
        };
        if (isDocReady()) {
          readyHandler();
        } else {
          addEvent(win, "DOMContentLoaded", readyHandler);
        }
        if (!eventUtils.domLoaded) {
          addEvent(win, "load", readyHandler);
        }
      };
      class EventUtils {
        constructor() {
          this.domLoaded = false;
          this.events = {};
          this.count = 1;
          this.expando = eventExpandoPrefix + (+/* @__PURE__ */ new Date()).toString(32);
          this.hasFocusIn = "onfocusin" in document.documentElement;
          this.count = 1;
        }
        bind(target, names, callback, scope) {
          const self = this;
          let callbackList;
          const win = window;
          const defaultNativeHandler = (evt) => {
            self.executeHandlers(fix(evt || win.event), id);
          };
          if (!target || isText$b(target) || isComment(target)) {
            return callback;
          }
          let id;
          if (!target[self.expando]) {
            id = self.count++;
            target[self.expando] = id;
            self.events[id] = {};
          } else {
            id = target[self.expando];
          }
          scope = scope || target;
          const namesList = names.split(" ");
          let i = namesList.length;
          while (i--) {
            let name2 = namesList[i];
            let nativeHandler = defaultNativeHandler;
            let capture = false;
            let fakeName = false;
            if (name2 === "DOMContentLoaded") {
              name2 = "ready";
            }
            if (self.domLoaded && name2 === "ready" && target.readyState === "complete") {
              callback.call(scope, fix({ type: name2 }));
              continue;
            }
            if (!self.hasFocusIn && (name2 === "focusin" || name2 === "focusout")) {
              capture = true;
              fakeName = name2 === "focusin" ? "focus" : "blur";
              nativeHandler = (evt) => {
                const event = fix(evt || win.event);
                event.type = event.type === "focus" ? "focusin" : "focusout";
                self.executeHandlers(event, id);
              };
            }
            callbackList = self.events[id][name2];
            if (!callbackList) {
              self.events[id][name2] = callbackList = [{
                func: callback,
                scope
              }];
              callbackList.fakeName = fakeName;
              callbackList.capture = capture;
              callbackList.nativeHandler = nativeHandler;
              if (name2 === "ready") {
                bindOnReady(target, nativeHandler, self);
              } else {
                addEvent(target, fakeName || name2, nativeHandler, capture);
              }
            } else {
              if (name2 === "ready" && self.domLoaded) {
                callback(fix({ type: name2 }));
              } else {
                callbackList.push({
                  func: callback,
                  scope
                });
              }
            }
          }
          target = callbackList = null;
          return callback;
        }
        unbind(target, names, callback) {
          if (!target || isText$b(target) || isComment(target)) {
            return this;
          }
          const id = target[this.expando];
          if (id) {
            let eventMap = this.events[id];
            if (names) {
              const namesList = names.split(" ");
              let i = namesList.length;
              while (i--) {
                const name2 = namesList[i];
                const callbackList = eventMap[name2];
                if (callbackList) {
                  if (callback) {
                    let ci = callbackList.length;
                    while (ci--) {
                      if (callbackList[ci].func === callback) {
                        const nativeHandler = callbackList.nativeHandler;
                        const fakeName = callbackList.fakeName, capture = callbackList.capture;
                        const newCallbackList = callbackList.slice(0, ci).concat(callbackList.slice(ci + 1));
                        newCallbackList.nativeHandler = nativeHandler;
                        newCallbackList.fakeName = fakeName;
                        newCallbackList.capture = capture;
                        eventMap[name2] = newCallbackList;
                      }
                    }
                  }
                  if (!callback || callbackList.length === 0) {
                    delete eventMap[name2];
                    removeEvent(target, callbackList.fakeName || name2, callbackList.nativeHandler, callbackList.capture);
                  }
                }
              }
            } else {
              each$d(eventMap, (callbackList, name2) => {
                removeEvent(target, callbackList.fakeName || name2, callbackList.nativeHandler, callbackList.capture);
              });
              eventMap = {};
            }
            for (const name2 in eventMap) {
              if (has$2(eventMap, name2)) {
                return this;
              }
            }
            delete this.events[id];
            try {
              delete target[this.expando];
            } catch (_a) {
              target[this.expando] = null;
            }
          }
          return this;
        }
        fire(target, name2, args) {
          return this.dispatch(target, name2, args);
        }
        dispatch(target, name2, args) {
          if (!target || isText$b(target) || isComment(target)) {
            return this;
          }
          const event = fix({
            type: name2,
            target
          }, args);
          do {
            const id = target[this.expando];
            if (id) {
              this.executeHandlers(event, id);
            }
            target = target.parentNode || target.ownerDocument || target.defaultView || target.parentWindow;
          } while (target && !event.isPropagationStopped());
          return this;
        }
        clean(target) {
          if (!target || isText$b(target) || isComment(target)) {
            return this;
          }
          if (target[this.expando]) {
            this.unbind(target);
          }
          if (!target.getElementsByTagName) {
            target = target.document;
          }
          if (target && target.getElementsByTagName) {
            this.unbind(target);
            const children2 = target.getElementsByTagName("*");
            let i = children2.length;
            while (i--) {
              target = children2[i];
              if (target[this.expando]) {
                this.unbind(target);
              }
            }
          }
          return this;
        }
        destroy() {
          this.events = {};
        }
        cancel(e) {
          if (e) {
            e.preventDefault();
            e.stopImmediatePropagation();
          }
          return false;
        }
        executeHandlers(evt, id) {
          const container = this.events[id];
          const callbackList = container && container[evt.type];
          if (callbackList) {
            for (let i = 0, l = callbackList.length; i < l; i++) {
              const callback = callbackList[i];
              if (callback && callback.func.call(callback.scope, evt) === false) {
                evt.preventDefault();
              }
              if (evt.isImmediatePropagationStopped()) {
                return;
              }
            }
          }
        }
      }
      EventUtils.Event = new EventUtils();
      const each$a = Tools.each;
      const grep = Tools.grep;
      const internalStyleName = "data-mce-style";
      const numericalCssMap = Tools.makeMap("fill-opacity font-weight line-height opacity orphans widows z-index zoom", " ");
      const legacySetAttribute = (elm, name2, value2) => {
        if (isNullable(value2) || value2 === "") {
          remove$9(elm, name2);
        } else {
          set$4(elm, name2, value2);
        }
      };
      const camelCaseToHyphens = (name2) => name2.replace(/[A-Z]/g, (v) => "-" + v.toLowerCase());
      const findNodeIndex = (node, normalized) => {
        let idx = 0;
        if (node) {
          for (let lastNodeType = node.nodeType, tempNode = node.previousSibling; tempNode; tempNode = tempNode.previousSibling) {
            const nodeType = tempNode.nodeType;
            if (normalized && isText$b(tempNode)) {
              if (nodeType === lastNodeType || !tempNode.data.length) {
                continue;
              }
            }
            idx++;
            lastNodeType = nodeType;
          }
        }
        return idx;
      };
      const updateInternalStyleAttr = (styles, elm) => {
        const rawValue = get$9(elm, "style");
        const value2 = styles.serialize(styles.parse(rawValue), name(elm));
        legacySetAttribute(elm, internalStyleName, value2);
      };
      const convertStyleToString = (cssValue, cssName) => {
        if (isNumber(cssValue)) {
          return has$2(numericalCssMap, cssName) ? cssValue + "" : cssValue + "px";
        } else {
          return cssValue;
        }
      };
      const applyStyle$1 = ($elm, cssName, cssValue) => {
        const normalizedName = camelCaseToHyphens(cssName);
        if (isNullable(cssValue) || cssValue === "") {
          remove$5($elm, normalizedName);
        } else {
          set$2($elm, normalizedName, convertStyleToString(cssValue, normalizedName));
        }
      };
      const setupAttrHooks = (styles, settings, getContext2) => {
        const keepValues = settings.keep_values;
        const keepUrlHook = {
          set: (elm, value2, name2) => {
            const sugarElm = SugarElement.fromDom(elm);
            if (isFunction(settings.url_converter) && isNonNullable(value2)) {
              value2 = settings.url_converter.call(settings.url_converter_scope || getContext2(), String(value2), name2, elm);
            }
            const internalName = "data-mce-" + name2;
            legacySetAttribute(sugarElm, internalName, value2);
            legacySetAttribute(sugarElm, name2, value2);
          },
          get: (elm, name2) => {
            const sugarElm = SugarElement.fromDom(elm);
            return get$9(sugarElm, "data-mce-" + name2) || get$9(sugarElm, name2);
          }
        };
        const attrHooks = {
          style: {
            set: (elm, value2) => {
              const sugarElm = SugarElement.fromDom(elm);
              if (keepValues) {
                legacySetAttribute(sugarElm, internalStyleName, value2);
              }
              remove$9(sugarElm, "style");
              if (isString(value2)) {
                setAll(sugarElm, styles.parse(value2));
              }
            },
            get: (elm) => {
              const sugarElm = SugarElement.fromDom(elm);
              const value2 = get$9(sugarElm, internalStyleName) || get$9(sugarElm, "style");
              return styles.serialize(styles.parse(value2), name(sugarElm));
            }
          }
        };
        if (keepValues) {
          attrHooks.href = attrHooks.src = keepUrlHook;
        }
        return attrHooks;
      };
      const DOMUtils = (doc, settings = {}) => {
        const addedStyles = {};
        const win = window;
        const files = {};
        let counter = 0;
        const stdMode = true;
        const boxModel = true;
        const styleSheetLoader = instance.forElement(SugarElement.fromDom(doc), {
          contentCssCors: settings.contentCssCors,
          referrerPolicy: settings.referrerPolicy
        });
        const boundEvents = [];
        const schema = settings.schema ? settings.schema : Schema({});
        const styles = Styles({
          url_converter: settings.url_converter,
          url_converter_scope: settings.url_converter_scope
        }, settings.schema);
        const events = settings.ownEvents ? new EventUtils() : EventUtils.Event;
        const blockElementsMap = schema.getBlockElements();
        const isBlock2 = (node) => {
          if (isString(node)) {
            return has$2(blockElementsMap, node);
          } else {
            return isElement$6(node) && (has$2(blockElementsMap, node.nodeName) || isTransparentBlock(schema, node));
          }
        };
        const get2 = (elm) => elm && doc && isString(elm) ? doc.getElementById(elm) : elm;
        const _get = (elm) => {
          const value2 = get2(elm);
          return isNonNullable(value2) ? SugarElement.fromDom(value2) : null;
        };
        const getAttrib = (elm, name2, defaultVal = "") => {
          let value2;
          const $elm = _get(elm);
          if (isNonNullable($elm) && isElement$7($elm)) {
            const hook = attrHooks[name2];
            if (hook && hook.get) {
              value2 = hook.get($elm.dom, name2);
            } else {
              value2 = get$9($elm, name2);
            }
          }
          return isNonNullable(value2) ? value2 : defaultVal;
        };
        const getAttribs = (elm) => {
          const node = get2(elm);
          return isNullable(node) ? [] : node.attributes;
        };
        const setAttrib = (elm, name2, value2) => {
          run(elm, (e) => {
            if (isElement$6(e)) {
              const $elm = SugarElement.fromDom(e);
              const val = value2 === "" ? null : value2;
              const originalValue = get$9($elm, name2);
              const hook = attrHooks[name2];
              if (hook && hook.set) {
                hook.set($elm.dom, val, name2);
              } else {
                legacySetAttribute($elm, name2, val);
              }
              if (originalValue !== val && settings.onSetAttrib) {
                settings.onSetAttrib({
                  attrElm: $elm.dom,
                  attrName: name2,
                  attrValue: val
                });
              }
            }
          });
        };
        const clone2 = (node, deep2) => {
          return node.cloneNode(deep2);
        };
        const getRoot = () => settings.root_element || doc.body;
        const getViewPort = (argWin) => {
          const vp = getBounds(argWin);
          return {
            x: vp.x,
            y: vp.y,
            w: vp.width,
            h: vp.height
          };
        };
        const getPos$1 = (elm, rootElm) => getPos(doc.body, get2(elm), rootElm);
        const setStyle = (elm, name2, value2) => {
          run(elm, (e) => {
            const $elm = SugarElement.fromDom(e);
            applyStyle$1($elm, name2, value2);
            if (settings.update_styles) {
              updateInternalStyleAttr(styles, $elm);
            }
          });
        };
        const setStyles = (elm, stylesArg) => {
          run(elm, (e) => {
            const $elm = SugarElement.fromDom(e);
            each$d(stylesArg, (v, n) => {
              applyStyle$1($elm, n, v);
            });
            if (settings.update_styles) {
              updateInternalStyleAttr(styles, $elm);
            }
          });
        };
        const getStyle2 = (elm, name2, computed) => {
          const $elm = get2(elm);
          if (isNullable($elm) || !isHTMLElement($elm) && !isSVGElement($elm)) {
            return void 0;
          }
          if (computed) {
            return get$7(SugarElement.fromDom($elm), camelCaseToHyphens(name2));
          } else {
            name2 = name2.replace(/-(\D)/g, (a, b) => b.toUpperCase());
            if (name2 === "float") {
              name2 = "cssFloat";
            }
            return $elm.style ? $elm.style[name2] : void 0;
          }
        };
        const getSize = (elm) => {
          const $elm = get2(elm);
          if (!$elm) {
            return {
              w: 0,
              h: 0
            };
          }
          let w = getStyle2($elm, "width");
          let h = getStyle2($elm, "height");
          if (!w || w.indexOf("px") === -1) {
            w = "0";
          }
          if (!h || h.indexOf("px") === -1) {
            h = "0";
          }
          return {
            w: parseInt(w, 10) || $elm.offsetWidth || $elm.clientWidth,
            h: parseInt(h, 10) || $elm.offsetHeight || $elm.clientHeight
          };
        };
        const getRect = (elm) => {
          const $elm = get2(elm);
          const pos = getPos$1($elm);
          const size = getSize($elm);
          return {
            x: pos.x,
            y: pos.y,
            w: size.w,
            h: size.h
          };
        };
        const is2 = (elm, selector) => {
          if (!elm) {
            return false;
          }
          const elms = isArray$1(elm) ? elm : [elm];
          return exists(elms, (e) => {
            return is$1(SugarElement.fromDom(e), selector);
          });
        };
        const getParents2 = (elm, selector, root, collect) => {
          const result = [];
          let node = get2(elm);
          collect = collect === void 0;
          const resolvedRoot = root || (getRoot().nodeName !== "BODY" ? getRoot().parentNode : null);
          if (isString(selector)) {
            if (selector === "*") {
              selector = isElement$6;
            } else {
              const selectorVal = selector;
              selector = (node2) => is2(node2, selectorVal);
            }
          }
          while (node) {
            if (node === resolvedRoot || isNullable(node.nodeType) || isDocument$1(node) || isDocumentFragment(node)) {
              break;
            }
            if (!selector || selector(node)) {
              if (collect) {
                result.push(node);
              } else {
                return [node];
              }
            }
            node = node.parentNode;
          }
          return collect ? result : null;
        };
        const getParent = (node, selector, root) => {
          const parents2 = getParents2(node, selector, root, false);
          return parents2 && parents2.length > 0 ? parents2[0] : null;
        };
        const _findSib = (node, selector, name2) => {
          let func = selector;
          if (node) {
            if (isString(selector)) {
              func = (node2) => {
                return is2(node2, selector);
              };
            }
            for (let tempNode = node[name2]; tempNode; tempNode = tempNode[name2]) {
              if (isFunction(func) && func(tempNode)) {
                return tempNode;
              }
            }
          }
          return null;
        };
        const getNext = (node, selector) => _findSib(node, selector, "nextSibling");
        const getPrev = (node, selector) => _findSib(node, selector, "previousSibling");
        const isParentNode = (node) => isFunction(node.querySelectorAll);
        const select2 = (selector, scope) => {
          var _a, _b;
          const elm = (_b = (_a = get2(scope)) !== null && _a !== void 0 ? _a : settings.root_element) !== null && _b !== void 0 ? _b : doc;
          return isParentNode(elm) ? from(elm.querySelectorAll(selector)) : [];
        };
        const run = function(elm, func, scope) {
          const context2 = scope !== null && scope !== void 0 ? scope : this;
          if (isArray$1(elm)) {
            const result = [];
            each$a(elm, (e, i) => {
              const node = get2(e);
              if (node) {
                result.push(func.call(context2, node, i));
              }
            });
            return result;
          } else {
            const node = get2(elm);
            return !node ? false : func.call(context2, node);
          }
        };
        const setAttribs = (elm, attrs) => {
          run(elm, ($elm) => {
            each$d(attrs, (value2, name2) => {
              setAttrib($elm, name2, value2);
            });
          });
        };
        const setHTML = (elm, html2) => {
          run(elm, (e) => {
            const $elm = SugarElement.fromDom(e);
            set$1($elm, html2);
          });
        };
        const add2 = (parentElm, name2, attrs, html2, create3) => run(parentElm, (parentElm2) => {
          const newElm = isString(name2) ? doc.createElement(name2) : name2;
          if (isNonNullable(attrs)) {
            setAttribs(newElm, attrs);
          }
          if (html2) {
            if (!isString(html2) && html2.nodeType) {
              newElm.appendChild(html2);
            } else if (isString(html2)) {
              setHTML(newElm, html2);
            }
          }
          return !create3 ? parentElm2.appendChild(newElm) : newElm;
        });
        const create2 = (name2, attrs, html2) => add2(doc.createElement(name2), name2, attrs, html2, true);
        const decode2 = Entities.decode;
        const encode = Entities.encodeAllRaw;
        const createHTML = (name2, attrs, html2 = "") => {
          let outHtml = "<" + name2;
          for (const key in attrs) {
            if (hasNonNullableKey(attrs, key)) {
              outHtml += " " + key + '="' + encode(attrs[key]) + '"';
            }
          }
          if (isEmpty$3(html2) && has$2(schema.getVoidElements(), name2)) {
            return outHtml + " />";
          } else {
            return outHtml + ">" + html2 + "</" + name2 + ">";
          }
        };
        const createFragment2 = (html2) => {
          const container = doc.createElement("div");
          const frag = doc.createDocumentFragment();
          frag.appendChild(container);
          if (html2) {
            container.innerHTML = html2;
          }
          let node;
          while (node = container.firstChild) {
            frag.appendChild(node);
          }
          frag.removeChild(container);
          return frag;
        };
        const remove2 = (node, keepChildren) => {
          return run(node, (n) => {
            const $node = SugarElement.fromDom(n);
            if (keepChildren) {
              each$e(children$1($node), (child2) => {
                if (isText$c(child2) && child2.dom.length === 0) {
                  remove$4(child2);
                } else {
                  before$3($node, child2);
                }
              });
            }
            remove$4($node);
            return $node.dom;
          });
        };
        const removeAllAttribs = (e) => run(e, (e2) => {
          const attrs = e2.attributes;
          for (let i = attrs.length - 1; i >= 0; i--) {
            e2.removeAttributeNode(attrs.item(i));
          }
        });
        const parseStyle = (cssText) => styles.parse(cssText);
        const serializeStyle = (stylesArg, name2) => styles.serialize(stylesArg, name2);
        const addStyle = (cssText) => {
          if (self !== DOMUtils.DOM && doc === document) {
            if (addedStyles[cssText]) {
              return;
            }
            addedStyles[cssText] = true;
          }
          let styleElm = doc.getElementById("mceDefaultStyles");
          if (!styleElm) {
            styleElm = doc.createElement("style");
            styleElm.id = "mceDefaultStyles";
            styleElm.type = "text/css";
            const head2 = doc.head;
            if (head2.firstChild) {
              head2.insertBefore(styleElm, head2.firstChild);
            } else {
              head2.appendChild(styleElm);
            }
          }
          if (styleElm.styleSheet) {
            styleElm.styleSheet.cssText += cssText;
          } else {
            styleElm.appendChild(doc.createTextNode(cssText));
          }
        };
        const loadCSS = (urls) => {
          if (!urls) {
            urls = "";
          }
          each$e(urls.split(","), (url) => {
            files[url] = true;
            styleSheetLoader.load(url).catch(noop);
          });
        };
        const toggleClass2 = (elm, cls, state) => {
          run(elm, (e) => {
            if (isElement$6(e)) {
              const $elm = SugarElement.fromDom(e);
              const classes = cls.split(" ");
              each$e(classes, (c) => {
                if (isNonNullable(state)) {
                  const fn = state ? add$2 : remove$6;
                  fn($elm, c);
                } else {
                  toggle$1($elm, c);
                }
              });
            }
          });
        };
        const addClass = (elm, cls) => {
          toggleClass2(elm, cls, true);
        };
        const removeClass = (elm, cls) => {
          toggleClass2(elm, cls, false);
        };
        const hasClass2 = (elm, cls) => {
          const $elm = _get(elm);
          const classes = cls.split(" ");
          return isNonNullable($elm) && forall(classes, (c) => has($elm, c));
        };
        const show = (elm) => {
          run(elm, (e) => remove$5(SugarElement.fromDom(e), "display"));
        };
        const hide = (elm) => {
          run(elm, (e) => set$2(SugarElement.fromDom(e), "display", "none"));
        };
        const isHidden = (elm) => {
          const $elm = _get(elm);
          return isNonNullable($elm) && is$2(getRaw($elm, "display"), "none");
        };
        const uniqueId2 = (prefix) => (!prefix ? "mce_" : prefix) + counter++;
        const getOuterHTML = (elm) => {
          const $elm = _get(elm);
          if (isNonNullable($elm)) {
            return isElement$6($elm.dom) ? $elm.dom.outerHTML : getOuter($elm);
          } else {
            return "";
          }
        };
        const setOuterHTML = (elm, html2) => {
          run(elm, ($elm) => {
            if (isElement$6($elm)) {
              $elm.outerHTML = html2;
            }
          });
        };
        const insertAfter2 = (node, reference) => {
          const referenceNode = get2(reference);
          return run(node, (node2) => {
            const parent2 = referenceNode === null || referenceNode === void 0 ? void 0 : referenceNode.parentNode;
            const nextSibling2 = referenceNode === null || referenceNode === void 0 ? void 0 : referenceNode.nextSibling;
            if (parent2) {
              if (nextSibling2) {
                parent2.insertBefore(node2, nextSibling2);
              } else {
                parent2.appendChild(node2);
              }
            }
            return node2;
          });
        };
        const replace = (newElm, oldElm, keepChildren) => run(oldElm, (elm) => {
          var _a;
          const replacee = isArray$1(oldElm) ? newElm.cloneNode(true) : newElm;
          if (keepChildren) {
            each$a(grep(elm.childNodes), (node) => {
              replacee.appendChild(node);
            });
          }
          (_a = elm.parentNode) === null || _a === void 0 ? void 0 : _a.replaceChild(replacee, elm);
          return elm;
        });
        const rename = (elm, name2) => {
          if (elm.nodeName !== name2.toUpperCase()) {
            const newElm = create2(name2);
            each$a(getAttribs(elm), (attrNode) => {
              setAttrib(newElm, attrNode.nodeName, getAttrib(elm, attrNode.nodeName));
            });
            replace(newElm, elm, true);
            return newElm;
          } else {
            return elm;
          }
        };
        const findCommonAncestor = (a, b) => {
          let ps = a;
          while (ps) {
            let pe = b;
            while (pe && ps !== pe) {
              pe = pe.parentNode;
            }
            if (ps === pe) {
              break;
            }
            ps = ps.parentNode;
          }
          if (!ps && a.ownerDocument) {
            return a.ownerDocument.documentElement;
          } else {
            return ps;
          }
        };
        const isEmpty2 = (node, elements, options) => {
          if (isPlainObject(elements)) {
            const isContent2 = (node2) => {
              const name2 = node2.nodeName.toLowerCase();
              return Boolean(elements[name2]);
            };
            return isEmptyNode(schema, node, {
              ...options,
              isContent: isContent2
            });
          } else {
            return isEmptyNode(schema, node, options);
          }
        };
        const createRng = () => doc.createRange();
        const split2 = (parentElm, splitElm, replacementElm) => {
          let range2 = createRng();
          let beforeFragment;
          let afterFragment;
          if (parentElm && splitElm && parentElm.parentNode && splitElm.parentNode) {
            const parentNode = parentElm.parentNode;
            range2.setStart(parentNode, findNodeIndex(parentElm));
            range2.setEnd(splitElm.parentNode, findNodeIndex(splitElm));
            beforeFragment = range2.extractContents();
            range2 = createRng();
            range2.setStart(splitElm.parentNode, findNodeIndex(splitElm) + 1);
            range2.setEnd(parentNode, findNodeIndex(parentElm) + 1);
            afterFragment = range2.extractContents();
            parentNode.insertBefore(trimNode(self, beforeFragment, schema), parentElm);
            if (replacementElm) {
              parentNode.insertBefore(replacementElm, parentElm);
            } else {
              parentNode.insertBefore(splitElm, parentElm);
            }
            parentNode.insertBefore(trimNode(self, afterFragment, schema), parentElm);
            remove2(parentElm);
            return replacementElm || splitElm;
          } else {
            return void 0;
          }
        };
        const bind2 = (target, name2, func, scope) => {
          if (isArray$1(target)) {
            let i = target.length;
            const rv = [];
            while (i--) {
              rv[i] = bind2(target[i], name2, func, scope);
            }
            return rv;
          } else {
            if (settings.collect && (target === doc || target === win)) {
              boundEvents.push([
                target,
                name2,
                func,
                scope
              ]);
            }
            return events.bind(target, name2, func, scope || self);
          }
        };
        const unbind2 = (target, name2, func) => {
          if (isArray$1(target)) {
            let i = target.length;
            const rv = [];
            while (i--) {
              rv[i] = unbind2(target[i], name2, func);
            }
            return rv;
          } else {
            if (boundEvents.length > 0 && (target === doc || target === win)) {
              let i = boundEvents.length;
              while (i--) {
                const [boundTarget, boundName, boundFunc] = boundEvents[i];
                if (target === boundTarget && (!name2 || name2 === boundName) && (!func || func === boundFunc)) {
                  events.unbind(boundTarget, boundName, boundFunc);
                }
              }
            }
            return events.unbind(target, name2, func);
          }
        };
        const dispatch = (target, name2, evt) => events.dispatch(target, name2, evt);
        const fire = (target, name2, evt) => events.dispatch(target, name2, evt);
        const getContentEditable = (node) => {
          if (node && isHTMLElement(node)) {
            const contentEditable = node.getAttribute("data-mce-contenteditable");
            if (contentEditable && contentEditable !== "inherit") {
              return contentEditable;
            }
            return node.contentEditable !== "inherit" ? node.contentEditable : null;
          } else {
            return null;
          }
        };
        const getContentEditableParent = (node) => {
          const root = getRoot();
          let state = null;
          for (let tempNode = node; tempNode && tempNode !== root; tempNode = tempNode.parentNode) {
            state = getContentEditable(tempNode);
            if (state !== null) {
              break;
            }
          }
          return state;
        };
        const isEditable2 = (node) => {
          if (isNonNullable(node)) {
            const scope = isElement$6(node) ? node : node.parentElement;
            return isNonNullable(scope) && isHTMLElement(scope) && isEditable$2(SugarElement.fromDom(scope));
          } else {
            return false;
          }
        };
        const destroy2 = () => {
          if (boundEvents.length > 0) {
            let i = boundEvents.length;
            while (i--) {
              const [boundTarget, boundName, boundFunc] = boundEvents[i];
              events.unbind(boundTarget, boundName, boundFunc);
            }
          }
          each$d(files, (_, url) => {
            styleSheetLoader.unload(url);
            delete files[url];
          });
        };
        const isChildOf = (node, parent2) => {
          return node === parent2 || parent2.contains(node);
        };
        const dumpRng = (r2) => "startContainer: " + r2.startContainer.nodeName + ", startOffset: " + r2.startOffset + ", endContainer: " + r2.endContainer.nodeName + ", endOffset: " + r2.endOffset;
        const self = {
          doc,
          settings,
          win,
          files,
          stdMode,
          boxModel,
          styleSheetLoader,
          boundEvents,
          styles,
          schema,
          events,
          isBlock: isBlock2,
          root: null,
          clone: clone2,
          getRoot,
          getViewPort,
          getRect,
          getSize,
          getParent,
          getParents: getParents2,
          get: get2,
          getNext,
          getPrev,
          select: select2,
          is: is2,
          add: add2,
          create: create2,
          createHTML,
          createFragment: createFragment2,
          remove: remove2,
          setStyle,
          getStyle: getStyle2,
          setStyles,
          removeAllAttribs,
          setAttrib,
          setAttribs,
          getAttrib,
          getPos: getPos$1,
          parseStyle,
          serializeStyle,
          addStyle,
          loadCSS,
          addClass,
          removeClass,
          hasClass: hasClass2,
          toggleClass: toggleClass2,
          show,
          hide,
          isHidden,
          uniqueId: uniqueId2,
          setHTML,
          getOuterHTML,
          setOuterHTML,
          decode: decode2,
          encode,
          insertAfter: insertAfter2,
          replace,
          rename,
          findCommonAncestor,
          run,
          getAttribs,
          isEmpty: isEmpty2,
          createRng,
          nodeIndex: findNodeIndex,
          split: split2,
          bind: bind2,
          unbind: unbind2,
          fire,
          dispatch,
          getContentEditable,
          getContentEditableParent,
          isEditable: isEditable2,
          destroy: destroy2,
          isChildOf,
          dumpRng
        };
        const attrHooks = setupAttrHooks(styles, settings, constant(self));
        return self;
      };
      DOMUtils.DOM = DOMUtils(document);
      DOMUtils.nodeIndex = findNodeIndex;
      const DOM$b = DOMUtils.DOM;
      const QUEUED = 0;
      const LOADING = 1;
      const LOADED = 2;
      const FAILED = 3;
      class ScriptLoader {
        constructor(settings = {}) {
          this.states = {};
          this.queue = [];
          this.scriptLoadedCallbacks = {};
          this.queueLoadedCallbacks = [];
          this.loading = false;
          this.settings = settings;
        }
        _setReferrerPolicy(referrerPolicy) {
          this.settings.referrerPolicy = referrerPolicy;
        }
        loadScript(url) {
          return new Promise((resolve2, reject) => {
            const dom2 = DOM$b;
            let elm;
            const cleanup = () => {
              dom2.remove(id);
              if (elm) {
                elm.onerror = elm.onload = elm = null;
              }
            };
            const done = () => {
              cleanup();
              resolve2();
            };
            const error2 = () => {
              cleanup();
              reject("Failed to load script: " + url);
            };
            const id = dom2.uniqueId();
            elm = document.createElement("script");
            elm.id = id;
            elm.type = "text/javascript";
            elm.src = Tools._addCacheSuffix(url);
            if (this.settings.referrerPolicy) {
              dom2.setAttrib(elm, "referrerpolicy", this.settings.referrerPolicy);
            }
            elm.onload = done;
            elm.onerror = error2;
            (document.getElementsByTagName("head")[0] || document.body).appendChild(elm);
          });
        }
        isDone(url) {
          return this.states[url] === LOADED;
        }
        markDone(url) {
          this.states[url] = LOADED;
        }
        add(url) {
          const self = this;
          self.queue.push(url);
          const state = self.states[url];
          if (state === void 0) {
            self.states[url] = QUEUED;
          }
          return new Promise((resolve2, reject) => {
            if (!self.scriptLoadedCallbacks[url]) {
              self.scriptLoadedCallbacks[url] = [];
            }
            self.scriptLoadedCallbacks[url].push({
              resolve: resolve2,
              reject
            });
          });
        }
        load(url) {
          return this.add(url);
        }
        remove(url) {
          delete this.states[url];
          delete this.scriptLoadedCallbacks[url];
        }
        loadQueue() {
          const queue = this.queue;
          this.queue = [];
          return this.loadScripts(queue);
        }
        loadScripts(scripts) {
          const self = this;
          const execCallbacks = (name2, url) => {
            get$a(self.scriptLoadedCallbacks, url).each((callbacks) => {
              each$e(callbacks, (callback) => callback[name2](url));
            });
            delete self.scriptLoadedCallbacks[url];
          };
          const processResults = (results) => {
            const failures = filter$5(results, (result) => result.status === "rejected");
            if (failures.length > 0) {
              return Promise.reject(bind$3(failures, ({ reason }) => isArray$1(reason) ? reason : [reason]));
            } else {
              return Promise.resolve();
            }
          };
          const load = (urls) => Promise.allSettled(map$3(urls, (url) => {
            if (self.states[url] === LOADED) {
              execCallbacks("resolve", url);
              return Promise.resolve();
            } else if (self.states[url] === FAILED) {
              execCallbacks("reject", url);
              return Promise.reject(url);
            } else {
              self.states[url] = LOADING;
              return self.loadScript(url).then(() => {
                self.states[url] = LOADED;
                execCallbacks("resolve", url);
                const queue = self.queue;
                if (queue.length > 0) {
                  self.queue = [];
                  return load(queue).then(processResults);
                } else {
                  return Promise.resolve();
                }
              }, () => {
                self.states[url] = FAILED;
                execCallbacks("reject", url);
                return Promise.reject(url);
              });
            }
          }));
          const processQueue = (urls) => {
            self.loading = true;
            return load(urls).then((results) => {
              self.loading = false;
              const nextQueuedItem = self.queueLoadedCallbacks.shift();
              Optional.from(nextQueuedItem).each(call);
              return processResults(results);
            });
          };
          const uniqueScripts = stringArray(scripts);
          if (self.loading) {
            return new Promise((resolve2, reject) => {
              self.queueLoadedCallbacks.push(() => {
                processQueue(uniqueScripts).then(resolve2, reject);
              });
            });
          } else {
            return processQueue(uniqueScripts);
          }
        }
      }
      ScriptLoader.ScriptLoader = new ScriptLoader();
      const isDuplicated = (items, item) => {
        const firstIndex = items.indexOf(item);
        return firstIndex !== -1 && items.indexOf(item, firstIndex + 1) > firstIndex;
      };
      const isRaw = (str) => isObject(str) && has$2(str, "raw");
      const isTokenised = (str) => isArray$1(str) && str.length > 1;
      const data = {};
      const currentCode = Cell("en");
      const getLanguageData = () => get$a(data, currentCode.get());
      const getData$1 = () => map$2(data, (value2) => ({ ...value2 }));
      const setCode = (newCode) => {
        if (newCode) {
          currentCode.set(newCode);
        }
      };
      const getCode = () => currentCode.get();
      const add$1 = (code, items) => {
        let langData = data[code];
        if (!langData) {
          data[code] = langData = {};
        }
        const lcNames = map$3(keys(items), (name2) => name2.toLowerCase());
        each$d(items, (translation, name2) => {
          const lcName = name2.toLowerCase();
          if (lcName !== name2 && isDuplicated(lcNames, lcName)) {
            if (!has$2(items, lcName)) {
              langData[lcName] = translation;
            }
            langData[name2] = translation;
          } else {
            langData[lcName] = translation;
          }
        });
      };
      const translate = (text2) => {
        const langData = getLanguageData().getOr({});
        const toString2 = (obj) => {
          if (isFunction(obj)) {
            return Object.prototype.toString.call(obj);
          }
          return !isEmpty2(obj) ? "" + obj : "";
        };
        const isEmpty2 = (text3) => text3 === "" || text3 === null || text3 === void 0;
        const getLangData = (text3) => {
          const textStr = toString2(text3);
          return has$2(langData, textStr) ? toString2(langData[textStr]) : get$a(langData, textStr.toLowerCase()).map(toString2).getOr(textStr);
        };
        const removeContext = (str) => str.replace(/{context:\w+}$/, "");
        if (isEmpty2(text2)) {
          return "";
        }
        if (isRaw(text2)) {
          return toString2(text2.raw);
        }
        if (isTokenised(text2)) {
          const values2 = text2.slice(1);
          const substitued = getLangData(text2[0]).replace(/\{([0-9]+)\}/g, ($1, $2) => has$2(values2, $2) ? toString2(values2[$2]) : $1);
          return removeContext(substitued);
        }
        return removeContext(getLangData(text2));
      };
      const isRtl$1 = () => getLanguageData().bind((items) => get$a(items, "_dir")).exists((dir) => dir === "rtl");
      const hasCode = (code) => has$2(data, code);
      const I18n = {
        getData: getData$1,
        setCode,
        getCode,
        add: add$1,
        translate,
        isRtl: isRtl$1,
        hasCode
      };
      const AddOnManager = () => {
        const items = [];
        const urls = {};
        const lookup2 = {};
        const _listeners = [];
        const runListeners = (name2, state) => {
          const matchedListeners = filter$5(_listeners, (listener) => listener.name === name2 && listener.state === state);
          each$e(matchedListeners, (listener) => listener.resolve());
        };
        const isLoaded = (name2) => has$2(urls, name2);
        const isAdded = (name2) => has$2(lookup2, name2);
        const get2 = (name2) => {
          if (lookup2[name2]) {
            return lookup2[name2].instance;
          }
          return void 0;
        };
        const loadLanguagePack = (name2, languages) => {
          const language = I18n.getCode();
          const wrappedLanguages = "," + (languages || "") + ",";
          if (!language || languages && wrappedLanguages.indexOf("," + language + ",") === -1) {
            return;
          }
          ScriptLoader.ScriptLoader.add(urls[name2] + "/langs/" + language + ".js");
        };
        const requireLangPack = (name2, languages) => {
          if (AddOnManager.languageLoad !== false) {
            if (isLoaded(name2)) {
              loadLanguagePack(name2, languages);
            } else {
              waitFor(name2, "loaded").then(() => loadLanguagePack(name2, languages));
            }
          }
        };
        const add2 = (id, addOn) => {
          items.push(addOn);
          lookup2[id] = { instance: addOn };
          runListeners(id, "added");
          return addOn;
        };
        const remove2 = (name2) => {
          delete urls[name2];
          delete lookup2[name2];
        };
        const createUrl = (baseUrl, dep) => {
          if (isString(dep)) {
            return isString(baseUrl) ? {
              prefix: "",
              resource: dep,
              suffix: ""
            } : {
              prefix: baseUrl.prefix,
              resource: dep,
              suffix: baseUrl.suffix
            };
          } else {
            return dep;
          }
        };
        const load = (name2, addOnUrl) => {
          if (urls[name2]) {
            return Promise.resolve();
          }
          let urlString = isString(addOnUrl) ? addOnUrl : addOnUrl.prefix + addOnUrl.resource + addOnUrl.suffix;
          if (urlString.indexOf("/") !== 0 && urlString.indexOf("://") === -1) {
            urlString = AddOnManager.baseURL + "/" + urlString;
          }
          urls[name2] = urlString.substring(0, urlString.lastIndexOf("/"));
          const done = () => {
            runListeners(name2, "loaded");
            return Promise.resolve();
          };
          if (lookup2[name2]) {
            return done();
          } else {
            return ScriptLoader.ScriptLoader.add(urlString).then(done);
          }
        };
        const waitFor = (name2, state = "added") => {
          if (state === "added" && isAdded(name2)) {
            return Promise.resolve();
          } else if (state === "loaded" && isLoaded(name2)) {
            return Promise.resolve();
          } else {
            return new Promise((resolve2) => {
              _listeners.push({
                name: name2,
                state,
                resolve: resolve2
              });
            });
          }
        };
        return {
          items,
          urls,
          lookup: lookup2,
          get: get2,
          requireLangPack,
          add: add2,
          remove: remove2,
          createUrl,
          load,
          waitFor
        };
      };
      AddOnManager.languageLoad = true;
      AddOnManager.baseURL = "";
      AddOnManager.PluginManager = AddOnManager();
      AddOnManager.ThemeManager = AddOnManager();
      AddOnManager.ModelManager = AddOnManager();
      const first$1 = (fn, rate) => {
        let timer = null;
        const cancel = () => {
          if (!isNull(timer)) {
            clearTimeout(timer);
            timer = null;
          }
        };
        const throttle = (...args) => {
          if (isNull(timer)) {
            timer = setTimeout(() => {
              timer = null;
              fn.apply(null, args);
            }, rate);
          }
        };
        return {
          cancel,
          throttle
        };
      };
      const last = (fn, rate) => {
        let timer = null;
        const cancel = () => {
          if (!isNull(timer)) {
            clearTimeout(timer);
            timer = null;
          }
        };
        const throttle = (...args) => {
          cancel();
          timer = setTimeout(() => {
            timer = null;
            fn.apply(null, args);
          }, rate);
        };
        return {
          cancel,
          throttle
        };
      };
      const ancestor$1 = (scope, selector, isRoot2) => ancestor$3(scope, selector, isRoot2).isSome();
      const annotation = constant("mce-annotation");
      const dataAnnotation = constant("data-mce-annotation");
      const dataAnnotationId = constant("data-mce-annotation-uid");
      const dataAnnotationActive = constant("data-mce-annotation-active");
      const dataAnnotationClasses = constant("data-mce-annotation-classes");
      const dataAnnotationAttributes = constant("data-mce-annotation-attrs");
      const isRoot$1 = (root) => (node) => eq(node, root);
      const identify = (editor, annotationName) => {
        const rng = editor.selection.getRng();
        const start2 = SugarElement.fromDom(rng.startContainer);
        const root = SugarElement.fromDom(editor.getBody());
        const selector = annotationName.fold(() => "." + annotation(), (an) => `[${dataAnnotation()}="${an}"]`);
        const newStart = child$1(start2, rng.startOffset).getOr(start2);
        const closest2 = closest$3(newStart, selector, isRoot$1(root));
        return closest2.bind((c) => getOpt(c, `${dataAnnotationId()}`).bind((uid2) => getOpt(c, `${dataAnnotation()}`).map((name2) => {
          const elements = findMarkers(editor, uid2);
          return {
            uid: uid2,
            name: name2,
            elements
          };
        })));
      };
      const isAnnotation = (elem) => isElement$7(elem) && has(elem, annotation());
      const isBogusElement = (elem, root) => has$1(elem, "data-mce-bogus") || ancestor$1(elem, '[data-mce-bogus="all"]', isRoot$1(root));
      const findMarkers = (editor, uid2) => {
        const body = SugarElement.fromDom(editor.getBody());
        const descendants$12 = descendants(body, `[${dataAnnotationId()}="${uid2}"]`);
        return filter$5(descendants$12, (descendant2) => !isBogusElement(descendant2, body));
      };
      const findAll = (editor, name2) => {
        const body = SugarElement.fromDom(editor.getBody());
        const markers = descendants(body, `[${dataAnnotation()}="${name2}"]`);
        const directory = {};
        each$e(markers, (m) => {
          if (!isBogusElement(m, body)) {
            const uid2 = get$9(m, dataAnnotationId());
            const nodesAlready = get$a(directory, uid2).getOr([]);
            directory[uid2] = nodesAlready.concat([m]);
          }
        });
        return directory;
      };
      const setup$y = (editor, registry2) => {
        const changeCallbacks = Cell({});
        const initData = () => ({
          listeners: [],
          previous: value$2()
        });
        const withCallbacks = (name2, f) => {
          updateCallbacks(name2, (data2) => {
            f(data2);
            return data2;
          });
        };
        const updateCallbacks = (name2, f) => {
          const callbackMap = changeCallbacks.get();
          const data2 = get$a(callbackMap, name2).getOrThunk(initData);
          const outputData = f(data2);
          callbackMap[name2] = outputData;
          changeCallbacks.set(callbackMap);
        };
        const fireCallbacks = (name2, uid2, elements) => {
          withCallbacks(name2, (data2) => {
            each$e(data2.listeners, (f) => f(true, name2, {
              uid: uid2,
              nodes: map$3(elements, (elem) => elem.dom)
            }));
          });
        };
        const fireNoAnnotation = (name2) => {
          withCallbacks(name2, (data2) => {
            each$e(data2.listeners, (f) => f(false, name2));
          });
        };
        const toggleActiveAttr = (uid2, state) => {
          each$e(findMarkers(editor, uid2), (elem) => {
            if (state) {
              set$4(elem, dataAnnotationActive(), "true");
            } else {
              remove$9(elem, dataAnnotationActive());
            }
          });
        };
        const onNodeChange = last(() => {
          const annotations = sort(registry2.getNames());
          each$e(annotations, (name2) => {
            updateCallbacks(name2, (data2) => {
              const prev2 = data2.previous.get();
              identify(editor, Optional.some(name2)).fold(() => {
                prev2.each((uid2) => {
                  fireNoAnnotation(name2);
                  data2.previous.clear();
                  toggleActiveAttr(uid2, false);
                });
              }, ({ uid: uid2, name: name3, elements }) => {
                if (!is$2(prev2, uid2)) {
                  prev2.each((uid3) => toggleActiveAttr(uid3, false));
                  fireCallbacks(name3, uid2, elements);
                  data2.previous.set(uid2);
                  toggleActiveAttr(uid2, true);
                }
              });
              return {
                previous: data2.previous,
                listeners: data2.listeners
              };
            });
          });
        }, 30);
        editor.on("remove", () => {
          onNodeChange.cancel();
        });
        editor.on("NodeChange", () => {
          onNodeChange.throttle();
        });
        const addListener = (name2, f) => {
          updateCallbacks(name2, (data2) => ({
            previous: data2.previous,
            listeners: data2.listeners.concat([f])
          }));
        };
        return { addListener };
      };
      const setup$x = (editor, registry2) => {
        const dataAnnotation$1 = dataAnnotation();
        const identifyParserNode = (node) => Optional.from(node.attr(dataAnnotation$1)).bind(registry2.lookup);
        const removeDirectAnnotation2 = (node) => {
          var _a, _b;
          node.attr(dataAnnotationId(), null);
          node.attr(dataAnnotation(), null);
          node.attr(dataAnnotationActive(), null);
          const customAttrNames = Optional.from(node.attr(dataAnnotationAttributes())).map((names) => names.split(",")).getOr([]);
          const customClasses = Optional.from(node.attr(dataAnnotationClasses())).map((names) => names.split(",")).getOr([]);
          each$e(customAttrNames, (name2) => node.attr(name2, null));
          const classList = (_b = (_a = node.attr("class")) === null || _a === void 0 ? void 0 : _a.split(" ")) !== null && _b !== void 0 ? _b : [];
          const newClassList = difference(classList, [annotation()].concat(customClasses));
          node.attr("class", newClassList.length > 0 ? newClassList.join(" ") : null);
          node.attr(dataAnnotationClasses(), null);
          node.attr(dataAnnotationAttributes(), null);
        };
        editor.serializer.addTempAttr(dataAnnotationActive());
        editor.serializer.addAttributeFilter(dataAnnotation$1, (nodes) => {
          for (const node of nodes) {
            identifyParserNode(node).each((settings) => {
              if (settings.persistent === false) {
                if (node.name === "span") {
                  node.unwrap();
                } else {
                  removeDirectAnnotation2(node);
                }
              }
            });
          }
        });
      };
      const create$b = () => {
        const annotations = {};
        const register2 = (name2, settings) => {
          annotations[name2] = {
            name: name2,
            settings
          };
        };
        const lookup2 = (name2) => get$a(annotations, name2).map((a) => a.settings);
        const getNames = () => keys(annotations);
        return {
          register: register2,
          lookup: lookup2,
          getNames
        };
      };
      const clamp$2 = (value2, min2, max2) => Math.min(Math.max(value2, min2), max2);
      const random = () => window.crypto.getRandomValues(new Uint32Array(1))[0] / 4294967295;
      let unique = 0;
      const generate$1 = (prefix) => {
        const date = /* @__PURE__ */ new Date();
        const time = date.getTime();
        const random$1 = Math.floor(random() * 1e9);
        unique++;
        return prefix + "_" + random$1 + unique + String(time);
      };
      const add = (element, classes) => {
        each$e(classes, (x) => {
          add$2(element, x);
        });
      };
      const remove$3 = (element, classes) => {
        each$e(classes, (x) => {
          remove$6(element, x);
        });
      };
      const clone$2 = (original, isDeep) => SugarElement.fromDom(original.dom.cloneNode(isDeep));
      const shallow$1 = (original) => clone$2(original, false);
      const deep$1 = (original) => clone$2(original, true);
      const shallowAs = (original, tag) => {
        const nu2 = SugarElement.fromTag(tag);
        const attributes = clone$4(original);
        setAll$1(nu2, attributes);
        return nu2;
      };
      const mutate = (original, tag) => {
        const nu2 = shallowAs(original, tag);
        after$4(original, nu2);
        const children2 = children$1(original);
        append(nu2, children2);
        remove$4(original);
        return nu2;
      };
      const TextWalker = (startNode, rootNode, isBoundary2 = never) => {
        const walker = new DomTreeWalker(startNode, rootNode);
        const walk2 = (direction) => {
          let next2;
          do {
            next2 = walker[direction]();
          } while (next2 && !isText$b(next2) && !isBoundary2(next2));
          return Optional.from(next2).filter(isText$b);
        };
        return {
          current: () => Optional.from(walker.current()).filter(isText$b),
          next: () => walk2("next"),
          prev: () => walk2("prev"),
          prev2: () => walk2("prev2")
        };
      };
      const TextSeeker = (dom2, isBoundary2) => {
        const isBlockBoundary = isBoundary2 ? isBoundary2 : (node) => dom2.isBlock(node) || isBr$6(node) || isContentEditableFalse$b(node);
        const walk2 = (node, offset, walker, process2) => {
          if (isText$b(node)) {
            const newOffset = process2(node, offset, node.data);
            if (newOffset !== -1) {
              return Optional.some({
                container: node,
                offset: newOffset
              });
            }
          }
          return walker().bind((next2) => walk2(next2.container, next2.offset, walker, process2));
        };
        const backwards = (node, offset, process2, root) => {
          const walker = TextWalker(node, root !== null && root !== void 0 ? root : dom2.getRoot(), isBlockBoundary);
          return walk2(node, offset, () => walker.prev().map((prev2) => ({
            container: prev2,
            offset: prev2.length
          })), process2).getOrNull();
        };
        const forwards = (node, offset, process2, root) => {
          const walker = TextWalker(node, root !== null && root !== void 0 ? root : dom2.getRoot(), isBlockBoundary);
          return walk2(node, offset, () => walker.next().map((next2) => ({
            container: next2,
            offset: 0
          })), process2).getOrNull();
        };
        return {
          backwards,
          forwards
        };
      };
      const NodeValue = (is2, name2) => {
        const get2 = (element) => {
          if (!is2(element)) {
            throw new Error("Can only get " + name2 + " value of a " + name2 + " node");
          }
          return getOption2(element).getOr("");
        };
        const getOption2 = (element) => is2(element) ? Optional.from(element.dom.nodeValue) : Optional.none();
        const set2 = (element, value2) => {
          if (!is2(element)) {
            throw new Error("Can only set raw " + name2 + " value of a " + name2 + " node");
          }
          element.dom.nodeValue = value2;
        };
        return {
          get: get2,
          getOption: getOption2,
          set: set2
        };
      };
      const api$1 = NodeValue(isText$c, "text");
      const get$3 = (element) => api$1.get(element);
      const getOption = (element) => api$1.getOption(element);
      const set = (element, value2) => api$1.set(element, value2);
      const tableCells = [
        "td",
        "th"
      ];
      const tableSections = [
        "thead",
        "tbody",
        "tfoot"
      ];
      const textBlocks = [
        "h1",
        "h2",
        "h3",
        "h4",
        "h5",
        "h6",
        "p",
        "div",
        "address",
        "pre",
        "form",
        "blockquote",
        "center",
        "dir",
        "fieldset",
        "header",
        "footer",
        "article",
        "section",
        "hgroup",
        "aside",
        "nav",
        "figure"
      ];
      const listItems$1 = [
        "li",
        "dd",
        "dt"
      ];
      const lists = [
        "ul",
        "ol",
        "dl"
      ];
      const wsElements = [
        "pre",
        "script",
        "textarea",
        "style"
      ];
      const lazyLookup = (items) => {
        let lookup2;
        return (node) => {
          lookup2 = lookup2 ? lookup2 : mapToObject(items, always);
          return has$2(lookup2, name(node));
        };
      };
      const isTable$1 = (node) => name(node) === "table";
      const isBr$5 = (node) => isElement$7(node) && name(node) === "br";
      const isTextBlock$2 = lazyLookup(textBlocks);
      const isList = lazyLookup(lists);
      const isListItem$1 = lazyLookup(listItems$1);
      const isTableSection = lazyLookup(tableSections);
      const isTableCell$2 = lazyLookup(tableCells);
      const isWsPreserveElement = lazyLookup(wsElements);
      const getLastChildren$1 = (elm) => {
        const children2 = [];
        let rawNode = elm.dom;
        while (rawNode) {
          children2.push(SugarElement.fromDom(rawNode));
          rawNode = rawNode.lastChild;
        }
        return children2;
      };
      const removeTrailingBr = (elm) => {
        const allBrs = descendants(elm, "br");
        const brs = filter$5(getLastChildren$1(elm).slice(-1), isBr$5);
        if (allBrs.length === brs.length) {
          each$e(brs, remove$4);
        }
      };
      const createPaddingBr = () => {
        const br = SugarElement.fromTag("br");
        set$4(br, "data-mce-bogus", "1");
        return br;
      };
      const fillWithPaddingBr = (elm) => {
        empty(elm);
        append$1(elm, createPaddingBr());
      };
      const trimBlockTrailingBr = (elm, schema) => {
        lastChild(elm).each((lastChild2) => {
          prevSibling(lastChild2).each((lastChildPrevSibling) => {
            if (schema.isBlock(name(elm)) && isBr$5(lastChild2) && schema.isBlock(name(lastChildPrevSibling))) {
              remove$4(lastChild2);
            }
          });
        });
      };
      const ZWSP$1 = zeroWidth;
      const isZwsp = isZwsp$2;
      const trim$2 = removeZwsp;
      const insert$5 = (editor) => editor.insertContent(ZWSP$1, { preserve_zwsp: true });
      const isElement$5 = isElement$6;
      const isText$9 = isText$b;
      const isCaretContainerBlock$1 = (node) => {
        if (isText$9(node)) {
          node = node.parentNode;
        }
        return isElement$5(node) && node.hasAttribute("data-mce-caret");
      };
      const isCaretContainerInline = (node) => isText$9(node) && isZwsp(node.data);
      const isCaretContainer$2 = (node) => isCaretContainerBlock$1(node) || isCaretContainerInline(node);
      const hasContent = (node) => node.firstChild !== node.lastChild || !isBr$6(node.firstChild);
      const insertInline$1 = (node, before2) => {
        var _a;
        const doc = (_a = node.ownerDocument) !== null && _a !== void 0 ? _a : document;
        const textNode = doc.createTextNode(ZWSP$1);
        const parentNode = node.parentNode;
        if (!before2) {
          const sibling2 = node.nextSibling;
          if (isText$9(sibling2)) {
            if (isCaretContainer$2(sibling2)) {
              return sibling2;
            }
            if (startsWithCaretContainer$1(sibling2)) {
              sibling2.splitText(1);
              return sibling2;
            }
          }
          if (node.nextSibling) {
            parentNode === null || parentNode === void 0 ? void 0 : parentNode.insertBefore(textNode, node.nextSibling);
          } else {
            parentNode === null || parentNode === void 0 ? void 0 : parentNode.appendChild(textNode);
          }
        } else {
          const sibling2 = node.previousSibling;
          if (isText$9(sibling2)) {
            if (isCaretContainer$2(sibling2)) {
              return sibling2;
            }
            if (endsWithCaretContainer$1(sibling2)) {
              return sibling2.splitText(sibling2.data.length - 1);
            }
          }
          parentNode === null || parentNode === void 0 ? void 0 : parentNode.insertBefore(textNode, node);
        }
        return textNode;
      };
      const isBeforeInline = (pos) => {
        const container = pos.container();
        if (!isText$b(container)) {
          return false;
        }
        return container.data.charAt(pos.offset()) === ZWSP$1 || pos.isAtStart() && isCaretContainerInline(container.previousSibling);
      };
      const isAfterInline = (pos) => {
        const container = pos.container();
        if (!isText$b(container)) {
          return false;
        }
        return container.data.charAt(pos.offset() - 1) === ZWSP$1 || pos.isAtEnd() && isCaretContainerInline(container.nextSibling);
      };
      const insertBlock = (blockName, node, before2) => {
        var _a;
        const doc = (_a = node.ownerDocument) !== null && _a !== void 0 ? _a : document;
        const blockNode = doc.createElement(blockName);
        blockNode.setAttribute("data-mce-caret", before2 ? "before" : "after");
        blockNode.setAttribute("data-mce-bogus", "all");
        blockNode.appendChild(createPaddingBr().dom);
        const parentNode = node.parentNode;
        if (!before2) {
          if (node.nextSibling) {
            parentNode === null || parentNode === void 0 ? void 0 : parentNode.insertBefore(blockNode, node.nextSibling);
          } else {
            parentNode === null || parentNode === void 0 ? void 0 : parentNode.appendChild(blockNode);
          }
        } else {
          parentNode === null || parentNode === void 0 ? void 0 : parentNode.insertBefore(blockNode, node);
        }
        return blockNode;
      };
      const startsWithCaretContainer$1 = (node) => isText$9(node) && node.data[0] === ZWSP$1;
      const endsWithCaretContainer$1 = (node) => isText$9(node) && node.data[node.data.length - 1] === ZWSP$1;
      const trimBogusBr = (elm) => {
        var _a;
        const brs = elm.getElementsByTagName("br");
        const lastBr = brs[brs.length - 1];
        if (isBogus$1(lastBr)) {
          (_a = lastBr.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(lastBr);
        }
      };
      const showCaretContainerBlock = (caretContainer) => {
        if (caretContainer && caretContainer.hasAttribute("data-mce-caret")) {
          trimBogusBr(caretContainer);
          caretContainer.removeAttribute("data-mce-caret");
          caretContainer.removeAttribute("data-mce-bogus");
          caretContainer.removeAttribute("style");
          caretContainer.removeAttribute("data-mce-style");
          caretContainer.removeAttribute("_moz_abspos");
          return caretContainer;
        }
        return null;
      };
      const isRangeInCaretContainerBlock = (range2) => isCaretContainerBlock$1(range2.startContainer);
      const round$2 = Math.round;
      const clone$1 = (rect) => {
        if (!rect) {
          return {
            left: 0,
            top: 0,
            bottom: 0,
            right: 0,
            width: 0,
            height: 0
          };
        }
        return {
          left: round$2(rect.left),
          top: round$2(rect.top),
          bottom: round$2(rect.bottom),
          right: round$2(rect.right),
          width: round$2(rect.width),
          height: round$2(rect.height)
        };
      };
      const collapse = (rect, toStart) => {
        rect = clone$1(rect);
        if (toStart) {
          rect.right = rect.left;
        } else {
          rect.left = rect.left + rect.width;
          rect.right = rect.left;
        }
        rect.width = 0;
        return rect;
      };
      const isEqual = (rect1, rect2) => rect1.left === rect2.left && rect1.top === rect2.top && rect1.bottom === rect2.bottom && rect1.right === rect2.right;
      const isValidOverflow = (overflowY, rect1, rect2) => overflowY >= 0 && overflowY <= Math.min(rect1.height, rect2.height) / 2;
      const isAbove$1 = (rect1, rect2) => {
        const halfHeight = Math.min(rect2.height / 2, rect1.height / 2);
        if (rect1.bottom - halfHeight < rect2.top) {
          return true;
        }
        if (rect1.top > rect2.bottom) {
          return false;
        }
        return isValidOverflow(rect2.top - rect1.bottom, rect1, rect2);
      };
      const isBelow$1 = (rect1, rect2) => {
        if (rect1.top > rect2.bottom) {
          return true;
        }
        if (rect1.bottom < rect2.top) {
          return false;
        }
        return isValidOverflow(rect2.bottom - rect1.top, rect1, rect2);
      };
      const containsXY = (rect, clientX, clientY) => clientX >= rect.left && clientX <= rect.right && clientY >= rect.top && clientY <= rect.bottom;
      const boundingClientRectFromRects = (rects) => {
        return foldl(rects, (acc, rect) => {
          return acc.fold(() => Optional.some(rect), (prevRect) => {
            const left = Math.min(rect.left, prevRect.left);
            const top = Math.min(rect.top, prevRect.top);
            const right = Math.max(rect.right, prevRect.right);
            const bottom = Math.max(rect.bottom, prevRect.bottom);
            return Optional.some({
              top,
              right,
              bottom,
              left,
              width: right - left,
              height: bottom - top
            });
          });
        }, Optional.none());
      };
      const distanceToRectEdgeFromXY = (rect, x, y) => {
        const cx = Math.max(Math.min(x, rect.left + rect.width), rect.left);
        const cy = Math.max(Math.min(y, rect.top + rect.height), rect.top);
        return Math.sqrt((x - cx) * (x - cx) + (y - cy) * (y - cy));
      };
      const overlapY = (r1, r2) => Math.max(0, Math.min(r1.bottom, r2.bottom) - Math.max(r1.top, r2.top));
      const getSelectedNode = (range2) => {
        const startContainer = range2.startContainer, startOffset = range2.startOffset;
        if (startContainer === range2.endContainer && startContainer.hasChildNodes() && range2.endOffset === startOffset + 1) {
          return startContainer.childNodes[startOffset];
        }
        return null;
      };
      const getNode$1 = (container, offset) => {
        if (isElement$6(container) && container.hasChildNodes()) {
          const childNodes = container.childNodes;
          const safeOffset = clamp$2(offset, 0, childNodes.length - 1);
          return childNodes[safeOffset];
        } else {
          return container;
        }
      };
      const getNodeUnsafe = (container, offset) => {
        if (offset < 0 && isElement$6(container) && container.hasChildNodes()) {
          return void 0;
        } else {
          return getNode$1(container, offset);
        }
      };
      const extendingChars = new RegExp("[̀-ͯ҃-҇҈-҉֑-ֽֿׁ-ׂׄ-ׇׅؐ-ًؚ-ٰٟۖ-ۜ۟-ۤۧ-۪ۨ-ܑۭܰ-݊ަ-ް߫-߳ࠖ-࠙ࠛ-ࠣࠥ-ࠧࠩ-࡙࠭-࡛ࣣ-ंऺ़ु-ै्॑-ॗॢ-ॣঁ়াু-ৄ্ৗৢ-ৣਁ-ਂ਼ੁ-ੂੇ-ੈੋ-੍ੑੰ-ੱੵઁ-ં઼ુ-ૅે-ૈ્ૢ-ૣଁ଼ାିୁ-ୄ୍ୖୗୢ-ୣஂாீ்ௗఀా-ీె-ైొ-్ౕ-ౖౢ-ౣಁ಼ಿೂೆೌ-್ೕ-ೖೢ-ೣഁാു-ൄ്ൗൢ-ൣ්ාි-ුූෟัิ-ฺ็-๎ັິ-ູົ-ຼ່-ໍ༘-ཱ༹༙༵༷-ཾྀ-྄྆-྇ྍ-ྗྙ-ྼ࿆ိ-ူဲ-့္-်ွ-ှၘ-ၙၞ-ၠၱ-ၴႂႅ-ႆႍႝ፝-፟ᜒ-᜔ᜲ-᜴ᝒ-ᝓᝲ-ᝳ឴-឵ិ-ួំ៉-៓៝᠋-᠍ᢩᤠ-ᤢᤧ-ᤨᤲ᤹-᤻ᨗ-ᨘᨛᩖᩘ-ᩞ᩠ᩢᩥ-ᩬᩳ-᩿᩼᪰-᪽᪾ᬀ-ᬃ᬴ᬶ-ᬺᬼᭂ᭫-᭳ᮀ-ᮁᮢ-ᮥᮨ-ᮩ᮫-ᮭ᯦ᯨ-ᯩᯭᯯ-ᯱᰬ-ᰳᰶ-᰷᳐-᳔᳒-᳢᳠-᳨᳭᳴᳸-᳹᷀-᷵᷼-᷿‌-‍⃐-⃜⃝-⃠⃡⃢-⃤⃥-⃰⳯-⵿⳱ⷠ-〪ⷿ-〭〮-゙〯-゚꙯꙰-꙲ꙴ-꙽ꚞ-ꚟ꛰-꛱ꠂ꠆ꠋꠥ-ꠦ꣄꣠-꣱ꤦ-꤭ꥇ-ꥑꦀ-ꦂ꦳ꦶ-ꦹꦼꧥꨩ-ꨮꨱ-ꨲꨵ-ꨶꩃꩌꩼꪰꪲ-ꪴꪷ-ꪸꪾ-꪿꫁ꫬ-ꫭ꫶ꯥꯨ꯭ﬞ︀-️︠-︯ﾞ-ﾟ]");
      const isExtendingChar = (ch) => isString(ch) && ch.charCodeAt(0) >= 768 && extendingChars.test(ch);
      const or = (...args) => {
        return (x) => {
          for (let i = 0; i < args.length; i++) {
            if (args[i](x)) {
              return true;
            }
          }
          return false;
        };
      };
      const and = (...args) => {
        return (x) => {
          for (let i = 0; i < args.length; i++) {
            if (!args[i](x)) {
              return false;
            }
          }
          return true;
        };
      };
      const isContentEditableTrue$2 = isContentEditableTrue$3;
      const isContentEditableFalse$a = isContentEditableFalse$b;
      const isBr$4 = isBr$6;
      const isText$8 = isText$b;
      const isInvalidTextElement = matchNodeNames([
        "script",
        "style",
        "textarea"
      ]);
      const isAtomicInline = matchNodeNames([
        "img",
        "input",
        "textarea",
        "hr",
        "iframe",
        "video",
        "audio",
        "object",
        "embed"
      ]);
      const isTable = matchNodeNames(["table"]);
      const isCaretContainer$1 = isCaretContainer$2;
      const isCaretCandidate$3 = (node) => {
        if (isCaretContainer$1(node)) {
          return false;
        }
        if (isText$8(node)) {
          return !isInvalidTextElement(node.parentNode);
        }
        return isAtomicInline(node) || isBr$4(node) || isTable(node) || isNonUiContentEditableFalse(node);
      };
      const isUnselectable = (node) => isElement$6(node) && node.getAttribute("unselectable") === "true";
      const isNonUiContentEditableFalse = (node) => !isUnselectable(node) && isContentEditableFalse$a(node);
      const isInEditable = (node, root) => {
        for (let tempNode = node.parentNode; tempNode && tempNode !== root; tempNode = tempNode.parentNode) {
          if (isNonUiContentEditableFalse(tempNode)) {
            return false;
          }
          if (isContentEditableTrue$2(tempNode)) {
            return true;
          }
        }
        return true;
      };
      const isAtomicContentEditableFalse = (node) => {
        if (!isNonUiContentEditableFalse(node)) {
          return false;
        }
        return !foldl(from(node.getElementsByTagName("*")), (result, elm) => {
          return result || isContentEditableTrue$2(elm);
        }, false);
      };
      const isAtomic$1 = (node) => isAtomicInline(node) || isAtomicContentEditableFalse(node);
      const isEditableCaretCandidate$1 = (node, root) => isCaretCandidate$3(node) && isInEditable(node, root);
      const isElement$4 = isElement$6;
      const isCaretCandidate$2 = isCaretCandidate$3;
      const isBlock$2 = matchStyleValues("display", "block table");
      const isFloated = matchStyleValues("float", "left right");
      const isValidElementCaretCandidate = and(isElement$4, isCaretCandidate$2, not(isFloated));
      const isNotPre = not(matchStyleValues("white-space", "pre pre-line pre-wrap"));
      const isText$7 = isText$b;
      const isBr$3 = isBr$6;
      const nodeIndex$1 = DOMUtils.nodeIndex;
      const resolveIndex$1 = getNodeUnsafe;
      const createRange$1 = (doc) => doc ? doc.createRange() : DOMUtils.DOM.createRng();
      const isWhiteSpace$1 = (chr) => isString(chr) && /[\r\n\t ]/.test(chr);
      const isRange = (rng) => !!rng.setStart && !!rng.setEnd;
      const isHiddenWhiteSpaceRange = (range2) => {
        const container = range2.startContainer;
        const offset = range2.startOffset;
        if (isWhiteSpace$1(range2.toString()) && isNotPre(container.parentNode) && isText$b(container)) {
          const text2 = container.data;
          if (isWhiteSpace$1(text2[offset - 1]) || isWhiteSpace$1(text2[offset + 1])) {
            return true;
          }
        }
        return false;
      };
      const getBrClientRect = (brNode) => {
        const doc = brNode.ownerDocument;
        const rng = createRange$1(doc);
        const nbsp$1 = doc.createTextNode(nbsp);
        const parentNode = brNode.parentNode;
        parentNode.insertBefore(nbsp$1, brNode);
        rng.setStart(nbsp$1, 0);
        rng.setEnd(nbsp$1, 1);
        const clientRect = clone$1(rng.getBoundingClientRect());
        parentNode.removeChild(nbsp$1);
        return clientRect;
      };
      const getBoundingClientRectWebKitText = (rng) => {
        const sc = rng.startContainer;
        const ec = rng.endContainer;
        const so = rng.startOffset;
        const eo = rng.endOffset;
        if (sc === ec && isText$b(ec) && so === 0 && eo === 1) {
          const newRng = rng.cloneRange();
          newRng.setEndAfter(ec);
          return getBoundingClientRect$1(newRng);
        } else {
          return null;
        }
      };
      const isZeroRect = (r2) => r2.left === 0 && r2.right === 0 && r2.top === 0 && r2.bottom === 0;
      const getBoundingClientRect$1 = (item) => {
        var _a;
        let clientRect;
        const clientRects = item.getClientRects();
        if (clientRects.length > 0) {
          clientRect = clone$1(clientRects[0]);
        } else {
          clientRect = clone$1(item.getBoundingClientRect());
        }
        if (!isRange(item) && isBr$3(item) && isZeroRect(clientRect)) {
          return getBrClientRect(item);
        }
        if (isZeroRect(clientRect) && isRange(item)) {
          return (_a = getBoundingClientRectWebKitText(item)) !== null && _a !== void 0 ? _a : clientRect;
        }
        return clientRect;
      };
      const collapseAndInflateWidth = (clientRect, toStart) => {
        const newClientRect = collapse(clientRect, toStart);
        newClientRect.width = 1;
        newClientRect.right = newClientRect.left + 1;
        return newClientRect;
      };
      const getCaretPositionClientRects = (caretPosition) => {
        const clientRects = [];
        const addUniqueAndValidRect = (clientRect) => {
          if (clientRect.height === 0) {
            return;
          }
          if (clientRects.length > 0) {
            if (isEqual(clientRect, clientRects[clientRects.length - 1])) {
              return;
            }
          }
          clientRects.push(clientRect);
        };
        const addCharacterOffset = (container2, offset2) => {
          const range2 = createRange$1(container2.ownerDocument);
          if (offset2 < container2.data.length) {
            if (isExtendingChar(container2.data[offset2])) {
              return;
            }
            if (isExtendingChar(container2.data[offset2 - 1])) {
              range2.setStart(container2, offset2);
              range2.setEnd(container2, offset2 + 1);
              if (!isHiddenWhiteSpaceRange(range2)) {
                addUniqueAndValidRect(collapseAndInflateWidth(getBoundingClientRect$1(range2), false));
                return;
              }
            }
          }
          if (offset2 > 0) {
            range2.setStart(container2, offset2 - 1);
            range2.setEnd(container2, offset2);
            if (!isHiddenWhiteSpaceRange(range2)) {
              addUniqueAndValidRect(collapseAndInflateWidth(getBoundingClientRect$1(range2), false));
            }
          }
          if (offset2 < container2.data.length) {
            range2.setStart(container2, offset2);
            range2.setEnd(container2, offset2 + 1);
            if (!isHiddenWhiteSpaceRange(range2)) {
              addUniqueAndValidRect(collapseAndInflateWidth(getBoundingClientRect$1(range2), true));
            }
          }
        };
        const container = caretPosition.container();
        const offset = caretPosition.offset();
        if (isText$7(container)) {
          addCharacterOffset(container, offset);
          return clientRects;
        }
        if (isElement$4(container)) {
          if (caretPosition.isAtEnd()) {
            const node = resolveIndex$1(container, offset);
            if (isText$7(node)) {
              addCharacterOffset(node, node.data.length);
            }
            if (isValidElementCaretCandidate(node) && !isBr$3(node)) {
              addUniqueAndValidRect(collapseAndInflateWidth(getBoundingClientRect$1(node), false));
            }
          } else {
            const node = resolveIndex$1(container, offset);
            if (isText$7(node)) {
              addCharacterOffset(node, 0);
            }
            if (isValidElementCaretCandidate(node) && caretPosition.isAtEnd()) {
              addUniqueAndValidRect(collapseAndInflateWidth(getBoundingClientRect$1(node), false));
              return clientRects;
            }
            const beforeNode = resolveIndex$1(caretPosition.container(), caretPosition.offset() - 1);
            if (isValidElementCaretCandidate(beforeNode) && !isBr$3(beforeNode)) {
              if (isBlock$2(beforeNode) || isBlock$2(node) || !isValidElementCaretCandidate(node)) {
                addUniqueAndValidRect(collapseAndInflateWidth(getBoundingClientRect$1(beforeNode), false));
              }
            }
            if (isValidElementCaretCandidate(node)) {
              addUniqueAndValidRect(collapseAndInflateWidth(getBoundingClientRect$1(node), true));
            }
          }
        }
        return clientRects;
      };
      const CaretPosition = (container, offset, clientRects) => {
        const isAtStart = () => {
          if (isText$7(container)) {
            return offset === 0;
          }
          return offset === 0;
        };
        const isAtEnd = () => {
          if (isText$7(container)) {
            return offset >= container.data.length;
          }
          return offset >= container.childNodes.length;
        };
        const toRange = () => {
          const range2 = createRange$1(container.ownerDocument);
          range2.setStart(container, offset);
          range2.setEnd(container, offset);
          return range2;
        };
        const getClientRects2 = () => {
          if (!clientRects) {
            clientRects = getCaretPositionClientRects(CaretPosition(container, offset));
          }
          return clientRects;
        };
        const isVisible = () => getClientRects2().length > 0;
        const isEqual2 = (caretPosition) => caretPosition && container === caretPosition.container() && offset === caretPosition.offset();
        const getNode2 = (before2) => resolveIndex$1(container, before2 ? offset - 1 : offset);
        return {
          container: constant(container),
          offset: constant(offset),
          toRange,
          getClientRects: getClientRects2,
          isVisible,
          isAtStart,
          isAtEnd,
          isEqual: isEqual2,
          getNode: getNode2
        };
      };
      CaretPosition.fromRangeStart = (range2) => CaretPosition(range2.startContainer, range2.startOffset);
      CaretPosition.fromRangeEnd = (range2) => CaretPosition(range2.endContainer, range2.endOffset);
      CaretPosition.after = (node) => CaretPosition(node.parentNode, nodeIndex$1(node) + 1);
      CaretPosition.before = (node) => CaretPosition(node.parentNode, nodeIndex$1(node));
      CaretPosition.isAbove = (pos1, pos2) => lift2(head(pos2.getClientRects()), last$2(pos1.getClientRects()), isAbove$1).getOr(false);
      CaretPosition.isBelow = (pos1, pos2) => lift2(last$2(pos2.getClientRects()), head(pos1.getClientRects()), isBelow$1).getOr(false);
      CaretPosition.isAtStart = (pos) => pos ? pos.isAtStart() : false;
      CaretPosition.isAtEnd = (pos) => pos ? pos.isAtEnd() : false;
      CaretPosition.isTextPosition = (pos) => pos ? isText$b(pos.container()) : false;
      CaretPosition.isElementPosition = (pos) => !CaretPosition.isTextPosition(pos);
      const trimEmptyTextNode$1 = (dom2, node) => {
        if (isText$b(node) && node.data.length === 0) {
          dom2.remove(node);
        }
      };
      const insertNode = (dom2, rng, node) => {
        rng.insertNode(node);
        trimEmptyTextNode$1(dom2, node.previousSibling);
        trimEmptyTextNode$1(dom2, node.nextSibling);
      };
      const insertFragment = (dom2, rng, frag) => {
        const firstChild2 = Optional.from(frag.firstChild);
        const lastChild2 = Optional.from(frag.lastChild);
        rng.insertNode(frag);
        firstChild2.each((child2) => trimEmptyTextNode$1(dom2, child2.previousSibling));
        lastChild2.each((child2) => trimEmptyTextNode$1(dom2, child2.nextSibling));
      };
      const rangeInsertNode = (dom2, rng, node) => {
        if (isDocumentFragment(node)) {
          insertFragment(dom2, rng, node);
        } else {
          insertNode(dom2, rng, node);
        }
      };
      const isText$6 = isText$b;
      const isBogus = isBogus$1;
      const nodeIndex = DOMUtils.nodeIndex;
      const normalizedParent = (node) => {
        const parentNode = node.parentNode;
        if (isBogus(parentNode)) {
          return normalizedParent(parentNode);
        }
        return parentNode;
      };
      const getChildNodes = (node) => {
        if (!node) {
          return [];
        }
        return reduce(node.childNodes, (result, node2) => {
          if (isBogus(node2) && node2.nodeName !== "BR") {
            result = result.concat(getChildNodes(node2));
          } else {
            result.push(node2);
          }
          return result;
        }, []);
      };
      const normalizedTextOffset = (node, offset) => {
        let tempNode = node;
        while (tempNode = tempNode.previousSibling) {
          if (!isText$6(tempNode)) {
            break;
          }
          offset += tempNode.data.length;
        }
        return offset;
      };
      const equal = (a) => (b) => a === b;
      const normalizedNodeIndex = (node) => {
        let nodes, index;
        nodes = getChildNodes(normalizedParent(node));
        index = findIndex$1(nodes, equal(node), node);
        nodes = nodes.slice(0, index + 1);
        const numTextFragments = reduce(nodes, (result, node2, i) => {
          if (isText$6(node2) && isText$6(nodes[i - 1])) {
            result++;
          }
          return result;
        }, 0);
        nodes = filter$3(nodes, matchNodeNames([node.nodeName]));
        index = findIndex$1(nodes, equal(node), node);
        return index - numTextFragments;
      };
      const createPathItem = (node) => {
        const name2 = isText$6(node) ? "text()" : node.nodeName.toLowerCase();
        return name2 + "[" + normalizedNodeIndex(node) + "]";
      };
      const parentsUntil$1 = (root, node, predicate) => {
        const parents2 = [];
        for (let tempNode = node.parentNode; tempNode && tempNode !== root; tempNode = tempNode.parentNode) {
          if (predicate && predicate(tempNode)) {
            break;
          }
          parents2.push(tempNode);
        }
        return parents2;
      };
      const create$a = (root, caretPosition) => {
        let path2 = [];
        let container = caretPosition.container();
        let offset = caretPosition.offset();
        let outputOffset;
        if (isText$6(container)) {
          outputOffset = normalizedTextOffset(container, offset);
        } else {
          const childNodes = container.childNodes;
          if (offset >= childNodes.length) {
            outputOffset = "after";
            offset = childNodes.length - 1;
          } else {
            outputOffset = "before";
          }
          container = childNodes[offset];
        }
        path2.push(createPathItem(container));
        let parents2 = parentsUntil$1(root, container);
        parents2 = filter$3(parents2, not(isBogus$1));
        path2 = path2.concat(map$1(parents2, (node) => {
          return createPathItem(node);
        }));
        return path2.reverse().join("/") + "," + outputOffset;
      };
      const resolvePathItem = (node, name2, index) => {
        let nodes = getChildNodes(node);
        nodes = filter$3(nodes, (node2, index2) => {
          return !isText$6(node2) || !isText$6(nodes[index2 - 1]);
        });
        nodes = filter$3(nodes, matchNodeNames([name2]));
        return nodes[index];
      };
      const findTextPosition = (container, offset) => {
        let node = container;
        let targetOffset = 0;
        while (isText$6(node)) {
          const dataLen = node.data.length;
          if (offset >= targetOffset && offset <= targetOffset + dataLen) {
            container = node;
            offset = offset - targetOffset;
            break;
          }
          if (!isText$6(node.nextSibling)) {
            container = node;
            offset = dataLen;
            break;
          }
          targetOffset += dataLen;
          node = node.nextSibling;
        }
        if (isText$6(container) && offset > container.data.length) {
          offset = container.data.length;
        }
        return CaretPosition(container, offset);
      };
      const resolve$1 = (root, path2) => {
        if (!path2) {
          return null;
        }
        const parts = path2.split(",");
        const paths = parts[0].split("/");
        const offset = parts.length > 1 ? parts[1] : "before";
        const container = reduce(paths, (result, value2) => {
          const match2 = /([\w\-\(\)]+)\[([0-9]+)\]/.exec(value2);
          if (!match2) {
            return null;
          }
          if (match2[1] === "text()") {
            match2[1] = "#text";
          }
          return resolvePathItem(result, match2[1], parseInt(match2[2], 10));
        }, root);
        if (!container) {
          return null;
        }
        if (!isText$6(container) && container.parentNode) {
          let nodeOffset;
          if (offset === "after") {
            nodeOffset = nodeIndex(container) + 1;
          } else {
            nodeOffset = nodeIndex(container);
          }
          return CaretPosition(container.parentNode, nodeOffset);
        }
        return findTextPosition(container, parseInt(offset, 10));
      };
      const isContentEditableFalse$9 = isContentEditableFalse$b;
      const getNormalizedTextOffset$1 = (trim2, container, offset) => {
        let trimmedOffset = trim2(container.data.slice(0, offset)).length;
        for (let node = container.previousSibling; node && isText$b(node); node = node.previousSibling) {
          trimmedOffset += trim2(node.data).length;
        }
        return trimmedOffset;
      };
      const getPoint = (dom2, trim2, normalized, rng, start2) => {
        const container = start2 ? rng.startContainer : rng.endContainer;
        let offset = start2 ? rng.startOffset : rng.endOffset;
        const point2 = [];
        const root = dom2.getRoot();
        if (isText$b(container)) {
          point2.push(normalized ? getNormalizedTextOffset$1(trim2, container, offset) : offset);
        } else {
          let after2 = 0;
          const childNodes = container.childNodes;
          if (offset >= childNodes.length && childNodes.length) {
            after2 = 1;
            offset = Math.max(0, childNodes.length - 1);
          }
          point2.push(dom2.nodeIndex(childNodes[offset], normalized) + after2);
        }
        for (let node = container; node && node !== root; node = node.parentNode) {
          point2.push(dom2.nodeIndex(node, normalized));
        }
        return point2;
      };
      const getLocation = (trim2, selection, normalized, rng) => {
        const dom2 = selection.dom;
        const start2 = getPoint(dom2, trim2, normalized, rng, true);
        const forward = selection.isForward();
        const fakeCaret = isRangeInCaretContainerBlock(rng) ? { isFakeCaret: true } : {};
        if (!selection.isCollapsed()) {
          const end2 = getPoint(dom2, trim2, normalized, rng, false);
          return {
            start: start2,
            end: end2,
            forward,
            ...fakeCaret
          };
        } else {
          return {
            start: start2,
            forward,
            ...fakeCaret
          };
        }
      };
      const findIndex = (dom2, name2, element) => {
        let count2 = 0;
        Tools.each(dom2.select(name2), (node) => {
          if (node.getAttribute("data-mce-bogus") === "all") {
            return;
          } else if (node === element) {
            return false;
          } else {
            count2++;
            return;
          }
        });
        return count2;
      };
      const moveEndPoint$1 = (rng, start2) => {
        let container = start2 ? rng.startContainer : rng.endContainer;
        let offset = start2 ? rng.startOffset : rng.endOffset;
        if (isElement$6(container) && container.nodeName === "TR") {
          const childNodes = container.childNodes;
          container = childNodes[Math.min(start2 ? offset : offset - 1, childNodes.length - 1)];
          if (container) {
            offset = start2 ? 0 : container.childNodes.length;
            if (start2) {
              rng.setStart(container, offset);
            } else {
              rng.setEnd(container, offset);
            }
          }
        }
      };
      const normalizeTableCellSelection = (rng) => {
        moveEndPoint$1(rng, true);
        moveEndPoint$1(rng, false);
        return rng;
      };
      const findSibling = (node, offset) => {
        if (isElement$6(node)) {
          node = getNode$1(node, offset);
          if (isContentEditableFalse$9(node)) {
            return node;
          }
        }
        if (isCaretContainer$2(node)) {
          if (isText$b(node) && isCaretContainerBlock$1(node)) {
            node = node.parentNode;
          }
          let sibling2 = node.previousSibling;
          if (isContentEditableFalse$9(sibling2)) {
            return sibling2;
          }
          sibling2 = node.nextSibling;
          if (isContentEditableFalse$9(sibling2)) {
            return sibling2;
          }
        }
        return void 0;
      };
      const findAdjacentContentEditableFalseElm = (rng) => {
        return findSibling(rng.startContainer, rng.startOffset) || findSibling(rng.endContainer, rng.endOffset);
      };
      const getOffsetBookmark = (trim2, normalized, selection) => {
        const element = selection.getNode();
        const rng = selection.getRng();
        if (element.nodeName === "IMG" || isContentEditableFalse$9(element)) {
          const name2 = element.nodeName;
          return {
            name: name2,
            index: findIndex(selection.dom, name2, element)
          };
        }
        const sibling2 = findAdjacentContentEditableFalseElm(rng);
        if (sibling2) {
          const name2 = sibling2.tagName;
          return {
            name: name2,
            index: findIndex(selection.dom, name2, sibling2)
          };
        }
        return getLocation(trim2, selection, normalized, rng);
      };
      const getCaretBookmark = (selection) => {
        const rng = selection.getRng();
        return {
          start: create$a(selection.dom.getRoot(), CaretPosition.fromRangeStart(rng)),
          end: create$a(selection.dom.getRoot(), CaretPosition.fromRangeEnd(rng)),
          forward: selection.isForward()
        };
      };
      const getRangeBookmark = (selection) => {
        return {
          rng: selection.getRng(),
          forward: selection.isForward()
        };
      };
      const createBookmarkSpan = (dom2, id, filled) => {
        const args = {
          "data-mce-type": "bookmark",
          id,
          "style": "overflow:hidden;line-height:0px"
        };
        return filled ? dom2.create("span", args, "&#xFEFF;") : dom2.create("span", args);
      };
      const getPersistentBookmark = (selection, filled) => {
        const dom2 = selection.dom;
        let rng = selection.getRng();
        const id = dom2.uniqueId();
        const collapsed = selection.isCollapsed();
        const element = selection.getNode();
        const name2 = element.nodeName;
        const forward = selection.isForward();
        if (name2 === "IMG") {
          return {
            name: name2,
            index: findIndex(dom2, name2, element)
          };
        }
        const rng2 = normalizeTableCellSelection(rng.cloneRange());
        if (!collapsed) {
          rng2.collapse(false);
          const endBookmarkNode = createBookmarkSpan(dom2, id + "_end", filled);
          rangeInsertNode(dom2, rng2, endBookmarkNode);
        }
        rng = normalizeTableCellSelection(rng);
        rng.collapse(true);
        const startBookmarkNode = createBookmarkSpan(dom2, id + "_start", filled);
        rangeInsertNode(dom2, rng, startBookmarkNode);
        selection.moveToBookmark({
          id,
          keep: true,
          forward
        });
        return {
          id,
          forward
        };
      };
      const getBookmark$3 = (selection, type2, normalized = false) => {
        if (type2 === 2) {
          return getOffsetBookmark(trim$2, normalized, selection);
        } else if (type2 === 3) {
          return getCaretBookmark(selection);
        } else if (type2) {
          return getRangeBookmark(selection);
        } else {
          return getPersistentBookmark(selection, false);
        }
      };
      const getUndoBookmark = curry(getOffsetBookmark, identity, true);
      const value$1 = (value2) => {
        const applyHelper = (fn) => fn(value2);
        const constHelper = constant(value2);
        const outputHelper = () => output;
        const output = {
          tag: true,
          inner: value2,
          fold: (_onError, onValue) => onValue(value2),
          isValue: always,
          isError: never,
          map: (mapper) => Result.value(mapper(value2)),
          mapError: outputHelper,
          bind: applyHelper,
          exists: applyHelper,
          forall: applyHelper,
          getOr: constHelper,
          or: outputHelper,
          getOrThunk: constHelper,
          orThunk: outputHelper,
          getOrDie: constHelper,
          each: (fn) => {
            fn(value2);
          },
          toOptional: () => Optional.some(value2)
        };
        return output;
      };
      const error = (error2) => {
        const outputHelper = () => output;
        const output = {
          tag: false,
          inner: error2,
          fold: (onError, _onValue) => onError(error2),
          isValue: never,
          isError: always,
          map: outputHelper,
          mapError: (mapper) => Result.error(mapper(error2)),
          bind: outputHelper,
          exists: never,
          forall: always,
          getOr: identity,
          or: identity,
          getOrThunk: apply$1,
          orThunk: apply$1,
          getOrDie: die(String(error2)),
          each: noop,
          toOptional: Optional.none
        };
        return output;
      };
      const fromOption = (optional, err) => optional.fold(() => error(err), value$1);
      const Result = {
        value: value$1,
        error,
        fromOption
      };
      const generate = (cases) => {
        if (!isArray$1(cases)) {
          throw new Error("cases must be an array");
        }
        if (cases.length === 0) {
          throw new Error("there must be at least one case");
        }
        const constructors = [];
        const adt2 = {};
        each$e(cases, (acase, count2) => {
          const keys$1 = keys(acase);
          if (keys$1.length !== 1) {
            throw new Error("one and only one name per case");
          }
          const key = keys$1[0];
          const value2 = acase[key];
          if (adt2[key] !== void 0) {
            throw new Error("duplicate key detected:" + key);
          } else if (key === "cata") {
            throw new Error("cannot have a case named cata (sorry)");
          } else if (!isArray$1(value2)) {
            throw new Error("case arguments must be an array");
          }
          constructors.push(key);
          adt2[key] = (...args) => {
            const argLength = args.length;
            if (argLength !== value2.length) {
              throw new Error("Wrong number of arguments to case " + key + ". Expected " + value2.length + " (" + value2 + "), got " + argLength);
            }
            const match2 = (branches) => {
              const branchKeys = keys(branches);
              if (constructors.length !== branchKeys.length) {
                throw new Error("Wrong number of arguments to match. Expected: " + constructors.join(",") + "\nActual: " + branchKeys.join(","));
              }
              const allReqd = forall(constructors, (reqKey) => {
                return contains$2(branchKeys, reqKey);
              });
              if (!allReqd) {
                throw new Error("Not all branches were specified when using match. Specified: " + branchKeys.join(", ") + "\nRequired: " + constructors.join(", "));
              }
              return branches[key].apply(null, args);
            };
            return {
              fold: (...foldArgs) => {
                if (foldArgs.length !== cases.length) {
                  throw new Error("Wrong number of arguments to fold. Expected " + cases.length + ", got " + foldArgs.length);
                }
                const target = foldArgs[count2];
                return target.apply(null, args);
              },
              match: match2,
              log: (label) => {
                console.log(label, {
                  constructors,
                  constructor: key,
                  params: args
                });
              }
            };
          };
        });
        return adt2;
      };
      const Adt = { generate };
      Adt.generate([
        {
          bothErrors: [
            "error1",
            "error2"
          ]
        },
        {
          firstError: [
            "error1",
            "value2"
          ]
        },
        {
          secondError: [
            "value1",
            "error2"
          ]
        },
        {
          bothValues: [
            "value1",
            "value2"
          ]
        }
      ]);
      const partition$1 = (results) => {
        const errors = [];
        const values2 = [];
        each$e(results, (result) => {
          result.fold((err) => {
            errors.push(err);
          }, (value2) => {
            values2.push(value2);
          });
        });
        return {
          errors,
          values: values2
        };
      };
      const isInlinePattern = (pattern) => pattern.type === "inline-command" || pattern.type === "inline-format";
      const isBlockPattern = (pattern) => pattern.type === "block-command" || pattern.type === "block-format";
      const hasBlockTrigger = (pattern, trigger) => (pattern.type === "block-command" || pattern.type === "block-format") && pattern.trigger === trigger;
      const normalizePattern = (pattern) => {
        var _a;
        const err = (message) => Result.error({
          message,
          pattern
        });
        const formatOrCmd = (name2, onFormat, onCommand) => {
          if (pattern.format !== void 0) {
            let formats;
            if (isArray$1(pattern.format)) {
              if (!forall(pattern.format, isString)) {
                return err(name2 + " pattern has non-string items in the `format` array");
              }
              formats = pattern.format;
            } else if (isString(pattern.format)) {
              formats = [pattern.format];
            } else {
              return err(name2 + " pattern has non-string `format` parameter");
            }
            return Result.value(onFormat(formats));
          } else if (pattern.cmd !== void 0) {
            if (!isString(pattern.cmd)) {
              return err(name2 + " pattern has non-string `cmd` parameter");
            }
            return Result.value(onCommand(pattern.cmd, pattern.value));
          } else {
            return err(name2 + " pattern is missing both `format` and `cmd` parameters");
          }
        };
        if (!isObject(pattern)) {
          return err("Raw pattern is not an object");
        }
        if (!isString(pattern.start)) {
          return err("Raw pattern is missing `start` parameter");
        }
        if (pattern.end !== void 0) {
          if (!isString(pattern.end)) {
            return err("Inline pattern has non-string `end` parameter");
          }
          if (pattern.start.length === 0 && pattern.end.length === 0) {
            return err("Inline pattern has empty `start` and `end` parameters");
          }
          let start2 = pattern.start;
          let end2 = pattern.end;
          if (end2.length === 0) {
            end2 = start2;
            start2 = "";
          }
          return formatOrCmd("Inline", (format) => ({
            type: "inline-format",
            start: start2,
            end: end2,
            format
          }), (cmd, value2) => ({
            type: "inline-command",
            start: start2,
            end: end2,
            cmd,
            value: value2
          }));
        } else if (pattern.replacement !== void 0) {
          if (!isString(pattern.replacement)) {
            return err("Replacement pattern has non-string `replacement` parameter");
          }
          if (pattern.start.length === 0) {
            return err("Replacement pattern has empty `start` parameter");
          }
          return Result.value({
            type: "inline-command",
            start: "",
            end: pattern.start,
            cmd: "mceInsertContent",
            value: pattern.replacement
          });
        } else {
          const trigger = (_a = pattern.trigger) !== null && _a !== void 0 ? _a : "space";
          if (pattern.start.length === 0) {
            return err("Block pattern has empty `start` parameter");
          }
          return formatOrCmd("Block", (formats) => ({
            type: "block-format",
            start: pattern.start,
            format: formats[0],
            trigger
          }), (command, commandValue) => ({
            type: "block-command",
            start: pattern.start,
            cmd: command,
            value: commandValue,
            trigger
          }));
        }
      };
      const getBlockPatterns = (patterns) => filter$5(patterns, isBlockPattern);
      const getInlinePatterns = (patterns) => filter$5(patterns, isInlinePattern);
      const createPatternSet = (patterns, dynamicPatternsLookup) => ({
        inlinePatterns: getInlinePatterns(patterns),
        blockPatterns: getBlockPatterns(patterns),
        dynamicPatternsLookup
      });
      const filterByTrigger = (patterns, trigger) => {
        return {
          ...patterns,
          blockPatterns: filter$5(patterns.blockPatterns, (pattern) => hasBlockTrigger(pattern, trigger))
        };
      };
      const fromRawPatterns = (patterns) => {
        const normalized = partition$1(map$3(patterns, normalizePattern));
        each$e(normalized.errors, (err) => console.error(err.message, err.pattern));
        return normalized.values;
      };
      const fromRawPatternsLookup = (lookupFn) => {
        return (ctx) => {
          const rawPatterns = lookupFn(ctx);
          return fromRawPatterns(rawPatterns);
        };
      };
      const firePreProcess = (editor, args) => editor.dispatch("PreProcess", args);
      const firePostProcess = (editor, args) => editor.dispatch("PostProcess", args);
      const fireRemove = (editor) => {
        editor.dispatch("remove");
      };
      const fireDetach = (editor) => {
        editor.dispatch("detach");
      };
      const fireSwitchMode = (editor, mode) => {
        editor.dispatch("SwitchMode", { mode });
      };
      const fireObjectResizeStart = (editor, target, width, height, origin) => {
        editor.dispatch("ObjectResizeStart", {
          target,
          width,
          height,
          origin
        });
      };
      const fireObjectResized = (editor, target, width, height, origin) => {
        editor.dispatch("ObjectResized", {
          target,
          width,
          height,
          origin
        });
      };
      const firePreInit = (editor) => {
        editor.dispatch("PreInit");
      };
      const firePostRender = (editor) => {
        editor.dispatch("PostRender");
      };
      const fireInit = (editor) => {
        editor.dispatch("Init");
      };
      const firePlaceholderToggle = (editor, state) => {
        editor.dispatch("PlaceholderToggle", { state });
      };
      const fireError = (editor, errorType, error2) => {
        editor.dispatch(errorType, error2);
      };
      const fireFormatApply = (editor, format, node, vars) => {
        editor.dispatch("FormatApply", {
          format,
          node,
          vars
        });
      };
      const fireFormatRemove = (editor, format, node, vars) => {
        editor.dispatch("FormatRemove", {
          format,
          node,
          vars
        });
      };
      const fireBeforeSetContent = (editor, args) => editor.dispatch("BeforeSetContent", args);
      const fireSetContent = (editor, args) => editor.dispatch("SetContent", args);
      const fireBeforeGetContent = (editor, args) => editor.dispatch("BeforeGetContent", args);
      const fireGetContent = (editor, args) => editor.dispatch("GetContent", args);
      const fireAutocompleterStart = (editor, args) => {
        editor.dispatch("AutocompleterStart", args);
      };
      const fireAutocompleterUpdate = (editor, args) => {
        editor.dispatch("AutocompleterUpdate", args);
      };
      const fireAutocompleterUpdateActiveRange = (editor, args) => {
        editor.dispatch("AutocompleterUpdateActiveRange", args);
      };
      const fireAutocompleterEnd = (editor) => {
        editor.dispatch("AutocompleterEnd");
      };
      const firePastePreProcess = (editor, html2, internal) => editor.dispatch("PastePreProcess", {
        content: html2,
        internal
      });
      const firePastePostProcess = (editor, node, internal) => editor.dispatch("PastePostProcess", {
        node,
        internal
      });
      const firePastePlainTextToggle = (editor, state) => editor.dispatch("PastePlainTextToggle", { state });
      const fireEditableRootStateChange = (editor, state) => editor.dispatch("EditableRootStateChange", { state });
      const fireDisabledStateChange = (editor, state) => editor.dispatch("DisabledStateChange", { state });
      const deviceDetection$1 = detect$1().deviceType;
      const isTouch = deviceDetection$1.isTouch();
      const DOM$a = DOMUtils.DOM;
      const getHash = (value2) => {
        const items = value2.indexOf("=") > 0 ? value2.split(/[;,](?![^=;,]*(?:[;,]|$))/) : value2.split(",");
        return foldl(items, (output, item) => {
          const arr = item.split("=");
          const key = arr[0];
          const val = arr.length > 1 ? arr[1] : key;
          output[trim$4(key)] = trim$4(val);
          return output;
        }, {});
      };
      const isRegExp = (x) => is$4(x, RegExp);
      const option = (name2) => (editor) => editor.options.get(name2);
      const stringOrObjectProcessor = (value2) => isString(value2) || isObject(value2);
      const bodyOptionProcessor = (editor, defaultValue = "") => (value2) => {
        const valid = isString(value2);
        if (valid) {
          if (value2.indexOf("=") !== -1) {
            const bodyObj = getHash(value2);
            return {
              value: get$a(bodyObj, editor.id).getOr(defaultValue),
              valid
            };
          } else {
            return {
              value: value2,
              valid
            };
          }
        } else {
          return {
            valid: false,
            message: "Must be a string."
          };
        }
      };
      const register$7 = (editor) => {
        const registerOption = editor.options.register;
        registerOption("id", {
          processor: "string",
          default: editor.id
        });
        registerOption("selector", { processor: "string" });
        registerOption("target", { processor: "object" });
        registerOption("suffix", { processor: "string" });
        registerOption("cache_suffix", { processor: "string" });
        registerOption("base_url", { processor: "string" });
        registerOption("referrer_policy", {
          processor: "string",
          default: ""
        });
        registerOption("language_load", {
          processor: "boolean",
          default: true
        });
        registerOption("inline", {
          processor: "boolean",
          default: false
        });
        registerOption("iframe_attrs", {
          processor: "object",
          default: {}
        });
        registerOption("doctype", {
          processor: "string",
          default: "<!DOCTYPE html>"
        });
        registerOption("document_base_url", {
          processor: "string",
          default: editor.documentBaseUrl
        });
        registerOption("body_id", {
          processor: bodyOptionProcessor(editor, "tinymce"),
          default: "tinymce"
        });
        registerOption("body_class", {
          processor: bodyOptionProcessor(editor),
          default: ""
        });
        registerOption("content_security_policy", {
          processor: "string",
          default: ""
        });
        registerOption("br_in_pre", {
          processor: "boolean",
          default: true
        });
        registerOption("forced_root_block", {
          processor: (value2) => {
            const valid = isString(value2) && isNotEmpty(value2);
            if (valid) {
              return {
                value: value2,
                valid
              };
            } else {
              return {
                valid: false,
                message: "Must be a non-empty string."
              };
            }
          },
          default: "p"
        });
        registerOption("forced_root_block_attrs", {
          processor: "object",
          default: {}
        });
        registerOption("newline_behavior", {
          processor: (value2) => {
            const valid = contains$2([
              "block",
              "linebreak",
              "invert",
              "default"
            ], value2);
            return valid ? {
              value: value2,
              valid
            } : {
              valid: false,
              message: "Must be one of: block, linebreak, invert or default."
            };
          },
          default: "default"
        });
        registerOption("br_newline_selector", {
          processor: "string",
          default: ".mce-toc h2,figcaption,caption"
        });
        registerOption("no_newline_selector", {
          processor: "string",
          default: ""
        });
        registerOption("keep_styles", {
          processor: "boolean",
          default: true
        });
        registerOption("end_container_on_empty_block", {
          processor: (value2) => {
            if (isBoolean(value2)) {
              return {
                valid: true,
                value: value2
              };
            } else if (isString(value2)) {
              return {
                valid: true,
                value: value2
              };
            } else {
              return {
                valid: false,
                message: "Must be boolean or a string"
              };
            }
          },
          default: "blockquote"
        });
        registerOption("font_size_style_values", {
          processor: "string",
          default: "xx-small,x-small,small,medium,large,x-large,xx-large"
        });
        registerOption("font_size_legacy_values", {
          processor: "string",
          default: "xx-small,small,medium,large,x-large,xx-large,300%"
        });
        registerOption("font_size_classes", {
          processor: "string",
          default: ""
        });
        registerOption("automatic_uploads", {
          processor: "boolean",
          default: true
        });
        registerOption("images_reuse_filename", {
          processor: "boolean",
          default: false
        });
        registerOption("images_replace_blob_uris", {
          processor: "boolean",
          default: true
        });
        registerOption("icons", {
          processor: "string",
          default: ""
        });
        registerOption("icons_url", {
          processor: "string",
          default: ""
        });
        registerOption("images_upload_url", {
          processor: "string",
          default: ""
        });
        registerOption("images_upload_base_path", {
          processor: "string",
          default: ""
        });
        registerOption("images_upload_credentials", {
          processor: "boolean",
          default: false
        });
        registerOption("images_upload_handler", { processor: "function" });
        registerOption("language", {
          processor: "string",
          default: "en"
        });
        registerOption("language_url", {
          processor: "string",
          default: ""
        });
        registerOption("entity_encoding", {
          processor: "string",
          default: "named"
        });
        registerOption("indent", {
          processor: "boolean",
          default: true
        });
        registerOption("indent_before", {
          processor: "string",
          default: "p,h1,h2,h3,h4,h5,h6,blockquote,div,title,style,pre,script,td,th,ul,ol,li,dl,dt,dd,area,table,thead,tfoot,tbody,tr,section,details,summary,article,hgroup,aside,figure,figcaption,option,optgroup,datalist"
        });
        registerOption("indent_after", {
          processor: "string",
          default: "p,h1,h2,h3,h4,h5,h6,blockquote,div,title,style,pre,script,td,th,ul,ol,li,dl,dt,dd,area,table,thead,tfoot,tbody,tr,section,details,summary,article,hgroup,aside,figure,figcaption,option,optgroup,datalist"
        });
        registerOption("indent_use_margin", {
          processor: "boolean",
          default: false
        });
        registerOption("indentation", {
          processor: "string",
          default: "40px"
        });
        registerOption("content_css", {
          processor: (value2) => {
            const valid = value2 === false || isString(value2) || isArrayOf(value2, isString);
            if (valid) {
              if (isString(value2)) {
                return {
                  value: map$3(value2.split(","), trim$4),
                  valid
                };
              } else if (isArray$1(value2)) {
                return {
                  value: value2,
                  valid
                };
              } else if (value2 === false) {
                return {
                  value: [],
                  valid
                };
              } else {
                return {
                  value: value2,
                  valid
                };
              }
            } else {
              return {
                valid: false,
                message: "Must be false, a string or an array of strings."
              };
            }
          },
          default: isInline$1(editor) ? [] : ["default"]
        });
        registerOption("content_style", { processor: "string" });
        registerOption("content_css_cors", {
          processor: "boolean",
          default: false
        });
        registerOption("font_css", {
          processor: (value2) => {
            const valid = isString(value2) || isArrayOf(value2, isString);
            if (valid) {
              const newValue = isArray$1(value2) ? value2 : map$3(value2.split(","), trim$4);
              return {
                value: newValue,
                valid
              };
            } else {
              return {
                valid: false,
                message: "Must be a string or an array of strings."
              };
            }
          },
          default: []
        });
        registerOption("extended_mathml_attributes", { processor: "string[]" });
        registerOption("extended_mathml_elements", { processor: "string[]" });
        registerOption("inline_boundaries", {
          processor: "boolean",
          default: true
        });
        registerOption("inline_boundaries_selector", {
          processor: "string",
          default: "a[href],code,span.mce-annotation"
        });
        registerOption("object_resizing", {
          processor: (value2) => {
            const valid = isBoolean(value2) || isString(value2);
            if (valid) {
              if (value2 === false || deviceDetection$1.isiPhone() || deviceDetection$1.isiPad()) {
                return {
                  value: "",
                  valid
                };
              } else {
                return {
                  value: value2 === true ? "table,img,figure.image,div,video,iframe" : value2,
                  valid
                };
              }
            } else {
              return {
                valid: false,
                message: "Must be boolean or a string"
              };
            }
          },
          default: !isTouch
        });
        registerOption("resize_img_proportional", {
          processor: "boolean",
          default: true
        });
        registerOption("event_root", { processor: "string" });
        registerOption("service_message", { processor: "string" });
        registerOption("onboarding", {
          processor: "boolean",
          default: true
        });
        registerOption("tiny_cloud_entry_url", { processor: "string" });
        registerOption("theme", {
          processor: (value2) => value2 === false || isString(value2) || isFunction(value2),
          default: "silver"
        });
        registerOption("theme_url", { processor: "string" });
        registerOption("formats", { processor: "object" });
        registerOption("format_empty_lines", {
          processor: "boolean",
          default: false
        });
        registerOption("format_noneditable_selector", {
          processor: "string",
          default: ""
        });
        registerOption("preview_styles", {
          processor: (value2) => {
            const valid = value2 === false || isString(value2);
            if (valid) {
              return {
                value: value2 === false ? "" : value2,
                valid
              };
            } else {
              return {
                valid: false,
                message: "Must be false or a string"
              };
            }
          },
          default: "font-family font-size font-weight font-style text-decoration text-transform color background-color border border-radius outline text-shadow"
        });
        registerOption("custom_ui_selector", {
          processor: "string",
          default: ""
        });
        registerOption("hidden_input", {
          processor: "boolean",
          default: true
        });
        registerOption("submit_patch", {
          processor: "boolean",
          default: true
        });
        registerOption("encoding", { processor: "string" });
        registerOption("add_form_submit_trigger", {
          processor: "boolean",
          default: true
        });
        registerOption("add_unload_trigger", {
          processor: "boolean",
          default: true
        });
        registerOption("custom_undo_redo_levels", {
          processor: "number",
          default: 0
        });
        registerOption("disable_nodechange", {
          processor: "boolean",
          default: false
        });
        registerOption("disabled", {
          processor: (value2) => {
            if (isBoolean(value2)) {
              if (editor.initialized && isDisabled$1(editor) !== value2) {
                Promise.resolve().then(() => {
                  fireDisabledStateChange(editor, value2);
                });
              }
              return {
                valid: true,
                value: value2
              };
            }
            return {
              valid: false,
              message: "The value must be a boolean."
            };
          },
          default: false
        });
        registerOption("readonly", {
          processor: "boolean",
          default: false
        });
        registerOption("editable_root", {
          processor: "boolean",
          default: true
        });
        registerOption("plugins", {
          processor: "string[]",
          default: []
        });
        registerOption("external_plugins", { processor: "object" });
        registerOption("forced_plugins", { processor: "string[]" });
        registerOption("model", {
          processor: "string",
          default: editor.hasPlugin("rtc") ? "plugin" : "dom"
        });
        registerOption("model_url", { processor: "string" });
        registerOption("block_unsupported_drop", {
          processor: "boolean",
          default: true
        });
        registerOption("visual", {
          processor: "boolean",
          default: true
        });
        registerOption("visual_table_class", {
          processor: "string",
          default: "mce-item-table"
        });
        registerOption("visual_anchor_class", {
          processor: "string",
          default: "mce-item-anchor"
        });
        registerOption("iframe_aria_text", {
          processor: "string",
          default: "Rich Text Area".concat(editor.hasPlugin("help") ? ". Press ALT-0 for help." : "")
        });
        registerOption("setup", { processor: "function" });
        registerOption("init_instance_callback", { processor: "function" });
        registerOption("url_converter", {
          processor: "function",
          default: editor.convertURL
        });
        registerOption("url_converter_scope", {
          processor: "object",
          default: editor
        });
        registerOption("urlconverter_callback", { processor: "function" });
        registerOption("allow_conditional_comments", {
          processor: "boolean",
          default: false
        });
        registerOption("allow_html_data_urls", {
          processor: "boolean",
          default: false
        });
        registerOption("allow_svg_data_urls", { processor: "boolean" });
        registerOption("allow_html_in_named_anchor", {
          processor: "boolean",
          default: false
        });
        registerOption("allow_script_urls", {
          processor: "boolean",
          default: false
        });
        registerOption("allow_unsafe_link_target", {
          processor: "boolean",
          default: false
        });
        registerOption("allow_mathml_annotation_encodings", {
          processor: (value2) => {
            const valid = isArrayOf(value2, isString);
            return valid ? {
              value: value2,
              valid
            } : {
              valid: false,
              message: "Must be an array of strings."
            };
          },
          default: []
        });
        registerOption("convert_fonts_to_spans", {
          processor: "boolean",
          default: true,
          deprecated: true
        });
        registerOption("fix_list_elements", {
          processor: "boolean",
          default: false
        });
        registerOption("preserve_cdata", {
          processor: "boolean",
          default: false
        });
        registerOption("remove_trailing_brs", {
          processor: "boolean",
          default: true
        });
        registerOption("pad_empty_with_br", {
          processor: "boolean",
          default: false
        });
        registerOption("inline_styles", {
          processor: "boolean",
          default: true,
          deprecated: true
        });
        registerOption("element_format", {
          processor: "string",
          default: "html"
        });
        registerOption("entities", { processor: "string" });
        registerOption("schema", {
          processor: "string",
          default: "html5"
        });
        registerOption("convert_urls", {
          processor: "boolean",
          default: true
        });
        registerOption("relative_urls", {
          processor: "boolean",
          default: true
        });
        registerOption("remove_script_host", {
          processor: "boolean",
          default: true
        });
        registerOption("custom_elements", { processor: stringOrObjectProcessor });
        registerOption("extended_valid_elements", { processor: "string" });
        registerOption("invalid_elements", { processor: "string" });
        registerOption("invalid_styles", { processor: stringOrObjectProcessor });
        registerOption("valid_children", { processor: "string" });
        registerOption("valid_classes", { processor: stringOrObjectProcessor });
        registerOption("valid_elements", { processor: "string" });
        registerOption("valid_styles", { processor: stringOrObjectProcessor });
        registerOption("verify_html", {
          processor: "boolean",
          default: true
        });
        registerOption("auto_focus", { processor: (value2) => isString(value2) || value2 === true });
        registerOption("browser_spellcheck", {
          processor: "boolean",
          default: false
        });
        registerOption("protect", { processor: "array" });
        registerOption("images_file_types", {
          processor: "string",
          default: "jpeg,jpg,jpe,jfi,jif,jfif,png,gif,bmp,webp"
        });
        registerOption("deprecation_warnings", {
          processor: "boolean",
          default: true
        });
        registerOption("a11y_advanced_options", {
          processor: "boolean",
          default: false
        });
        registerOption("api_key", { processor: "string" });
        registerOption("license_key", { processor: "string" });
        registerOption("paste_block_drop", {
          processor: "boolean",
          default: false
        });
        registerOption("paste_data_images", {
          processor: "boolean",
          default: true
        });
        registerOption("paste_preprocess", { processor: "function" });
        registerOption("paste_postprocess", { processor: "function" });
        registerOption("paste_webkit_styles", {
          processor: "string",
          default: "none"
        });
        registerOption("paste_remove_styles_if_webkit", {
          processor: "boolean",
          default: true
        });
        registerOption("paste_merge_formats", {
          processor: "boolean",
          default: true
        });
        registerOption("smart_paste", {
          processor: "boolean",
          default: true
        });
        registerOption("paste_as_text", {
          processor: "boolean",
          default: false
        });
        registerOption("paste_tab_spaces", {
          processor: "number",
          default: 4
        });
        registerOption("text_patterns", {
          processor: (value2) => {
            if (isArrayOf(value2, isObject) || value2 === false) {
              const patterns = value2 === false ? [] : value2;
              return {
                value: fromRawPatterns(patterns),
                valid: true
              };
            } else {
              return {
                valid: false,
                message: "Must be an array of objects or false."
              };
            }
          },
          default: [
            {
              start: "*",
              end: "*",
              format: "italic"
            },
            {
              start: "**",
              end: "**",
              format: "bold"
            },
            {
              start: "#",
              format: "h1",
              trigger: "space"
            },
            {
              start: "##",
              format: "h2",
              trigger: "space"
            },
            {
              start: "###",
              format: "h3",
              trigger: "space"
            },
            {
              start: "####",
              format: "h4",
              trigger: "space"
            },
            {
              start: "#####",
              format: "h5",
              trigger: "space"
            },
            {
              start: "######",
              format: "h6",
              trigger: "space"
            },
            {
              start: "1.",
              cmd: "InsertOrderedList",
              trigger: "space"
            },
            {
              start: "*",
              cmd: "InsertUnorderedList",
              trigger: "space"
            },
            {
              start: "-",
              cmd: "InsertUnorderedList",
              trigger: "space"
            },
            {
              start: ">",
              cmd: "mceBlockQuote",
              trigger: "space"
            },
            {
              start: "---",
              cmd: "InsertHorizontalRule",
              trigger: "space"
            }
          ]
        });
        registerOption("text_patterns_lookup", {
          processor: (value2) => {
            if (isFunction(value2)) {
              return {
                value: fromRawPatternsLookup(value2),
                valid: true
              };
            } else {
              return {
                valid: false,
                message: "Must be a single function"
              };
            }
          },
          default: (_ctx) => []
        });
        registerOption("noneditable_class", {
          processor: "string",
          default: "mceNonEditable"
        });
        registerOption("editable_class", {
          processor: "string",
          default: "mceEditable"
        });
        registerOption("noneditable_regexp", {
          processor: (value2) => {
            if (isArrayOf(value2, isRegExp)) {
              return {
                value: value2,
                valid: true
              };
            } else if (isRegExp(value2)) {
              return {
                value: [value2],
                valid: true
              };
            } else {
              return {
                valid: false,
                message: "Must be a RegExp or an array of RegExp."
              };
            }
          },
          default: []
        });
        registerOption("table_tab_navigation", {
          processor: "boolean",
          default: true
        });
        registerOption("highlight_on_focus", {
          processor: "boolean",
          default: true
        });
        registerOption("xss_sanitization", {
          processor: "boolean",
          default: true
        });
        registerOption("details_initial_state", {
          processor: (value2) => {
            const valid = contains$2([
              "inherited",
              "collapsed",
              "expanded"
            ], value2);
            return valid ? {
              value: value2,
              valid
            } : {
              valid: false,
              message: "Must be one of: inherited, collapsed, or expanded."
            };
          },
          default: "inherited"
        });
        registerOption("details_serialized_state", {
          processor: (value2) => {
            const valid = contains$2([
              "inherited",
              "collapsed",
              "expanded"
            ], value2);
            return valid ? {
              value: value2,
              valid
            } : {
              valid: false,
              message: "Must be one of: inherited, collapsed, or expanded."
            };
          },
          default: "inherited"
        });
        registerOption("init_content_sync", {
          processor: "boolean",
          default: false
        });
        registerOption("newdocument_content", {
          processor: "string",
          default: ""
        });
        registerOption("sandbox_iframes", {
          processor: "boolean",
          default: true
        });
        registerOption("sandbox_iframes_exclusions", {
          processor: "string[]",
          default: [
            "youtube.com",
            "youtu.be",
            "vimeo.com",
            "player.vimeo.com",
            "dailymotion.com",
            "embed.music.apple.com",
            "open.spotify.com",
            "giphy.com",
            "dai.ly",
            "codepen.io"
          ]
        });
        registerOption("convert_unsafe_embeds", {
          processor: "boolean",
          default: true
        });
        editor.on("ScriptsLoaded", () => {
          registerOption("directionality", {
            processor: "string",
            default: I18n.isRtl() ? "rtl" : void 0
          });
          registerOption("placeholder", {
            processor: "string",
            default: DOM$a.getAttrib(editor.getElement(), "placeholder")
          });
        });
      };
      const getIframeAttrs = option("iframe_attrs");
      const getDocType = option("doctype");
      const getDocumentBaseUrl = option("document_base_url");
      const getBodyId = option("body_id");
      const getBodyClass = option("body_class");
      const getContentSecurityPolicy = option("content_security_policy");
      const shouldPutBrInPre$1 = option("br_in_pre");
      const getForcedRootBlock = option("forced_root_block");
      const getForcedRootBlockAttrs = option("forced_root_block_attrs");
      const getNewlineBehavior = option("newline_behavior");
      const getBrNewLineSelector = option("br_newline_selector");
      const getNoNewLineSelector = option("no_newline_selector");
      const shouldKeepStyles = option("keep_styles");
      const shouldEndContainerOnEmptyBlock = option("end_container_on_empty_block");
      const isAutomaticUploadsEnabled = option("automatic_uploads");
      const shouldReuseFileName = option("images_reuse_filename");
      const shouldReplaceBlobUris = option("images_replace_blob_uris");
      const getIconPackName = option("icons");
      const getIconsUrl = option("icons_url");
      const getImageUploadUrl = option("images_upload_url");
      const getImageUploadBasePath = option("images_upload_base_path");
      const getImagesUploadCredentials = option("images_upload_credentials");
      const getImagesUploadHandler = option("images_upload_handler");
      const shouldUseContentCssCors = option("content_css_cors");
      const getReferrerPolicy = option("referrer_policy");
      const getLanguageCode = option("language");
      const getLanguageUrl = option("language_url");
      const shouldIndentUseMargin = option("indent_use_margin");
      const getIndentation = option("indentation");
      const getContentCss = option("content_css");
      const getContentStyle = option("content_style");
      const getFontCss = option("font_css");
      const getDirectionality = option("directionality");
      const getInlineBoundarySelector = option("inline_boundaries_selector");
      const getObjectResizing = option("object_resizing");
      const getResizeImgProportional = option("resize_img_proportional");
      const getPlaceholder = option("placeholder");
      const getEventRoot = option("event_root");
      const getServiceMessage = option("service_message");
      const getTheme = option("theme");
      const getThemeUrl = option("theme_url");
      const getModel = option("model");
      const getModelUrl = option("model_url");
      const isInlineBoundariesEnabled = option("inline_boundaries");
      const getFormats = option("formats");
      const getPreviewStyles = option("preview_styles");
      const canFormatEmptyLines = option("format_empty_lines");
      const getFormatNoneditableSelector = option("format_noneditable_selector");
      const getCustomUiSelector = option("custom_ui_selector");
      const isInline$1 = option("inline");
      const hasHiddenInput = option("hidden_input");
      const shouldPatchSubmit = option("submit_patch");
      const shouldAddFormSubmitTrigger = option("add_form_submit_trigger");
      const shouldAddUnloadTrigger = option("add_unload_trigger");
      const getCustomUndoRedoLevels = option("custom_undo_redo_levels");
      const shouldDisableNodeChange = option("disable_nodechange");
      const isReadOnly$1 = option("readonly");
      const hasEditableRoot$1 = option("editable_root");
      const hasContentCssCors = option("content_css_cors");
      const getPlugins = option("plugins");
      const getExternalPlugins$1 = option("external_plugins");
      const shouldBlockUnsupportedDrop = option("block_unsupported_drop");
      const isVisualAidsEnabled = option("visual");
      const getVisualAidsTableClass = option("visual_table_class");
      const getVisualAidsAnchorClass = option("visual_anchor_class");
      const getIframeAriaText = option("iframe_aria_text");
      const getSetupCallback = option("setup");
      const getInitInstanceCallback = option("init_instance_callback");
      const getUrlConverterCallback = option("urlconverter_callback");
      const getAutoFocus = option("auto_focus");
      const shouldBrowserSpellcheck = option("browser_spellcheck");
      const getProtect = option("protect");
      const shouldPasteBlockDrop = option("paste_block_drop");
      const shouldPasteDataImages = option("paste_data_images");
      const getPastePreProcess = option("paste_preprocess");
      const getPastePostProcess = option("paste_postprocess");
      const getNewDocumentContent = option("newdocument_content");
      const getPasteWebkitStyles = option("paste_webkit_styles");
      const shouldPasteRemoveWebKitStyles = option("paste_remove_styles_if_webkit");
      const shouldPasteMergeFormats = option("paste_merge_formats");
      const isSmartPasteEnabled = option("smart_paste");
      const isPasteAsTextEnabled = option("paste_as_text");
      const getPasteTabSpaces = option("paste_tab_spaces");
      const shouldAllowHtmlDataUrls = option("allow_html_data_urls");
      const getTextPatterns = option("text_patterns");
      const getTextPatternsLookup = option("text_patterns_lookup");
      const getNonEditableClass = option("noneditable_class");
      const getEditableClass = option("editable_class");
      const getNonEditableRegExps = option("noneditable_regexp");
      const shouldPreserveCData = option("preserve_cdata");
      const shouldHighlightOnFocus = option("highlight_on_focus");
      const shouldSanitizeXss = option("xss_sanitization");
      const shouldUseDocumentWrite = option("init_content_sync");
      const hasTextPatternsLookup = (editor) => editor.options.isSet("text_patterns_lookup");
      const getFontStyleValues = (editor) => Tools.explode(editor.options.get("font_size_style_values"));
      const getFontSizeClasses = (editor) => Tools.explode(editor.options.get("font_size_classes"));
      const isEncodingXml = (editor) => editor.options.get("encoding") === "xml";
      const getAllowedImageFileTypes = (editor) => Tools.explode(editor.options.get("images_file_types"));
      const hasTableTabNavigation = option("table_tab_navigation");
      const getDetailsInitialState = option("details_initial_state");
      const getDetailsSerializedState = option("details_serialized_state");
      const shouldSandboxIframes = option("sandbox_iframes");
      const getSandboxIframesExclusions = (editor) => editor.options.get("sandbox_iframes_exclusions");
      const shouldConvertUnsafeEmbeds = option("convert_unsafe_embeds");
      const getLicenseKey = option("license_key");
      const getApiKey = option("api_key");
      const isDisabled$1 = option("disabled");
      const isElement$3 = isElement$6;
      const isText$5 = isText$b;
      const removeNode$1 = (node) => {
        const parentNode = node.parentNode;
        if (parentNode) {
          parentNode.removeChild(node);
        }
      };
      const trimCount = (text2) => {
        const trimmedText = trim$2(text2);
        return {
          count: text2.length - trimmedText.length,
          text: trimmedText
        };
      };
      const deleteZwspChars = (caretContainer) => {
        let idx;
        while ((idx = caretContainer.data.lastIndexOf(ZWSP$1)) !== -1) {
          caretContainer.deleteData(idx, 1);
        }
      };
      const removeUnchanged = (caretContainer, pos) => {
        remove$2(caretContainer);
        return pos;
      };
      const removeTextAndReposition = (caretContainer, pos) => {
        const before2 = trimCount(caretContainer.data.substr(0, pos.offset()));
        const after2 = trimCount(caretContainer.data.substr(pos.offset()));
        const text2 = before2.text + after2.text;
        if (text2.length > 0) {
          deleteZwspChars(caretContainer);
          return CaretPosition(caretContainer, pos.offset() - before2.count);
        } else {
          return pos;
        }
      };
      const removeElementAndReposition = (caretContainer, pos) => {
        const parentNode = pos.container();
        const newPosition = indexOf$1(from(parentNode.childNodes), caretContainer).map((index) => {
          return index < pos.offset() ? CaretPosition(parentNode, pos.offset() - 1) : pos;
        }).getOr(pos);
        remove$2(caretContainer);
        return newPosition;
      };
      const removeTextCaretContainer = (caretContainer, pos) => isText$5(caretContainer) && pos.container() === caretContainer ? removeTextAndReposition(caretContainer, pos) : removeUnchanged(caretContainer, pos);
      const removeElementCaretContainer = (caretContainer, pos) => pos.container() === caretContainer.parentNode ? removeElementAndReposition(caretContainer, pos) : removeUnchanged(caretContainer, pos);
      const removeAndReposition = (container, pos) => CaretPosition.isTextPosition(pos) ? removeTextCaretContainer(container, pos) : removeElementCaretContainer(container, pos);
      const remove$2 = (caretContainerNode) => {
        if (isElement$3(caretContainerNode) && isCaretContainer$2(caretContainerNode)) {
          if (hasContent(caretContainerNode)) {
            caretContainerNode.removeAttribute("data-mce-caret");
          } else {
            removeNode$1(caretContainerNode);
          }
        }
        if (isText$5(caretContainerNode)) {
          deleteZwspChars(caretContainerNode);
          if (caretContainerNode.data.length === 0) {
            removeNode$1(caretContainerNode);
          }
        }
      };
      const isContentEditableFalse$8 = isContentEditableFalse$b;
      const isMedia$1 = isMedia$2;
      const isTableCell$1 = isTableCell$3;
      const inlineFakeCaretSelector = "*[contentEditable=false],video,audio,embed,object";
      const getAbsoluteClientRect = (root, element, before2) => {
        const clientRect = collapse(element.getBoundingClientRect(), before2);
        let scrollX;
        let scrollY;
        if (root.tagName === "BODY") {
          const docElm = root.ownerDocument.documentElement;
          scrollX = root.scrollLeft || docElm.scrollLeft;
          scrollY = root.scrollTop || docElm.scrollTop;
        } else {
          const rootRect = root.getBoundingClientRect();
          scrollX = root.scrollLeft - rootRect.left;
          scrollY = root.scrollTop - rootRect.top;
        }
        clientRect.left += scrollX;
        clientRect.right += scrollX;
        clientRect.top += scrollY;
        clientRect.bottom += scrollY;
        clientRect.width = 1;
        let margin = element.offsetWidth - element.clientWidth;
        if (margin > 0) {
          if (before2) {
            margin *= -1;
          }
          clientRect.left += margin;
          clientRect.right += margin;
        }
        return clientRect;
      };
      const trimInlineCaretContainers = (root) => {
        var _a, _b;
        const fakeCaretTargetNodes = descendants(SugarElement.fromDom(root), inlineFakeCaretSelector);
        for (let i = 0; i < fakeCaretTargetNodes.length; i++) {
          const node = fakeCaretTargetNodes[i].dom;
          let sibling2 = node.previousSibling;
          if (endsWithCaretContainer$1(sibling2)) {
            const data2 = sibling2.data;
            if (data2.length === 1) {
              (_a = sibling2.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(sibling2);
            } else {
              sibling2.deleteData(data2.length - 1, 1);
            }
          }
          sibling2 = node.nextSibling;
          if (startsWithCaretContainer$1(sibling2)) {
            const data2 = sibling2.data;
            if (data2.length === 1) {
              (_b = sibling2.parentNode) === null || _b === void 0 ? void 0 : _b.removeChild(sibling2);
            } else {
              sibling2.deleteData(0, 1);
            }
          }
        }
      };
      const FakeCaret = (editor, root, isBlock2, hasFocus2) => {
        const lastVisualCaret = value$2();
        let cursorInterval;
        let caretContainerNode;
        const caretBlock = getForcedRootBlock(editor);
        const dom2 = editor.dom;
        const show = (before2, element) => {
          let rng;
          hide();
          if (isTableCell$1(element)) {
            return null;
          }
          if (isBlock2(element)) {
            const caretContainer = insertBlock(caretBlock, element, before2);
            const clientRect = getAbsoluteClientRect(root, element, before2);
            dom2.setStyle(caretContainer, "top", clientRect.top);
            dom2.setStyle(caretContainer, "caret-color", "transparent");
            caretContainerNode = caretContainer;
            const caret = dom2.create("div", {
              "class": "mce-visual-caret",
              "data-mce-bogus": "all"
            });
            dom2.setStyles(caret, { ...clientRect });
            dom2.add(root, caret);
            lastVisualCaret.set({
              caret,
              element,
              before: before2
            });
            if (before2) {
              dom2.addClass(caret, "mce-visual-caret-before");
            }
            startBlink();
            rng = element.ownerDocument.createRange();
            rng.setStart(caretContainer, 0);
            rng.setEnd(caretContainer, 0);
          } else {
            caretContainerNode = insertInline$1(element, before2);
            rng = element.ownerDocument.createRange();
            if (isInlineFakeCaretTarget(caretContainerNode.nextSibling)) {
              rng.setStart(caretContainerNode, 0);
              rng.setEnd(caretContainerNode, 0);
            } else {
              rng.setStart(caretContainerNode, 1);
              rng.setEnd(caretContainerNode, 1);
            }
            return rng;
          }
          return rng;
        };
        const hide = () => {
          trimInlineCaretContainers(root);
          if (caretContainerNode) {
            remove$2(caretContainerNode);
            caretContainerNode = null;
          }
          lastVisualCaret.on((caretState) => {
            dom2.remove(caretState.caret);
            lastVisualCaret.clear();
          });
          if (cursorInterval) {
            clearInterval(cursorInterval);
            cursorInterval = void 0;
          }
        };
        const startBlink = () => {
          cursorInterval = window.setInterval(() => {
            lastVisualCaret.on((caretState) => {
              if (hasFocus2()) {
                dom2.toggleClass(caretState.caret, "mce-visual-caret-hidden");
              } else {
                dom2.addClass(caretState.caret, "mce-visual-caret-hidden");
              }
            });
          }, 500);
        };
        const reposition2 = () => {
          lastVisualCaret.on((caretState) => {
            const clientRect = getAbsoluteClientRect(root, caretState.element, caretState.before);
            dom2.setStyles(caretState.caret, { ...clientRect });
          });
        };
        const destroy2 = () => clearInterval(cursorInterval);
        const getCss = () => ".mce-visual-caret {position: absolute;background-color: black;background-color: currentcolor;}.mce-visual-caret-hidden {display: none;}*[data-mce-caret] {position: absolute;left: -1000px;right: auto;top: 0;margin: 0;padding: 0;}";
        return {
          show,
          hide,
          getCss,
          reposition: reposition2,
          destroy: destroy2
        };
      };
      const isFakeCaretTableBrowser = () => Env.browser.isFirefox();
      const isInlineFakeCaretTarget = (node) => isContentEditableFalse$8(node) || isMedia$1(node);
      const isFakeCaretTarget = (node) => {
        const isTarget2 = isInlineFakeCaretTarget(node) || isTable$2(node) && isFakeCaretTableBrowser();
        return isTarget2 && parentElement(SugarElement.fromDom(node)).exists(isEditable$2);
      };
      const isContentEditableTrue$1 = isContentEditableTrue$3;
      const isContentEditableFalse$7 = isContentEditableFalse$b;
      const isMedia = isMedia$2;
      const isBlockLike = matchStyleValues("display", "block table table-cell table-row table-caption list-item");
      const isCaretContainer = isCaretContainer$2;
      const isCaretContainerBlock = isCaretContainerBlock$1;
      const isElement$2 = isElement$6;
      const isText$4 = isText$b;
      const isCaretCandidate$1 = isCaretCandidate$3;
      const isForwards = (direction) => direction === 1;
      const isBackwards = (direction) => direction === -1;
      const skipCaretContainers = (walk2, shallow2) => {
        let node;
        while (node = walk2(shallow2)) {
          if (!isCaretContainerBlock(node)) {
            return node;
          }
        }
        return null;
      };
      const findNode = (node, direction, predicateFn, rootNode, shallow2) => {
        const walker = new DomTreeWalker(node, rootNode);
        const isCefOrCaretContainer = isContentEditableFalse$7(node) || isCaretContainerBlock(node);
        let tempNode;
        if (isBackwards(direction)) {
          if (isCefOrCaretContainer) {
            tempNode = skipCaretContainers(walker.prev.bind(walker), true);
            if (predicateFn(tempNode)) {
              return tempNode;
            }
          }
          while (tempNode = skipCaretContainers(walker.prev.bind(walker), shallow2)) {
            if (predicateFn(tempNode)) {
              return tempNode;
            }
          }
        }
        if (isForwards(direction)) {
          if (isCefOrCaretContainer) {
            tempNode = skipCaretContainers(walker.next.bind(walker), true);
            if (predicateFn(tempNode)) {
              return tempNode;
            }
          }
          while (tempNode = skipCaretContainers(walker.next.bind(walker), shallow2)) {
            if (predicateFn(tempNode)) {
              return tempNode;
            }
          }
        }
        return null;
      };
      const getEditingHost = (node, rootNode) => {
        const isCETrue = (node2) => isContentEditableTrue$1(node2.dom);
        const isRoot2 = (node2) => node2.dom === rootNode;
        return ancestor$4(SugarElement.fromDom(node), isCETrue, isRoot2).map((elm) => elm.dom).getOr(rootNode);
      };
      const getParentBlock$3 = (node, rootNode) => {
        while (node && node !== rootNode) {
          if (isBlockLike(node)) {
            return node;
          }
          node = node.parentNode;
        }
        return null;
      };
      const isInSameBlock = (caretPosition1, caretPosition2, rootNode) => getParentBlock$3(caretPosition1.container(), rootNode) === getParentBlock$3(caretPosition2.container(), rootNode);
      const getChildNodeAtRelativeOffset = (relativeOffset, caretPosition) => {
        if (!caretPosition) {
          return Optional.none();
        }
        const container = caretPosition.container();
        const offset = caretPosition.offset();
        if (!isElement$2(container)) {
          return Optional.none();
        }
        return Optional.from(container.childNodes[offset + relativeOffset]);
      };
      const beforeAfter = (before2, node) => {
        var _a;
        const doc = (_a = node.ownerDocument) !== null && _a !== void 0 ? _a : document;
        const range2 = doc.createRange();
        if (before2) {
          range2.setStartBefore(node);
          range2.setEndBefore(node);
        } else {
          range2.setStartAfter(node);
          range2.setEndAfter(node);
        }
        return range2;
      };
      const isNodesInSameBlock = (root, node1, node2) => getParentBlock$3(node1, root) === getParentBlock$3(node2, root);
      const lean = (left, root, node) => {
        const siblingName = left ? "previousSibling" : "nextSibling";
        let tempNode = node;
        while (tempNode && tempNode !== root) {
          let sibling2 = tempNode[siblingName];
          if (sibling2 && isCaretContainer(sibling2)) {
            sibling2 = sibling2[siblingName];
          }
          if (isContentEditableFalse$7(sibling2) || isMedia(sibling2)) {
            if (isNodesInSameBlock(root, sibling2, tempNode)) {
              return sibling2;
            }
            break;
          }
          if (isCaretCandidate$1(sibling2)) {
            break;
          }
          tempNode = tempNode.parentNode;
        }
        return null;
      };
      const before$2 = curry(beforeAfter, true);
      const after$2 = curry(beforeAfter, false);
      const normalizeRange = (direction, root, range2) => {
        let node;
        const leanLeft = curry(lean, true, root);
        const leanRight2 = curry(lean, false, root);
        const container = range2.startContainer;
        const offset = range2.startOffset;
        if (isCaretContainerBlock$1(container)) {
          const block = isText$4(container) ? container.parentNode : container;
          const location = block.getAttribute("data-mce-caret");
          if (location === "before") {
            node = block.nextSibling;
            if (isFakeCaretTarget(node)) {
              return before$2(node);
            }
          }
          if (location === "after") {
            node = block.previousSibling;
            if (isFakeCaretTarget(node)) {
              return after$2(node);
            }
          }
        }
        if (!range2.collapsed) {
          return range2;
        }
        if (isText$b(container)) {
          if (isCaretContainer(container)) {
            if (direction === 1) {
              node = leanRight2(container);
              if (node) {
                return before$2(node);
              }
              node = leanLeft(container);
              if (node) {
                return after$2(node);
              }
            }
            if (direction === -1) {
              node = leanLeft(container);
              if (node) {
                return after$2(node);
              }
              node = leanRight2(container);
              if (node) {
                return before$2(node);
              }
            }
            return range2;
          }
          if (endsWithCaretContainer$1(container) && offset >= container.data.length - 1) {
            if (direction === 1) {
              node = leanRight2(container);
              if (node) {
                return before$2(node);
              }
            }
            return range2;
          }
          if (startsWithCaretContainer$1(container) && offset <= 1) {
            if (direction === -1) {
              node = leanLeft(container);
              if (node) {
                return after$2(node);
              }
            }
            return range2;
          }
          if (offset === container.data.length) {
            node = leanRight2(container);
            if (node) {
              return before$2(node);
            }
            return range2;
          }
          if (offset === 0) {
            node = leanLeft(container);
            if (node) {
              return after$2(node);
            }
            return range2;
          }
        }
        return range2;
      };
      const getRelativeCefElm = (forward, caretPosition) => getChildNodeAtRelativeOffset(forward ? 0 : -1, caretPosition).filter(isContentEditableFalse$7);
      const getNormalizedRangeEndPoint = (direction, root, range2) => {
        const normalizedRange = normalizeRange(direction, root, range2);
        return direction === -1 ? CaretPosition.fromRangeStart(normalizedRange) : CaretPosition.fromRangeEnd(normalizedRange);
      };
      const getElementFromPosition = (pos) => Optional.from(pos.getNode()).map(SugarElement.fromDom);
      const getElementFromPrevPosition = (pos) => Optional.from(pos.getNode(true)).map(SugarElement.fromDom);
      const getVisualCaretPosition = (walkFn, caretPosition) => {
        let pos = caretPosition;
        while (pos = walkFn(pos)) {
          if (pos.isVisible()) {
            return pos;
          }
        }
        return pos;
      };
      const isMoveInsideSameBlock = (from2, to2) => {
        const inSameBlock = isInSameBlock(from2, to2);
        if (!inSameBlock && isBr$6(from2.getNode())) {
          return true;
        }
        return inSameBlock;
      };
      const isContentEditableFalse$6 = isContentEditableFalse$b;
      const isText$3 = isText$b;
      const isElement$1 = isElement$6;
      const isBr$2 = isBr$6;
      const isCaretCandidate = isCaretCandidate$3;
      const isAtomic = isAtomic$1;
      const isEditableCaretCandidate = isEditableCaretCandidate$1;
      const getParents$3 = (node, root) => {
        const parents2 = [];
        let tempNode = node;
        while (tempNode && tempNode !== root) {
          parents2.push(tempNode);
          tempNode = tempNode.parentNode;
        }
        return parents2;
      };
      const nodeAtIndex = (container, offset) => {
        if (container.hasChildNodes() && offset < container.childNodes.length) {
          return container.childNodes[offset];
        }
        return null;
      };
      const getCaretCandidatePosition = (direction, node) => {
        if (isForwards(direction)) {
          if (isCaretCandidate(node.previousSibling) && !isText$3(node.previousSibling)) {
            return CaretPosition.before(node);
          }
          if (isText$3(node)) {
            return CaretPosition(node, 0);
          }
        }
        if (isBackwards(direction)) {
          if (isCaretCandidate(node.nextSibling) && !isText$3(node.nextSibling)) {
            return CaretPosition.after(node);
          }
          if (isText$3(node)) {
            return CaretPosition(node, node.data.length);
          }
        }
        if (isBackwards(direction)) {
          if (isBr$2(node)) {
            return CaretPosition.before(node);
          }
          return CaretPosition.after(node);
        }
        return CaretPosition.before(node);
      };
      const moveForwardFromBr = (root, nextNode) => {
        const nextSibling2 = nextNode.nextSibling;
        if (nextSibling2 && isCaretCandidate(nextSibling2)) {
          if (isText$3(nextSibling2)) {
            return CaretPosition(nextSibling2, 0);
          } else {
            return CaretPosition.before(nextSibling2);
          }
        } else {
          return findCaretPosition$1(1, CaretPosition.after(nextNode), root);
        }
      };
      const findCaretPosition$1 = (direction, startPos, root) => {
        let node;
        let nextNode;
        let innerNode;
        let caretPosition;
        if (!isElement$1(root) || !startPos) {
          return null;
        }
        if (startPos.isEqual(CaretPosition.after(root)) && root.lastChild) {
          caretPosition = CaretPosition.after(root.lastChild);
          if (isBackwards(direction) && isCaretCandidate(root.lastChild) && isElement$1(root.lastChild)) {
            return isBr$2(root.lastChild) ? CaretPosition.before(root.lastChild) : caretPosition;
          }
        } else {
          caretPosition = startPos;
        }
        const container = caretPosition.container();
        let offset = caretPosition.offset();
        if (isText$3(container)) {
          if (isBackwards(direction) && offset > 0) {
            return CaretPosition(container, --offset);
          }
          if (isForwards(direction) && offset < container.length) {
            return CaretPosition(container, ++offset);
          }
          node = container;
        } else {
          if (isBackwards(direction) && offset > 0) {
            nextNode = nodeAtIndex(container, offset - 1);
            if (isCaretCandidate(nextNode)) {
              if (!isAtomic(nextNode)) {
                innerNode = findNode(nextNode, direction, isEditableCaretCandidate, nextNode);
                if (innerNode) {
                  if (isText$3(innerNode)) {
                    return CaretPosition(innerNode, innerNode.data.length);
                  }
                  return CaretPosition.after(innerNode);
                }
              }
              if (isText$3(nextNode)) {
                return CaretPosition(nextNode, nextNode.data.length);
              }
              return CaretPosition.before(nextNode);
            }
          }
          if (isForwards(direction) && offset < container.childNodes.length) {
            nextNode = nodeAtIndex(container, offset);
            if (isCaretCandidate(nextNode)) {
              if (isBr$2(nextNode)) {
                return moveForwardFromBr(root, nextNode);
              }
              if (!isAtomic(nextNode)) {
                innerNode = findNode(nextNode, direction, isEditableCaretCandidate, nextNode);
                if (innerNode) {
                  if (isText$3(innerNode)) {
                    return CaretPosition(innerNode, 0);
                  }
                  return CaretPosition.before(innerNode);
                }
              }
              if (isText$3(nextNode)) {
                return CaretPosition(nextNode, 0);
              }
              return CaretPosition.after(nextNode);
            }
          }
          node = nextNode ? nextNode : caretPosition.getNode();
        }
        if (node && (isForwards(direction) && caretPosition.isAtEnd() || isBackwards(direction) && caretPosition.isAtStart())) {
          node = findNode(node, direction, always, root, true);
          if (isEditableCaretCandidate(node, root)) {
            return getCaretCandidatePosition(direction, node);
          }
        }
        nextNode = node ? findNode(node, direction, isEditableCaretCandidate, root) : node;
        const rootContentEditableFalseElm = last$1(filter$5(getParents$3(container, root), isContentEditableFalse$6));
        if (rootContentEditableFalseElm && (!nextNode || !rootContentEditableFalseElm.contains(nextNode))) {
          if (isForwards(direction)) {
            caretPosition = CaretPosition.after(rootContentEditableFalseElm);
          } else {
            caretPosition = CaretPosition.before(rootContentEditableFalseElm);
          }
          return caretPosition;
        }
        if (nextNode) {
          return getCaretCandidatePosition(direction, nextNode);
        }
        return null;
      };
      const CaretWalker = (root) => ({
        next: (caretPosition) => {
          return findCaretPosition$1(1, caretPosition, root);
        },
        prev: (caretPosition) => {
          return findCaretPosition$1(-1, caretPosition, root);
        }
      });
      const walkToPositionIn = (forward, root, start2) => {
        const position = forward ? CaretPosition.before(start2) : CaretPosition.after(start2);
        return fromPosition(forward, root, position);
      };
      const afterElement = (node) => isBr$6(node) ? CaretPosition.before(node) : CaretPosition.after(node);
      const isBeforeOrStart = (position) => {
        if (CaretPosition.isTextPosition(position)) {
          return position.offset() === 0;
        } else {
          return isCaretCandidate$3(position.getNode());
        }
      };
      const isAfterOrEnd = (position) => {
        if (CaretPosition.isTextPosition(position)) {
          const container = position.container();
          return position.offset() === container.data.length;
        } else {
          return isCaretCandidate$3(position.getNode(true));
        }
      };
      const isBeforeAfterSameElement = (from2, to2) => !CaretPosition.isTextPosition(from2) && !CaretPosition.isTextPosition(to2) && from2.getNode() === to2.getNode(true);
      const isAtBr = (position) => !CaretPosition.isTextPosition(position) && isBr$6(position.getNode());
      const shouldSkipPosition = (forward, from2, to2) => {
        if (forward) {
          return !isBeforeAfterSameElement(from2, to2) && !isAtBr(from2) && isAfterOrEnd(from2) && isBeforeOrStart(to2);
        } else {
          return !isBeforeAfterSameElement(to2, from2) && isBeforeOrStart(from2) && isAfterOrEnd(to2);
        }
      };
      const fromPosition = (forward, root, pos) => {
        const walker = CaretWalker(root);
        return Optional.from(forward ? walker.next(pos) : walker.prev(pos));
      };
      const navigate = (forward, root, from2) => fromPosition(forward, root, from2).bind((to2) => {
        if (isInSameBlock(from2, to2, root) && shouldSkipPosition(forward, from2, to2)) {
          return fromPosition(forward, root, to2);
        } else {
          return Optional.some(to2);
        }
      });
      const navigateIgnore = (forward, root, from2, ignoreFilter) => navigate(forward, root, from2).bind((pos) => ignoreFilter(pos) ? navigateIgnore(forward, root, pos, ignoreFilter) : Optional.some(pos));
      const positionIn = (forward, element) => {
        const startNode = forward ? element.firstChild : element.lastChild;
        if (isText$b(startNode)) {
          return Optional.some(CaretPosition(startNode, forward ? 0 : startNode.data.length));
        } else if (startNode) {
          if (isCaretCandidate$3(startNode)) {
            return Optional.some(forward ? CaretPosition.before(startNode) : afterElement(startNode));
          } else {
            return walkToPositionIn(forward, element, startNode);
          }
        } else {
          return Optional.none();
        }
      };
      const nextPosition = curry(fromPosition, true);
      const prevPosition = curry(fromPosition, false);
      const firstPositionIn = curry(positionIn, true);
      const lastPositionIn = curry(positionIn, false);
      const CARET_ID = "_mce_caret";
      const isCaretNode = (node) => isElement$6(node) && node.id === CARET_ID;
      const getParentCaretContainer = (body, node) => {
        let currentNode = node;
        while (currentNode && currentNode !== body) {
          if (isCaretNode(currentNode)) {
            return currentNode;
          }
          currentNode = currentNode.parentNode;
        }
        return null;
      };
      const isStringPathBookmark = (bookmark) => isString(bookmark.start);
      const isRangeBookmark = (bookmark) => has$2(bookmark, "rng");
      const isIdBookmark = (bookmark) => has$2(bookmark, "id");
      const isIndexBookmark = (bookmark) => has$2(bookmark, "name");
      const isPathBookmark = (bookmark) => Tools.isArray(bookmark.start);
      const isForwardBookmark = (bookmark) => !isIndexBookmark(bookmark) && isBoolean(bookmark.forward) ? bookmark.forward : true;
      const addBogus = (dom2, node) => {
        if (isElement$6(node) && dom2.isBlock(node) && !node.innerHTML) {
          node.innerHTML = '<br data-mce-bogus="1" />';
        }
        return node;
      };
      const resolveCaretPositionBookmark = (dom2, bookmark) => {
        const startPos = Optional.from(resolve$1(dom2.getRoot(), bookmark.start));
        const endPos = Optional.from(resolve$1(dom2.getRoot(), bookmark.end));
        return lift2(startPos, endPos, (start2, end2) => {
          const range2 = dom2.createRng();
          range2.setStart(start2.container(), start2.offset());
          range2.setEnd(end2.container(), end2.offset());
          return {
            range: range2,
            forward: isForwardBookmark(bookmark)
          };
        });
      };
      const insertZwsp = (node, rng) => {
        var _a;
        const doc = (_a = node.ownerDocument) !== null && _a !== void 0 ? _a : document;
        const textNode = doc.createTextNode(ZWSP$1);
        node.appendChild(textNode);
        rng.setStart(textNode, 0);
        rng.setEnd(textNode, 0);
      };
      const isEmpty$1 = (node) => !node.hasChildNodes();
      const tryFindRangePosition = (node, rng) => lastPositionIn(node).fold(never, (pos) => {
        rng.setStart(pos.container(), pos.offset());
        rng.setEnd(pos.container(), pos.offset());
        return true;
      });
      const padEmptyCaretContainer = (root, node, rng) => {
        if (isEmpty$1(node) && getParentCaretContainer(root, node)) {
          insertZwsp(node, rng);
          return true;
        } else {
          return false;
        }
      };
      const setEndPoint = (dom2, start2, bookmark, rng) => {
        const point2 = bookmark[start2 ? "start" : "end"];
        const root = dom2.getRoot();
        if (point2) {
          let node = root;
          let offset = point2[0];
          for (let i = point2.length - 1; node && i >= 1; i--) {
            const children2 = node.childNodes;
            if (padEmptyCaretContainer(root, node, rng)) {
              return true;
            }
            if (point2[i] > children2.length - 1) {
              if (padEmptyCaretContainer(root, node, rng)) {
                return true;
              }
              return tryFindRangePosition(node, rng);
            }
            node = children2[point2[i]];
          }
          if (isText$b(node)) {
            offset = Math.min(point2[0], node.data.length);
          }
          if (isElement$6(node)) {
            offset = Math.min(point2[0], node.childNodes.length);
          }
          if (start2) {
            rng.setStart(node, offset);
          } else {
            rng.setEnd(node, offset);
          }
        }
        return true;
      };
      const isValidTextNode = (node) => isText$b(node) && node.data.length > 0;
      const restoreEndPoint = (dom2, suffix, bookmark) => {
        const marker = dom2.get(bookmark.id + "_" + suffix);
        const markerParent = marker === null || marker === void 0 ? void 0 : marker.parentNode;
        const keep = bookmark.keep;
        if (marker && markerParent) {
          let container;
          let offset;
          if (suffix === "start") {
            if (!keep) {
              container = markerParent;
              offset = dom2.nodeIndex(marker);
            } else {
              if (marker.hasChildNodes()) {
                container = marker.firstChild;
                offset = 1;
              } else if (isValidTextNode(marker.nextSibling)) {
                container = marker.nextSibling;
                offset = 0;
              } else if (isValidTextNode(marker.previousSibling)) {
                container = marker.previousSibling;
                offset = marker.previousSibling.data.length;
              } else {
                container = markerParent;
                offset = dom2.nodeIndex(marker) + 1;
              }
            }
          } else {
            if (!keep) {
              container = markerParent;
              offset = dom2.nodeIndex(marker);
            } else {
              if (marker.hasChildNodes()) {
                container = marker.firstChild;
                offset = 1;
              } else if (isValidTextNode(marker.previousSibling)) {
                container = marker.previousSibling;
                offset = marker.previousSibling.data.length;
              } else {
                container = markerParent;
                offset = dom2.nodeIndex(marker);
              }
            }
          }
          if (!keep) {
            const prev2 = marker.previousSibling;
            const next2 = marker.nextSibling;
            Tools.each(Tools.grep(marker.childNodes), (node) => {
              if (isText$b(node)) {
                node.data = node.data.replace(/\uFEFF/g, "");
              }
            });
            let otherMarker;
            while (otherMarker = dom2.get(bookmark.id + "_" + suffix)) {
              dom2.remove(otherMarker, true);
            }
            if (isText$b(next2) && isText$b(prev2) && !Env.browser.isOpera()) {
              const idx = prev2.data.length;
              prev2.appendData(next2.data);
              dom2.remove(next2);
              container = prev2;
              offset = idx;
            }
          }
          return Optional.some(CaretPosition(container, offset));
        } else {
          return Optional.none();
        }
      };
      const resolvePaths = (dom2, bookmark) => {
        const range2 = dom2.createRng();
        if (setEndPoint(dom2, true, bookmark, range2) && setEndPoint(dom2, false, bookmark, range2)) {
          return Optional.some({
            range: range2,
            forward: isForwardBookmark(bookmark)
          });
        } else {
          return Optional.none();
        }
      };
      const resolveId = (dom2, bookmark) => {
        const startPos = restoreEndPoint(dom2, "start", bookmark);
        const endPos = restoreEndPoint(dom2, "end", bookmark);
        return lift2(startPos, endPos.or(startPos), (spos, epos) => {
          const range2 = dom2.createRng();
          range2.setStart(addBogus(dom2, spos.container()), spos.offset());
          range2.setEnd(addBogus(dom2, epos.container()), epos.offset());
          return {
            range: range2,
            forward: isForwardBookmark(bookmark)
          };
        });
      };
      const resolveIndex = (dom2, bookmark) => Optional.from(dom2.select(bookmark.name)[bookmark.index]).map((elm) => {
        const range2 = dom2.createRng();
        range2.selectNode(elm);
        return {
          range: range2,
          forward: true
        };
      });
      const resolve = (selection, bookmark) => {
        const dom2 = selection.dom;
        if (bookmark) {
          if (isPathBookmark(bookmark)) {
            return resolvePaths(dom2, bookmark);
          } else if (isStringPathBookmark(bookmark)) {
            return resolveCaretPositionBookmark(dom2, bookmark);
          } else if (isIdBookmark(bookmark)) {
            return resolveId(dom2, bookmark);
          } else if (isIndexBookmark(bookmark)) {
            return resolveIndex(dom2, bookmark);
          } else if (isRangeBookmark(bookmark)) {
            return Optional.some({
              range: bookmark.rng,
              forward: isForwardBookmark(bookmark)
            });
          }
        }
        return Optional.none();
      };
      const getBookmark$2 = (selection, type2, normalized) => {
        return getBookmark$3(selection, type2, normalized);
      };
      const moveToBookmark = (selection, bookmark) => {
        resolve(selection, bookmark).each(({ range: range2, forward }) => {
          selection.setRng(range2, forward);
        });
      };
      const isBookmarkNode$1 = (node) => {
        return isElement$6(node) && node.tagName === "SPAN" && node.getAttribute("data-mce-type") === "bookmark";
      };
      const is = (expected) => (actual) => expected === actual;
      const isNbsp = is(nbsp);
      const isWhiteSpace = (chr) => chr !== "" && " \f\n\r	\v".indexOf(chr) !== -1;
      const isContent = (chr) => !isWhiteSpace(chr) && !isNbsp(chr) && !isZwsp$2(chr);
      const getRanges$1 = (selection) => {
        const ranges = [];
        if (selection) {
          for (let i = 0; i < selection.rangeCount; i++) {
            ranges.push(selection.getRangeAt(i));
          }
        }
        return ranges;
      };
      const getSelectedNodes = (ranges) => {
        return bind$3(ranges, (range2) => {
          const node = getSelectedNode(range2);
          return node ? [SugarElement.fromDom(node)] : [];
        });
      };
      const hasMultipleRanges = (selection) => {
        return getRanges$1(selection).length > 1;
      };
      const getCellsFromRanges = (ranges) => filter$5(getSelectedNodes(ranges), isTableCell$2);
      const getCellsFromElement = (elm) => descendants(elm, "td[data-mce-selected],th[data-mce-selected]");
      const getCellsFromElementOrRanges = (ranges, element) => {
        const selectedCells = getCellsFromElement(element);
        return selectedCells.length > 0 ? selectedCells : getCellsFromRanges(ranges);
      };
      const getCellsFromEditor = (editor) => getCellsFromElementOrRanges(getRanges$1(editor.selection.getSel()), SugarElement.fromDom(editor.getBody()));
      const getClosestTable = (cell2, isRoot2) => ancestor$3(cell2, "table", isRoot2);
      const getStartNode = (rng) => {
        const sc = rng.startContainer, so = rng.startOffset;
        if (isText$b(sc)) {
          return so === 0 ? Optional.some(SugarElement.fromDom(sc)) : Optional.none();
        } else {
          return Optional.from(sc.childNodes[so]).map(SugarElement.fromDom);
        }
      };
      const getEndNode = (rng) => {
        const ec = rng.endContainer, eo = rng.endOffset;
        if (isText$b(ec)) {
          return eo === ec.data.length ? Optional.some(SugarElement.fromDom(ec)) : Optional.none();
        } else {
          return Optional.from(ec.childNodes[eo - 1]).map(SugarElement.fromDom);
        }
      };
      const getFirstChildren = (node) => {
        return firstChild(node).fold(constant([node]), (child2) => {
          return [node].concat(getFirstChildren(child2));
        });
      };
      const getLastChildren = (node) => {
        return lastChild(node).fold(constant([node]), (child2) => {
          if (name(child2) === "br") {
            return prevSibling(child2).map((sibling2) => {
              return [node].concat(getLastChildren(sibling2));
            }).getOr([]);
          } else {
            return [node].concat(getLastChildren(child2));
          }
        });
      };
      const hasAllContentsSelected = (elm, rng) => {
        return lift2(getStartNode(rng), getEndNode(rng), (startNode, endNode) => {
          const start2 = find$2(getFirstChildren(elm), curry(eq, startNode));
          const end2 = find$2(getLastChildren(elm), curry(eq, endNode));
          return start2.isSome() && end2.isSome();
        }).getOr(false);
      };
      const moveEndPoint = (dom2, rng, node, start2) => {
        const root = node;
        const walker = new DomTreeWalker(node, root);
        const moveCaretBeforeOnEnterElementsMap = filter$4(dom2.schema.getMoveCaretBeforeOnEnterElements(), (_, name2) => !contains$2([
          "td",
          "th",
          "table"
        ], name2.toLowerCase()));
        let currentNode = node;
        do {
          if (isText$b(currentNode) && Tools.trim(currentNode.data).length !== 0) {
            if (start2) {
              rng.setStart(currentNode, 0);
            } else {
              rng.setEnd(currentNode, currentNode.data.length);
            }
            return;
          }
          if (moveCaretBeforeOnEnterElementsMap[currentNode.nodeName]) {
            if (start2) {
              rng.setStartBefore(currentNode);
            } else {
              if (currentNode.nodeName === "BR") {
                rng.setEndBefore(currentNode);
              } else {
                rng.setEndAfter(currentNode);
              }
            }
            return;
          }
        } while (currentNode = start2 ? walker.next() : walker.prev());
        if (root.nodeName === "BODY") {
          if (start2) {
            rng.setStart(root, 0);
          } else {
            rng.setEnd(root, root.childNodes.length);
          }
        }
      };
      const hasAnyRanges = (editor) => {
        const sel = editor.selection.getSel();
        return isNonNullable(sel) && sel.rangeCount > 0;
      };
      const runOnRanges = (editor, executor) => {
        const fakeSelectionNodes = getCellsFromEditor(editor);
        if (fakeSelectionNodes.length > 0) {
          each$e(fakeSelectionNodes, (elem) => {
            const node = elem.dom;
            const fakeNodeRng = editor.dom.createRng();
            fakeNodeRng.setStartBefore(node);
            fakeNodeRng.setEndAfter(node);
            executor(fakeNodeRng, true);
          });
        } else {
          executor(editor.selection.getRng(), false);
        }
      };
      const preserve = (selection, fillBookmark, executor) => {
        const bookmark = getPersistentBookmark(selection, fillBookmark);
        executor(bookmark);
        selection.moveToBookmark(bookmark);
      };
      const isNode = (node) => isNumber(node === null || node === void 0 ? void 0 : node.nodeType);
      const isElementNode$1 = (node) => isElement$6(node) && !isBookmarkNode$1(node) && !isCaretNode(node) && !isBogus$1(node);
      const isElementDirectlySelected = (dom2, node) => {
        if (isElementNode$1(node) && !/^(TD|TH)$/.test(node.nodeName)) {
          const selectedAttr = dom2.getAttrib(node, "data-mce-selected");
          const value2 = parseInt(selectedAttr, 10);
          return !isNaN(value2) && value2 > 0;
        } else {
          return false;
        }
      };
      const preserveSelection = (editor, action2, shouldMoveStart) => {
        const { selection, dom: dom2 } = editor;
        const selectedNodeBeforeAction = selection.getNode();
        const isSelectedBeforeNodeNoneditable = isContentEditableFalse$b(selectedNodeBeforeAction);
        preserve(selection, true, () => {
          action2();
        });
        const isBeforeNodeStillNoneditable = isSelectedBeforeNodeNoneditable && isContentEditableFalse$b(selectedNodeBeforeAction);
        if (isBeforeNodeStillNoneditable && dom2.isChildOf(selectedNodeBeforeAction, editor.getBody())) {
          editor.selection.select(selectedNodeBeforeAction);
        } else if (shouldMoveStart(selection.getStart())) {
          moveStartToNearestText(dom2, selection);
        }
      };
      const moveStartToNearestText = (dom2, selection) => {
        var _a, _b;
        const rng = selection.getRng();
        const { startContainer, startOffset } = rng;
        const selectedNode = selection.getNode();
        if (isElementDirectlySelected(dom2, selectedNode)) {
          return;
        }
        if (isElement$6(startContainer)) {
          const nodes = startContainer.childNodes;
          const root = dom2.getRoot();
          let walker;
          if (startOffset < nodes.length) {
            const startNode = nodes[startOffset];
            walker = new DomTreeWalker(startNode, (_a = dom2.getParent(startNode, dom2.isBlock)) !== null && _a !== void 0 ? _a : root);
          } else {
            const startNode = nodes[nodes.length - 1];
            walker = new DomTreeWalker(startNode, (_b = dom2.getParent(startNode, dom2.isBlock)) !== null && _b !== void 0 ? _b : root);
            walker.next(true);
          }
          for (let node = walker.current(); node; node = walker.next()) {
            if (dom2.getContentEditable(node) === "false") {
              return;
            } else if (isText$b(node) && !isWhiteSpaceNode$1(node)) {
              rng.setStart(node, 0);
              selection.setRng(rng);
              return;
            }
          }
        }
      };
      const getNonWhiteSpaceSibling = (node, next2, inc) => {
        if (node) {
          const nextName = next2 ? "nextSibling" : "previousSibling";
          for (node = inc ? node : node[nextName]; node; node = node[nextName]) {
            if (isElement$6(node) || !isWhiteSpaceNode$1(node)) {
              return node;
            }
          }
        }
        return void 0;
      };
      const isTextBlock$1 = (schema, node) => !!schema.getTextBlockElements()[node.nodeName.toLowerCase()] || isTransparentBlock(schema, node);
      const isValid = (ed, parent2, child2) => {
        return ed.schema.isValidChild(parent2, child2);
      };
      const isWhiteSpaceNode$1 = (node, allowSpaces = false) => {
        if (isNonNullable(node) && isText$b(node)) {
          const data2 = allowSpaces ? node.data.replace(/ /g, " ") : node.data;
          return isWhitespaceText(data2);
        } else {
          return false;
        }
      };
      const isEmptyTextNode$1 = (node) => {
        return isNonNullable(node) && isText$b(node) && node.length === 0;
      };
      const isWrapNoneditableTarget = (editor, node) => {
        const baseDataSelector = "[data-mce-cef-wrappable]";
        const formatNoneditableSelector = getFormatNoneditableSelector(editor);
        const selector = isEmpty$3(formatNoneditableSelector) ? baseDataSelector : `${baseDataSelector},${formatNoneditableSelector}`;
        return is$1(SugarElement.fromDom(node), selector);
      };
      const isWrappableNoneditable = (editor, node) => {
        const dom2 = editor.dom;
        return isElementNode$1(node) && dom2.getContentEditable(node) === "false" && isWrapNoneditableTarget(editor, node) && dom2.select('[contenteditable="true"]', node).length === 0;
      };
      const replaceVars = (value2, vars) => {
        if (isFunction(value2)) {
          return value2(vars);
        } else if (isNonNullable(vars)) {
          value2 = value2.replace(/%(\w+)/g, (str, name2) => {
            return vars[name2] || str;
          });
        }
        return value2;
      };
      const isEq$5 = (str1, str2) => {
        str1 = str1 || "";
        str2 = str2 || "";
        str1 = "" + (str1.nodeName || str1);
        str2 = "" + (str2.nodeName || str2);
        return str1.toLowerCase() === str2.toLowerCase();
      };
      const normalizeStyleValue = (value2, name2) => {
        if (isNullable(value2)) {
          return null;
        } else {
          let strValue = String(value2);
          if (name2 === "color" || name2 === "backgroundColor") {
            strValue = rgbaToHexString(strValue);
          }
          if (name2 === "fontWeight" && value2 === 700) {
            strValue = "bold";
          }
          if (name2 === "fontFamily") {
            strValue = strValue.replace(/[\'\"]/g, "").replace(/,\s+/g, ",");
          }
          return strValue;
        }
      };
      const getStyle = (dom2, node, name2) => {
        const style = dom2.getStyle(node, name2);
        return normalizeStyleValue(style, name2);
      };
      const getTextDecoration = (dom2, node) => {
        let decoration;
        dom2.getParent(node, (n) => {
          if (isElement$6(n)) {
            decoration = dom2.getStyle(n, "text-decoration");
            return !!decoration && decoration !== "none";
          } else {
            return false;
          }
        });
        return decoration;
      };
      const getParents$2 = (dom2, node, selector) => {
        return dom2.getParents(node, selector, dom2.getRoot());
      };
      const isFormatPredicate = (editor, formatName, predicate) => {
        const formats = editor.formatter.get(formatName);
        return isNonNullable(formats) && exists(formats, predicate);
      };
      const isVariableFormatName = (editor, formatName) => {
        const hasVariableValues = (format) => {
          const isVariableValue = (val) => isFunction(val) || val.length > 1 && val.charAt(0) === "%";
          return exists([
            "styles",
            "attributes"
          ], (key) => get$a(format, key).exists((field2) => {
            const fieldValues = isArray$1(field2) ? field2 : values(field2);
            return exists(fieldValues, isVariableValue);
          }));
        };
        return isFormatPredicate(editor, formatName, hasVariableValues);
      };
      const areSimilarFormats = (editor, formatName, otherFormatName) => {
        const validKeys = [
          "inline",
          "block",
          "selector",
          "attributes",
          "styles",
          "classes"
        ];
        const filterObj = (format) => filter$4(format, (_, key) => exists(validKeys, (validKey) => validKey === key));
        return isFormatPredicate(editor, formatName, (fmt1) => {
          const filteredFmt1 = filterObj(fmt1);
          return isFormatPredicate(editor, otherFormatName, (fmt2) => {
            const filteredFmt2 = filterObj(fmt2);
            return equal$1(filteredFmt1, filteredFmt2);
          });
        });
      };
      const isBlockFormat = (format) => hasNonNullableKey(format, "block");
      const isWrappingBlockFormat = (format) => isBlockFormat(format) && format.wrapper === true;
      const isNonWrappingBlockFormat = (format) => isBlockFormat(format) && format.wrapper !== true;
      const isSelectorFormat = (format) => hasNonNullableKey(format, "selector");
      const isInlineFormat = (format) => hasNonNullableKey(format, "inline");
      const isMixedFormat = (format) => isSelectorFormat(format) && isInlineFormat(format) && is$2(get$a(format, "mixed"), true);
      const shouldExpandToSelector = (format) => isSelectorFormat(format) && format.expand !== false && !isInlineFormat(format);
      const getEmptyCaretContainers = (node) => {
        const nodes = [];
        let tempNode = node;
        while (tempNode) {
          if (isText$b(tempNode) && tempNode.data !== ZWSP$1 || tempNode.childNodes.length > 1) {
            return [];
          }
          if (isElement$6(tempNode)) {
            nodes.push(tempNode);
          }
          tempNode = tempNode.firstChild;
        }
        return nodes;
      };
      const isCaretContainerEmpty = (node) => {
        return getEmptyCaretContainers(node).length > 0;
      };
      const isEmptyCaretFormatElement = (element) => {
        return isCaretNode(element.dom) && isCaretContainerEmpty(element.dom);
      };
      const isBookmarkNode = isBookmarkNode$1;
      const getParents$1 = getParents$2;
      const isWhiteSpaceNode = isWhiteSpaceNode$1;
      const isTextBlock = isTextBlock$1;
      const isBogusBr = (node) => {
        return isBr$6(node) && node.getAttribute("data-mce-bogus") && !node.nextSibling;
      };
      const findParentContentEditable = (dom2, node) => {
        let parent2 = node;
        while (parent2) {
          if (isElement$6(parent2) && dom2.getContentEditable(parent2)) {
            return dom2.getContentEditable(parent2) === "false" ? parent2 : node;
          }
          parent2 = parent2.parentNode;
        }
        return node;
      };
      const walkText = (start2, node, offset, predicate) => {
        const str = node.data;
        if (start2) {
          for (let i = offset; i > 0; i--) {
            if (predicate(str.charAt(i - 1))) {
              return i;
            }
          }
        } else {
          for (let i = offset; i < str.length; i++) {
            if (predicate(str.charAt(i))) {
              return i;
            }
          }
        }
        return -1;
      };
      const findSpace = (start2, node, offset) => walkText(start2, node, offset, (c) => isNbsp(c) || isWhiteSpace(c));
      const findContent = (start2, node, offset) => walkText(start2, node, offset, isContent);
      const findWordEndPoint = (dom2, body, container, offset, start2, includeTrailingSpaces) => {
        let lastTextNode;
        const closestRoot = dom2.getParent(container, (node) => isEditingHost(node) || dom2.isBlock(node));
        const rootNode = isNonNullable(closestRoot) ? closestRoot : body;
        const walk2 = (container2, offset2, pred) => {
          const textSeeker = TextSeeker(dom2);
          const walker = start2 ? textSeeker.backwards : textSeeker.forwards;
          return Optional.from(walker(container2, offset2, (text2, textOffset) => {
            if (isBookmarkNode(text2.parentNode)) {
              return -1;
            } else {
              lastTextNode = text2;
              return pred(start2, text2, textOffset);
            }
          }, rootNode));
        };
        const spaceResult = walk2(container, offset, findSpace);
        return spaceResult.bind((result) => includeTrailingSpaces ? walk2(result.container, result.offset + (start2 ? -1 : 0), findContent) : Optional.some(result)).orThunk(() => lastTextNode ? Optional.some({
          container: lastTextNode,
          offset: start2 ? 0 : lastTextNode.length
        }) : Optional.none());
      };
      const findSelectorEndPoint = (dom2, formatList, rng, container, siblingName) => {
        const sibling2 = container[siblingName];
        if (isText$b(container) && isEmpty$3(container.data) && sibling2) {
          container = sibling2;
        }
        const parents2 = getParents$1(dom2, container);
        for (let i = 0; i < parents2.length; i++) {
          for (let y = 0; y < formatList.length; y++) {
            const curFormat = formatList[y];
            if (isNonNullable(curFormat.collapsed) && curFormat.collapsed !== rng.collapsed) {
              continue;
            }
            if (isSelectorFormat(curFormat) && dom2.is(parents2[i], curFormat.selector)) {
              return parents2[i];
            }
          }
        }
        return container;
      };
      const findBlockEndPoint = (dom2, formatList, container, siblingName) => {
        var _a;
        let node = container;
        const root = dom2.getRoot();
        const format = formatList[0];
        if (isBlockFormat(format)) {
          node = format.wrapper ? null : dom2.getParent(container, format.block, root);
        }
        if (!node) {
          const scopeRoot = (_a = dom2.getParent(container, "LI,TD,TH,SUMMARY")) !== null && _a !== void 0 ? _a : root;
          node = dom2.getParent(isText$b(container) ? container.parentNode : container, (node2) => node2 !== root && isTextBlock(dom2.schema, node2), scopeRoot);
        }
        if (node && isBlockFormat(format) && format.wrapper) {
          node = getParents$1(dom2, node, "ul,ol").reverse()[0] || node;
        }
        if (!node) {
          node = container;
          while (node && node[siblingName] && !dom2.isBlock(node[siblingName])) {
            node = node[siblingName];
            if (isEq$5(node, "br")) {
              break;
            }
          }
        }
        return node || container;
      };
      const isAtBlockBoundary$1 = (dom2, root, container, siblingName) => {
        const parent2 = container.parentNode;
        if (isNonNullable(container[siblingName])) {
          return false;
        } else if (parent2 === root || isNullable(parent2) || dom2.isBlock(parent2)) {
          return true;
        } else {
          return isAtBlockBoundary$1(dom2, root, parent2, siblingName);
        }
      };
      const findParentContainer = (dom2, formatList, container, offset, start2, expandToBlock) => {
        let parent2 = container;
        const siblingName = start2 ? "previousSibling" : "nextSibling";
        const root = dom2.getRoot();
        if (isText$b(container) && !isWhiteSpaceNode(container)) {
          if (start2 ? offset > 0 : offset < container.data.length) {
            return container;
          }
        }
        while (parent2) {
          if (isEditingHost(parent2)) {
            return container;
          }
          if (!formatList[0].block_expand && dom2.isBlock(parent2)) {
            return expandToBlock ? parent2 : container;
          }
          for (let sibling2 = parent2[siblingName]; sibling2; sibling2 = sibling2[siblingName]) {
            const allowSpaces = isText$b(sibling2) && !isAtBlockBoundary$1(dom2, root, sibling2, siblingName);
            if (!isBookmarkNode(sibling2) && !isBogusBr(sibling2) && !isWhiteSpaceNode(sibling2, allowSpaces)) {
              return parent2;
            }
          }
          if (parent2 === root || parent2.parentNode === root) {
            container = parent2;
            break;
          }
          parent2 = parent2.parentNode;
        }
        return container;
      };
      const isSelfOrParentBookmark = (container) => isBookmarkNode(container.parentNode) || isBookmarkNode(container);
      const expandRng = (dom2, rng, formatList, expandOptions = {}) => {
        const { includeTrailingSpace = false, expandToBlock = true } = expandOptions;
        const editableHost = dom2.getParent(rng.commonAncestorContainer, (node) => isEditingHost(node));
        const root = isNonNullable(editableHost) ? editableHost : dom2.getRoot();
        let { startContainer, startOffset, endContainer, endOffset } = rng;
        const format = formatList[0];
        if (isElement$6(startContainer) && startContainer.hasChildNodes()) {
          startContainer = getNode$1(startContainer, startOffset);
          if (isText$b(startContainer)) {
            startOffset = 0;
          }
        }
        if (isElement$6(endContainer) && endContainer.hasChildNodes()) {
          endContainer = getNode$1(endContainer, rng.collapsed ? endOffset : endOffset - 1);
          if (isText$b(endContainer)) {
            endOffset = endContainer.data.length;
          }
        }
        startContainer = findParentContentEditable(dom2, startContainer);
        endContainer = findParentContentEditable(dom2, endContainer);
        if (isSelfOrParentBookmark(startContainer)) {
          startContainer = isBookmarkNode(startContainer) ? startContainer : startContainer.parentNode;
          if (rng.collapsed) {
            startContainer = startContainer.previousSibling || startContainer;
          } else {
            startContainer = startContainer.nextSibling || startContainer;
          }
          if (isText$b(startContainer)) {
            startOffset = rng.collapsed ? startContainer.length : 0;
          }
        }
        if (isSelfOrParentBookmark(endContainer)) {
          endContainer = isBookmarkNode(endContainer) ? endContainer : endContainer.parentNode;
          if (rng.collapsed) {
            endContainer = endContainer.nextSibling || endContainer;
          } else {
            endContainer = endContainer.previousSibling || endContainer;
          }
          if (isText$b(endContainer)) {
            endOffset = rng.collapsed ? 0 : endContainer.length;
          }
        }
        if (rng.collapsed) {
          const startPoint = findWordEndPoint(dom2, root, startContainer, startOffset, true, includeTrailingSpace);
          startPoint.each(({ container, offset }) => {
            startContainer = container;
            startOffset = offset;
          });
          const endPoint = findWordEndPoint(dom2, root, endContainer, endOffset, false, includeTrailingSpace);
          endPoint.each(({ container, offset }) => {
            endContainer = container;
            endOffset = offset;
          });
        }
        if (isInlineFormat(format) || format.block_expand) {
          if (!isInlineFormat(format) || (!isText$b(startContainer) || startOffset === 0)) {
            startContainer = findParentContainer(dom2, formatList, startContainer, startOffset, true, expandToBlock);
          }
          if (!isInlineFormat(format) || (!isText$b(endContainer) || endOffset === endContainer.data.length)) {
            endContainer = findParentContainer(dom2, formatList, endContainer, endOffset, false, expandToBlock);
          }
        }
        if (shouldExpandToSelector(format)) {
          startContainer = findSelectorEndPoint(dom2, formatList, rng, startContainer, "previousSibling");
          endContainer = findSelectorEndPoint(dom2, formatList, rng, endContainer, "nextSibling");
        }
        if (isBlockFormat(format) || isSelectorFormat(format)) {
          startContainer = findBlockEndPoint(dom2, formatList, startContainer, "previousSibling");
          endContainer = findBlockEndPoint(dom2, formatList, endContainer, "nextSibling");
          if (isBlockFormat(format)) {
            if (!dom2.isBlock(startContainer)) {
              startContainer = findParentContainer(dom2, formatList, startContainer, startOffset, true, expandToBlock);
              if (isText$b(startContainer)) {
                startOffset = 0;
              }
            }
            if (!dom2.isBlock(endContainer)) {
              endContainer = findParentContainer(dom2, formatList, endContainer, endOffset, false, expandToBlock);
              if (isText$b(endContainer)) {
                endOffset = endContainer.data.length;
              }
            }
          }
        }
        if (isElement$6(startContainer) && startContainer.parentNode) {
          startOffset = dom2.nodeIndex(startContainer);
          startContainer = startContainer.parentNode;
        }
        if (isElement$6(endContainer) && endContainer.parentNode) {
          endOffset = dom2.nodeIndex(endContainer) + 1;
          endContainer = endContainer.parentNode;
        }
        return {
          startContainer,
          startOffset,
          endContainer,
          endOffset
        };
      };
      const walk$3 = (dom2, rng, callback) => {
        var _a;
        const startOffset = rng.startOffset;
        const startContainer = getNode$1(rng.startContainer, startOffset);
        const endOffset = rng.endOffset;
        const endContainer = getNode$1(rng.endContainer, endOffset - 1);
        const exclude = (nodes) => {
          const firstNode = nodes[0];
          if (isText$b(firstNode) && firstNode === startContainer && startOffset >= firstNode.data.length) {
            nodes.splice(0, 1);
          }
          const lastNode = nodes[nodes.length - 1];
          if (endOffset === 0 && nodes.length > 0 && lastNode === endContainer && isText$b(lastNode)) {
            nodes.splice(nodes.length - 1, 1);
          }
          return nodes;
        };
        const collectSiblings = (node, name2, endNode) => {
          const siblings3 = [];
          for (; node && node !== endNode; node = node[name2]) {
            siblings3.push(node);
          }
          return siblings3;
        };
        const findEndPoint = (node, root) => dom2.getParent(node, (node2) => node2.parentNode === root, root);
        const walkBoundary = (startNode, endNode, next2) => {
          const siblingName = next2 ? "nextSibling" : "previousSibling";
          for (let node = startNode, parent2 = node.parentNode; node && node !== endNode; node = parent2) {
            parent2 = node.parentNode;
            const siblings3 = collectSiblings(node === startNode ? node : node[siblingName], siblingName);
            if (siblings3.length) {
              if (!next2) {
                siblings3.reverse();
              }
              callback(exclude(siblings3));
            }
          }
        };
        if (startContainer === endContainer) {
          return callback(exclude([startContainer]));
        }
        const ancestor2 = (_a = dom2.findCommonAncestor(startContainer, endContainer)) !== null && _a !== void 0 ? _a : dom2.getRoot();
        if (dom2.isChildOf(startContainer, endContainer)) {
          return walkBoundary(startContainer, ancestor2, true);
        }
        if (dom2.isChildOf(endContainer, startContainer)) {
          return walkBoundary(endContainer, ancestor2);
        }
        const startPoint = findEndPoint(startContainer, ancestor2) || startContainer;
        const endPoint = findEndPoint(endContainer, ancestor2) || endContainer;
        walkBoundary(startContainer, startPoint, true);
        const siblings2 = collectSiblings(startPoint === startContainer ? startPoint : startPoint.nextSibling, "nextSibling", endPoint === endContainer ? endPoint.nextSibling : endPoint);
        if (siblings2.length) {
          callback(exclude(siblings2));
        }
        walkBoundary(endContainer, endPoint);
      };
      const validBlocks = [
        'pre[class*=language-][contenteditable="false"]',
        "figure.image",
        "div[data-ephox-embed-iri]",
        "div.tiny-pageembed",
        "div.mce-toc",
        "div[data-mce-toc]",
        "div.mce-footnotes"
      ];
      const isZeroWidth = (elem) => isText$c(elem) && get$3(elem) === ZWSP$1;
      const context = (editor, elem, wrapName, nodeName) => parentElement(elem).fold(() => "skipping", (parent2) => {
        if (nodeName === "br" || isZeroWidth(elem)) {
          return "valid";
        } else if (isAnnotation(elem)) {
          return "existing";
        } else if (isCaretNode(elem.dom)) {
          return "caret";
        } else if (exists(validBlocks, (selector) => is$1(elem, selector))) {
          return "valid-block";
        } else if (!isValid(editor, wrapName, nodeName) || !isValid(editor, name(parent2), wrapName)) {
          return "invalid-child";
        } else {
          return "valid";
        }
      });
      const applyWordGrab = (editor, rng) => {
        const r2 = expandRng(editor.dom, rng, [{ inline: "span" }]);
        rng.setStart(r2.startContainer, r2.startOffset);
        rng.setEnd(r2.endContainer, r2.endOffset);
        editor.selection.setRng(rng);
      };
      const applyAnnotation = (elem, masterUId, data2, annotationName, decorate, directAnnotation) => {
        const { uid: uid2 = masterUId, ...otherData } = data2;
        add$2(elem, annotation());
        set$4(elem, `${dataAnnotationId()}`, uid2);
        set$4(elem, `${dataAnnotation()}`, annotationName);
        const { attributes = {}, classes = [] } = decorate(uid2, otherData);
        setAll$1(elem, attributes);
        add(elem, classes);
        if (directAnnotation) {
          if (classes.length > 0) {
            set$4(elem, `${dataAnnotationClasses()}`, classes.join(","));
          }
          const attributeNames = keys(attributes);
          if (attributeNames.length > 0) {
            set$4(elem, `${dataAnnotationAttributes()}`, attributeNames.join(","));
          }
        }
      };
      const removeDirectAnnotation = (elem) => {
        remove$6(elem, annotation());
        remove$9(elem, `${dataAnnotationId()}`);
        remove$9(elem, `${dataAnnotation()}`);
        remove$9(elem, `${dataAnnotationActive()}`);
        const customAttrNames = getOpt(elem, `${dataAnnotationAttributes()}`).map((names) => names.split(",")).getOr([]);
        const customClasses = getOpt(elem, `${dataAnnotationClasses()}`).map((names) => names.split(",")).getOr([]);
        each$e(customAttrNames, (name2) => remove$9(elem, name2));
        remove$3(elem, customClasses);
        remove$9(elem, `${dataAnnotationClasses()}`);
        remove$9(elem, `${dataAnnotationAttributes()}`);
      };
      const makeAnnotation = (eDoc, uid2, data2, annotationName, decorate) => {
        const master = SugarElement.fromTag("span", eDoc);
        applyAnnotation(master, uid2, data2, annotationName, decorate, false);
        return master;
      };
      const annotate = (editor, rng, uid2, annotationName, decorate, data2) => {
        const newWrappers = [];
        const master = makeAnnotation(editor.getDoc(), uid2, data2, annotationName, decorate);
        const wrapper = value$2();
        const finishWrapper = () => {
          wrapper.clear();
        };
        const getOrOpenWrapper = () => wrapper.get().getOrThunk(() => {
          const nu2 = shallow$1(master);
          newWrappers.push(nu2);
          wrapper.set(nu2);
          return nu2;
        });
        const processElements = (elems) => {
          each$e(elems, processElement);
        };
        const processElement = (elem) => {
          const ctx = context(editor, elem, "span", name(elem));
          switch (ctx) {
            case "invalid-child": {
              finishWrapper();
              const children2 = children$1(elem);
              processElements(children2);
              finishWrapper();
              break;
            }
            case "valid-block": {
              finishWrapper();
              applyAnnotation(elem, uid2, data2, annotationName, decorate, true);
              break;
            }
            case "valid": {
              const w = getOrOpenWrapper();
              wrap$2(elem, w);
              break;
            }
          }
        };
        const processNodes = (nodes) => {
          const elems = map$3(nodes, SugarElement.fromDom);
          processElements(elems);
        };
        walk$3(editor.dom, rng, (nodes) => {
          finishWrapper();
          processNodes(nodes);
        });
        return newWrappers;
      };
      const annotateWithBookmark = (editor, name2, settings, data2) => {
        editor.undoManager.transact(() => {
          const selection = editor.selection;
          const initialRng = selection.getRng();
          const hasFakeSelection = getCellsFromEditor(editor).length > 0;
          const masterUid = generate$1("mce-annotation");
          if (initialRng.collapsed && !hasFakeSelection) {
            applyWordGrab(editor, initialRng);
          }
          if (selection.getRng().collapsed && !hasFakeSelection) {
            const wrapper = makeAnnotation(editor.getDoc(), masterUid, data2, name2, settings.decorate);
            set$1(wrapper, nbsp);
            selection.getRng().insertNode(wrapper.dom);
            selection.select(wrapper.dom);
          } else {
            preserve(selection, false, () => {
              runOnRanges(editor, (selectionRng) => {
                annotate(editor, selectionRng, masterUid, name2, settings.decorate, data2);
              });
            });
          }
        });
      };
      const Annotator = (editor) => {
        const registry2 = create$b();
        setup$x(editor, registry2);
        const changes = setup$y(editor, registry2);
        const isSpan2 = isTag("span");
        const removeAnnotations = (elements) => {
          each$e(elements, (element) => {
            if (isSpan2(element)) {
              unwrap(element);
            } else {
              removeDirectAnnotation(element);
            }
          });
        };
        return {
          register: (name2, settings) => {
            registry2.register(name2, settings);
          },
          annotate: (name2, data2) => {
            registry2.lookup(name2).each((settings) => {
              annotateWithBookmark(editor, name2, settings, data2);
            });
          },
          annotationChanged: (name2, callback) => {
            changes.addListener(name2, callback);
          },
          remove: (name2) => {
            identify(editor, Optional.some(name2)).each(({ elements }) => {
              const bookmark = editor.selection.getBookmark();
              removeAnnotations(elements);
              editor.selection.moveToBookmark(bookmark);
            });
          },
          removeAll: (name2) => {
            const bookmark = editor.selection.getBookmark();
            each$d(findAll(editor, name2), (elements, _) => {
              removeAnnotations(elements);
            });
            editor.selection.moveToBookmark(bookmark);
          },
          getAll: (name2) => {
            const directory = findAll(editor, name2);
            return map$2(directory, (elems) => map$3(elems, (elem) => elem.dom));
          }
        };
      };
      const BookmarkManager = (selection) => {
        return {
          getBookmark: curry(getBookmark$2, selection),
          moveToBookmark: curry(moveToBookmark, selection)
        };
      };
      BookmarkManager.isBookmarkNode = isBookmarkNode$1;
      const isXYWithinRange = (clientX, clientY, range2) => {
        if (range2.collapsed) {
          return false;
        } else {
          return exists(range2.getClientRects(), (rect) => containsXY(rect, clientX, clientY));
        }
      };
      const getDocument = () => SugarElement.fromDom(document);
      const focus$1 = (element, preventScroll = false) => element.dom.focus({ preventScroll });
      const hasFocus$1 = (element) => {
        const root = getRootNode(element).dom;
        return element.dom === root.activeElement;
      };
      const active$1 = (root = getDocument()) => Optional.from(root.dom.activeElement).map(SugarElement.fromDom);
      const search = (element) => active$1(getRootNode(element)).filter((e) => element.dom.contains(e.dom));
      const create$9 = (start2, soffset, finish, foffset) => ({
        start: start2,
        soffset,
        finish,
        foffset
      });
      const SimRange = { create: create$9 };
      const adt$3 = Adt.generate([
        { before: ["element"] },
        {
          on: [
            "element",
            "offset"
          ]
        },
        { after: ["element"] }
      ]);
      const cata = (subject, onBefore, onOn, onAfter) => subject.fold(onBefore, onOn, onAfter);
      const getStart$2 = (situ) => situ.fold(identity, identity, identity);
      const before$1 = adt$3.before;
      const on = adt$3.on;
      const after$1 = adt$3.after;
      const Situ = {
        before: before$1,
        on,
        after: after$1,
        cata,
        getStart: getStart$2
      };
      const adt$2 = Adt.generate([
        { domRange: ["rng"] },
        {
          relative: [
            "startSitu",
            "finishSitu"
          ]
        },
        {
          exact: [
            "start",
            "soffset",
            "finish",
            "foffset"
          ]
        }
      ]);
      const exactFromRange = (simRange) => adt$2.exact(simRange.start, simRange.soffset, simRange.finish, simRange.foffset);
      const getStart$1 = (selection) => selection.match({
        domRange: (rng) => SugarElement.fromDom(rng.startContainer),
        relative: (startSitu, _finishSitu) => Situ.getStart(startSitu),
        exact: (start2, _soffset, _finish, _foffset) => start2
      });
      const domRange = adt$2.domRange;
      const relative = adt$2.relative;
      const exact = adt$2.exact;
      const getWin = (selection) => {
        const start2 = getStart$1(selection);
        return defaultView(start2);
      };
      const range = SimRange.create;
      const SimSelection = {
        domRange,
        relative,
        exact,
        exactFromRange,
        getWin,
        range
      };
      const clamp$1 = (offset, element) => {
        const max2 = isText$c(element) ? get$3(element).length : children$1(element).length + 1;
        if (offset > max2) {
          return max2;
        } else if (offset < 0) {
          return 0;
        }
        return offset;
      };
      const normalizeRng = (rng) => SimSelection.range(rng.start, clamp$1(rng.soffset, rng.start), rng.finish, clamp$1(rng.foffset, rng.finish));
      const isOrContains = (root, elm) => !isRestrictedNode(elm.dom) && (contains(root, elm) || eq(root, elm));
      const isRngInRoot = (root) => (rng) => isOrContains(root, rng.start) && isOrContains(root, rng.finish);
      const shouldStore = (editor) => editor.inline || Env.browser.isFirefox();
      const nativeRangeToSelectionRange = (r2) => SimSelection.range(SugarElement.fromDom(r2.startContainer), r2.startOffset, SugarElement.fromDom(r2.endContainer), r2.endOffset);
      const readRange = (win) => {
        const selection = win.getSelection();
        const rng = !selection || selection.rangeCount === 0 ? Optional.none() : Optional.from(selection.getRangeAt(0));
        return rng.map(nativeRangeToSelectionRange);
      };
      const getBookmark$1 = (root) => {
        const win = defaultView(root);
        return readRange(win.dom).filter(isRngInRoot(root));
      };
      const validate = (root, bookmark) => Optional.from(bookmark).filter(isRngInRoot(root)).map(normalizeRng);
      const bookmarkToNativeRng = (bookmark) => {
        const rng = document.createRange();
        try {
          rng.setStart(bookmark.start.dom, bookmark.soffset);
          rng.setEnd(bookmark.finish.dom, bookmark.foffset);
          return Optional.some(rng);
        } catch (_a) {
          return Optional.none();
        }
      };
      const store = (editor) => {
        const newBookmark = shouldStore(editor) ? getBookmark$1(SugarElement.fromDom(editor.getBody())) : Optional.none();
        editor.bookmark = newBookmark.isSome() ? newBookmark : editor.bookmark;
      };
      const getRng = (editor) => {
        const bookmark = editor.bookmark ? editor.bookmark : Optional.none();
        return bookmark.bind((x) => validate(SugarElement.fromDom(editor.getBody()), x)).bind(bookmarkToNativeRng);
      };
      const restore = (editor) => {
        getRng(editor).each((rng) => editor.selection.setRng(rng));
      };
      const isEditorUIElement$1 = (elm) => {
        const className = elm.className.toString();
        return className.indexOf("tox-") !== -1 || className.indexOf("mce-") !== -1;
      };
      const FocusManager = { isEditorUIElement: isEditorUIElement$1 };
      const wrappedSetTimeout = (callback, time) => {
        if (!isNumber(time)) {
          time = 0;
        }
        return window.setTimeout(callback, time);
      };
      const wrappedSetInterval = (callback, time) => {
        if (!isNumber(time)) {
          time = 0;
        }
        return window.setInterval(callback, time);
      };
      const Delay = {
        setEditorTimeout: (editor, callback, time) => {
          return wrappedSetTimeout(() => {
            if (!editor.removed) {
              callback();
            }
          }, time);
        },
        setEditorInterval: (editor, callback, time) => {
          const timer = wrappedSetInterval(() => {
            if (!editor.removed) {
              callback();
            } else {
              window.clearInterval(timer);
            }
          }, time);
          return timer;
        }
      };
      const isManualNodeChange = (e) => {
        return e.type === "nodechange" && e.selectionChange;
      };
      const registerPageMouseUp = (editor, throttledStore) => {
        const mouseUpPage = () => {
          throttledStore.throttle();
        };
        DOMUtils.DOM.bind(document, "mouseup", mouseUpPage);
        editor.on("remove", () => {
          DOMUtils.DOM.unbind(document, "mouseup", mouseUpPage);
        });
      };
      const registerMouseUp = (editor, throttledStore) => {
        editor.on("mouseup touchend", (_e) => {
          throttledStore.throttle();
        });
      };
      const registerEditorEvents = (editor, throttledStore) => {
        registerMouseUp(editor, throttledStore);
        editor.on("keyup NodeChange AfterSetSelectionRange", (e) => {
          if (!isManualNodeChange(e)) {
            store(editor);
          }
        });
      };
      const register$6 = (editor) => {
        const throttledStore = first$1(() => {
          store(editor);
        }, 0);
        editor.on("init", () => {
          if (editor.inline) {
            registerPageMouseUp(editor, throttledStore);
          }
          registerEditorEvents(editor, throttledStore);
        });
        editor.on("remove", () => {
          throttledStore.cancel();
        });
      };
      let documentFocusInHandler;
      const DOM$9 = DOMUtils.DOM;
      const isEditorUIElement = (elm) => {
        return isElement$6(elm) && FocusManager.isEditorUIElement(elm);
      };
      const isEditorContentAreaElement = (elm) => {
        const classList = elm.classList;
        if (classList !== void 0) {
          return classList.contains("tox-edit-area") || classList.contains("tox-edit-area__iframe") || classList.contains("mce-content-body");
        } else {
          return false;
        }
      };
      const isUIElement = (editor, elm) => {
        const customSelector = getCustomUiSelector(editor);
        const parent2 = DOM$9.getParent(elm, (elm2) => {
          return isEditorUIElement(elm2) || (customSelector ? editor.dom.is(elm2, customSelector) : false);
        });
        return parent2 !== null;
      };
      const getActiveElement = (editor) => {
        try {
          const root = getRootNode(SugarElement.fromDom(editor.getElement()));
          return active$1(root).fold(() => document.body, (x) => x.dom);
        } catch (_a) {
          return document.body;
        }
      };
      const registerEvents$1 = (editorManager, e) => {
        const editor = e.editor;
        register$6(editor);
        const toggleContentAreaOnFocus = (editor2, fn) => {
          if (shouldHighlightOnFocus(editor2) && editor2.inline !== true) {
            const contentArea = SugarElement.fromDom(editor2.getContainer());
            fn(contentArea, "tox-edit-focus");
          }
        };
        editor.on("focusin", () => {
          const focusedEditor = editorManager.focusedEditor;
          if (isEditorContentAreaElement(getActiveElement(editor))) {
            toggleContentAreaOnFocus(editor, add$2);
          }
          if (focusedEditor !== editor) {
            if (focusedEditor) {
              focusedEditor.dispatch("blur", { focusedEditor: editor });
            }
            editorManager.setActive(editor);
            editorManager.focusedEditor = editor;
            editor.dispatch("focus", { blurredEditor: focusedEditor });
            editor.focus(true);
          }
        });
        editor.on("focusout", () => {
          Delay.setEditorTimeout(editor, () => {
            const focusedEditor = editorManager.focusedEditor;
            if (!isEditorContentAreaElement(getActiveElement(editor)) || focusedEditor !== editor) {
              toggleContentAreaOnFocus(editor, remove$6);
            }
            if (!isUIElement(editor, getActiveElement(editor)) && focusedEditor === editor) {
              editor.dispatch("blur", { focusedEditor: null });
              editorManager.focusedEditor = null;
            }
          });
        });
        if (!documentFocusInHandler) {
          documentFocusInHandler = (e2) => {
            const activeEditor = editorManager.activeEditor;
            if (activeEditor) {
              getOriginalEventTarget(e2).each((target) => {
                const elem = target;
                if (elem.ownerDocument === document) {
                  if (elem !== document.body && !isUIElement(activeEditor, elem) && editorManager.focusedEditor === activeEditor) {
                    activeEditor.dispatch("blur", { focusedEditor: null });
                    editorManager.focusedEditor = null;
                  }
                }
              });
            }
          };
          DOM$9.bind(document, "focusin", documentFocusInHandler);
        }
      };
      const unregisterDocumentEvents = (editorManager, e) => {
        if (editorManager.focusedEditor === e.editor) {
          editorManager.focusedEditor = null;
        }
        if (!editorManager.activeEditor && documentFocusInHandler) {
          DOM$9.unbind(document, "focusin", documentFocusInHandler);
          documentFocusInHandler = null;
        }
      };
      const setup$w = (editorManager) => {
        editorManager.on("AddEditor", curry(registerEvents$1, editorManager));
        editorManager.on("RemoveEditor", curry(unregisterDocumentEvents, editorManager));
      };
      const getContentEditableHost = (editor, node) => editor.dom.getParent(node, (node2) => editor.dom.getContentEditable(node2) === "true");
      const hasContentEditableFalseParent$1 = (editor, node) => editor.dom.getParent(node, (node2) => editor.dom.getContentEditable(node2) === "false") !== null;
      const getCollapsedNode = (rng) => rng.collapsed ? Optional.from(getNode$1(rng.startContainer, rng.startOffset)).map(SugarElement.fromDom) : Optional.none();
      const getFocusInElement = (root, rng) => getCollapsedNode(rng).bind((node) => {
        if (isTableSection(node)) {
          return Optional.some(node);
        } else if (!contains(root, node)) {
          return Optional.some(root);
        } else {
          return Optional.none();
        }
      });
      const normalizeSelection = (editor, rng) => {
        getFocusInElement(SugarElement.fromDom(editor.getBody()), rng).bind((elm) => {
          return firstPositionIn(elm.dom);
        }).fold(() => {
          editor.selection.normalize();
        }, (caretPos) => editor.selection.setRng(caretPos.toRange()));
      };
      const focusBody = (body) => {
        if (body.setActive) {
          try {
            body.setActive();
          } catch (_a) {
            body.focus();
          }
        } else {
          body.focus();
        }
      };
      const hasElementFocus = (elm) => hasFocus$1(elm) || search(elm).isSome();
      const hasIframeFocus = (editor) => isNonNullable(editor.iframeElement) && hasFocus$1(SugarElement.fromDom(editor.iframeElement));
      const hasInlineFocus = (editor) => {
        const rawBody = editor.getBody();
        return rawBody && hasElementFocus(SugarElement.fromDom(rawBody));
      };
      const hasUiFocus = (editor) => {
        const dos = getRootNode(SugarElement.fromDom(editor.getElement()));
        return active$1(dos).filter((elem) => !isEditorContentAreaElement(elem.dom) && isUIElement(editor, elem.dom)).isSome();
      };
      const hasFocus = (editor) => editor.inline ? hasInlineFocus(editor) : hasIframeFocus(editor);
      const hasEditorOrUiFocus = (editor) => hasFocus(editor) || hasUiFocus(editor);
      const focusEditor = (editor) => {
        const selection = editor.selection;
        const body = editor.getBody();
        let rng = selection.getRng();
        editor.quirks.refreshContentEditable();
        const restoreBookmark = (editor2) => {
          getRng(editor2).each((bookmarkRng) => {
            editor2.selection.setRng(bookmarkRng);
            rng = bookmarkRng;
          });
        };
        if (!hasFocus(editor) && editor.hasEditableRoot()) {
          restoreBookmark(editor);
        }
        const contentEditableHost = getContentEditableHost(editor, selection.getNode());
        if (contentEditableHost && editor.dom.isChildOf(contentEditableHost, body)) {
          if (!hasContentEditableFalseParent$1(editor, contentEditableHost)) {
            focusBody(body);
          }
          focusBody(contentEditableHost);
          if (!editor.hasEditableRoot()) {
            restoreBookmark(editor);
          }
          normalizeSelection(editor, rng);
          activateEditor(editor);
          return;
        }
        if (!editor.inline) {
          if (!Env.browser.isOpera()) {
            focusBody(body);
          }
          editor.getWin().focus();
        }
        if (Env.browser.isFirefox() || editor.inline) {
          focusBody(body);
          normalizeSelection(editor, rng);
        }
        activateEditor(editor);
      };
      const activateEditor = (editor) => editor.editorManager.setActive(editor);
      const focus = (editor, skipFocus) => {
        if (editor.removed) {
          return;
        }
        if (skipFocus) {
          activateEditor(editor);
        } else {
          focusEditor(editor);
        }
      };
      const VK = {
        BACKSPACE: 8,
        DELETE: 46,
        DOWN: 40,
        ENTER: 13,
        ESC: 27,
        LEFT: 37,
        RIGHT: 39,
        SPACEBAR: 32,
        TAB: 9,
        UP: 38,
        PAGE_UP: 33,
        PAGE_DOWN: 34,
        END: 35,
        HOME: 36,
        modifierPressed: (e) => {
          return e.shiftKey || e.ctrlKey || e.altKey || VK.metaKeyPressed(e);
        },
        metaKeyPressed: (e) => {
          return Env.os.isMacOS() || Env.os.isiOS() ? e.metaKey : e.ctrlKey && !e.altKey;
        }
      };
      const elementSelectionAttr = "data-mce-selected";
      const controlElmSelector = "table,img,figure.image,hr,video,span.mce-preview-object,details";
      const abs = Math.abs;
      const round$1 = Math.round;
      const resizeHandles = {
        nw: [
          0,
          0,
          -1,
          -1
        ],
        ne: [
          1,
          0,
          1,
          -1
        ],
        se: [
          1,
          1,
          1,
          1
        ],
        sw: [
          0,
          1,
          -1,
          1
        ]
      };
      const isTouchEvent = (evt) => evt.type === "longpress" || evt.type.indexOf("touch") === 0;
      const ControlSelection = (selection, editor) => {
        const dom2 = editor.dom;
        const editableDoc = editor.getDoc();
        const rootDocument = document;
        const rootElement = editor.getBody();
        let selectedElm, selectedElmGhost, resizeHelper, selectedHandle, resizeBackdrop;
        let startX, startY, startW, startH, ratio, resizeStarted;
        let width;
        let height;
        let startScrollWidth;
        let startScrollHeight;
        const isImage2 = (elm) => isNonNullable(elm) && (isImg(elm) || dom2.is(elm, "figure.image"));
        const isMedia2 = (elm) => isMedia$2(elm) || dom2.hasClass(elm, "mce-preview-object");
        const isEventOnImageOutsideRange = (evt, range2) => {
          if (isTouchEvent(evt)) {
            const touch = evt.touches[0];
            return isImage2(evt.target) && !isXYWithinRange(touch.clientX, touch.clientY, range2);
          } else {
            return isImage2(evt.target) && !isXYWithinRange(evt.clientX, evt.clientY, range2);
          }
        };
        const contextMenuSelectImage = (evt) => {
          const target = evt.target;
          if (isEventOnImageOutsideRange(evt, editor.selection.getRng()) && !evt.isDefaultPrevented()) {
            editor.selection.select(target);
          }
        };
        const getResizeTargets = (elm) => {
          if (dom2.hasClass(elm, "mce-preview-object") && isNonNullable(elm.firstElementChild)) {
            return [
              elm,
              elm.firstElementChild
            ];
          } else if (dom2.is(elm, "figure.image")) {
            return [elm.querySelector("img")];
          } else {
            return [elm];
          }
        };
        const isResizable = (elm) => {
          const selector = getObjectResizing(editor);
          if (!selector || editor.mode.isReadOnly()) {
            return false;
          }
          if (elm.getAttribute("data-mce-resize") === "false") {
            return false;
          }
          if (elm === editor.getBody()) {
            return false;
          }
          if (dom2.hasClass(elm, "mce-preview-object") && isNonNullable(elm.firstElementChild)) {
            return is$1(SugarElement.fromDom(elm.firstElementChild), selector);
          } else {
            return is$1(SugarElement.fromDom(elm), selector);
          }
        };
        const createGhostElement = (dom3, elm) => {
          if (isMedia2(elm)) {
            return dom3.create("img", { src: Env.transparentSrc });
          } else if (isTable$2(elm)) {
            const isNorth = startsWith(selectedHandle.name, "n");
            const rowSelect = isNorth ? head : last$2;
            const tableElm = elm.cloneNode(true);
            rowSelect(dom3.select("tr", tableElm)).each((tr) => {
              const cells2 = dom3.select("td,th", tr);
              dom3.setStyle(tr, "height", null);
              each$e(cells2, (cell2) => dom3.setStyle(cell2, "height", null));
            });
            return tableElm;
          } else {
            return elm.cloneNode(true);
          }
        };
        const setSizeProp = (element, name2, value2) => {
          if (isNonNullable(value2)) {
            const targets = getResizeTargets(element);
            each$e(targets, (target) => {
              if (target.style[name2] || !editor.schema.isValid(target.nodeName.toLowerCase(), name2)) {
                dom2.setStyle(target, name2, value2);
              } else {
                dom2.setAttrib(target, name2, "" + value2);
              }
            });
          }
        };
        const setGhostElmSize = (ghostElm, width2, height2) => {
          setSizeProp(ghostElm, "width", width2);
          setSizeProp(ghostElm, "height", height2);
        };
        const resizeGhostElement = (e) => {
          let deltaX, deltaY, proportional;
          let resizeHelperX, resizeHelperY;
          deltaX = e.screenX - startX;
          deltaY = e.screenY - startY;
          width = deltaX * selectedHandle[2] + startW;
          height = deltaY * selectedHandle[3] + startH;
          width = width < 5 ? 5 : width;
          height = height < 5 ? 5 : height;
          if ((isImage2(selectedElm) || isMedia2(selectedElm)) && getResizeImgProportional(editor) !== false) {
            proportional = !VK.modifierPressed(e);
          } else {
            proportional = VK.modifierPressed(e);
          }
          if (proportional) {
            if (abs(deltaX) > abs(deltaY)) {
              height = round$1(width * ratio);
              width = round$1(height / ratio);
            } else {
              width = round$1(height / ratio);
              height = round$1(width * ratio);
            }
          }
          setGhostElmSize(selectedElmGhost, width, height);
          resizeHelperX = selectedHandle.startPos.x + deltaX;
          resizeHelperY = selectedHandle.startPos.y + deltaY;
          resizeHelperX = resizeHelperX > 0 ? resizeHelperX : 0;
          resizeHelperY = resizeHelperY > 0 ? resizeHelperY : 0;
          dom2.setStyles(resizeHelper, {
            left: resizeHelperX,
            top: resizeHelperY,
            display: "block"
          });
          resizeHelper.innerHTML = width + " &times; " + height;
          deltaX = rootElement.scrollWidth - startScrollWidth;
          deltaY = rootElement.scrollHeight - startScrollHeight;
          if (deltaX + deltaY !== 0) {
            dom2.setStyles(resizeHelper, {
              left: resizeHelperX - deltaX,
              top: resizeHelperY - deltaY
            });
          }
          if (!resizeStarted) {
            fireObjectResizeStart(editor, selectedElm, startW, startH, "corner-" + selectedHandle.name);
            resizeStarted = true;
          }
        };
        const endGhostResize = () => {
          const wasResizeStarted = resizeStarted;
          resizeStarted = false;
          if (wasResizeStarted) {
            setSizeProp(selectedElm, "width", width);
            setSizeProp(selectedElm, "height", height);
          }
          dom2.unbind(editableDoc, "mousemove", resizeGhostElement);
          dom2.unbind(editableDoc, "mouseup", endGhostResize);
          if (rootDocument !== editableDoc) {
            dom2.unbind(rootDocument, "mousemove", resizeGhostElement);
            dom2.unbind(rootDocument, "mouseup", endGhostResize);
          }
          dom2.remove(selectedElmGhost);
          dom2.remove(resizeHelper);
          dom2.remove(resizeBackdrop);
          showResizeRect(selectedElm);
          if (wasResizeStarted) {
            fireObjectResized(editor, selectedElm, width, height, "corner-" + selectedHandle.name);
            dom2.setAttrib(selectedElm, "style", dom2.getAttrib(selectedElm, "style"));
          }
          editor.nodeChanged();
        };
        const showResizeRect = (targetElm) => {
          unbindResizeHandleEvents();
          const position = dom2.getPos(targetElm, rootElement);
          const selectedElmX = position.x;
          const selectedElmY = position.y;
          const rect = targetElm.getBoundingClientRect();
          const targetWidth = rect.width || rect.right - rect.left;
          const targetHeight = rect.height || rect.bottom - rect.top;
          if (selectedElm !== targetElm) {
            hideResizeRect();
            selectedElm = targetElm;
            width = height = 0;
          }
          const e = editor.dispatch("ObjectSelected", { target: targetElm });
          if (isResizable(targetElm) && !e.isDefaultPrevented()) {
            each$d(resizeHandles, (handle2, name2) => {
              const startDrag = (e2) => {
                const target = getResizeTargets(selectedElm)[0];
                startX = e2.screenX;
                startY = e2.screenY;
                startW = target.clientWidth;
                startH = target.clientHeight;
                ratio = startH / startW;
                selectedHandle = handle2;
                selectedHandle.name = name2;
                selectedHandle.startPos = {
                  x: targetWidth * handle2[0] + selectedElmX,
                  y: targetHeight * handle2[1] + selectedElmY
                };
                startScrollWidth = rootElement.scrollWidth;
                startScrollHeight = rootElement.scrollHeight;
                resizeBackdrop = dom2.add(rootElement, "div", {
                  "class": "mce-resize-backdrop",
                  "data-mce-bogus": "all"
                });
                dom2.setStyles(resizeBackdrop, {
                  position: "fixed",
                  left: "0",
                  top: "0",
                  width: "100%",
                  height: "100%"
                });
                selectedElmGhost = createGhostElement(dom2, selectedElm);
                dom2.addClass(selectedElmGhost, "mce-clonedresizable");
                dom2.setAttrib(selectedElmGhost, "data-mce-bogus", "all");
                selectedElmGhost.contentEditable = "false";
                dom2.setStyles(selectedElmGhost, {
                  left: selectedElmX,
                  top: selectedElmY,
                  margin: 0
                });
                setGhostElmSize(selectedElmGhost, targetWidth, targetHeight);
                selectedElmGhost.removeAttribute(elementSelectionAttr);
                rootElement.appendChild(selectedElmGhost);
                dom2.bind(editableDoc, "mousemove", resizeGhostElement);
                dom2.bind(editableDoc, "mouseup", endGhostResize);
                if (rootDocument !== editableDoc) {
                  dom2.bind(rootDocument, "mousemove", resizeGhostElement);
                  dom2.bind(rootDocument, "mouseup", endGhostResize);
                }
                resizeHelper = dom2.add(rootElement, "div", {
                  "class": "mce-resize-helper",
                  "data-mce-bogus": "all"
                }, startW + " &times; " + startH);
              };
              let handleElm = dom2.get("mceResizeHandle" + name2);
              if (handleElm) {
                dom2.remove(handleElm);
              }
              handleElm = dom2.add(rootElement, "div", {
                "id": "mceResizeHandle" + name2,
                "data-mce-bogus": "all",
                "class": "mce-resizehandle",
                "unselectable": true,
                "style": "cursor:" + name2 + "-resize; margin:0; padding:0"
              });
              dom2.bind(handleElm, "mousedown", (e2) => {
                e2.stopImmediatePropagation();
                e2.preventDefault();
                startDrag(e2);
              });
              handle2.elm = handleElm;
              dom2.setStyles(handleElm, {
                left: targetWidth * handle2[0] + selectedElmX - handleElm.offsetWidth / 2,
                top: targetHeight * handle2[1] + selectedElmY - handleElm.offsetHeight / 2
              });
            });
          } else {
            hideResizeRect(false);
          }
        };
        const throttledShowResizeRect = first$1(showResizeRect, 0);
        const hideResizeRect = (removeSelected = true) => {
          throttledShowResizeRect.cancel();
          unbindResizeHandleEvents();
          if (selectedElm && removeSelected) {
            selectedElm.removeAttribute(elementSelectionAttr);
          }
          each$d(resizeHandles, (value2, name2) => {
            const handleElm = dom2.get("mceResizeHandle" + name2);
            if (handleElm) {
              dom2.unbind(handleElm);
              dom2.remove(handleElm);
            }
          });
        };
        const isChildOrEqual = (node, parent2) => dom2.isChildOf(node, parent2);
        const updateResizeRect = (e) => {
          if (resizeStarted || editor.removed || editor.composing) {
            return;
          }
          const targetElm = e.type === "mousedown" ? e.target : selection.getNode();
          const controlElm = closest$3(SugarElement.fromDom(targetElm), controlElmSelector).map((e2) => e2.dom).filter((e2) => dom2.isEditable(e2.parentElement) || e2.nodeName === "IMG" && dom2.isEditable(e2)).getOrUndefined();
          const selectedValue = isNonNullable(controlElm) ? dom2.getAttrib(controlElm, elementSelectionAttr, "1") : "1";
          each$e(dom2.select(`img[${elementSelectionAttr}],hr[${elementSelectionAttr}]`), (img) => {
            img.removeAttribute(elementSelectionAttr);
          });
          if (isNonNullable(controlElm) && isChildOrEqual(controlElm, rootElement) && hasEditorOrUiFocus(editor)) {
            disableGeckoResize();
            const startElm = selection.getStart(true);
            if (isChildOrEqual(startElm, controlElm) && isChildOrEqual(selection.getEnd(true), controlElm)) {
              dom2.setAttrib(controlElm, elementSelectionAttr, selectedValue);
              throttledShowResizeRect.throttle(controlElm);
              return;
            }
          }
          hideResizeRect();
        };
        const unbindResizeHandleEvents = () => {
          each$d(resizeHandles, (handle2) => {
            if (handle2.elm) {
              dom2.unbind(handle2.elm);
              delete handle2.elm;
            }
          });
        };
        const disableGeckoResize = () => {
          try {
            editor.getDoc().execCommand("enableObjectResizing", false, "false");
          } catch (_a) {
          }
        };
        editor.on("init", () => {
          disableGeckoResize();
          editor.on("NodeChange ResizeEditor ResizeWindow ResizeContent drop", updateResizeRect);
          editor.on("keyup compositionend", (e) => {
            if (selectedElm && selectedElm.nodeName === "TABLE") {
              updateResizeRect(e);
            }
          });
          editor.on("hide blur", hideResizeRect);
          editor.on("contextmenu longpress", contextMenuSelectImage, true);
        });
        editor.on("remove", unbindResizeHandleEvents);
        const destroy2 = () => {
          throttledShowResizeRect.cancel();
          selectedElm = selectedElmGhost = resizeBackdrop = null;
        };
        return {
          isResizable,
          showResizeRect,
          hideResizeRect,
          updateResizeRect,
          destroy: destroy2
        };
      };
      const setStart = (rng, situ) => {
        situ.fold((e) => {
          rng.setStartBefore(e.dom);
        }, (e, o) => {
          rng.setStart(e.dom, o);
        }, (e) => {
          rng.setStartAfter(e.dom);
        });
      };
      const setFinish = (rng, situ) => {
        situ.fold((e) => {
          rng.setEndBefore(e.dom);
        }, (e, o) => {
          rng.setEnd(e.dom, o);
        }, (e) => {
          rng.setEndAfter(e.dom);
        });
      };
      const relativeToNative = (win, startSitu, finishSitu) => {
        const range2 = win.document.createRange();
        setStart(range2, startSitu);
        setFinish(range2, finishSitu);
        return range2;
      };
      const exactToNative = (win, start2, soffset, finish, foffset) => {
        const rng = win.document.createRange();
        rng.setStart(start2.dom, soffset);
        rng.setEnd(finish.dom, foffset);
        return rng;
      };
      const adt$1 = Adt.generate([
        {
          ltr: [
            "start",
            "soffset",
            "finish",
            "foffset"
          ]
        },
        {
          rtl: [
            "start",
            "soffset",
            "finish",
            "foffset"
          ]
        }
      ]);
      const fromRange = (win, type2, range2) => type2(SugarElement.fromDom(range2.startContainer), range2.startOffset, SugarElement.fromDom(range2.endContainer), range2.endOffset);
      const getRanges = (win, selection) => selection.match({
        domRange: (rng) => {
          return {
            ltr: constant(rng),
            rtl: Optional.none
          };
        },
        relative: (startSitu, finishSitu) => {
          return {
            ltr: cached(() => relativeToNative(win, startSitu, finishSitu)),
            rtl: cached(() => Optional.some(relativeToNative(win, finishSitu, startSitu)))
          };
        },
        exact: (start2, soffset, finish, foffset) => {
          return {
            ltr: cached(() => exactToNative(win, start2, soffset, finish, foffset)),
            rtl: cached(() => Optional.some(exactToNative(win, finish, foffset, start2, soffset)))
          };
        }
      });
      const doDiagnose = (win, ranges) => {
        const rng = ranges.ltr();
        if (rng.collapsed) {
          const reversed = ranges.rtl().filter((rev) => rev.collapsed === false);
          return reversed.map((rev) => adt$1.rtl(SugarElement.fromDom(rev.endContainer), rev.endOffset, SugarElement.fromDom(rev.startContainer), rev.startOffset)).getOrThunk(() => fromRange(win, adt$1.ltr, rng));
        } else {
          return fromRange(win, adt$1.ltr, rng);
        }
      };
      const diagnose = (win, selection) => {
        const ranges = getRanges(win, selection);
        return doDiagnose(win, ranges);
      };
      adt$1.ltr;
      adt$1.rtl;
      const caretPositionFromPoint = (doc, x, y) => {
        var _a;
        return Optional.from((_a = doc.caretPositionFromPoint) === null || _a === void 0 ? void 0 : _a.call(doc, x, y)).bind((pos) => {
          if (pos.offsetNode === null) {
            return Optional.none();
          }
          const r2 = doc.createRange();
          r2.setStart(pos.offsetNode, pos.offset);
          r2.collapse();
          return Optional.some(r2);
        });
      };
      const caretRangeFromPoint = (doc, x, y) => {
        var _a;
        return Optional.from((_a = doc.caretRangeFromPoint) === null || _a === void 0 ? void 0 : _a.call(doc, x, y));
      };
      const availableSearch = (doc, x, y) => {
        if (doc.caretPositionFromPoint) {
          return caretPositionFromPoint(doc, x, y);
        } else if (doc.caretRangeFromPoint) {
          return caretRangeFromPoint(doc, x, y);
        } else {
          return Optional.none();
        }
      };
      const fromPoint$1 = (win, x, y) => {
        const doc = win.document;
        return availableSearch(doc, x, y).map((rng) => SimRange.create(SugarElement.fromDom(rng.startContainer), rng.startOffset, SugarElement.fromDom(rng.endContainer), rng.endOffset));
      };
      const beforeSpecial = (element, offset) => {
        const name$1 = name(element);
        if ("input" === name$1) {
          return Situ.after(element);
        } else if (!contains$2([
          "br",
          "img"
        ], name$1)) {
          return Situ.on(element, offset);
        } else {
          return offset === 0 ? Situ.before(element) : Situ.after(element);
        }
      };
      const preprocessRelative = (startSitu, finishSitu) => {
        const start2 = startSitu.fold(Situ.before, beforeSpecial, Situ.after);
        const finish = finishSitu.fold(Situ.before, beforeSpecial, Situ.after);
        return SimSelection.relative(start2, finish);
      };
      const preprocessExact = (start2, soffset, finish, foffset) => {
        const startSitu = beforeSpecial(start2, soffset);
        const finishSitu = beforeSpecial(finish, foffset);
        return SimSelection.relative(startSitu, finishSitu);
      };
      const preprocess = (selection) => selection.match({
        domRange: (rng) => {
          const start2 = SugarElement.fromDom(rng.startContainer);
          const finish = SugarElement.fromDom(rng.endContainer);
          return preprocessExact(start2, rng.startOffset, finish, rng.endOffset);
        },
        relative: preprocessRelative,
        exact: preprocessExact
      });
      const fromElements = (elements, scope) => {
        const doc = scope || document;
        const fragment = doc.createDocumentFragment();
        each$e(elements, (element) => {
          fragment.appendChild(element.dom);
        });
        return SugarElement.fromDom(fragment);
      };
      const toNative = (selection) => {
        const win = SimSelection.getWin(selection).dom;
        const getDomRange = (start2, soffset, finish, foffset) => exactToNative(win, start2, soffset, finish, foffset);
        const filtered = preprocess(selection);
        return diagnose(win, filtered).match({
          ltr: getDomRange,
          rtl: getDomRange
        });
      };
      const getAtPoint = (win, x, y) => fromPoint$1(win, x, y);
      const fromPoint = (clientX, clientY, doc) => {
        const win = defaultView(SugarElement.fromDom(doc));
        return getAtPoint(win.dom, clientX, clientY).map((simRange) => {
          const rng = doc.createRange();
          rng.setStart(simRange.start.dom, simRange.soffset);
          rng.setEnd(simRange.finish.dom, simRange.foffset);
          return rng;
        }).getOrUndefined();
      };
      const isEq$4 = (rng1, rng2) => {
        return isNonNullable(rng1) && isNonNullable(rng2) && (rng1.startContainer === rng2.startContainer && rng1.startOffset === rng2.startOffset) && (rng1.endContainer === rng2.endContainer && rng1.endOffset === rng2.endOffset);
      };
      const findParent = (node, rootNode, predicate) => {
        let currentNode = node;
        while (currentNode && currentNode !== rootNode) {
          if (predicate(currentNode)) {
            return currentNode;
          }
          currentNode = currentNode.parentNode;
        }
        return null;
      };
      const hasParent$1 = (node, rootNode, predicate) => findParent(node, rootNode, predicate) !== null;
      const hasParentWithName = (node, rootNode, name2) => hasParent$1(node, rootNode, (node2) => node2.nodeName === name2);
      const isCeFalseCaretContainer = (node, rootNode) => isCaretContainer$2(node) && !hasParent$1(node, rootNode, isCaretNode);
      const hasBrBeforeAfter = (dom2, node, left) => {
        const parentNode = node.parentNode;
        if (parentNode) {
          const walker = new DomTreeWalker(node, dom2.getParent(parentNode, dom2.isBlock) || dom2.getRoot());
          let currentNode;
          while (currentNode = walker[left ? "prev" : "next"]()) {
            if (isBr$6(currentNode)) {
              return true;
            }
          }
        }
        return false;
      };
      const isPrevNode = (node, name2) => {
        var _a;
        return ((_a = node.previousSibling) === null || _a === void 0 ? void 0 : _a.nodeName) === name2;
      };
      const hasContentEditableFalseParent = (root, node) => {
        let currentNode = node;
        while (currentNode && currentNode !== root) {
          if (isContentEditableFalse$b(currentNode)) {
            return true;
          }
          currentNode = currentNode.parentNode;
        }
        return false;
      };
      const findTextNodeRelative = (dom2, isAfterNode, collapsed, left, startNode) => {
        const body = dom2.getRoot();
        const nonEmptyElementsMap = dom2.schema.getNonEmptyElements();
        const parentNode = startNode.parentNode;
        let lastInlineElement;
        let node;
        if (!parentNode) {
          return Optional.none();
        }
        const parentBlockContainer = dom2.getParent(parentNode, dom2.isBlock) || body;
        if (left && isBr$6(startNode) && isAfterNode && dom2.isEmpty(parentBlockContainer)) {
          return Optional.some(CaretPosition(parentNode, dom2.nodeIndex(startNode)));
        }
        const walker = new DomTreeWalker(startNode, parentBlockContainer);
        while (node = walker[left ? "prev" : "next"]()) {
          if (dom2.getContentEditableParent(node) === "false" || isCeFalseCaretContainer(node, body)) {
            return Optional.none();
          }
          if (isText$b(node) && node.data.length > 0) {
            if (!hasParentWithName(node, body, "A")) {
              return Optional.some(CaretPosition(node, left ? node.data.length : 0));
            }
            return Optional.none();
          }
          if (dom2.isBlock(node) || nonEmptyElementsMap[node.nodeName.toLowerCase()]) {
            return Optional.none();
          }
          lastInlineElement = node;
        }
        if (isComment(lastInlineElement)) {
          return Optional.none();
        }
        if (collapsed && lastInlineElement) {
          return Optional.some(CaretPosition(lastInlineElement, 0));
        }
        return Optional.none();
      };
      const normalizeEndPoint = (dom2, collapsed, start2, rng) => {
        const body = dom2.getRoot();
        let node;
        let normalized = false;
        let container = start2 ? rng.startContainer : rng.endContainer;
        let offset = start2 ? rng.startOffset : rng.endOffset;
        const isAfterNode = isElement$6(container) && offset === container.childNodes.length;
        const nonEmptyElementsMap = dom2.schema.getNonEmptyElements();
        let directionLeft = start2;
        if (isCaretContainer$2(container)) {
          return Optional.none();
        }
        if (isElement$6(container) && offset > container.childNodes.length - 1) {
          directionLeft = false;
        }
        if (isDocument$1(container)) {
          container = body;
          offset = 0;
        }
        if (container === body) {
          if (directionLeft) {
            node = container.childNodes[offset > 0 ? offset - 1 : 0];
            if (node) {
              if (isCaretContainer$2(node)) {
                return Optional.none();
              }
              if (nonEmptyElementsMap[node.nodeName] || isTable$2(node)) {
                return Optional.none();
              }
            }
          }
          if (container.hasChildNodes()) {
            offset = Math.min(!directionLeft && offset > 0 ? offset - 1 : offset, container.childNodes.length - 1);
            container = container.childNodes[offset];
            offset = isText$b(container) && isAfterNode ? container.data.length : 0;
            if (!collapsed && container === body.lastChild && isTable$2(container)) {
              return Optional.none();
            }
            if (hasContentEditableFalseParent(body, container) || isCaretContainer$2(container)) {
              return Optional.none();
            }
            if (isDetails(container)) {
              return Optional.none();
            }
            if (container.hasChildNodes() && !isTable$2(container)) {
              node = container;
              const walker = new DomTreeWalker(container, body);
              do {
                if (isContentEditableFalse$b(node) || isCaretContainer$2(node)) {
                  normalized = false;
                  break;
                }
                if (isText$b(node) && node.data.length > 0) {
                  offset = directionLeft ? 0 : node.data.length;
                  container = node;
                  normalized = true;
                  break;
                }
                if (nonEmptyElementsMap[node.nodeName.toLowerCase()] && !isTableCellOrCaption(node)) {
                  offset = dom2.nodeIndex(node);
                  container = node.parentNode;
                  if (!directionLeft) {
                    offset++;
                  }
                  normalized = true;
                  break;
                }
              } while (node = directionLeft ? walker.next() : walker.prev());
            }
          }
        }
        if (collapsed) {
          if (isText$b(container) && offset === 0) {
            findTextNodeRelative(dom2, isAfterNode, collapsed, true, container).each((pos) => {
              container = pos.container();
              offset = pos.offset();
              normalized = true;
            });
          }
          if (isElement$6(container)) {
            node = container.childNodes[offset];
            if (!node) {
              node = container.childNodes[offset - 1];
            }
            if (node && isBr$6(node) && !isPrevNode(node, "A") && !hasBrBeforeAfter(dom2, node, false) && !hasBrBeforeAfter(dom2, node, true)) {
              findTextNodeRelative(dom2, isAfterNode, collapsed, true, node).each((pos) => {
                container = pos.container();
                offset = pos.offset();
                normalized = true;
              });
            }
          }
        }
        if (directionLeft && !collapsed && isText$b(container) && offset === container.data.length) {
          findTextNodeRelative(dom2, isAfterNode, collapsed, false, container).each((pos) => {
            container = pos.container();
            offset = pos.offset();
            normalized = true;
          });
        }
        return normalized && container ? Optional.some(CaretPosition(container, offset)) : Optional.none();
      };
      const normalize$2 = (dom2, rng) => {
        const collapsed = rng.collapsed, normRng = rng.cloneRange();
        const startPos = CaretPosition.fromRangeStart(rng);
        normalizeEndPoint(dom2, collapsed, true, normRng).each((pos) => {
          if (!collapsed || !CaretPosition.isAbove(startPos, pos)) {
            normRng.setStart(pos.container(), pos.offset());
          }
        });
        if (!collapsed) {
          normalizeEndPoint(dom2, collapsed, false, normRng).each((pos) => {
            normRng.setEnd(pos.container(), pos.offset());
          });
        }
        if (collapsed) {
          normRng.collapse(true);
        }
        return isEq$4(rng, normRng) ? Optional.none() : Optional.some(normRng);
      };
      const splitText = (node, offset) => {
        return node.splitText(offset);
      };
      const split = (rng) => {
        let startContainer = rng.startContainer, startOffset = rng.startOffset, endContainer = rng.endContainer, endOffset = rng.endOffset;
        if (startContainer === endContainer && isText$b(startContainer)) {
          if (startOffset > 0 && startOffset < startContainer.data.length) {
            endContainer = splitText(startContainer, startOffset);
            startContainer = endContainer.previousSibling;
            if (endOffset > startOffset) {
              endOffset = endOffset - startOffset;
              const newContainer = splitText(endContainer, endOffset).previousSibling;
              startContainer = endContainer = newContainer;
              endOffset = newContainer.data.length;
              startOffset = 0;
            } else {
              endOffset = 0;
            }
          }
        } else {
          if (isText$b(startContainer) && startOffset > 0 && startOffset < startContainer.data.length) {
            startContainer = splitText(startContainer, startOffset);
            startOffset = 0;
          }
          if (isText$b(endContainer) && endOffset > 0 && endOffset < endContainer.data.length) {
            const newContainer = splitText(endContainer, endOffset).previousSibling;
            endContainer = newContainer;
            endOffset = newContainer.data.length;
          }
        }
        return {
          startContainer,
          startOffset,
          endContainer,
          endOffset
        };
      };
      const RangeUtils = (dom2) => {
        const walk2 = (rng, callback) => {
          return walk$3(dom2, rng, callback);
        };
        const split$12 = split;
        const normalize2 = (rng) => {
          return normalize$2(dom2, rng).fold(never, (normalizedRng) => {
            rng.setStart(normalizedRng.startContainer, normalizedRng.startOffset);
            rng.setEnd(normalizedRng.endContainer, normalizedRng.endOffset);
            return true;
          });
        };
        const expand = (rng, options = { type: "word" }) => {
          if (options.type === "word") {
            const rangeLike = expandRng(dom2, rng, [{ inline: "span" }], {
              includeTrailingSpace: false,
              expandToBlock: false
            });
            const newRange = dom2.createRng();
            newRange.setStart(rangeLike.startContainer, rangeLike.startOffset);
            newRange.setEnd(rangeLike.endContainer, rangeLike.endOffset);
            return newRange;
          }
          return rng;
        };
        return {
          walk: walk2,
          split: split$12,
          expand,
          normalize: normalize2
        };
      };
      RangeUtils.compareRanges = isEq$4;
      RangeUtils.getCaretRangeFromPoint = fromPoint;
      RangeUtils.getSelectedNode = getSelectedNode;
      RangeUtils.getNode = getNode$1;
      const Dimension = (name2, getOffset) => {
        const set2 = (element, h) => {
          if (!isNumber(h) && !h.match(/^[0-9]+$/)) {
            throw new Error(name2 + ".set accepts only positive integer values. Value was " + h);
          }
          const dom2 = element.dom;
          if (isSupported(dom2)) {
            dom2.style[name2] = h + "px";
          }
        };
        const get2 = (element) => {
          const r2 = getOffset(element);
          if (r2 <= 0 || r2 === null) {
            const css = get$7(element, name2);
            return parseFloat(css) || 0;
          }
          return r2;
        };
        const getOuter2 = get2;
        const aggregate = (element, properties) => foldl(properties, (acc, property) => {
          const val = get$7(element, property);
          const value2 = val === void 0 ? 0 : parseInt(val, 10);
          return isNaN(value2) ? acc : acc + value2;
        }, 0);
        const max2 = (element, value2, properties) => {
          const cumulativeInclusions = aggregate(element, properties);
          const absoluteMax = value2 > cumulativeInclusions ? value2 - cumulativeInclusions : 0;
          return absoluteMax;
        };
        return {
          set: set2,
          get: get2,
          getOuter: getOuter2,
          aggregate,
          max: max2
        };
      };
      const api = Dimension("height", (element) => {
        const dom2 = element.dom;
        return inBody(element) ? dom2.getBoundingClientRect().height : dom2.offsetHeight;
      });
      const get$2 = (element) => api.get(element);
      const walkUp = (navigation, doc) => {
        const frame = navigation.view(doc);
        return frame.fold(constant([]), (f) => {
          const parent2 = navigation.owner(f);
          const rest = walkUp(navigation, parent2);
          return [f].concat(rest);
        });
      };
      const pathTo = (element, navigation) => {
        const d = navigation.owner(element);
        return walkUp(navigation, d);
      };
      const view = (doc) => {
        var _a;
        const element = doc.dom === document ? Optional.none() : Optional.from((_a = doc.dom.defaultView) === null || _a === void 0 ? void 0 : _a.frameElement);
        return element.map(SugarElement.fromDom);
      };
      const owner = (element) => documentOrOwner(element);
      var Navigation = Object.freeze({
        __proto__: null,
        view,
        owner
      });
      const find = (element) => {
        const doc = getDocument();
        const scroll = get$5(doc);
        const frames = pathTo(element, Navigation);
        const offset = viewport(element);
        const r2 = foldr(frames, (b, a) => {
          const loc = viewport(a);
          return {
            left: b.left + loc.left,
            top: b.top + loc.top
          };
        }, {
          left: 0,
          top: 0
        });
        return SugarPosition(r2.left + offset.left + scroll.left, r2.top + offset.top + scroll.top);
      };
      const excludeFromDescend = (element) => name(element) === "textarea";
      const fireScrollIntoViewEvent = (editor, data2) => {
        const scrollEvent = editor.dispatch("ScrollIntoView", data2);
        return scrollEvent.isDefaultPrevented();
      };
      const fireAfterScrollIntoViewEvent = (editor, data2) => {
        editor.dispatch("AfterScrollIntoView", data2);
      };
      const descend = (element, offset) => {
        const children2 = children$1(element);
        if (children2.length === 0 || excludeFromDescend(element)) {
          return {
            element,
            offset
          };
        } else if (offset < children2.length && !excludeFromDescend(children2[offset])) {
          return {
            element: children2[offset],
            offset: 0
          };
        } else {
          const last2 = children2[children2.length - 1];
          if (excludeFromDescend(last2)) {
            return {
              element,
              offset
            };
          } else {
            if (name(last2) === "img") {
              return {
                element: last2,
                offset: 1
              };
            } else if (isText$c(last2)) {
              return {
                element: last2,
                offset: get$3(last2).length
              };
            } else {
              return {
                element: last2,
                offset: children$1(last2).length
              };
            }
          }
        }
      };
      const markerInfo = (element, cleanupFun) => {
        const pos = absolute(element);
        const height = get$2(element);
        return {
          element,
          bottom: pos.top + height,
          height,
          pos,
          cleanup: cleanupFun
        };
      };
      const createMarker$1 = (element, offset) => {
        const startPoint = descend(element, offset);
        const span = SugarElement.fromHtml('<span data-mce-bogus="all" style="display: inline-block;">' + ZWSP$1 + "</span>");
        before$3(startPoint.element, span);
        return markerInfo(span, () => remove$4(span));
      };
      const elementMarker = (element) => markerInfo(SugarElement.fromDom(element), noop);
      const withMarker = (editor, f, rng, alignToTop) => {
        preserveWith(editor, (_s, _e) => applyWithMarker(editor, f, rng, alignToTop), rng);
      };
      const withScrollEvents = (editor, doc, f, marker, alignToTop) => {
        const data2 = {
          elm: marker.element.dom,
          alignToTop
        };
        if (fireScrollIntoViewEvent(editor, data2)) {
          return;
        }
        const scrollTop = get$5(doc).top;
        f(editor, doc, scrollTop, marker, alignToTop);
        fireAfterScrollIntoViewEvent(editor, data2);
      };
      const applyWithMarker = (editor, f, rng, alignToTop) => {
        const body = SugarElement.fromDom(editor.getBody());
        const doc = SugarElement.fromDom(editor.getDoc());
        reflow(body);
        const marker = createMarker$1(SugarElement.fromDom(rng.startContainer), rng.startOffset);
        withScrollEvents(editor, doc, f, marker, alignToTop);
        marker.cleanup();
      };
      const withElement = (editor, element, f, alignToTop) => {
        const doc = SugarElement.fromDom(editor.getDoc());
        withScrollEvents(editor, doc, f, elementMarker(element), alignToTop);
      };
      const preserveWith = (editor, f, rng) => {
        const startElement = rng.startContainer;
        const startOffset = rng.startOffset;
        const endElement = rng.endContainer;
        const endOffset = rng.endOffset;
        f(SugarElement.fromDom(startElement), SugarElement.fromDom(endElement));
        const newRng = editor.dom.createRng();
        newRng.setStart(startElement, startOffset);
        newRng.setEnd(endElement, endOffset);
        editor.selection.setRng(rng);
      };
      const scrollToMarker = (editor, marker, viewHeight, alignToTop, doc) => {
        const pos = marker.pos;
        const scrollMargin = 30;
        if (alignToTop) {
          to(pos.left, Math.max(0, pos.top - scrollMargin), doc);
        } else {
          const y = pos.top - viewHeight + marker.height + scrollMargin;
          to(-editor.getBody().getBoundingClientRect().left, y, doc);
        }
      };
      const intoWindowIfNeeded = (editor, doc, scrollTop, viewHeight, marker, alignToTop) => {
        const viewportBottom = viewHeight + scrollTop;
        const markerTop = marker.pos.top;
        const markerBottom = marker.bottom;
        const largerThanViewport = markerBottom - markerTop >= viewHeight;
        if (markerTop < scrollTop) {
          scrollToMarker(editor, marker, viewHeight, alignToTop !== false, doc);
        } else if (markerTop > viewportBottom) {
          const align = largerThanViewport ? alignToTop !== false : alignToTop === true;
          scrollToMarker(editor, marker, viewHeight, align, doc);
        } else if (markerBottom > viewportBottom && !largerThanViewport) {
          scrollToMarker(editor, marker, viewHeight, alignToTop === true, doc);
        }
      };
      const intoWindow = (editor, doc, scrollTop, marker, alignToTop) => {
        const viewHeight = defaultView(doc).dom.innerHeight;
        intoWindowIfNeeded(editor, doc, scrollTop, viewHeight, marker, alignToTop);
      };
      const intoFrame = (editor, doc, scrollTop, marker, alignToTop) => {
        const frameViewHeight = defaultView(doc).dom.innerHeight;
        intoWindowIfNeeded(editor, doc, scrollTop, frameViewHeight, marker, alignToTop);
        const op = find(marker.element);
        const viewportBounds = getBounds(window);
        if (op.top < viewportBounds.y) {
          intoView(marker.element, alignToTop !== false);
        } else if (op.top > viewportBounds.bottom) {
          intoView(marker.element, alignToTop === true);
        }
      };
      const rangeIntoWindow = (editor, rng, alignToTop) => withMarker(editor, intoWindow, rng, alignToTop);
      const elementIntoWindow = (editor, element, alignToTop) => withElement(editor, element, intoWindow, alignToTop);
      const rangeIntoFrame = (editor, rng, alignToTop) => withMarker(editor, intoFrame, rng, alignToTop);
      const elementIntoFrame = (editor, element, alignToTop) => withElement(editor, element, intoFrame, alignToTop);
      const scrollElementIntoView = (editor, element, alignToTop) => {
        const scroller = editor.inline ? elementIntoWindow : elementIntoFrame;
        scroller(editor, element, alignToTop);
      };
      const scrollRangeIntoView = (editor, rng, alignToTop) => {
        const scroller = editor.inline ? rangeIntoWindow : rangeIntoFrame;
        scroller(editor, rng, alignToTop);
      };
      const isEditableRange = (dom2, rng) => {
        if (rng.collapsed) {
          return dom2.isEditable(rng.startContainer);
        } else {
          return dom2.isEditable(rng.startContainer) && dom2.isEditable(rng.endContainer);
        }
      };
      const getEndpointElement = (root, rng, start2, real, resolve2) => {
        const container = start2 ? rng.startContainer : rng.endContainer;
        const offset = start2 ? rng.startOffset : rng.endOffset;
        return Optional.from(container).map(SugarElement.fromDom).map((elm) => !real || !rng.collapsed ? child$1(elm, resolve2(elm, offset)).getOr(elm) : elm).bind((elm) => isElement$7(elm) ? Optional.some(elm) : parent(elm).filter(isElement$7)).map((elm) => elm.dom).getOr(root);
      };
      const getStart = (root, rng, real = false) => getEndpointElement(root, rng, true, real, (elm, offset) => Math.min(childNodesCount(elm), offset));
      const getEnd = (root, rng, real = false) => getEndpointElement(root, rng, false, real, (elm, offset) => offset > 0 ? offset - 1 : offset);
      const skipEmptyTextNodes = (node, forwards) => {
        const orig = node;
        while (node && isText$b(node) && node.length === 0) {
          node = forwards ? node.nextSibling : node.previousSibling;
        }
        return node || orig;
      };
      const getNode = (root, rng) => {
        if (!rng) {
          return root;
        }
        let startContainer = rng.startContainer;
        let endContainer = rng.endContainer;
        const startOffset = rng.startOffset;
        const endOffset = rng.endOffset;
        let node = rng.commonAncestorContainer;
        if (!rng.collapsed) {
          if (startContainer === endContainer) {
            if (endOffset - startOffset < 2) {
              if (startContainer.hasChildNodes()) {
                node = startContainer.childNodes[startOffset];
              }
            }
          }
          if (isText$b(startContainer) && isText$b(endContainer)) {
            if (startContainer.length === startOffset) {
              startContainer = skipEmptyTextNodes(startContainer.nextSibling, true);
            } else {
              startContainer = startContainer.parentNode;
            }
            if (endOffset === 0) {
              endContainer = skipEmptyTextNodes(endContainer.previousSibling, false);
            } else {
              endContainer = endContainer.parentNode;
            }
            if (startContainer && startContainer === endContainer) {
              node = startContainer;
            }
          }
        }
        const elm = isText$b(node) ? node.parentNode : node;
        return isHTMLElement(elm) ? elm : root;
      };
      const getSelectedBlocks = (dom2, rng, startElm, endElm) => {
        const selectedBlocks = [];
        const root = dom2.getRoot();
        const start2 = dom2.getParent(startElm || getStart(root, rng, rng.collapsed), dom2.isBlock);
        const end2 = dom2.getParent(endElm || getEnd(root, rng, rng.collapsed), dom2.isBlock);
        if (start2 && start2 !== root) {
          selectedBlocks.push(start2);
        }
        if (start2 && end2 && start2 !== end2) {
          let node;
          const walker = new DomTreeWalker(start2, root);
          while ((node = walker.next()) && node !== end2) {
            if (dom2.isBlock(node)) {
              selectedBlocks.push(node);
            }
          }
        }
        if (end2 && start2 !== end2 && end2 !== root) {
          selectedBlocks.push(end2);
        }
        return selectedBlocks;
      };
      const select = (dom2, node, content) => Optional.from(node).bind((node2) => Optional.from(node2.parentNode).map((parent2) => {
        const idx = dom2.nodeIndex(node2);
        const rng = dom2.createRng();
        rng.setStart(parent2, idx);
        rng.setEnd(parent2, idx + 1);
        if (content) {
          moveEndPoint(dom2, rng, node2, true);
          moveEndPoint(dom2, rng, node2, false);
        }
        return rng;
      }));
      const processRanges = (editor, ranges) => map$3(ranges, (range2) => {
        const evt = editor.dispatch("GetSelectionRange", { range: range2 });
        return evt.range !== range2 ? evt.range : range2;
      });
      const typeLookup = {
        "#text": 3,
        "#comment": 8,
        "#cdata": 4,
        "#pi": 7,
        "#doctype": 10,
        "#document-fragment": 11
      };
      const walk$2 = (node, root, prev2) => {
        const startName = prev2 ? "lastChild" : "firstChild";
        const siblingName = prev2 ? "prev" : "next";
        if (node[startName]) {
          return node[startName];
        }
        if (node !== root) {
          let sibling2 = node[siblingName];
          if (sibling2) {
            return sibling2;
          }
          for (let parent2 = node.parent; parent2 && parent2 !== root; parent2 = parent2.parent) {
            sibling2 = parent2[siblingName];
            if (sibling2) {
              return sibling2;
            }
          }
        }
        return void 0;
      };
      const isEmptyTextNode = (node) => {
        var _a;
        const text2 = (_a = node.value) !== null && _a !== void 0 ? _a : "";
        if (!isWhitespaceText(text2)) {
          return false;
        }
        const parentNode = node.parent;
        if (parentNode && (parentNode.name !== "span" || parentNode.attr("style")) && /^[ ]+$/.test(text2)) {
          return false;
        }
        return true;
      };
      const isNonEmptyElement = (node) => {
        const isNamedAnchor2 = node.name === "a" && !node.attr("href") && node.attr("id");
        return node.attr("name") || node.attr("id") && !node.firstChild || node.attr("data-mce-bookmark") || isNamedAnchor2;
      };
      class AstNode {
        static create(name2, attrs) {
          const node = new AstNode(name2, typeLookup[name2] || 1);
          if (attrs) {
            each$d(attrs, (value2, attrName) => {
              node.attr(attrName, value2);
            });
          }
          return node;
        }
        constructor(name2, type2) {
          this.name = name2;
          this.type = type2;
          if (type2 === 1) {
            this.attributes = [];
            this.attributes.map = {};
          }
        }
        replace(node) {
          const self = this;
          if (node.parent) {
            node.remove();
          }
          self.insert(node, self);
          self.remove();
          return self;
        }
        attr(name2, value2) {
          const self = this;
          if (!isString(name2)) {
            if (isNonNullable(name2)) {
              each$d(name2, (value3, key) => {
                self.attr(key, value3);
              });
            }
            return self;
          }
          const attrs = self.attributes;
          if (attrs) {
            if (value2 !== void 0) {
              if (value2 === null) {
                if (name2 in attrs.map) {
                  delete attrs.map[name2];
                  let i = attrs.length;
                  while (i--) {
                    if (attrs[i].name === name2) {
                      attrs.splice(i, 1);
                      return self;
                    }
                  }
                }
                return self;
              }
              if (name2 in attrs.map) {
                let i = attrs.length;
                while (i--) {
                  if (attrs[i].name === name2) {
                    attrs[i].value = value2;
                    break;
                  }
                }
              } else {
                attrs.push({
                  name: name2,
                  value: value2
                });
              }
              attrs.map[name2] = value2;
              return self;
            }
            return attrs.map[name2];
          }
          return void 0;
        }
        clone() {
          const self = this;
          const clone2 = new AstNode(self.name, self.type);
          const selfAttrs = self.attributes;
          if (selfAttrs) {
            const cloneAttrs = [];
            cloneAttrs.map = {};
            for (let i = 0, l = selfAttrs.length; i < l; i++) {
              const selfAttr = selfAttrs[i];
              if (selfAttr.name !== "id") {
                cloneAttrs[cloneAttrs.length] = {
                  name: selfAttr.name,
                  value: selfAttr.value
                };
                cloneAttrs.map[selfAttr.name] = selfAttr.value;
              }
            }
            clone2.attributes = cloneAttrs;
          }
          clone2.value = self.value;
          return clone2;
        }
        wrap(wrapper) {
          const self = this;
          if (self.parent) {
            self.parent.insert(wrapper, self);
            wrapper.append(self);
          }
          return self;
        }
        unwrap() {
          const self = this;
          for (let node = self.firstChild; node; ) {
            const next2 = node.next;
            self.insert(node, self, true);
            node = next2;
          }
          self.remove();
        }
        remove() {
          const self = this, parent2 = self.parent, next2 = self.next, prev2 = self.prev;
          if (parent2) {
            if (parent2.firstChild === self) {
              parent2.firstChild = next2;
              if (next2) {
                next2.prev = null;
              }
            } else if (prev2) {
              prev2.next = next2;
            }
            if (parent2.lastChild === self) {
              parent2.lastChild = prev2;
              if (prev2) {
                prev2.next = null;
              }
            } else if (next2) {
              next2.prev = prev2;
            }
            self.parent = self.next = self.prev = null;
          }
          return self;
        }
        append(node) {
          const self = this;
          if (node.parent) {
            node.remove();
          }
          const last2 = self.lastChild;
          if (last2) {
            last2.next = node;
            node.prev = last2;
            self.lastChild = node;
          } else {
            self.lastChild = self.firstChild = node;
          }
          node.parent = self;
          return node;
        }
        insert(node, refNode, before2) {
          if (node.parent) {
            node.remove();
          }
          const parent2 = refNode.parent || this;
          if (before2) {
            if (refNode === parent2.firstChild) {
              parent2.firstChild = node;
            } else if (refNode.prev) {
              refNode.prev.next = node;
            }
            node.prev = refNode.prev;
            node.next = refNode;
            refNode.prev = node;
          } else {
            if (refNode === parent2.lastChild) {
              parent2.lastChild = node;
            } else if (refNode.next) {
              refNode.next.prev = node;
            }
            node.next = refNode.next;
            node.prev = refNode;
            refNode.next = node;
          }
          node.parent = parent2;
          return node;
        }
        getAll(name2) {
          const self = this;
          const collection = [];
          for (let node = self.firstChild; node; node = walk$2(node, self)) {
            if (node.name === name2) {
              collection.push(node);
            }
          }
          return collection;
        }
        children() {
          const self = this;
          const collection = [];
          for (let node = self.firstChild; node; node = node.next) {
            collection.push(node);
          }
          return collection;
        }
        empty() {
          const self = this;
          if (self.firstChild) {
            const nodes = [];
            for (let node = self.firstChild; node; node = walk$2(node, self)) {
              nodes.push(node);
            }
            let i = nodes.length;
            while (i--) {
              const node = nodes[i];
              node.parent = node.firstChild = node.lastChild = node.next = node.prev = null;
            }
          }
          self.firstChild = self.lastChild = null;
          return self;
        }
        isEmpty(elements, whitespace = {}, predicate) {
          var _a;
          const self = this;
          let node = self.firstChild;
          if (isNonEmptyElement(self)) {
            return false;
          }
          if (node) {
            do {
              if (node.type === 1) {
                if (node.attr("data-mce-bogus")) {
                  continue;
                }
                if (elements[node.name]) {
                  return false;
                }
                if (isNonEmptyElement(node)) {
                  return false;
                }
              }
              if (node.type === 8) {
                return false;
              }
              if (node.type === 3 && !isEmptyTextNode(node)) {
                return false;
              }
              if (node.type === 3 && node.parent && whitespace[node.parent.name] && isWhitespaceText((_a = node.value) !== null && _a !== void 0 ? _a : "")) {
                return false;
              }
              if (predicate && predicate(node)) {
                return false;
              }
            } while (node = walk$2(node, self));
          }
          return true;
        }
        walk(prev2) {
          return walk$2(this, null, prev2);
        }
      }
      const unescapedTextParents = Tools.makeMap("NOSCRIPT STYLE SCRIPT XMP IFRAME NOEMBED NOFRAMES PLAINTEXT", " ");
      const containsZwsp = (node) => isString(node.nodeValue) && node.nodeValue.includes(ZWSP$1);
      const getTemporaryNodeSelector = (tempAttrs) => `${tempAttrs.length === 0 ? "" : `${map$3(tempAttrs, (attr) => `[${attr}]`).join(",")},`}[data-mce-bogus="all"]`;
      const getTemporaryNodes = (tempAttrs, body) => body.querySelectorAll(getTemporaryNodeSelector(tempAttrs));
      const createZwspCommentWalker = (body) => document.createTreeWalker(body, NodeFilter.SHOW_COMMENT, (node) => containsZwsp(node) ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP);
      const createUnescapedZwspTextWalker = (body) => document.createTreeWalker(body, NodeFilter.SHOW_TEXT, (node) => {
        if (containsZwsp(node)) {
          const parent2 = node.parentNode;
          return parent2 && has$2(unescapedTextParents, parent2.nodeName) ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
        } else {
          return NodeFilter.FILTER_SKIP;
        }
      });
      const hasZwspComment = (body) => createZwspCommentWalker(body).nextNode() !== null;
      const hasUnescapedZwspText = (body) => createUnescapedZwspTextWalker(body).nextNode() !== null;
      const hasTemporaryNode = (tempAttrs, body) => body.querySelector(getTemporaryNodeSelector(tempAttrs)) !== null;
      const trimTemporaryNodes = (tempAttrs, body) => {
        each$e(getTemporaryNodes(tempAttrs, body), (elm) => {
          const element = SugarElement.fromDom(elm);
          if (get$9(element, "data-mce-bogus") === "all") {
            remove$4(element);
          } else {
            each$e(tempAttrs, (attr) => {
              if (has$1(element, attr)) {
                remove$9(element, attr);
              }
            });
          }
        });
      };
      const emptyAllNodeValuesInWalker = (walker) => {
        let curr = walker.nextNode();
        while (curr !== null) {
          curr.nodeValue = null;
          curr = walker.nextNode();
        }
      };
      const emptyZwspComments = compose(emptyAllNodeValuesInWalker, createZwspCommentWalker);
      const emptyUnescapedZwspTexts = compose(emptyAllNodeValuesInWalker, createUnescapedZwspTextWalker);
      const trim$1 = (body, tempAttrs) => {
        const conditionalTrims = [
          {
            condition: curry(hasTemporaryNode, tempAttrs),
            action: curry(trimTemporaryNodes, tempAttrs)
          },
          {
            condition: hasZwspComment,
            action: emptyZwspComments
          },
          {
            condition: hasUnescapedZwspText,
            action: emptyUnescapedZwspTexts
          }
        ];
        let trimmed = body;
        let cloned = false;
        each$e(conditionalTrims, ({ condition, action: action2 }) => {
          if (condition(trimmed)) {
            if (!cloned) {
              trimmed = body.cloneNode(true);
              cloned = true;
            }
            action2(trimmed);
          }
        });
        return trimmed;
      };
      const cleanupBogusElements = (parent2) => {
        const bogusElements = descendants(parent2, "[data-mce-bogus]");
        each$e(bogusElements, (elem) => {
          const bogusValue = get$9(elem, "data-mce-bogus");
          if (bogusValue === "all") {
            remove$4(elem);
          } else if (isBr$5(elem)) {
            before$3(elem, SugarElement.fromText(zeroWidth));
            remove$4(elem);
          } else {
            unwrap(elem);
          }
        });
      };
      const cleanupInputNames = (parent2) => {
        const inputs = descendants(parent2, "input");
        each$e(inputs, (input) => {
          remove$9(input, "name");
        });
      };
      const trimEmptyContents = (editor, html2) => {
        const blockName = getForcedRootBlock(editor);
        const emptyRegExp = new RegExp(`^(<${blockName}[^>]*>(&nbsp;|&#160;|\\s| |<br \\/>|)<\\/${blockName}>[\r
]*|<br \\/>[\r
]*)$`);
        return html2.replace(emptyRegExp, "");
      };
      const getPlainTextContent = (editor, body) => {
        const doc = editor.getDoc();
        const dos = getRootNode(SugarElement.fromDom(editor.getBody()));
        const offscreenDiv = SugarElement.fromTag("div", doc);
        set$4(offscreenDiv, "data-mce-bogus", "all");
        setAll(offscreenDiv, {
          position: "fixed",
          left: "-9999999px",
          top: "0"
        });
        set$1(offscreenDiv, body.innerHTML);
        cleanupBogusElements(offscreenDiv);
        cleanupInputNames(offscreenDiv);
        const root = getContentContainer(dos);
        append$1(root, offscreenDiv);
        const content = trim$2(offscreenDiv.dom.innerText);
        remove$4(offscreenDiv);
        return content;
      };
      const getContentFromBody = (editor, args, body) => {
        let content;
        if (args.format === "raw") {
          content = Tools.trim(trim$2(trim$1(body, editor.serializer.getTempAttrs()).innerHTML));
        } else if (args.format === "text") {
          content = getPlainTextContent(editor, body);
        } else if (args.format === "tree") {
          content = editor.serializer.serialize(body, args);
        } else {
          content = trimEmptyContents(editor, editor.serializer.serialize(body, args));
        }
        const shouldTrim = args.format !== "text" && !isWsPreserveElement(SugarElement.fromDom(body));
        return shouldTrim && isString(content) ? Tools.trim(content) : content;
      };
      const getContentInternal = (editor, args) => Optional.from(editor.getBody()).fold(constant(args.format === "tree" ? new AstNode("body", 11) : ""), (body) => getContentFromBody(editor, args, body));
      const makeMap$1 = Tools.makeMap;
      const Writer = (settings) => {
        const html2 = [];
        settings = settings || {};
        const indent2 = settings.indent;
        const indentBefore = makeMap$1(settings.indent_before || "");
        const indentAfter = makeMap$1(settings.indent_after || "");
        const encode = Entities.getEncodeFunc(settings.entity_encoding || "raw", settings.entities);
        const htmlOutput = settings.element_format !== "xhtml";
        return {
          start: (name2, attrs, empty2) => {
            if (indent2 && indentBefore[name2] && html2.length > 0) {
              const value2 = html2[html2.length - 1];
              if (value2.length > 0 && value2 !== "\n") {
                html2.push("\n");
              }
            }
            html2.push("<", name2);
            if (attrs) {
              for (let i = 0, l = attrs.length; i < l; i++) {
                const attr = attrs[i];
                html2.push(" ", attr.name, '="', encode(attr.value, true), '"');
              }
            }
            if (!empty2 || htmlOutput) {
              html2[html2.length] = ">";
            } else {
              html2[html2.length] = " />";
            }
            if (empty2 && indent2 && indentAfter[name2] && html2.length > 0) {
              const value2 = html2[html2.length - 1];
              if (value2.length > 0 && value2 !== "\n") {
                html2.push("\n");
              }
            }
          },
          end: (name2) => {
            let value2;
            html2.push("</", name2, ">");
            if (indent2 && indentAfter[name2] && html2.length > 0) {
              value2 = html2[html2.length - 1];
              if (value2.length > 0 && value2 !== "\n") {
                html2.push("\n");
              }
            }
          },
          text: (text2, raw) => {
            if (text2.length > 0) {
              html2[html2.length] = raw ? text2 : encode(text2);
            }
          },
          cdata: (text2) => {
            html2.push("<![CDATA[", text2, "]]>");
          },
          comment: (text2) => {
            html2.push("<!--", text2, "-->");
          },
          pi: (name2, text2) => {
            if (text2) {
              html2.push("<?", name2, " ", encode(text2), "?>");
            } else {
              html2.push("<?", name2, "?>");
            }
            if (indent2) {
              html2.push("\n");
            }
          },
          doctype: (text2) => {
            html2.push("<!DOCTYPE", text2, ">", indent2 ? "\n" : "");
          },
          reset: () => {
            html2.length = 0;
          },
          getContent: () => {
            return html2.join("").replace(/\n$/, "");
          }
        };
      };
      const HtmlSerializer = (settings = {}, schema = Schema()) => {
        const writer = Writer(settings);
        settings.validate = "validate" in settings ? settings.validate : true;
        const serialize = (node) => {
          const validate2 = settings.validate;
          const handlers = {
            3: (node2) => {
              var _a;
              writer.text((_a = node2.value) !== null && _a !== void 0 ? _a : "", node2.raw);
            },
            8: (node2) => {
              var _a;
              writer.comment((_a = node2.value) !== null && _a !== void 0 ? _a : "");
            },
            7: (node2) => {
              writer.pi(node2.name, node2.value);
            },
            10: (node2) => {
              var _a;
              writer.doctype((_a = node2.value) !== null && _a !== void 0 ? _a : "");
            },
            4: (node2) => {
              var _a;
              writer.cdata((_a = node2.value) !== null && _a !== void 0 ? _a : "");
            },
            11: (node2) => {
              let tempNode = node2;
              if (tempNode = tempNode.firstChild) {
                do {
                  walk2(tempNode);
                } while (tempNode = tempNode.next);
              }
            }
          };
          writer.reset();
          const walk2 = (node2) => {
            var _a;
            const handler = handlers[node2.type];
            if (!handler) {
              const name2 = node2.name;
              const isEmpty2 = name2 in schema.getVoidElements();
              let attrs = node2.attributes;
              if (validate2 && attrs && attrs.length > 1) {
                const sortedAttrs = [];
                sortedAttrs.map = {};
                const elementRule = schema.getElementRule(node2.name);
                if (elementRule) {
                  for (let i = 0, l = elementRule.attributesOrder.length; i < l; i++) {
                    const attrName = elementRule.attributesOrder[i];
                    if (attrName in attrs.map) {
                      const attrValue = attrs.map[attrName];
                      sortedAttrs.map[attrName] = attrValue;
                      sortedAttrs.push({
                        name: attrName,
                        value: attrValue
                      });
                    }
                  }
                  for (let i = 0, l = attrs.length; i < l; i++) {
                    const attrName = attrs[i].name;
                    if (!(attrName in sortedAttrs.map)) {
                      const attrValue = attrs.map[attrName];
                      sortedAttrs.map[attrName] = attrValue;
                      sortedAttrs.push({
                        name: attrName,
                        value: attrValue
                      });
                    }
                  }
                  attrs = sortedAttrs;
                }
              }
              writer.start(name2, attrs, isEmpty2);
              if (isNonHtmlElementRootName(name2)) {
                if (isString(node2.value)) {
                  writer.text(node2.value, true);
                }
                writer.end(name2);
              } else {
                if (!isEmpty2) {
                  let child2 = node2.firstChild;
                  if (child2) {
                    if ((name2 === "pre" || name2 === "textarea") && child2.type === 3 && ((_a = child2.value) === null || _a === void 0 ? void 0 : _a[0]) === "\n") {
                      writer.text("\n", true);
                    }
                    do {
                      walk2(child2);
                    } while (child2 = child2.next);
                  }
                  writer.end(name2);
                }
              }
            } else {
              handler(node2);
            }
          };
          if (node.type === 1 && !settings.inner) {
            walk2(node);
          } else if (node.type === 3) {
            handlers[3](node);
          } else {
            handlers[11](node);
          }
          return writer.getContent();
        };
        return { serialize };
      };
      const nonInheritableStyles = /* @__PURE__ */ new Set();
      (() => {
        const nonInheritableStylesArr = [
          "margin",
          "margin-left",
          "margin-right",
          "margin-top",
          "margin-bottom",
          "padding",
          "padding-left",
          "padding-right",
          "padding-top",
          "padding-bottom",
          "border",
          "border-width",
          "border-style",
          "border-color",
          "background",
          "background-attachment",
          "background-clip",
          "background-image",
          "background-origin",
          "background-position",
          "background-repeat",
          "background-size",
          "float",
          "position",
          "left",
          "right",
          "top",
          "bottom",
          "z-index",
          "display",
          "transform",
          "width",
          "max-width",
          "min-width",
          "height",
          "max-height",
          "min-height",
          "overflow",
          "overflow-x",
          "overflow-y",
          "text-overflow",
          "vertical-align",
          "transition",
          "transition-delay",
          "transition-duration",
          "transition-property",
          "transition-timing-function"
        ];
        each$e(nonInheritableStylesArr, (style) => {
          nonInheritableStyles.add(style);
        });
      })();
      const conditionalNonInheritableStyles = /* @__PURE__ */ new Set();
      (() => {
        const conditionalNonInheritableStylesArr = ["background-color"];
        each$e(conditionalNonInheritableStylesArr, (style) => {
          conditionalNonInheritableStyles.add(style);
        });
      })();
      const shorthandStyleProps = [
        "font",
        "text-decoration",
        "text-emphasis"
      ];
      const getStyles$1 = (dom2, node) => dom2.parseStyle(dom2.getAttrib(node, "style"));
      const getStyleProps = (dom2, node) => keys(getStyles$1(dom2, node));
      const isNonInheritableStyle = (style) => nonInheritableStyles.has(style);
      const isConditionalNonInheritableStyle = (style) => conditionalNonInheritableStyles.has(style);
      const hasNonInheritableStyles = (dom2, node) => exists(getStyleProps(dom2, node), (style) => isNonInheritableStyle(style));
      const hasConditionalNonInheritableStyles = (dom2, node) => hasNonInheritableStyles(dom2, node) && exists(getStyleProps(dom2, node), (style) => isConditionalNonInheritableStyle(style));
      const getLonghandStyleProps = (styles) => filter$5(styles, (style) => exists(shorthandStyleProps, (prop) => startsWith(style, prop)));
      const hasStyleConflict = (dom2, node, parentNode) => {
        const nodeStyleProps = getStyleProps(dom2, node);
        const parentNodeStyleProps = getStyleProps(dom2, parentNode);
        const valueMismatch = (prop) => {
          var _a, _b;
          const nodeValue = (_a = dom2.getStyle(node, prop)) !== null && _a !== void 0 ? _a : "";
          const parentValue = (_b = dom2.getStyle(parentNode, prop)) !== null && _b !== void 0 ? _b : "";
          return isNotEmpty(nodeValue) && isNotEmpty(parentValue) && nodeValue !== parentValue;
        };
        return exists(nodeStyleProps, (nodeStyleProp) => {
          const propExists = (props) => exists(props, (prop) => prop === nodeStyleProp);
          if (!propExists(parentNodeStyleProps) && propExists(shorthandStyleProps)) {
            const longhandProps = getLonghandStyleProps(parentNodeStyleProps);
            return exists(longhandProps, valueMismatch);
          } else {
            return valueMismatch(nodeStyleProp);
          }
        });
      };
      const isChar = (forward, predicate, pos) => Optional.from(pos.container()).filter(isText$b).exists((text2) => {
        const delta = forward ? 0 : -1;
        return predicate(text2.data.charAt(pos.offset() + delta));
      });
      const isBeforeSpace = curry(isChar, true, isWhiteSpace);
      const isAfterSpace = curry(isChar, false, isWhiteSpace);
      const isEmptyText = (pos) => {
        const container = pos.container();
        return isText$b(container) && (container.data.length === 0 || isZwsp(container.data) && BookmarkManager.isBookmarkNode(container.parentNode));
      };
      const matchesElementPosition = (before2, predicate) => (pos) => getChildNodeAtRelativeOffset(before2 ? 0 : -1, pos).filter(predicate).isSome();
      const isImageBlock = (node) => isImg(node) && get$7(SugarElement.fromDom(node), "display") === "block";
      const isCefNode = (node) => isContentEditableFalse$b(node) && !isBogusAll(node);
      const isBeforeImageBlock = matchesElementPosition(true, isImageBlock);
      const isAfterImageBlock = matchesElementPosition(false, isImageBlock);
      const isBeforeMedia = matchesElementPosition(true, isMedia$2);
      const isAfterMedia = matchesElementPosition(false, isMedia$2);
      const isBeforeTable = matchesElementPosition(true, isTable$2);
      const isAfterTable = matchesElementPosition(false, isTable$2);
      const isBeforeContentEditableFalse = matchesElementPosition(true, isCefNode);
      const isAfterContentEditableFalse = matchesElementPosition(false, isCefNode);
      const dropLast = (xs) => xs.slice(0, -1);
      const parentsUntil = (start2, root, predicate) => {
        if (contains(root, start2)) {
          return dropLast(parents$1(start2, (elm) => {
            return predicate(elm) || eq(elm, root);
          }));
        } else {
          return [];
        }
      };
      const parents = (start2, root) => parentsUntil(start2, root, never);
      const parentsAndSelf = (start2, root) => [start2].concat(parents(start2, root));
      const navigateIgnoreEmptyTextNodes = (forward, root, from2) => navigateIgnore(forward, root, from2, isEmptyText);
      const isBlock$1 = (schema) => (el) => schema.isBlock(name(el));
      const getClosestBlock$1 = (root, pos, schema) => find$2(parentsAndSelf(SugarElement.fromDom(pos.container()), root), isBlock$1(schema));
      const isAtBeforeAfterBlockBoundary = (forward, root, pos, schema) => navigateIgnoreEmptyTextNodes(forward, root.dom, pos).forall((newPos) => getClosestBlock$1(root, pos, schema).fold(() => !isInSameBlock(newPos, pos, root.dom), (fromBlock) => !isInSameBlock(newPos, pos, root.dom) && contains(fromBlock, SugarElement.fromDom(newPos.container()))));
      const isAtBlockBoundary = (forward, root, pos, schema) => getClosestBlock$1(root, pos, schema).fold(() => navigateIgnoreEmptyTextNodes(forward, root.dom, pos).forall((newPos) => !isInSameBlock(newPos, pos, root.dom)), (parent2) => navigateIgnoreEmptyTextNodes(forward, parent2.dom, pos).isNone());
      const isAtStartOfBlock = curry(isAtBlockBoundary, false);
      const isAtEndOfBlock = curry(isAtBlockBoundary, true);
      const isBeforeBlock = curry(isAtBeforeAfterBlockBoundary, false);
      const isAfterBlock = curry(isAtBeforeAfterBlockBoundary, true);
      const isBr$1 = (pos) => getElementFromPosition(pos).exists(isBr$5);
      const findBr = (forward, root, pos, schema) => {
        const parentBlocks = filter$5(parentsAndSelf(SugarElement.fromDom(pos.container()), root), (el) => schema.isBlock(name(el)));
        const scope = head(parentBlocks).getOr(root);
        return fromPosition(forward, scope.dom, pos).filter(isBr$1);
      };
      const isBeforeBr$1 = (root, pos, schema) => getElementFromPosition(pos).exists(isBr$5) || findBr(true, root, pos, schema).isSome();
      const isAfterBr = (root, pos, schema) => getElementFromPrevPosition(pos).exists(isBr$5) || findBr(false, root, pos, schema).isSome();
      const findPreviousBr = curry(findBr, false);
      const findNextBr = curry(findBr, true);
      const isInMiddleOfText = (pos) => CaretPosition.isTextPosition(pos) && !pos.isAtStart() && !pos.isAtEnd();
      const getClosestBlock = (root, pos, schema) => {
        const parentBlocks = filter$5(parentsAndSelf(SugarElement.fromDom(pos.container()), root), (el) => schema.isBlock(name(el)));
        return head(parentBlocks).getOr(root);
      };
      const hasSpaceBefore = (root, pos, schema) => {
        if (isInMiddleOfText(pos)) {
          return isAfterSpace(pos);
        } else {
          return isAfterSpace(pos) || prevPosition(getClosestBlock(root, pos, schema).dom, pos).exists(isAfterSpace);
        }
      };
      const hasSpaceAfter = (root, pos, schema) => {
        if (isInMiddleOfText(pos)) {
          return isBeforeSpace(pos);
        } else {
          return isBeforeSpace(pos) || nextPosition(getClosestBlock(root, pos, schema).dom, pos).exists(isBeforeSpace);
        }
      };
      const isPreValue = (value2) => contains$2([
        "pre",
        "pre-wrap"
      ], value2);
      const isInPre = (pos) => getElementFromPosition(pos).bind((elm) => closest$4(elm, isElement$7)).exists((elm) => isPreValue(get$7(elm, "white-space")));
      const isAtBeginningOfBody = (root, pos) => prevPosition(root.dom, pos).isNone();
      const isAtEndOfBody = (root, pos) => nextPosition(root.dom, pos).isNone();
      const isAtLineBoundary = (root, pos, schema) => isAtBeginningOfBody(root, pos) || isAtEndOfBody(root, pos) || isAtStartOfBlock(root, pos, schema) || isAtEndOfBlock(root, pos, schema) || isAfterBr(root, pos, schema) || isBeforeBr$1(root, pos, schema);
      const isCefBlock = (node) => isNonNullable(node) && isContentEditableFalse$b(node) && isBlockLike(node);
      const isSiblingCefBlock = (root, direction) => (container) => {
        return isCefBlock(new DomTreeWalker(container, root)[direction]());
      };
      const isBeforeCefBlock = (root, pos) => {
        const nextPos = nextPosition(root.dom, pos).getOr(pos);
        const isNextCefBlock = isSiblingCefBlock(root.dom, "next");
        return pos.isAtEnd() && (isNextCefBlock(pos.container()) || isNextCefBlock(nextPos.container()));
      };
      const isAfterCefBlock = (root, pos) => {
        const prevPos = prevPosition(root.dom, pos).getOr(pos);
        const isPrevCefBlock = isSiblingCefBlock(root.dom, "prev");
        return pos.isAtStart() && (isPrevCefBlock(pos.container()) || isPrevCefBlock(prevPos.container()));
      };
      const needsToHaveNbsp = (root, pos, schema) => {
        if (isInPre(pos)) {
          return false;
        } else {
          return isAtLineBoundary(root, pos, schema) || hasSpaceBefore(root, pos, schema) || hasSpaceAfter(root, pos, schema);
        }
      };
      const needsToBeNbspLeft = (root, pos, schema) => {
        if (isInPre(pos)) {
          return false;
        } else {
          return isAtStartOfBlock(root, pos, schema) || isBeforeBlock(root, pos, schema) || isAfterBr(root, pos, schema) || hasSpaceBefore(root, pos, schema) || isAfterCefBlock(root, pos);
        }
      };
      const leanRight = (pos) => {
        const container = pos.container();
        const offset = pos.offset();
        if (isText$b(container) && offset < container.data.length) {
          return CaretPosition(container, offset + 1);
        } else {
          return pos;
        }
      };
      const needsToBeNbspRight = (root, pos, schema) => {
        if (isInPre(pos)) {
          return false;
        } else {
          return isAtEndOfBlock(root, pos, schema) || isAfterBlock(root, pos, schema) || isBeforeBr$1(root, pos, schema) || hasSpaceAfter(root, pos, schema) || isBeforeCefBlock(root, pos);
        }
      };
      const needsToBeNbsp = (root, pos, schema) => needsToBeNbspLeft(root, pos, schema) || needsToBeNbspRight(root, leanRight(pos), schema);
      const isNbspAt = (text2, offset) => isNbsp(text2.charAt(offset));
      const isWhiteSpaceAt = (text2, offset) => isWhiteSpace(text2.charAt(offset));
      const hasNbsp = (pos) => {
        const container = pos.container();
        return isText$b(container) && contains$1(container.data, nbsp);
      };
      const normalizeNbspMiddle = (text2) => {
        const chars = text2.split("");
        return map$3(chars, (chr, i) => {
          if (isNbsp(chr) && i > 0 && i < chars.length - 1 && isContent(chars[i - 1]) && isContent(chars[i + 1])) {
            return " ";
          } else {
            return chr;
          }
        }).join("");
      };
      const normalizeNbspAtStart = (root, node, makeNbsp, schema) => {
        const text2 = node.data;
        const firstPos = CaretPosition(node, 0);
        if (!makeNbsp && isNbspAt(text2, 0) && !needsToBeNbsp(root, firstPos, schema)) {
          node.data = " " + text2.slice(1);
          return true;
        } else if (makeNbsp && isWhiteSpaceAt(text2, 0) && needsToBeNbspLeft(root, firstPos, schema)) {
          node.data = nbsp + text2.slice(1);
          return true;
        } else {
          return false;
        }
      };
      const normalizeNbspInMiddleOfTextNode = (node) => {
        const text2 = node.data;
        const newText = normalizeNbspMiddle(text2);
        if (newText !== text2) {
          node.data = newText;
          return true;
        } else {
          return false;
        }
      };
      const normalizeNbspAtEnd = (root, node, makeNbsp, schema) => {
        const text2 = node.data;
        const lastPos = CaretPosition(node, text2.length - 1);
        if (!makeNbsp && isNbspAt(text2, text2.length - 1) && !needsToBeNbsp(root, lastPos, schema)) {
          node.data = text2.slice(0, -1) + " ";
          return true;
        } else if (makeNbsp && isWhiteSpaceAt(text2, text2.length - 1) && needsToBeNbspRight(root, lastPos, schema)) {
          node.data = text2.slice(0, -1) + nbsp;
          return true;
        } else {
          return false;
        }
      };
      const normalizeNbsps$1 = (root, pos, schema) => {
        const container = pos.container();
        if (!isText$b(container)) {
          return Optional.none();
        }
        if (hasNbsp(pos)) {
          const normalized = normalizeNbspAtStart(root, container, false, schema) || normalizeNbspInMiddleOfTextNode(container) || normalizeNbspAtEnd(root, container, false, schema);
          return someIf(normalized, pos);
        } else if (needsToBeNbsp(root, pos, schema)) {
          const normalized = normalizeNbspAtStart(root, container, true, schema) || normalizeNbspAtEnd(root, container, true, schema);
          return someIf(normalized, pos);
        } else {
          return Optional.none();
        }
      };
      const normalizeNbspsInEditor = (editor) => {
        const root = SugarElement.fromDom(editor.getBody());
        if (editor.selection.isCollapsed()) {
          normalizeNbsps$1(root, CaretPosition.fromRangeStart(editor.selection.getRng()), editor.schema).each((pos) => {
            editor.selection.setRng(pos.toRange());
          });
        }
      };
      const normalize$1 = (node, offset, count2, schema) => {
        if (count2 === 0) {
          return;
        }
        const elm = SugarElement.fromDom(node);
        const root = ancestor$4(elm, (el) => schema.isBlock(name(el))).getOr(elm);
        const whitespace = node.data.slice(offset, offset + count2);
        const isEndOfContent = offset + count2 >= node.data.length && needsToBeNbspRight(root, CaretPosition(node, node.data.length), schema);
        const isStartOfContent = offset === 0 && needsToBeNbspLeft(root, CaretPosition(node, 0), schema);
        node.replaceData(offset, count2, normalize$4(whitespace, 4, isStartOfContent, isEndOfContent));
      };
      const normalizeWhitespaceAfter = (node, offset, schema) => {
        const content = node.data.slice(offset);
        const whitespaceCount = content.length - lTrim(content).length;
        normalize$1(node, offset, whitespaceCount, schema);
      };
      const normalizeWhitespaceBefore = (node, offset, schema) => {
        const content = node.data.slice(0, offset);
        const whitespaceCount = content.length - rTrim(content).length;
        normalize$1(node, offset - whitespaceCount, whitespaceCount, schema);
      };
      const mergeTextNodes = (prevNode, nextNode, schema, normalizeWhitespace, mergeToPrev = true) => {
        const whitespaceOffset = rTrim(prevNode.data).length;
        const newNode = mergeToPrev ? prevNode : nextNode;
        const removeNode2 = mergeToPrev ? nextNode : prevNode;
        if (mergeToPrev) {
          newNode.appendData(removeNode2.data);
        } else {
          newNode.insertData(0, removeNode2.data);
        }
        remove$4(SugarElement.fromDom(removeNode2));
        if (normalizeWhitespace) {
          normalizeWhitespaceAfter(newNode, whitespaceOffset, schema);
        }
        return newNode;
      };
      const needsReposition = (pos, elm) => {
        const container = pos.container();
        const offset = pos.offset();
        return !CaretPosition.isTextPosition(pos) && container === elm.parentNode && offset > CaretPosition.before(elm).offset();
      };
      const reposition = (elm, pos) => needsReposition(pos, elm) ? CaretPosition(pos.container(), pos.offset() - 1) : pos;
      const beforeOrStartOf = (node) => isText$b(node) ? CaretPosition(node, 0) : CaretPosition.before(node);
      const afterOrEndOf = (node) => isText$b(node) ? CaretPosition(node, node.data.length) : CaretPosition.after(node);
      const getPreviousSiblingCaretPosition = (elm) => {
        if (isCaretCandidate$3(elm.previousSibling)) {
          return Optional.some(afterOrEndOf(elm.previousSibling));
        } else {
          return elm.previousSibling ? lastPositionIn(elm.previousSibling) : Optional.none();
        }
      };
      const getNextSiblingCaretPosition = (elm) => {
        if (isCaretCandidate$3(elm.nextSibling)) {
          return Optional.some(beforeOrStartOf(elm.nextSibling));
        } else {
          return elm.nextSibling ? firstPositionIn(elm.nextSibling) : Optional.none();
        }
      };
      const findCaretPositionBackwardsFromElm = (rootElement, elm) => {
        return Optional.from(elm.previousSibling ? elm.previousSibling : elm.parentNode).bind((node) => prevPosition(rootElement, CaretPosition.before(node))).orThunk(() => nextPosition(rootElement, CaretPosition.after(elm)));
      };
      const findCaretPositionForwardsFromElm = (rootElement, elm) => nextPosition(rootElement, CaretPosition.after(elm)).orThunk(() => prevPosition(rootElement, CaretPosition.before(elm)));
      const findCaretPositionBackwards = (rootElement, elm) => getPreviousSiblingCaretPosition(elm).orThunk(() => getNextSiblingCaretPosition(elm)).orThunk(() => findCaretPositionBackwardsFromElm(rootElement, elm));
      const findCaretPositionForward = (rootElement, elm) => getNextSiblingCaretPosition(elm).orThunk(() => getPreviousSiblingCaretPosition(elm)).orThunk(() => findCaretPositionForwardsFromElm(rootElement, elm));
      const findCaretPosition = (forward, rootElement, elm) => forward ? findCaretPositionForward(rootElement, elm) : findCaretPositionBackwards(rootElement, elm);
      const findCaretPosOutsideElmAfterDelete = (forward, rootElement, elm) => findCaretPosition(forward, rootElement, elm).map(curry(reposition, elm));
      const setSelection$1 = (editor, forward, pos) => {
        pos.fold(() => {
          editor.focus();
        }, (pos2) => {
          editor.selection.setRng(pos2.toRange(), forward);
        });
      };
      const eqRawNode = (rawNode) => (elm) => elm.dom === rawNode;
      const isBlock = (editor, elm) => elm && has$2(editor.schema.getBlockElements(), name(elm));
      const paddEmptyBlock = (schema, elm, preserveEmptyCaret) => {
        if (isEmpty$2(schema, elm)) {
          const br = SugarElement.fromHtml('<br data-mce-bogus="1">');
          if (preserveEmptyCaret) {
            each$e(children$1(elm), (node) => {
              if (!isEmptyCaretFormatElement(node)) {
                remove$4(node);
              }
            });
          } else {
            empty(elm);
          }
          append$1(elm, br);
          return Optional.some(CaretPosition.before(br.dom));
        } else {
          return Optional.none();
        }
      };
      const deleteNormalized = (elm, afterDeletePosOpt, schema, normalizeWhitespace) => {
        const prevTextOpt = prevSibling(elm).filter(isText$c);
        const nextTextOpt = nextSibling(elm).filter(isText$c);
        remove$4(elm);
        return lift3(prevTextOpt, nextTextOpt, afterDeletePosOpt, (prev2, next2, pos) => {
          const prevNode = prev2.dom, nextNode = next2.dom;
          const offset = prevNode.data.length;
          mergeTextNodes(prevNode, nextNode, schema, normalizeWhitespace);
          return pos.container() === nextNode ? CaretPosition(prevNode, offset) : pos;
        }).orThunk(() => {
          if (normalizeWhitespace) {
            prevTextOpt.each((elm2) => normalizeWhitespaceBefore(elm2.dom, elm2.dom.length, schema));
            nextTextOpt.each((elm2) => normalizeWhitespaceAfter(elm2.dom, 0, schema));
          }
          return afterDeletePosOpt;
        });
      };
      const isInlineElement = (editor, element) => has$2(editor.schema.getTextInlineElements(), name(element));
      const deleteElement$2 = (editor, forward, elm, moveCaret2 = true, preserveEmptyCaret = false) => {
        const afterDeletePos = findCaretPosOutsideElmAfterDelete(forward, editor.getBody(), elm.dom);
        const parentBlock = ancestor$4(elm, curry(isBlock, editor), eqRawNode(editor.getBody()));
        const normalizedAfterDeletePos = deleteNormalized(elm, afterDeletePos, editor.schema, isInlineElement(editor, elm));
        if (editor.dom.isEmpty(editor.getBody())) {
          editor.setContent("");
          editor.selection.setCursorLocation();
        } else {
          parentBlock.bind((elm2) => paddEmptyBlock(editor.schema, elm2, preserveEmptyCaret)).fold(() => {
            if (moveCaret2) {
              setSelection$1(editor, forward, normalizedAfterDeletePos);
            }
          }, (paddPos) => {
            if (moveCaret2) {
              setSelection$1(editor, forward, Optional.some(paddPos));
            }
          });
        }
      };
      const strongRtl = /[\u0591-\u07FF\uFB1D-\uFDFF\uFE70-\uFEFC]/;
      const hasStrongRtl = (text2) => strongRtl.test(text2);
      const isInlineTarget = (editor, elm) => is$1(SugarElement.fromDom(elm), getInlineBoundarySelector(editor)) && !isTransparentBlock(editor.schema, elm) && editor.dom.isEditable(elm);
      const isRtl = (element) => {
        var _a;
        return DOMUtils.DOM.getStyle(element, "direction", true) === "rtl" || hasStrongRtl((_a = element.textContent) !== null && _a !== void 0 ? _a : "");
      };
      const findInlineParents = (isInlineTarget2, rootNode, pos) => filter$5(DOMUtils.DOM.getParents(pos.container(), "*", rootNode), isInlineTarget2);
      const findRootInline = (isInlineTarget2, rootNode, pos) => {
        const parents2 = findInlineParents(isInlineTarget2, rootNode, pos);
        return Optional.from(parents2[parents2.length - 1]);
      };
      const hasSameParentBlock = (rootNode, node1, node2) => {
        const block1 = getParentBlock$3(node1, rootNode);
        const block2 = getParentBlock$3(node2, rootNode);
        return isNonNullable(block1) && block1 === block2;
      };
      const isAtZwsp = (pos) => isBeforeInline(pos) || isAfterInline(pos);
      const normalizePosition = (forward, pos) => {
        const container = pos.container(), offset = pos.offset();
        if (forward) {
          if (isCaretContainerInline(container)) {
            if (isText$b(container.nextSibling)) {
              return CaretPosition(container.nextSibling, 0);
            } else {
              return CaretPosition.after(container);
            }
          } else {
            return isBeforeInline(pos) ? CaretPosition(container, offset + 1) : pos;
          }
        } else {
          if (isCaretContainerInline(container)) {
            if (isText$b(container.previousSibling)) {
              return CaretPosition(container.previousSibling, container.previousSibling.data.length);
            } else {
              return CaretPosition.before(container);
            }
          } else {
            return isAfterInline(pos) ? CaretPosition(container, offset - 1) : pos;
          }
        }
      };
      const normalizeForwards = curry(normalizePosition, true);
      const normalizeBackwards = curry(normalizePosition, false);
      const execCommandIgnoreInputEvents = (editor, command) => {
        const inputBlocker = (e) => e.stopImmediatePropagation();
        editor.on("beforeinput input", inputBlocker, true);
        editor.getDoc().execCommand(command);
        editor.off("beforeinput input", inputBlocker);
      };
      const execEditorDeleteCommand = (editor) => {
        editor.execCommand("delete");
      };
      const execNativeDeleteCommand = (editor) => execCommandIgnoreInputEvents(editor, "Delete");
      const execNativeForwardDeleteCommand = (editor) => execCommandIgnoreInputEvents(editor, "ForwardDelete");
      const isBeforeRoot = (rootNode) => (elm) => is$2(parent(elm), rootNode, eq);
      const isTextBlockOrListItem = (element) => isTextBlock$2(element) || isListItem$1(element);
      const getParentBlock$2 = (rootNode, elm) => {
        if (contains(rootNode, elm)) {
          return closest$4(elm, isTextBlockOrListItem, isBeforeRoot(rootNode));
        } else {
          return Optional.none();
        }
      };
      const paddEmptyBody = (editor, moveSelection2 = true) => {
        if (editor.dom.isEmpty(editor.getBody())) {
          editor.setContent("", { no_selection: !moveSelection2 });
        }
      };
      const willDeleteLastPositionInElement = (forward, fromPos, elm) => lift2(firstPositionIn(elm), lastPositionIn(elm), (firstPos, lastPos) => {
        const normalizedFirstPos = normalizePosition(true, firstPos);
        const normalizedLastPos = normalizePosition(false, lastPos);
        const normalizedFromPos = normalizePosition(false, fromPos);
        if (forward) {
          return nextPosition(elm, normalizedFromPos).exists((nextPos) => nextPos.isEqual(normalizedLastPos) && fromPos.isEqual(normalizedFirstPos));
        } else {
          return prevPosition(elm, normalizedFromPos).exists((prevPos) => prevPos.isEqual(normalizedFirstPos) && fromPos.isEqual(normalizedLastPos));
        }
      }).getOr(true);
      const freefallRtl = (root) => {
        const child2 = isComment$1(root) ? prevSibling(root) : lastChild(root);
        return child2.bind(freefallRtl).orThunk(() => Optional.some(root));
      };
      const deleteRangeContents = (editor, rng, root, moveSelection2 = true) => {
        var _a;
        rng.deleteContents();
        const lastNode = freefallRtl(root).getOr(root);
        const lastBlock = SugarElement.fromDom((_a = editor.dom.getParent(lastNode.dom, editor.dom.isBlock)) !== null && _a !== void 0 ? _a : root.dom);
        if (lastBlock.dom === editor.getBody()) {
          paddEmptyBody(editor, moveSelection2);
        } else if (isEmpty$2(editor.schema, lastBlock, { checkRootAsContent: false })) {
          fillWithPaddingBr(lastBlock);
          if (moveSelection2) {
            editor.selection.setCursorLocation(lastBlock.dom, 0);
          }
        }
        if (!eq(root, lastBlock)) {
          const additionalCleanupNodes = is$2(parent(lastBlock), root) ? [] : siblings(lastBlock);
          each$e(additionalCleanupNodes.concat(children$1(root)), (node) => {
            if (!eq(node, lastBlock) && !contains(node, lastBlock) && isEmpty$2(editor.schema, node)) {
              remove$4(node);
            }
          });
        }
      };
      const isRootFromElement = (root) => (cur) => eq(root, cur);
      const getTableCells = (table2) => descendants(table2, "td,th");
      const getTable$1 = (node, isRoot2) => getClosestTable(SugarElement.fromDom(node), isRoot2);
      const selectionInTableWithNestedTable = (details) => {
        return lift2(details.startTable, details.endTable, (startTable, endTable) => {
          const isStartTableParentOfEndTable = descendant(startTable, (t) => eq(t, endTable));
          const isEndTableParentOfStartTable = descendant(endTable, (t) => eq(t, startTable));
          return !isStartTableParentOfEndTable && !isEndTableParentOfStartTable ? details : {
            ...details,
            startTable: isStartTableParentOfEndTable ? Optional.none() : details.startTable,
            endTable: isEndTableParentOfStartTable ? Optional.none() : details.endTable,
            isSameTable: false,
            isMultiTable: false
          };
        }).getOr(details);
      };
      const adjustQuirksInDetails = (details) => {
        return selectionInTableWithNestedTable(details);
      };
      const getTableDetailsFromRange = (rng, isRoot2) => {
        const startTable = getTable$1(rng.startContainer, isRoot2);
        const endTable = getTable$1(rng.endContainer, isRoot2);
        const isStartInTable = startTable.isSome();
        const isEndInTable = endTable.isSome();
        const isSameTable = lift2(startTable, endTable, eq).getOr(false);
        const isMultiTable = !isSameTable && isStartInTable && isEndInTable;
        return adjustQuirksInDetails({
          startTable,
          endTable,
          isStartInTable,
          isEndInTable,
          isSameTable,
          isMultiTable
        });
      };
      const tableCellRng = (start2, end2) => ({
        start: start2,
        end: end2
      });
      const tableSelection = (rng, table2, cells2) => ({
        rng,
        table: table2,
        cells: cells2
      });
      const deleteAction = Adt.generate([
        {
          singleCellTable: [
            "rng",
            "cell"
          ]
        },
        { fullTable: ["table"] },
        {
          partialTable: [
            "cells",
            "outsideDetails"
          ]
        },
        {
          multiTable: [
            "startTableCells",
            "endTableCells",
            "betweenRng"
          ]
        }
      ]);
      const getClosestCell$1 = (container, isRoot2) => closest$3(SugarElement.fromDom(container), "td,th", isRoot2);
      const isExpandedCellRng = (cellRng) => !eq(cellRng.start, cellRng.end);
      const getTableFromCellRng = (cellRng, isRoot2) => getClosestTable(cellRng.start, isRoot2).bind((startParentTable) => getClosestTable(cellRng.end, isRoot2).bind((endParentTable) => someIf(eq(startParentTable, endParentTable), startParentTable)));
      const isSingleCellTable = (cellRng, isRoot2) => !isExpandedCellRng(cellRng) && getTableFromCellRng(cellRng, isRoot2).exists((table2) => {
        const rows = table2.dom.rows;
        return rows.length === 1 && rows[0].cells.length === 1;
      });
      const getCellRng = (rng, isRoot2) => {
        const startCell = getClosestCell$1(rng.startContainer, isRoot2);
        const endCell = getClosestCell$1(rng.endContainer, isRoot2);
        return lift2(startCell, endCell, tableCellRng);
      };
      const getCellRangeFromStartTable = (isRoot2) => (startCell) => getClosestTable(startCell, isRoot2).bind((table2) => last$2(getTableCells(table2)).map((endCell) => tableCellRng(startCell, endCell)));
      const getCellRangeFromEndTable = (isRoot2) => (endCell) => getClosestTable(endCell, isRoot2).bind((table2) => head(getTableCells(table2)).map((startCell) => tableCellRng(startCell, endCell)));
      const getTableSelectionFromCellRng = (isRoot2) => (cellRng) => getTableFromCellRng(cellRng, isRoot2).map((table2) => tableSelection(cellRng, table2, getTableCells(table2)));
      const getTableSelections = (cellRng, selectionDetails, rng, isRoot2) => {
        if (rng.collapsed || !cellRng.forall(isExpandedCellRng)) {
          return Optional.none();
        } else if (selectionDetails.isSameTable) {
          const sameTableSelection = cellRng.bind(getTableSelectionFromCellRng(isRoot2));
          return Optional.some({
            start: sameTableSelection,
            end: sameTableSelection
          });
        } else {
          const startCell = getClosestCell$1(rng.startContainer, isRoot2);
          const endCell = getClosestCell$1(rng.endContainer, isRoot2);
          const startTableSelection = startCell.bind(getCellRangeFromStartTable(isRoot2)).bind(getTableSelectionFromCellRng(isRoot2));
          const endTableSelection = endCell.bind(getCellRangeFromEndTable(isRoot2)).bind(getTableSelectionFromCellRng(isRoot2));
          return Optional.some({
            start: startTableSelection,
            end: endTableSelection
          });
        }
      };
      const getCellIndex = (cells2, cell2) => findIndex$2(cells2, (x) => eq(x, cell2));
      const getSelectedCells = (tableSelection2) => lift2(getCellIndex(tableSelection2.cells, tableSelection2.rng.start), getCellIndex(tableSelection2.cells, tableSelection2.rng.end), (startIndex, endIndex) => tableSelection2.cells.slice(startIndex, endIndex + 1));
      const isSingleCellTableContentSelected = (optCellRng, rng, isRoot2) => optCellRng.exists((cellRng) => isSingleCellTable(cellRng, isRoot2) && hasAllContentsSelected(cellRng.start, rng));
      const unselectCells = (rng, selectionDetails) => {
        const { startTable, endTable } = selectionDetails;
        const otherContentRng = rng.cloneRange();
        startTable.each((table2) => otherContentRng.setStartAfter(table2.dom));
        endTable.each((table2) => otherContentRng.setEndBefore(table2.dom));
        return otherContentRng;
      };
      const handleSingleTable = (cellRng, selectionDetails, rng, isRoot2) => getTableSelections(cellRng, selectionDetails, rng, isRoot2).bind(({ start: start2, end: end2 }) => start2.or(end2)).bind((tableSelection2) => {
        const { isSameTable } = selectionDetails;
        const selectedCells = getSelectedCells(tableSelection2).getOr([]);
        if (isSameTable && tableSelection2.cells.length === selectedCells.length) {
          return Optional.some(deleteAction.fullTable(tableSelection2.table));
        } else if (selectedCells.length > 0) {
          if (isSameTable) {
            return Optional.some(deleteAction.partialTable(selectedCells, Optional.none()));
          } else {
            const otherContentRng = unselectCells(rng, selectionDetails);
            return Optional.some(deleteAction.partialTable(selectedCells, Optional.some({
              ...selectionDetails,
              rng: otherContentRng
            })));
          }
        } else {
          return Optional.none();
        }
      });
      const handleMultiTable = (cellRng, selectionDetails, rng, isRoot2) => getTableSelections(cellRng, selectionDetails, rng, isRoot2).bind(({ start: start2, end: end2 }) => {
        const startTableSelectedCells = start2.bind(getSelectedCells).getOr([]);
        const endTableSelectedCells = end2.bind(getSelectedCells).getOr([]);
        if (startTableSelectedCells.length > 0 && endTableSelectedCells.length > 0) {
          const otherContentRng = unselectCells(rng, selectionDetails);
          return Optional.some(deleteAction.multiTable(startTableSelectedCells, endTableSelectedCells, otherContentRng));
        } else {
          return Optional.none();
        }
      });
      const getActionFromRange = (root, rng) => {
        const isRoot2 = isRootFromElement(root);
        const optCellRng = getCellRng(rng, isRoot2);
        const selectionDetails = getTableDetailsFromRange(rng, isRoot2);
        if (isSingleCellTableContentSelected(optCellRng, rng, isRoot2)) {
          return optCellRng.map((cellRng) => deleteAction.singleCellTable(rng, cellRng.start));
        } else if (selectionDetails.isMultiTable) {
          return handleMultiTable(optCellRng, selectionDetails, rng, isRoot2);
        } else {
          return handleSingleTable(optCellRng, selectionDetails, rng, isRoot2);
        }
      };
      const cleanCells = (cells2) => each$e(cells2, (cell2) => {
        remove$9(cell2, "contenteditable");
        fillWithPaddingBr(cell2);
      });
      const getOutsideBlock = (editor, container) => Optional.from(editor.dom.getParent(container, editor.dom.isBlock)).map(SugarElement.fromDom);
      const handleEmptyBlock = (editor, startInTable, emptyBlock2) => {
        emptyBlock2.each((block) => {
          if (startInTable) {
            remove$4(block);
          } else {
            fillWithPaddingBr(block);
            editor.selection.setCursorLocation(block.dom, 0);
          }
        });
      };
      const deleteContentInsideCell = (editor, cell2, rng, isFirstCellInSelection) => {
        const insideTableRng = rng.cloneRange();
        if (isFirstCellInSelection) {
          insideTableRng.setStart(rng.startContainer, rng.startOffset);
          insideTableRng.setEndAfter(cell2.dom.lastChild);
        } else {
          insideTableRng.setStartBefore(cell2.dom.firstChild);
          insideTableRng.setEnd(rng.endContainer, rng.endOffset);
        }
        deleteCellContents(editor, insideTableRng, cell2, false).each((action2) => action2());
      };
      const collapseAndRestoreCellSelection = (editor) => {
        const selectedCells = getCellsFromEditor(editor);
        const selectedNode = SugarElement.fromDom(editor.selection.getNode());
        if (isTableCell$3(selectedNode.dom) && isEmpty$2(editor.schema, selectedNode)) {
          editor.selection.setCursorLocation(selectedNode.dom, 0);
        } else {
          editor.selection.collapse(true);
        }
        if (selectedCells.length > 1 && exists(selectedCells, (cell2) => eq(cell2, selectedNode))) {
          set$4(selectedNode, "data-mce-selected", "1");
        }
      };
      const emptySingleTableCells = (editor, cells2, outsideDetails) => Optional.some(() => {
        const editorRng = editor.selection.getRng();
        const cellsToClean = outsideDetails.bind(({ rng, isStartInTable }) => {
          const outsideBlock = getOutsideBlock(editor, isStartInTable ? rng.endContainer : rng.startContainer);
          rng.deleteContents();
          handleEmptyBlock(editor, isStartInTable, outsideBlock.filter(curry(isEmpty$2, editor.schema)));
          const endPointCell = isStartInTable ? cells2[0] : cells2[cells2.length - 1];
          deleteContentInsideCell(editor, endPointCell, editorRng, isStartInTable);
          if (!isEmpty$2(editor.schema, endPointCell)) {
            return Optional.some(isStartInTable ? cells2.slice(1) : cells2.slice(0, -1));
          } else {
            return Optional.none();
          }
        }).getOr(cells2);
        cleanCells(cellsToClean);
        collapseAndRestoreCellSelection(editor);
      });
      const emptyMultiTableCells = (editor, startTableCells, endTableCells, betweenRng) => Optional.some(() => {
        const rng = editor.selection.getRng();
        const startCell = startTableCells[0];
        const endCell = endTableCells[endTableCells.length - 1];
        deleteContentInsideCell(editor, startCell, rng, true);
        deleteContentInsideCell(editor, endCell, rng, false);
        const startTableCellsToClean = isEmpty$2(editor.schema, startCell) ? startTableCells : startTableCells.slice(1);
        const endTableCellsToClean = isEmpty$2(editor.schema, endCell) ? endTableCells : endTableCells.slice(0, -1);
        cleanCells(startTableCellsToClean.concat(endTableCellsToClean));
        betweenRng.deleteContents();
        collapseAndRestoreCellSelection(editor);
      });
      const deleteCellContents = (editor, rng, cell2, moveSelection2 = true) => Optional.some(() => {
        deleteRangeContents(editor, rng, cell2, moveSelection2);
      });
      const deleteTableElement = (editor, table2) => Optional.some(() => deleteElement$2(editor, false, table2));
      const deleteCellRange = (editor, rootElm, rng) => getActionFromRange(rootElm, rng).bind((action2) => action2.fold(curry(deleteCellContents, editor), curry(deleteTableElement, editor), curry(emptySingleTableCells, editor), curry(emptyMultiTableCells, editor)));
      const deleteCaptionRange = (editor, caption) => emptyElement(editor, caption);
      const deleteTableRange = (editor, rootElm, rng, startElm) => getParentCaption(rootElm, startElm).fold(() => deleteCellRange(editor, rootElm, rng), (caption) => deleteCaptionRange(editor, caption));
      const deleteRange$3 = (editor, startElm, selectedCells) => {
        const rootNode = SugarElement.fromDom(editor.getBody());
        const rng = editor.selection.getRng();
        return selectedCells.length !== 0 ? emptySingleTableCells(editor, selectedCells, Optional.none()) : deleteTableRange(editor, rootNode, rng, startElm);
      };
      const getParentCell = (rootElm, elm) => find$2(parentsAndSelf(elm, rootElm), isTableCell$2);
      const getParentCaption = (rootElm, elm) => find$2(parentsAndSelf(elm, rootElm), isTag("caption"));
      const deleteBetweenCells = (editor, rootElm, forward, fromCell, from2) => navigate(forward, editor.getBody(), from2).bind((to2) => getParentCell(rootElm, SugarElement.fromDom(to2.getNode())).bind((toCell) => eq(toCell, fromCell) ? Optional.none() : Optional.some(noop)));
      const emptyElement = (editor, elm) => Optional.some(() => {
        fillWithPaddingBr(elm);
        editor.selection.setCursorLocation(elm.dom, 0);
      });
      const isDeleteOfLastCharPos = (fromCaption, forward, from2, to2) => firstPositionIn(fromCaption.dom).bind((first2) => lastPositionIn(fromCaption.dom).map((last2) => forward ? from2.isEqual(first2) && to2.isEqual(last2) : from2.isEqual(last2) && to2.isEqual(first2))).getOr(true);
      const emptyCaretCaption = (editor, elm) => emptyElement(editor, elm);
      const validateCaretCaption = (rootElm, fromCaption, to2) => getParentCaption(rootElm, SugarElement.fromDom(to2.getNode())).fold(() => Optional.some(noop), (toCaption) => someIf(!eq(toCaption, fromCaption), noop));
      const deleteCaretInsideCaption = (editor, rootElm, forward, fromCaption, from2) => navigate(forward, editor.getBody(), from2).fold(() => Optional.some(noop), (to2) => isDeleteOfLastCharPos(fromCaption, forward, from2, to2) ? emptyCaretCaption(editor, fromCaption) : validateCaretCaption(rootElm, fromCaption, to2));
      const deleteCaretCells = (editor, forward, rootElm, startElm) => {
        const from2 = CaretPosition.fromRangeStart(editor.selection.getRng());
        return getParentCell(rootElm, startElm).bind((fromCell) => isEmpty$2(editor.schema, fromCell, { checkRootAsContent: false }) ? emptyElement(editor, fromCell) : deleteBetweenCells(editor, rootElm, forward, fromCell, from2));
      };
      const deleteCaretCaption = (editor, forward, rootElm, fromCaption) => {
        const from2 = CaretPosition.fromRangeStart(editor.selection.getRng());
        return isEmpty$2(editor.schema, fromCaption) ? emptyElement(editor, fromCaption) : deleteCaretInsideCaption(editor, rootElm, forward, fromCaption, from2);
      };
      const isNearTable = (forward, pos) => forward ? isBeforeTable(pos) : isAfterTable(pos);
      const isBeforeOrAfterTable = (editor, forward) => {
        const fromPos = CaretPosition.fromRangeStart(editor.selection.getRng());
        return isNearTable(forward, fromPos) || fromPosition(forward, editor.getBody(), fromPos).exists((pos) => isNearTable(forward, pos));
      };
      const deleteCaret$3 = (editor, forward, startElm) => {
        const rootElm = SugarElement.fromDom(editor.getBody());
        return getParentCaption(rootElm, startElm).fold(() => deleteCaretCells(editor, forward, rootElm, startElm).orThunk(() => someIf(isBeforeOrAfterTable(editor, forward), noop)), (fromCaption) => deleteCaretCaption(editor, forward, rootElm, fromCaption));
      };
      const backspaceDelete$b = (editor, forward) => {
        const startElm = SugarElement.fromDom(editor.selection.getStart(true));
        const cells2 = getCellsFromEditor(editor);
        return editor.selection.isCollapsed() && cells2.length === 0 ? deleteCaret$3(editor, forward, startElm) : deleteRange$3(editor, startElm, cells2);
      };
      const getContentEditableRoot$1 = (root, node) => {
        let tempNode = node;
        while (tempNode && tempNode !== root) {
          if (isContentEditableTrue$3(tempNode) || isContentEditableFalse$b(tempNode)) {
            return tempNode;
          }
          tempNode = tempNode.parentNode;
        }
        return null;
      };
      const internalAttributesPrefixes = [
        "data-ephox-",
        "data-mce-",
        "data-alloy-",
        "data-snooker-",
        "_"
      ];
      const each$9 = Tools.each;
      const ElementUtils = (editor) => {
        const dom2 = editor.dom;
        const internalAttributes = new Set(editor.serializer.getTempAttrs());
        const compare = (node1, node2) => {
          if (node1.nodeName !== node2.nodeName || node1.nodeType !== node2.nodeType) {
            return false;
          }
          const getAttribs = (node) => {
            const attribs = {};
            each$9(dom2.getAttribs(node), (attr) => {
              const name2 = attr.nodeName.toLowerCase();
              if (name2 !== "style" && !isAttributeInternal(name2)) {
                attribs[name2] = dom2.getAttrib(node, name2);
              }
            });
            return attribs;
          };
          const compareObjects = (obj1, obj2) => {
            for (const name2 in obj1) {
              if (has$2(obj1, name2)) {
                const value2 = obj2[name2];
                if (isUndefined(value2)) {
                  return false;
                }
                if (obj1[name2] !== value2) {
                  return false;
                }
                delete obj2[name2];
              }
            }
            for (const name2 in obj2) {
              if (has$2(obj2, name2)) {
                return false;
              }
            }
            return true;
          };
          if (isElement$6(node1) && isElement$6(node2)) {
            if (!compareObjects(getAttribs(node1), getAttribs(node2))) {
              return false;
            }
            if (!compareObjects(dom2.parseStyle(dom2.getAttrib(node1, "style")), dom2.parseStyle(dom2.getAttrib(node2, "style")))) {
              return false;
            }
          }
          return !isBookmarkNode$1(node1) && !isBookmarkNode$1(node2);
        };
        const isAttributeInternal = (attributeName) => exists(internalAttributesPrefixes, (value2) => startsWith(attributeName, value2)) || internalAttributes.has(attributeName);
        return {
          compare,
          isAttributeInternal
        };
      };
      const isHeading = (node) => [
        "h1",
        "h2",
        "h3",
        "h4",
        "h5",
        "h6"
      ].includes(node.name);
      const isSummary = (node) => node.name === "summary";
      const traverse = (root, fn) => {
        let node = root;
        while (node = node.walk()) {
          fn(node);
        }
      };
      const matchNode$1 = (nodeFilters, attributeFilters, node, matches) => {
        const name2 = node.name;
        for (let ni = 0, nl = nodeFilters.length; ni < nl; ni++) {
          const filter2 = nodeFilters[ni];
          if (filter2.name === name2) {
            const match2 = matches.nodes[name2];
            if (match2) {
              match2.nodes.push(node);
            } else {
              matches.nodes[name2] = {
                filter: filter2,
                nodes: [node]
              };
            }
          }
        }
        if (node.attributes) {
          for (let ai = 0, al = attributeFilters.length; ai < al; ai++) {
            const filter2 = attributeFilters[ai];
            const attrName = filter2.name;
            if (attrName in node.attributes.map) {
              const match2 = matches.attributes[attrName];
              if (match2) {
                match2.nodes.push(node);
              } else {
                matches.attributes[attrName] = {
                  filter: filter2,
                  nodes: [node]
                };
              }
            }
          }
        }
      };
      const findMatchingNodes = (nodeFilters, attributeFilters, node) => {
        const matches = {
          nodes: {},
          attributes: {}
        };
        if (node.firstChild) {
          traverse(node, (childNode) => {
            matchNode$1(nodeFilters, attributeFilters, childNode, matches);
          });
        }
        return matches;
      };
      const runFilters = (matches, args) => {
        const run = (matchRecord, filteringAttributes) => {
          each$d(matchRecord, (match2) => {
            const nodes = from(match2.nodes);
            each$e(match2.filter.callbacks, (callback) => {
              for (let i = nodes.length - 1; i >= 0; i--) {
                const node = nodes[i];
                const valueMatches = filteringAttributes ? node.attr(match2.filter.name) !== void 0 : node.name === match2.filter.name;
                if (!valueMatches || isNullable(node.parent)) {
                  nodes.splice(i, 1);
                }
              }
              if (nodes.length > 0) {
                callback(nodes, match2.filter.name, args);
              }
            });
          });
        };
        run(matches.nodes, false);
        run(matches.attributes, true);
      };
      const filter$2 = (nodeFilters, attributeFilters, node, args = {}) => {
        const matches = findMatchingNodes(nodeFilters, attributeFilters, node);
        runFilters(matches, args);
      };
      const paddEmptyNode = (settings, args, isBlock2, node) => {
        const brPreferred = settings.pad_empty_with_br || args.insert;
        if (brPreferred && isBlock2(node)) {
          const astNode = new AstNode("br", 1);
          if (args.insert) {
            astNode.attr("data-mce-bogus", "1");
          }
          node.empty().append(astNode);
        } else {
          node.empty().append(new AstNode("#text", 3)).value = nbsp;
        }
      };
      const isPaddedWithNbsp = (node) => {
        var _a;
        return hasOnlyChild(node, "#text") && ((_a = node === null || node === void 0 ? void 0 : node.firstChild) === null || _a === void 0 ? void 0 : _a.value) === nbsp;
      };
      const hasOnlyChild = (node, name2) => {
        const firstChild2 = node === null || node === void 0 ? void 0 : node.firstChild;
        return isNonNullable(firstChild2) && firstChild2 === node.lastChild && firstChild2.name === name2;
      };
      const isPadded = (schema, node) => {
        const rule = schema.getElementRule(node.name);
        return (rule === null || rule === void 0 ? void 0 : rule.paddEmpty) === true;
      };
      const isEmpty = (schema, nonEmptyElements, whitespaceElements, node) => node.isEmpty(nonEmptyElements, whitespaceElements, (node2) => isPadded(schema, node2));
      const isLineBreakNode = (node, isBlock2) => isNonNullable(node) && (isBlock2(node) || node.name === "br");
      const findClosestEditingHost = (scope) => {
        let editableNode;
        for (let node = scope; node; node = node.parent) {
          const contentEditable = node.attr("contenteditable");
          if (contentEditable === "false") {
            break;
          } else if (contentEditable === "true") {
            editableNode = node;
          }
        }
        return Optional.from(editableNode);
      };
      const removeOrUnwrapInvalidNode = (node, schema, originalNodeParent = node.parent) => {
        if (schema.getSpecialElements()[node.name]) {
          node.empty().remove();
        } else {
          const children2 = node.children();
          for (const childNode of children2) {
            if (originalNodeParent && !schema.isValidChild(originalNodeParent.name, childNode.name)) {
              removeOrUnwrapInvalidNode(childNode, schema, originalNodeParent);
            }
          }
          node.unwrap();
        }
      };
      const cleanInvalidNodes = (nodes, schema, rootNode, onCreate = noop) => {
        const textBlockElements = schema.getTextBlockElements();
        const nonEmptyElements = schema.getNonEmptyElements();
        const whitespaceElements = schema.getWhitespaceElements();
        const nonSplittableElements = Tools.makeMap("tr,td,th,tbody,thead,tfoot,table,summary");
        const fixed = /* @__PURE__ */ new Set();
        const isSplittableElement = (node) => node !== rootNode && !nonSplittableElements[node.name];
        for (let ni = 0; ni < nodes.length; ni++) {
          const node = nodes[ni];
          let parent2;
          let newParent;
          let tempNode;
          if (!node.parent || fixed.has(node)) {
            continue;
          }
          if (textBlockElements[node.name] && node.parent.name === "li") {
            let sibling2 = node.next;
            while (sibling2) {
              if (textBlockElements[sibling2.name]) {
                sibling2.name = "li";
                fixed.add(sibling2);
                node.parent.insert(sibling2, node.parent);
              } else {
                break;
              }
              sibling2 = sibling2.next;
            }
            node.unwrap();
            continue;
          }
          const parents2 = [node];
          for (parent2 = node.parent; parent2 && !schema.isValidChild(parent2.name, node.name) && isSplittableElement(parent2); parent2 = parent2.parent) {
            parents2.push(parent2);
          }
          if (parent2 && parents2.length > 1) {
            if (!isInvalid(schema, node, parent2)) {
              parents2.reverse();
              newParent = parents2[0].clone();
              onCreate(newParent);
              let currentNode = newParent;
              for (let i = 0; i < parents2.length - 1; i++) {
                if (schema.isValidChild(currentNode.name, parents2[i].name) && i > 0) {
                  tempNode = parents2[i].clone();
                  onCreate(tempNode);
                  currentNode.append(tempNode);
                } else {
                  tempNode = currentNode;
                }
                for (let childNode = parents2[i].firstChild; childNode && childNode !== parents2[i + 1]; ) {
                  const nextNode = childNode.next;
                  tempNode.append(childNode);
                  childNode = nextNode;
                }
                currentNode = tempNode;
              }
              if (!isEmpty(schema, nonEmptyElements, whitespaceElements, newParent)) {
                parent2.insert(newParent, parents2[0], true);
                parent2.insert(node, newParent);
              } else {
                parent2.insert(node, parents2[0], true);
              }
              parent2 = parents2[0];
              if (isEmpty(schema, nonEmptyElements, whitespaceElements, parent2) || hasOnlyChild(parent2, "br")) {
                parent2.empty().remove();
              }
            } else {
              removeOrUnwrapInvalidNode(node, schema);
            }
          } else if (node.parent) {
            if (node.name === "li") {
              let sibling2 = node.prev;
              if (sibling2 && (sibling2.name === "ul" || sibling2.name === "ol")) {
                sibling2.append(node);
                continue;
              }
              sibling2 = node.next;
              if (sibling2 && (sibling2.name === "ul" || sibling2.name === "ol") && sibling2.firstChild) {
                sibling2.insert(node, sibling2.firstChild, true);
                continue;
              }
              const wrapper = new AstNode("ul", 1);
              onCreate(wrapper);
              node.wrap(wrapper);
              continue;
            }
            if (schema.isValidChild(node.parent.name, "div") && schema.isValidChild("div", node.name)) {
              const wrapper = new AstNode("div", 1);
              onCreate(wrapper);
              node.wrap(wrapper);
            } else {
              removeOrUnwrapInvalidNode(node, schema);
            }
          }
        }
      };
      const hasClosest = (node, parentName) => {
        let tempNode = node;
        while (tempNode) {
          if (tempNode.name === parentName) {
            return true;
          }
          tempNode = tempNode.parent;
        }
        return false;
      };
      const isInvalid = (schema, node, parent2 = node.parent) => {
        if (!parent2) {
          return false;
        }
        if (schema.children[node.name] && !schema.isValidChild(parent2.name, node.name)) {
          return true;
        }
        if (node.name === "a" && hasClosest(parent2, "a")) {
          return true;
        }
        if (isSummary(parent2) && isHeading(node)) {
          return !((parent2 === null || parent2 === void 0 ? void 0 : parent2.firstChild) === node && (parent2 === null || parent2 === void 0 ? void 0 : parent2.lastChild) === node);
        }
        return false;
      };
      const createRange = (sc, so, ec, eo) => {
        const rng = document.createRange();
        rng.setStart(sc, so);
        rng.setEnd(ec, eo);
        return rng;
      };
      const normalizeBlockSelectionRange = (rng) => {
        const startPos = CaretPosition.fromRangeStart(rng);
        const endPos = CaretPosition.fromRangeEnd(rng);
        const rootNode = rng.commonAncestorContainer;
        return fromPosition(false, rootNode, endPos).map((newEndPos) => {
          if (!isInSameBlock(startPos, endPos, rootNode) && isInSameBlock(startPos, newEndPos, rootNode)) {
            return createRange(startPos.container(), startPos.offset(), newEndPos.container(), newEndPos.offset());
          } else {
            return rng;
          }
        }).getOr(rng);
      };
      const normalize = (rng) => rng.collapsed ? rng : normalizeBlockSelectionRange(rng);
      const hasOnlyOneChild$1 = (node) => {
        return isNonNullable(node.firstChild) && node.firstChild === node.lastChild;
      };
      const isPaddingNode = (node) => {
        return node.name === "br" || node.value === nbsp;
      };
      const isPaddedEmptyBlock = (schema, node) => {
        const blockElements = schema.getBlockElements();
        return blockElements[node.name] && hasOnlyOneChild$1(node) && isPaddingNode(node.firstChild);
      };
      const isEmptyFragmentElement = (schema, node) => {
        const nonEmptyElements = schema.getNonEmptyElements();
        return isNonNullable(node) && (node.isEmpty(nonEmptyElements) || isPaddedEmptyBlock(schema, node));
      };
      const isListFragment = (schema, fragment) => {
        let firstChild2 = fragment.firstChild;
        let lastChild2 = fragment.lastChild;
        if (firstChild2 && firstChild2.name === "meta") {
          firstChild2 = firstChild2.next;
        }
        if (lastChild2 && lastChild2.attr("id") === "mce_marker") {
          lastChild2 = lastChild2.prev;
        }
        if (isEmptyFragmentElement(schema, lastChild2)) {
          lastChild2 = lastChild2 === null || lastChild2 === void 0 ? void 0 : lastChild2.prev;
        }
        if (!firstChild2 || firstChild2 !== lastChild2) {
          return false;
        }
        return firstChild2.name === "ul" || firstChild2.name === "ol";
      };
      const cleanupDomFragment = (domFragment) => {
        var _a, _b;
        const firstChild2 = domFragment.firstChild;
        const lastChild2 = domFragment.lastChild;
        if (firstChild2 && firstChild2.nodeName === "META") {
          (_a = firstChild2.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(firstChild2);
        }
        if (lastChild2 && lastChild2.id === "mce_marker") {
          (_b = lastChild2.parentNode) === null || _b === void 0 ? void 0 : _b.removeChild(lastChild2);
        }
        return domFragment;
      };
      const toDomFragment = (dom2, serializer, fragment) => {
        const html2 = serializer.serialize(fragment);
        const domFragment = dom2.createFragment(html2);
        return cleanupDomFragment(domFragment);
      };
      const listItems = (elm) => {
        var _a;
        return filter$5((_a = elm === null || elm === void 0 ? void 0 : elm.childNodes) !== null && _a !== void 0 ? _a : [], (child2) => {
          return child2.nodeName === "LI";
        });
      };
      const isPadding = (node) => {
        return node.data === nbsp || isBr$6(node);
      };
      const isListItemPadded = (node) => {
        return isNonNullable(node === null || node === void 0 ? void 0 : node.firstChild) && node.firstChild === node.lastChild && isPadding(node.firstChild);
      };
      const isEmptyOrPadded = (elm) => {
        return !elm.firstChild || isListItemPadded(elm);
      };
      const trimListItems = (elms) => {
        return elms.length > 0 && isEmptyOrPadded(elms[elms.length - 1]) ? elms.slice(0, -1) : elms;
      };
      const getParentLi = (dom2, node) => {
        const parentBlock = dom2.getParent(node, dom2.isBlock);
        return parentBlock && parentBlock.nodeName === "LI" ? parentBlock : null;
      };
      const isParentBlockLi = (dom2, node) => {
        return !!getParentLi(dom2, node);
      };
      const getSplit = (parentNode, rng) => {
        const beforeRng = rng.cloneRange();
        const afterRng = rng.cloneRange();
        beforeRng.setStartBefore(parentNode);
        afterRng.setEndAfter(parentNode);
        return [
          beforeRng.cloneContents(),
          afterRng.cloneContents()
        ];
      };
      const findFirstIn = (node, rootNode) => {
        const caretPos = CaretPosition.before(node);
        const caretWalker = CaretWalker(rootNode);
        const newCaretPos = caretWalker.next(caretPos);
        return newCaretPos ? newCaretPos.toRange() : null;
      };
      const findLastOf = (node, rootNode) => {
        const caretPos = CaretPosition.after(node);
        const caretWalker = CaretWalker(rootNode);
        const newCaretPos = caretWalker.prev(caretPos);
        return newCaretPos ? newCaretPos.toRange() : null;
      };
      const insertMiddle = (target, elms, rootNode, rng) => {
        const parts = getSplit(target, rng);
        const parentElm = target.parentNode;
        if (parentElm) {
          parentElm.insertBefore(parts[0], target);
          Tools.each(elms, (li) => {
            parentElm.insertBefore(li, target);
          });
          parentElm.insertBefore(parts[1], target);
          parentElm.removeChild(target);
        }
        return findLastOf(elms[elms.length - 1], rootNode);
      };
      const insertBefore$2 = (target, elms, rootNode) => {
        const parentElm = target.parentNode;
        if (parentElm) {
          Tools.each(elms, (elm) => {
            parentElm.insertBefore(elm, target);
          });
        }
        return findFirstIn(target, rootNode);
      };
      const insertAfter$2 = (target, elms, rootNode, dom2) => {
        dom2.insertAfter(elms.reverse(), target);
        return findLastOf(elms[0], rootNode);
      };
      const insertAtCaret$1 = (serializer, dom2, rng, fragment) => {
        const domFragment = toDomFragment(dom2, serializer, fragment);
        const liTarget = getParentLi(dom2, rng.startContainer);
        const liElms = trimListItems(listItems(domFragment.firstChild));
        const BEGINNING = 1, END = 2;
        const rootNode = dom2.getRoot();
        const isAt = (location) => {
          const caretPos = CaretPosition.fromRangeStart(rng);
          const caretWalker = CaretWalker(dom2.getRoot());
          const newPos = location === BEGINNING ? caretWalker.prev(caretPos) : caretWalker.next(caretPos);
          const newPosNode = newPos === null || newPos === void 0 ? void 0 : newPos.getNode();
          return newPosNode ? getParentLi(dom2, newPosNode) !== liTarget : true;
        };
        if (!liTarget) {
          return null;
        } else if (isAt(BEGINNING)) {
          return insertBefore$2(liTarget, liElms, rootNode);
        } else if (isAt(END)) {
          return insertAfter$2(liTarget, liElms, rootNode, dom2);
        } else {
          return insertMiddle(liTarget, liElms, rootNode, rng);
        }
      };
      const mergeableWrappedElements = ["pre"];
      const shouldPasteContentOnly = (dom2, fragment, parentNode, root) => {
        var _a;
        const firstNode = fragment.firstChild;
        const lastNode = fragment.lastChild;
        const last2 = lastNode.attr("data-mce-type") === "bookmark" ? lastNode.prev : lastNode;
        const isPastingSingleElement = firstNode === last2;
        const isWrappedElement = contains$2(mergeableWrappedElements, firstNode.name);
        if (isPastingSingleElement && isWrappedElement) {
          const isContentEditable2 = firstNode.attr("contenteditable") !== "false";
          const isPastingInTheSameBlockTag = ((_a = dom2.getParent(parentNode, dom2.isBlock)) === null || _a === void 0 ? void 0 : _a.nodeName.toLowerCase()) === firstNode.name;
          const isPastingInContentEditable = Optional.from(getContentEditableRoot$1(root, parentNode)).forall(isContentEditableTrue$3);
          return isContentEditable2 && isPastingInTheSameBlockTag && isPastingInContentEditable;
        } else {
          return false;
        }
      };
      const isTableCell = isTableCell$3;
      const isTableCellContentSelected = (dom2, rng, cell2) => {
        if (isNonNullable(cell2)) {
          const endCell = dom2.getParent(rng.endContainer, isTableCell);
          return cell2 === endCell && hasAllContentsSelected(SugarElement.fromDom(cell2), rng);
        } else {
          return false;
        }
      };
      const isEditableEmptyBlock = (dom2, node) => {
        if (dom2.isBlock(node) && dom2.isEditable(node)) {
          const childNodes = node.childNodes;
          return childNodes.length === 1 && isBr$6(childNodes[0]) || childNodes.length === 0;
        } else {
          return false;
        }
      };
      const validInsertion = (editor, value2, parentNode) => {
        var _a;
        if (parentNode.getAttribute("data-mce-bogus") === "all") {
          (_a = parentNode.parentNode) === null || _a === void 0 ? void 0 : _a.insertBefore(editor.dom.createFragment(value2), parentNode);
        } else {
          if (isEditableEmptyBlock(editor.dom, parentNode)) {
            editor.dom.setHTML(parentNode, value2);
          } else {
            editor.selection.setContent(value2, { no_events: true });
          }
        }
      };
      const trimBrsFromTableCell = (dom2, elm, schema) => {
        Optional.from(dom2.getParent(elm, "td,th")).map(SugarElement.fromDom).each((el) => trimBlockTrailingBr(el, schema));
      };
      const reduceInlineTextElements = (editor, merge2) => {
        const textInlineElements = editor.schema.getTextInlineElements();
        const dom2 = editor.dom;
        if (merge2) {
          const root = editor.getBody();
          const elementUtils = ElementUtils(editor);
          const fragmentSelector = "*[data-mce-fragment]";
          const fragments = dom2.select(fragmentSelector);
          Tools.each(fragments, (node) => {
            const isInline2 = (currentNode) => isNonNullable(textInlineElements[currentNode.nodeName.toLowerCase()]);
            const hasOneChild = (currentNode) => currentNode.childNodes.length === 1;
            const hasNoNonInheritableStyles = (currentNode) => !(hasNonInheritableStyles(dom2, currentNode) || hasConditionalNonInheritableStyles(dom2, currentNode));
            if (hasNoNonInheritableStyles(node) && isInline2(node) && hasOneChild(node)) {
              const styles = getStyleProps(dom2, node);
              const isOverridden = (oldStyles, newStyles) => forall(oldStyles, (style) => contains$2(newStyles, style));
              const overriddenByAllChildren = (childNode) => hasOneChild(node) && dom2.is(childNode, fragmentSelector) && isInline2(childNode) && (childNode.nodeName === node.nodeName && isOverridden(styles, getStyleProps(dom2, childNode)) || overriddenByAllChildren(childNode.children[0]));
              const identicalToParent = (parentNode) => isNonNullable(parentNode) && parentNode !== root && (elementUtils.compare(node, parentNode) || identicalToParent(parentNode.parentElement));
              const conflictWithInsertedParent = (parentNode) => isNonNullable(parentNode) && parentNode !== root && dom2.is(parentNode, fragmentSelector) && (hasStyleConflict(dom2, node, parentNode) || conflictWithInsertedParent(parentNode.parentElement));
              if (overriddenByAllChildren(node.children[0]) || identicalToParent(node.parentElement) && !conflictWithInsertedParent(node.parentElement)) {
                dom2.remove(node, true);
              }
            }
          });
        }
      };
      const markFragmentElements = (fragment) => {
        let node = fragment;
        while (node = node.walk()) {
          if (node.type === 1) {
            node.attr("data-mce-fragment", "1");
          }
        }
      };
      const unmarkFragmentElements = (elm) => {
        Tools.each(elm.getElementsByTagName("*"), (elm2) => {
          elm2.removeAttribute("data-mce-fragment");
        });
      };
      const isPartOfFragment = (node) => {
        return !!node.getAttribute("data-mce-fragment");
      };
      const canHaveChildren = (editor, node) => {
        return isNonNullable(node) && !editor.schema.getVoidElements()[node.nodeName];
      };
      const moveSelectionToMarker = (editor, marker) => {
        var _a, _b, _c;
        let nextRng;
        const dom2 = editor.dom;
        const selection = editor.selection;
        if (!marker) {
          return;
        }
        selection.scrollIntoView(marker);
        const parentEditableElm = getContentEditableRoot$1(editor.getBody(), marker);
        if (parentEditableElm && dom2.getContentEditable(parentEditableElm) === "false") {
          dom2.remove(marker);
          selection.select(parentEditableElm);
          return;
        }
        let rng = dom2.createRng();
        const node = marker.previousSibling;
        if (isText$b(node)) {
          rng.setStart(node, (_b = (_a = node.nodeValue) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0);
          const node2 = marker.nextSibling;
          if (isText$b(node2)) {
            node.appendData(node2.data);
            (_c = node2.parentNode) === null || _c === void 0 ? void 0 : _c.removeChild(node2);
          }
        } else {
          rng.setStartBefore(marker);
          rng.setEndBefore(marker);
        }
        const findNextCaretRng = (rng2) => {
          let caretPos = CaretPosition.fromRangeStart(rng2);
          const caretWalker = CaretWalker(editor.getBody());
          caretPos = caretWalker.next(caretPos);
          return caretPos === null || caretPos === void 0 ? void 0 : caretPos.toRange();
        };
        const parentBlock = dom2.getParent(marker, dom2.isBlock);
        dom2.remove(marker);
        if (parentBlock && dom2.isEmpty(parentBlock)) {
          const isCell = isTableCell(parentBlock);
          empty(SugarElement.fromDom(parentBlock));
          rng.setStart(parentBlock, 0);
          rng.setEnd(parentBlock, 0);
          if (!isCell && !isPartOfFragment(parentBlock) && (nextRng = findNextCaretRng(rng))) {
            rng = nextRng;
            dom2.remove(parentBlock);
          } else {
            dom2.add(parentBlock, dom2.create("br", isCell ? {} : { "data-mce-bogus": "1" }));
          }
        }
        selection.setRng(rng);
      };
      const deleteSelectedContent = (editor) => {
        const dom2 = editor.dom;
        const rng = normalize(editor.selection.getRng());
        editor.selection.setRng(rng);
        const startCell = dom2.getParent(rng.startContainer, isTableCell);
        if (isTableCellContentSelected(dom2, rng, startCell)) {
          deleteCellContents(editor, rng, SugarElement.fromDom(startCell));
        } else if (rng.startContainer === rng.endContainer && rng.endOffset - rng.startOffset === 1 && isText$b(rng.startContainer.childNodes[rng.startOffset])) {
          rng.deleteContents();
        } else {
          editor.getDoc().execCommand("Delete", false);
        }
      };
      const findMarkerNode = (scope) => {
        for (let markerNode = scope; markerNode; markerNode = markerNode.walk()) {
          if (markerNode.attr("id") === "mce_marker") {
            return Optional.some(markerNode);
          }
        }
        return Optional.none();
      };
      const notHeadingsInSummary = (dom2, node, fragment) => {
        var _a;
        return exists(fragment.children(), isHeading) && ((_a = dom2.getParent(node, dom2.isBlock)) === null || _a === void 0 ? void 0 : _a.nodeName) === "SUMMARY";
      };
      const insertHtmlAtCaret = (editor, value2, details) => {
        var _a, _b;
        const selection = editor.selection;
        const dom2 = editor.dom;
        const parser = editor.parser;
        const merge2 = details.merge;
        const serializer = HtmlSerializer({ validate: true }, editor.schema);
        const bookmarkHtml = '<span id="mce_marker" data-mce-type="bookmark">&#xFEFF;</span>';
        if (!details.preserve_zwsp) {
          value2 = trim$2(value2);
        }
        if (value2.indexOf("{$caret}") === -1) {
          value2 += "{$caret}";
        }
        value2 = value2.replace(/\{\$caret\}/, bookmarkHtml);
        let rng = selection.getRng();
        const caretElement = rng.startContainer;
        const body = editor.getBody();
        if (caretElement === body && selection.isCollapsed()) {
          if (dom2.isBlock(body.firstChild) && canHaveChildren(editor, body.firstChild) && dom2.isEmpty(body.firstChild)) {
            rng = dom2.createRng();
            rng.setStart(body.firstChild, 0);
            rng.setEnd(body.firstChild, 0);
            selection.setRng(rng);
          }
        }
        if (!selection.isCollapsed()) {
          deleteSelectedContent(editor);
        }
        const parentNode = selection.getNode();
        const parserArgs = {
          context: parentNode.nodeName.toLowerCase(),
          data: details.data,
          insert: true
        };
        const fragment = parser.parse(value2, parserArgs);
        if (details.paste === true && isListFragment(editor.schema, fragment) && isParentBlockLi(dom2, parentNode)) {
          rng = insertAtCaret$1(serializer, dom2, selection.getRng(), fragment);
          if (rng) {
            selection.setRng(rng);
          }
          return value2;
        }
        if (details.paste === true && shouldPasteContentOnly(dom2, fragment, parentNode, editor.getBody())) {
          (_a = fragment.firstChild) === null || _a === void 0 ? void 0 : _a.unwrap();
        }
        markFragmentElements(fragment);
        let node = fragment.lastChild;
        if (node && node.attr("id") === "mce_marker") {
          const marker = node;
          for (node = node.prev; node; node = node.walk(true)) {
            if (node.name === "table") {
              break;
            }
            if (node.type === 3 || !dom2.isBlock(node.name)) {
              if (node.parent && editor.schema.isValidChild(node.parent.name, "span")) {
                node.parent.insert(marker, node, node.name === "br");
              }
              break;
            }
          }
        }
        editor._selectionOverrides.showBlockCaretContainer(parentNode);
        if (!parserArgs.invalid && !notHeadingsInSummary(dom2, parentNode, fragment)) {
          value2 = serializer.serialize(fragment);
          validInsertion(editor, value2, parentNode);
        } else {
          editor.selection.setContent(bookmarkHtml);
          let parentNode2 = selection.getNode();
          let tempNode;
          const rootNode = editor.getBody();
          if (isDocument$1(parentNode2)) {
            parentNode2 = tempNode = rootNode;
          } else {
            tempNode = parentNode2;
          }
          while (tempNode && tempNode !== rootNode) {
            parentNode2 = tempNode;
            tempNode = tempNode.parentNode;
          }
          value2 = parentNode2 === rootNode ? rootNode.innerHTML : dom2.getOuterHTML(parentNode2);
          const root = parser.parse(value2);
          const markerNode = findMarkerNode(root);
          const editingHost = markerNode.bind(findClosestEditingHost).getOr(root);
          markerNode.each((marker) => marker.replace(fragment));
          const toExtract = fragment.children();
          const parent2 = (_b = fragment.parent) !== null && _b !== void 0 ? _b : root;
          fragment.unwrap();
          const invalidChildren = filter$5(toExtract, (node2) => isInvalid(editor.schema, node2, parent2));
          cleanInvalidNodes(invalidChildren, editor.schema, editingHost);
          filter$2(parser.getNodeFilters(), parser.getAttributeFilters(), root);
          value2 = serializer.serialize(root);
          if (parentNode2 === rootNode) {
            dom2.setHTML(rootNode, value2);
          } else {
            dom2.setOuterHTML(parentNode2, value2);
          }
        }
        reduceInlineTextElements(editor, merge2);
        moveSelectionToMarker(editor, dom2.get("mce_marker"));
        unmarkFragmentElements(editor.getBody());
        trimBrsFromTableCell(dom2, selection.getStart(), editor.schema);
        updateCaret(editor.schema, editor.getBody(), selection.getStart());
        return value2;
      };
      const isTreeNode = (content) => content instanceof AstNode;
      const moveSelection = (editor) => {
        if (hasFocus(editor)) {
          firstPositionIn(editor.getBody()).each((pos) => {
            const node = pos.getNode();
            const caretPos = isTable$2(node) ? firstPositionIn(node).getOr(pos) : pos;
            editor.selection.setRng(caretPos.toRange());
          });
        }
      };
      const setEditorHtml = (editor, html2, noSelection) => {
        editor.dom.setHTML(editor.getBody(), html2);
        if (noSelection !== true) {
          moveSelection(editor);
        }
      };
      const setContentString = (editor, body, content, args) => {
        content = trim$2(content);
        if (content.length === 0 || /^\s+$/.test(content)) {
          const padd = '<br data-mce-bogus="1">';
          if (body.nodeName === "TABLE") {
            content = "<tr><td>" + padd + "</td></tr>";
          } else if (/^(UL|OL)$/.test(body.nodeName)) {
            content = "<li>" + padd + "</li>";
          }
          const forcedRootBlockName = getForcedRootBlock(editor);
          if (editor.schema.isValidChild(body.nodeName.toLowerCase(), forcedRootBlockName.toLowerCase())) {
            content = padd;
            content = editor.dom.createHTML(forcedRootBlockName, getForcedRootBlockAttrs(editor), content);
          } else if (!content) {
            content = padd;
          }
          setEditorHtml(editor, content, args.no_selection);
          return {
            content,
            html: content
          };
        } else {
          if (args.format !== "raw") {
            content = HtmlSerializer({ validate: false }, editor.schema).serialize(editor.parser.parse(content, {
              isRootContent: true,
              insert: true
            }));
          }
          const trimmedHtml = isWsPreserveElement(SugarElement.fromDom(body)) ? content : Tools.trim(content);
          setEditorHtml(editor, trimmedHtml, args.no_selection);
          return {
            content: trimmedHtml,
            html: trimmedHtml
          };
        }
      };
      const setContentTree = (editor, body, content, args) => {
        filter$2(editor.parser.getNodeFilters(), editor.parser.getAttributeFilters(), content);
        const html2 = HtmlSerializer({ validate: false }, editor.schema).serialize(content);
        const trimmedHtml = trim$2(isWsPreserveElement(SugarElement.fromDom(body)) ? html2 : Tools.trim(html2));
        setEditorHtml(editor, trimmedHtml, args.no_selection);
        return {
          content,
          html: trimmedHtml
        };
      };
      const setContentInternal = (editor, content, args) => {
        return Optional.from(editor.getBody()).map((body) => {
          if (isTreeNode(content)) {
            return setContentTree(editor, body, content, args);
          } else {
            return setContentString(editor, body, content, args);
          }
        }).getOr({
          content,
          html: isTreeNode(args.content) ? "" : args.content
        });
      };
      const ensureIsRoot = (isRoot2) => isFunction(isRoot2) ? isRoot2 : never;
      const ancestor = (scope, transform, isRoot2) => {
        let element = scope.dom;
        const stop2 = ensureIsRoot(isRoot2);
        while (element.parentNode) {
          element = element.parentNode;
          const el = SugarElement.fromDom(element);
          const transformed = transform(el);
          if (transformed.isSome()) {
            return transformed;
          } else if (stop2(el)) {
            break;
          }
        }
        return Optional.none();
      };
      const closest$1 = (scope, transform, isRoot2) => {
        const current = transform(scope);
        const stop2 = ensureIsRoot(isRoot2);
        return current.orThunk(() => stop2(scope) ? Optional.none() : ancestor(scope, transform, stop2));
      };
      const isEq$3 = isEq$5;
      const matchesUnInheritedFormatSelector = (ed, node, name2) => {
        const formatList = ed.formatter.get(name2);
        if (formatList) {
          for (let i = 0; i < formatList.length; i++) {
            const format = formatList[i];
            if (isSelectorFormat(format) && format.inherit === false && ed.dom.is(node, format.selector)) {
              return true;
            }
          }
        }
        return false;
      };
      const matchParents = (editor, node, name2, vars, similar) => {
        const root = editor.dom.getRoot();
        if (node === root) {
          return false;
        }
        const matchedNode = editor.dom.getParent(node, (elm) => {
          if (matchesUnInheritedFormatSelector(editor, elm, name2)) {
            return true;
          }
          return elm.parentNode === root || !!matchNode(editor, elm, name2, vars, true);
        });
        return !!matchNode(editor, matchedNode, name2, vars, similar);
      };
      const matchName = (dom2, node, format) => {
        if (isInlineFormat(format) && isEq$3(node, format.inline)) {
          return true;
        }
        if (isBlockFormat(format) && isEq$3(node, format.block)) {
          return true;
        }
        if (isSelectorFormat(format)) {
          return isElement$6(node) && dom2.is(node, format.selector);
        }
        return false;
      };
      const matchItems = (dom2, node, format, itemName, similar, vars) => {
        const items = format[itemName];
        const matchAttributes = itemName === "attributes";
        if (isFunction(format.onmatch)) {
          return format.onmatch(node, format, itemName);
        }
        if (items) {
          if (!isArrayLike(items)) {
            for (const key in items) {
              if (has$2(items, key)) {
                const value2 = matchAttributes ? dom2.getAttrib(node, key) : getStyle(dom2, node, key);
                const expectedValue = replaceVars(items[key], vars);
                const isEmptyValue = isNullable(value2) || isEmpty$3(value2);
                if (isEmptyValue && isNullable(expectedValue)) {
                  continue;
                }
                if (similar && isEmptyValue && !format.exact) {
                  return false;
                }
                if ((!similar || format.exact) && !isEq$3(value2, normalizeStyleValue(expectedValue, key))) {
                  return false;
                }
              }
            }
          } else {
            for (let i = 0; i < items.length; i++) {
              if (matchAttributes ? dom2.getAttrib(node, items[i]) : getStyle(dom2, node, items[i])) {
                return true;
              }
            }
          }
        }
        return true;
      };
      const matchNode = (ed, node, name2, vars, similar) => {
        const formatList = ed.formatter.get(name2);
        const dom2 = ed.dom;
        if (formatList && isElement$6(node)) {
          for (let i = 0; i < formatList.length; i++) {
            const format = formatList[i];
            if (matchName(ed.dom, node, format) && matchItems(dom2, node, format, "attributes", similar, vars) && matchItems(dom2, node, format, "styles", similar, vars)) {
              const classes = format.classes;
              if (classes) {
                for (let x = 0; x < classes.length; x++) {
                  if (!ed.dom.hasClass(node, replaceVars(classes[x], vars))) {
                    return;
                  }
                }
              }
              return format;
            }
          }
        }
        return void 0;
      };
      const match$2 = (editor, name2, vars, node, similar) => {
        if (node) {
          return matchParents(editor, node, name2, vars, similar);
        }
        node = editor.selection.getNode();
        if (matchParents(editor, node, name2, vars, similar)) {
          return true;
        }
        const startNode = editor.selection.getStart();
        if (startNode !== node) {
          if (matchParents(editor, startNode, name2, vars, similar)) {
            return true;
          }
        }
        return false;
      };
      const matchAll = (editor, names, vars) => {
        const matchedFormatNames = [];
        const checkedMap = {};
        const startElement = editor.selection.getStart();
        editor.dom.getParent(startElement, (node) => {
          for (let i = 0; i < names.length; i++) {
            const name2 = names[i];
            if (!checkedMap[name2] && matchNode(editor, node, name2, vars)) {
              checkedMap[name2] = true;
              matchedFormatNames.push(name2);
            }
          }
        }, editor.dom.getRoot());
        return matchedFormatNames;
      };
      const closest = (editor, names) => {
        const isRoot2 = (elm) => eq(elm, SugarElement.fromDom(editor.getBody()));
        const match2 = (elm, name2) => matchNode(editor, elm.dom, name2) ? Optional.some(name2) : Optional.none();
        return Optional.from(editor.selection.getStart(true)).bind((rawElm) => closest$1(SugarElement.fromDom(rawElm), (elm) => findMap(names, (name2) => match2(elm, name2)), isRoot2)).getOrNull();
      };
      const canApply = (editor, name2) => {
        const formatList = editor.formatter.get(name2);
        const dom2 = editor.dom;
        if (formatList && editor.selection.isEditable()) {
          const startNode = editor.selection.getStart();
          const parents2 = getParents$2(dom2, startNode);
          for (let x = formatList.length - 1; x >= 0; x--) {
            const format = formatList[x];
            if (!isSelectorFormat(format)) {
              return true;
            }
            for (let i = parents2.length - 1; i >= 0; i--) {
              if (dom2.is(parents2[i], format.selector)) {
                return true;
              }
            }
          }
        }
        return false;
      };
      const matchAllOnNode = (editor, node, formatNames) => foldl(formatNames, (acc, name2) => {
        const matchSimilar = isVariableFormatName(editor, name2);
        if (editor.formatter.matchNode(node, name2, {}, matchSimilar)) {
          return acc.concat([name2]);
        } else {
          return acc;
        }
      }, []);
      const ZWSP = ZWSP$1;
      const importNode = (ownerDocument, node) => {
        return ownerDocument.importNode(node, true);
      };
      const findFirstTextNode = (node) => {
        if (node) {
          const walker = new DomTreeWalker(node, node);
          for (let tempNode = walker.current(); tempNode; tempNode = walker.next()) {
            if (isText$b(tempNode)) {
              return tempNode;
            }
          }
        }
        return null;
      };
      const createCaretContainer = (fill) => {
        const caretContainer = SugarElement.fromTag("span");
        setAll$1(caretContainer, {
          "id": CARET_ID,
          "data-mce-bogus": "1",
          "data-mce-type": "format-caret"
        });
        if (fill) {
          append$1(caretContainer, SugarElement.fromText(ZWSP));
        }
        return caretContainer;
      };
      const trimZwspFromCaretContainer = (caretContainerNode) => {
        const textNode = findFirstTextNode(caretContainerNode);
        if (textNode && textNode.data.charAt(0) === ZWSP) {
          textNode.deleteData(0, 1);
        }
        return textNode;
      };
      const removeCaretContainerNode = (editor, node, moveCaret2) => {
        const dom2 = editor.dom, selection = editor.selection;
        if (isCaretContainerEmpty(node)) {
          deleteElement$2(editor, false, SugarElement.fromDom(node), moveCaret2, true);
        } else {
          const rng = selection.getRng();
          const block = dom2.getParent(node, dom2.isBlock);
          const startContainer = rng.startContainer;
          const startOffset = rng.startOffset;
          const endContainer = rng.endContainer;
          const endOffset = rng.endOffset;
          const textNode = trimZwspFromCaretContainer(node);
          dom2.remove(node, true);
          if (startContainer === textNode && startOffset > 0) {
            rng.setStart(textNode, startOffset - 1);
          }
          if (endContainer === textNode && endOffset > 0) {
            rng.setEnd(textNode, endOffset - 1);
          }
          if (block && dom2.isEmpty(block)) {
            fillWithPaddingBr(SugarElement.fromDom(block));
          }
          selection.setRng(rng);
        }
      };
      const removeCaretContainer = (editor, node, moveCaret2) => {
        const dom2 = editor.dom, selection = editor.selection;
        if (!node) {
          node = getParentCaretContainer(editor.getBody(), selection.getStart());
          if (!node) {
            while (node = dom2.get(CARET_ID)) {
              removeCaretContainerNode(editor, node, moveCaret2);
            }
          }
        } else {
          removeCaretContainerNode(editor, node, moveCaret2);
        }
      };
      const insertCaretContainerNode = (editor, caretContainer, formatNode) => {
        var _a, _b;
        const dom2 = editor.dom;
        const block = dom2.getParent(formatNode, curry(isTextBlock$1, editor.schema));
        if (block && dom2.isEmpty(block)) {
          (_a = formatNode.parentNode) === null || _a === void 0 ? void 0 : _a.replaceChild(caretContainer, formatNode);
        } else {
          removeTrailingBr(SugarElement.fromDom(formatNode));
          if (dom2.isEmpty(formatNode)) {
            (_b = formatNode.parentNode) === null || _b === void 0 ? void 0 : _b.replaceChild(caretContainer, formatNode);
          } else {
            dom2.insertAfter(caretContainer, formatNode);
          }
        }
      };
      const appendNode = (parentNode, node) => {
        parentNode.appendChild(node);
        return node;
      };
      const insertFormatNodesIntoCaretContainer = (formatNodes, caretContainer) => {
        var _a;
        const innerMostFormatNode = foldr(formatNodes, (parentNode, formatNode) => {
          return appendNode(parentNode, formatNode.cloneNode(false));
        }, caretContainer);
        const doc = (_a = innerMostFormatNode.ownerDocument) !== null && _a !== void 0 ? _a : document;
        return appendNode(innerMostFormatNode, doc.createTextNode(ZWSP));
      };
      const cleanFormatNode = (editor, caretContainer, formatNode, name2, vars, similar) => {
        const formatter = editor.formatter;
        const dom2 = editor.dom;
        const validFormats = filter$5(keys(formatter.get()), (formatName) => formatName !== name2 && !contains$1(formatName, "removeformat"));
        const matchedFormats = matchAllOnNode(editor, formatNode, validFormats);
        const uniqueFormats = filter$5(matchedFormats, (fmtName) => !areSimilarFormats(editor, fmtName, name2));
        if (uniqueFormats.length > 0) {
          const clonedFormatNode = formatNode.cloneNode(false);
          dom2.add(caretContainer, clonedFormatNode);
          formatter.remove(name2, vars, clonedFormatNode, similar);
          dom2.remove(clonedFormatNode);
          return Optional.some(clonedFormatNode);
        } else {
          return Optional.none();
        }
      };
      const normalizeNbsps = (node) => set(node, get$3(node).replace(new RegExp(`${nbsp}$`), " "));
      const normalizeNbspsBetween = (editor, caretContainer) => {
        const handler = () => {
          if (caretContainer !== null && !editor.dom.isEmpty(caretContainer)) {
            prevSibling(SugarElement.fromDom(caretContainer)).each((node) => {
              if (isText$c(node)) {
                normalizeNbsps(node);
              } else {
                descendant$2(node, (e) => isText$c(e)).each((textNode) => {
                  if (isText$c(textNode)) {
                    normalizeNbsps(textNode);
                  }
                });
              }
            });
          }
        };
        editor.once("input", (e) => {
          if (e.data && !isWhiteSpace(e.data)) {
            if (!e.isComposing) {
              handler();
            } else {
              editor.once("compositionend", () => {
                handler();
              });
            }
          }
        });
      };
      const applyCaretFormat = (editor, name2, vars) => {
        let caretContainer;
        const selection = editor.selection;
        const formatList = editor.formatter.get(name2);
        if (!formatList) {
          return;
        }
        const selectionRng = selection.getRng();
        let offset = selectionRng.startOffset;
        const container = selectionRng.startContainer;
        const text2 = container.nodeValue;
        caretContainer = getParentCaretContainer(editor.getBody(), selection.getStart());
        const wordcharRegex = /[^\s\u00a0\u00ad\u200b\ufeff]/;
        if (text2 && offset > 0 && offset < text2.length && wordcharRegex.test(text2.charAt(offset)) && wordcharRegex.test(text2.charAt(offset - 1))) {
          const bookmark = selection.getBookmark();
          selectionRng.collapse(true);
          let rng = expandRng(editor.dom, selectionRng, formatList);
          rng = split(rng);
          editor.formatter.apply(name2, vars, rng);
          selection.moveToBookmark(bookmark);
        } else {
          let textNode = caretContainer ? findFirstTextNode(caretContainer) : null;
          if (!caretContainer || (textNode === null || textNode === void 0 ? void 0 : textNode.data) !== ZWSP) {
            caretContainer = importNode(editor.getDoc(), createCaretContainer(true).dom);
            textNode = caretContainer.firstChild;
            selectionRng.insertNode(caretContainer);
            offset = 1;
            normalizeNbspsBetween(editor, caretContainer);
            editor.formatter.apply(name2, vars, caretContainer);
          } else {
            editor.formatter.apply(name2, vars, caretContainer);
          }
          selection.setCursorLocation(textNode, offset);
        }
      };
      const removeCaretFormat = (editor, name2, vars, similar) => {
        const dom2 = editor.dom;
        const selection = editor.selection;
        let hasContentAfter = false;
        const formatList = editor.formatter.get(name2);
        if (!formatList) {
          return;
        }
        const rng = selection.getRng();
        const container = rng.startContainer;
        const offset = rng.startOffset;
        let node = container;
        if (isText$b(container)) {
          if (offset !== container.data.length) {
            hasContentAfter = true;
          }
          node = node.parentNode;
        }
        const parents2 = [];
        let formatNode;
        while (node) {
          if (matchNode(editor, node, name2, vars, similar)) {
            formatNode = node;
            break;
          }
          if (node.nextSibling) {
            hasContentAfter = true;
          }
          parents2.push(node);
          node = node.parentNode;
        }
        if (!formatNode) {
          return;
        }
        if (hasContentAfter) {
          const bookmark = selection.getBookmark();
          rng.collapse(true);
          let expandedRng = expandRng(dom2, rng, formatList, { includeTrailingSpace: true });
          expandedRng = split(expandedRng);
          editor.formatter.remove(name2, vars, expandedRng, similar);
          selection.moveToBookmark(bookmark);
        } else {
          const caretContainer = getParentCaretContainer(editor.getBody(), formatNode);
          const parentsAfter = isNonNullable(caretContainer) ? dom2.getParents(formatNode.parentNode, always, caretContainer) : [];
          const newCaretContainer = createCaretContainer(false).dom;
          insertCaretContainerNode(editor, newCaretContainer, caretContainer !== null && caretContainer !== void 0 ? caretContainer : formatNode);
          const cleanedFormatNode = cleanFormatNode(editor, newCaretContainer, formatNode, name2, vars, similar);
          const caretTextNode = insertFormatNodesIntoCaretContainer([
            ...parents2,
            ...cleanedFormatNode.toArray(),
            ...parentsAfter
          ], newCaretContainer);
          if (caretContainer) {
            removeCaretContainerNode(editor, caretContainer, isNonNullable(caretContainer));
          }
          selection.setCursorLocation(caretTextNode, 1);
          normalizeNbspsBetween(editor, newCaretContainer);
          if (dom2.isEmpty(formatNode)) {
            dom2.remove(formatNode);
          }
        }
      };
      const disableCaretContainer = (editor, keyCode, moveCaret2) => {
        const selection = editor.selection, body = editor.getBody();
        removeCaretContainer(editor, null, moveCaret2);
        if ((keyCode === 8 || keyCode === 46) && selection.isCollapsed() && selection.getStart().innerHTML === ZWSP) {
          removeCaretContainer(editor, getParentCaretContainer(body, selection.getStart()), true);
        }
        if (keyCode === 37 || keyCode === 39) {
          removeCaretContainer(editor, getParentCaretContainer(body, selection.getStart()), true);
        }
      };
      const endsWithNbsp = (element) => isText$b(element) && endsWith(element.data, nbsp);
      const setup$v = (editor) => {
        editor.on("mouseup keydown", (e) => {
          disableCaretContainer(editor, e.keyCode, endsWithNbsp(editor.selection.getRng().endContainer));
        });
      };
      const createCaretFormat = (formatNodes) => {
        const caretContainer = createCaretContainer(false);
        const innerMost = insertFormatNodesIntoCaretContainer(formatNodes, caretContainer.dom);
        return {
          caretContainer,
          caretPosition: CaretPosition(innerMost, 0)
        };
      };
      const replaceWithCaretFormat = (targetNode, formatNodes) => {
        const { caretContainer, caretPosition } = createCaretFormat(formatNodes);
        before$3(SugarElement.fromDom(targetNode), caretContainer);
        remove$4(SugarElement.fromDom(targetNode));
        return caretPosition;
      };
      const createCaretFormatAtStart$1 = (rng, formatNodes) => {
        const { caretContainer, caretPosition } = createCaretFormat(formatNodes);
        rng.insertNode(caretContainer.dom);
        return caretPosition;
      };
      const isFormatElement = (editor, element) => {
        if (isCaretNode(element.dom)) {
          return false;
        }
        const inlineElements = editor.schema.getTextInlineElements();
        return has$2(inlineElements, name(element)) && !isCaretNode(element.dom) && !isBogus$1(element.dom);
      };
      const postProcessHooks = {};
      const isPre = matchNodeNames(["pre"]);
      const addPostProcessHook = (name2, hook) => {
        const hooks = postProcessHooks[name2];
        if (!hooks) {
          postProcessHooks[name2] = [];
        }
        postProcessHooks[name2].push(hook);
      };
      const postProcess$1 = (name2, editor) => {
        if (has$2(postProcessHooks, name2)) {
          each$e(postProcessHooks[name2], (hook) => {
            hook(editor);
          });
        }
      };
      addPostProcessHook("pre", (editor) => {
        const rng = editor.selection.getRng();
        const hasPreSibling = (blocks) => (pre) => {
          const prev2 = pre.previousSibling;
          return isPre(prev2) && contains$2(blocks, prev2);
        };
        const joinPre = (pre1, pre2) => {
          const sPre2 = SugarElement.fromDom(pre2);
          const doc = documentOrOwner(sPre2).dom;
          remove$4(sPre2);
          append(SugarElement.fromDom(pre1), [
            SugarElement.fromTag("br", doc),
            SugarElement.fromTag("br", doc),
            ...children$1(sPre2)
          ]);
        };
        if (!rng.collapsed) {
          const blocks = editor.selection.getSelectedBlocks();
          const preBlocks = filter$5(filter$5(blocks, isPre), hasPreSibling(blocks));
          each$e(preBlocks, (pre) => {
            joinPre(pre.previousSibling, pre);
          });
        }
      });
      const listItemStyles = [
        "fontWeight",
        "fontStyle",
        "color",
        "fontSize",
        "fontFamily"
      ];
      const hasListStyles = (fmt) => isObject(fmt.styles) && exists(keys(fmt.styles), (name2) => contains$2(listItemStyles, name2));
      const findExpandedListItemFormat = (formats) => find$2(formats, (fmt) => isInlineFormat(fmt) && fmt.inline === "span" && hasListStyles(fmt));
      const getExpandedListItemFormat = (formatter, format) => {
        const formatList = formatter.get(format);
        return isArray$1(formatList) ? findExpandedListItemFormat(formatList) : Optional.none();
      };
      const isRngStartAtStartOfElement = (rng, elm) => prevPosition(elm, CaretPosition.fromRangeStart(rng)).isNone();
      const isRngEndAtEndOfElement = (rng, elm) => {
        return nextPosition(elm, CaretPosition.fromRangeEnd(rng)).exists((pos) => !isBr$6(pos.getNode()) || nextPosition(elm, pos).isSome()) === false;
      };
      const isEditableListItem = (dom2) => (elm) => isListItem$2(elm) && dom2.isEditable(elm);
      const getFullySelectedBlocks = (selection) => {
        const blocks = selection.getSelectedBlocks();
        const rng = selection.getRng();
        if (selection.isCollapsed()) {
          return [];
        }
        if (blocks.length === 1) {
          return isRngStartAtStartOfElement(rng, blocks[0]) && isRngEndAtEndOfElement(rng, blocks[0]) ? blocks : [];
        } else {
          const first2 = head(blocks).filter((elm) => isRngStartAtStartOfElement(rng, elm)).toArray();
          const last2 = last$2(blocks).filter((elm) => isRngEndAtEndOfElement(rng, elm)).toArray();
          const middle = blocks.slice(1, -1);
          return first2.concat(middle).concat(last2);
        }
      };
      const getFullySelectedListItems = (selection) => filter$5(getFullySelectedBlocks(selection), isEditableListItem(selection.dom));
      const getPartiallySelectedListItems = (selection) => filter$5(selection.getSelectedBlocks(), isEditableListItem(selection.dom));
      const each$8 = Tools.each;
      const isElementNode = (node) => isElement$6(node) && !isBookmarkNode$1(node) && !isCaretNode(node) && !isBogus$1(node);
      const findElementSibling = (node, siblingName) => {
        for (let sibling2 = node; sibling2; sibling2 = sibling2[siblingName]) {
          if (isText$b(sibling2) && isNotEmpty(sibling2.data)) {
            return node;
          }
          if (isElement$6(sibling2) && !isBookmarkNode$1(sibling2)) {
            return sibling2;
          }
        }
        return node;
      };
      const mergeSiblingsNodes = (editor, prev2, next2) => {
        const elementUtils = ElementUtils(editor);
        const isPrevEditable = isHTMLElement(prev2) && editor.dom.isEditable(prev2);
        const isNextEditable = isHTMLElement(next2) && editor.dom.isEditable(next2);
        if (isPrevEditable && isNextEditable) {
          const prevSibling2 = findElementSibling(prev2, "previousSibling");
          const nextSibling2 = findElementSibling(next2, "nextSibling");
          if (elementUtils.compare(prevSibling2, nextSibling2)) {
            for (let sibling2 = prevSibling2.nextSibling; sibling2 && sibling2 !== nextSibling2; ) {
              const tmpSibling = sibling2;
              sibling2 = sibling2.nextSibling;
              prevSibling2.appendChild(tmpSibling);
            }
            editor.dom.remove(nextSibling2);
            Tools.each(Tools.grep(nextSibling2.childNodes), (node) => {
              prevSibling2.appendChild(node);
            });
            return prevSibling2;
          }
        }
        return next2;
      };
      const mergeSiblings = (editor, format, vars, node) => {
        var _a;
        if (node && format.merge_siblings !== false) {
          const newNode = (_a = mergeSiblingsNodes(editor, getNonWhiteSpaceSibling(node), node)) !== null && _a !== void 0 ? _a : node;
          mergeSiblingsNodes(editor, newNode, getNonWhiteSpaceSibling(newNode, true));
        }
      };
      const clearChildStyles = (dom2, format, node) => {
        if (format.clear_child_styles) {
          const selector = format.links ? "*:not(a)" : "*";
          each$8(dom2.select(selector, node), (childNode) => {
            if (isElementNode(childNode) && dom2.isEditable(childNode)) {
              each$8(format.styles, (_value, name2) => {
                dom2.setStyle(childNode, name2, "");
              });
            }
          });
        }
      };
      const processChildElements = (node, filter2, process2) => {
        each$8(node.childNodes, (node2) => {
          if (isElementNode(node2)) {
            if (filter2(node2)) {
              process2(node2);
            }
            if (node2.hasChildNodes()) {
              processChildElements(node2, filter2, process2);
            }
          }
        });
      };
      const unwrapEmptySpan = (dom2, node) => {
        if (node.nodeName === "SPAN" && dom2.getAttribs(node).length === 0) {
          dom2.remove(node, true);
        }
      };
      const hasStyle = (dom2, name2) => (node) => !!(node && getStyle(dom2, node, name2));
      const applyStyle = (dom2, name2, value2) => (node) => {
        dom2.setStyle(node, name2, value2);
        if (node.getAttribute("style") === "") {
          node.removeAttribute("style");
        }
        unwrapEmptySpan(dom2, node);
      };
      const removeResult = Adt.generate([
        { keep: [] },
        { rename: ["name"] },
        { removed: [] }
      ]);
      const MCE_ATTR_RE = /^(src|href|style)$/;
      const each$7 = Tools.each;
      const isEq$2 = isEq$5;
      const isTableCellOrRow = (node) => /^(TR|TH|TD)$/.test(node.nodeName);
      const isChildOfInlineParent = (dom2, node, parent2) => dom2.isChildOf(node, parent2) && node !== parent2 && !dom2.isBlock(parent2);
      const getContainer = (ed, rng, start2) => {
        let container = rng[start2 ? "startContainer" : "endContainer"];
        let offset = rng[start2 ? "startOffset" : "endOffset"];
        if (isElement$6(container)) {
          const lastIdx = container.childNodes.length - 1;
          if (!start2 && offset) {
            offset--;
          }
          container = container.childNodes[offset > lastIdx ? lastIdx : offset];
        }
        if (isText$b(container) && start2 && offset >= container.data.length) {
          container = new DomTreeWalker(container, ed.getBody()).next() || container;
        }
        if (isText$b(container) && !start2 && offset === 0) {
          container = new DomTreeWalker(container, ed.getBody()).prev() || container;
        }
        return container;
      };
      const normalizeTableSelection = (node, start2) => {
        const prop = start2 ? "firstChild" : "lastChild";
        const childNode = node[prop];
        if (isTableCellOrRow(node) && childNode) {
          if (node.nodeName === "TR") {
            return childNode[prop] || childNode;
          } else {
            return childNode;
          }
        }
        return node;
      };
      const wrap$1 = (dom2, node, name2, attrs) => {
        var _a;
        const wrapper = dom2.create(name2, attrs);
        (_a = node.parentNode) === null || _a === void 0 ? void 0 : _a.insertBefore(wrapper, node);
        wrapper.appendChild(node);
        return wrapper;
      };
      const wrapWithSiblings = (dom2, node, next2, name2, attrs) => {
        const start2 = SugarElement.fromDom(node);
        const wrapper = SugarElement.fromDom(dom2.create(name2, attrs));
        const siblings2 = next2 ? nextSiblings(start2) : prevSiblings(start2);
        append(wrapper, siblings2);
        if (next2) {
          before$3(start2, wrapper);
          prepend(wrapper, start2);
        } else {
          after$4(start2, wrapper);
          append$1(wrapper, start2);
        }
        return wrapper.dom;
      };
      const isColorFormatAndAnchor = (node, format) => format.links && node.nodeName === "A";
      const removeNode = (ed, node, format) => {
        const parentNode = node.parentNode;
        let rootBlockElm;
        const dom2 = ed.dom;
        const forcedRootBlock = getForcedRootBlock(ed);
        if (isBlockFormat(format)) {
          if (parentNode === dom2.getRoot()) {
            if (!format.list_block || !isEq$2(node, format.list_block)) {
              each$e(from(node.childNodes), (node2) => {
                if (isValid(ed, forcedRootBlock, node2.nodeName.toLowerCase())) {
                  if (!rootBlockElm) {
                    rootBlockElm = wrap$1(dom2, node2, forcedRootBlock);
                    dom2.setAttribs(rootBlockElm, getForcedRootBlockAttrs(ed));
                  } else {
                    rootBlockElm.appendChild(node2);
                  }
                } else {
                  rootBlockElm = null;
                }
              });
            }
          }
        }
        if (isMixedFormat(format) && !isEq$2(format.inline, node)) {
          return;
        }
        dom2.remove(node, true);
      };
      const processFormatAttrOrStyle = (name2, value2, vars) => {
        if (isNumber(name2)) {
          return {
            name: value2,
            value: null
          };
        } else {
          return {
            name: name2,
            value: replaceVars(value2, vars)
          };
        }
      };
      const removeEmptyStyleAttributeIfNeeded = (dom2, elm) => {
        if (dom2.getAttrib(elm, "style") === "") {
          elm.removeAttribute("style");
          elm.removeAttribute("data-mce-style");
        }
      };
      const removeStyles = (dom2, elm, format, vars, compareNode) => {
        let stylesModified = false;
        each$7(format.styles, (value2, name2) => {
          const {
            name: styleName,
            value: styleValue
          } = processFormatAttrOrStyle(name2, value2, vars);
          const normalizedStyleValue = normalizeStyleValue(styleValue, styleName);
          if (format.remove_similar || isNull(styleValue) || !isElement$6(compareNode) || isEq$2(getStyle(dom2, compareNode, styleName), normalizedStyleValue)) {
            dom2.setStyle(elm, styleName, "");
          }
          stylesModified = true;
        });
        if (stylesModified) {
          removeEmptyStyleAttributeIfNeeded(dom2, elm);
        }
      };
      const removeListStyleFormats = (editor, name2, vars) => {
        if (name2 === "removeformat") {
          each$e(getPartiallySelectedListItems(editor.selection), (li) => {
            each$e(listItemStyles, (name3) => editor.dom.setStyle(li, name3, ""));
            removeEmptyStyleAttributeIfNeeded(editor.dom, li);
          });
        } else {
          getExpandedListItemFormat(editor.formatter, name2).each((liFmt) => {
            each$e(getPartiallySelectedListItems(editor.selection), (li) => removeStyles(editor.dom, li, liFmt, vars, null));
          });
        }
      };
      const removeNodeFormatInternal = (ed, format, vars, node, compareNode) => {
        const dom2 = ed.dom;
        const elementUtils = ElementUtils(ed);
        const schema = ed.schema;
        if (isInlineFormat(format) && isTransparentElementName(schema, format.inline) && isTransparentBlock(schema, node) && node.parentElement === ed.getBody()) {
          removeNode(ed, node, format);
          return removeResult.removed();
        }
        if (!format.ceFalseOverride && node && dom2.getContentEditableParent(node) === "false") {
          return removeResult.keep();
        }
        if (node && !matchName(dom2, node, format) && !isColorFormatAndAnchor(node, format)) {
          return removeResult.keep();
        }
        const elm = node;
        const preserveAttributes = format.preserve_attributes;
        if (isInlineFormat(format) && format.remove === "all" && isArray$1(preserveAttributes)) {
          const attrsToPreserve = filter$5(dom2.getAttribs(elm), (attr) => contains$2(preserveAttributes, attr.name.toLowerCase()));
          dom2.removeAllAttribs(elm);
          each$e(attrsToPreserve, (attr) => dom2.setAttrib(elm, attr.name, attr.value));
          if (attrsToPreserve.length > 0) {
            return removeResult.rename("span");
          }
        }
        if (format.remove !== "all") {
          removeStyles(dom2, elm, format, vars, compareNode);
          each$7(format.attributes, (value2, name2) => {
            const {
              name: attrName,
              value: attrValue
            } = processFormatAttrOrStyle(name2, value2, vars);
            if (format.remove_similar || isNull(attrValue) || !isElement$6(compareNode) || isEq$2(dom2.getAttrib(compareNode, attrName), attrValue)) {
              if (attrName === "class") {
                const currentValue = dom2.getAttrib(elm, attrName);
                if (currentValue) {
                  let valueOut = "";
                  each$e(currentValue.split(/\s+/), (cls) => {
                    if (/mce\-\w+/.test(cls)) {
                      valueOut += (valueOut ? " " : "") + cls;
                    }
                  });
                  if (valueOut) {
                    dom2.setAttrib(elm, attrName, valueOut);
                    return;
                  }
                }
              }
              if (MCE_ATTR_RE.test(attrName)) {
                elm.removeAttribute("data-mce-" + attrName);
              }
              if (attrName === "style" && matchNodeNames(["li"])(elm) && dom2.getStyle(elm, "list-style-type") === "none") {
                elm.removeAttribute(attrName);
                dom2.setStyle(elm, "list-style-type", "none");
                return;
              }
              if (attrName === "class") {
                elm.removeAttribute("className");
              }
              elm.removeAttribute(attrName);
            }
          });
          each$7(format.classes, (value2) => {
            value2 = replaceVars(value2, vars);
            if (!isElement$6(compareNode) || dom2.hasClass(compareNode, value2)) {
              dom2.removeClass(elm, value2);
            }
          });
          const attrs = dom2.getAttribs(elm);
          for (let i = 0; i < attrs.length; i++) {
            const attrName = attrs[i].nodeName;
            if (!elementUtils.isAttributeInternal(attrName)) {
              return removeResult.keep();
            }
          }
        }
        if (format.remove !== "none") {
          removeNode(ed, elm, format);
          return removeResult.removed();
        }
        return removeResult.keep();
      };
      const findFormatRoot = (editor, container, name2, vars, similar) => {
        let formatRoot;
        if (container.parentNode) {
          each$e(getParents$2(editor.dom, container.parentNode).reverse(), (parent2) => {
            if (!formatRoot && isElement$6(parent2) && parent2.id !== "_start" && parent2.id !== "_end") {
              const format = matchNode(editor, parent2, name2, vars, similar);
              if (format && format.split !== false) {
                formatRoot = parent2;
              }
            }
          });
        }
        return formatRoot;
      };
      const removeNodeFormatFromClone = (editor, format, vars, clone2) => removeNodeFormatInternal(editor, format, vars, clone2, clone2).fold(constant(clone2), (newName) => {
        const fragment = editor.dom.createFragment();
        fragment.appendChild(clone2);
        return editor.dom.rename(clone2, newName);
      }, constant(null));
      const wrapAndSplit = (editor, formatList, formatRoot, container, target, split2, format, vars) => {
        var _a, _b;
        let lastClone;
        let firstClone;
        const dom2 = editor.dom;
        if (formatRoot) {
          const formatRootParent = formatRoot.parentNode;
          for (let parent2 = container.parentNode; parent2 && parent2 !== formatRootParent; parent2 = parent2.parentNode) {
            let clone2 = dom2.clone(parent2, false);
            for (let i = 0; i < formatList.length; i++) {
              clone2 = removeNodeFormatFromClone(editor, formatList[i], vars, clone2);
              if (clone2 === null) {
                break;
              }
            }
            if (clone2) {
              if (lastClone) {
                clone2.appendChild(lastClone);
              }
              if (!firstClone) {
                firstClone = clone2;
              }
              lastClone = clone2;
            }
          }
          if (split2 && (!format.mixed || !dom2.isBlock(formatRoot))) {
            container = (_a = dom2.split(formatRoot, container)) !== null && _a !== void 0 ? _a : container;
          }
          if (lastClone && firstClone) {
            (_b = target.parentNode) === null || _b === void 0 ? void 0 : _b.insertBefore(lastClone, target);
            firstClone.appendChild(target);
            if (isInlineFormat(format)) {
              mergeSiblings(editor, format, vars, lastClone);
            }
          }
        }
        return container;
      };
      const removeFormatInternal = (ed, name2, vars, node, similar) => {
        const formatList = ed.formatter.get(name2);
        const format = formatList[0];
        const dom2 = ed.dom;
        const selection = ed.selection;
        const splitToFormatRoot = (container) => {
          const formatRoot = findFormatRoot(ed, container, name2, vars, similar);
          return wrapAndSplit(ed, formatList, formatRoot, container, container, true, format, vars);
        };
        const isRemoveBookmarkNode = (node2) => isBookmarkNode$1(node2) && isElement$6(node2) && (node2.id === "_start" || node2.id === "_end");
        const removeFormatOnNode = (node2) => exists(formatList, (fmt) => removeNodeFormat(ed, fmt, vars, node2, node2));
        const process2 = (node2) => {
          const children2 = from(node2.childNodes);
          const removed = removeFormatOnNode(node2);
          const currentNodeMatches = removed || exists(formatList, (f) => matchName(dom2, node2, f));
          const parentNode = node2.parentNode;
          if (!currentNodeMatches && isNonNullable(parentNode) && shouldExpandToSelector(format)) {
            removeFormatOnNode(parentNode);
          }
          if (format.deep) {
            if (children2.length) {
              for (let i = 0; i < children2.length; i++) {
                process2(children2[i]);
              }
            }
          }
          const textDecorations = [
            "underline",
            "line-through",
            "overline"
          ];
          each$e(textDecorations, (decoration) => {
            if (isElement$6(node2) && ed.dom.getStyle(node2, "text-decoration") === decoration && node2.parentNode && getTextDecoration(dom2, node2.parentNode) === decoration) {
              removeNodeFormat(ed, {
                deep: false,
                exact: true,
                inline: "span",
                styles: { textDecoration: decoration }
              }, void 0, node2);
            }
          });
        };
        const unwrap2 = (start2) => {
          const node2 = dom2.get(start2 ? "_start" : "_end");
          if (node2) {
            let out = node2[start2 ? "firstChild" : "lastChild"];
            if (isRemoveBookmarkNode(out)) {
              out = out[start2 ? "firstChild" : "lastChild"];
            }
            if (isText$b(out) && out.data.length === 0) {
              out = start2 ? node2.previousSibling || node2.nextSibling : node2.nextSibling || node2.previousSibling;
            }
            dom2.remove(node2, true);
            return out;
          } else {
            return null;
          }
        };
        const removeRngStyle = (rng) => {
          let startContainer;
          let endContainer;
          let expandedRng = expandRng(dom2, rng, formatList, { includeTrailingSpace: rng.collapsed });
          if (format.split) {
            expandedRng = split(expandedRng);
            startContainer = getContainer(ed, expandedRng, true);
            endContainer = getContainer(ed, expandedRng);
            if (startContainer !== endContainer) {
              startContainer = normalizeTableSelection(startContainer, true);
              endContainer = normalizeTableSelection(endContainer, false);
              if (isChildOfInlineParent(dom2, startContainer, endContainer)) {
                const marker = Optional.from(startContainer.firstChild).getOr(startContainer);
                splitToFormatRoot(wrapWithSiblings(dom2, marker, true, "span", {
                  "id": "_start",
                  "data-mce-type": "bookmark"
                }));
                unwrap2(true);
                return;
              }
              if (isChildOfInlineParent(dom2, endContainer, startContainer)) {
                const marker = Optional.from(endContainer.lastChild).getOr(endContainer);
                splitToFormatRoot(wrapWithSiblings(dom2, marker, false, "span", {
                  "id": "_end",
                  "data-mce-type": "bookmark"
                }));
                unwrap2(false);
                return;
              }
              startContainer = wrap$1(dom2, startContainer, "span", {
                "id": "_start",
                "data-mce-type": "bookmark"
              });
              endContainer = wrap$1(dom2, endContainer, "span", {
                "id": "_end",
                "data-mce-type": "bookmark"
              });
              const newRng = dom2.createRng();
              newRng.setStartAfter(startContainer);
              newRng.setEndBefore(endContainer);
              walk$3(dom2, newRng, (nodes) => {
                each$e(nodes, (n) => {
                  if (!isBookmarkNode$1(n) && !isBookmarkNode$1(n.parentNode)) {
                    splitToFormatRoot(n);
                  }
                });
              });
              splitToFormatRoot(startContainer);
              splitToFormatRoot(endContainer);
              startContainer = unwrap2(true);
              endContainer = unwrap2();
            } else {
              startContainer = endContainer = splitToFormatRoot(startContainer);
            }
            expandedRng.startContainer = startContainer.parentNode ? startContainer.parentNode : startContainer;
            expandedRng.startOffset = dom2.nodeIndex(startContainer);
            expandedRng.endContainer = endContainer.parentNode ? endContainer.parentNode : endContainer;
            expandedRng.endOffset = dom2.nodeIndex(endContainer) + 1;
          }
          walk$3(dom2, expandedRng, (nodes) => {
            each$e(nodes, process2);
          });
        };
        if (node) {
          if (isNode(node)) {
            const rng = dom2.createRng();
            rng.setStartBefore(node);
            rng.setEndAfter(node);
            removeRngStyle(rng);
          } else {
            removeRngStyle(node);
          }
          fireFormatRemove(ed, name2, node, vars);
          return;
        }
        if (!selection.isCollapsed() || !isInlineFormat(format) || getCellsFromEditor(ed).length) {
          preserveSelection(ed, () => runOnRanges(ed, removeRngStyle), (startNode) => isInlineFormat(format) && match$2(ed, name2, vars, startNode));
          ed.nodeChanged();
        } else {
          removeCaretFormat(ed, name2, vars, similar);
        }
        removeListStyleFormats(ed, name2, vars);
        fireFormatRemove(ed, name2, node, vars);
      };
      const removeFormat$1 = (ed, name2, vars, node, similar) => {
        if (node || ed.selection.isEditable()) {
          removeFormatInternal(ed, name2, vars, node, similar);
        }
      };
      const removeNodeFormat = (editor, format, vars, node, compareNode) => {
        return removeNodeFormatInternal(editor, format, vars, node, compareNode).fold(never, (newName) => {
          editor.dom.rename(node, newName);
          return true;
        }, always);
      };
      const each$6 = Tools.each;
      const mergeTextDecorationsAndColor = (dom2, format, vars, node) => {
        const processTextDecorationsAndColor = (n) => {
          if (isHTMLElement(n) && isElement$6(n.parentNode) && dom2.isEditable(n)) {
            const parentTextDecoration = getTextDecoration(dom2, n.parentNode);
            if (dom2.getStyle(n, "color") && parentTextDecoration) {
              dom2.setStyle(n, "text-decoration", parentTextDecoration);
            } else if (dom2.getStyle(n, "text-decoration") === parentTextDecoration) {
              dom2.setStyle(n, "text-decoration", null);
            }
          }
        };
        if (format.styles && (format.styles.color || format.styles.textDecoration)) {
          Tools.walk(node, processTextDecorationsAndColor, "childNodes");
          processTextDecorationsAndColor(node);
        }
      };
      const mergeBackgroundColorAndFontSize = (dom2, format, vars, node) => {
        if (format.styles && format.styles.backgroundColor) {
          const hasFontSize = hasStyle(dom2, "fontSize");
          processChildElements(node, (elm) => hasFontSize(elm) && dom2.isEditable(elm), applyStyle(dom2, "backgroundColor", replaceVars(format.styles.backgroundColor, vars)));
        }
      };
      const mergeSubSup = (dom2, format, vars, node) => {
        if (isInlineFormat(format) && (format.inline === "sub" || format.inline === "sup")) {
          const hasFontSize = hasStyle(dom2, "fontSize");
          processChildElements(node, (elm) => hasFontSize(elm) && dom2.isEditable(elm), applyStyle(dom2, "fontSize", ""));
          const inverseTagDescendants = filter$5(dom2.select(format.inline === "sup" ? "sub" : "sup", node), dom2.isEditable);
          dom2.remove(inverseTagDescendants, true);
        }
      };
      const mergeWithChildren = (editor, formatList, vars, node) => {
        each$6(formatList, (format) => {
          if (isInlineFormat(format)) {
            each$6(editor.dom.select(format.inline, node), (child2) => {
              if (isElementNode(child2)) {
                removeNodeFormat(editor, format, vars, child2, format.exact ? child2 : null);
              }
            });
          }
          clearChildStyles(editor.dom, format, node);
        });
      };
      const mergeWithParents = (editor, format, name2, vars, node) => {
        const parentNode = node.parentNode;
        if (matchNode(editor, parentNode, name2, vars)) {
          if (removeNodeFormat(editor, format, vars, node)) {
            return;
          }
        }
        if (format.merge_with_parents && parentNode) {
          editor.dom.getParent(parentNode, (parent2) => {
            if (matchNode(editor, parent2, name2, vars)) {
              removeNodeFormat(editor, format, vars, node);
              return true;
            } else {
              return false;
            }
          });
        }
      };
      const each$5 = Tools.each;
      const canFormatBR = (editor, format, node, parentName) => {
        if (canFormatEmptyLines(editor) && isInlineFormat(format) && node.parentNode) {
          const validBRParentElements = getTextRootBlockElements(editor.schema);
          const hasCaretNodeSibling = sibling(SugarElement.fromDom(node), (sibling2) => isCaretNode(sibling2.dom));
          return hasNonNullableKey(validBRParentElements, parentName) && isEmptyNode(editor.schema, node.parentNode, {
            skipBogus: false,
            includeZwsp: true
          }) && !hasCaretNodeSibling;
        } else {
          return false;
        }
      };
      const applyStyles = (dom2, elm, format, vars) => {
        each$5(format.styles, (value2, name2) => {
          dom2.setStyle(elm, name2, replaceVars(value2, vars));
        });
        if (format.styles) {
          const styleVal = dom2.getAttrib(elm, "style");
          if (styleVal) {
            dom2.setAttrib(elm, "data-mce-style", styleVal);
          }
        }
      };
      const applyFormatAction = (ed, name2, vars, node) => {
        const formatList = ed.formatter.get(name2);
        const format = formatList[0];
        const isCollapsed = !node && ed.selection.isCollapsed();
        const dom2 = ed.dom;
        const selection = ed.selection;
        const setElementFormat = (elm, fmt = format) => {
          if (isFunction(fmt.onformat)) {
            fmt.onformat(elm, fmt, vars, node);
          }
          applyStyles(dom2, elm, fmt, vars);
          each$5(fmt.attributes, (value2, name3) => {
            dom2.setAttrib(elm, name3, replaceVars(value2, vars));
          });
          each$5(fmt.classes, (value2) => {
            const newValue = replaceVars(value2, vars);
            if (!dom2.hasClass(elm, newValue)) {
              dom2.addClass(elm, newValue);
            }
          });
        };
        const applyNodeStyle = (formatList2, node2) => {
          let found = false;
          each$5(formatList2, (format2) => {
            if (!isSelectorFormat(format2)) {
              return false;
            }
            if (dom2.getContentEditable(node2) === "false" && !format2.ceFalseOverride) {
              return true;
            }
            if (isNonNullable(format2.collapsed) && format2.collapsed !== isCollapsed) {
              return true;
            }
            if (dom2.is(node2, format2.selector) && !isCaretNode(node2)) {
              setElementFormat(node2, format2);
              found = true;
              return false;
            }
            return true;
          });
          return found;
        };
        const createWrapElement = (wrapName) => {
          if (isString(wrapName)) {
            const wrapElm = dom2.create(wrapName);
            setElementFormat(wrapElm);
            return wrapElm;
          } else {
            return null;
          }
        };
        const applyRngStyle = (dom3, rng, nodeSpecific) => {
          const newWrappers = [];
          let contentEditable = true;
          const wrapName = format.inline || format.block;
          const wrapElm = createWrapElement(wrapName);
          const isMatchingWrappingBlock = (node2) => isWrappingBlockFormat(format) && matchNode(ed, node2, name2, vars);
          const canRenameBlock = (node2, parentName, isEditableDescendant) => {
            const isValidBlockFormatForNode = isNonWrappingBlockFormat(format) && isTextBlock$1(ed.schema, node2) && isValid(ed, parentName, wrapName);
            return isEditableDescendant && isValidBlockFormatForNode;
          };
          const canWrapNode = (node2, parentName, isEditableDescendant, isWrappableNoneditableElm) => {
            const nodeName = node2.nodeName.toLowerCase();
            const isValidWrapNode = isValid(ed, wrapName, nodeName) && isValid(ed, parentName, wrapName);
            const isZwsp$12 = !nodeSpecific && isText$b(node2) && isZwsp(node2.data);
            const isCaret = isCaretNode(node2);
            const isCorrectFormatForNode = !isInlineFormat(format) || !dom3.isBlock(node2);
            return (isEditableDescendant || isWrappableNoneditableElm) && isValidWrapNode && !isZwsp$12 && !isCaret && isCorrectFormatForNode;
          };
          walk$3(dom3, rng, (nodes) => {
            let currentWrapElm;
            const process2 = (node2) => {
              let hasContentEditableState2 = false;
              let lastContentEditable = contentEditable;
              let isWrappableNoneditableElm = false;
              const parentNode = node2.parentNode;
              const parentName = parentNode.nodeName.toLowerCase();
              const contentEditableValue = dom3.getContentEditable(node2);
              if (isNonNullable(contentEditableValue)) {
                lastContentEditable = contentEditable;
                contentEditable = contentEditableValue === "true";
                hasContentEditableState2 = true;
                isWrappableNoneditableElm = isWrappableNoneditable(ed, node2);
              }
              const isEditableDescendant = contentEditable && !hasContentEditableState2;
              if (isBr$6(node2) && !canFormatBR(ed, format, node2, parentName)) {
                currentWrapElm = null;
                if (isBlockFormat(format)) {
                  dom3.remove(node2);
                }
                return;
              }
              if (isMatchingWrappingBlock(node2)) {
                currentWrapElm = null;
                return;
              }
              if (canRenameBlock(node2, parentName, isEditableDescendant)) {
                const elm = dom3.rename(node2, wrapName);
                setElementFormat(elm);
                newWrappers.push(elm);
                currentWrapElm = null;
                return;
              }
              if (isSelectorFormat(format)) {
                let found = applyNodeStyle(formatList, node2);
                if (!found && isNonNullable(parentNode) && shouldExpandToSelector(format)) {
                  found = applyNodeStyle(formatList, parentNode);
                }
                if (!isInlineFormat(format) || found) {
                  currentWrapElm = null;
                  return;
                }
              }
              if (isNonNullable(wrapElm) && canWrapNode(node2, parentName, isEditableDescendant, isWrappableNoneditableElm)) {
                if (!currentWrapElm) {
                  currentWrapElm = dom3.clone(wrapElm, false);
                  parentNode.insertBefore(currentWrapElm, node2);
                  newWrappers.push(currentWrapElm);
                }
                if (isWrappableNoneditableElm && hasContentEditableState2) {
                  contentEditable = lastContentEditable;
                }
                currentWrapElm.appendChild(node2);
              } else {
                currentWrapElm = null;
                each$e(from(node2.childNodes), process2);
                if (hasContentEditableState2) {
                  contentEditable = lastContentEditable;
                }
                currentWrapElm = null;
              }
            };
            each$e(nodes, process2);
          });
          if (format.links === true) {
            each$e(newWrappers, (node2) => {
              const process2 = (node3) => {
                if (node3.nodeName === "A") {
                  setElementFormat(node3, format);
                }
                each$e(from(node3.childNodes), process2);
              };
              process2(node2);
            });
          }
          each$e(newWrappers, (node2) => {
            const getChildCount = (node3) => {
              let count2 = 0;
              each$e(node3.childNodes, (node4) => {
                if (!isEmptyTextNode$1(node4) && !isBookmarkNode$1(node4)) {
                  count2++;
                }
              });
              return count2;
            };
            const mergeStyles = (node3) => {
              const childElement = find$2(node3.childNodes, isElementNode$1).filter((child2) => dom3.getContentEditable(child2) !== "false" && matchName(dom3, child2, format));
              return childElement.map((child2) => {
                const clone2 = dom3.clone(child2, false);
                setElementFormat(clone2);
                dom3.replace(clone2, node3, true);
                dom3.remove(child2, true);
                return clone2;
              }).getOr(node3);
            };
            const childCount = getChildCount(node2);
            if ((newWrappers.length > 1 || !dom3.isBlock(node2)) && childCount === 0) {
              dom3.remove(node2, true);
              return;
            }
            if (isInlineFormat(format) || isBlockFormat(format) && format.wrapper) {
              if (!format.exact && childCount === 1) {
                node2 = mergeStyles(node2);
              }
              mergeWithChildren(ed, formatList, vars, node2);
              mergeWithParents(ed, format, name2, vars, node2);
              mergeBackgroundColorAndFontSize(dom3, format, vars, node2);
              mergeTextDecorationsAndColor(dom3, format, vars, node2);
              mergeSubSup(dom3, format, vars, node2);
              mergeSiblings(ed, format, vars, node2);
            }
          });
        };
        const targetNode = isNode(node) ? node : selection.getNode();
        if (dom2.getContentEditable(targetNode) === "false" && !isWrappableNoneditable(ed, targetNode)) {
          node = targetNode;
          applyNodeStyle(formatList, node);
          fireFormatApply(ed, name2, node, vars);
          return;
        }
        if (format) {
          if (node) {
            if (isNode(node)) {
              if (!applyNodeStyle(formatList, node)) {
                const rng = dom2.createRng();
                rng.setStartBefore(node);
                rng.setEndAfter(node);
                applyRngStyle(dom2, expandRng(dom2, rng, formatList), true);
              }
            } else {
              applyRngStyle(dom2, node, true);
            }
          } else {
            if (!isCollapsed || !isInlineFormat(format) || getCellsFromEditor(ed).length) {
              selection.setRng(normalize(selection.getRng()));
              preserveSelection(ed, () => {
                runOnRanges(ed, (selectionRng, fake) => {
                  const expandedRng = fake ? selectionRng : expandRng(dom2, selectionRng, formatList);
                  applyRngStyle(dom2, expandedRng, false);
                });
              }, always);
              ed.nodeChanged();
            } else {
              applyCaretFormat(ed, name2, vars);
            }
            getExpandedListItemFormat(ed.formatter, name2).each((liFmt) => {
              each$e(getFullySelectedListItems(ed.selection), (li) => applyStyles(dom2, li, liFmt, vars));
            });
          }
          postProcess$1(name2, ed);
        }
        fireFormatApply(ed, name2, node, vars);
      };
      const applyFormat$1 = (editor, name2, vars, node) => {
        if (node || editor.selection.isEditable()) {
          applyFormatAction(editor, name2, vars, node);
        }
      };
      const hasVars = (value2) => has$2(value2, "vars");
      const setup$u = (registeredFormatListeners, editor) => {
        registeredFormatListeners.set({});
        editor.on("NodeChange", (e) => {
          updateAndFireChangeCallbacks(editor, e.element, registeredFormatListeners.get());
        });
        editor.on("FormatApply FormatRemove", (e) => {
          const element = Optional.from(e.node).map((nodeOrRange) => isNode(nodeOrRange) ? nodeOrRange : nodeOrRange.startContainer).bind((node) => isElement$6(node) ? Optional.some(node) : Optional.from(node.parentElement)).getOrThunk(() => fallbackElement(editor));
          updateAndFireChangeCallbacks(editor, element, registeredFormatListeners.get());
        });
      };
      const fallbackElement = (editor) => editor.selection.getStart();
      const matchingNode = (editor, parents2, format, similar, vars) => {
        const isMatchingNode = (node) => {
          const matchingFormat = editor.formatter.matchNode(node, format, vars !== null && vars !== void 0 ? vars : {}, similar);
          return !isUndefined(matchingFormat);
        };
        const isUnableToMatch = (node) => {
          if (matchesUnInheritedFormatSelector(editor, node, format)) {
            return true;
          } else {
            if (!similar) {
              return isNonNullable(editor.formatter.matchNode(node, format, vars, true));
            } else {
              return false;
            }
          }
        };
        return findUntil$1(parents2, isMatchingNode, isUnableToMatch);
      };
      const getParents = (editor, elm) => {
        const element = elm !== null && elm !== void 0 ? elm : fallbackElement(editor);
        return filter$5(getParents$2(editor.dom, element), (node) => isElement$6(node) && !isBogus$1(node));
      };
      const updateAndFireChangeCallbacks = (editor, elm, registeredCallbacks) => {
        const parents2 = getParents(editor, elm);
        each$d(registeredCallbacks, (data2, format) => {
          const runIfChanged = (spec) => {
            const match2 = matchingNode(editor, parents2, format, spec.similar, hasVars(spec) ? spec.vars : void 0);
            const isSet = match2.isSome();
            if (spec.state.get() !== isSet) {
              spec.state.set(isSet);
              const node = match2.getOr(elm);
              if (hasVars(spec)) {
                spec.callback(isSet, {
                  node,
                  format,
                  parents: parents2
                });
              } else {
                each$e(spec.callbacks, (callback) => callback(isSet, {
                  node,
                  format,
                  parents: parents2
                }));
              }
            }
          };
          each$e([
            data2.withSimilar,
            data2.withoutSimilar
          ], runIfChanged);
          each$e(data2.withVars, runIfChanged);
        });
      };
      const addListeners = (editor, registeredFormatListeners, formats, callback, similar, vars) => {
        const formatChangeItems = registeredFormatListeners.get();
        each$e(formats.split(","), (format) => {
          const group = get$a(formatChangeItems, format).getOrThunk(() => {
            const base = {
              withSimilar: {
                state: Cell(false),
                similar: true,
                callbacks: []
              },
              withoutSimilar: {
                state: Cell(false),
                similar: false,
                callbacks: []
              },
              withVars: []
            };
            formatChangeItems[format] = base;
            return base;
          });
          const getCurrent = () => {
            const parents2 = getParents(editor);
            return matchingNode(editor, parents2, format, similar, vars).isSome();
          };
          if (isUndefined(vars)) {
            const toAppendTo = similar ? group.withSimilar : group.withoutSimilar;
            toAppendTo.callbacks.push(callback);
            if (toAppendTo.callbacks.length === 1) {
              toAppendTo.state.set(getCurrent());
            }
          } else {
            group.withVars.push({
              state: Cell(getCurrent()),
              similar,
              vars,
              callback
            });
          }
        });
        registeredFormatListeners.set(formatChangeItems);
      };
      const removeListeners = (registeredFormatListeners, formats, callback) => {
        const formatChangeItems = registeredFormatListeners.get();
        each$e(formats.split(","), (format) => get$a(formatChangeItems, format).each((group) => {
          formatChangeItems[format] = {
            withSimilar: {
              ...group.withSimilar,
              callbacks: filter$5(group.withSimilar.callbacks, (cb) => cb !== callback)
            },
            withoutSimilar: {
              ...group.withoutSimilar,
              callbacks: filter$5(group.withoutSimilar.callbacks, (cb) => cb !== callback)
            },
            withVars: filter$5(group.withVars, (item) => item.callback !== callback)
          };
        }));
        registeredFormatListeners.set(formatChangeItems);
      };
      const formatChangedInternal = (editor, registeredFormatListeners, formats, callback, similar, vars) => {
        addListeners(editor, registeredFormatListeners, formats, callback, similar, vars);
        return { unbind: () => removeListeners(registeredFormatListeners, formats, callback) };
      };
      const toggle = (editor, name2, vars, node) => {
        const fmt = editor.formatter.get(name2);
        if (fmt) {
          if (match$2(editor, name2, vars, node) && (!("toggle" in fmt[0]) || fmt[0].toggle)) {
            removeFormat$1(editor, name2, vars, node);
          } else {
            applyFormat$1(editor, name2, vars, node);
          }
        }
      };
      const explode$1 = Tools.explode;
      const create$8 = () => {
        const filters = {};
        const addFilter = (name2, callback) => {
          each$e(explode$1(name2), (name3) => {
            if (!has$2(filters, name3)) {
              filters[name3] = {
                name: name3,
                callbacks: []
              };
            }
            filters[name3].callbacks.push(callback);
          });
        };
        const getFilters = () => values(filters);
        const removeFilter = (name2, callback) => {
          each$e(explode$1(name2), (name3) => {
            if (has$2(filters, name3)) {
              if (isNonNullable(callback)) {
                const filter2 = filters[name3];
                const newCallbacks = filter$5(filter2.callbacks, (c) => c !== callback);
                if (newCallbacks.length > 0) {
                  filter2.callbacks = newCallbacks;
                } else {
                  delete filters[name3];
                }
              } else {
                delete filters[name3];
              }
            }
          });
        };
        return {
          addFilter,
          getFilters,
          removeFilter
        };
      };
      const removeAttrs = (node, names) => {
        each$e(names, (name2) => {
          node.attr(name2, null);
        });
      };
      const addFontToSpansFilter = (domParser, styles, fontSizes) => {
        domParser.addNodeFilter("font", (nodes) => {
          each$e(nodes, (node) => {
            const props = styles.parse(node.attr("style"));
            const color = node.attr("color");
            const face = node.attr("face");
            const size = node.attr("size");
            if (color) {
              props.color = color;
            }
            if (face) {
              props["font-family"] = face;
            }
            if (size) {
              toInt(size).each((num) => {
                props["font-size"] = fontSizes[num - 1];
              });
            }
            node.name = "span";
            node.attr("style", styles.serialize(props));
            removeAttrs(node, [
              "color",
              "face",
              "size"
            ]);
          });
        });
      };
      const addStrikeFilter = (domParser, schema, styles) => {
        domParser.addNodeFilter("strike", (nodes) => {
          const convertToSTag = schema.type !== "html4";
          each$e(nodes, (node) => {
            if (convertToSTag) {
              node.name = "s";
            } else {
              const props = styles.parse(node.attr("style"));
              props["text-decoration"] = "line-through";
              node.name = "span";
              node.attr("style", styles.serialize(props));
            }
          });
        });
      };
      const addFilters = (domParser, settings, schema) => {
        var _a;
        const styles = Styles();
        if (settings.convert_fonts_to_spans) {
          addFontToSpansFilter(domParser, styles, Tools.explode((_a = settings.font_size_legacy_values) !== null && _a !== void 0 ? _a : ""));
        }
        addStrikeFilter(domParser, schema, styles);
      };
      const register$5 = (domParser, settings, schema) => {
        if (settings.inline_styles) {
          addFilters(domParser, settings, schema);
        }
      };
      const blobUriToBlob = (url) => fetch(url).then((res) => res.ok ? res.blob() : Promise.reject()).catch(() => Promise.reject({
        message: `Cannot convert ${url} to Blob. Resource might not exist or is inaccessible.`,
        uriType: "blob"
      }));
      const extractBase64Data = (data2) => {
        const matches = /([a-z0-9+\/=\s]+)/i.exec(data2);
        return matches ? matches[1] : "";
      };
      const decodeData = (data2) => {
        try {
          return decodeURIComponent(data2);
        } catch (_a) {
          return data2;
        }
      };
      const parseDataUri = (uri) => {
        const [type2, ...rest] = uri.split(",");
        const data2 = rest.join(",");
        const matches = /data:([^/]+\/[^;]+)(;.+)?/.exec(type2);
        if (matches) {
          const base64Encoded = matches[2] === ";base64";
          const decodedData = decodeData(data2);
          const extractedData = base64Encoded ? extractBase64Data(decodedData) : decodedData;
          return Optional.some({
            type: matches[1],
            data: extractedData,
            base64Encoded
          });
        } else {
          return Optional.none();
        }
      };
      const buildBlob = (type2, data2, base64Encoded = true) => {
        let str = data2;
        if (base64Encoded) {
          try {
            str = atob(data2);
          } catch (_a) {
            return Optional.none();
          }
        }
        const arr = new Uint8Array(str.length);
        for (let i = 0; i < arr.length; i++) {
          arr[i] = str.charCodeAt(i);
        }
        return Optional.some(new Blob([arr], { type: type2 }));
      };
      const dataUriToBlob = (uri) => {
        return new Promise((resolve2, reject) => {
          parseDataUri(uri).bind(({ type: type2, data: data2, base64Encoded }) => buildBlob(type2, data2, base64Encoded)).fold(() => reject("Invalid data URI"), resolve2);
        });
      };
      const uriToBlob = (url) => {
        if (startsWith(url, "blob:")) {
          return blobUriToBlob(url);
        } else if (startsWith(url, "data:")) {
          return dataUriToBlob(url);
        } else {
          return Promise.reject("Unknown URI format");
        }
      };
      const blobToDataUri = (blob) => {
        return new Promise((resolve2, reject) => {
          const reader = new FileReader();
          reader.onloadend = () => {
            resolve2(reader.result);
          };
          reader.onerror = () => {
            var _a;
            reject((_a = reader.error) === null || _a === void 0 ? void 0 : _a.message);
          };
          reader.readAsDataURL(blob);
        });
      };
      let count$1 = 0;
      const uniqueId$1 = (prefix) => {
        return (prefix || "blobid") + count$1++;
      };
      const processDataUri = (dataUri, base64Only, generateBlobInfo) => {
        return parseDataUri(dataUri).bind(({ data: data2, type: type2, base64Encoded }) => {
          if (base64Only && !base64Encoded) {
            return Optional.none();
          } else {
            const base64 = base64Encoded ? data2 : btoa(data2);
            return generateBlobInfo(base64, type2);
          }
        });
      };
      const createBlobInfo$1 = (blobCache, blob, base64) => {
        const blobInfo = blobCache.create(uniqueId$1(), blob, base64);
        blobCache.add(blobInfo);
        return blobInfo;
      };
      const dataUriToBlobInfo = (blobCache, dataUri, base64Only = false) => {
        return processDataUri(dataUri, base64Only, (base64, type2) => Optional.from(blobCache.getByData(base64, type2)).orThunk(() => buildBlob(type2, base64).map((blob) => createBlobInfo$1(blobCache, blob, base64))));
      };
      const imageToBlobInfo = (blobCache, imageSrc) => {
        const invalidDataUri = () => Promise.reject("Invalid data URI");
        if (startsWith(imageSrc, "blob:")) {
          const blobInfo = blobCache.getByUri(imageSrc);
          if (isNonNullable(blobInfo)) {
            return Promise.resolve(blobInfo);
          } else {
            return uriToBlob(imageSrc).then((blob) => {
              return blobToDataUri(blob).then((dataUri) => {
                return processDataUri(dataUri, false, (base64) => {
                  return Optional.some(createBlobInfo$1(blobCache, blob, base64));
                }).getOrThunk(invalidDataUri);
              });
            });
          }
        } else if (startsWith(imageSrc, "data:")) {
          return dataUriToBlobInfo(blobCache, imageSrc).fold(invalidDataUri, (blobInfo) => Promise.resolve(blobInfo));
        } else {
          return Promise.reject("Unknown image data format");
        }
      };
      const hostCaptureRegex = /^(?:(?:(?:[A-Za-z][A-Za-z\d.+-]{0,14}:\/\/(?:[-.~*+=!&;:'%@?^${}(),\w]+@)?|www\.|[-;:&=+$,.\w]+@)([A-Za-z\d-]+(?:\.[A-Za-z\d-]+)*))(?::\d+)?(?:\/(?:[-.~*+=!;:'%@$(),\/\w]*[-~*+=%@$()\/\w])?)?(?:\?(?:[-.~*+=!&;:'%@?^${}(),\/\w]+)?)?(?:#(?:[-.~*+=!&;:'%@?^${}(),\/\w]+)?)?)$/;
      const extractHost = (url) => Optional.from(url.match(hostCaptureRegex)).bind((ms) => get$b(ms, 1)).map((h) => startsWith(h, "www.") ? h.substring(4) : h);
      const sandboxIframe = (iframeNode, exclusions) => {
        if (Optional.from(iframeNode.attr("src")).bind(extractHost).forall((host) => !contains$2(exclusions, host))) {
          iframeNode.attr("sandbox", "");
        }
      };
      const isMimeType = (mime, type2) => startsWith(mime, `${type2}/`);
      const getEmbedType = (type2) => {
        if (isUndefined(type2)) {
          return "iframe";
        } else if (isMimeType(type2, "image")) {
          return "img";
        } else if (isMimeType(type2, "video")) {
          return "video";
        } else if (isMimeType(type2, "audio")) {
          return "audio";
        } else {
          return "iframe";
        }
      };
      const createSafeEmbed = ({ type: type2, src, width, height } = {}, sandboxIframes, sandboxIframesExclusions) => {
        const name2 = getEmbedType(type2);
        const embed = new AstNode(name2, 1);
        embed.attr(name2 === "audio" ? { src } : {
          src,
          width,
          height
        });
        if (name2 === "audio" || name2 === "video") {
          embed.attr("controls", "");
        }
        if (name2 === "iframe" && sandboxIframes) {
          sandboxIframe(embed, sandboxIframesExclusions);
        }
        return embed;
      };
      const isBogusImage = (img) => isNonNullable(img.attr("data-mce-bogus"));
      const isInternalImageSource = (img) => img.attr("src") === Env.transparentSrc || isNonNullable(img.attr("data-mce-placeholder"));
      const registerBase64ImageFilter = (parser, settings) => {
        const { blob_cache: blobCache } = settings;
        if (blobCache) {
          const processImage = (img) => {
            const inputSrc = img.attr("src");
            if (isInternalImageSource(img) || isBogusImage(img) || isNullable(inputSrc)) {
              return;
            }
            dataUriToBlobInfo(blobCache, inputSrc, true).each((blobInfo) => {
              img.attr("src", blobInfo.blobUri());
            });
          };
          parser.addAttributeFilter("src", (nodes) => each$e(nodes, processImage));
        }
      };
      const register$4 = (parser, settings) => {
        var _a, _b;
        const schema = parser.schema;
        parser.addAttributeFilter("href", (nodes) => {
          let i = nodes.length;
          const appendRel = (rel) => {
            const parts = rel.split(" ").filter((p) => p.length > 0);
            return parts.concat(["noopener"]).sort().join(" ");
          };
          const addNoOpener = (rel) => {
            const newRel = rel ? Tools.trim(rel) : "";
            if (!/\b(noopener)\b/g.test(newRel)) {
              return appendRel(newRel);
            } else {
              return newRel;
            }
          };
          if (!settings.allow_unsafe_link_target) {
            while (i--) {
              const node = nodes[i];
              if (node.name === "a" && node.attr("target") === "_blank") {
                node.attr("rel", addNoOpener(node.attr("rel")));
              }
            }
          }
        });
        if (!settings.allow_html_in_named_anchor) {
          parser.addAttributeFilter("id,name", (nodes) => {
            let i = nodes.length, sibling2, prevSibling2, parent2, node;
            while (i--) {
              node = nodes[i];
              if (node.name === "a" && node.firstChild && !node.attr("href")) {
                parent2 = node.parent;
                sibling2 = node.lastChild;
                while (sibling2 && parent2) {
                  prevSibling2 = sibling2.prev;
                  parent2.insert(sibling2, node);
                  sibling2 = prevSibling2;
                }
              }
            }
          });
        }
        if (settings.fix_list_elements) {
          parser.addNodeFilter("ul,ol", (nodes) => {
            let i = nodes.length, node, parentNode;
            while (i--) {
              node = nodes[i];
              parentNode = node.parent;
              if (parentNode && (parentNode.name === "ul" || parentNode.name === "ol")) {
                if (node.prev && node.prev.name === "li") {
                  node.prev.append(node);
                } else {
                  const li = new AstNode("li", 1);
                  li.attr("style", "list-style-type: none");
                  node.wrap(li);
                }
              }
            }
          });
        }
        const validClasses = schema.getValidClasses();
        if (settings.validate && validClasses) {
          parser.addAttributeFilter("class", (nodes) => {
            var _a2;
            let i = nodes.length;
            while (i--) {
              const node = nodes[i];
              const clazz = (_a2 = node.attr("class")) !== null && _a2 !== void 0 ? _a2 : "";
              const classList = Tools.explode(clazz, " ");
              let classValue = "";
              for (let ci = 0; ci < classList.length; ci++) {
                const className = classList[ci];
                let valid = false;
                let validClassesMap = validClasses["*"];
                if (validClassesMap && validClassesMap[className]) {
                  valid = true;
                }
                validClassesMap = validClasses[node.name];
                if (!valid && validClassesMap && validClassesMap[className]) {
                  valid = true;
                }
                if (valid) {
                  if (classValue) {
                    classValue += " ";
                  }
                  classValue += className;
                }
              }
              if (!classValue.length) {
                classValue = null;
              }
              node.attr("class", classValue);
            }
          });
        }
        registerBase64ImageFilter(parser, settings);
        const shouldSandboxIframes2 = (_a = settings.sandbox_iframes) !== null && _a !== void 0 ? _a : false;
        const sandboxIframesExclusions = unique$1((_b = settings.sandbox_iframes_exclusions) !== null && _b !== void 0 ? _b : []);
        if (settings.convert_unsafe_embeds) {
          parser.addNodeFilter("object,embed", (nodes) => each$e(nodes, (node) => {
            node.replace(createSafeEmbed({
              type: node.attr("type"),
              src: node.name === "object" ? node.attr("data") : node.attr("src"),
              width: node.attr("width"),
              height: node.attr("height")
            }, shouldSandboxIframes2, sandboxIframesExclusions));
          }));
        }
        if (shouldSandboxIframes2) {
          parser.addNodeFilter("iframe", (nodes) => each$e(nodes, (node) => sandboxIframe(node, sandboxIframesExclusions)));
        }
      };
      const {
        entries,
        setPrototypeOf,
        isFrozen,
        getPrototypeOf,
        getOwnPropertyDescriptor
      } = Object;
      let {
        freeze,
        seal,
        create: create$7
      } = Object;
      let {
        apply,
        construct
      } = typeof Reflect !== "undefined" && Reflect;
      if (!freeze) {
        freeze = function freeze2(x) {
          return x;
        };
      }
      if (!seal) {
        seal = function seal2(x) {
          return x;
        };
      }
      if (!apply) {
        apply = function apply2(fun, thisValue, args) {
          return fun.apply(thisValue, args);
        };
      }
      if (!construct) {
        construct = function construct2(Func, args) {
          return new Func(...args);
        };
      }
      const arrayForEach = unapply(Array.prototype.forEach);
      const arrayLastIndexOf = unapply(Array.prototype.lastIndexOf);
      const arrayPop = unapply(Array.prototype.pop);
      const arrayPush = unapply(Array.prototype.push);
      const arraySplice = unapply(Array.prototype.splice);
      const stringToLowerCase = unapply(String.prototype.toLowerCase);
      const stringToString = unapply(String.prototype.toString);
      const stringMatch = unapply(String.prototype.match);
      const stringReplace = unapply(String.prototype.replace);
      const stringIndexOf = unapply(String.prototype.indexOf);
      const stringTrim = unapply(String.prototype.trim);
      const objectHasOwnProperty = unapply(Object.prototype.hasOwnProperty);
      const regExpTest = unapply(RegExp.prototype.test);
      const typeErrorCreate = unconstruct(TypeError);
      function unapply(func) {
        return function(thisArg) {
          for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
          }
          return apply(func, thisArg, args);
        };
      }
      function unconstruct(func) {
        return function() {
          for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
            args[_key2] = arguments[_key2];
          }
          return construct(func, args);
        };
      }
      function addToSet(set2, array) {
        let transformCaseFunc = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : stringToLowerCase;
        if (setPrototypeOf) {
          setPrototypeOf(set2, null);
        }
        let l = array.length;
        while (l--) {
          let element = array[l];
          if (typeof element === "string") {
            const lcElement = transformCaseFunc(element);
            if (lcElement !== element) {
              if (!isFrozen(array)) {
                array[l] = lcElement;
              }
              element = lcElement;
            }
          }
          set2[element] = true;
        }
        return set2;
      }
      function cleanArray(array) {
        for (let index = 0; index < array.length; index++) {
          const isPropertyExist = objectHasOwnProperty(array, index);
          if (!isPropertyExist) {
            array[index] = null;
          }
        }
        return array;
      }
      function clone(object) {
        const newObject = create$7(null);
        for (const [property, value2] of entries(object)) {
          const isPropertyExist = objectHasOwnProperty(object, property);
          if (isPropertyExist) {
            if (Array.isArray(value2)) {
              newObject[property] = cleanArray(value2);
            } else if (value2 && typeof value2 === "object" && value2.constructor === Object) {
              newObject[property] = clone(value2);
            } else {
              newObject[property] = value2;
            }
          }
        }
        return newObject;
      }
      function lookupGetter(object, prop) {
        while (object !== null) {
          const desc = getOwnPropertyDescriptor(object, prop);
          if (desc) {
            if (desc.get) {
              return unapply(desc.get);
            }
            if (typeof desc.value === "function") {
              return unapply(desc.value);
            }
          }
          object = getPrototypeOf(object);
        }
        function fallbackValue() {
          return null;
        }
        return fallbackValue;
      }
      const html$1 = freeze(["a", "abbr", "acronym", "address", "area", "article", "aside", "audio", "b", "bdi", "bdo", "big", "blink", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "content", "data", "datalist", "dd", "decorator", "del", "details", "dfn", "dialog", "dir", "div", "dl", "dt", "element", "em", "fieldset", "figcaption", "figure", "font", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "img", "input", "ins", "kbd", "label", "legend", "li", "main", "map", "mark", "marquee", "menu", "menuitem", "meter", "nav", "nobr", "ol", "optgroup", "option", "output", "p", "picture", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "section", "select", "shadow", "small", "source", "spacer", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"]);
      const svg$1 = freeze(["svg", "a", "altglyph", "altglyphdef", "altglyphitem", "animatecolor", "animatemotion", "animatetransform", "circle", "clippath", "defs", "desc", "ellipse", "filter", "font", "g", "glyph", "glyphref", "hkern", "image", "line", "lineargradient", "marker", "mask", "metadata", "mpath", "path", "pattern", "polygon", "polyline", "radialgradient", "rect", "stop", "style", "switch", "symbol", "text", "textpath", "title", "tref", "tspan", "view", "vkern"]);
      const svgFilters = freeze(["feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feDropShadow", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence"]);
      const svgDisallowed = freeze(["animate", "color-profile", "cursor", "discard", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "foreignobject", "hatch", "hatchpath", "mesh", "meshgradient", "meshpatch", "meshrow", "missing-glyph", "script", "set", "solidcolor", "unknown", "use"]);
      const mathMl$1 = freeze(["math", "menclose", "merror", "mfenced", "mfrac", "mglyph", "mi", "mlabeledtr", "mmultiscripts", "mn", "mo", "mover", "mpadded", "mphantom", "mroot", "mrow", "ms", "mspace", "msqrt", "mstyle", "msub", "msup", "msubsup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover", "mprescripts"]);
      const mathMlDisallowed = freeze(["maction", "maligngroup", "malignmark", "mlongdiv", "mscarries", "mscarry", "msgroup", "mstack", "msline", "msrow", "semantics", "annotation", "annotation-xml", "mprescripts", "none"]);
      const text = freeze(["#text"]);
      const html = freeze(["accept", "action", "align", "alt", "autocapitalize", "autocomplete", "autopictureinpicture", "autoplay", "background", "bgcolor", "border", "capture", "cellpadding", "cellspacing", "checked", "cite", "class", "clear", "color", "cols", "colspan", "controls", "controlslist", "coords", "crossorigin", "datetime", "decoding", "default", "dir", "disabled", "disablepictureinpicture", "disableremoteplayback", "download", "draggable", "enctype", "enterkeyhint", "face", "for", "headers", "height", "hidden", "high", "href", "hreflang", "id", "inputmode", "integrity", "ismap", "kind", "label", "lang", "list", "loading", "loop", "low", "max", "maxlength", "media", "method", "min", "minlength", "multiple", "muted", "name", "nonce", "noshade", "novalidate", "nowrap", "open", "optimum", "pattern", "placeholder", "playsinline", "popover", "popovertarget", "popovertargetaction", "poster", "preload", "pubdate", "radiogroup", "readonly", "rel", "required", "rev", "reversed", "role", "rows", "rowspan", "spellcheck", "scope", "selected", "shape", "size", "sizes", "span", "srclang", "start", "src", "srcset", "step", "style", "summary", "tabindex", "title", "translate", "type", "usemap", "valign", "value", "width", "wrap", "xmlns", "slot"]);
      const svg = freeze(["accent-height", "accumulate", "additive", "alignment-baseline", "amplitude", "ascent", "attributename", "attributetype", "azimuth", "basefrequency", "baseline-shift", "begin", "bias", "by", "class", "clip", "clippathunits", "clip-path", "clip-rule", "color", "color-interpolation", "color-interpolation-filters", "color-profile", "color-rendering", "cx", "cy", "d", "dx", "dy", "diffuseconstant", "direction", "display", "divisor", "dur", "edgemode", "elevation", "end", "exponent", "fill", "fill-opacity", "fill-rule", "filter", "filterunits", "flood-color", "flood-opacity", "font-family", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-variant", "font-weight", "fx", "fy", "g1", "g2", "glyph-name", "glyphref", "gradientunits", "gradienttransform", "height", "href", "id", "image-rendering", "in", "in2", "intercept", "k", "k1", "k2", "k3", "k4", "kerning", "keypoints", "keysplines", "keytimes", "lang", "lengthadjust", "letter-spacing", "kernelmatrix", "kernelunitlength", "lighting-color", "local", "marker-end", "marker-mid", "marker-start", "markerheight", "markerunits", "markerwidth", "maskcontentunits", "maskunits", "max", "mask", "media", "method", "mode", "min", "name", "numoctaves", "offset", "operator", "opacity", "order", "orient", "orientation", "origin", "overflow", "paint-order", "path", "pathlength", "patterncontentunits", "patterntransform", "patternunits", "points", "preservealpha", "preserveaspectratio", "primitiveunits", "r", "rx", "ry", "radius", "refx", "refy", "repeatcount", "repeatdur", "restart", "result", "rotate", "scale", "seed", "shape-rendering", "slope", "specularconstant", "specularexponent", "spreadmethod", "startoffset", "stddeviation", "stitchtiles", "stop-color", "stop-opacity", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke", "stroke-width", "style", "surfacescale", "systemlanguage", "tabindex", "tablevalues", "targetx", "targety", "transform", "transform-origin", "text-anchor", "text-decoration", "text-rendering", "textlength", "type", "u1", "u2", "unicode", "values", "viewbox", "visibility", "version", "vert-adv-y", "vert-origin-x", "vert-origin-y", "width", "word-spacing", "wrap", "writing-mode", "xchannelselector", "ychannelselector", "x", "x1", "x2", "xmlns", "y", "y1", "y2", "z", "zoomandpan"]);
      const mathMl = freeze(["accent", "accentunder", "align", "bevelled", "close", "columnsalign", "columnlines", "columnspan", "denomalign", "depth", "dir", "display", "displaystyle", "encoding", "fence", "frame", "height", "href", "id", "largeop", "length", "linethickness", "lspace", "lquote", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minsize", "movablelimits", "notation", "numalign", "open", "rowalign", "rowlines", "rowspacing", "rowspan", "rspace", "rquote", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "selection", "separator", "separators", "stretchy", "subscriptshift", "supscriptshift", "symmetric", "voffset", "width", "xmlns"]);
      const xml = freeze(["xlink:href", "xml:id", "xlink:title", "xml:space", "xmlns:xlink"]);
      const MUSTACHE_EXPR = seal(/\{\{[\w\W]*|[\w\W]*\}\}/gm);
      const ERB_EXPR = seal(/<%[\w\W]*|[\w\W]*%>/gm);
      const TMPLIT_EXPR = seal(/\$\{[\w\W]*/gm);
      const DATA_ATTR = seal(/^data-[\-\w.\u00B7-\uFFFF]+$/);
      const ARIA_ATTR = seal(/^aria-[\-\w]+$/);
      const IS_ALLOWED_URI = seal(
        /^(?:(?:(?:f|ht)tps?|mailto|tel|callto|sms|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i
        // eslint-disable-line no-useless-escape
      );
      const IS_SCRIPT_OR_DATA = seal(/^(?:\w+script|data):/i);
      const ATTR_WHITESPACE = seal(
        /[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g
        // eslint-disable-line no-control-regex
      );
      const DOCTYPE_NAME = seal(/^html$/i);
      const CUSTOM_ELEMENT = seal(/^[a-z][.\w]*(-[.\w]+)+$/i);
      var EXPRESSIONS = Object.freeze({
        __proto__: null,
        ARIA_ATTR,
        ATTR_WHITESPACE,
        CUSTOM_ELEMENT,
        DATA_ATTR,
        DOCTYPE_NAME,
        ERB_EXPR,
        IS_ALLOWED_URI,
        IS_SCRIPT_OR_DATA,
        MUSTACHE_EXPR,
        TMPLIT_EXPR
      });
      const NODE_TYPE = {
        element: 1,
        attribute: 2,
        text: 3,
        cdataSection: 4,
        entityReference: 5,
        // Deprecated
        entityNode: 6,
        // Deprecated
        progressingInstruction: 7,
        comment: 8,
        document: 9,
        documentType: 10,
        documentFragment: 11,
        notation: 12
        // Deprecated
      };
      const getGlobal = function getGlobal2() {
        return typeof window === "undefined" ? null : window;
      };
      const _createTrustedTypesPolicy = function _createTrustedTypesPolicy2(trustedTypes, purifyHostElement) {
        if (typeof trustedTypes !== "object" || typeof trustedTypes.createPolicy !== "function") {
          return null;
        }
        let suffix = null;
        const ATTR_NAME = "data-tt-policy-suffix";
        if (purifyHostElement && purifyHostElement.hasAttribute(ATTR_NAME)) {
          suffix = purifyHostElement.getAttribute(ATTR_NAME);
        }
        const policyName = "dompurify" + (suffix ? "#" + suffix : "");
        try {
          return trustedTypes.createPolicy(policyName, {
            createHTML(html2) {
              return html2;
            },
            createScriptURL(scriptUrl) {
              return scriptUrl;
            }
          });
        } catch (_) {
          console.warn("TrustedTypes policy " + policyName + " could not be created.");
          return null;
        }
      };
      const _createHooksMap = function _createHooksMap2() {
        return {
          afterSanitizeAttributes: [],
          afterSanitizeElements: [],
          afterSanitizeShadowDOM: [],
          beforeSanitizeAttributes: [],
          beforeSanitizeElements: [],
          beforeSanitizeShadowDOM: [],
          uponSanitizeAttribute: [],
          uponSanitizeElement: [],
          uponSanitizeShadowNode: []
        };
      };
      function createDOMPurify() {
        let window2 = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : getGlobal();
        const DOMPurify = (root) => createDOMPurify(root);
        DOMPurify.version = "3.2.4";
        DOMPurify.removed = [];
        if (!window2 || !window2.document || window2.document.nodeType !== NODE_TYPE.document || !window2.Element) {
          DOMPurify.isSupported = false;
          return DOMPurify;
        }
        let {
          document: document2
        } = window2;
        const originalDocument = document2;
        const currentScript = originalDocument.currentScript;
        const {
          DocumentFragment,
          HTMLTemplateElement,
          Node,
          Element,
          NodeFilter: NodeFilter2,
          NamedNodeMap = window2.NamedNodeMap || window2.MozNamedAttrMap,
          HTMLFormElement,
          DOMParser: DOMParser2,
          trustedTypes
        } = window2;
        const ElementPrototype = Element.prototype;
        const cloneNode = lookupGetter(ElementPrototype, "cloneNode");
        const remove2 = lookupGetter(ElementPrototype, "remove");
        const getNextSibling = lookupGetter(ElementPrototype, "nextSibling");
        const getChildNodes2 = lookupGetter(ElementPrototype, "childNodes");
        const getParentNode = lookupGetter(ElementPrototype, "parentNode");
        if (typeof HTMLTemplateElement === "function") {
          const template = document2.createElement("template");
          if (template.content && template.content.ownerDocument) {
            document2 = template.content.ownerDocument;
          }
        }
        let trustedTypesPolicy;
        let emptyHTML = "";
        const {
          implementation,
          createNodeIterator,
          createDocumentFragment,
          getElementsByTagName
        } = document2;
        const {
          importNode: importNode2
        } = originalDocument;
        let hooks = _createHooksMap();
        DOMPurify.isSupported = typeof entries === "function" && typeof getParentNode === "function" && implementation && implementation.createHTMLDocument !== void 0;
        const {
          MUSTACHE_EXPR: MUSTACHE_EXPR2,
          ERB_EXPR: ERB_EXPR2,
          TMPLIT_EXPR: TMPLIT_EXPR2,
          DATA_ATTR: DATA_ATTR2,
          ARIA_ATTR: ARIA_ATTR2,
          IS_SCRIPT_OR_DATA: IS_SCRIPT_OR_DATA2,
          ATTR_WHITESPACE: ATTR_WHITESPACE2,
          CUSTOM_ELEMENT: CUSTOM_ELEMENT2
        } = EXPRESSIONS;
        let {
          IS_ALLOWED_URI: IS_ALLOWED_URI$1
        } = EXPRESSIONS;
        let ALLOWED_TAGS = null;
        const DEFAULT_ALLOWED_TAGS = addToSet({}, [...html$1, ...svg$1, ...svgFilters, ...mathMl$1, ...text]);
        let ALLOWED_ATTR = null;
        const DEFAULT_ALLOWED_ATTR = addToSet({}, [...html, ...svg, ...mathMl, ...xml]);
        let CUSTOM_ELEMENT_HANDLING = Object.seal(create$7(null, {
          tagNameCheck: {
            writable: true,
            configurable: false,
            enumerable: true,
            value: null
          },
          attributeNameCheck: {
            writable: true,
            configurable: false,
            enumerable: true,
            value: null
          },
          allowCustomizedBuiltInElements: {
            writable: true,
            configurable: false,
            enumerable: true,
            value: false
          }
        }));
        let FORBID_TAGS = null;
        let FORBID_ATTR = null;
        let ALLOW_ARIA_ATTR = true;
        let ALLOW_DATA_ATTR = true;
        let ALLOW_UNKNOWN_PROTOCOLS = false;
        let ALLOW_SELF_CLOSE_IN_ATTR = true;
        let SAFE_FOR_TEMPLATES = false;
        let SAFE_FOR_XML = true;
        let WHOLE_DOCUMENT = false;
        let SET_CONFIG = false;
        let FORCE_BODY = false;
        let RETURN_DOM = false;
        let RETURN_DOM_FRAGMENT = false;
        let RETURN_TRUSTED_TYPE = false;
        let SANITIZE_DOM = true;
        let SANITIZE_NAMED_PROPS = false;
        const SANITIZE_NAMED_PROPS_PREFIX = "user-content-";
        let KEEP_CONTENT = true;
        let IN_PLACE = false;
        let USE_PROFILES = {};
        let FORBID_CONTENTS = null;
        const DEFAULT_FORBID_CONTENTS = addToSet({}, ["annotation-xml", "audio", "colgroup", "desc", "foreignobject", "head", "iframe", "math", "mi", "mn", "mo", "ms", "mtext", "noembed", "noframes", "noscript", "plaintext", "script", "style", "svg", "template", "thead", "title", "video", "xmp"]);
        let DATA_URI_TAGS = null;
        const DEFAULT_DATA_URI_TAGS = addToSet({}, ["audio", "video", "img", "source", "image", "track"]);
        let URI_SAFE_ATTRIBUTES = null;
        const DEFAULT_URI_SAFE_ATTRIBUTES = addToSet({}, ["alt", "class", "for", "id", "label", "name", "pattern", "placeholder", "role", "summary", "title", "value", "style", "xmlns"]);
        const MATHML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
        const SVG_NAMESPACE = "http://www.w3.org/2000/svg";
        const HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
        let NAMESPACE = HTML_NAMESPACE;
        let IS_EMPTY_INPUT = false;
        let ALLOWED_NAMESPACES = null;
        const DEFAULT_ALLOWED_NAMESPACES = addToSet({}, [MATHML_NAMESPACE, SVG_NAMESPACE, HTML_NAMESPACE], stringToString);
        let MATHML_TEXT_INTEGRATION_POINTS = addToSet({}, ["mi", "mo", "mn", "ms", "mtext"]);
        let HTML_INTEGRATION_POINTS = addToSet({}, ["annotation-xml"]);
        const COMMON_SVG_AND_HTML_ELEMENTS = addToSet({}, ["title", "style", "font", "a", "script"]);
        let PARSER_MEDIA_TYPE = null;
        const SUPPORTED_PARSER_MEDIA_TYPES = ["application/xhtml+xml", "text/html"];
        const DEFAULT_PARSER_MEDIA_TYPE = "text/html";
        let transformCaseFunc = null;
        let CONFIG = null;
        const formElement = document2.createElement("form");
        const isRegexOrFunction = function isRegexOrFunction2(testValue) {
          return testValue instanceof RegExp || testValue instanceof Function;
        };
        const _parseConfig = function _parseConfig2() {
          let cfg = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
          if (CONFIG && CONFIG === cfg) {
            return;
          }
          if (!cfg || typeof cfg !== "object") {
            cfg = {};
          }
          cfg = clone(cfg);
          PARSER_MEDIA_TYPE = // eslint-disable-next-line unicorn/prefer-includes
          SUPPORTED_PARSER_MEDIA_TYPES.indexOf(cfg.PARSER_MEDIA_TYPE) === -1 ? DEFAULT_PARSER_MEDIA_TYPE : cfg.PARSER_MEDIA_TYPE;
          transformCaseFunc = PARSER_MEDIA_TYPE === "application/xhtml+xml" ? stringToString : stringToLowerCase;
          ALLOWED_TAGS = objectHasOwnProperty(cfg, "ALLOWED_TAGS") ? addToSet({}, cfg.ALLOWED_TAGS, transformCaseFunc) : DEFAULT_ALLOWED_TAGS;
          ALLOWED_ATTR = objectHasOwnProperty(cfg, "ALLOWED_ATTR") ? addToSet({}, cfg.ALLOWED_ATTR, transformCaseFunc) : DEFAULT_ALLOWED_ATTR;
          ALLOWED_NAMESPACES = objectHasOwnProperty(cfg, "ALLOWED_NAMESPACES") ? addToSet({}, cfg.ALLOWED_NAMESPACES, stringToString) : DEFAULT_ALLOWED_NAMESPACES;
          URI_SAFE_ATTRIBUTES = objectHasOwnProperty(cfg, "ADD_URI_SAFE_ATTR") ? addToSet(clone(DEFAULT_URI_SAFE_ATTRIBUTES), cfg.ADD_URI_SAFE_ATTR, transformCaseFunc) : DEFAULT_URI_SAFE_ATTRIBUTES;
          DATA_URI_TAGS = objectHasOwnProperty(cfg, "ADD_DATA_URI_TAGS") ? addToSet(clone(DEFAULT_DATA_URI_TAGS), cfg.ADD_DATA_URI_TAGS, transformCaseFunc) : DEFAULT_DATA_URI_TAGS;
          FORBID_CONTENTS = objectHasOwnProperty(cfg, "FORBID_CONTENTS") ? addToSet({}, cfg.FORBID_CONTENTS, transformCaseFunc) : DEFAULT_FORBID_CONTENTS;
          FORBID_TAGS = objectHasOwnProperty(cfg, "FORBID_TAGS") ? addToSet({}, cfg.FORBID_TAGS, transformCaseFunc) : {};
          FORBID_ATTR = objectHasOwnProperty(cfg, "FORBID_ATTR") ? addToSet({}, cfg.FORBID_ATTR, transformCaseFunc) : {};
          USE_PROFILES = objectHasOwnProperty(cfg, "USE_PROFILES") ? cfg.USE_PROFILES : false;
          ALLOW_ARIA_ATTR = cfg.ALLOW_ARIA_ATTR !== false;
          ALLOW_DATA_ATTR = cfg.ALLOW_DATA_ATTR !== false;
          ALLOW_UNKNOWN_PROTOCOLS = cfg.ALLOW_UNKNOWN_PROTOCOLS || false;
          ALLOW_SELF_CLOSE_IN_ATTR = cfg.ALLOW_SELF_CLOSE_IN_ATTR !== false;
          SAFE_FOR_TEMPLATES = cfg.SAFE_FOR_TEMPLATES || false;
          SAFE_FOR_XML = cfg.SAFE_FOR_XML !== false;
          WHOLE_DOCUMENT = cfg.WHOLE_DOCUMENT || false;
          RETURN_DOM = cfg.RETURN_DOM || false;
          RETURN_DOM_FRAGMENT = cfg.RETURN_DOM_FRAGMENT || false;
          RETURN_TRUSTED_TYPE = cfg.RETURN_TRUSTED_TYPE || false;
          FORCE_BODY = cfg.FORCE_BODY || false;
          SANITIZE_DOM = cfg.SANITIZE_DOM !== false;
          SANITIZE_NAMED_PROPS = cfg.SANITIZE_NAMED_PROPS || false;
          KEEP_CONTENT = cfg.KEEP_CONTENT !== false;
          IN_PLACE = cfg.IN_PLACE || false;
          IS_ALLOWED_URI$1 = cfg.ALLOWED_URI_REGEXP || IS_ALLOWED_URI;
          NAMESPACE = cfg.NAMESPACE || HTML_NAMESPACE;
          MATHML_TEXT_INTEGRATION_POINTS = cfg.MATHML_TEXT_INTEGRATION_POINTS || MATHML_TEXT_INTEGRATION_POINTS;
          HTML_INTEGRATION_POINTS = cfg.HTML_INTEGRATION_POINTS || HTML_INTEGRATION_POINTS;
          CUSTOM_ELEMENT_HANDLING = cfg.CUSTOM_ELEMENT_HANDLING || {};
          if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck)) {
            CUSTOM_ELEMENT_HANDLING.tagNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck;
          }
          if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)) {
            CUSTOM_ELEMENT_HANDLING.attributeNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck;
          }
          if (cfg.CUSTOM_ELEMENT_HANDLING && typeof cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements === "boolean") {
            CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements = cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements;
          }
          if (SAFE_FOR_TEMPLATES) {
            ALLOW_DATA_ATTR = false;
          }
          if (RETURN_DOM_FRAGMENT) {
            RETURN_DOM = true;
          }
          if (USE_PROFILES) {
            ALLOWED_TAGS = addToSet({}, text);
            ALLOWED_ATTR = [];
            if (USE_PROFILES.html === true) {
              addToSet(ALLOWED_TAGS, html$1);
              addToSet(ALLOWED_ATTR, html);
            }
            if (USE_PROFILES.svg === true) {
              addToSet(ALLOWED_TAGS, svg$1);
              addToSet(ALLOWED_ATTR, svg);
              addToSet(ALLOWED_ATTR, xml);
            }
            if (USE_PROFILES.svgFilters === true) {
              addToSet(ALLOWED_TAGS, svgFilters);
              addToSet(ALLOWED_ATTR, svg);
              addToSet(ALLOWED_ATTR, xml);
            }
            if (USE_PROFILES.mathMl === true) {
              addToSet(ALLOWED_TAGS, mathMl$1);
              addToSet(ALLOWED_ATTR, mathMl);
              addToSet(ALLOWED_ATTR, xml);
            }
          }
          if (cfg.ADD_TAGS) {
            if (ALLOWED_TAGS === DEFAULT_ALLOWED_TAGS) {
              ALLOWED_TAGS = clone(ALLOWED_TAGS);
            }
            addToSet(ALLOWED_TAGS, cfg.ADD_TAGS, transformCaseFunc);
          }
          if (cfg.ADD_ATTR) {
            if (ALLOWED_ATTR === DEFAULT_ALLOWED_ATTR) {
              ALLOWED_ATTR = clone(ALLOWED_ATTR);
            }
            addToSet(ALLOWED_ATTR, cfg.ADD_ATTR, transformCaseFunc);
          }
          if (cfg.ADD_URI_SAFE_ATTR) {
            addToSet(URI_SAFE_ATTRIBUTES, cfg.ADD_URI_SAFE_ATTR, transformCaseFunc);
          }
          if (cfg.FORBID_CONTENTS) {
            if (FORBID_CONTENTS === DEFAULT_FORBID_CONTENTS) {
              FORBID_CONTENTS = clone(FORBID_CONTENTS);
            }
            addToSet(FORBID_CONTENTS, cfg.FORBID_CONTENTS, transformCaseFunc);
          }
          if (KEEP_CONTENT) {
            ALLOWED_TAGS["#text"] = true;
          }
          if (WHOLE_DOCUMENT) {
            addToSet(ALLOWED_TAGS, ["html", "head", "body"]);
          }
          if (ALLOWED_TAGS.table) {
            addToSet(ALLOWED_TAGS, ["tbody"]);
            delete FORBID_TAGS.tbody;
          }
          if (cfg.TRUSTED_TYPES_POLICY) {
            if (typeof cfg.TRUSTED_TYPES_POLICY.createHTML !== "function") {
              throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createHTML" hook.');
            }
            if (typeof cfg.TRUSTED_TYPES_POLICY.createScriptURL !== "function") {
              throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createScriptURL" hook.');
            }
            trustedTypesPolicy = cfg.TRUSTED_TYPES_POLICY;
            emptyHTML = trustedTypesPolicy.createHTML("");
          } else {
            if (trustedTypesPolicy === void 0) {
              trustedTypesPolicy = _createTrustedTypesPolicy(trustedTypes, currentScript);
            }
            if (trustedTypesPolicy !== null && typeof emptyHTML === "string") {
              emptyHTML = trustedTypesPolicy.createHTML("");
            }
          }
          if (freeze) {
            freeze(cfg);
          }
          CONFIG = cfg;
        };
        const ALL_SVG_TAGS = addToSet({}, [...svg$1, ...svgFilters, ...svgDisallowed]);
        const ALL_MATHML_TAGS = addToSet({}, [...mathMl$1, ...mathMlDisallowed]);
        const _checkValidNamespace = function _checkValidNamespace2(element) {
          let parent2 = getParentNode(element);
          if (!parent2 || !parent2.tagName) {
            parent2 = {
              namespaceURI: NAMESPACE,
              tagName: "template"
            };
          }
          const tagName = stringToLowerCase(element.tagName);
          const parentTagName = stringToLowerCase(parent2.tagName);
          if (!ALLOWED_NAMESPACES[element.namespaceURI]) {
            return false;
          }
          if (element.namespaceURI === SVG_NAMESPACE) {
            if (parent2.namespaceURI === HTML_NAMESPACE) {
              return tagName === "svg";
            }
            if (parent2.namespaceURI === MATHML_NAMESPACE) {
              return tagName === "svg" && (parentTagName === "annotation-xml" || MATHML_TEXT_INTEGRATION_POINTS[parentTagName]);
            }
            return Boolean(ALL_SVG_TAGS[tagName]);
          }
          if (element.namespaceURI === MATHML_NAMESPACE) {
            if (parent2.namespaceURI === HTML_NAMESPACE) {
              return tagName === "math";
            }
            if (parent2.namespaceURI === SVG_NAMESPACE) {
              return tagName === "math" && HTML_INTEGRATION_POINTS[parentTagName];
            }
            return Boolean(ALL_MATHML_TAGS[tagName]);
          }
          if (element.namespaceURI === HTML_NAMESPACE) {
            if (parent2.namespaceURI === SVG_NAMESPACE && !HTML_INTEGRATION_POINTS[parentTagName]) {
              return false;
            }
            if (parent2.namespaceURI === MATHML_NAMESPACE && !MATHML_TEXT_INTEGRATION_POINTS[parentTagName]) {
              return false;
            }
            return !ALL_MATHML_TAGS[tagName] && (COMMON_SVG_AND_HTML_ELEMENTS[tagName] || !ALL_SVG_TAGS[tagName]);
          }
          if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && ALLOWED_NAMESPACES[element.namespaceURI]) {
            return true;
          }
          return false;
        };
        const _forceRemove = function _forceRemove2(node) {
          arrayPush(DOMPurify.removed, {
            element: node
          });
          try {
            getParentNode(node).removeChild(node);
          } catch (_) {
            remove2(node);
          }
        };
        const _removeAttribute = function _removeAttribute2(name2, element) {
          try {
            arrayPush(DOMPurify.removed, {
              attribute: element.getAttributeNode(name2),
              from: element
            });
          } catch (_) {
            arrayPush(DOMPurify.removed, {
              attribute: null,
              from: element
            });
          }
          element.removeAttribute(name2);
          if (name2 === "is") {
            if (RETURN_DOM || RETURN_DOM_FRAGMENT) {
              try {
                _forceRemove(element);
              } catch (_) {
              }
            } else {
              try {
                element.setAttribute(name2, "");
              } catch (_) {
              }
            }
          }
        };
        const _initDocument = function _initDocument2(dirty) {
          let doc = null;
          let leadingWhitespace = null;
          if (FORCE_BODY) {
            dirty = "<remove></remove>" + dirty;
          } else {
            const matches = stringMatch(dirty, /^[\r\n\t ]+/);
            leadingWhitespace = matches && matches[0];
          }
          if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && NAMESPACE === HTML_NAMESPACE) {
            dirty = '<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>' + dirty + "</body></html>";
          }
          const dirtyPayload = trustedTypesPolicy ? trustedTypesPolicy.createHTML(dirty) : dirty;
          if (NAMESPACE === HTML_NAMESPACE) {
            try {
              doc = new DOMParser2().parseFromString(dirtyPayload, PARSER_MEDIA_TYPE);
            } catch (_) {
            }
          }
          if (!doc || !doc.documentElement) {
            doc = implementation.createDocument(NAMESPACE, "template", null);
            try {
              doc.documentElement.innerHTML = IS_EMPTY_INPUT ? emptyHTML : dirtyPayload;
            } catch (_) {
            }
          }
          const body = doc.body || doc.documentElement;
          if (dirty && leadingWhitespace) {
            body.insertBefore(document2.createTextNode(leadingWhitespace), body.childNodes[0] || null);
          }
          if (NAMESPACE === HTML_NAMESPACE) {
            return getElementsByTagName.call(doc, WHOLE_DOCUMENT ? "html" : "body")[0];
          }
          return WHOLE_DOCUMENT ? doc.documentElement : body;
        };
        const _createNodeIterator = function _createNodeIterator2(root) {
          return createNodeIterator.call(
            root.ownerDocument || root,
            root,
            // eslint-disable-next-line no-bitwise
            NodeFilter2.SHOW_ELEMENT | NodeFilter2.SHOW_COMMENT | NodeFilter2.SHOW_TEXT | NodeFilter2.SHOW_PROCESSING_INSTRUCTION | NodeFilter2.SHOW_CDATA_SECTION,
            null
          );
        };
        const _isClobbered = function _isClobbered2(element) {
          return element instanceof HTMLFormElement && (typeof element.nodeName !== "string" || typeof element.textContent !== "string" || typeof element.removeChild !== "function" || !(element.attributes instanceof NamedNodeMap) || typeof element.removeAttribute !== "function" || typeof element.setAttribute !== "function" || typeof element.namespaceURI !== "string" || typeof element.insertBefore !== "function" || typeof element.hasChildNodes !== "function");
        };
        const _isNode = function _isNode2(value2) {
          return typeof Node === "function" && value2 instanceof Node;
        };
        function _executeHooks(hooks2, currentNode, data2) {
          arrayForEach(hooks2, (hook) => {
            hook.call(DOMPurify, currentNode, data2, CONFIG);
          });
        }
        const _sanitizeElements = function _sanitizeElements2(currentNode) {
          let content = null;
          _executeHooks(hooks.beforeSanitizeElements, currentNode, null);
          if (_isClobbered(currentNode)) {
            _forceRemove(currentNode);
            return true;
          }
          const tagName = transformCaseFunc(currentNode.nodeName);
          _executeHooks(hooks.uponSanitizeElement, currentNode, {
            tagName,
            allowedTags: ALLOWED_TAGS
          });
          if (currentNode.hasChildNodes() && !_isNode(currentNode.firstElementChild) && regExpTest(/<[/\w]/g, currentNode.innerHTML) && regExpTest(/<[/\w]/g, currentNode.textContent)) {
            _forceRemove(currentNode);
            return true;
          }
          if (currentNode.nodeType === NODE_TYPE.progressingInstruction) {
            _forceRemove(currentNode);
            return true;
          }
          if (SAFE_FOR_XML && currentNode.nodeType === NODE_TYPE.comment && regExpTest(/<[/\w]/g, currentNode.data)) {
            _forceRemove(currentNode);
            return true;
          }
          if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
            if (!FORBID_TAGS[tagName] && _isBasicCustomElement(tagName)) {
              if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, tagName)) {
                return false;
              }
              if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(tagName)) {
                return false;
              }
            }
            if (KEEP_CONTENT && !FORBID_CONTENTS[tagName]) {
              const parentNode = getParentNode(currentNode) || currentNode.parentNode;
              const childNodes = getChildNodes2(currentNode) || currentNode.childNodes;
              if (childNodes && parentNode) {
                const childCount = childNodes.length;
                for (let i = childCount - 1; i >= 0; --i) {
                  const childClone = cloneNode(childNodes[i], true);
                  childClone.__removalCount = (currentNode.__removalCount || 0) + 1;
                  parentNode.insertBefore(childClone, getNextSibling(currentNode));
                }
              }
            }
            _forceRemove(currentNode);
            return true;
          }
          if (currentNode instanceof Element && !_checkValidNamespace(currentNode)) {
            _forceRemove(currentNode);
            return true;
          }
          if ((tagName === "noscript" || tagName === "noembed" || tagName === "noframes") && regExpTest(/<\/no(script|embed|frames)/i, currentNode.innerHTML)) {
            _forceRemove(currentNode);
            return true;
          }
          if (SAFE_FOR_TEMPLATES && currentNode.nodeType === NODE_TYPE.text) {
            content = currentNode.textContent;
            arrayForEach([MUSTACHE_EXPR2, ERB_EXPR2, TMPLIT_EXPR2], (expr) => {
              content = stringReplace(content, expr, " ");
            });
            if (currentNode.textContent !== content) {
              arrayPush(DOMPurify.removed, {
                element: currentNode.cloneNode()
              });
              currentNode.textContent = content;
            }
          }
          _executeHooks(hooks.afterSanitizeElements, currentNode, null);
          return false;
        };
        const _isValidAttribute = function _isValidAttribute2(lcTag, lcName, value2) {
          if (SANITIZE_DOM && (lcName === "id" || lcName === "name") && (value2 in document2 || value2 in formElement)) {
            return false;
          }
          if (ALLOW_DATA_ATTR && !FORBID_ATTR[lcName] && regExpTest(DATA_ATTR2, lcName)) ;
          else if (ALLOW_ARIA_ATTR && regExpTest(ARIA_ATTR2, lcName)) ;
          else if (!ALLOWED_ATTR[lcName] || FORBID_ATTR[lcName]) {
            if (
              // First condition does a very basic check if a) it's basically a valid custom element tagname AND
              // b) if the tagName passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
              // and c) if the attribute name passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.attributeNameCheck
              _isBasicCustomElement(lcTag) && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, lcTag) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(lcTag)) && (CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.attributeNameCheck, lcName) || CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.attributeNameCheck(lcName)) || // Alternative, second condition checks if it's an `is`-attribute, AND
              // the value passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
              lcName === "is" && CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, value2) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(value2))
            ) ;
            else {
              return false;
            }
          } else if (URI_SAFE_ATTRIBUTES[lcName]) ;
          else if (regExpTest(IS_ALLOWED_URI$1, stringReplace(value2, ATTR_WHITESPACE2, ""))) ;
          else if ((lcName === "src" || lcName === "xlink:href" || lcName === "href") && lcTag !== "script" && stringIndexOf(value2, "data:") === 0 && DATA_URI_TAGS[lcTag]) ;
          else if (ALLOW_UNKNOWN_PROTOCOLS && !regExpTest(IS_SCRIPT_OR_DATA2, stringReplace(value2, ATTR_WHITESPACE2, ""))) ;
          else if (value2) {
            return false;
          } else ;
          return true;
        };
        const _isBasicCustomElement = function _isBasicCustomElement2(tagName) {
          return tagName !== "annotation-xml" && stringMatch(tagName, CUSTOM_ELEMENT2);
        };
        const _sanitizeAttributes = function _sanitizeAttributes2(currentNode) {
          _executeHooks(hooks.beforeSanitizeAttributes, currentNode, null);
          const {
            attributes
          } = currentNode;
          if (!attributes || _isClobbered(currentNode)) {
            return;
          }
          const hookEvent = {
            attrName: "",
            attrValue: "",
            keepAttr: true,
            allowedAttributes: ALLOWED_ATTR,
            forceKeepAttr: void 0
          };
          let l = attributes.length;
          while (l--) {
            const attr = attributes[l];
            const {
              name: name2,
              namespaceURI,
              value: attrValue
            } = attr;
            const lcName = transformCaseFunc(name2);
            let value2 = name2 === "value" ? attrValue : stringTrim(attrValue);
            const initValue = value2;
            hookEvent.attrName = lcName;
            hookEvent.attrValue = value2;
            hookEvent.keepAttr = true;
            hookEvent.forceKeepAttr = void 0;
            _executeHooks(hooks.uponSanitizeAttribute, currentNode, hookEvent);
            value2 = hookEvent.attrValue;
            if (SANITIZE_NAMED_PROPS && (lcName === "id" || lcName === "name")) {
              _removeAttribute(name2, currentNode);
              value2 = SANITIZE_NAMED_PROPS_PREFIX + value2;
            }
            if (SAFE_FOR_XML && regExpTest(/((--!?|])>)|<\/(style|title)/i, value2)) {
              _removeAttribute(name2, currentNode);
              continue;
            }
            if (hookEvent.forceKeepAttr) {
              continue;
            }
            if (!hookEvent.keepAttr) {
              _removeAttribute(name2, currentNode);
              continue;
            }
            if (!ALLOW_SELF_CLOSE_IN_ATTR && regExpTest(/\/>/i, value2)) {
              _removeAttribute(name2, currentNode);
              continue;
            }
            if (SAFE_FOR_TEMPLATES) {
              arrayForEach([MUSTACHE_EXPR2, ERB_EXPR2, TMPLIT_EXPR2], (expr) => {
                value2 = stringReplace(value2, expr, " ");
              });
            }
            const lcTag = transformCaseFunc(currentNode.nodeName);
            if (!_isValidAttribute(lcTag, lcName, value2)) {
              _removeAttribute(name2, currentNode);
              continue;
            }
            if (trustedTypesPolicy && typeof trustedTypes === "object" && typeof trustedTypes.getAttributeType === "function") {
              if (namespaceURI) ;
              else {
                switch (trustedTypes.getAttributeType(lcTag, lcName)) {
                  case "TrustedHTML": {
                    value2 = trustedTypesPolicy.createHTML(value2);
                    break;
                  }
                  case "TrustedScriptURL": {
                    value2 = trustedTypesPolicy.createScriptURL(value2);
                    break;
                  }
                }
              }
            }
            if (value2 !== initValue) {
              try {
                if (namespaceURI) {
                  currentNode.setAttributeNS(namespaceURI, name2, value2);
                } else {
                  currentNode.setAttribute(name2, value2);
                }
                if (_isClobbered(currentNode)) {
                  _forceRemove(currentNode);
                } else {
                  arrayPop(DOMPurify.removed);
                }
              } catch (_) {
              }
            }
          }
          _executeHooks(hooks.afterSanitizeAttributes, currentNode, null);
        };
        const _sanitizeShadowDOM = function _sanitizeShadowDOM2(fragment) {
          let shadowNode = null;
          const shadowIterator = _createNodeIterator(fragment);
          _executeHooks(hooks.beforeSanitizeShadowDOM, fragment, null);
          while (shadowNode = shadowIterator.nextNode()) {
            _executeHooks(hooks.uponSanitizeShadowNode, shadowNode, null);
            _sanitizeElements(shadowNode);
            _sanitizeAttributes(shadowNode);
            if (shadowNode.content instanceof DocumentFragment) {
              _sanitizeShadowDOM2(shadowNode.content);
            }
          }
          _executeHooks(hooks.afterSanitizeShadowDOM, fragment, null);
        };
        DOMPurify.sanitize = function(dirty) {
          let cfg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
          let body = null;
          let importedNode = null;
          let currentNode = null;
          let returnNode = null;
          IS_EMPTY_INPUT = !dirty;
          if (IS_EMPTY_INPUT) {
            dirty = "<!-->";
          }
          if (typeof dirty !== "string" && !_isNode(dirty)) {
            if (typeof dirty.toString === "function") {
              dirty = dirty.toString();
              if (typeof dirty !== "string") {
                throw typeErrorCreate("dirty is not a string, aborting");
              }
            } else {
              throw typeErrorCreate("toString is not a function");
            }
          }
          if (!DOMPurify.isSupported) {
            return dirty;
          }
          if (!SET_CONFIG) {
            _parseConfig(cfg);
          }
          DOMPurify.removed = [];
          if (typeof dirty === "string") {
            IN_PLACE = false;
          }
          if (IN_PLACE) {
            if (dirty.nodeName) {
              const tagName = transformCaseFunc(dirty.nodeName);
              if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
                throw typeErrorCreate("root node is forbidden and cannot be sanitized in-place");
              }
            }
          } else if (dirty instanceof Node) {
            body = _initDocument("<!---->");
            importedNode = body.ownerDocument.importNode(dirty, true);
            if (importedNode.nodeType === NODE_TYPE.element && importedNode.nodeName === "BODY") {
              body = importedNode;
            } else if (importedNode.nodeName === "HTML") {
              body = importedNode;
            } else {
              body.appendChild(importedNode);
            }
          } else {
            if (!RETURN_DOM && !SAFE_FOR_TEMPLATES && !WHOLE_DOCUMENT && // eslint-disable-next-line unicorn/prefer-includes
            dirty.indexOf("<") === -1) {
              return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(dirty) : dirty;
            }
            body = _initDocument(dirty);
            if (!body) {
              return RETURN_DOM ? null : RETURN_TRUSTED_TYPE ? emptyHTML : "";
            }
          }
          if (body && FORCE_BODY) {
            _forceRemove(body.firstChild);
          }
          const nodeIterator = _createNodeIterator(IN_PLACE ? dirty : body);
          while (currentNode = nodeIterator.nextNode()) {
            _sanitizeElements(currentNode);
            _sanitizeAttributes(currentNode);
            if (currentNode.content instanceof DocumentFragment) {
              _sanitizeShadowDOM(currentNode.content);
            }
          }
          if (IN_PLACE) {
            return dirty;
          }
          if (RETURN_DOM) {
            if (RETURN_DOM_FRAGMENT) {
              returnNode = createDocumentFragment.call(body.ownerDocument);
              while (body.firstChild) {
                returnNode.appendChild(body.firstChild);
              }
            } else {
              returnNode = body;
            }
            if (ALLOWED_ATTR.shadowroot || ALLOWED_ATTR.shadowrootmode) {
              returnNode = importNode2.call(originalDocument, returnNode, true);
            }
            return returnNode;
          }
          let serializedHTML = WHOLE_DOCUMENT ? body.outerHTML : body.innerHTML;
          if (WHOLE_DOCUMENT && ALLOWED_TAGS["!doctype"] && body.ownerDocument && body.ownerDocument.doctype && body.ownerDocument.doctype.name && regExpTest(DOCTYPE_NAME, body.ownerDocument.doctype.name)) {
            serializedHTML = "<!DOCTYPE " + body.ownerDocument.doctype.name + ">\n" + serializedHTML;
          }
          if (SAFE_FOR_TEMPLATES) {
            arrayForEach([MUSTACHE_EXPR2, ERB_EXPR2, TMPLIT_EXPR2], (expr) => {
              serializedHTML = stringReplace(serializedHTML, expr, " ");
            });
          }
          return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(serializedHTML) : serializedHTML;
        };
        DOMPurify.setConfig = function() {
          let cfg = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
          _parseConfig(cfg);
          SET_CONFIG = true;
        };
        DOMPurify.clearConfig = function() {
          CONFIG = null;
          SET_CONFIG = false;
        };
        DOMPurify.isValidAttribute = function(tag, attr, value2) {
          if (!CONFIG) {
            _parseConfig({});
          }
          const lcTag = transformCaseFunc(tag);
          const lcName = transformCaseFunc(attr);
          return _isValidAttribute(lcTag, lcName, value2);
        };
        DOMPurify.addHook = function(entryPoint, hookFunction) {
          if (typeof hookFunction !== "function") {
            return;
          }
          arrayPush(hooks[entryPoint], hookFunction);
        };
        DOMPurify.removeHook = function(entryPoint, hookFunction) {
          if (hookFunction !== void 0) {
            const index = arrayLastIndexOf(hooks[entryPoint], hookFunction);
            return index === -1 ? void 0 : arraySplice(hooks[entryPoint], index, 1)[0];
          }
          return arrayPop(hooks[entryPoint]);
        };
        DOMPurify.removeHooks = function(entryPoint) {
          hooks[entryPoint] = [];
        };
        DOMPurify.removeAllHooks = function() {
          hooks = _createHooksMap();
        };
        return DOMPurify;
      }
      var purify = createDOMPurify();
      const each$4 = Tools.each, trim = Tools.trim;
      const queryParts = [
        "source",
        "protocol",
        "authority",
        "userInfo",
        "user",
        "password",
        "host",
        "port",
        "relative",
        "path",
        "directory",
        "file",
        "query",
        "anchor"
      ];
      const DEFAULT_PORTS = {
        ftp: 21,
        http: 80,
        https: 443,
        mailto: 25
      };
      const safeSvgDataUrlElements = [
        "img",
        "video"
      ];
      const blockSvgDataUris = (allowSvgDataUrls, tagName) => {
        if (isNonNullable(allowSvgDataUrls)) {
          return !allowSvgDataUrls;
        } else {
          return isNonNullable(tagName) ? !contains$2(safeSvgDataUrlElements, tagName) : true;
        }
      };
      const decodeUri = (encodedUri) => {
        try {
          return decodeURIComponent(encodedUri);
        } catch (_a) {
          return unescape(encodedUri);
        }
      };
      const isInvalidUri = (settings, uri, tagName) => {
        const decodedUri = decodeUri(uri).replace(/\s/g, "");
        if (settings.allow_script_urls) {
          return false;
        } else if (/((java|vb)script|mhtml):/i.test(decodedUri)) {
          return true;
        } else if (settings.allow_html_data_urls) {
          return false;
        } else if (/^data:image\//i.test(decodedUri)) {
          return blockSvgDataUris(settings.allow_svg_data_urls, tagName) && /^data:image\/svg\+xml/i.test(decodedUri);
        } else {
          return /^data:/i.test(decodedUri);
        }
      };
      class URI {
        static parseDataUri(uri) {
          let type2;
          const uriComponents = decodeURIComponent(uri).split(",");
          const matches = /data:([^;]+)/.exec(uriComponents[0]);
          if (matches) {
            type2 = matches[1];
          }
          return {
            type: type2,
            data: uriComponents[1]
          };
        }
        static isDomSafe(uri, context2, options = {}) {
          if (options.allow_script_urls) {
            return true;
          } else {
            const decodedUri = Entities.decode(uri).replace(/[\s\u0000-\u001F]+/g, "");
            return !isInvalidUri(options, decodedUri, context2);
          }
        }
        static getDocumentBaseUrl(loc) {
          var _a;
          let baseUrl;
          if (loc.protocol.indexOf("http") !== 0 && loc.protocol !== "file:") {
            baseUrl = (_a = loc.href) !== null && _a !== void 0 ? _a : "";
          } else {
            baseUrl = loc.protocol + "//" + loc.host + loc.pathname;
          }
          if (/^[^:]+:\/\/\/?[^\/]+\//.test(baseUrl)) {
            baseUrl = baseUrl.replace(/[\?#].*$/, "").replace(/[\/\\][^\/]+$/, "");
            if (!/[\/\\]$/.test(baseUrl)) {
              baseUrl += "/";
            }
          }
          return baseUrl;
        }
        constructor(url, settings = {}) {
          this.path = "";
          this.directory = "";
          url = trim(url);
          this.settings = settings;
          const baseUri = settings.base_uri;
          const self = this;
          if (/^([\w\-]+):([^\/]{2})/i.test(url) || /^\s*#/.test(url)) {
            self.source = url;
            return;
          }
          const isProtocolRelative = url.indexOf("//") === 0;
          if (url.indexOf("/") === 0 && !isProtocolRelative) {
            url = (baseUri ? baseUri.protocol || "http" : "http") + "://mce_host" + url;
          }
          if (!/^[\w\-]*:?\/\//.test(url)) {
            const baseUrl = baseUri ? baseUri.path : new URI(document.location.href).directory;
            if ((baseUri === null || baseUri === void 0 ? void 0 : baseUri.protocol) === "") {
              url = "//mce_host" + self.toAbsPath(baseUrl, url);
            } else {
              const match2 = /([^#?]*)([#?]?.*)/.exec(url);
              if (match2) {
                url = (baseUri && baseUri.protocol || "http") + "://mce_host" + self.toAbsPath(baseUrl, match2[1]) + match2[2];
              }
            }
          }
          url = url.replace(/@@/g, "(mce_at)");
          const urlMatch = /^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@\/]*):?([^:@\/]*))?@)?(\[[a-zA-Z0-9:.%]+\]|[^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/.exec(url);
          if (urlMatch) {
            each$4(queryParts, (v, i) => {
              let part = urlMatch[i];
              if (part) {
                part = part.replace(/\(mce_at\)/g, "@@");
              }
              self[v] = part;
            });
          }
          if (baseUri) {
            if (!self.protocol) {
              self.protocol = baseUri.protocol;
            }
            if (!self.userInfo) {
              self.userInfo = baseUri.userInfo;
            }
            if (!self.port && self.host === "mce_host") {
              self.port = baseUri.port;
            }
            if (!self.host || self.host === "mce_host") {
              self.host = baseUri.host;
            }
            self.source = "";
          }
          if (isProtocolRelative) {
            self.protocol = "";
          }
        }
        setPath(path2) {
          const pathMatch = /^(.*?)\/?(\w+)?$/.exec(path2);
          if (pathMatch) {
            this.path = pathMatch[0];
            this.directory = pathMatch[1];
            this.file = pathMatch[2];
          }
          this.source = "";
          this.getURI();
        }
        toRelative(uri) {
          if (uri === "./") {
            return uri;
          }
          const relativeUri = new URI(uri, { base_uri: this });
          if (relativeUri.host !== "mce_host" && this.host !== relativeUri.host && relativeUri.host || this.port !== relativeUri.port || this.protocol !== relativeUri.protocol && relativeUri.protocol !== "") {
            return relativeUri.getURI();
          }
          const tu = this.getURI(), uu = relativeUri.getURI();
          if (tu === uu || tu.charAt(tu.length - 1) === "/" && tu.substr(0, tu.length - 1) === uu) {
            return tu;
          }
          let output = this.toRelPath(this.path, relativeUri.path);
          if (relativeUri.query) {
            output += "?" + relativeUri.query;
          }
          if (relativeUri.anchor) {
            output += "#" + relativeUri.anchor;
          }
          return output;
        }
        toAbsolute(uri, noHost) {
          const absoluteUri = new URI(uri, { base_uri: this });
          return absoluteUri.getURI(noHost && this.isSameOrigin(absoluteUri));
        }
        isSameOrigin(uri) {
          if (this.host == uri.host && this.protocol == uri.protocol) {
            if (this.port == uri.port) {
              return true;
            }
            const defaultPort = this.protocol ? DEFAULT_PORTS[this.protocol] : null;
            if (defaultPort && (this.port || defaultPort) == (uri.port || defaultPort)) {
              return true;
            }
          }
          return false;
        }
        toRelPath(base, path2) {
          let breakPoint = 0, out = "", i, l;
          const normalizedBase = base.substring(0, base.lastIndexOf("/")).split("/");
          const items = path2.split("/");
          if (normalizedBase.length >= items.length) {
            for (i = 0, l = normalizedBase.length; i < l; i++) {
              if (i >= items.length || normalizedBase[i] !== items[i]) {
                breakPoint = i + 1;
                break;
              }
            }
          }
          if (normalizedBase.length < items.length) {
            for (i = 0, l = items.length; i < l; i++) {
              if (i >= normalizedBase.length || normalizedBase[i] !== items[i]) {
                breakPoint = i + 1;
                break;
              }
            }
          }
          if (breakPoint === 1) {
            return path2;
          }
          for (i = 0, l = normalizedBase.length - (breakPoint - 1); i < l; i++) {
            out += "../";
          }
          for (i = breakPoint - 1, l = items.length; i < l; i++) {
            if (i !== breakPoint - 1) {
              out += "/" + items[i];
            } else {
              out += items[i];
            }
          }
          return out;
        }
        toAbsPath(base, path2) {
          let nb = 0;
          const tr = /\/$/.test(path2) ? "/" : "";
          const normalizedBase = base.split("/");
          const normalizedPath = path2.split("/");
          const baseParts = [];
          each$4(normalizedBase, (k) => {
            if (k) {
              baseParts.push(k);
            }
          });
          const pathParts = [];
          for (let i2 = normalizedPath.length - 1; i2 >= 0; i2--) {
            if (normalizedPath[i2].length === 0 || normalizedPath[i2] === ".") {
              continue;
            }
            if (normalizedPath[i2] === "..") {
              nb++;
              continue;
            }
            if (nb > 0) {
              nb--;
              continue;
            }
            pathParts.push(normalizedPath[i2]);
          }
          const i = baseParts.length - nb;
          let outPath;
          if (i <= 0) {
            outPath = reverse(pathParts).join("/");
          } else {
            outPath = baseParts.slice(0, i).join("/") + "/" + reverse(pathParts).join("/");
          }
          if (outPath.indexOf("/") !== 0) {
            outPath = "/" + outPath;
          }
          if (tr && outPath.lastIndexOf("/") !== outPath.length - 1) {
            outPath += tr;
          }
          return outPath;
        }
        getURI(noProtoHost = false) {
          let s;
          if (!this.source || noProtoHost) {
            s = "";
            if (!noProtoHost) {
              if (this.protocol) {
                s += this.protocol + "://";
              } else {
                s += "//";
              }
              if (this.userInfo) {
                s += this.userInfo + "@";
              }
              if (this.host) {
                s += this.host;
              }
              if (this.port) {
                s += ":" + this.port;
              }
            }
            if (this.path) {
              s += this.path;
            }
            if (this.query) {
              s += "?" + this.query;
            }
            if (this.anchor) {
              s += "#" + this.anchor;
            }
            this.source = s;
          }
          return this.source;
        }
      }
      const filteredUrlAttrs = Tools.makeMap("src,href,data,background,action,formaction,poster,xlink:href");
      const internalElementAttr = "data-mce-type";
      let uid = 0;
      const processNode = (node, settings, schema, scope, evt) => {
        var _a, _b, _c, _d;
        const validate2 = settings.validate;
        const specialElements = schema.getSpecialElements();
        if (node.nodeType === COMMENT && !settings.allow_conditional_comments && /^\[if/i.test((_a = node.nodeValue) !== null && _a !== void 0 ? _a : "")) {
          node.nodeValue = " " + node.nodeValue;
        }
        const lcTagName = (_b = evt === null || evt === void 0 ? void 0 : evt.tagName) !== null && _b !== void 0 ? _b : node.nodeName.toLowerCase();
        if (scope !== "html" && schema.isValid(scope)) {
          if (isNonNullable(evt)) {
            evt.allowedTags[lcTagName] = true;
          }
          return;
        }
        if (node.nodeType !== ELEMENT || lcTagName === "body") {
          return;
        }
        const element = SugarElement.fromDom(node);
        const isInternalElement = has$1(element, internalElementAttr);
        const bogus = get$9(element, "data-mce-bogus");
        if (!isInternalElement && isString(bogus)) {
          if (bogus === "all") {
            remove$4(element);
          } else {
            unwrap(element);
          }
          return;
        }
        const rule = schema.getElementRule(lcTagName);
        if (validate2 && !rule) {
          if (has$2(specialElements, lcTagName)) {
            remove$4(element);
          } else {
            unwrap(element);
          }
          return;
        } else {
          if (isNonNullable(evt)) {
            evt.allowedTags[lcTagName] = true;
          }
        }
        if (validate2 && rule && !isInternalElement) {
          each$e((_c = rule.attributesForced) !== null && _c !== void 0 ? _c : [], (attr) => {
            set$4(element, attr.name, attr.value === "{$uid}" ? `mce_${uid++}` : attr.value);
          });
          each$e((_d = rule.attributesDefault) !== null && _d !== void 0 ? _d : [], (attr) => {
            if (!has$1(element, attr.name)) {
              set$4(element, attr.name, attr.value === "{$uid}" ? `mce_${uid++}` : attr.value);
            }
          });
          if (rule.attributesRequired && !exists(rule.attributesRequired, (attr) => has$1(element, attr))) {
            unwrap(element);
            return;
          }
          if (rule.removeEmptyAttrs && hasNone(element)) {
            unwrap(element);
            return;
          }
          if (rule.outputName && rule.outputName !== lcTagName) {
            mutate(element, rule.outputName);
          }
        }
      };
      const processAttr = (ele, settings, schema, scope, evt) => {
        const tagName = ele.tagName.toLowerCase();
        const { attrName, attrValue } = evt;
        evt.keepAttr = shouldKeepAttribute(settings, schema, scope, tagName, attrName, attrValue);
        if (evt.keepAttr) {
          evt.allowedAttributes[attrName] = true;
          if (isBooleanAttribute(attrName, schema)) {
            evt.attrValue = attrName;
          }
          if (settings.allow_svg_data_urls && startsWith(attrValue, "data:image/svg+xml")) {
            evt.forceKeepAttr = true;
          }
        } else if (isRequiredAttributeOfInternalElement(ele, attrName)) {
          evt.forceKeepAttr = true;
        }
      };
      const shouldKeepAttribute = (settings, schema, scope, tagName, attrName, attrValue) => {
        if (scope !== "html" && !isNonHtmlElementRootName(tagName)) {
          return true;
        }
        return !(attrName in filteredUrlAttrs && isInvalidUri(settings, attrValue, tagName)) && (!settings.validate || schema.isValid(tagName, attrName) || startsWith(attrName, "data-") || startsWith(attrName, "aria-"));
      };
      const isRequiredAttributeOfInternalElement = (ele, attrName) => ele.hasAttribute(internalElementAttr) && (attrName === "id" || attrName === "class" || attrName === "style");
      const isBooleanAttribute = (attrName, schema) => attrName in schema.getBoolAttrs();
      const filterAttributes = (ele, settings, schema, scope) => {
        const { attributes } = ele;
        for (let i = attributes.length - 1; i >= 0; i--) {
          const attr = attributes[i];
          const attrName = attr.name;
          const attrValue = attr.value;
          if (!shouldKeepAttribute(settings, schema, scope, ele.tagName.toLowerCase(), attrName, attrValue) && !isRequiredAttributeOfInternalElement(ele, attrName)) {
            ele.removeAttribute(attrName);
          } else if (isBooleanAttribute(attrName, schema)) {
            ele.setAttribute(attrName, attrName);
          }
        }
      };
      const setupPurify = (settings, schema, namespaceTracker) => {
        const purify$1 = purify();
        purify$1.addHook("uponSanitizeElement", (ele, evt) => {
          processNode(ele, settings, schema, namespaceTracker.track(ele), evt);
        });
        purify$1.addHook("uponSanitizeAttribute", (ele, evt) => {
          processAttr(ele, settings, schema, namespaceTracker.current(), evt);
        });
        return purify$1;
      };
      const getPurifyConfig = (settings, mimeType) => {
        const basePurifyConfig = {
          IN_PLACE: true,
          ALLOW_UNKNOWN_PROTOCOLS: true,
          ALLOWED_TAGS: [
            "#comment",
            "#cdata-section",
            "body"
          ],
          ALLOWED_ATTR: [],
          SAFE_FOR_XML: false
        };
        const config = { ...basePurifyConfig };
        config.PARSER_MEDIA_TYPE = mimeType;
        if (settings.allow_script_urls) {
          config.ALLOWED_URI_REGEXP = /.*/;
        } else if (settings.allow_html_data_urls) {
          config.ALLOWED_URI_REGEXP = /^(?!(\w+script|mhtml):)/i;
        }
        return config;
      };
      const sanitizeSvgElement = (ele) => {
        const xlinkAttrs = [
          "type",
          "href",
          "role",
          "arcrole",
          "title",
          "show",
          "actuate",
          "label",
          "from",
          "to"
        ].map((name2) => `xlink:${name2}`);
        const config = {
          IN_PLACE: true,
          USE_PROFILES: {
            html: true,
            svg: true,
            svgFilters: true
          },
          ALLOWED_ATTR: xlinkAttrs
        };
        purify().sanitize(ele, config);
      };
      const sanitizeMathmlElement = (node, settings) => {
        const config = {
          IN_PLACE: true,
          USE_PROFILES: { mathMl: true }
        };
        const purify$1 = purify();
        const allowedEncodings = settings.allow_mathml_annotation_encodings;
        const hasAllowedEncodings = isArray$1(allowedEncodings) && allowedEncodings.length > 0;
        const hasValidEncoding = (el) => {
          const encoding = el.getAttribute("encoding");
          return hasAllowedEncodings && isString(encoding) && contains$2(allowedEncodings, encoding);
        };
        const isValidElementOpt = (node2, lcTagName) => {
          if (hasAllowedEncodings && lcTagName === "semantics") {
            return Optional.some(true);
          } else if (lcTagName === "annotation") {
            return Optional.some(isElement$6(node2) && hasValidEncoding(node2));
          } else if (isArray$1(settings.extended_mathml_elements)) {
            if (settings.extended_mathml_elements.includes(lcTagName)) {
              return Optional.from(true);
            } else {
              return Optional.none();
            }
          } else {
            return Optional.none();
          }
        };
        purify$1.addHook("uponSanitizeElement", (node2, evt) => {
          var _a;
          const lcTagName = (_a = evt.tagName) !== null && _a !== void 0 ? _a : node2.nodeName.toLowerCase();
          const keepElementOpt = isValidElementOpt(node2, lcTagName);
          keepElementOpt.each((keepElement) => {
            evt.allowedTags[lcTagName] = keepElement;
            if (!keepElement && settings.sanitize) {
              if (isElement$6(node2)) {
                node2.remove();
              }
            }
          });
        });
        purify$1.addHook("uponSanitizeAttribute", (_node, event) => {
          if (isArray$1(settings.extended_mathml_attributes)) {
            const keepAttribute = settings.extended_mathml_attributes.includes(event.attrName);
            if (keepAttribute) {
              event.forceKeepAttr = true;
            }
          }
        });
        purify$1.sanitize(node, config);
      };
      const mkSanitizeNamespaceElement = (settings) => (ele) => {
        const namespaceType = toScopeType(ele);
        if (namespaceType === "svg") {
          sanitizeSvgElement(ele);
        } else if (namespaceType === "math") {
          sanitizeMathmlElement(ele, settings);
        } else {
          throw new Error("Not a namespace element");
        }
      };
      const getSanitizer = (settings, schema) => {
        const namespaceTracker = createNamespaceTracker();
        if (settings.sanitize) {
          const purify2 = setupPurify(settings, schema, namespaceTracker);
          const sanitizeHtmlElement = (body, mimeType) => {
            purify2.sanitize(body, getPurifyConfig(settings, mimeType));
            purify2.removed = [];
            namespaceTracker.reset();
          };
          return {
            sanitizeHtmlElement,
            sanitizeNamespaceElement: mkSanitizeNamespaceElement(settings)
          };
        } else {
          const sanitizeHtmlElement = (body, _mimeType) => {
            const nodeIterator = document.createNodeIterator(body, NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_COMMENT | NodeFilter.SHOW_TEXT);
            let node;
            while (node = nodeIterator.nextNode()) {
              const currentScope = namespaceTracker.track(node);
              processNode(node, settings, schema, currentScope);
              if (isElement$6(node)) {
                filterAttributes(node, settings, schema, currentScope);
              }
            }
            namespaceTracker.reset();
          };
          const sanitizeNamespaceElement = noop;
          return {
            sanitizeHtmlElement,
            sanitizeNamespaceElement
          };
        }
      };
      const makeMap = Tools.makeMap, extend$1 = Tools.extend;
      const transferChildren = (parent2, nativeParent, specialElements, nsSanitizer) => {
        const parentName = parent2.name;
        const isSpecial = parentName in specialElements && parentName !== "title" && parentName !== "textarea" && parentName !== "noscript";
        const childNodes = nativeParent.childNodes;
        for (let ni = 0, nl = childNodes.length; ni < nl; ni++) {
          const nativeChild = childNodes[ni];
          const child2 = new AstNode(nativeChild.nodeName.toLowerCase(), nativeChild.nodeType);
          if (isElement$6(nativeChild)) {
            const attributes = nativeChild.attributes;
            for (let ai = 0, al = attributes.length; ai < al; ai++) {
              const attr = attributes[ai];
              child2.attr(attr.name, attr.value);
            }
            if (isNonHtmlElementRootName(child2.name)) {
              nsSanitizer(nativeChild);
              child2.value = nativeChild.innerHTML;
            }
          } else if (isText$b(nativeChild)) {
            child2.value = nativeChild.data;
            if (isSpecial) {
              child2.raw = true;
            }
          } else if (isComment(nativeChild) || isCData(nativeChild) || isPi(nativeChild)) {
            child2.value = nativeChild.data;
          }
          if (!isNonHtmlElementRootName(child2.name)) {
            transferChildren(child2, nativeChild, specialElements, nsSanitizer);
          }
          parent2.append(child2);
        }
      };
      const walkTree = (root, preprocessors, postprocessors) => {
        const traverseOrder = [];
        for (let node = root, lastNode = node; node; lastNode = node, node = node.walk()) {
          const tempNode = node;
          each$e(preprocessors, (preprocess2) => preprocess2(tempNode));
          if (isNullable(tempNode.parent) && tempNode !== root) {
            node = lastNode;
          } else {
            traverseOrder.push(tempNode);
          }
        }
        for (let i = traverseOrder.length - 1; i >= 0; i--) {
          const node = traverseOrder[i];
          each$e(postprocessors, (postprocess) => postprocess(node));
        }
      };
      const whitespaceCleaner = (root, schema, settings, args) => {
        const validate2 = settings.validate;
        const nonEmptyElements = schema.getNonEmptyElements();
        const whitespaceElements = schema.getWhitespaceElements();
        const blockElements = extend$1(makeMap("script,style,head,html,body,title,meta,param"), schema.getBlockElements());
        const textRootBlockElements = getTextRootBlockElements(schema);
        const allWhiteSpaceRegExp = /[ \t\r\n]+/g;
        const startWhiteSpaceRegExp = /^[ \t\r\n]+/;
        const endWhiteSpaceRegExp = /[ \t\r\n]+$/;
        const hasWhitespaceParent = (node) => {
          let tempNode = node.parent;
          while (isNonNullable(tempNode)) {
            if (tempNode.name in whitespaceElements) {
              return true;
            } else {
              tempNode = tempNode.parent;
            }
          }
          return false;
        };
        const isTextRootBlockEmpty = (node) => {
          let tempNode = node;
          while (isNonNullable(tempNode)) {
            if (tempNode.name in textRootBlockElements) {
              return isEmpty(schema, nonEmptyElements, whitespaceElements, tempNode);
            } else {
              tempNode = tempNode.parent;
            }
          }
          return false;
        };
        const isBlock2 = (node) => node.name in blockElements || isTransparentAstBlock(schema, node) || isNonHtmlElementRootName(node.name) && node.parent === root;
        const isAtEdgeOfBlock = (node, start2) => {
          const neighbour = start2 ? node.prev : node.next;
          if (isNonNullable(neighbour) || isNullable(node.parent)) {
            return false;
          }
          return isBlock2(node.parent) && (node.parent !== root || args.isRootContent === true);
        };
        const preprocess2 = (node) => {
          var _a;
          if (node.type === 3) {
            if (!hasWhitespaceParent(node)) {
              let text2 = (_a = node.value) !== null && _a !== void 0 ? _a : "";
              text2 = text2.replace(allWhiteSpaceRegExp, " ");
              if (isLineBreakNode(node.prev, isBlock2) || isAtEdgeOfBlock(node, true)) {
                text2 = text2.replace(startWhiteSpaceRegExp, "");
              }
              if (text2.length === 0) {
                node.remove();
              } else if (text2 === " " && node.prev && node.prev.type === COMMENT && node.next && node.next.type === COMMENT) {
                node.remove();
              } else {
                node.value = text2;
              }
            }
          }
        };
        const postprocess = (node) => {
          var _a;
          if (node.type === 1) {
            const elementRule = schema.getElementRule(node.name);
            if (validate2 && elementRule) {
              const isNodeEmpty = isEmpty(schema, nonEmptyElements, whitespaceElements, node);
              if (elementRule.paddInEmptyBlock && isNodeEmpty && isTextRootBlockEmpty(node)) {
                paddEmptyNode(settings, args, isBlock2, node);
              } else if (elementRule.removeEmpty && isNodeEmpty) {
                if (isBlock2(node)) {
                  node.remove();
                } else {
                  node.unwrap();
                }
              } else if (elementRule.paddEmpty && (isNodeEmpty || isPaddedWithNbsp(node))) {
                paddEmptyNode(settings, args, isBlock2, node);
              }
            }
          } else if (node.type === 3) {
            if (!hasWhitespaceParent(node)) {
              let text2 = (_a = node.value) !== null && _a !== void 0 ? _a : "";
              if (node.next && isBlock2(node.next) || isAtEdgeOfBlock(node, false)) {
                text2 = text2.replace(endWhiteSpaceRegExp, "");
              }
              if (text2.length === 0) {
                node.remove();
              } else {
                node.value = text2;
              }
            }
          }
        };
        return [
          preprocess2,
          postprocess
        ];
      };
      const getRootBlockName = (settings, args) => {
        var _a;
        const name2 = (_a = args.forced_root_block) !== null && _a !== void 0 ? _a : settings.forced_root_block;
        if (name2 === false) {
          return "";
        } else if (name2 === true) {
          return "p";
        } else {
          return name2;
        }
      };
      const DomParser = (settings = {}, schema = Schema()) => {
        const nodeFilterRegistry = create$8();
        const attributeFilterRegistry = create$8();
        const defaultedSettings = {
          validate: true,
          root_name: "body",
          sanitize: true,
          ...settings
        };
        const parser = new DOMParser();
        const sanitizer = getSanitizer(defaultedSettings, schema);
        const parseAndSanitizeWithContext = (html2, rootName, format = "html") => {
          const mimeType = format === "xhtml" ? "application/xhtml+xml" : "text/html";
          const isSpecialRoot = has$2(schema.getSpecialElements(), rootName.toLowerCase());
          const content = isSpecialRoot ? `<${rootName}>${html2}</${rootName}>` : html2;
          const makeWrap = () => {
            if (format === "xhtml") {
              return `<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>${content}</body></html>`;
            } else if (/^[\s]*<head/i.test(html2) || /^[\s]*<html/i.test(html2) || /^[\s]*<!DOCTYPE/i.test(html2)) {
              return `<html>${content}</html>`;
            } else {
              return `<body>${content}</body>`;
            }
          };
          const body = parser.parseFromString(makeWrap(), mimeType).body;
          sanitizer.sanitizeHtmlElement(body, mimeType);
          return isSpecialRoot ? body.firstChild : body;
        };
        const addNodeFilter2 = nodeFilterRegistry.addFilter;
        const getNodeFilters = nodeFilterRegistry.getFilters;
        const removeNodeFilter = nodeFilterRegistry.removeFilter;
        const addAttributeFilter = attributeFilterRegistry.addFilter;
        const getAttributeFilters = attributeFilterRegistry.getFilters;
        const removeAttributeFilter = attributeFilterRegistry.removeFilter;
        const findInvalidChildren = (node, invalidChildren) => {
          if (isInvalid(schema, node)) {
            invalidChildren.push(node);
          }
        };
        const isWrappableNode = (blockElements, node) => {
          const isInternalElement = isString(node.attr(internalElementAttr));
          const isInlineElement2 = node.type === 1 && (!has$2(blockElements, node.name) && !isTransparentAstBlock(schema, node)) && !isNonHtmlElementRootName(node.name);
          return node.type === 3 || isInlineElement2 && !isInternalElement;
        };
        const addRootBlocks2 = (rootNode, rootBlockName) => {
          const blockElements = extend$1(makeMap("script,style,head,html,body,title,meta,param"), schema.getBlockElements());
          const startWhiteSpaceRegExp = /^[ \t\r\n]+/;
          const endWhiteSpaceRegExp = /[ \t\r\n]+$/;
          let node = rootNode.firstChild, rootBlockNode = null;
          const trim2 = (rootBlock) => {
            var _a, _b;
            if (rootBlock) {
              node = rootBlock.firstChild;
              if (node && node.type === 3) {
                node.value = (_a = node.value) === null || _a === void 0 ? void 0 : _a.replace(startWhiteSpaceRegExp, "");
              }
              node = rootBlock.lastChild;
              if (node && node.type === 3) {
                node.value = (_b = node.value) === null || _b === void 0 ? void 0 : _b.replace(endWhiteSpaceRegExp, "");
              }
            }
          };
          if (!schema.isValidChild(rootNode.name, rootBlockName.toLowerCase())) {
            return;
          }
          while (node) {
            const next2 = node.next;
            if (isWrappableNode(blockElements, node)) {
              if (!rootBlockNode) {
                rootBlockNode = new AstNode(rootBlockName, 1);
                rootBlockNode.attr(defaultedSettings.forced_root_block_attrs);
                rootNode.insert(rootBlockNode, node);
                rootBlockNode.append(node);
              } else {
                rootBlockNode.append(node);
              }
            } else {
              trim2(rootBlockNode);
              rootBlockNode = null;
            }
            node = next2;
          }
          trim2(rootBlockNode);
        };
        const parse = (html2, args = {}) => {
          var _a;
          const validate2 = defaultedSettings.validate;
          const rootName = (_a = args.context) !== null && _a !== void 0 ? _a : defaultedSettings.root_name;
          const element = parseAndSanitizeWithContext(html2, rootName, args.format);
          updateChildren(schema, element);
          const rootNode = new AstNode(rootName, 11);
          transferChildren(rootNode, element, schema.getSpecialElements(), sanitizer.sanitizeNamespaceElement);
          element.innerHTML = "";
          const [whitespacePre, whitespacePost] = whitespaceCleaner(rootNode, schema, defaultedSettings, args);
          const invalidChildren = [];
          const invalidFinder = validate2 ? (node) => findInvalidChildren(node, invalidChildren) : noop;
          const matches = {
            nodes: {},
            attributes: {}
          };
          const matchFinder = (node) => matchNode$1(getNodeFilters(), getAttributeFilters(), node, matches);
          walkTree(rootNode, [
            whitespacePre,
            matchFinder
          ], [
            whitespacePost,
            invalidFinder
          ]);
          invalidChildren.reverse();
          if (validate2 && invalidChildren.length > 0) {
            if (args.context) {
              const {
                pass: topLevelChildren,
                fail: otherChildren
              } = partition$2(invalidChildren, (child2) => child2.parent === rootNode);
              cleanInvalidNodes(otherChildren, schema, rootNode, matchFinder);
              args.invalid = topLevelChildren.length > 0;
            } else {
              cleanInvalidNodes(invalidChildren, schema, rootNode, matchFinder);
            }
          }
          const rootBlockName = getRootBlockName(defaultedSettings, args);
          if (rootBlockName && (rootNode.name === "body" || args.isRootContent)) {
            addRootBlocks2(rootNode, rootBlockName);
          }
          if (!args.invalid) {
            runFilters(matches, args);
          }
          return rootNode;
        };
        const exports2 = {
          schema,
          addAttributeFilter,
          getAttributeFilters,
          removeAttributeFilter,
          addNodeFilter: addNodeFilter2,
          getNodeFilters,
          removeNodeFilter,
          parse
        };
        register$4(exports2, defaultedSettings);
        register$5(exports2, defaultedSettings, schema);
        return exports2;
      };
      const serializeContent = (content) => isTreeNode(content) ? HtmlSerializer({ validate: false }).serialize(content) : content;
      const withSerializedContent = (content, fireEvent2, parserSettings) => {
        const serializedContent = serializeContent(content);
        const eventArgs = fireEvent2(serializedContent);
        if (eventArgs.isDefaultPrevented()) {
          return eventArgs;
        } else if (isTreeNode(content)) {
          if (eventArgs.content !== serializedContent) {
            const rootNode = DomParser({
              validate: false,
              forced_root_block: false,
              ...parserSettings
            }).parse(eventArgs.content, { context: content.name });
            return {
              ...eventArgs,
              content: rootNode
            };
          } else {
            return {
              ...eventArgs,
              content
            };
          }
        } else {
          return eventArgs;
        }
      };
      const makeParserSettings = (editor) => ({
        sanitize: shouldSanitizeXss(editor),
        sandbox_iframes: shouldSandboxIframes(editor),
        sandbox_iframes_exclusions: getSandboxIframesExclusions(editor)
      });
      const preProcessGetContent = (editor, args) => {
        if (args.no_events) {
          return Result.value(args);
        } else {
          const eventArgs = fireBeforeGetContent(editor, args);
          if (eventArgs.isDefaultPrevented()) {
            return Result.error(fireGetContent(editor, {
              content: "",
              ...eventArgs
            }).content);
          } else {
            return Result.value(eventArgs);
          }
        }
      };
      const postProcessGetContent = (editor, content, args) => {
        if (args.no_events) {
          return content;
        } else {
          const processedEventArgs = withSerializedContent(content, (content2) => fireGetContent(editor, {
            ...args,
            content: content2
          }), makeParserSettings(editor));
          return processedEventArgs.content;
        }
      };
      const preProcessSetContent = (editor, args) => {
        if (args.no_events) {
          return Result.value(args);
        } else {
          const processedEventArgs = withSerializedContent(args.content, (content) => fireBeforeSetContent(editor, {
            ...args,
            content
          }), makeParserSettings(editor));
          if (processedEventArgs.isDefaultPrevented()) {
            fireSetContent(editor, processedEventArgs);
            return Result.error(void 0);
          } else {
            return Result.value(processedEventArgs);
          }
        }
      };
      const postProcessSetContent = (editor, content, args) => {
        if (!args.no_events) {
          fireSetContent(editor, {
            ...args,
            content
          });
        }
      };
      const tableModel = (element, width, rows) => ({
        element,
        width,
        rows
      });
      const tableRow = (element, cells2) => ({
        element,
        cells: cells2
      });
      const cellPosition = (x, y) => ({
        x,
        y
      });
      const getSpan = (td, key) => {
        return getOpt(td, key).bind(toInt).getOr(1);
      };
      const fillout = (table2, x, y, tr, td) => {
        const rowspan = getSpan(td, "rowspan");
        const colspan = getSpan(td, "colspan");
        const rows = table2.rows;
        for (let y2 = y; y2 < y + rowspan; y2++) {
          if (!rows[y2]) {
            rows[y2] = tableRow(deep$1(tr), []);
          }
          for (let x2 = x; x2 < x + colspan; x2++) {
            const cells2 = rows[y2].cells;
            cells2[x2] = y2 === y && x2 === x ? td : shallow$1(td);
          }
        }
      };
      const cellExists = (table2, x, y) => {
        const rows = table2.rows;
        const cells2 = rows[y] ? rows[y].cells : [];
        return !!cells2[x];
      };
      const skipCellsX = (table2, x, y) => {
        while (cellExists(table2, x, y)) {
          x++;
        }
        return x;
      };
      const getWidth = (rows) => {
        return foldl(rows, (acc, row) => {
          return row.cells.length > acc ? row.cells.length : acc;
        }, 0);
      };
      const findElementPos = (table2, element) => {
        const rows = table2.rows;
        for (let y = 0; y < rows.length; y++) {
          const cells2 = rows[y].cells;
          for (let x = 0; x < cells2.length; x++) {
            if (eq(cells2[x], element)) {
              return Optional.some(cellPosition(x, y));
            }
          }
        }
        return Optional.none();
      };
      const extractRows = (table2, sx, sy, ex, ey) => {
        const newRows = [];
        const rows = table2.rows;
        for (let y = sy; y <= ey; y++) {
          const cells2 = rows[y].cells;
          const slice = sx < ex ? cells2.slice(sx, ex + 1) : cells2.slice(ex, sx + 1);
          newRows.push(tableRow(rows[y].element, slice));
        }
        return newRows;
      };
      const subTable = (table2, startPos, endPos) => {
        const sx = startPos.x, sy = startPos.y;
        const ex = endPos.x, ey = endPos.y;
        const newRows = sy < ey ? extractRows(table2, sx, sy, ex, ey) : extractRows(table2, sx, ey, ex, sy);
        return tableModel(table2.element, getWidth(newRows), newRows);
      };
      const createDomTable = (table2, rows) => {
        const tableElement = shallow$1(table2.element);
        const tableBody = SugarElement.fromTag("tbody");
        append(tableBody, rows);
        append$1(tableElement, tableBody);
        return tableElement;
      };
      const modelRowsToDomRows = (table2) => {
        return map$3(table2.rows, (row) => {
          const cells2 = map$3(row.cells, (cell2) => {
            const td = deep$1(cell2);
            remove$9(td, "colspan");
            remove$9(td, "rowspan");
            return td;
          });
          const tr = shallow$1(row.element);
          append(tr, cells2);
          return tr;
        });
      };
      const fromDom = (tableElm) => {
        const table2 = tableModel(shallow$1(tableElm), 0, []);
        each$e(descendants(tableElm, "tr"), (tr, y) => {
          each$e(descendants(tr, "td,th"), (td, x) => {
            fillout(table2, skipCellsX(table2, x, y), y, tr, td);
          });
        });
        return tableModel(table2.element, getWidth(table2.rows), table2.rows);
      };
      const toDom = (table2) => {
        return createDomTable(table2, modelRowsToDomRows(table2));
      };
      const subsection = (table2, startElement, endElement) => {
        return findElementPos(table2, startElement).bind((startPos) => {
          return findElementPos(table2, endElement).map((endPos) => {
            return subTable(table2, startPos, endPos);
          });
        });
      };
      const findParentListContainer = (parents2) => find$2(parents2, (elm) => name(elm) === "ul" || name(elm) === "ol");
      const getFullySelectedListWrappers = (parents2, rng) => find$2(parents2, (elm) => name(elm) === "li" && hasAllContentsSelected(elm, rng)).fold(constant([]), (_li) => findParentListContainer(parents2).map((listCont) => {
        const listElm = SugarElement.fromTag(name(listCont));
        const listStyles = filter$4(getAllRaw(listCont), (_style, name2) => startsWith(name2, "list-style"));
        setAll(listElm, listStyles);
        return [
          SugarElement.fromTag("li"),
          listElm
        ];
      }).getOr([]));
      const wrap = (innerElm, elms) => {
        const wrapped = foldl(elms, (acc, elm) => {
          append$1(elm, acc);
          return elm;
        }, innerElm);
        return elms.length > 0 ? fromElements([wrapped]) : wrapped;
      };
      const directListWrappers = (commonAnchorContainer) => {
        if (isListItem$1(commonAnchorContainer)) {
          return parent(commonAnchorContainer).filter(isList).fold(constant([]), (listElm) => [
            commonAnchorContainer,
            listElm
          ]);
        } else {
          return isList(commonAnchorContainer) ? [commonAnchorContainer] : [];
        }
      };
      const getWrapElements = (rootNode, rng, schema) => {
        const commonAnchorContainer = SugarElement.fromDom(rng.commonAncestorContainer);
        const parents2 = parentsAndSelf(commonAnchorContainer, rootNode);
        const wrapElements = filter$5(parents2, (el) => schema.isWrapper(name(el)));
        const listWrappers = getFullySelectedListWrappers(parents2, rng);
        const allWrappers = wrapElements.concat(listWrappers.length ? listWrappers : directListWrappers(commonAnchorContainer));
        return map$3(allWrappers, shallow$1);
      };
      const emptyFragment = () => fromElements([]);
      const getFragmentFromRange = (rootNode, rng, schema) => wrap(SugarElement.fromDom(rng.cloneContents()), getWrapElements(rootNode, rng, schema));
      const getParentTable = (rootElm, cell2) => ancestor$3(cell2, "table", curry(eq, rootElm));
      const getTableFragment = (rootNode, selectedTableCells) => getParentTable(rootNode, selectedTableCells[0]).bind((tableElm) => {
        const firstCell = selectedTableCells[0];
        const lastCell = selectedTableCells[selectedTableCells.length - 1];
        const fullTableModel = fromDom(tableElm);
        return subsection(fullTableModel, firstCell, lastCell).map((sectionedTableModel) => fromElements([toDom(sectionedTableModel)]));
      }).getOrThunk(emptyFragment);
      const getSelectionFragment = (rootNode, ranges, schema) => ranges.length > 0 && ranges[0].collapsed ? emptyFragment() : getFragmentFromRange(rootNode, ranges[0], schema);
      const read$3 = (rootNode, ranges, schema) => {
        const selectedCells = getCellsFromElementOrRanges(ranges, rootNode);
        return selectedCells.length > 0 ? getTableFragment(rootNode, selectedCells) : getSelectionFragment(rootNode, ranges, schema);
      };
      const isCollapsibleWhitespace = (text2, index) => index >= 0 && index < text2.length && isWhiteSpace(text2.charAt(index));
      const getInnerText = (bin) => {
        return trim$2(bin.innerText);
      };
      const getContextNodeName = (parentBlockOpt) => parentBlockOpt.map((block) => block.nodeName).getOr("div").toLowerCase();
      const getTextContent = (editor) => Optional.from(editor.selection.getRng()).map((rng) => {
        var _a;
        const parentBlockOpt = Optional.from(editor.dom.getParent(rng.commonAncestorContainer, editor.dom.isBlock));
        const body = editor.getBody();
        const contextNodeName = getContextNodeName(parentBlockOpt);
        const rangeContentClone = SugarElement.fromDom(rng.cloneContents());
        cleanupBogusElements(rangeContentClone);
        cleanupInputNames(rangeContentClone);
        const bin = editor.dom.add(body, contextNodeName, {
          "data-mce-bogus": "all",
          "style": "overflow: hidden; opacity: 0;"
        }, rangeContentClone.dom);
        const text2 = getInnerText(bin);
        const nonRenderedText = trim$2((_a = bin.textContent) !== null && _a !== void 0 ? _a : "");
        editor.dom.remove(bin);
        if (isCollapsibleWhitespace(nonRenderedText, 0) || isCollapsibleWhitespace(nonRenderedText, nonRenderedText.length - 1)) {
          const parentBlock = parentBlockOpt.getOr(body);
          const parentBlockText = getInnerText(parentBlock);
          const textIndex = parentBlockText.indexOf(text2);
          if (textIndex === -1) {
            return text2;
          } else {
            const hasProceedingSpace = isCollapsibleWhitespace(parentBlockText, textIndex - 1);
            const hasTrailingSpace = isCollapsibleWhitespace(parentBlockText, textIndex + text2.length);
            return (hasProceedingSpace ? " " : "") + text2 + (hasTrailingSpace ? " " : "");
          }
        } else {
          return text2;
        }
      }).getOr("");
      const getSerializedContent = (editor, args) => {
        const rng = editor.selection.getRng(), tmpElm = editor.dom.create("body");
        const sel = editor.selection.getSel();
        const ranges = processRanges(editor, getRanges$1(sel));
        const fragment = args.contextual ? read$3(SugarElement.fromDom(editor.getBody()), ranges, editor.schema).dom : rng.cloneContents();
        if (fragment) {
          tmpElm.appendChild(fragment);
        }
        return editor.selection.serializer.serialize(tmpElm, args);
      };
      const extractSelectedContent = (editor, args) => {
        if (args.format === "text") {
          return getTextContent(editor);
        } else {
          const content = getSerializedContent(editor, args);
          if (args.format === "tree") {
            return content;
          } else {
            return editor.selection.isCollapsed() ? "" : content;
          }
        }
      };
      const setupArgs$3 = (args, format) => ({
        ...args,
        format,
        get: true,
        selection: true,
        getInner: true
      });
      const getSelectedContentInternal = (editor, format, args = {}) => {
        const defaultedArgs = setupArgs$3(args, format);
        return preProcessGetContent(editor, defaultedArgs).fold(identity, (updatedArgs) => {
          const content = extractSelectedContent(editor, updatedArgs);
          return postProcessGetContent(editor, content, updatedArgs);
        });
      };
      const KEEP = 0, INSERT = 1, DELETE = 2;
      const diff = (left, right) => {
        const size = left.length + right.length + 2;
        const vDown = new Array(size);
        const vUp = new Array(size);
        const snake = (start2, end2, diag) => {
          return {
            start: start2,
            end: end2,
            diag
          };
        };
        const buildScript = (start1, end1, start2, end2, script2) => {
          const middle = getMiddleSnake(start1, end1, start2, end2);
          if (middle === null || middle.start === end1 && middle.diag === end1 - end2 || middle.end === start1 && middle.diag === start1 - start2) {
            let i = start1;
            let j = start2;
            while (i < end1 || j < end2) {
              if (i < end1 && j < end2 && left[i] === right[j]) {
                script2.push([
                  KEEP,
                  left[i]
                ]);
                ++i;
                ++j;
              } else {
                if (end1 - start1 > end2 - start2) {
                  script2.push([
                    DELETE,
                    left[i]
                  ]);
                  ++i;
                } else {
                  script2.push([
                    INSERT,
                    right[j]
                  ]);
                  ++j;
                }
              }
            }
          } else {
            buildScript(start1, middle.start, start2, middle.start - middle.diag, script2);
            for (let i2 = middle.start; i2 < middle.end; ++i2) {
              script2.push([
                KEEP,
                left[i2]
              ]);
            }
            buildScript(middle.end, end1, middle.end - middle.diag, end2, script2);
          }
        };
        const buildSnake = (start2, diag, end1, end2) => {
          let end3 = start2;
          while (end3 - diag < end2 && end3 < end1 && left[end3] === right[end3 - diag]) {
            ++end3;
          }
          return snake(start2, end3, diag);
        };
        const getMiddleSnake = (start1, end1, start2, end2) => {
          const m = end1 - start1;
          const n = end2 - start2;
          if (m === 0 || n === 0) {
            return null;
          }
          const delta = m - n;
          const sum = n + m;
          const offset = (sum % 2 === 0 ? sum : sum + 1) / 2;
          vDown[1 + offset] = start1;
          vUp[1 + offset] = end1 + 1;
          let d, k, i, x, y;
          for (d = 0; d <= offset; ++d) {
            for (k = -d; k <= d; k += 2) {
              i = k + offset;
              if (k === -d || k !== d && vDown[i - 1] < vDown[i + 1]) {
                vDown[i] = vDown[i + 1];
              } else {
                vDown[i] = vDown[i - 1] + 1;
              }
              x = vDown[i];
              y = x - start1 + start2 - k;
              while (x < end1 && y < end2 && left[x] === right[y]) {
                vDown[i] = ++x;
                ++y;
              }
              if (delta % 2 !== 0 && delta - d <= k && k <= delta + d) {
                if (vUp[i - delta] <= vDown[i]) {
                  return buildSnake(vUp[i - delta], k + start1 - start2, end1, end2);
                }
              }
            }
            for (k = delta - d; k <= delta + d; k += 2) {
              i = k + offset - delta;
              if (k === delta - d || k !== delta + d && vUp[i + 1] <= vUp[i - 1]) {
                vUp[i] = vUp[i + 1] - 1;
              } else {
                vUp[i] = vUp[i - 1];
              }
              x = vUp[i] - 1;
              y = x - start1 + start2 - k;
              while (x >= start1 && y >= start2 && left[x] === right[y]) {
                vUp[i] = x--;
                y--;
              }
              if (delta % 2 === 0 && -d <= k && k <= d) {
                if (vUp[i] <= vDown[i + delta]) {
                  return buildSnake(vUp[i], k + start1 - start2, end1, end2);
                }
              }
            }
          }
          return null;
        };
        const script = [];
        buildScript(0, left.length, 0, right.length, script);
        return script;
      };
      const getOuterHtml = (elm) => {
        if (isElement$6(elm)) {
          return elm.outerHTML;
        } else if (isText$b(elm)) {
          return Entities.encodeRaw(elm.data, false);
        } else if (isComment(elm)) {
          return "<!--" + elm.data + "-->";
        }
        return "";
      };
      const createFragment = (html2) => {
        let node;
        const container = document.createElement("div");
        const frag = document.createDocumentFragment();
        if (html2) {
          container.innerHTML = html2;
        }
        while (node = container.firstChild) {
          frag.appendChild(node);
        }
        return frag;
      };
      const insertAt = (elm, html2, index) => {
        const fragment = createFragment(html2);
        if (elm.hasChildNodes() && index < elm.childNodes.length) {
          const target = elm.childNodes[index];
          elm.insertBefore(fragment, target);
        } else {
          elm.appendChild(fragment);
        }
      };
      const removeAt = (elm, index) => {
        if (elm.hasChildNodes() && index < elm.childNodes.length) {
          const target = elm.childNodes[index];
          elm.removeChild(target);
        }
      };
      const applyDiff = (diff2, elm) => {
        let index = 0;
        each$e(diff2, (action2) => {
          if (action2[0] === KEEP) {
            index++;
          } else if (action2[0] === INSERT) {
            insertAt(elm, action2[1], index);
            index++;
          } else if (action2[0] === DELETE) {
            removeAt(elm, index);
          }
        });
      };
      const read$2 = (elm, trimZwsp2) => filter$5(map$3(from(elm.childNodes), trimZwsp2 ? compose(trim$2, getOuterHtml) : getOuterHtml), (item) => {
        return item.length > 0;
      });
      const write = (fragments, elm) => {
        const currentFragments = map$3(from(elm.childNodes), getOuterHtml);
        applyDiff(diff(currentFragments, fragments), elm);
        return elm;
      };
      const lazyTempDocument = cached(() => document.implementation.createHTMLDocument("undo"));
      const hasIframes = (body) => body.querySelector("iframe") !== null;
      const createFragmentedLevel = (fragments) => {
        return {
          type: "fragmented",
          fragments,
          content: "",
          bookmark: null,
          beforeBookmark: null
        };
      };
      const createCompleteLevel = (content) => {
        return {
          type: "complete",
          fragments: null,
          content,
          bookmark: null,
          beforeBookmark: null
        };
      };
      const createFromEditor = (editor) => {
        const tempAttrs = editor.serializer.getTempAttrs();
        const body = trim$1(editor.getBody(), tempAttrs);
        return hasIframes(body) ? createFragmentedLevel(read$2(body, true)) : createCompleteLevel(trim$2(body.innerHTML));
      };
      const applyToEditor = (editor, level, before2) => {
        const bookmark = before2 ? level.beforeBookmark : level.bookmark;
        if (level.type === "fragmented") {
          write(level.fragments, editor.getBody());
        } else {
          editor.setContent(level.content, {
            format: "raw",
            no_selection: isNonNullable(bookmark) && isPathBookmark(bookmark) ? !bookmark.isFakeCaret : true
          });
        }
        if (bookmark) {
          editor.selection.moveToBookmark(bookmark);
          editor.selection.scrollIntoView();
        }
      };
      const getLevelContent = (level) => {
        return level.type === "fragmented" ? level.fragments.join("") : level.content;
      };
      const getCleanLevelContent = (level) => {
        const elm = SugarElement.fromTag("body", lazyTempDocument());
        set$1(elm, getLevelContent(level));
        each$e(descendants(elm, "*[data-mce-bogus]"), unwrap);
        return get$6(elm);
      };
      const hasEqualContent = (level1, level2) => getLevelContent(level1) === getLevelContent(level2);
      const hasEqualCleanedContent = (level1, level2) => getCleanLevelContent(level1) === getCleanLevelContent(level2);
      const isEq$1 = (level1, level2) => {
        if (!level1 || !level2) {
          return false;
        } else if (hasEqualContent(level1, level2)) {
          return true;
        } else {
          return hasEqualCleanedContent(level1, level2);
        }
      };
      const isUnlocked = (locks) => locks.get() === 0;
      const setTyping = (undoManager, typing, locks) => {
        if (isUnlocked(locks)) {
          undoManager.typing = typing;
        }
      };
      const endTyping = (undoManager, locks) => {
        if (undoManager.typing) {
          setTyping(undoManager, false, locks);
          undoManager.add();
        }
      };
      const endTypingLevelIgnoreLocks = (undoManager) => {
        if (undoManager.typing) {
          undoManager.typing = false;
          undoManager.add();
        }
      };
      const beforeChange$1 = (editor, locks, beforeBookmark) => {
        if (isUnlocked(locks)) {
          beforeBookmark.set(getUndoBookmark(editor.selection));
        }
      };
      const addUndoLevel$1 = (editor, undoManager, index, locks, beforeBookmark, level, event) => {
        const currentLevel = createFromEditor(editor);
        const newLevel = Tools.extend(level || {}, currentLevel);
        if (!isUnlocked(locks) || editor.removed) {
          return null;
        }
        const lastLevel = undoManager.data[index.get()];
        if (editor.dispatch("BeforeAddUndo", {
          level: newLevel,
          lastLevel,
          originalEvent: event
        }).isDefaultPrevented()) {
          return null;
        }
        if (lastLevel && isEq$1(lastLevel, newLevel)) {
          return null;
        }
        if (undoManager.data[index.get()]) {
          beforeBookmark.get().each((bm) => {
            undoManager.data[index.get()].beforeBookmark = bm;
          });
        }
        const customUndoRedoLevels = getCustomUndoRedoLevels(editor);
        if (customUndoRedoLevels) {
          if (undoManager.data.length > customUndoRedoLevels) {
            for (let i = 0; i < undoManager.data.length - 1; i++) {
              undoManager.data[i] = undoManager.data[i + 1];
            }
            undoManager.data.length--;
            index.set(undoManager.data.length);
          }
        }
        newLevel.bookmark = getUndoBookmark(editor.selection);
        if (index.get() < undoManager.data.length - 1) {
          undoManager.data.length = index.get() + 1;
        }
        undoManager.data.push(newLevel);
        index.set(undoManager.data.length - 1);
        const args = {
          level: newLevel,
          lastLevel,
          originalEvent: event
        };
        if (index.get() > 0) {
          editor.setDirty(true);
          editor.dispatch("AddUndo", args);
          editor.dispatch("change", args);
        } else {
          editor.dispatch("AddUndo", args);
        }
        return newLevel;
      };
      const clear$1 = (editor, undoManager, index) => {
        undoManager.data = [];
        index.set(0);
        undoManager.typing = false;
        editor.dispatch("ClearUndos");
      };
      const extra$1 = (editor, undoManager, index, callback1, callback2) => {
        if (undoManager.transact(callback1)) {
          const bookmark = undoManager.data[index.get()].bookmark;
          const lastLevel = undoManager.data[index.get() - 1];
          applyToEditor(editor, lastLevel, true);
          if (undoManager.transact(callback2)) {
            undoManager.data[index.get() - 1].beforeBookmark = bookmark;
          }
        }
      };
      const redo$1 = (editor, index, data2) => {
        let level;
        if (index.get() < data2.length - 1) {
          index.set(index.get() + 1);
          level = data2[index.get()];
          applyToEditor(editor, level, false);
          editor.setDirty(true);
          editor.dispatch("Redo", { level });
        }
        return level;
      };
      const undo$1 = (editor, undoManager, locks, index) => {
        let level;
        if (undoManager.typing) {
          undoManager.add();
          undoManager.typing = false;
          setTyping(undoManager, false, locks);
        }
        if (index.get() > 0) {
          index.set(index.get() - 1);
          level = undoManager.data[index.get()];
          applyToEditor(editor, level, true);
          editor.setDirty(true);
          editor.dispatch("Undo", { level });
        }
        return level;
      };
      const reset$1 = (undoManager) => {
        undoManager.clear();
        undoManager.add();
      };
      const hasUndo$1 = (editor, undoManager, index) => index.get() > 0 || undoManager.typing && undoManager.data[0] && !isEq$1(createFromEditor(editor), undoManager.data[0]);
      const hasRedo$1 = (undoManager, index) => index.get() < undoManager.data.length - 1 && !undoManager.typing;
      const transact$1 = (undoManager, locks, callback) => {
        endTyping(undoManager, locks);
        undoManager.beforeChange();
        undoManager.ignore(callback);
        return undoManager.add();
      };
      const ignore$1 = (locks, callback) => {
        try {
          locks.set(locks.get() + 1);
          callback();
        } finally {
          locks.set(locks.get() - 1);
        }
      };
      const addVisualInternal = (editor, elm) => {
        const dom2 = editor.dom;
        const scope = isNonNullable(elm) ? elm : editor.getBody();
        each$e(dom2.select("table,a", scope), (matchedElm) => {
          switch (matchedElm.nodeName) {
            case "TABLE":
              const cls = getVisualAidsTableClass(editor);
              const value2 = dom2.getAttrib(matchedElm, "border");
              if ((!value2 || value2 === "0") && editor.hasVisual) {
                dom2.addClass(matchedElm, cls);
              } else {
                dom2.removeClass(matchedElm, cls);
              }
              break;
            case "A":
              if (!dom2.getAttrib(matchedElm, "href")) {
                const value3 = dom2.getAttrib(matchedElm, "name") || matchedElm.id;
                const cls2 = getVisualAidsAnchorClass(editor);
                if (value3 && editor.hasVisual) {
                  dom2.addClass(matchedElm, cls2);
                } else {
                  dom2.removeClass(matchedElm, cls2);
                }
              }
              break;
          }
        });
        editor.dispatch("VisualAid", {
          element: elm,
          hasVisual: editor.hasVisual
        });
      };
      const makePlainAdaptor = (editor) => ({
        init: { bindEvents: noop },
        undoManager: {
          beforeChange: (locks, beforeBookmark) => beforeChange$1(editor, locks, beforeBookmark),
          add: (undoManager, index, locks, beforeBookmark, level, event) => addUndoLevel$1(editor, undoManager, index, locks, beforeBookmark, level, event),
          undo: (undoManager, locks, index) => undo$1(editor, undoManager, locks, index),
          redo: (index, data2) => redo$1(editor, index, data2),
          clear: (undoManager, index) => clear$1(editor, undoManager, index),
          reset: (undoManager) => reset$1(undoManager),
          hasUndo: (undoManager, index) => hasUndo$1(editor, undoManager, index),
          hasRedo: (undoManager, index) => hasRedo$1(undoManager, index),
          transact: (undoManager, locks, callback) => transact$1(undoManager, locks, callback),
          ignore: (locks, callback) => ignore$1(locks, callback),
          extra: (undoManager, index, callback1, callback2) => extra$1(editor, undoManager, index, callback1, callback2)
        },
        formatter: {
          match: (name2, vars, node, similar) => match$2(editor, name2, vars, node, similar),
          matchAll: (names, vars) => matchAll(editor, names, vars),
          matchNode: (node, name2, vars, similar) => matchNode(editor, node, name2, vars, similar),
          canApply: (name2) => canApply(editor, name2),
          closest: (names) => closest(editor, names),
          apply: (name2, vars, node) => applyFormat$1(editor, name2, vars, node),
          remove: (name2, vars, node, similar) => removeFormat$1(editor, name2, vars, node, similar),
          toggle: (name2, vars, node) => toggle(editor, name2, vars, node),
          formatChanged: (registeredFormatListeners, formats, callback, similar, vars) => formatChangedInternal(editor, registeredFormatListeners, formats, callback, similar, vars)
        },
        editor: {
          getContent: (args) => getContentInternal(editor, args),
          setContent: (content, args) => setContentInternal(editor, content, args),
          insertContent: (value2, details) => insertHtmlAtCaret(editor, value2, details),
          addVisual: (elm) => addVisualInternal(editor, elm)
        },
        selection: { getContent: (format, args) => getSelectedContentInternal(editor, format, args) },
        autocompleter: {
          addDecoration: noop,
          removeDecoration: noop
        },
        raw: { getModel: () => Optional.none() }
      });
      const makeRtcAdaptor = (rtcEditor) => {
        const defaultVars = (vars) => isObject(vars) ? vars : {};
        const { init: init2, undoManager, formatter, editor, selection, autocompleter, raw } = rtcEditor;
        return {
          init: { bindEvents: init2.bindEvents },
          undoManager: {
            beforeChange: undoManager.beforeChange,
            add: undoManager.add,
            undo: undoManager.undo,
            redo: undoManager.redo,
            clear: undoManager.clear,
            reset: undoManager.reset,
            hasUndo: undoManager.hasUndo,
            hasRedo: undoManager.hasRedo,
            transact: (_undoManager, _locks, fn) => undoManager.transact(fn),
            ignore: (_locks, callback) => undoManager.ignore(callback),
            extra: (_undoManager, _index, callback1, callback2) => undoManager.extra(callback1, callback2)
          },
          formatter: {
            match: (name2, vars, _node, similar) => formatter.match(name2, defaultVars(vars), similar),
            matchAll: formatter.matchAll,
            matchNode: formatter.matchNode,
            canApply: (name2) => formatter.canApply(name2),
            closest: (names) => formatter.closest(names),
            apply: (name2, vars, _node) => formatter.apply(name2, defaultVars(vars)),
            remove: (name2, vars, _node, _similar) => formatter.remove(name2, defaultVars(vars)),
            toggle: (name2, vars, _node) => formatter.toggle(name2, defaultVars(vars)),
            formatChanged: (_rfl, formats, callback, similar, vars) => formatter.formatChanged(formats, callback, similar, vars)
          },
          editor: {
            getContent: (args) => editor.getContent(args),
            setContent: (content, args) => {
              return {
                content: editor.setContent(content, args),
                html: ""
              };
            },
            insertContent: (content, _details) => {
              editor.insertContent(content);
              return "";
            },
            addVisual: editor.addVisual
          },
          selection: { getContent: (_format, args) => selection.getContent(args) },
          autocompleter: {
            addDecoration: autocompleter.addDecoration,
            removeDecoration: autocompleter.removeDecoration
          },
          raw: { getModel: () => Optional.some(raw.getRawModel()) }
        };
      };
      const makeNoopAdaptor = () => {
        const nul = constant(null);
        const empty2 = constant("");
        return {
          init: { bindEvents: noop },
          undoManager: {
            beforeChange: noop,
            add: nul,
            undo: nul,
            redo: nul,
            clear: noop,
            reset: noop,
            hasUndo: never,
            hasRedo: never,
            transact: nul,
            ignore: noop,
            extra: noop
          },
          formatter: {
            match: never,
            matchAll: constant([]),
            matchNode: constant(void 0),
            canApply: never,
            closest: empty2,
            apply: noop,
            remove: noop,
            toggle: noop,
            formatChanged: constant({ unbind: noop })
          },
          editor: {
            getContent: empty2,
            setContent: constant({
              content: "",
              html: ""
            }),
            insertContent: constant(""),
            addVisual: noop
          },
          selection: { getContent: empty2 },
          autocompleter: {
            addDecoration: noop,
            removeDecoration: noop
          },
          raw: { getModel: constant(Optional.none()) }
        };
      };
      const isRtc = (editor) => has$2(editor.plugins, "rtc");
      const getRtcSetup = (editor) => get$a(editor.plugins, "rtc").bind((rtcPlugin) => Optional.from(rtcPlugin.setup));
      const setup$t = (editor) => {
        const editorCast = editor;
        return getRtcSetup(editor).fold(() => {
          editorCast.rtcInstance = makePlainAdaptor(editor);
          return Optional.none();
        }, (setup2) => {
          editorCast.rtcInstance = makeNoopAdaptor();
          return Optional.some(() => setup2().then((rtcEditor) => {
            editorCast.rtcInstance = makeRtcAdaptor(rtcEditor);
            return rtcEditor.rtc.isRemote;
          }));
        });
      };
      const getRtcInstanceWithFallback = (editor) => editor.rtcInstance ? editor.rtcInstance : makePlainAdaptor(editor);
      const getRtcInstanceWithError = (editor) => {
        const rtcInstance = editor.rtcInstance;
        if (!rtcInstance) {
          throw new Error("Failed to get RTC instance not yet initialized.");
        } else {
          return rtcInstance;
        }
      };
      const beforeChange = (editor, locks, beforeBookmark) => {
        getRtcInstanceWithError(editor).undoManager.beforeChange(locks, beforeBookmark);
      };
      const addUndoLevel = (editor, undoManager, index, locks, beforeBookmark, level, event) => getRtcInstanceWithError(editor).undoManager.add(undoManager, index, locks, beforeBookmark, level, event);
      const undo = (editor, undoManager, locks, index) => getRtcInstanceWithError(editor).undoManager.undo(undoManager, locks, index);
      const redo = (editor, index, data2) => getRtcInstanceWithError(editor).undoManager.redo(index, data2);
      const clear = (editor, undoManager, index) => {
        getRtcInstanceWithError(editor).undoManager.clear(undoManager, index);
      };
      const reset = (editor, undoManager) => {
        getRtcInstanceWithError(editor).undoManager.reset(undoManager);
      };
      const hasUndo = (editor, undoManager, index) => getRtcInstanceWithError(editor).undoManager.hasUndo(undoManager, index);
      const hasRedo = (editor, undoManager, index) => getRtcInstanceWithError(editor).undoManager.hasRedo(undoManager, index);
      const transact = (editor, undoManager, locks, callback) => getRtcInstanceWithError(editor).undoManager.transact(undoManager, locks, callback);
      const ignore = (editor, locks, callback) => {
        getRtcInstanceWithError(editor).undoManager.ignore(locks, callback);
      };
      const extra = (editor, undoManager, index, callback1, callback2) => {
        getRtcInstanceWithError(editor).undoManager.extra(undoManager, index, callback1, callback2);
      };
      const matchFormat = (editor, name2, vars, node, similar) => getRtcInstanceWithError(editor).formatter.match(name2, vars, node, similar);
      const matchAllFormats = (editor, names, vars) => getRtcInstanceWithError(editor).formatter.matchAll(names, vars);
      const matchNodeFormat = (editor, node, name2, vars, similar) => getRtcInstanceWithError(editor).formatter.matchNode(node, name2, vars, similar);
      const canApplyFormat = (editor, name2) => getRtcInstanceWithError(editor).formatter.canApply(name2);
      const closestFormat = (editor, names) => getRtcInstanceWithError(editor).formatter.closest(names);
      const applyFormat = (editor, name2, vars, node) => {
        getRtcInstanceWithError(editor).formatter.apply(name2, vars, node);
      };
      const removeFormat = (editor, name2, vars, node, similar) => {
        getRtcInstanceWithError(editor).formatter.remove(name2, vars, node, similar);
      };
      const toggleFormat = (editor, name2, vars, node) => {
        getRtcInstanceWithError(editor).formatter.toggle(name2, vars, node);
      };
      const formatChanged = (editor, registeredFormatListeners, formats, callback, similar, vars) => getRtcInstanceWithError(editor).formatter.formatChanged(registeredFormatListeners, formats, callback, similar, vars);
      const getContent$2 = (editor, args) => getRtcInstanceWithFallback(editor).editor.getContent(args);
      const setContent$2 = (editor, content, args) => getRtcInstanceWithFallback(editor).editor.setContent(content, args);
      const insertContent$1 = (editor, value2, details) => getRtcInstanceWithFallback(editor).editor.insertContent(value2, details);
      const getSelectedContent = (editor, format, args) => getRtcInstanceWithError(editor).selection.getContent(format, args);
      const addVisual$1 = (editor, elm) => getRtcInstanceWithError(editor).editor.addVisual(elm);
      const bindEvents = (editor) => getRtcInstanceWithError(editor).init.bindEvents();
      const getContent$1 = (editor, args = {}) => {
        const format = args.format ? args.format : "html";
        return getSelectedContent(editor, format, args);
      };
      const removeEmpty = (text2) => {
        if (text2.dom.length === 0) {
          remove$4(text2);
          return Optional.none();
        } else {
          return Optional.some(text2);
        }
      };
      const walkPastBookmark = (node, start2) => node.filter((elm) => BookmarkManager.isBookmarkNode(elm.dom)).bind(start2 ? nextSibling : prevSibling);
      const merge$1 = (outer, inner, rng, start2, schema) => {
        const outerElm = outer.dom;
        const innerElm = inner.dom;
        const oldLength = start2 ? outerElm.length : innerElm.length;
        if (start2) {
          mergeTextNodes(outerElm, innerElm, schema, false, !start2);
          rng.setStart(innerElm, oldLength);
        } else {
          mergeTextNodes(innerElm, outerElm, schema, false, !start2);
          rng.setEnd(innerElm, oldLength);
        }
      };
      const normalizeTextIfRequired = (inner, start2, schema) => {
        parent(inner).each((root) => {
          const text2 = inner.dom;
          if (start2 && needsToBeNbspLeft(root, CaretPosition(text2, 0), schema)) {
            normalizeWhitespaceAfter(text2, 0, schema);
          } else if (!start2 && needsToBeNbspRight(root, CaretPosition(text2, text2.length), schema)) {
            normalizeWhitespaceBefore(text2, text2.length, schema);
          }
        });
      };
      const mergeAndNormalizeText = (outerNode, innerNode, rng, start2, schema) => {
        outerNode.bind((outer) => {
          const normalizer = start2 ? normalizeWhitespaceBefore : normalizeWhitespaceAfter;
          normalizer(outer.dom, start2 ? outer.dom.length : 0, schema);
          return innerNode.filter(isText$c).map((inner) => merge$1(outer, inner, rng, start2, schema));
        }).orThunk(() => {
          const innerTextNode = walkPastBookmark(innerNode, start2).or(innerNode).filter(isText$c);
          return innerTextNode.map((inner) => normalizeTextIfRequired(inner, start2, schema));
        });
      };
      const rngSetContent = (rng, fragment, schema) => {
        const firstChild2 = Optional.from(fragment.firstChild).map(SugarElement.fromDom);
        const lastChild2 = Optional.from(fragment.lastChild).map(SugarElement.fromDom);
        rng.deleteContents();
        rng.insertNode(fragment);
        const prevText = firstChild2.bind(prevSibling).filter(isText$c).bind(removeEmpty);
        const nextText = lastChild2.bind(nextSibling).filter(isText$c).bind(removeEmpty);
        mergeAndNormalizeText(prevText, firstChild2, rng, true, schema);
        mergeAndNormalizeText(nextText, lastChild2, rng, false, schema);
        rng.collapse(false);
      };
      const setupArgs$2 = (args, content) => ({
        format: "html",
        ...args,
        set: true,
        selection: true,
        content
      });
      const cleanContent = (editor, args) => {
        if (args.format !== "raw") {
          const rng = editor.selection.getRng();
          const contextBlock = editor.dom.getParent(rng.commonAncestorContainer, editor.dom.isBlock);
          const contextArgs = contextBlock ? { context: contextBlock.nodeName.toLowerCase() } : {};
          const node = editor.parser.parse(args.content, {
            forced_root_block: false,
            ...contextArgs,
            ...args
          });
          return HtmlSerializer({ validate: false }, editor.schema).serialize(node);
        } else {
          return args.content;
        }
      };
      const setContent$1 = (editor, content, args = {}) => {
        const defaultedArgs = setupArgs$2(args, content);
        preProcessSetContent(editor, defaultedArgs).each((updatedArgs) => {
          const cleanedContent = cleanContent(editor, updatedArgs);
          const rng = editor.selection.getRng();
          rngSetContent(rng, rng.createContextualFragment(cleanedContent), editor.schema);
          editor.selection.setRng(rng);
          scrollRangeIntoView(editor, rng);
          postProcessSetContent(editor, cleanedContent, updatedArgs);
        });
      };
      const deleteFromCallbackMap = (callbackMap, selector, callback) => {
        if (has$2(callbackMap, selector)) {
          const newCallbacks = filter$5(callbackMap[selector], (cb) => cb !== callback);
          if (newCallbacks.length === 0) {
            delete callbackMap[selector];
          } else {
            callbackMap[selector] = newCallbacks;
          }
        }
      };
      var SelectorChanged = (dom2, editor) => {
        let selectorChangedData;
        let currentSelectors;
        const findMatchingNode = (selector, nodes) => find$2(nodes, (node) => dom2.is(node, selector));
        const getParents2 = (elem) => dom2.getParents(elem, void 0, dom2.getRoot());
        const setup2 = () => {
          selectorChangedData = {};
          currentSelectors = {};
          editor.on("NodeChange", (e) => {
            const node = e.element;
            const parents2 = getParents2(node);
            const matchedSelectors = {};
            each$d(selectorChangedData, (callbacks, selector) => {
              findMatchingNode(selector, parents2).each((node2) => {
                if (!currentSelectors[selector]) {
                  each$e(callbacks, (callback) => {
                    callback(true, {
                      node: node2,
                      selector,
                      parents: parents2
                    });
                  });
                  currentSelectors[selector] = callbacks;
                }
                matchedSelectors[selector] = callbacks;
              });
            });
            each$d(currentSelectors, (callbacks, selector) => {
              if (!matchedSelectors[selector]) {
                delete currentSelectors[selector];
                each$e(callbacks, (callback) => {
                  callback(false, {
                    node,
                    selector,
                    parents: parents2
                  });
                });
              }
            });
          });
        };
        return {
          selectorChangedWithUnbind: (selector, callback) => {
            if (!selectorChangedData) {
              setup2();
            }
            if (!selectorChangedData[selector]) {
              selectorChangedData[selector] = [];
            }
            selectorChangedData[selector].push(callback);
            findMatchingNode(selector, getParents2(editor.selection.getStart())).each(() => {
              currentSelectors[selector] = selectorChangedData[selector];
            });
            return {
              unbind: () => {
                deleteFromCallbackMap(selectorChangedData, selector, callback);
                deleteFromCallbackMap(currentSelectors, selector, callback);
              }
            };
          }
        };
      };
      const isAttachedToDom = (node) => {
        return !!(node && node.ownerDocument) && contains(SugarElement.fromDom(node.ownerDocument), SugarElement.fromDom(node));
      };
      const isValidRange = (rng) => {
        if (!rng) {
          return false;
        } else {
          return isAttachedToDom(rng.startContainer) && isAttachedToDom(rng.endContainer);
        }
      };
      const EditorSelection = (dom2, win, serializer, editor) => {
        let selectedRange;
        let explicitRange;
        const { selectorChangedWithUnbind } = SelectorChanged(dom2, editor);
        const setCursorLocation = (node, offset) => {
          const rng = dom2.createRng();
          if (isNonNullable(node) && isNonNullable(offset)) {
            rng.setStart(node, offset);
            rng.setEnd(node, offset);
            setRng(rng);
            collapse2(false);
          } else {
            moveEndPoint(dom2, rng, editor.getBody(), true);
            setRng(rng);
          }
        };
        const getContent2 = (args) => getContent$1(editor, args);
        const setContent2 = (content, args) => setContent$1(editor, content, args);
        const getStart$12 = (real) => getStart(editor.getBody(), getRng$1(), real);
        const getEnd$1 = (real) => getEnd(editor.getBody(), getRng$1(), real);
        const getBookmark2 = (type2, normalized) => bookmarkManager.getBookmark(type2, normalized);
        const moveToBookmark2 = (bookmark) => bookmarkManager.moveToBookmark(bookmark);
        const select$1 = (node, content) => {
          select(dom2, node, content).each(setRng);
          return node;
        };
        const isCollapsed = () => {
          const rng = getRng$1(), sel = getSel();
          if (!rng || rng.item) {
            return false;
          }
          if (rng.compareEndPoints) {
            return rng.compareEndPoints("StartToEnd", rng) === 0;
          }
          return !sel || rng.collapsed;
        };
        const isEditable2 = () => {
          if (editor.mode.isReadOnly()) {
            return false;
          }
          const rng = getRng$1();
          const fakeSelectedElements = editor.getBody().querySelectorAll('[data-mce-selected="1"]');
          if (fakeSelectedElements.length > 0) {
            return forall(fakeSelectedElements, (el) => dom2.isEditable(el.parentElement));
          } else {
            return isEditableRange(dom2, rng);
          }
        };
        const collapse2 = (toStart) => {
          const rng = getRng$1();
          rng.collapse(!!toStart);
          setRng(rng);
        };
        const getSel = () => win.getSelection ? win.getSelection() : win.document.selection;
        const getRng$1 = () => {
          let rng;
          const tryCompareBoundaryPoints = (how, sourceRange, destinationRange) => {
            try {
              return sourceRange.compareBoundaryPoints(how, destinationRange);
            } catch (_a) {
              return -1;
            }
          };
          const doc = win.document;
          if (isNonNullable(editor.bookmark) && !hasFocus(editor)) {
            const bookmark = getRng(editor);
            if (bookmark.isSome()) {
              return bookmark.map((r2) => processRanges(editor, [r2])[0]).getOr(doc.createRange());
            }
          }
          try {
            const selection = getSel();
            if (selection && !isRestrictedNode(selection.anchorNode)) {
              if (selection.rangeCount > 0) {
                rng = selection.getRangeAt(0);
              } else {
                rng = doc.createRange();
              }
              rng = processRanges(editor, [rng])[0];
            }
          } catch (_a) {
          }
          if (!rng) {
            rng = doc.createRange();
          }
          if (isDocument$1(rng.startContainer) && rng.collapsed) {
            const elm = dom2.getRoot();
            rng.setStart(elm, 0);
            rng.setEnd(elm, 0);
          }
          if (selectedRange && explicitRange) {
            if (tryCompareBoundaryPoints(rng.START_TO_START, rng, selectedRange) === 0 && tryCompareBoundaryPoints(rng.END_TO_END, rng, selectedRange) === 0) {
              rng = explicitRange;
            } else {
              selectedRange = null;
              explicitRange = null;
            }
          }
          return rng;
        };
        const setRng = (rng, forward) => {
          if (!isValidRange(rng)) {
            return;
          }
          const sel = getSel();
          const evt = editor.dispatch("SetSelectionRange", {
            range: rng,
            forward
          });
          rng = evt.range;
          if (sel) {
            explicitRange = rng;
            try {
              sel.removeAllRanges();
              sel.addRange(rng);
            } catch (_a) {
            }
            if (forward === false && sel.extend) {
              sel.collapse(rng.endContainer, rng.endOffset);
              sel.extend(rng.startContainer, rng.startOffset);
            }
            selectedRange = sel.rangeCount > 0 ? sel.getRangeAt(0) : null;
          }
          if (!rng.collapsed && rng.startContainer === rng.endContainer && (sel === null || sel === void 0 ? void 0 : sel.setBaseAndExtent)) {
            if (rng.endOffset - rng.startOffset < 2) {
              if (rng.startContainer.hasChildNodes()) {
                const node = rng.startContainer.childNodes[rng.startOffset];
                if (node && node.nodeName === "IMG") {
                  sel.setBaseAndExtent(rng.startContainer, rng.startOffset, rng.endContainer, rng.endOffset);
                  if (sel.anchorNode !== rng.startContainer || sel.focusNode !== rng.endContainer) {
                    sel.setBaseAndExtent(node, 0, node, 1);
                  }
                }
              }
            }
          }
          editor.dispatch("AfterSetSelectionRange", {
            range: rng,
            forward
          });
        };
        const setNode = (elm) => {
          setContent2(dom2.getOuterHTML(elm));
          return elm;
        };
        const getNode$12 = () => getNode(editor.getBody(), getRng$1());
        const getSelectedBlocks$1 = (startElm, endElm) => getSelectedBlocks(dom2, getRng$1(), startElm, endElm);
        const isForward = () => {
          const sel = getSel();
          const anchorNode = sel === null || sel === void 0 ? void 0 : sel.anchorNode;
          const focusNode = sel === null || sel === void 0 ? void 0 : sel.focusNode;
          if (!sel || !anchorNode || !focusNode || isRestrictedNode(anchorNode) || isRestrictedNode(focusNode)) {
            return true;
          }
          const anchorRange = dom2.createRng();
          const focusRange = dom2.createRng();
          try {
            anchorRange.setStart(anchorNode, sel.anchorOffset);
            anchorRange.collapse(true);
            focusRange.setStart(focusNode, sel.focusOffset);
            focusRange.collapse(true);
          } catch (_a) {
            return true;
          }
          return anchorRange.compareBoundaryPoints(anchorRange.START_TO_START, focusRange) <= 0;
        };
        const normalize2 = () => {
          const rng = getRng$1();
          const sel = getSel();
          if (!hasMultipleRanges(sel) && hasAnyRanges(editor)) {
            const normRng = normalize$2(dom2, rng);
            normRng.each((normRng2) => {
              setRng(normRng2, isForward());
            });
            return normRng.getOr(rng);
          }
          return rng;
        };
        const selectorChanged = (selector, callback) => {
          selectorChangedWithUnbind(selector, callback);
          return exports2;
        };
        const getScrollContainer = () => {
          let scrollContainer;
          let node = dom2.getRoot();
          while (node && node.nodeName !== "BODY") {
            if (node.scrollHeight > node.clientHeight) {
              scrollContainer = node;
              break;
            }
            node = node.parentNode;
          }
          return scrollContainer;
        };
        const scrollIntoView = (elm, alignToTop) => {
          if (isNonNullable(elm)) {
            scrollElementIntoView(editor, elm, alignToTop);
          } else {
            scrollRangeIntoView(editor, getRng$1(), alignToTop);
          }
        };
        const placeCaretAt2 = (clientX, clientY) => setRng(fromPoint(clientX, clientY, editor.getDoc()));
        const getBoundingClientRect2 = () => {
          const rng = getRng$1();
          return rng.collapsed ? CaretPosition.fromRangeStart(rng).getClientRects()[0] : rng.getBoundingClientRect();
        };
        const destroy2 = () => {
          win = selectedRange = explicitRange = null;
          controlSelection.destroy();
        };
        const expand = (options = { type: "word" }) => setRng(RangeUtils(dom2).expand(getRng$1(), options));
        const exports2 = {
          dom: dom2,
          win,
          serializer,
          editor,
          expand,
          collapse: collapse2,
          setCursorLocation,
          getContent: getContent2,
          setContent: setContent2,
          getBookmark: getBookmark2,
          moveToBookmark: moveToBookmark2,
          select: select$1,
          isCollapsed,
          isEditable: isEditable2,
          isForward,
          setNode,
          getNode: getNode$12,
          getSel,
          setRng,
          getRng: getRng$1,
          getStart: getStart$12,
          getEnd: getEnd$1,
          getSelectedBlocks: getSelectedBlocks$1,
          normalize: normalize2,
          selectorChanged,
          selectorChangedWithUnbind,
          getScrollContainer,
          scrollIntoView,
          placeCaretAt: placeCaretAt2,
          getBoundingClientRect: getBoundingClientRect2,
          destroy: destroy2
        };
        const bookmarkManager = BookmarkManager(exports2);
        const controlSelection = ControlSelection(exports2, editor);
        exports2.bookmarkManager = bookmarkManager;
        exports2.controlSelection = controlSelection;
        return exports2;
      };
      const addNodeFilter = (settings, htmlParser, schema) => {
        htmlParser.addNodeFilter("br", (nodes, _, args) => {
          const blockElements = Tools.extend({}, schema.getBlockElements());
          const nonEmptyElements = schema.getNonEmptyElements();
          const whitespaceElements = schema.getWhitespaceElements();
          blockElements.body = 1;
          const isBlock2 = (node) => node.name in blockElements || isTransparentAstBlock(schema, node);
          for (let i = 0, l = nodes.length; i < l; i++) {
            let node = nodes[i];
            let parent2 = node.parent;
            if (parent2 && isBlock2(parent2) && node === parent2.lastChild) {
              let prev2 = node.prev;
              while (prev2) {
                const prevName = prev2.name;
                if (prevName !== "span" || prev2.attr("data-mce-type") !== "bookmark") {
                  if (prevName === "br") {
                    node = null;
                  }
                  break;
                }
                prev2 = prev2.prev;
              }
              if (node) {
                node.remove();
                if (isEmpty(schema, nonEmptyElements, whitespaceElements, parent2)) {
                  const elementRule = schema.getElementRule(parent2.name);
                  if (elementRule) {
                    if (elementRule.removeEmpty) {
                      parent2.remove();
                    } else if (elementRule.paddEmpty) {
                      paddEmptyNode(settings, args, isBlock2, parent2);
                    }
                  }
                }
              }
            } else {
              let lastParent = node;
              while (parent2 && parent2.firstChild === lastParent && parent2.lastChild === lastParent) {
                lastParent = parent2;
                if (blockElements[parent2.name]) {
                  break;
                }
                parent2 = parent2.parent;
              }
              if (lastParent === parent2) {
                const textNode = new AstNode("#text", 3);
                textNode.value = nbsp;
                node.replace(textNode);
              }
            }
          }
        });
      };
      const register$3 = (htmlParser, settings, dom2) => {
        htmlParser.addAttributeFilter("data-mce-tabindex", (nodes, name2) => {
          let i = nodes.length;
          while (i--) {
            const node = nodes[i];
            node.attr("tabindex", node.attr("data-mce-tabindex"));
            node.attr(name2, null);
          }
        });
        htmlParser.addAttributeFilter("src,href,style", (nodes, name2) => {
          const internalName = "data-mce-" + name2;
          const urlConverter = settings.url_converter;
          const urlConverterScope = settings.url_converter_scope;
          let i = nodes.length;
          while (i--) {
            const node = nodes[i];
            let value2 = node.attr(internalName);
            if (value2 !== void 0) {
              node.attr(name2, value2.length > 0 ? value2 : null);
              node.attr(internalName, null);
            } else {
              value2 = node.attr(name2);
              if (name2 === "style") {
                value2 = dom2.serializeStyle(dom2.parseStyle(value2), node.name);
              } else if (urlConverter) {
                value2 = urlConverter.call(urlConverterScope, value2, name2, node.name);
              }
              node.attr(name2, value2.length > 0 ? value2 : null);
            }
          }
        });
        htmlParser.addAttributeFilter("class", (nodes) => {
          let i = nodes.length;
          while (i--) {
            const node = nodes[i];
            let value2 = node.attr("class");
            if (value2) {
              value2 = value2.replace(/(?:^|\s)mce-item-\w+(?!\S)/g, "");
              node.attr("class", value2.length > 0 ? value2 : null);
            }
          }
        });
        htmlParser.addAttributeFilter("data-mce-type", (nodes, name2, args) => {
          let i = nodes.length;
          while (i--) {
            const node = nodes[i];
            if (node.attr("data-mce-type") === "bookmark" && !args.cleanup) {
              const hasChildren = Optional.from(node.firstChild).exists((firstChild2) => {
                var _a;
                return !isZwsp((_a = firstChild2.value) !== null && _a !== void 0 ? _a : "");
              });
              if (hasChildren) {
                node.unwrap();
              } else {
                node.remove();
              }
            }
          }
        });
        htmlParser.addNodeFilter("script,style", (nodes, name2) => {
          var _a;
          const trim2 = (value2) => {
            return value2.replace(/(<!--\[CDATA\[|\]\]-->)/g, "\n").replace(/^[\r\n]*|[\r\n]*$/g, "").replace(/^\s*((<!--)?(\s*\/\/)?\s*<!\[CDATA\[|(<!--\s*)?\/\*\s*<!\[CDATA\[\s*\*\/|(\/\/)?\s*<!--|\/\*\s*<!--\s*\*\/)\s*[\r\n]*/gi, "").replace(/\s*(\/\*\s*\]\]>\s*\*\/(-->)?|\s*\/\/\s*\]\]>(-->)?|\/\/\s*(-->)?|\]\]>|\/\*\s*-->\s*\*\/|\s*-->\s*)\s*$/g, "");
          };
          let i = nodes.length;
          while (i--) {
            const node = nodes[i];
            const firstChild2 = node.firstChild;
            const value2 = (_a = firstChild2 === null || firstChild2 === void 0 ? void 0 : firstChild2.value) !== null && _a !== void 0 ? _a : "";
            if (name2 === "script") {
              const type2 = node.attr("type");
              if (type2) {
                node.attr("type", type2 === "mce-no/type" ? null : type2.replace(/^mce\-/, ""));
              }
              if (settings.element_format === "xhtml" && firstChild2 && value2.length > 0) {
                firstChild2.value = "// <![CDATA[\n" + trim2(value2) + "\n// ]]>";
              }
            } else {
              if (settings.element_format === "xhtml" && firstChild2 && value2.length > 0) {
                firstChild2.value = "<!--\n" + trim2(value2) + "\n-->";
              }
            }
          }
        });
        htmlParser.addNodeFilter("#comment", (nodes) => {
          let i = nodes.length;
          while (i--) {
            const node = nodes[i];
            const value2 = node.value;
            if (settings.preserve_cdata && (value2 === null || value2 === void 0 ? void 0 : value2.indexOf("[CDATA[")) === 0) {
              node.name = "#cdata";
              node.type = 4;
              node.value = dom2.decode(value2.replace(/^\[CDATA\[|\]\]$/g, ""));
            } else if ((value2 === null || value2 === void 0 ? void 0 : value2.indexOf("mce:protected ")) === 0) {
              node.name = "#text";
              node.type = 3;
              node.raw = true;
              node.value = unescape(value2).substr(14);
            }
          }
        });
        htmlParser.addNodeFilter("xml:namespace,input", (nodes, name2) => {
          let i = nodes.length;
          while (i--) {
            const node = nodes[i];
            if (node.type === 7) {
              node.remove();
            } else if (node.type === 1) {
              if (name2 === "input" && !node.attr("type")) {
                node.attr("type", "text");
              }
            }
          }
        });
        htmlParser.addAttributeFilter("data-mce-type", (nodes) => {
          each$e(nodes, (node) => {
            if (node.attr("data-mce-type") === "format-caret") {
              if (node.isEmpty(htmlParser.schema.getNonEmptyElements())) {
                node.remove();
              } else {
                node.unwrap();
              }
            }
          });
        });
        htmlParser.addAttributeFilter("data-mce-src,data-mce-href,data-mce-style,data-mce-selected,data-mce-expando,data-mce-block,data-mce-type,data-mce-resize,data-mce-placeholder", (nodes, name2) => {
          let i = nodes.length;
          while (i--) {
            nodes[i].attr(name2, null);
          }
        });
        if (settings.remove_trailing_brs) {
          addNodeFilter(settings, htmlParser, htmlParser.schema);
        }
      };
      const trimTrailingBr = (rootNode) => {
        const isBr2 = (node) => {
          return (node === null || node === void 0 ? void 0 : node.name) === "br";
        };
        const brNode1 = rootNode.lastChild;
        if (isBr2(brNode1)) {
          const brNode2 = brNode1.prev;
          if (isBr2(brNode2)) {
            brNode1.remove();
            brNode2.remove();
          }
        }
      };
      const preProcess$1 = (editor, node, args) => {
        let oldDoc;
        const dom2 = editor.dom;
        let clonedNode = node.cloneNode(true);
        const impl = document.implementation;
        if (impl.createHTMLDocument) {
          const doc = impl.createHTMLDocument("");
          Tools.each(clonedNode.nodeName === "BODY" ? clonedNode.childNodes : [clonedNode], (node2) => {
            doc.body.appendChild(doc.importNode(node2, true));
          });
          if (clonedNode.nodeName !== "BODY") {
            clonedNode = doc.body.firstChild;
          } else {
            clonedNode = doc.body;
          }
          oldDoc = dom2.doc;
          dom2.doc = doc;
        }
        firePreProcess(editor, {
          ...args,
          node: clonedNode
        });
        if (oldDoc) {
          dom2.doc = oldDoc;
        }
        return clonedNode;
      };
      const shouldFireEvent = (editor, args) => {
        return isNonNullable(editor) && editor.hasEventListeners("PreProcess") && !args.no_events;
      };
      const process$1 = (editor, node, args) => {
        return shouldFireEvent(editor, args) ? preProcess$1(editor, node, args) : node;
      };
      const addTempAttr = (htmlParser, tempAttrs, name2) => {
        if (Tools.inArray(tempAttrs, name2) === -1) {
          htmlParser.addAttributeFilter(name2, (nodes, name3) => {
            let i = nodes.length;
            while (i--) {
              nodes[i].attr(name3, null);
            }
          });
          tempAttrs.push(name2);
        }
      };
      const postProcess = (editor, args, content) => {
        if (!args.no_events && editor) {
          const outArgs = firePostProcess(editor, {
            ...args,
            content
          });
          return outArgs.content;
        } else {
          return content;
        }
      };
      const getHtmlFromNode = (dom2, node, args) => {
        const html2 = trim$2(args.getInner ? node.innerHTML : dom2.getOuterHTML(node));
        return args.selection || isWsPreserveElement(SugarElement.fromDom(node)) ? html2 : Tools.trim(html2);
      };
      const parseHtml = (htmlParser, html2, args) => {
        const parserArgs = args.selection ? {
          forced_root_block: false,
          ...args
        } : args;
        const rootNode = htmlParser.parse(html2, parserArgs);
        trimTrailingBr(rootNode);
        return rootNode;
      };
      const serializeNode = (settings, schema, node) => {
        const htmlSerializer = HtmlSerializer(settings, schema);
        return htmlSerializer.serialize(node);
      };
      const toHtml = (editor, settings, schema, rootNode, args) => {
        const content = serializeNode(settings, schema, rootNode);
        return postProcess(editor, args, content);
      };
      const DomSerializerImpl = (settings, editor) => {
        const tempAttrs = ["data-mce-selected"];
        const defaultedSettings = {
          entity_encoding: "named",
          remove_trailing_brs: true,
          pad_empty_with_br: false,
          ...settings
        };
        const dom2 = editor && editor.dom ? editor.dom : DOMUtils.DOM;
        const schema = editor && editor.schema ? editor.schema : Schema(defaultedSettings);
        const htmlParser = DomParser(defaultedSettings, schema);
        register$3(htmlParser, defaultedSettings, dom2);
        const serialize = (node, parserArgs = {}) => {
          const args = {
            format: "html",
            ...parserArgs
          };
          const targetNode = process$1(editor, node, args);
          const html2 = getHtmlFromNode(dom2, targetNode, args);
          const rootNode = parseHtml(htmlParser, html2, args);
          return args.format === "tree" ? rootNode : toHtml(editor, defaultedSettings, schema, rootNode, args);
        };
        return {
          schema,
          addNodeFilter: htmlParser.addNodeFilter,
          addAttributeFilter: htmlParser.addAttributeFilter,
          serialize,
          addRules: schema.addValidElements,
          setRules: schema.setValidElements,
          addTempAttr: curry(addTempAttr, htmlParser, tempAttrs),
          getTempAttrs: constant(tempAttrs),
          getNodeFilters: htmlParser.getNodeFilters,
          getAttributeFilters: htmlParser.getAttributeFilters,
          removeNodeFilter: htmlParser.removeNodeFilter,
          removeAttributeFilter: htmlParser.removeAttributeFilter
        };
      };
      const DomSerializer = (settings, editor) => {
        const domSerializer = DomSerializerImpl(settings, editor);
        return {
          schema: domSerializer.schema,
          addNodeFilter: domSerializer.addNodeFilter,
          addAttributeFilter: domSerializer.addAttributeFilter,
          serialize: domSerializer.serialize,
          addRules: domSerializer.addRules,
          setRules: domSerializer.setRules,
          addTempAttr: domSerializer.addTempAttr,
          getTempAttrs: domSerializer.getTempAttrs,
          getNodeFilters: domSerializer.getNodeFilters,
          getAttributeFilters: domSerializer.getAttributeFilters,
          removeNodeFilter: domSerializer.removeNodeFilter,
          removeAttributeFilter: domSerializer.removeAttributeFilter
        };
      };
      const defaultFormat$1 = "html";
      const setupArgs$1 = (args, format) => ({
        ...args,
        format,
        get: true,
        getInner: true
      });
      const getContent = (editor, args = {}) => {
        const format = args.format ? args.format : defaultFormat$1;
        const defaultedArgs = setupArgs$1(args, format);
        return preProcessGetContent(editor, defaultedArgs).fold(identity, (updatedArgs) => {
          const content = getContent$2(editor, updatedArgs);
          return postProcessGetContent(editor, content, updatedArgs);
        });
      };
      const defaultFormat = "html";
      const setupArgs = (args, content) => ({
        format: defaultFormat,
        ...args,
        set: true,
        content
      });
      const setContent = (editor, content, args = {}) => {
        const defaultedArgs = setupArgs(args, content);
        return preProcessSetContent(editor, defaultedArgs).map((updatedArgs) => {
          const result = setContent$2(editor, updatedArgs.content, updatedArgs);
          postProcessSetContent(editor, result.html, updatedArgs);
          return result.content;
        }).getOr(content);
      };
      const removedOptions = "autoresize_on_init,content_editable_state,padd_empty_with_br,block_elements,boolean_attributes,editor_deselector,editor_selector,elements,file_browser_callback_types,filepicker_validator_handler,force_hex_style_colors,force_p_newlines,gecko_spellcheck,images_dataimg_filter,media_scripts,mode,move_caret_before_on_enter_elements,non_empty_elements,self_closing_elements,short_ended_elements,special,spellchecker_select_languages,spellchecker_whitelist,tab_focus,tabfocus_elements,table_responsive_width,text_block_elements,text_inline_elements,toolbar_drawer,types,validate,whitespace_elements,paste_enable_default_filters,paste_filter_drop,paste_word_valid_elements,paste_retain_style_properties,paste_convert_word_fake_lists,template_cdate_classes,template_mdate_classes,template_selected_content_classes,template_preview_replace_values,template_replace_values,templates,template_cdate_format,template_mdate_format".split(",");
      const deprecatedOptions = [];
      const removedPlugins = "bbcode,colorpicker,contextmenu,fullpage,legacyoutput,spellchecker,template,textcolor,rtc".split(",");
      const deprecatedPlugins = [];
      const getMatchingOptions = (options, searchingFor) => {
        const settingNames = filter$5(searchingFor, (setting) => has$2(options, setting));
        return sort(settingNames);
      };
      const getRemovedOptions = (options) => {
        const settingNames = getMatchingOptions(options, removedOptions);
        const forcedRootBlock = options.forced_root_block;
        if (forcedRootBlock === false || forcedRootBlock === "") {
          settingNames.push("forced_root_block (false only)");
        }
        return sort(settingNames);
      };
      const getDeprecatedOptions = (options) => getMatchingOptions(options, deprecatedOptions);
      const getMatchingPlugins = (options, searchingFor) => {
        const plugins = Tools.makeMap(options.plugins, " ");
        const hasPlugin = (plugin) => has$2(plugins, plugin);
        const pluginNames = filter$5(searchingFor, hasPlugin);
        return sort(pluginNames);
      };
      const getRemovedPlugins = (options) => getMatchingPlugins(options, removedPlugins);
      const getDeprecatedPlugins = (options) => getMatchingPlugins(options, deprecatedPlugins.map((entry) => entry.name));
      const logRemovedWarnings = (rawOptions, normalizedOptions) => {
        const removedOptions2 = getRemovedOptions(rawOptions);
        const removedPlugins2 = getRemovedPlugins(normalizedOptions);
        const hasRemovedPlugins = removedPlugins2.length > 0;
        const hasRemovedOptions = removedOptions2.length > 0;
        const isLegacyMobileTheme = normalizedOptions.theme === "mobile";
        if (hasRemovedPlugins || hasRemovedOptions || isLegacyMobileTheme) {
          const listJoiner = "\n- ";
          const themesMessage = isLegacyMobileTheme ? `

Themes:${listJoiner}mobile` : "";
          const pluginsMessage = hasRemovedPlugins ? `

Plugins:${listJoiner}${removedPlugins2.join(listJoiner)}` : "";
          const optionsMessage = hasRemovedOptions ? `

Options:${listJoiner}${removedOptions2.join(listJoiner)}` : "";
          console.warn("The following deprecated features are currently enabled and have been removed in TinyMCE 7.0. These features will no longer work and should be removed from the TinyMCE configuration. See https://www.tiny.cloud/docs/tinymce/7/migration-from-6x/ for more information." + themesMessage + pluginsMessage + optionsMessage);
        }
      };
      const getPluginDescription = (name2) => find$2(deprecatedPlugins, (entry) => entry.name === name2).fold(() => name2, (entry) => {
        if (entry.replacedWith) {
          return `${name2}, replaced by ${entry.replacedWith}`;
        } else {
          return name2;
        }
      });
      const logDeprecatedWarnings = (rawOptions, normalizedOptions) => {
        const deprecatedOptions2 = getDeprecatedOptions(rawOptions);
        const deprecatedPlugins2 = getDeprecatedPlugins(normalizedOptions);
        const hasDeprecatedPlugins = deprecatedPlugins2.length > 0;
        const hasDeprecatedOptions = deprecatedOptions2.length > 0;
        if (hasDeprecatedPlugins || hasDeprecatedOptions) {
          const listJoiner = "\n- ";
          const pluginsMessage = hasDeprecatedPlugins ? `

Plugins:${listJoiner}${deprecatedPlugins2.map(getPluginDescription).join(listJoiner)}` : "";
          const optionsMessage = hasDeprecatedOptions ? `

Options:${listJoiner}${deprecatedOptions2.join(listJoiner)}` : "";
          console.warn("The following deprecated features are currently enabled but will be removed soon." + pluginsMessage + optionsMessage);
        }
      };
      const logWarnings = (rawOptions, normalizedOptions) => {
        logRemovedWarnings(rawOptions, normalizedOptions);
        logDeprecatedWarnings(rawOptions, normalizedOptions);
      };
      const DOM$8 = DOMUtils.DOM;
      const restoreOriginalStyles = (editor) => {
        DOM$8.setStyle(editor.id, "display", editor.orgDisplay);
      };
      const safeDestroy = (x) => Optional.from(x).each((x2) => x2.destroy());
      const clearDomReferences = (editor) => {
        const ed = editor;
        ed.contentAreaContainer = ed.formElement = ed.container = ed.editorContainer = null;
        ed.bodyElement = ed.contentDocument = ed.contentWindow = null;
        ed.iframeElement = ed.targetElm = null;
        const selection = editor.selection;
        if (selection) {
          const dom2 = selection.dom;
          ed.selection = selection.win = selection.dom = dom2.doc = null;
        }
      };
      const restoreForm = (editor) => {
        const form = editor.formElement;
        if (form) {
          if (form._mceOldSubmit) {
            form.submit = form._mceOldSubmit;
            delete form._mceOldSubmit;
          }
          DOM$8.unbind(form, "submit reset", editor.formEventDelegate);
        }
      };
      const remove$1 = (editor) => {
        if (!editor.removed) {
          const { _selectionOverrides, editorUpload } = editor;
          const body = editor.getBody();
          const element = editor.getElement();
          if (body) {
            editor.save({ is_removing: true });
          }
          editor.removed = true;
          editor.unbindAllNativeEvents();
          if (editor.hasHiddenInput && isNonNullable(element === null || element === void 0 ? void 0 : element.nextSibling)) {
            DOM$8.remove(element.nextSibling);
          }
          fireRemove(editor);
          editor.editorManager.remove(editor);
          if (!editor.inline && body) {
            restoreOriginalStyles(editor);
          }
          fireDetach(editor);
          DOM$8.remove(editor.getContainer());
          safeDestroy(_selectionOverrides);
          safeDestroy(editorUpload);
          editor.destroy();
        }
      };
      const destroy = (editor, automatic) => {
        const { selection, dom: dom2 } = editor;
        if (editor.destroyed) {
          return;
        }
        if (!automatic && !editor.removed) {
          editor.remove();
          return;
        }
        if (!automatic) {
          editor.editorManager.off("beforeunload", editor._beforeUnload);
          if (editor.theme && editor.theme.destroy) {
            editor.theme.destroy();
          }
          safeDestroy(selection);
          safeDestroy(dom2);
        }
        restoreForm(editor);
        clearDomReferences(editor);
        editor.destroyed = true;
      };
      const CreateIconManager = () => {
        const lookup2 = {};
        const add2 = (id, iconPack) => {
          lookup2[id] = iconPack;
        };
        const get2 = (id) => {
          if (lookup2[id]) {
            return lookup2[id];
          } else {
            return { icons: {} };
          }
        };
        const has2 = (id) => has$2(lookup2, id);
        return {
          add: add2,
          get: get2,
          has: has2
        };
      };
      const IconManager = CreateIconManager();
      const ModelManager = AddOnManager.ModelManager;
      const getProp = (propName, elm) => {
        const rawElm = elm.dom;
        return rawElm[propName];
      };
      const getComputedSizeProp = (propName, elm) => parseInt(get$7(elm, propName), 10);
      const getClientWidth = curry(getProp, "clientWidth");
      const getClientHeight = curry(getProp, "clientHeight");
      const getMarginTop = curry(getComputedSizeProp, "margin-top");
      const getMarginLeft = curry(getComputedSizeProp, "margin-left");
      const getBoundingClientRect = (elm) => elm.dom.getBoundingClientRect();
      const isInsideElementContentArea = (bodyElm, clientX, clientY) => {
        const clientWidth = getClientWidth(bodyElm);
        const clientHeight = getClientHeight(bodyElm);
        return clientX >= 0 && clientY >= 0 && clientX <= clientWidth && clientY <= clientHeight;
      };
      const transpose = (inline, elm, clientX, clientY) => {
        const clientRect = getBoundingClientRect(elm);
        const deltaX = inline ? clientRect.left + elm.dom.clientLeft + getMarginLeft(elm) : 0;
        const deltaY = inline ? clientRect.top + elm.dom.clientTop + getMarginTop(elm) : 0;
        const x = clientX - deltaX;
        const y = clientY - deltaY;
        return {
          x,
          y
        };
      };
      const isXYInContentArea = (editor, clientX, clientY) => {
        const bodyElm = SugarElement.fromDom(editor.getBody());
        const targetElm = editor.inline ? bodyElm : documentElement(bodyElm);
        const transposedPoint = transpose(editor.inline, targetElm, clientX, clientY);
        return isInsideElementContentArea(targetElm, transposedPoint.x, transposedPoint.y);
      };
      const fromDomSafe = (node) => Optional.from(node).map(SugarElement.fromDom);
      const isEditorAttachedToDom = (editor) => {
        const rawContainer = editor.inline ? editor.getBody() : editor.getContentAreaContainer();
        return fromDomSafe(rawContainer).map(inBody).getOr(false);
      };
      var NotificationManagerImpl = () => {
        const unimplemented = () => {
          throw new Error("Theme did not provide a NotificationManager implementation.");
        };
        return {
          open: unimplemented,
          close: unimplemented,
          getArgs: unimplemented
        };
      };
      const NotificationManager = (editor) => {
        const notifications = [];
        const getImplementation = () => {
          const theme = editor.theme;
          return theme && theme.getNotificationManagerImpl ? theme.getNotificationManagerImpl() : NotificationManagerImpl();
        };
        const getTopNotification = () => {
          return Optional.from(notifications[0]);
        };
        const isEqual2 = (a, b) => {
          return a.type === b.type && a.text === b.text && !a.progressBar && !a.timeout && !b.progressBar && !b.timeout;
        };
        const reposition2 = () => {
          getTopNotification().each((notification) => {
            notification.reposition();
          });
        };
        const addNotification = (notification) => {
          notifications.push(notification);
        };
        const closeNotification = (notification) => {
          findIndex$2(notifications, (otherNotification) => {
            return otherNotification === notification;
          }).each((index) => {
            notifications.splice(index, 1);
          });
        };
        const open = (spec, fireEvent2 = true) => {
          if (editor.removed || !isEditorAttachedToDom(editor)) {
            return {};
          }
          if (fireEvent2) {
            editor.dispatch("BeforeOpenNotification", { notification: spec });
          }
          return find$2(notifications, (notification) => {
            return isEqual2(getImplementation().getArgs(notification), spec);
          }).getOrThunk(() => {
            editor.editorManager.setActive(editor);
            const notification = getImplementation().open(spec, () => {
              closeNotification(notification);
            }, () => hasEditorOrUiFocus(editor));
            addNotification(notification);
            reposition2();
            editor.dispatch("OpenNotification", { notification: { ...notification } });
            return notification;
          });
        };
        const close = () => {
          getTopNotification().each((notification) => {
            getImplementation().close(notification);
            closeNotification(notification);
            reposition2();
          });
        };
        const getNotifications = constant(notifications);
        const registerEvents2 = (editor2) => {
          editor2.on("SkinLoaded", () => {
            const serviceMessage = getServiceMessage(editor2);
            if (serviceMessage) {
              open({
                text: serviceMessage,
                type: "warning",
                timeout: 0
              }, false);
            }
            reposition2();
          });
          editor2.on("show ResizeEditor ResizeWindow NodeChange ToggleView FullscreenStateChanged", () => {
            requestAnimationFrame(reposition2);
          });
          editor2.on("remove", () => {
            each$e(notifications.slice(), (notification) => {
              getImplementation().close(notification);
            });
          });
          editor2.on("keydown", (e) => {
            var _a;
            const isF12 = ((_a = e.key) === null || _a === void 0 ? void 0 : _a.toLowerCase()) === "f12" || e.keyCode === 123;
            if (e.altKey && isF12) {
              e.preventDefault();
              getTopNotification().map((notificationApi) => SugarElement.fromDom(notificationApi.getEl())).each((elm) => focus$1(elm));
            }
          });
        };
        registerEvents2(editor);
        return {
          open,
          close,
          getNotifications
        };
      };
      const PluginManager = AddOnManager.PluginManager;
      const ThemeManager = AddOnManager.ThemeManager;
      var WindowManagerImpl = () => {
        const unimplemented = () => {
          throw new Error("Theme did not provide a WindowManager implementation.");
        };
        return {
          open: unimplemented,
          openUrl: unimplemented,
          alert: unimplemented,
          confirm: unimplemented,
          close: unimplemented
        };
      };
      const WindowManager = (editor) => {
        let dialogs = [];
        const getImplementation = () => {
          const theme = editor.theme;
          return theme && theme.getWindowManagerImpl ? theme.getWindowManagerImpl() : WindowManagerImpl();
        };
        const funcBind = (scope, f) => {
          return (...args) => {
            return f ? f.apply(scope, args) : void 0;
          };
        };
        const fireOpenEvent = (dialog) => {
          editor.dispatch("OpenWindow", { dialog });
        };
        const fireCloseEvent = (dialog) => {
          editor.dispatch("CloseWindow", { dialog });
        };
        const addDialog = (dialog) => {
          dialogs.push(dialog);
          fireOpenEvent(dialog);
        };
        const closeDialog = (dialog) => {
          fireCloseEvent(dialog);
          dialogs = filter$5(dialogs, (otherDialog) => {
            return otherDialog !== dialog;
          });
          if (dialogs.length === 0) {
            editor.focus();
          }
        };
        const getTopDialog = () => {
          return Optional.from(dialogs[dialogs.length - 1]);
        };
        const storeSelectionAndOpenDialog = (openDialog) => {
          editor.editorManager.setActive(editor);
          store(editor);
          editor.ui.show();
          const dialog = openDialog();
          addDialog(dialog);
          return dialog;
        };
        const open = (args, params) => {
          return storeSelectionAndOpenDialog(() => getImplementation().open(args, params, closeDialog));
        };
        const openUrl = (args) => {
          return storeSelectionAndOpenDialog(() => getImplementation().openUrl(args, closeDialog));
        };
        const alert = (message, callback, scope) => {
          const windowManagerImpl = getImplementation();
          windowManagerImpl.alert(message, funcBind(scope ? scope : windowManagerImpl, callback));
        };
        const confirm = (message, callback, scope) => {
          const windowManagerImpl = getImplementation();
          windowManagerImpl.confirm(message, funcBind(scope ? scope : windowManagerImpl, callback));
        };
        const close = () => {
          getTopDialog().each((dialog) => {
            getImplementation().close(dialog);
            closeDialog(dialog);
          });
        };
        editor.on("remove", () => {
          each$e(dialogs, (dialog) => {
            getImplementation().close(dialog);
          });
        });
        return {
          open,
          openUrl,
          alert,
          confirm,
          close
        };
      };
      const displayNotification = (editor, message) => {
        editor.notificationManager.open({
          type: "error",
          text: message
        });
      };
      const displayError = (editor, message) => {
        if (editor._skinLoaded) {
          displayNotification(editor, message);
        } else {
          editor.on("SkinLoaded", () => {
            displayNotification(editor, message);
          });
        }
      };
      const uploadError = (editor, message) => {
        displayError(editor, I18n.translate([
          "Failed to upload image: {0}",
          message
        ]));
      };
      const logError = (editor, errorType, msg) => {
        fireError(editor, errorType, { message: msg });
        console.error(msg);
      };
      const createLoadError = (type2, url, name2) => name2 ? `Failed to load ${type2}: ${name2} from url ${url}` : `Failed to load ${type2} url: ${url}`;
      const pluginLoadError = (editor, url, name2) => {
        logError(editor, "PluginLoadError", createLoadError("plugin", url, name2));
      };
      const iconsLoadError = (editor, url, name2) => {
        logError(editor, "IconsLoadError", createLoadError("icons", url, name2));
      };
      const languageLoadError = (editor, url, name2) => {
        logError(editor, "LanguageLoadError", createLoadError("language", url, name2));
      };
      const themeLoadError = (editor, url, name2) => {
        logError(editor, "ThemeLoadError", createLoadError("theme", url, name2));
      };
      const modelLoadError = (editor, url, name2) => {
        logError(editor, "ModelLoadError", createLoadError("model", url, name2));
      };
      const pluginInitError = (editor, name2, err) => {
        const message = I18n.translate([
          "Failed to initialize plugin: {0}",
          name2
        ]);
        fireError(editor, "PluginLoadError", { message });
        initError(message, err);
        displayError(editor, message);
      };
      const initError = (message, ...x) => {
        const console2 = window.console;
        if (console2) {
          if (console2.error) {
            console2.error(message, ...x);
          } else {
            console2.log(message, ...x);
          }
        }
      };
      const removeFakeSelection = (editor) => {
        Optional.from(editor.selection.getNode()).each((elm) => {
          elm.removeAttribute("data-mce-selected");
        });
      };
      const setEditorCommandState = (editor, cmd, state) => {
        try {
          editor.getDoc().execCommand(cmd, false, String(state));
        } catch (_a) {
        }
      };
      const setCommonEditorCommands = (editor, state) => {
        setEditorCommandState(editor, "StyleWithCSS", state);
        setEditorCommandState(editor, "enableInlineTableEditing", state);
        setEditorCommandState(editor, "enableObjectResizing", state);
      };
      const restoreFakeSelection = (editor) => {
        editor.selection.setRng(editor.selection.getRng());
      };
      const toggleClass = (elm, cls, state) => {
        if (has(elm, cls) && !state) {
          remove$6(elm, cls);
        } else if (state) {
          add$2(elm, cls);
        }
      };
      const disableEditor = (editor) => {
        const body = SugarElement.fromDom(editor.getBody());
        toggleClass(body, "mce-content-readonly", true);
        editor.selection.controlSelection.hideResizeRect();
        editor._selectionOverrides.hideFakeCaret();
        removeFakeSelection(editor);
      };
      const enableEditor = (editor) => {
        const body = SugarElement.fromDom(editor.getBody());
        toggleClass(body, "mce-content-readonly", false);
        if (editor.hasEditableRoot()) {
          set$3(body, true);
        }
        setCommonEditorCommands(editor, false);
        if (hasEditorOrUiFocus(editor)) {
          editor.focus();
        }
        restoreFakeSelection(editor);
        editor.nodeChanged();
      };
      const isDisabled = (editor) => isDisabled$1(editor);
      const internalContentEditableAttr = "data-mce-contenteditable";
      const switchOffContentEditableTrue = (elm) => {
        each$e(descendants(elm, '*[contenteditable="true"]'), (elm2) => {
          set$4(elm2, internalContentEditableAttr, "true");
          set$3(elm2, false);
        });
      };
      const switchOnContentEditableTrue = (elm) => {
        each$e(descendants(elm, `*[${internalContentEditableAttr}="true"]`), (elm2) => {
          remove$9(elm2, internalContentEditableAttr);
          set$3(elm2, true);
        });
      };
      const toggleDisabled = (editor, state) => {
        const body = SugarElement.fromDom(editor.getBody());
        if (state) {
          disableEditor(editor);
          set$3(body, false);
          switchOffContentEditableTrue(body);
        } else {
          switchOnContentEditableTrue(body);
          enableEditor(editor);
        }
      };
      const registerDisabledContentFilters = (editor) => {
        if (editor.serializer) {
          registerFilters(editor);
        } else {
          editor.on("PreInit", () => {
            registerFilters(editor);
          });
        }
      };
      const registerFilters = (editor) => {
        editor.parser.addAttributeFilter("contenteditable", (nodes) => {
          if (isDisabled(editor)) {
            each$e(nodes, (node) => {
              node.attr(internalContentEditableAttr, node.attr("contenteditable"));
              node.attr("contenteditable", "false");
            });
          }
        });
        editor.serializer.addAttributeFilter(internalContentEditableAttr, (nodes) => {
          if (isDisabled(editor)) {
            each$e(nodes, (node) => {
              node.attr("contenteditable", node.attr(internalContentEditableAttr));
            });
          }
        });
        editor.serializer.addTempAttr(internalContentEditableAttr);
      };
      const isClickEvent = (e) => e.type === "click";
      const allowedEvents = ["copy"];
      const isAllowedEventInDisabledMode = (e) => contains$2(allowedEvents, e.type);
      const getAnchorHrefOpt = (editor, elm) => {
        const isRoot2 = (elm2) => eq(elm2, SugarElement.fromDom(editor.getBody()));
        return closest$3(elm, "a", isRoot2).bind((a) => getOpt(a, "href"));
      };
      const processDisabledEvents = (editor, e) => {
        if (isClickEvent(e) && !VK.metaKeyPressed(e)) {
          const elm = SugarElement.fromDom(e.target);
          getAnchorHrefOpt(editor, elm).each((href) => {
            e.preventDefault();
            if (/^#/.test(href)) {
              const targetEl = editor.dom.select(`${href},[name="${removeLeading(href, "#")}"]`);
              if (targetEl.length) {
                editor.selection.scrollIntoView(targetEl[0], true);
              }
            } else {
              window.open(href, "_blank", "rel=noopener noreferrer,menubar=yes,toolbar=yes,location=yes,status=yes,resizable=yes,scrollbars=yes");
            }
          });
        } else if (isAllowedEventInDisabledMode(e)) {
          editor.dispatch(e.type, e);
        }
      };
      const registerDisabledModeEventHandlers = (editor) => {
        editor.on("ShowCaret ObjectSelected", (e) => {
          if (isDisabled(editor)) {
            e.preventDefault();
          }
        });
        editor.on("DisabledStateChange", (e) => {
          if (!e.isDefaultPrevented()) {
            toggleDisabled(editor, e.state);
          }
        });
      };
      const registerEventsAndFilters$1 = (editor) => {
        registerDisabledContentFilters(editor);
        registerDisabledModeEventHandlers(editor);
      };
      const isContentCssSkinName = (url) => /^[a-z0-9\-]+$/i.test(url);
      const toContentSkinResourceName = (url) => "content/" + url + "/content.css";
      const isBundledCssSkinName = (url) => tinymce.Resource.has(toContentSkinResourceName(url));
      const getContentCssUrls = (editor) => {
        return transformToUrls(editor, getContentCss(editor));
      };
      const getFontCssUrls = (editor) => {
        return transformToUrls(editor, getFontCss(editor));
      };
      const transformToUrls = (editor, cssLinks) => {
        const skinUrl = editor.editorManager.baseURL + "/skins/content";
        const suffix = editor.editorManager.suffix;
        const contentCssFile = `content${suffix}.css`;
        return map$3(cssLinks, (url) => {
          if (isBundledCssSkinName(url)) {
            return url;
          } else if (isContentCssSkinName(url) && !editor.inline) {
            return `${skinUrl}/${url}/${contentCssFile}`;
          } else {
            return editor.documentBaseURI.toAbsolute(url);
          }
        });
      };
      const appendContentCssFromSettings = (editor) => {
        editor.contentCSS = editor.contentCSS.concat(getContentCssUrls(editor), getFontCssUrls(editor));
      };
      const getAllImages = (elm) => {
        return elm ? from(elm.getElementsByTagName("img")) : [];
      };
      const ImageScanner = (uploadStatus, blobCache) => {
        const cachedPromises = {};
        const findAll2 = (elm, predicate = always) => {
          const images = filter$5(getAllImages(elm), (img) => {
            const src = img.src;
            if (img.hasAttribute("data-mce-bogus")) {
              return false;
            }
            if (img.hasAttribute("data-mce-placeholder")) {
              return false;
            }
            if (!src || src === Env.transparentSrc) {
              return false;
            }
            if (startsWith(src, "blob:")) {
              return !uploadStatus.isUploaded(src) && predicate(img);
            }
            if (startsWith(src, "data:")) {
              return predicate(img);
            }
            return false;
          });
          const promises = map$3(images, (img) => {
            const imageSrc = img.src;
            if (has$2(cachedPromises, imageSrc)) {
              return cachedPromises[imageSrc].then((imageInfo) => {
                if (isString(imageInfo)) {
                  return imageInfo;
                } else {
                  return {
                    image: img,
                    blobInfo: imageInfo.blobInfo
                  };
                }
              });
            } else {
              const newPromise = imageToBlobInfo(blobCache, imageSrc).then((blobInfo) => {
                delete cachedPromises[imageSrc];
                return {
                  image: img,
                  blobInfo
                };
              }).catch((error2) => {
                delete cachedPromises[imageSrc];
                return error2;
              });
              cachedPromises[imageSrc] = newPromise;
              return newPromise;
            }
          });
          return Promise.all(promises);
        };
        return { findAll: findAll2 };
      };
      const UploadStatus = () => {
        const PENDING = 1, UPLOADED = 2;
        let blobUriStatuses = {};
        const createStatus = (status, resultUri) => {
          return {
            status,
            resultUri
          };
        };
        const hasBlobUri = (blobUri) => {
          return blobUri in blobUriStatuses;
        };
        const getResultUri = (blobUri) => {
          const result = blobUriStatuses[blobUri];
          return result ? result.resultUri : null;
        };
        const isPending = (blobUri) => {
          return hasBlobUri(blobUri) ? blobUriStatuses[blobUri].status === PENDING : false;
        };
        const isUploaded = (blobUri) => {
          return hasBlobUri(blobUri) ? blobUriStatuses[blobUri].status === UPLOADED : false;
        };
        const markPending = (blobUri) => {
          blobUriStatuses[blobUri] = createStatus(PENDING, null);
        };
        const markUploaded = (blobUri, resultUri) => {
          blobUriStatuses[blobUri] = createStatus(UPLOADED, resultUri);
        };
        const removeFailed = (blobUri) => {
          delete blobUriStatuses[blobUri];
        };
        const destroy2 = () => {
          blobUriStatuses = {};
        };
        return {
          hasBlobUri,
          getResultUri,
          isPending,
          isUploaded,
          markPending,
          markUploaded,
          removeFailed,
          destroy: destroy2
        };
      };
      let count = 0;
      const seed = () => {
        const rnd = () => {
          return Math.round(random() * 4294967295).toString(36);
        };
        const now = (/* @__PURE__ */ new Date()).getTime();
        return "s" + now.toString(36) + rnd() + rnd() + rnd();
      };
      const uuid = (prefix) => {
        return prefix + count++ + seed();
      };
      const BlobCache = () => {
        let cache = [];
        const mimeToExt = (mime) => {
          const mimes = {
            "image/jpeg": "jpg",
            "image/jpg": "jpg",
            "image/gif": "gif",
            "image/png": "png",
            "image/apng": "apng",
            "image/avif": "avif",
            "image/svg+xml": "svg",
            "image/webp": "webp",
            "image/bmp": "bmp",
            "image/tiff": "tiff"
          };
          return mimes[mime.toLowerCase()] || "dat";
        };
        const create2 = (o, blob, base64, name2, filename) => {
          if (isString(o)) {
            const id = o;
            return toBlobInfo({
              id,
              name: name2,
              filename,
              blob,
              base64
            });
          } else if (isObject(o)) {
            return toBlobInfo(o);
          } else {
            throw new Error("Unknown input type");
          }
        };
        const toBlobInfo = (o) => {
          if (!o.blob || !o.base64) {
            throw new Error("blob and base64 representations of the image are required for BlobInfo to be created");
          }
          const id = o.id || uuid("blobid");
          const name2 = o.name || id;
          const blob = o.blob;
          return {
            id: constant(id),
            name: constant(name2),
            filename: constant(o.filename || name2 + "." + mimeToExt(blob.type)),
            blob: constant(blob),
            base64: constant(o.base64),
            blobUri: constant(o.blobUri || URL.createObjectURL(blob)),
            uri: constant(o.uri)
          };
        };
        const add2 = (blobInfo) => {
          if (!get2(blobInfo.id())) {
            cache.push(blobInfo);
          }
        };
        const findFirst = (predicate) => find$2(cache, predicate).getOrUndefined();
        const get2 = (id) => findFirst((cachedBlobInfo) => cachedBlobInfo.id() === id);
        const getByUri = (blobUri) => findFirst((blobInfo) => blobInfo.blobUri() === blobUri);
        const getByData = (base64, type2) => findFirst((blobInfo) => blobInfo.base64() === base64 && blobInfo.blob().type === type2);
        const removeByUri = (blobUri) => {
          cache = filter$5(cache, (blobInfo) => {
            if (blobInfo.blobUri() === blobUri) {
              URL.revokeObjectURL(blobInfo.blobUri());
              return false;
            }
            return true;
          });
        };
        const destroy2 = () => {
          each$e(cache, (cachedBlobInfo) => {
            URL.revokeObjectURL(cachedBlobInfo.blobUri());
          });
          cache = [];
        };
        return {
          create: create2,
          add: add2,
          get: get2,
          getByUri,
          getByData,
          findFirst,
          removeByUri,
          destroy: destroy2
        };
      };
      const Uploader = (uploadStatus, settings) => {
        const pendingPromises = {};
        const pathJoin = (path1, path2) => {
          if (path1) {
            return path1.replace(/\/$/, "") + "/" + path2.replace(/^\//, "");
          }
          return path2;
        };
        const defaultHandler = (blobInfo, progress) => new Promise((success, failure) => {
          const xhr = new XMLHttpRequest();
          xhr.open("POST", settings.url);
          xhr.withCredentials = settings.credentials;
          xhr.upload.onprogress = (e) => {
            progress(e.loaded / e.total * 100);
          };
          xhr.onerror = () => {
            failure("Image upload failed due to a XHR Transport error. Code: " + xhr.status);
          };
          xhr.onload = () => {
            if (xhr.status < 200 || xhr.status >= 300) {
              failure("HTTP Error: " + xhr.status);
              return;
            }
            const json = JSON.parse(xhr.responseText);
            if (!json || !isString(json.location)) {
              failure("Invalid JSON: " + xhr.responseText);
              return;
            }
            success(pathJoin(settings.basePath, json.location));
          };
          const formData = new FormData();
          formData.append("file", blobInfo.blob(), blobInfo.filename());
          xhr.send(formData);
        });
        const uploadHandler = isFunction(settings.handler) ? settings.handler : defaultHandler;
        const noUpload = () => new Promise((resolve2) => {
          resolve2([]);
        });
        const handlerSuccess = (blobInfo, url) => ({
          url,
          blobInfo,
          status: true
        });
        const handlerFailure = (blobInfo, error2) => ({
          url: "",
          blobInfo,
          status: false,
          error: error2
        });
        const resolvePending = (blobUri, result) => {
          Tools.each(pendingPromises[blobUri], (resolve2) => {
            resolve2(result);
          });
          delete pendingPromises[blobUri];
        };
        const uploadBlobInfo = (blobInfo, handler, openNotification2) => {
          uploadStatus.markPending(blobInfo.blobUri());
          return new Promise((resolve2) => {
            let notification;
            let progress;
            try {
              const closeNotification = () => {
                if (notification) {
                  notification.close();
                  progress = noop;
                }
              };
              const success = (url) => {
                closeNotification();
                uploadStatus.markUploaded(blobInfo.blobUri(), url);
                resolvePending(blobInfo.blobUri(), handlerSuccess(blobInfo, url));
                resolve2(handlerSuccess(blobInfo, url));
              };
              const failure = (error2) => {
                closeNotification();
                uploadStatus.removeFailed(blobInfo.blobUri());
                resolvePending(blobInfo.blobUri(), handlerFailure(blobInfo, error2));
                resolve2(handlerFailure(blobInfo, error2));
              };
              progress = (percent) => {
                if (percent < 0 || percent > 100) {
                  return;
                }
                Optional.from(notification).orThunk(() => Optional.from(openNotification2).map(apply$1)).each((n) => {
                  notification = n;
                  n.progressBar.value(percent);
                });
              };
              handler(blobInfo, progress).then(success, (err) => {
                failure(isString(err) ? { message: err } : err);
              });
            } catch (ex) {
              resolve2(handlerFailure(blobInfo, ex));
            }
          });
        };
        const isDefaultHandler = (handler) => handler === defaultHandler;
        const pendingUploadBlobInfo = (blobInfo) => {
          const blobUri = blobInfo.blobUri();
          return new Promise((resolve2) => {
            pendingPromises[blobUri] = pendingPromises[blobUri] || [];
            pendingPromises[blobUri].push(resolve2);
          });
        };
        const uploadBlobs = (blobInfos, openNotification2) => {
          blobInfos = Tools.grep(blobInfos, (blobInfo) => !uploadStatus.isUploaded(blobInfo.blobUri()));
          return Promise.all(Tools.map(blobInfos, (blobInfo) => uploadStatus.isPending(blobInfo.blobUri()) ? pendingUploadBlobInfo(blobInfo) : uploadBlobInfo(blobInfo, uploadHandler, openNotification2)));
        };
        const upload = (blobInfos, openNotification2) => !settings.url && isDefaultHandler(uploadHandler) ? noUpload() : uploadBlobs(blobInfos, openNotification2);
        return { upload };
      };
      const openNotification = (editor) => () => editor.notificationManager.open({
        text: editor.translate("Image uploading..."),
        type: "info",
        timeout: -1,
        progressBar: true
      });
      const createUploader = (editor, uploadStatus) => Uploader(uploadStatus, {
        url: getImageUploadUrl(editor),
        basePath: getImageUploadBasePath(editor),
        credentials: getImagesUploadCredentials(editor),
        handler: getImagesUploadHandler(editor)
      });
      const ImageUploader = (editor) => {
        const uploadStatus = UploadStatus();
        const uploader = createUploader(editor, uploadStatus);
        return { upload: (blobInfos, showNotification = true) => uploader.upload(blobInfos, showNotification ? openNotification(editor) : void 0) };
      };
      const isEmptyForPadding = (editor, element) => editor.dom.isEmpty(element.dom) && isNonNullable(editor.schema.getTextBlockElements()[name(element)]);
      const addPaddingToEmpty = (editor) => (element) => {
        if (isEmptyForPadding(editor, element)) {
          append$1(element, SugarElement.fromHtml('<br data-mce-bogus="1" />'));
        }
      };
      const EditorUpload = (editor) => {
        const blobCache = BlobCache();
        let uploader, imageScanner;
        const uploadStatus = UploadStatus();
        const urlFilters = [];
        const aliveGuard = (callback) => {
          return (result) => {
            if (editor.selection) {
              return callback(result);
            }
            return [];
          };
        };
        const cacheInvalidator = (url) => url + (url.indexOf("?") === -1 ? "?" : "&") + (/* @__PURE__ */ new Date()).getTime();
        const replaceString = (content, search2, replace) => {
          let index = 0;
          do {
            index = content.indexOf(search2, index);
            if (index !== -1) {
              content = content.substring(0, index) + replace + content.substr(index + search2.length);
              index += replace.length - search2.length + 1;
            }
          } while (index !== -1);
          return content;
        };
        const replaceImageUrl = (content, targetUrl, replacementUrl) => {
          const replacementString = `src="${replacementUrl}"${replacementUrl === Env.transparentSrc ? ' data-mce-placeholder="1"' : ""}`;
          content = replaceString(content, `src="${targetUrl}"`, replacementString);
          content = replaceString(content, 'data-mce-src="' + targetUrl + '"', 'data-mce-src="' + replacementUrl + '"');
          return content;
        };
        const replaceUrlInUndoStack = (targetUrl, replacementUrl) => {
          each$e(editor.undoManager.data, (level) => {
            if (level.type === "fragmented") {
              level.fragments = map$3(level.fragments, (fragment) => replaceImageUrl(fragment, targetUrl, replacementUrl));
            } else {
              level.content = replaceImageUrl(level.content, targetUrl, replacementUrl);
            }
          });
        };
        const replaceImageUriInView = (image, resultUri) => {
          const src = editor.convertURL(resultUri, "src");
          replaceUrlInUndoStack(image.src, resultUri);
          setAll$1(SugarElement.fromDom(image), {
            "src": shouldReuseFileName(editor) ? cacheInvalidator(resultUri) : resultUri,
            "data-mce-src": src
          });
        };
        const uploadImages = () => {
          if (!uploader) {
            uploader = createUploader(editor, uploadStatus);
          }
          return scanForImages().then(aliveGuard((imageInfos) => {
            const blobInfos = map$3(imageInfos, (imageInfo) => imageInfo.blobInfo);
            return uploader.upload(blobInfos, openNotification(editor)).then(aliveGuard((result) => {
              const imagesToRemove = [];
              let shouldDispatchChange = false;
              const filteredResult = map$3(result, (uploadInfo, index) => {
                const { blobInfo, image } = imageInfos[index];
                let removed = false;
                if (uploadInfo.status && shouldReplaceBlobUris(editor)) {
                  if (uploadInfo.url && !contains$1(image.src, uploadInfo.url)) {
                    shouldDispatchChange = true;
                  }
                  blobCache.removeByUri(image.src);
                  if (isRtc(editor)) ;
                  else {
                    replaceImageUriInView(image, uploadInfo.url);
                  }
                } else if (uploadInfo.error) {
                  if (uploadInfo.error.remove) {
                    replaceUrlInUndoStack(image.src, Env.transparentSrc);
                    imagesToRemove.push(image);
                    removed = true;
                  }
                  uploadError(editor, uploadInfo.error.message);
                }
                return {
                  element: image,
                  status: uploadInfo.status,
                  uploadUri: uploadInfo.url,
                  blobInfo,
                  removed
                };
              });
              if (imagesToRemove.length > 0 && !isRtc(editor)) {
                editor.undoManager.transact(() => {
                  each$e(fromDom$1(imagesToRemove), (sugarElement) => {
                    const parentOpt = parent(sugarElement);
                    remove$4(sugarElement);
                    parentOpt.each(addPaddingToEmpty(editor));
                    blobCache.removeByUri(sugarElement.dom.src);
                  });
                });
              } else if (shouldDispatchChange) {
                editor.undoManager.dispatchChange();
              }
              return filteredResult;
            }));
          }));
        };
        const uploadImagesAuto = () => isAutomaticUploadsEnabled(editor) ? uploadImages() : Promise.resolve([]);
        const isValidDataUriImage = (imgElm) => forall(urlFilters, (filter2) => filter2(imgElm));
        const addFilter = (filter2) => {
          urlFilters.push(filter2);
        };
        const scanForImages = () => {
          if (!imageScanner) {
            imageScanner = ImageScanner(uploadStatus, blobCache);
          }
          return imageScanner.findAll(editor.getBody(), isValidDataUriImage).then(aliveGuard((result) => {
            const filteredResult = filter$5(result, (resultItem) => {
              if (isString(resultItem)) {
                displayError(editor, resultItem);
                return false;
              } else if (resultItem.uriType === "blob") {
                return false;
              } else {
                return true;
              }
            });
            if (isRtc(editor)) ;
            else {
              each$e(filteredResult, (resultItem) => {
                replaceUrlInUndoStack(resultItem.image.src, resultItem.blobInfo.blobUri());
                resultItem.image.src = resultItem.blobInfo.blobUri();
                resultItem.image.removeAttribute("data-mce-src");
              });
            }
            return filteredResult;
          }));
        };
        const destroy2 = () => {
          blobCache.destroy();
          uploadStatus.destroy();
          imageScanner = uploader = null;
        };
        const replaceBlobUris = (content) => {
          return content.replace(/src="(blob:[^"]+)"/g, (match2, blobUri) => {
            const resultUri = uploadStatus.getResultUri(blobUri);
            if (resultUri) {
              return 'src="' + resultUri + '"';
            }
            let blobInfo = blobCache.getByUri(blobUri);
            if (!blobInfo) {
              blobInfo = foldl(editor.editorManager.get(), (result, editor2) => {
                return result || editor2.editorUpload && editor2.editorUpload.blobCache.getByUri(blobUri);
              }, void 0);
            }
            if (blobInfo) {
              const blob = blobInfo.blob();
              return 'src="data:' + blob.type + ";base64," + blobInfo.base64() + '"';
            }
            return match2;
          });
        };
        editor.on("SetContent", () => {
          if (isAutomaticUploadsEnabled(editor)) {
            uploadImagesAuto();
          } else {
            scanForImages();
          }
        });
        editor.on("RawSaveContent", (e) => {
          e.content = replaceBlobUris(e.content);
        });
        editor.on("GetContent", (e) => {
          if (e.source_view || e.format === "raw" || e.format === "tree") {
            return;
          }
          e.content = replaceBlobUris(e.content);
        });
        editor.on("PostRender", () => {
          editor.parser.addNodeFilter("img", (images) => {
            each$e(images, (img) => {
              const src = img.attr("src");
              if (!src || blobCache.getByUri(src)) {
                return;
              }
              const resultUri = uploadStatus.getResultUri(src);
              if (resultUri) {
                img.attr("src", resultUri);
              }
            });
          });
        });
        return {
          blobCache,
          addFilter,
          uploadImages,
          uploadImagesAuto,
          scanForImages,
          destroy: destroy2
        };
      };
      const get$1 = (editor) => {
        const dom2 = editor.dom;
        const schemaType = editor.schema.type;
        const formats = {
          valigntop: [{
            selector: "td,th",
            styles: { verticalAlign: "top" }
          }],
          valignmiddle: [{
            selector: "td,th",
            styles: { verticalAlign: "middle" }
          }],
          valignbottom: [{
            selector: "td,th",
            styles: { verticalAlign: "bottom" }
          }],
          alignleft: [
            {
              selector: "figure.image",
              collapsed: false,
              classes: "align-left",
              ceFalseOverride: true,
              preview: "font-family font-size"
            },
            {
              selector: "figure,p,h1,h2,h3,h4,h5,h6,td,th,tr,div,ul,ol,li,pre",
              styles: { textAlign: "left" },
              inherit: false,
              preview: false
            },
            {
              selector: "img,audio,video",
              collapsed: false,
              styles: { float: "left" },
              preview: "font-family font-size"
            },
            {
              selector: ".mce-placeholder",
              styles: { float: "left" },
              ceFalseOverride: true
            },
            {
              selector: "table",
              collapsed: false,
              styles: {
                marginLeft: "0px",
                marginRight: "auto"
              },
              onformat: (table2) => {
                dom2.setStyle(table2, "float", null);
              },
              preview: "font-family font-size"
            },
            {
              selector: ".mce-preview-object,[data-ephox-embed-iri]",
              ceFalseOverride: true,
              styles: { float: "left" }
            }
          ],
          aligncenter: [
            {
              selector: "figure,p,h1,h2,h3,h4,h5,h6,td,th,tr,div,ul,ol,li,pre",
              styles: { textAlign: "center" },
              inherit: false,
              preview: "font-family font-size"
            },
            {
              selector: "figure.image",
              collapsed: false,
              classes: "align-center",
              ceFalseOverride: true,
              preview: "font-family font-size"
            },
            {
              selector: "img,audio,video",
              collapsed: false,
              styles: {
                display: "block",
                marginLeft: "auto",
                marginRight: "auto"
              },
              preview: false
            },
            {
              selector: ".mce-placeholder",
              styles: {
                display: "block",
                marginLeft: "auto",
                marginRight: "auto"
              },
              ceFalseOverride: true
            },
            {
              selector: "table",
              collapsed: false,
              styles: {
                marginLeft: "auto",
                marginRight: "auto"
              },
              preview: "font-family font-size"
            },
            {
              selector: ".mce-preview-object",
              ceFalseOverride: true,
              styles: {
                display: "table",
                marginLeft: "auto",
                marginRight: "auto"
              },
              preview: false
            },
            {
              selector: "[data-ephox-embed-iri]",
              ceFalseOverride: true,
              styles: {
                marginLeft: "auto",
                marginRight: "auto"
              },
              preview: false
            }
          ],
          alignright: [
            {
              selector: "figure.image",
              collapsed: false,
              classes: "align-right",
              ceFalseOverride: true,
              preview: "font-family font-size"
            },
            {
              selector: "figure,p,h1,h2,h3,h4,h5,h6,td,th,tr,div,ul,ol,li,pre",
              styles: { textAlign: "right" },
              inherit: false,
              preview: "font-family font-size"
            },
            {
              selector: "img,audio,video",
              collapsed: false,
              styles: { float: "right" },
              preview: "font-family font-size"
            },
            {
              selector: ".mce-placeholder",
              styles: { float: "right" },
              ceFalseOverride: true
            },
            {
              selector: "table",
              collapsed: false,
              styles: {
                marginRight: "0px",
                marginLeft: "auto"
              },
              onformat: (table2) => {
                dom2.setStyle(table2, "float", null);
              },
              preview: "font-family font-size"
            },
            {
              selector: ".mce-preview-object,[data-ephox-embed-iri]",
              ceFalseOverride: true,
              styles: { float: "right" },
              preview: false
            }
          ],
          alignjustify: [{
            selector: "figure,p,h1,h2,h3,h4,h5,h6,td,th,tr,div,ul,ol,li,pre",
            styles: { textAlign: "justify" },
            inherit: false,
            preview: "font-family font-size"
          }],
          bold: [
            {
              inline: "strong",
              remove: "all",
              preserve_attributes: [
                "class",
                "style"
              ]
            },
            {
              inline: "span",
              styles: { fontWeight: "bold" }
            },
            {
              inline: "b",
              remove: "all",
              preserve_attributes: [
                "class",
                "style"
              ]
            }
          ],
          italic: [
            {
              inline: "em",
              remove: "all",
              preserve_attributes: [
                "class",
                "style"
              ]
            },
            {
              inline: "span",
              styles: { fontStyle: "italic" }
            },
            {
              inline: "i",
              remove: "all",
              preserve_attributes: [
                "class",
                "style"
              ]
            }
          ],
          underline: [
            {
              inline: "span",
              styles: { textDecoration: "underline" },
              exact: true
            },
            {
              inline: "u",
              remove: "all",
              preserve_attributes: [
                "class",
                "style"
              ]
            }
          ],
          strikethrough: /* @__PURE__ */ (() => {
            const span = {
              inline: "span",
              styles: { textDecoration: "line-through" },
              exact: true
            };
            const strike = {
              inline: "strike",
              remove: "all",
              preserve_attributes: [
                "class",
                "style"
              ]
            };
            const s = {
              inline: "s",
              remove: "all",
              preserve_attributes: [
                "class",
                "style"
              ]
            };
            return schemaType !== "html4" ? [
              s,
              span,
              strike
            ] : [
              span,
              s,
              strike
            ];
          })(),
          forecolor: {
            inline: "span",
            styles: { color: "%value" },
            links: true,
            remove_similar: true,
            clear_child_styles: true
          },
          hilitecolor: {
            inline: "span",
            styles: { backgroundColor: "%value" },
            links: true,
            remove_similar: true,
            clear_child_styles: true
          },
          fontname: {
            inline: "span",
            toggle: false,
            styles: { fontFamily: "%value" },
            clear_child_styles: true
          },
          fontsize: {
            inline: "span",
            toggle: false,
            styles: { fontSize: "%value" },
            clear_child_styles: true
          },
          lineheight: {
            selector: "h1,h2,h3,h4,h5,h6,p,li,td,th,div",
            styles: { lineHeight: "%value" }
          },
          fontsize_class: {
            inline: "span",
            attributes: { class: "%value" }
          },
          blockquote: {
            block: "blockquote",
            wrapper: true,
            remove: "all"
          },
          subscript: { inline: "sub" },
          superscript: { inline: "sup" },
          code: { inline: "code" },
          samp: { inline: "samp" },
          link: {
            inline: "a",
            selector: "a",
            remove: "all",
            split: true,
            deep: true,
            onmatch: (node, _fmt, _itemName) => {
              return isElement$6(node) && node.hasAttribute("href");
            },
            onformat: (elm, _fmt, vars) => {
              Tools.each(vars, (value2, key) => {
                dom2.setAttrib(elm, key, value2);
              });
            }
          },
          lang: {
            inline: "span",
            clear_child_styles: true,
            remove_similar: true,
            attributes: {
              "lang": "%value",
              "data-mce-lang": (vars) => {
                var _a;
                return (_a = vars === null || vars === void 0 ? void 0 : vars.customValue) !== null && _a !== void 0 ? _a : null;
              }
            }
          },
          removeformat: [
            {
              selector: "b,strong,em,i,font,u,strike,s,sub,sup,dfn,code,samp,kbd,var,cite,mark,q,del,ins,small",
              remove: "all",
              split: true,
              expand: false,
              block_expand: true,
              deep: true
            },
            {
              selector: "span",
              attributes: [
                "style",
                "class"
              ],
              remove: "empty",
              split: true,
              expand: false,
              deep: true
            },
            {
              selector: "*",
              attributes: [
                "style",
                "class"
              ],
              split: false,
              expand: false,
              deep: true
            }
          ]
        };
        Tools.each("p h1 h2 h3 h4 h5 h6 div address pre dt dd".split(/\s/), (name2) => {
          formats[name2] = {
            block: name2,
            remove: "all"
          };
        });
        return formats;
      };
      const genericBase = {
        remove_similar: true,
        inherit: false
      };
      const cellBase = {
        selector: "td,th",
        ...genericBase
      };
      const cellFormats = {
        tablecellbackgroundcolor: {
          styles: { backgroundColor: "%value" },
          ...cellBase
        },
        tablecellverticalalign: {
          styles: { "vertical-align": "%value" },
          ...cellBase
        },
        tablecellbordercolor: {
          styles: { borderColor: "%value" },
          ...cellBase
        },
        tablecellclass: {
          classes: ["%value"],
          ...cellBase
        },
        tableclass: {
          selector: "table",
          classes: ["%value"],
          ...genericBase
        },
        tablecellborderstyle: {
          styles: { borderStyle: "%value" },
          ...cellBase
        },
        tablecellborderwidth: {
          styles: { borderWidth: "%value" },
          ...cellBase
        }
      };
      const get = constant(cellFormats);
      const FormatRegistry = (editor) => {
        const formats = {};
        const get$22 = (name2) => isNonNullable(name2) ? formats[name2] : formats;
        const has2 = (name2) => has$2(formats, name2);
        const register2 = (name2, format) => {
          if (name2) {
            if (!isString(name2)) {
              each$d(name2, (format2, name3) => {
                register2(name3, format2);
              });
            } else {
              if (!isArray$1(format)) {
                format = [format];
              }
              each$e(format, (format2) => {
                if (isUndefined(format2.deep)) {
                  format2.deep = !isSelectorFormat(format2);
                }
                if (isUndefined(format2.split)) {
                  format2.split = !isSelectorFormat(format2) || isInlineFormat(format2);
                }
                if (isUndefined(format2.remove) && isSelectorFormat(format2) && !isInlineFormat(format2)) {
                  format2.remove = "none";
                }
                if (isSelectorFormat(format2) && isInlineFormat(format2)) {
                  format2.mixed = true;
                  format2.block_expand = true;
                }
                if (isString(format2.classes)) {
                  format2.classes = format2.classes.split(/\s+/);
                }
              });
              formats[name2] = format;
            }
          }
        };
        const unregister = (name2) => {
          if (name2 && formats[name2]) {
            delete formats[name2];
          }
          return formats;
        };
        register2(get$1(editor));
        register2(get());
        register2(getFormats(editor));
        return {
          get: get$22,
          has: has2,
          register: register2,
          unregister
        };
      };
      const each$3 = Tools.each;
      const dom = DOMUtils.DOM;
      const isPreviewItem = (item) => isNonNullable(item) && isObject(item);
      const parsedSelectorToHtml = (ancestry, editor) => {
        const schema = editor && editor.schema || Schema({});
        const decorate = (elm, item) => {
          if (item.classes.length > 0) {
            dom.addClass(elm, item.classes.join(" "));
          }
          dom.setAttribs(elm, item.attrs);
        };
        const createElement = (sItem) => {
          const item = isString(sItem) ? {
            name: sItem,
            classes: [],
            attrs: {}
          } : sItem;
          const elm = dom.create(item.name);
          decorate(elm, item);
          return elm;
        };
        const getRequiredParent = (elm, candidate) => {
          const elmRule = schema.getElementRule(elm.nodeName.toLowerCase());
          const parentsRequired = elmRule === null || elmRule === void 0 ? void 0 : elmRule.parentsRequired;
          if (parentsRequired && parentsRequired.length) {
            return candidate && contains$2(parentsRequired, candidate) ? candidate : parentsRequired[0];
          } else {
            return false;
          }
        };
        const wrapInHtml = (elm, ancestors, siblings2) => {
          let parentCandidate;
          const ancestor2 = ancestors[0];
          const ancestorName = isPreviewItem(ancestor2) ? ancestor2.name : void 0;
          const parentRequired = getRequiredParent(elm, ancestorName);
          if (parentRequired) {
            if (ancestorName === parentRequired) {
              parentCandidate = ancestor2;
              ancestors = ancestors.slice(1);
            } else {
              parentCandidate = parentRequired;
            }
          } else if (ancestor2) {
            parentCandidate = ancestor2;
            ancestors = ancestors.slice(1);
          } else if (!siblings2) {
            return elm;
          }
          const parent2 = parentCandidate ? createElement(parentCandidate) : dom.create("div");
          parent2.appendChild(elm);
          if (siblings2) {
            Tools.each(siblings2, (sibling2) => {
              const siblingElm = createElement(sibling2);
              parent2.insertBefore(siblingElm, elm);
            });
          }
          const parentSiblings = isPreviewItem(parentCandidate) ? parentCandidate.siblings : void 0;
          return wrapInHtml(parent2, ancestors, parentSiblings);
        };
        const fragment = dom.create("div");
        if (ancestry.length > 0) {
          const item = ancestry[0];
          const elm = createElement(item);
          const siblings2 = isPreviewItem(item) ? item.siblings : void 0;
          fragment.appendChild(wrapInHtml(elm, ancestry.slice(1), siblings2));
        }
        return fragment;
      };
      const parseSelectorItem = (item) => {
        item = Tools.trim(item);
        let tagName = "div";
        const obj = {
          name: tagName,
          classes: [],
          attrs: {},
          selector: item
        };
        if (item !== "*") {
          tagName = item.replace(/(?:([#\.]|::?)([\w\-]+)|(\[)([^\]]+)\]?)/g, ($0, $1, $2, $3, $4) => {
            switch ($1) {
              case "#":
                obj.attrs.id = $2;
                break;
              case ".":
                obj.classes.push($2);
                break;
              case ":":
                if (Tools.inArray("checked disabled enabled read-only required".split(" "), $2) !== -1) {
                  obj.attrs[$2] = $2;
                }
                break;
            }
            if ($3 === "[") {
              const m = $4.match(/([\w\-]+)(?:\=\"([^\"]+))?/);
              if (m) {
                obj.attrs[m[1]] = m[2];
              }
            }
            return "";
          });
        }
        obj.name = tagName || "div";
        return obj;
      };
      const parseSelector = (selector) => {
        if (!isString(selector)) {
          return [];
        }
        selector = selector.split(/\s*,\s*/)[0];
        selector = selector.replace(/\s*(~\+|~|\+|>)\s*/g, "$1");
        return Tools.map(selector.split(/(?:>|\s+(?![^\[\]]+\]))/), (item) => {
          const siblings2 = Tools.map(item.split(/(?:~\+|~|\+)/), parseSelectorItem);
          const obj = siblings2.pop();
          if (siblings2.length) {
            obj.siblings = siblings2;
          }
          return obj;
        }).reverse();
      };
      const getCssText = (editor, format) => {
        let previewCss = "";
        let previewStyles = getPreviewStyles(editor);
        if (previewStyles === "") {
          return "";
        }
        const removeVars = (val) => {
          return isString(val) ? val.replace(/%(\w+)/g, "") : "";
        };
        const getComputedStyle = (name3, elm) => {
          return dom.getStyle(elm !== null && elm !== void 0 ? elm : editor.getBody(), name3, true);
        };
        if (isString(format)) {
          const formats = editor.formatter.get(format);
          if (!formats) {
            return "";
          }
          format = formats[0];
        }
        if ("preview" in format) {
          const preview = format.preview;
          if (preview === false) {
            return "";
          } else {
            previewStyles = preview || previewStyles;
          }
        }
        let name2 = format.block || format.inline || "span";
        let previewFrag;
        const items = parseSelector(format.selector);
        if (items.length > 0) {
          if (!items[0].name) {
            items[0].name = name2;
          }
          name2 = format.selector;
          previewFrag = parsedSelectorToHtml(items, editor);
        } else {
          previewFrag = parsedSelectorToHtml([name2], editor);
        }
        const previewElm = dom.select(name2, previewFrag)[0] || previewFrag.firstChild;
        each$3(format.styles, (value2, name3) => {
          const newValue = removeVars(value2);
          if (newValue) {
            dom.setStyle(previewElm, name3, newValue);
          }
        });
        each$3(format.attributes, (value2, name3) => {
          const newValue = removeVars(value2);
          if (newValue) {
            dom.setAttrib(previewElm, name3, newValue);
          }
        });
        each$3(format.classes, (value2) => {
          const newValue = removeVars(value2);
          if (!dom.hasClass(previewElm, newValue)) {
            dom.addClass(previewElm, newValue);
          }
        });
        editor.dispatch("PreviewFormats");
        dom.setStyles(previewFrag, {
          position: "absolute",
          left: -65535
        });
        editor.getBody().appendChild(previewFrag);
        const rawParentFontSize = getComputedStyle("fontSize");
        const parentFontSize = /px$/.test(rawParentFontSize) ? parseInt(rawParentFontSize, 10) : 0;
        each$3(previewStyles.split(" "), (name3) => {
          let value2 = getComputedStyle(name3, previewElm);
          if (name3 === "background-color" && /transparent|rgba\s*\([^)]+,\s*0\)/.test(value2)) {
            value2 = getComputedStyle(name3);
            if (rgbaToHexString(value2).toLowerCase() === "#ffffff") {
              return;
            }
          }
          if (name3 === "color") {
            if (rgbaToHexString(value2).toLowerCase() === "#000000") {
              return;
            }
          }
          if (name3 === "font-size") {
            if (/em|%$/.test(value2)) {
              if (parentFontSize === 0) {
                return;
              }
              const numValue = parseFloat(value2) / (/%$/.test(value2) ? 100 : 1);
              value2 = numValue * parentFontSize + "px";
            }
          }
          if (name3 === "border" && value2) {
            previewCss += "padding:0 2px;";
          }
          previewCss += name3 + ":" + value2 + ";";
        });
        editor.dispatch("AfterPreviewFormats");
        dom.remove(previewFrag);
        return previewCss;
      };
      const setup$s = (editor) => {
        editor.addShortcut("meta+b", "", "Bold");
        editor.addShortcut("meta+i", "", "Italic");
        editor.addShortcut("meta+u", "", "Underline");
        for (let i = 1; i <= 6; i++) {
          editor.addShortcut("access+" + i, "", [
            "FormatBlock",
            false,
            "h" + i
          ]);
        }
        editor.addShortcut("access+7", "", [
          "FormatBlock",
          false,
          "p"
        ]);
        editor.addShortcut("access+8", "", [
          "FormatBlock",
          false,
          "div"
        ]);
        editor.addShortcut("access+9", "", [
          "FormatBlock",
          false,
          "address"
        ]);
      };
      const Formatter = (editor) => {
        const formats = FormatRegistry(editor);
        const formatChangeState = Cell({});
        setup$s(editor);
        setup$v(editor);
        if (!isRtc(editor)) {
          setup$u(formatChangeState, editor);
        }
        return {
          get: formats.get,
          has: formats.has,
          register: formats.register,
          unregister: formats.unregister,
          apply: (name2, vars, node) => {
            applyFormat(editor, name2, vars, node);
          },
          remove: (name2, vars, node, similar) => {
            removeFormat(editor, name2, vars, node, similar);
          },
          toggle: (name2, vars, node) => {
            toggleFormat(editor, name2, vars, node);
          },
          match: (name2, vars, node, similar) => matchFormat(editor, name2, vars, node, similar),
          closest: (names) => closestFormat(editor, names),
          matchAll: (names, vars) => matchAllFormats(editor, names, vars),
          matchNode: (node, name2, vars, similar) => matchNodeFormat(editor, node, name2, vars, similar),
          canApply: (name2) => canApplyFormat(editor, name2),
          formatChanged: (formats2, callback, similar, vars) => formatChanged(editor, formatChangeState, formats2, callback, similar, vars),
          getCssText: curry(getCssText, editor)
        };
      };
      const shouldIgnoreCommand = (cmd) => {
        switch (cmd.toLowerCase()) {
          case "undo":
          case "redo":
          case "mcefocus":
            return true;
          default:
            return false;
        }
      };
      const registerEvents = (editor, undoManager, locks) => {
        const isFirstTypedCharacter = Cell(false);
        const addNonTypingUndoLevel = (e) => {
          setTyping(undoManager, false, locks);
          undoManager.add({}, e);
        };
        editor.on("init", () => {
          undoManager.add();
        });
        editor.on("BeforeExecCommand", (e) => {
          const cmd = e.command;
          if (!shouldIgnoreCommand(cmd)) {
            endTyping(undoManager, locks);
            undoManager.beforeChange();
          }
        });
        editor.on("ExecCommand", (e) => {
          const cmd = e.command;
          if (!shouldIgnoreCommand(cmd)) {
            addNonTypingUndoLevel(e);
          }
        });
        editor.on("ObjectResizeStart cut", () => {
          undoManager.beforeChange();
        });
        editor.on("SaveContent ObjectResized blur", addNonTypingUndoLevel);
        editor.on("dragend", addNonTypingUndoLevel);
        editor.on("keyup", (e) => {
          const keyCode = e.keyCode;
          if (e.isDefaultPrevented()) {
            return;
          }
          const isMeta = Env.os.isMacOS() && e.key === "Meta";
          if (keyCode >= 33 && keyCode <= 36 || keyCode >= 37 && keyCode <= 40 || keyCode === 45 || e.ctrlKey || isMeta) {
            addNonTypingUndoLevel();
            editor.nodeChanged();
          }
          if (keyCode === 46 || keyCode === 8) {
            editor.nodeChanged();
          }
          if (isFirstTypedCharacter.get() && undoManager.typing && !isEq$1(createFromEditor(editor), undoManager.data[0])) {
            if (!editor.isDirty()) {
              editor.setDirty(true);
            }
            editor.dispatch("TypingUndo");
            isFirstTypedCharacter.set(false);
            editor.nodeChanged();
          }
        });
        editor.on("keydown", (e) => {
          const keyCode = e.keyCode;
          if (e.isDefaultPrevented()) {
            return;
          }
          if (keyCode >= 33 && keyCode <= 36 || keyCode >= 37 && keyCode <= 40 || keyCode === 45) {
            if (undoManager.typing) {
              addNonTypingUndoLevel(e);
            }
            return;
          }
          const modKey = e.ctrlKey && !e.altKey || e.metaKey;
          if ((keyCode < 16 || keyCode > 20) && keyCode !== 224 && keyCode !== 91 && !undoManager.typing && !modKey) {
            undoManager.beforeChange();
            setTyping(undoManager, true, locks);
            undoManager.add({}, e);
            isFirstTypedCharacter.set(true);
            return;
          }
          const hasOnlyMetaOrCtrlModifier = Env.os.isMacOS() ? e.metaKey : e.ctrlKey && !e.altKey;
          if (hasOnlyMetaOrCtrlModifier) {
            undoManager.beforeChange();
          }
        });
        editor.on("mousedown", (e) => {
          if (undoManager.typing) {
            addNonTypingUndoLevel(e);
          }
        });
        const isInsertReplacementText = (event) => event.inputType === "insertReplacementText";
        const isInsertTextDataNull = (event) => event.inputType === "insertText" && event.data === null;
        const isInsertFromPasteOrDrop = (event) => event.inputType === "insertFromPaste" || event.inputType === "insertFromDrop";
        editor.on("input", (e) => {
          if (e.inputType && (isInsertReplacementText(e) || isInsertTextDataNull(e) || isInsertFromPasteOrDrop(e))) {
            addNonTypingUndoLevel(e);
          }
        });
        editor.on("AddUndo Undo Redo ClearUndos", (e) => {
          if (!e.isDefaultPrevented()) {
            editor.nodeChanged();
          }
        });
      };
      const addKeyboardShortcuts = (editor) => {
        editor.addShortcut("meta+z", "", "Undo");
        editor.addShortcut("meta+y,meta+shift+z", "", "Redo");
      };
      const UndoManager = (editor) => {
        const beforeBookmark = value$2();
        const locks = Cell(0);
        const index = Cell(0);
        const undoManager = {
          data: [],
          typing: false,
          beforeChange: () => {
            beforeChange(editor, locks, beforeBookmark);
          },
          add: (level, event) => {
            return addUndoLevel(editor, undoManager, index, locks, beforeBookmark, level, event);
          },
          dispatchChange: () => {
            editor.setDirty(true);
            const level = createFromEditor(editor);
            level.bookmark = getUndoBookmark(editor.selection);
            editor.dispatch("change", {
              level,
              lastLevel: get$b(undoManager.data, index.get()).getOrUndefined()
            });
          },
          undo: () => {
            return undo(editor, undoManager, locks, index);
          },
          redo: () => {
            return redo(editor, index, undoManager.data);
          },
          clear: () => {
            clear(editor, undoManager, index);
          },
          reset: () => {
            reset(editor, undoManager);
          },
          hasUndo: () => {
            return hasUndo(editor, undoManager, index);
          },
          hasRedo: () => {
            return hasRedo(editor, undoManager, index);
          },
          transact: (callback) => {
            return transact(editor, undoManager, locks, callback);
          },
          ignore: (callback) => {
            ignore(editor, locks, callback);
          },
          extra: (callback1, callback2) => {
            extra(editor, undoManager, index, callback1, callback2);
          }
        };
        if (!isRtc(editor)) {
          registerEvents(editor, undoManager, locks);
        }
        addKeyboardShortcuts(editor);
        return undoManager;
      };
      const nonTypingKeycodes = [
        9,
        27,
        VK.HOME,
        VK.END,
        19,
        20,
        44,
        144,
        145,
        33,
        34,
        45,
        16,
        17,
        18,
        91,
        92,
        93,
        VK.DOWN,
        VK.UP,
        VK.LEFT,
        VK.RIGHT
      ].concat(Env.browser.isFirefox() ? [224] : []);
      const placeholderAttr = "data-mce-placeholder";
      const isKeyboardEvent = (e) => e.type === "keydown" || e.type === "keyup";
      const isDeleteEvent = (e) => {
        const keyCode = e.keyCode;
        return keyCode === VK.BACKSPACE || keyCode === VK.DELETE;
      };
      const isNonTypingKeyboardEvent = (e) => {
        if (isKeyboardEvent(e)) {
          const keyCode = e.keyCode;
          return !isDeleteEvent(e) && (VK.metaKeyPressed(e) || e.altKey || keyCode >= 112 && keyCode <= 123 || contains$2(nonTypingKeycodes, keyCode));
        } else {
          return false;
        }
      };
      const isTypingKeyboardEvent = (e) => isKeyboardEvent(e) && !(isDeleteEvent(e) || e.type === "keyup" && e.keyCode === 229);
      const isVisuallyEmpty = (dom2, rootElm, forcedRootBlock) => {
        if (dom2.isEmpty(rootElm, void 0, {
          skipBogus: false,
          includeZwsp: true
        })) {
          const firstElement2 = rootElm.firstElementChild;
          if (!firstElement2) {
            return true;
          } else if (dom2.getStyle(rootElm.firstElementChild, "padding-left") || dom2.getStyle(rootElm.firstElementChild, "padding-right")) {
            return false;
          } else {
            return forcedRootBlock === firstElement2.nodeName.toLowerCase();
          }
        } else {
          return false;
        }
      };
      const setup$r = (editor) => {
        var _a;
        const dom2 = editor.dom;
        const rootBlock = getForcedRootBlock(editor);
        const placeholder = (_a = getPlaceholder(editor)) !== null && _a !== void 0 ? _a : "";
        const updatePlaceholder = (e, initial) => {
          if (isNonTypingKeyboardEvent(e)) {
            return;
          }
          const body = editor.getBody();
          const showPlaceholder = isTypingKeyboardEvent(e) ? false : isVisuallyEmpty(dom2, body, rootBlock);
          const isPlaceholderShown = dom2.getAttrib(body, placeholderAttr) !== "";
          if (isPlaceholderShown !== showPlaceholder || initial) {
            dom2.setAttrib(body, placeholderAttr, showPlaceholder ? placeholder : null);
            firePlaceholderToggle(editor, showPlaceholder);
            editor.on(showPlaceholder ? "keydown" : "keyup", updatePlaceholder);
            editor.off(showPlaceholder ? "keyup" : "keydown", updatePlaceholder);
          }
        };
        if (isNotEmpty(placeholder)) {
          editor.on("init", (e) => {
            updatePlaceholder(e, true);
            editor.on("change SetContent ExecCommand", updatePlaceholder);
            editor.on("paste", (e2) => Delay.setEditorTimeout(editor, () => updatePlaceholder(e2)));
          });
        }
      };
      const blockPosition = (block, position) => ({
        block,
        position
      });
      const blockBoundary = (from2, to2) => ({
        from: from2,
        to: to2
      });
      const getBlockPosition = (rootNode, pos) => {
        const rootElm = SugarElement.fromDom(rootNode);
        const containerElm = SugarElement.fromDom(pos.container());
        return getParentBlock$2(rootElm, containerElm).map((block) => blockPosition(block, pos));
      };
      const isNotAncestorial = (blockBoundary2) => !(contains(blockBoundary2.to.block, blockBoundary2.from.block) || contains(blockBoundary2.from.block, blockBoundary2.to.block));
      const isDifferentBlocks = (blockBoundary2) => !eq(blockBoundary2.from.block, blockBoundary2.to.block);
      const getClosestHost = (root, scope) => {
        const isRoot2 = (node) => eq(node, root);
        const isHost = (node) => isTableCell$2(node) || isContentEditableTrue$3(node.dom);
        return closest$4(scope, isHost, isRoot2).filter(isElement$7).getOr(root);
      };
      const hasSameHost = (rootNode, blockBoundary2) => {
        const root = SugarElement.fromDom(rootNode);
        return eq(getClosestHost(root, blockBoundary2.from.block), getClosestHost(root, blockBoundary2.to.block));
      };
      const isEditable$1 = (blockBoundary2) => isContentEditableFalse$b(blockBoundary2.from.block.dom) === false && isContentEditableFalse$b(blockBoundary2.to.block.dom) === false;
      const hasValidBlocks = (blockBoundary2) => {
        const isValidBlock = (block) => isTextBlock$2(block) || hasBlockAttr(block.dom) || isListItem$1(block);
        return isValidBlock(blockBoundary2.from.block) && isValidBlock(blockBoundary2.to.block);
      };
      const skipLastBr = (schema, rootNode, forward, blockPosition2) => {
        if (isBr$6(blockPosition2.position.getNode()) && !isEmpty$2(schema, blockPosition2.block)) {
          return positionIn(false, blockPosition2.block.dom).bind((lastPositionInBlock) => {
            if (lastPositionInBlock.isEqual(blockPosition2.position)) {
              return fromPosition(forward, rootNode, lastPositionInBlock).bind((to2) => getBlockPosition(rootNode, to2));
            } else {
              return Optional.some(blockPosition2);
            }
          }).getOr(blockPosition2);
        } else {
          return blockPosition2;
        }
      };
      const readFromRange = (schema, rootNode, forward, rng) => {
        const fromBlockPos = getBlockPosition(rootNode, CaretPosition.fromRangeStart(rng));
        const toBlockPos = fromBlockPos.bind((blockPos) => fromPosition(forward, rootNode, blockPos.position).bind((to2) => getBlockPosition(rootNode, to2).map((blockPos2) => skipLastBr(schema, rootNode, forward, blockPos2))));
        return lift2(fromBlockPos, toBlockPos, blockBoundary).filter((blockBoundary2) => isDifferentBlocks(blockBoundary2) && hasSameHost(rootNode, blockBoundary2) && isEditable$1(blockBoundary2) && hasValidBlocks(blockBoundary2) && isNotAncestorial(blockBoundary2));
      };
      const read$1 = (schema, rootNode, forward, rng) => rng.collapsed ? readFromRange(schema, rootNode, forward, rng) : Optional.none();
      const getChildrenUntilBlockBoundary = (block, schema) => {
        const children2 = children$1(block);
        return findIndex$2(children2, (el) => schema.isBlock(name(el))).fold(constant(children2), (index) => children2.slice(0, index));
      };
      const extractChildren = (block, schema) => {
        const children2 = getChildrenUntilBlockBoundary(block, schema);
        each$e(children2, remove$4);
        return children2;
      };
      const removeEmptyRoot = (schema, rootNode, block) => {
        const parents2 = parentsAndSelf(block, rootNode);
        return find$2(parents2.reverse(), (element) => isEmpty$2(schema, element)).each(remove$4);
      };
      const isEmptyBefore = (schema, el) => filter$5(prevSiblings(el), (el2) => !isEmpty$2(schema, el2)).length === 0;
      const nestedBlockMerge = (rootNode, fromBlock, toBlock, schema, insertionPoint) => {
        if (isEmpty$2(schema, toBlock)) {
          fillWithPaddingBr(toBlock);
          return firstPositionIn(toBlock.dom);
        }
        if (isEmptyBefore(schema, insertionPoint) && isEmpty$2(schema, fromBlock)) {
          before$3(insertionPoint, SugarElement.fromTag("br"));
        }
        const position = prevPosition(toBlock.dom, CaretPosition.before(insertionPoint.dom));
        each$e(extractChildren(fromBlock, schema), (child2) => {
          before$3(insertionPoint, child2);
        });
        removeEmptyRoot(schema, rootNode, fromBlock);
        return position;
      };
      const isInline = (schema, node) => schema.isInline(name(node));
      const sidelongBlockMerge = (rootNode, fromBlock, toBlock, schema) => {
        if (isEmpty$2(schema, toBlock)) {
          if (isEmpty$2(schema, fromBlock)) {
            const getInlineToBlockDescendants = (el) => {
              const helper = (node, elements) => firstChild(node).fold(() => elements, (child2) => isInline(schema, child2) ? helper(child2, elements.concat(shallow$1(child2))) : elements);
              return helper(el, []);
            };
            const newFromBlockDescendants = foldr(getInlineToBlockDescendants(toBlock), (element, descendant2) => {
              wrap$2(element, descendant2);
              return descendant2;
            }, createPaddingBr());
            empty(fromBlock);
            append$1(fromBlock, newFromBlockDescendants);
          }
          remove$4(toBlock);
          return firstPositionIn(fromBlock.dom);
        }
        const position = lastPositionIn(toBlock.dom);
        each$e(extractChildren(fromBlock, schema), (child2) => {
          append$1(toBlock, child2);
        });
        removeEmptyRoot(schema, rootNode, fromBlock);
        return position;
      };
      const findInsertionPoint = (toBlock, block) => {
        const parentsAndSelf$1 = parentsAndSelf(block, toBlock);
        return Optional.from(parentsAndSelf$1[parentsAndSelf$1.length - 1]);
      };
      const getInsertionPoint = (fromBlock, toBlock) => contains(toBlock, fromBlock) ? findInsertionPoint(toBlock, fromBlock) : Optional.none();
      const trimBr = (first2, block) => {
        positionIn(first2, block.dom).bind((position) => Optional.from(position.getNode())).map(SugarElement.fromDom).filter(isBr$5).each(remove$4);
      };
      const mergeBlockInto = (rootNode, fromBlock, toBlock, schema) => {
        trimBr(true, fromBlock);
        trimBr(false, toBlock);
        return getInsertionPoint(fromBlock, toBlock).fold(curry(sidelongBlockMerge, rootNode, fromBlock, toBlock, schema), curry(nestedBlockMerge, rootNode, fromBlock, toBlock, schema));
      };
      const mergeBlocks = (rootNode, forward, block1, block2, schema) => forward ? mergeBlockInto(rootNode, block2, block1, schema) : mergeBlockInto(rootNode, block1, block2, schema);
      const backspaceDelete$a = (editor, forward) => {
        const rootNode = SugarElement.fromDom(editor.getBody());
        const position = read$1(editor.schema, rootNode.dom, forward, editor.selection.getRng()).map((blockBoundary2) => () => {
          mergeBlocks(rootNode, forward, blockBoundary2.from.block, blockBoundary2.to.block, editor.schema).each((pos) => {
            editor.selection.setRng(pos.toRange());
          });
        });
        return position;
      };
      const deleteRangeMergeBlocks = (rootNode, selection, schema) => {
        const rng = selection.getRng();
        return lift2(getParentBlock$2(rootNode, SugarElement.fromDom(rng.startContainer)), getParentBlock$2(rootNode, SugarElement.fromDom(rng.endContainer)), (block1, block2) => {
          if (!eq(block1, block2)) {
            return Optional.some(() => {
              rng.deleteContents();
              mergeBlocks(rootNode, true, block1, block2, schema).each((pos) => {
                selection.setRng(pos.toRange());
              });
            });
          } else {
            return Optional.none();
          }
        }).getOr(Optional.none());
      };
      const isRawNodeInTable = (root, rawNode) => {
        const node = SugarElement.fromDom(rawNode);
        const isRoot2 = curry(eq, root);
        return ancestor$4(node, isTableCell$2, isRoot2).isSome();
      };
      const isSelectionInTable = (root, rng) => isRawNodeInTable(root, rng.startContainer) || isRawNodeInTable(root, rng.endContainer);
      const isEverythingSelected = (root, rng) => {
        const noPrevious = prevPosition(root.dom, CaretPosition.fromRangeStart(rng)).isNone();
        const noNext = nextPosition(root.dom, CaretPosition.fromRangeEnd(rng)).isNone();
        return !isSelectionInTable(root, rng) && noPrevious && noNext;
      };
      const emptyEditor = (editor) => {
        return Optional.some(() => {
          editor.setContent("");
          editor.selection.setCursorLocation();
        });
      };
      const deleteRange$2 = (editor) => {
        const rootNode = SugarElement.fromDom(editor.getBody());
        const rng = editor.selection.getRng();
        return isEverythingSelected(rootNode, rng) ? emptyEditor(editor) : deleteRangeMergeBlocks(rootNode, editor.selection, editor.schema);
      };
      const backspaceDelete$9 = (editor, _forward) => editor.selection.isCollapsed() ? Optional.none() : deleteRange$2(editor);
      const showCaret = (direction, editor, node, before2, scrollIntoView) => Optional.from(editor._selectionOverrides.showCaret(direction, node, before2, scrollIntoView));
      const getNodeRange = (node) => {
        const rng = node.ownerDocument.createRange();
        rng.selectNode(node);
        return rng;
      };
      const selectNode = (editor, node) => {
        const e = editor.dispatch("BeforeObjectSelected", { target: node });
        if (e.isDefaultPrevented()) {
          return Optional.none();
        }
        return Optional.some(getNodeRange(node));
      };
      const renderCaretAtRange = (editor, range2, scrollIntoView) => {
        const normalizedRange = normalizeRange(1, editor.getBody(), range2);
        const caretPosition = CaretPosition.fromRangeStart(normalizedRange);
        const caretPositionNode = caretPosition.getNode();
        if (isInlineFakeCaretTarget(caretPositionNode)) {
          return showCaret(1, editor, caretPositionNode, !caretPosition.isAtEnd(), false);
        }
        const caretPositionBeforeNode = caretPosition.getNode(true);
        if (isInlineFakeCaretTarget(caretPositionBeforeNode)) {
          return showCaret(1, editor, caretPositionBeforeNode, false, false);
        }
        const ceRoot = getContentEditableRoot$1(editor.dom.getRoot(), caretPosition.getNode());
        if (isInlineFakeCaretTarget(ceRoot)) {
          return showCaret(1, editor, ceRoot, false, scrollIntoView);
        }
        return Optional.none();
      };
      const renderRangeCaret = (editor, range2, scrollIntoView) => range2.collapsed ? renderCaretAtRange(editor, range2, scrollIntoView).getOr(range2) : range2;
      const isBeforeBoundary = (pos) => isBeforeContentEditableFalse(pos) || isBeforeMedia(pos);
      const isAfterBoundary = (pos) => isAfterContentEditableFalse(pos) || isAfterMedia(pos);
      const trimEmptyTextNode = (dom2, node) => {
        if (isText$b(node) && node.data.length === 0) {
          dom2.remove(node);
        }
      };
      const deleteContentAndShowCaret = (editor, range2, node, direction, forward, peekCaretPosition) => {
        showCaret(direction, editor, peekCaretPosition.getNode(!forward), forward, true).each((caretRange) => {
          if (range2.collapsed) {
            const deleteRange2 = range2.cloneRange();
            if (forward) {
              deleteRange2.setEnd(caretRange.startContainer, caretRange.startOffset);
            } else {
              deleteRange2.setStart(caretRange.endContainer, caretRange.endOffset);
            }
            deleteRange2.deleteContents();
          } else {
            range2.deleteContents();
          }
          editor.selection.setRng(caretRange);
        });
        trimEmptyTextNode(editor.dom, node);
      };
      const deleteBoundaryText = (editor, forward) => {
        const range2 = editor.selection.getRng();
        if (!isText$b(range2.commonAncestorContainer)) {
          return Optional.none();
        }
        const direction = forward ? 1 : -1;
        const caretWalker = CaretWalker(editor.getBody());
        const getNextPosFn = curry(getVisualCaretPosition, forward ? caretWalker.next : caretWalker.prev);
        const isBeforeFn = forward ? isBeforeBoundary : isAfterBoundary;
        const caretPosition = getNormalizedRangeEndPoint(direction, editor.getBody(), range2);
        const nextCaretPosition = getNextPosFn(caretPosition);
        const normalizedNextCaretPosition = nextCaretPosition ? normalizePosition(forward, nextCaretPosition) : nextCaretPosition;
        if (!normalizedNextCaretPosition || !isMoveInsideSameBlock(caretPosition, normalizedNextCaretPosition)) {
          return Optional.none();
        } else if (isBeforeFn(normalizedNextCaretPosition)) {
          return Optional.some(() => deleteContentAndShowCaret(editor, range2, caretPosition.getNode(), direction, forward, normalizedNextCaretPosition));
        }
        const peekCaretPosition = getNextPosFn(normalizedNextCaretPosition);
        if (peekCaretPosition && isBeforeFn(peekCaretPosition)) {
          if (isMoveInsideSameBlock(normalizedNextCaretPosition, peekCaretPosition)) {
            return Optional.some(() => deleteContentAndShowCaret(editor, range2, caretPosition.getNode(), direction, forward, peekCaretPosition));
          }
        }
        return Optional.none();
      };
      const backspaceDelete$8 = (editor, forward) => deleteBoundaryText(editor, forward);
      const getEdgeCefPosition = (editor, atStart) => {
        const root = editor.getBody();
        return atStart ? firstPositionIn(root).filter(isBeforeContentEditableFalse) : lastPositionIn(root).filter(isAfterContentEditableFalse);
      };
      const isCefAtEdgeSelected = (editor) => {
        const rng = editor.selection.getRng();
        return !rng.collapsed && (getEdgeCefPosition(editor, true).exists((pos) => pos.isEqual(CaretPosition.fromRangeStart(rng))) || getEdgeCefPosition(editor, false).exists((pos) => pos.isEqual(CaretPosition.fromRangeEnd(rng))));
      };
      const isCompoundElement = (node) => isNonNullable(node) && (isTableCell$2(SugarElement.fromDom(node)) || isListItem$1(SugarElement.fromDom(node)));
      const DeleteAction = Adt.generate([
        { remove: ["element"] },
        { moveToElement: ["element"] },
        { moveToPosition: ["position"] }
      ]);
      const isAtContentEditableBlockCaret = (forward, from2) => {
        const elm = from2.getNode(!forward);
        const caretLocation = forward ? "after" : "before";
        return isElement$6(elm) && elm.getAttribute("data-mce-caret") === caretLocation;
      };
      const isDeleteFromCefDifferentBlocks = (root, forward, from2, to2, schema) => {
        const inSameBlock = (elm) => schema.isInline(elm.nodeName.toLowerCase()) && !isInSameBlock(from2, to2, root);
        return getRelativeCefElm(!forward, from2).fold(() => getRelativeCefElm(forward, to2).fold(never, inSameBlock), inSameBlock);
      };
      const deleteEmptyBlockOrMoveToCef = (schema, root, forward, from2, to2) => {
        const toCefElm = to2.getNode(!forward);
        return getParentBlock$2(SugarElement.fromDom(root), SugarElement.fromDom(from2.getNode())).map((blockElm) => isEmpty$2(schema, blockElm) ? DeleteAction.remove(blockElm.dom) : DeleteAction.moveToElement(toCefElm)).orThunk(() => Optional.some(DeleteAction.moveToElement(toCefElm)));
      };
      const findCefPosition = (root, forward, from2, schema) => fromPosition(forward, root, from2).bind((to2) => {
        if (isCompoundElement(to2.getNode())) {
          return Optional.none();
        } else if (isDeleteFromCefDifferentBlocks(root, forward, from2, to2, schema)) {
          return Optional.none();
        } else if (forward && isContentEditableFalse$b(to2.getNode())) {
          return deleteEmptyBlockOrMoveToCef(schema, root, forward, from2, to2);
        } else if (!forward && isContentEditableFalse$b(to2.getNode(true))) {
          return deleteEmptyBlockOrMoveToCef(schema, root, forward, from2, to2);
        } else if (forward && isAfterContentEditableFalse(from2)) {
          return Optional.some(DeleteAction.moveToPosition(to2));
        } else if (!forward && isBeforeContentEditableFalse(from2)) {
          return Optional.some(DeleteAction.moveToPosition(to2));
        } else {
          return Optional.none();
        }
      });
      const getContentEditableBlockAction = (forward, elm) => {
        if (isNullable(elm)) {
          return Optional.none();
        } else if (forward && isContentEditableFalse$b(elm.nextSibling)) {
          return Optional.some(DeleteAction.moveToElement(elm.nextSibling));
        } else if (!forward && isContentEditableFalse$b(elm.previousSibling)) {
          return Optional.some(DeleteAction.moveToElement(elm.previousSibling));
        } else {
          return Optional.none();
        }
      };
      const skipMoveToActionFromInlineCefToContent = (root, from2, deleteAction2) => deleteAction2.fold((elm) => Optional.some(DeleteAction.remove(elm)), (elm) => Optional.some(DeleteAction.moveToElement(elm)), (to2) => {
        if (isInSameBlock(from2, to2, root)) {
          return Optional.none();
        } else {
          return Optional.some(DeleteAction.moveToPosition(to2));
        }
      });
      const getContentEditableAction = (root, forward, from2, schema) => {
        if (isAtContentEditableBlockCaret(forward, from2)) {
          return getContentEditableBlockAction(forward, from2.getNode(!forward)).orThunk(() => findCefPosition(root, forward, from2, schema));
        } else {
          return findCefPosition(root, forward, from2, schema).bind((deleteAction2) => skipMoveToActionFromInlineCefToContent(root, from2, deleteAction2));
        }
      };
      const read = (root, forward, rng, schema) => {
        const normalizedRange = normalizeRange(forward ? 1 : -1, root, rng);
        const from2 = CaretPosition.fromRangeStart(normalizedRange);
        const rootElement = SugarElement.fromDom(root);
        if (!forward && isAfterContentEditableFalse(from2)) {
          return Optional.some(DeleteAction.remove(from2.getNode(true)));
        } else if (forward && isBeforeContentEditableFalse(from2)) {
          return Optional.some(DeleteAction.remove(from2.getNode()));
        } else if (!forward && isBeforeContentEditableFalse(from2) && isAfterBr(rootElement, from2, schema)) {
          return findPreviousBr(rootElement, from2, schema).map((br) => DeleteAction.remove(br.getNode()));
        } else if (forward && isAfterContentEditableFalse(from2) && isBeforeBr$1(rootElement, from2, schema)) {
          return findNextBr(rootElement, from2, schema).map((br) => DeleteAction.remove(br.getNode()));
        } else {
          return getContentEditableAction(root, forward, from2, schema);
        }
      };
      const deleteElement$1 = (editor, forward) => (element) => {
        editor._selectionOverrides.hideFakeCaret();
        deleteElement$2(editor, forward, SugarElement.fromDom(element));
        return true;
      };
      const moveToElement = (editor, forward) => (element) => {
        const pos = forward ? CaretPosition.before(element) : CaretPosition.after(element);
        editor.selection.setRng(pos.toRange());
        return true;
      };
      const moveToPosition = (editor) => (pos) => {
        editor.selection.setRng(pos.toRange());
        return true;
      };
      const getAncestorCe = (editor, node) => Optional.from(getContentEditableRoot$1(editor.getBody(), node));
      const backspaceDeleteCaret = (editor, forward) => {
        const selectedNode = editor.selection.getNode();
        return getAncestorCe(editor, selectedNode).filter(isContentEditableFalse$b).fold(() => read(editor.getBody(), forward, editor.selection.getRng(), editor.schema).map((deleteAction2) => () => deleteAction2.fold(deleteElement$1(editor, forward), moveToElement(editor, forward), moveToPosition(editor))), () => Optional.some(noop));
      };
      const deleteOffscreenSelection = (rootElement) => {
        each$e(descendants(rootElement, ".mce-offscreen-selection"), remove$4);
      };
      const backspaceDeleteRange = (editor, forward) => {
        const selectedNode = editor.selection.getNode();
        if (isContentEditableFalse$b(selectedNode) && !isTableCell$3(selectedNode)) {
          const hasCefAncestor = getAncestorCe(editor, selectedNode.parentNode).filter(isContentEditableFalse$b);
          return hasCefAncestor.fold(() => Optional.some(() => {
            deleteOffscreenSelection(SugarElement.fromDom(editor.getBody()));
            deleteElement$2(editor, forward, SugarElement.fromDom(editor.selection.getNode()));
            paddEmptyBody(editor);
          }), () => Optional.some(noop));
        }
        if (isCefAtEdgeSelected(editor)) {
          return Optional.some(() => {
            deleteRangeContents(editor, editor.selection.getRng(), SugarElement.fromDom(editor.getBody()));
          });
        }
        return Optional.none();
      };
      const paddEmptyElement = (editor) => {
        const dom2 = editor.dom, selection = editor.selection;
        const ceRoot = getContentEditableRoot$1(editor.getBody(), selection.getNode());
        if (isContentEditableTrue$3(ceRoot) && dom2.isBlock(ceRoot) && dom2.isEmpty(ceRoot)) {
          const br = dom2.create("br", { "data-mce-bogus": "1" });
          dom2.setHTML(ceRoot, "");
          ceRoot.appendChild(br);
          selection.setRng(CaretPosition.before(br).toRange());
        }
        return true;
      };
      const backspaceDelete$7 = (editor, forward) => {
        if (editor.selection.isCollapsed()) {
          return backspaceDeleteCaret(editor, forward);
        } else {
          return backspaceDeleteRange(editor, forward);
        }
      };
      const isTextEndpoint = (endpoint) => endpoint.hasOwnProperty("text");
      const isElementEndpoint = (endpoint) => endpoint.hasOwnProperty("marker");
      const getBookmark = (range2, createMarker2) => {
        const getEndpoint = (container, offset) => {
          if (isText$b(container)) {
            return {
              text: container,
              offset
            };
          } else {
            const marker = createMarker2();
            const children2 = container.childNodes;
            if (offset < children2.length) {
              container.insertBefore(marker, children2[offset]);
              return {
                marker,
                before: true
              };
            } else {
              container.appendChild(marker);
              return {
                marker,
                before: false
              };
            }
          }
        };
        const end2 = getEndpoint(range2.endContainer, range2.endOffset);
        const start2 = getEndpoint(range2.startContainer, range2.startOffset);
        return {
          start: start2,
          end: end2
        };
      };
      const resolveBookmark = (bm) => {
        var _a, _b;
        const { start: start2, end: end2 } = bm;
        const rng = new window.Range();
        if (isTextEndpoint(start2)) {
          rng.setStart(start2.text, start2.offset);
        } else {
          if (isElementEndpoint(start2)) {
            if (start2.before) {
              rng.setStartBefore(start2.marker);
            } else {
              rng.setStartAfter(start2.marker);
            }
            (_a = start2.marker.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(start2.marker);
          }
        }
        if (isTextEndpoint(end2)) {
          rng.setEnd(end2.text, end2.offset);
        } else {
          if (isElementEndpoint(end2)) {
            if (end2.before) {
              rng.setEndBefore(end2.marker);
            } else {
              rng.setEndAfter(end2.marker);
            }
            (_b = end2.marker.parentNode) === null || _b === void 0 ? void 0 : _b.removeChild(end2.marker);
          }
        }
        return rng;
      };
      const backspaceDelete$6 = (editor, forward) => {
        var _a;
        const dom2 = editor.dom;
        const startBlock = dom2.getParent(editor.selection.getStart(), dom2.isBlock);
        const endBlock = dom2.getParent(editor.selection.getEnd(), dom2.isBlock);
        const body = editor.getBody();
        const startBlockName = (_a = startBlock === null || startBlock === void 0 ? void 0 : startBlock.nodeName) === null || _a === void 0 ? void 0 : _a.toLowerCase();
        if (startBlockName === "div" && startBlock && endBlock && startBlock === body.firstChild && endBlock === body.lastChild && !dom2.isEmpty(body)) {
          const wrapper = startBlock.cloneNode(false);
          const deleteAction2 = () => {
            if (forward) {
              execNativeForwardDeleteCommand(editor);
            } else {
              execNativeDeleteCommand(editor);
            }
            if (body.firstChild !== startBlock) {
              const bookmark = getBookmark(editor.selection.getRng(), () => document.createElement("span"));
              Array.from(body.childNodes).forEach((node) => wrapper.appendChild(node));
              body.appendChild(wrapper);
              editor.selection.setRng(resolveBookmark(bookmark));
            }
          };
          return Optional.some(deleteAction2);
        }
        return Optional.none();
      };
      const deleteCaret$2 = (editor, forward) => {
        const fromPos = CaretPosition.fromRangeStart(editor.selection.getRng());
        return fromPosition(forward, editor.getBody(), fromPos).filter((pos) => forward ? isBeforeImageBlock(pos) : isAfterImageBlock(pos)).bind((pos) => getChildNodeAtRelativeOffset(forward ? 0 : -1, pos)).map((elm) => () => editor.selection.select(elm));
      };
      const backspaceDelete$5 = (editor, forward) => editor.selection.isCollapsed() ? deleteCaret$2(editor, forward) : Optional.none();
      const isText$2 = isText$b;
      const startsWithCaretContainer = (node) => isText$2(node) && node.data[0] === ZWSP$1;
      const endsWithCaretContainer = (node) => isText$2(node) && node.data[node.data.length - 1] === ZWSP$1;
      const createZwsp = (node) => {
        var _a;
        const doc = (_a = node.ownerDocument) !== null && _a !== void 0 ? _a : document;
        return doc.createTextNode(ZWSP$1);
      };
      const insertBefore$1 = (node) => {
        var _a;
        if (isText$2(node.previousSibling)) {
          if (endsWithCaretContainer(node.previousSibling)) {
            return node.previousSibling;
          } else {
            node.previousSibling.appendData(ZWSP$1);
            return node.previousSibling;
          }
        } else if (isText$2(node)) {
          if (startsWithCaretContainer(node)) {
            return node;
          } else {
            node.insertData(0, ZWSP$1);
            return node;
          }
        } else {
          const newNode = createZwsp(node);
          (_a = node.parentNode) === null || _a === void 0 ? void 0 : _a.insertBefore(newNode, node);
          return newNode;
        }
      };
      const insertAfter$1 = (node) => {
        var _a, _b;
        if (isText$2(node.nextSibling)) {
          if (startsWithCaretContainer(node.nextSibling)) {
            return node.nextSibling;
          } else {
            node.nextSibling.insertData(0, ZWSP$1);
            return node.nextSibling;
          }
        } else if (isText$2(node)) {
          if (endsWithCaretContainer(node)) {
            return node;
          } else {
            node.appendData(ZWSP$1);
            return node;
          }
        } else {
          const newNode = createZwsp(node);
          if (node.nextSibling) {
            (_a = node.parentNode) === null || _a === void 0 ? void 0 : _a.insertBefore(newNode, node.nextSibling);
          } else {
            (_b = node.parentNode) === null || _b === void 0 ? void 0 : _b.appendChild(newNode);
          }
          return newNode;
        }
      };
      const insertInline = (before2, node) => before2 ? insertBefore$1(node) : insertAfter$1(node);
      const insertInlineBefore = curry(insertInline, true);
      const insertInlineAfter = curry(insertInline, false);
      const insertInlinePos = (pos, before2) => {
        if (isText$b(pos.container())) {
          return insertInline(before2, pos.container());
        } else {
          return insertInline(before2, pos.getNode());
        }
      };
      const isPosCaretContainer = (pos, caret) => {
        const caretNode = caret.get();
        return caretNode && pos.container() === caretNode && isCaretContainerInline(caretNode);
      };
      const renderCaret = (caret, location) => location.fold((element) => {
        remove$2(caret.get());
        const text2 = insertInlineBefore(element);
        caret.set(text2);
        return Optional.some(CaretPosition(text2, text2.length - 1));
      }, (element) => firstPositionIn(element).map((pos) => {
        if (!isPosCaretContainer(pos, caret)) {
          remove$2(caret.get());
          const text2 = insertInlinePos(pos, true);
          caret.set(text2);
          return CaretPosition(text2, 1);
        } else {
          const node = caret.get();
          return CaretPosition(node, 1);
        }
      }), (element) => lastPositionIn(element).map((pos) => {
        if (!isPosCaretContainer(pos, caret)) {
          remove$2(caret.get());
          const text2 = insertInlinePos(pos, false);
          caret.set(text2);
          return CaretPosition(text2, text2.length - 1);
        } else {
          const node = caret.get();
          return CaretPosition(node, node.length - 1);
        }
      }), (element) => {
        remove$2(caret.get());
        const text2 = insertInlineAfter(element);
        caret.set(text2);
        return Optional.some(CaretPosition(text2, 1));
      });
      const evaluateUntil = (fns, args) => {
        for (let i = 0; i < fns.length; i++) {
          const result = fns[i].apply(null, args);
          if (result.isSome()) {
            return result;
          }
        }
        return Optional.none();
      };
      const Location = Adt.generate([
        { before: ["element"] },
        { start: ["element"] },
        { end: ["element"] },
        { after: ["element"] }
      ]);
      const rescope$1 = (rootNode, node) => {
        const parentBlock = getParentBlock$3(node, rootNode);
        return parentBlock ? parentBlock : rootNode;
      };
      const before = (isInlineTarget2, rootNode, pos) => {
        const nPos = normalizeForwards(pos);
        const scope = rescope$1(rootNode, nPos.container());
        return findRootInline(isInlineTarget2, scope, nPos).fold(() => nextPosition(scope, nPos).bind(curry(findRootInline, isInlineTarget2, scope)).map((inline) => Location.before(inline)), Optional.none);
      };
      const isNotInsideFormatCaretContainer = (rootNode, elm) => getParentCaretContainer(rootNode, elm) === null;
      const findInsideRootInline = (isInlineTarget2, rootNode, pos) => findRootInline(isInlineTarget2, rootNode, pos).filter(curry(isNotInsideFormatCaretContainer, rootNode));
      const start$1 = (isInlineTarget2, rootNode, pos) => {
        const nPos = normalizeBackwards(pos);
        return findInsideRootInline(isInlineTarget2, rootNode, nPos).bind((inline) => {
          const prevPos = prevPosition(inline, nPos);
          return prevPos.isNone() ? Optional.some(Location.start(inline)) : Optional.none();
        });
      };
      const end = (isInlineTarget2, rootNode, pos) => {
        const nPos = normalizeForwards(pos);
        return findInsideRootInline(isInlineTarget2, rootNode, nPos).bind((inline) => {
          const nextPos = nextPosition(inline, nPos);
          return nextPos.isNone() ? Optional.some(Location.end(inline)) : Optional.none();
        });
      };
      const after = (isInlineTarget2, rootNode, pos) => {
        const nPos = normalizeBackwards(pos);
        const scope = rescope$1(rootNode, nPos.container());
        return findRootInline(isInlineTarget2, scope, nPos).fold(() => prevPosition(scope, nPos).bind(curry(findRootInline, isInlineTarget2, scope)).map((inline) => Location.after(inline)), Optional.none);
      };
      const isValidLocation = (location) => !isRtl(getElement(location));
      const readLocation = (isInlineTarget2, rootNode, pos) => {
        const location = evaluateUntil([
          before,
          start$1,
          end,
          after
        ], [
          isInlineTarget2,
          rootNode,
          pos
        ]);
        return location.filter(isValidLocation);
      };
      const getElement = (location) => location.fold(identity, identity, identity, identity);
      const getName = (location) => location.fold(constant("before"), constant("start"), constant("end"), constant("after"));
      const outside = (location) => location.fold(Location.before, Location.before, Location.after, Location.after);
      const inside = (location) => location.fold(Location.start, Location.start, Location.end, Location.end);
      const isEq = (location1, location2) => getName(location1) === getName(location2) && getElement(location1) === getElement(location2);
      const betweenInlines = (forward, isInlineTarget2, rootNode, from2, to2, location) => lift2(findRootInline(isInlineTarget2, rootNode, from2), findRootInline(isInlineTarget2, rootNode, to2), (fromInline, toInline) => {
        if (fromInline !== toInline && hasSameParentBlock(rootNode, fromInline, toInline)) {
          return Location.after(forward ? fromInline : toInline);
        } else {
          return location;
        }
      }).getOr(location);
      const skipNoMovement = (fromLocation, toLocation) => fromLocation.fold(always, (fromLocation2) => !isEq(fromLocation2, toLocation));
      const findLocationTraverse = (forward, isInlineTarget2, rootNode, fromLocation, pos) => {
        const from2 = normalizePosition(forward, pos);
        const to2 = fromPosition(forward, rootNode, from2).map(curry(normalizePosition, forward));
        const location = to2.fold(() => fromLocation.map(outside), (to3) => readLocation(isInlineTarget2, rootNode, to3).map(curry(betweenInlines, forward, isInlineTarget2, rootNode, from2, to3)).filter(curry(skipNoMovement, fromLocation)));
        return location.filter(isValidLocation);
      };
      const findLocationSimple = (forward, location) => {
        if (forward) {
          return location.fold(compose(Optional.some, Location.start), Optional.none, compose(Optional.some, Location.after), Optional.none);
        } else {
          return location.fold(Optional.none, compose(Optional.some, Location.before), Optional.none, compose(Optional.some, Location.end));
        }
      };
      const findLocation$1 = (forward, isInlineTarget2, rootNode, pos) => {
        const from2 = normalizePosition(forward, pos);
        const fromLocation = readLocation(isInlineTarget2, rootNode, from2);
        return readLocation(isInlineTarget2, rootNode, from2).bind(curry(findLocationSimple, forward)).orThunk(() => findLocationTraverse(forward, isInlineTarget2, rootNode, fromLocation, pos));
      };
      const hasSelectionModifyApi = (editor) => {
        return isFunction(editor.selection.getSel().modify);
      };
      const moveRel = (forward, selection, pos) => {
        const delta = forward ? 1 : -1;
        selection.setRng(CaretPosition(pos.container(), pos.offset() + delta).toRange());
        selection.getSel().modify("move", forward ? "forward" : "backward", "word");
        return true;
      };
      const moveByWord = (forward, editor) => {
        const rng = editor.selection.getRng();
        const pos = forward ? CaretPosition.fromRangeEnd(rng) : CaretPosition.fromRangeStart(rng);
        if (!hasSelectionModifyApi(editor)) {
          return false;
        } else if (forward && isBeforeInline(pos)) {
          return moveRel(true, editor.selection, pos);
        } else if (!forward && isAfterInline(pos)) {
          return moveRel(false, editor.selection, pos);
        } else {
          return false;
        }
      };
      var BreakType;
      (function(BreakType2) {
        BreakType2[BreakType2["Br"] = 0] = "Br";
        BreakType2[BreakType2["Block"] = 1] = "Block";
        BreakType2[BreakType2["Wrap"] = 2] = "Wrap";
        BreakType2[BreakType2["Eol"] = 3] = "Eol";
      })(BreakType || (BreakType = {}));
      const flip = (direction, positions) => direction === -1 ? reverse(positions) : positions;
      const walk$1 = (direction, caretWalker, pos) => direction === 1 ? caretWalker.next(pos) : caretWalker.prev(pos);
      const getBreakType = (scope, direction, currentPos, nextPos) => {
        if (isBr$6(nextPos.getNode(direction === 1))) {
          return BreakType.Br;
        } else if (isInSameBlock(currentPos, nextPos) === false) {
          return BreakType.Block;
        } else {
          return BreakType.Wrap;
        }
      };
      const getPositionsUntil = (predicate, direction, scope, start2) => {
        const caretWalker = CaretWalker(scope);
        let currentPos = start2;
        const positions = [];
        while (currentPos) {
          const nextPos = walk$1(direction, caretWalker, currentPos);
          if (!nextPos) {
            break;
          }
          if (isBr$6(nextPos.getNode(false))) {
            if (direction === 1) {
              return {
                positions: flip(direction, positions).concat([nextPos]),
                breakType: BreakType.Br,
                breakAt: Optional.some(nextPos)
              };
            } else {
              return {
                positions: flip(direction, positions),
                breakType: BreakType.Br,
                breakAt: Optional.some(nextPos)
              };
            }
          }
          if (!nextPos.isVisible()) {
            currentPos = nextPos;
            continue;
          }
          if (predicate(currentPos, nextPos)) {
            const breakType = getBreakType(scope, direction, currentPos, nextPos);
            return {
              positions: flip(direction, positions),
              breakType,
              breakAt: Optional.some(nextPos)
            };
          }
          positions.push(nextPos);
          currentPos = nextPos;
        }
        return {
          positions: flip(direction, positions),
          breakType: BreakType.Eol,
          breakAt: Optional.none()
        };
      };
      const getAdjacentLinePositions = (direction, getPositionsUntilBreak, scope, start2) => getPositionsUntilBreak(scope, start2).breakAt.map((pos) => {
        const positions = getPositionsUntilBreak(scope, pos).positions;
        return direction === -1 ? positions.concat(pos) : [pos].concat(positions);
      }).getOr([]);
      const findClosestHorizontalPositionFromPoint = (positions, x) => foldl(positions, (acc, newPos) => acc.fold(() => Optional.some(newPos), (lastPos) => lift2(head(lastPos.getClientRects()), head(newPos.getClientRects()), (lastRect, newRect) => {
        const lastDist = Math.abs(x - lastRect.left);
        const newDist = Math.abs(x - newRect.left);
        return newDist <= lastDist ? newPos : lastPos;
      }).or(acc)), Optional.none());
      const findClosestHorizontalPosition = (positions, pos) => head(pos.getClientRects()).bind((targetRect) => findClosestHorizontalPositionFromPoint(positions, targetRect.left));
      const getPositionsUntilPreviousLine = curry(getPositionsUntil, CaretPosition.isAbove, -1);
      const getPositionsUntilNextLine = curry(getPositionsUntil, CaretPosition.isBelow, 1);
      const getPositionsAbove = curry(getAdjacentLinePositions, -1, getPositionsUntilPreviousLine);
      const getPositionsBelow = curry(getAdjacentLinePositions, 1, getPositionsUntilNextLine);
      const isAtFirstLine = (scope, pos) => getPositionsUntilPreviousLine(scope, pos).breakAt.isNone();
      const isAtLastLine = (scope, pos) => getPositionsUntilNextLine(scope, pos).breakAt.isNone();
      const getFirstLinePositions = (scope) => firstPositionIn(scope).map((pos) => [pos].concat(getPositionsUntilNextLine(scope, pos).positions)).getOr([]);
      const getLastLinePositions = (scope) => lastPositionIn(scope).map((pos) => getPositionsUntilPreviousLine(scope, pos).positions.concat(pos)).getOr([]);
      const getClosestPositionAbove = (scope, pos) => findClosestHorizontalPosition(getPositionsAbove(scope, pos), pos);
      const getClosestPositionBelow = (scope, pos) => findClosestHorizontalPosition(getPositionsBelow(scope, pos), pos);
      const isContentEditableFalse$5 = isContentEditableFalse$b;
      const distanceToRectLeft$1 = (clientRect, clientX) => Math.abs(clientRect.left - clientX);
      const distanceToRectRight$1 = (clientRect, clientX) => Math.abs(clientRect.right - clientX);
      const isNodeClientRect = (rect) => hasNonNullableKey(rect, "node");
      const findClosestClientRect = (clientRects, clientX) => reduce(clientRects, (oldClientRect, clientRect) => {
        const oldDistance = Math.min(distanceToRectLeft$1(oldClientRect, clientX), distanceToRectRight$1(oldClientRect, clientX));
        const newDistance = Math.min(distanceToRectLeft$1(clientRect, clientX), distanceToRectRight$1(clientRect, clientX));
        if (newDistance === oldDistance && isNodeClientRect(clientRect) && isContentEditableFalse$5(clientRect.node)) {
          return clientRect;
        }
        if (newDistance < oldDistance) {
          return clientRect;
        }
        return oldClientRect;
      });
      const getNodeClientRects = (node) => {
        const toArrayWithNode = (clientRects) => {
          return map$3(clientRects, (rect) => {
            const clientRect = clone$1(rect);
            clientRect.node = node;
            return clientRect;
          });
        };
        if (isElement$6(node)) {
          return toArrayWithNode(node.getClientRects());
        } else if (isText$b(node)) {
          const rng = node.ownerDocument.createRange();
          rng.setStart(node, 0);
          rng.setEnd(node, node.data.length);
          return toArrayWithNode(rng.getClientRects());
        } else {
          return [];
        }
      };
      const getClientRects = (nodes) => bind$3(nodes, getNodeClientRects);
      var VDirection;
      (function(VDirection2) {
        VDirection2[VDirection2["Up"] = -1] = "Up";
        VDirection2[VDirection2["Down"] = 1] = "Down";
      })(VDirection || (VDirection = {}));
      const findUntil = (direction, root, predicateFn, node) => {
        let currentNode = node;
        while (currentNode = findNode(currentNode, direction, isEditableCaretCandidate$1, root)) {
          if (predicateFn(currentNode)) {
            return;
          }
        }
      };
      const walkUntil = (direction, isAboveFn, isBeflowFn, root, predicateFn, caretPosition) => {
        let line = 0;
        const result = [];
        const add2 = (node2) => {
          let clientRects = getClientRects([node2]);
          if (direction === VDirection.Up) {
            clientRects = clientRects.reverse();
          }
          for (let i = 0; i < clientRects.length; i++) {
            const clientRect = clientRects[i];
            if (isBeflowFn(clientRect, targetClientRect)) {
              continue;
            }
            if (result.length > 0 && isAboveFn(clientRect, last$1(result))) {
              line++;
            }
            clientRect.line = line;
            if (predicateFn(clientRect)) {
              return true;
            }
            result.push(clientRect);
          }
          return false;
        };
        const targetClientRect = last$1(caretPosition.getClientRects());
        if (!targetClientRect) {
          return result;
        }
        const node = caretPosition.getNode();
        if (node) {
          add2(node);
          findUntil(direction, root, add2, node);
        }
        return result;
      };
      const aboveLineNumber = (lineNumber, clientRect) => clientRect.line > lineNumber;
      const isLineNumber = (lineNumber, clientRect) => clientRect.line === lineNumber;
      const upUntil = curry(walkUntil, VDirection.Up, isAbove$1, isBelow$1);
      const downUntil = curry(walkUntil, VDirection.Down, isBelow$1, isAbove$1);
      const getLastClientRect = (caretPosition) => {
        return last$1(caretPosition.getClientRects());
      };
      const positionsUntil = (direction, root, predicateFn, node) => {
        const caretWalker = CaretWalker(root);
        let walkFn;
        let isBelowFn;
        let isAboveFn;
        let caretPosition;
        const result = [];
        let line = 0;
        if (direction === VDirection.Down) {
          walkFn = caretWalker.next;
          isBelowFn = isBelow$1;
          isAboveFn = isAbove$1;
          caretPosition = CaretPosition.after(node);
        } else {
          walkFn = caretWalker.prev;
          isBelowFn = isAbove$1;
          isAboveFn = isBelow$1;
          caretPosition = CaretPosition.before(node);
        }
        const targetClientRect = getLastClientRect(caretPosition);
        do {
          if (!caretPosition.isVisible()) {
            continue;
          }
          const rect = getLastClientRect(caretPosition);
          if (isAboveFn(rect, targetClientRect)) {
            continue;
          }
          if (result.length > 0 && isBelowFn(rect, last$1(result))) {
            line++;
          }
          const clientRect = clone$1(rect);
          clientRect.position = caretPosition;
          clientRect.line = line;
          if (predicateFn(clientRect)) {
            return result;
          }
          result.push(clientRect);
        } while (caretPosition = walkFn(caretPosition));
        return result;
      };
      const isAboveLine = (lineNumber) => (clientRect) => aboveLineNumber(lineNumber, clientRect);
      const isLine = (lineNumber) => (clientRect) => isLineNumber(lineNumber, clientRect);
      const moveToRange = (editor, rng) => {
        editor.selection.setRng(rng);
        scrollRangeIntoView(editor, editor.selection.getRng());
      };
      const renderRangeCaretOpt = (editor, range2, scrollIntoView) => Optional.some(renderRangeCaret(editor, range2, scrollIntoView));
      const moveHorizontally = (editor, direction, range2, isBefore, isAfter, isElement2) => {
        const forwards = direction === 1;
        const caretWalker = CaretWalker(editor.getBody());
        const getNextPosFn = curry(getVisualCaretPosition, forwards ? caretWalker.next : caretWalker.prev);
        const isBeforeFn = forwards ? isBefore : isAfter;
        if (!range2.collapsed) {
          const node = getSelectedNode(range2);
          if (isElement2(node)) {
            return showCaret(direction, editor, node, direction === -1, false);
          } else if (isCefAtEdgeSelected(editor)) {
            const newRange = range2.cloneRange();
            newRange.collapse(direction === -1);
            return Optional.from(newRange);
          }
        }
        const caretPosition = getNormalizedRangeEndPoint(direction, editor.getBody(), range2);
        if (isBeforeFn(caretPosition)) {
          return selectNode(editor, caretPosition.getNode(!forwards));
        }
        let nextCaretPosition = getNextPosFn(caretPosition);
        const rangeIsInContainerBlock = isRangeInCaretContainerBlock(range2);
        if (!nextCaretPosition) {
          return rangeIsInContainerBlock ? Optional.some(range2) : Optional.none();
        } else {
          nextCaretPosition = normalizePosition(forwards, nextCaretPosition);
        }
        if (isBeforeFn(nextCaretPosition)) {
          return showCaret(direction, editor, nextCaretPosition.getNode(!forwards), forwards, false);
        }
        const peekCaretPosition = getNextPosFn(nextCaretPosition);
        if (peekCaretPosition && isBeforeFn(peekCaretPosition)) {
          if (isMoveInsideSameBlock(nextCaretPosition, peekCaretPosition)) {
            return showCaret(direction, editor, peekCaretPosition.getNode(!forwards), forwards, false);
          }
        }
        if (rangeIsInContainerBlock) {
          return renderRangeCaretOpt(editor, nextCaretPosition.toRange(), false);
        }
        return Optional.none();
      };
      const moveVertically = (editor, direction, range2, isBefore, isAfter, isElement2) => {
        const caretPosition = getNormalizedRangeEndPoint(direction, editor.getBody(), range2);
        const caretClientRect = last$1(caretPosition.getClientRects());
        const forwards = direction === VDirection.Down;
        const root = editor.getBody();
        if (!caretClientRect) {
          return Optional.none();
        }
        if (isCefAtEdgeSelected(editor)) {
          const caretPosition2 = forwards ? CaretPosition.fromRangeEnd(range2) : CaretPosition.fromRangeStart(range2);
          const getClosestFn = !forwards ? getClosestPositionAbove : getClosestPositionBelow;
          return getClosestFn(root, caretPosition2).orThunk(() => Optional.from(caretPosition2)).map((pos) => pos.toRange());
        }
        const walkerFn = forwards ? downUntil : upUntil;
        const linePositions = walkerFn(root, isAboveLine(1), caretPosition);
        const nextLinePositions = filter$5(linePositions, isLine(1));
        const clientX = caretClientRect.left;
        const nextLineRect = findClosestClientRect(nextLinePositions, clientX);
        if (nextLineRect && isElement2(nextLineRect.node)) {
          const dist1 = Math.abs(clientX - nextLineRect.left);
          const dist2 = Math.abs(clientX - nextLineRect.right);
          return showCaret(direction, editor, nextLineRect.node, dist1 < dist2, false);
        }
        let currentNode;
        if (isBefore(caretPosition)) {
          currentNode = caretPosition.getNode();
        } else if (isAfter(caretPosition)) {
          currentNode = caretPosition.getNode(true);
        } else {
          currentNode = getSelectedNode(range2);
        }
        if (currentNode) {
          const caretPositions = positionsUntil(direction, root, isAboveLine(1), currentNode);
          let closestNextLineRect = findClosestClientRect(filter$5(caretPositions, isLine(1)), clientX);
          if (closestNextLineRect) {
            return renderRangeCaretOpt(editor, closestNextLineRect.position.toRange(), false);
          }
          closestNextLineRect = last$1(filter$5(caretPositions, isLine(0)));
          if (closestNextLineRect) {
            return renderRangeCaretOpt(editor, closestNextLineRect.position.toRange(), false);
          }
        }
        if (nextLinePositions.length === 0) {
          return getLineEndPoint(editor, forwards).filter(forwards ? isAfter : isBefore).map((pos) => renderRangeCaret(editor, pos.toRange(), false));
        }
        return Optional.none();
      };
      const getLineEndPoint = (editor, forward) => {
        const rng = editor.selection.getRng();
        const from2 = forward ? CaretPosition.fromRangeEnd(rng) : CaretPosition.fromRangeStart(rng);
        const host = getEditingHost(from2.container(), editor.getBody());
        if (forward) {
          const lineInfo = getPositionsUntilNextLine(host, from2);
          return last$2(lineInfo.positions);
        } else {
          const lineInfo = getPositionsUntilPreviousLine(host, from2);
          return head(lineInfo.positions);
        }
      };
      const moveToLineEndPoint$3 = (editor, forward, isElementPosition) => getLineEndPoint(editor, forward).filter(isElementPosition).exists((pos) => {
        editor.selection.setRng(pos.toRange());
        return true;
      });
      const setCaretPosition = (editor, pos) => {
        const rng = editor.dom.createRng();
        rng.setStart(pos.container(), pos.offset());
        rng.setEnd(pos.container(), pos.offset());
        editor.selection.setRng(rng);
      };
      const setSelected = (state, elm) => {
        if (state) {
          elm.setAttribute("data-mce-selected", "inline-boundary");
        } else {
          elm.removeAttribute("data-mce-selected");
        }
      };
      const renderCaretLocation = (editor, caret, location) => renderCaret(caret, location).map((pos) => {
        setCaretPosition(editor, pos);
        return location;
      });
      const getPositionFromRange = (range2, root, forward) => {
        const start2 = CaretPosition.fromRangeStart(range2);
        if (range2.collapsed) {
          return start2;
        } else {
          const end2 = CaretPosition.fromRangeEnd(range2);
          return forward ? prevPosition(root, end2).getOr(end2) : nextPosition(root, start2).getOr(start2);
        }
      };
      const findLocation = (editor, caret, forward) => {
        const rootNode = editor.getBody();
        const from2 = getPositionFromRange(editor.selection.getRng(), rootNode, forward);
        const isInlineTarget$1 = curry(isInlineTarget, editor);
        const location = findLocation$1(forward, isInlineTarget$1, rootNode, from2);
        return location.bind((location2) => renderCaretLocation(editor, caret, location2));
      };
      const toggleInlines = (isInlineTarget2, dom2, elms) => {
        const inlineBoundaries = map$3(descendants(SugarElement.fromDom(dom2.getRoot()), '*[data-mce-selected="inline-boundary"]'), (e) => e.dom);
        const selectedInlines = filter$5(inlineBoundaries, isInlineTarget2);
        const targetInlines = filter$5(elms, isInlineTarget2);
        each$e(difference(selectedInlines, targetInlines), curry(setSelected, false));
        each$e(difference(targetInlines, selectedInlines), curry(setSelected, true));
      };
      const safeRemoveCaretContainer = (editor, caret) => {
        const caretValue = caret.get();
        if (editor.selection.isCollapsed() && !editor.composing && caretValue) {
          const pos = CaretPosition.fromRangeStart(editor.selection.getRng());
          if (CaretPosition.isTextPosition(pos) && !isAtZwsp(pos)) {
            setCaretPosition(editor, removeAndReposition(caretValue, pos));
            caret.set(null);
          }
        }
      };
      const renderInsideInlineCaret = (isInlineTarget2, editor, caret, elms) => {
        if (editor.selection.isCollapsed()) {
          const inlines = filter$5(elms, isInlineTarget2);
          each$e(inlines, (_inline) => {
            const pos = CaretPosition.fromRangeStart(editor.selection.getRng());
            readLocation(isInlineTarget2, editor.getBody(), pos).bind((location) => renderCaretLocation(editor, caret, location));
          });
        }
      };
      const move$3 = (editor, caret, forward) => isInlineBoundariesEnabled(editor) ? findLocation(editor, caret, forward).isSome() : false;
      const moveWord = (forward, editor, _caret) => isInlineBoundariesEnabled(editor) ? moveByWord(forward, editor) : false;
      const setupSelectedState = (editor) => {
        const caret = Cell(null);
        const isInlineTarget$1 = curry(isInlineTarget, editor);
        editor.on("NodeChange", (e) => {
          if (isInlineBoundariesEnabled(editor)) {
            toggleInlines(isInlineTarget$1, editor.dom, e.parents);
            safeRemoveCaretContainer(editor, caret);
            renderInsideInlineCaret(isInlineTarget$1, editor, caret, e.parents);
          }
        });
        return caret;
      };
      const moveNextWord = curry(moveWord, true);
      const movePrevWord = curry(moveWord, false);
      const moveToLineEndPoint$2 = (editor, forward, caret) => {
        if (isInlineBoundariesEnabled(editor)) {
          const linePoint = getLineEndPoint(editor, forward).getOrThunk(() => {
            const rng = editor.selection.getRng();
            return forward ? CaretPosition.fromRangeEnd(rng) : CaretPosition.fromRangeStart(rng);
          });
          return readLocation(curry(isInlineTarget, editor), editor.getBody(), linePoint).exists((loc) => {
            const outsideLoc = outside(loc);
            return renderCaret(caret, outsideLoc).exists((pos) => {
              setCaretPosition(editor, pos);
              return true;
            });
          });
        } else {
          return false;
        }
      };
      const rangeFromPositions = (from2, to2) => {
        const range2 = document.createRange();
        range2.setStart(from2.container(), from2.offset());
        range2.setEnd(to2.container(), to2.offset());
        return range2;
      };
      const hasOnlyTwoOrLessPositionsLeft = (elm) => lift2(firstPositionIn(elm), lastPositionIn(elm), (firstPos, lastPos) => {
        const normalizedFirstPos = normalizePosition(true, firstPos);
        const normalizedLastPos = normalizePosition(false, lastPos);
        return nextPosition(elm, normalizedFirstPos).forall((pos) => pos.isEqual(normalizedLastPos));
      }).getOr(true);
      const setCaretLocation = (editor, caret) => (location) => renderCaret(caret, location).map((pos) => () => setCaretPosition(editor, pos));
      const deleteFromTo = (editor, caret, from2, to2) => {
        const rootNode = editor.getBody();
        const isInlineTarget$1 = curry(isInlineTarget, editor);
        editor.undoManager.ignore(() => {
          editor.selection.setRng(rangeFromPositions(from2, to2));
          execNativeDeleteCommand(editor);
          readLocation(isInlineTarget$1, rootNode, CaretPosition.fromRangeStart(editor.selection.getRng())).map(inside).bind(setCaretLocation(editor, caret)).each(call);
        });
        editor.nodeChanged();
      };
      const rescope = (rootNode, node) => {
        const parentBlock = getParentBlock$3(node, rootNode);
        return parentBlock ? parentBlock : rootNode;
      };
      const backspaceDeleteCollapsed = (editor, caret, forward, from2) => {
        const rootNode = rescope(editor.getBody(), from2.container());
        const isInlineTarget$1 = curry(isInlineTarget, editor);
        const fromLocation = readLocation(isInlineTarget$1, rootNode, from2);
        const location = fromLocation.bind((location2) => {
          if (forward) {
            return location2.fold(constant(Optional.some(inside(location2))), Optional.none, constant(Optional.some(outside(location2))), Optional.none);
          } else {
            return location2.fold(Optional.none, constant(Optional.some(outside(location2))), Optional.none, constant(Optional.some(inside(location2))));
          }
        });
        return location.map(setCaretLocation(editor, caret)).getOrThunk(() => {
          const toPosition = navigate(forward, rootNode, from2);
          const toLocation = toPosition.bind((pos) => readLocation(isInlineTarget$1, rootNode, pos));
          return lift2(fromLocation, toLocation, () => findRootInline(isInlineTarget$1, rootNode, from2).bind((elm) => {
            if (hasOnlyTwoOrLessPositionsLeft(elm)) {
              return Optional.some(() => {
                deleteElement$2(editor, forward, SugarElement.fromDom(elm));
              });
            } else {
              return Optional.none();
            }
          })).getOrThunk(() => toLocation.bind(() => toPosition.map((to2) => {
            return () => {
              if (forward) {
                deleteFromTo(editor, caret, from2, to2);
              } else {
                deleteFromTo(editor, caret, to2, from2);
              }
            };
          })));
        });
      };
      const backspaceDelete$4 = (editor, caret, forward) => {
        if (editor.selection.isCollapsed() && isInlineBoundariesEnabled(editor)) {
          const from2 = CaretPosition.fromRangeStart(editor.selection.getRng());
          return backspaceDeleteCollapsed(editor, caret, forward, from2);
        }
        return Optional.none();
      };
      const hasMultipleChildren = (elm) => childNodesCount(elm) > 1;
      const getParentsUntil = (editor, pred) => {
        const rootElm = SugarElement.fromDom(editor.getBody());
        const startElm = SugarElement.fromDom(editor.selection.getStart());
        const parents2 = parentsAndSelf(startElm, rootElm);
        return findIndex$2(parents2, pred).fold(constant(parents2), (index) => parents2.slice(0, index));
      };
      const hasOnlyOneChild = (elm) => childNodesCount(elm) === 1;
      const getParentInlinesUntilMultichildInline = (editor) => getParentsUntil(editor, (elm) => editor.schema.isBlock(name(elm)) || hasMultipleChildren(elm));
      const getParentInlines = (editor) => getParentsUntil(editor, (el) => editor.schema.isBlock(name(el)));
      const getFormatNodes = (editor, parentInlines) => {
        const isFormatElement$1 = curry(isFormatElement, editor);
        return bind$3(parentInlines, (elm) => isFormatElement$1(elm) ? [elm.dom] : []);
      };
      const getFormatNodesAtStart = (editor) => {
        const parentInlines = getParentInlines(editor);
        return getFormatNodes(editor, parentInlines);
      };
      const deleteLastPosition = (forward, editor, target, parentInlines) => {
        const formatNodes = getFormatNodes(editor, parentInlines);
        if (formatNodes.length === 0) {
          deleteElement$2(editor, forward, target);
        } else {
          const pos = replaceWithCaretFormat(target.dom, formatNodes);
          editor.selection.setRng(pos.toRange());
        }
      };
      const deleteCaret$1 = (editor, forward) => {
        const parentInlines = filter$5(getParentInlinesUntilMultichildInline(editor), hasOnlyOneChild);
        return last$2(parentInlines).bind((target) => {
          const fromPos = CaretPosition.fromRangeStart(editor.selection.getRng());
          if (willDeleteLastPositionInElement(forward, fromPos, target.dom) && !isEmptyCaretFormatElement(target)) {
            return Optional.some(() => deleteLastPosition(forward, editor, target, parentInlines));
          } else {
            return Optional.none();
          }
        });
      };
      const isBrInEmptyElement = (editor, elm) => {
        const parentElm = elm.parentElement;
        return isBr$6(elm) && !isNull(parentElm) && editor.dom.isEmpty(parentElm);
      };
      const isEmptyCaret = (elm) => isEmptyCaretFormatElement(SugarElement.fromDom(elm));
      const createCaretFormatAtStart = (editor, formatNodes) => {
        const startElm = editor.selection.getStart();
        const pos = isBrInEmptyElement(editor, startElm) || isEmptyCaret(startElm) ? replaceWithCaretFormat(startElm, formatNodes) : createCaretFormatAtStart$1(editor.selection.getRng(), formatNodes);
        editor.selection.setRng(pos.toRange());
      };
      const updateCaretFormat = (editor, updateFormats) => {
        const missingFormats = difference(updateFormats, getFormatNodesAtStart(editor));
        if (missingFormats.length > 0) {
          createCaretFormatAtStart(editor, missingFormats);
        }
      };
      const rangeStartsAtTextContainer = (rng) => isText$b(rng.startContainer);
      const rangeStartsAtStartOfTextContainer = (rng) => rng.startOffset === 0 && rangeStartsAtTextContainer(rng);
      const rangeStartParentIsFormatElement = (editor, rng) => {
        const startParent = rng.startContainer.parentElement;
        return !isNull(startParent) && isFormatElement(editor, SugarElement.fromDom(startParent));
      };
      const rangeStartAndEndHaveSameParent = (rng) => {
        const startParent = rng.startContainer.parentNode;
        const endParent = rng.endContainer.parentNode;
        return !isNull(startParent) && !isNull(endParent) && startParent.isEqualNode(endParent);
      };
      const rangeEndsAtEndOfEndContainer = (rng) => {
        const endContainer = rng.endContainer;
        return rng.endOffset === (isText$b(endContainer) ? endContainer.length : endContainer.childNodes.length);
      };
      const rangeEndsAtEndOfStartContainer = (rng) => rangeStartAndEndHaveSameParent(rng) && rangeEndsAtEndOfEndContainer(rng);
      const rangeEndsAfterEndOfStartContainer = (rng) => !rng.endContainer.isEqualNode(rng.commonAncestorContainer);
      const rangeEndsAtOrAfterEndOfStartContainer = (rng) => rangeEndsAtEndOfStartContainer(rng) || rangeEndsAfterEndOfStartContainer(rng);
      const requiresDeleteRangeOverride = (editor) => {
        const rng = editor.selection.getRng();
        return rangeStartsAtStartOfTextContainer(rng) && rangeStartParentIsFormatElement(editor, rng) && rangeEndsAtOrAfterEndOfStartContainer(rng);
      };
      const deleteRange$1 = (editor) => {
        if (requiresDeleteRangeOverride(editor)) {
          const formatNodes = getFormatNodesAtStart(editor);
          return Optional.some(() => {
            execNativeDeleteCommand(editor);
            updateCaretFormat(editor, formatNodes);
          });
        } else {
          return Optional.none();
        }
      };
      const backspaceDelete$3 = (editor, forward) => editor.selection.isCollapsed() ? deleteCaret$1(editor, forward) : deleteRange$1(editor);
      const hasAncestorInlineCaret = (elm, schema) => ancestor$2(elm, (node) => isCaretNode(node.dom), (el) => schema.isBlock(name(el)));
      const hasAncestorInlineCaretAtStart = (editor) => hasAncestorInlineCaret(SugarElement.fromDom(editor.selection.getStart()), editor.schema);
      const requiresRefreshCaretOverride = (editor) => {
        const rng = editor.selection.getRng();
        return rng.collapsed && (rangeStartsAtTextContainer(rng) || editor.dom.isEmpty(rng.startContainer)) && !hasAncestorInlineCaretAtStart(editor);
      };
      const refreshCaret = (editor) => {
        if (requiresRefreshCaretOverride(editor)) {
          createCaretFormatAtStart(editor, []);
        }
        return true;
      };
      const deleteElement = (editor, forward, element) => {
        if (isNonNullable(element)) {
          return Optional.some(() => {
            editor._selectionOverrides.hideFakeCaret();
            deleteElement$2(editor, forward, SugarElement.fromDom(element));
          });
        } else {
          return Optional.none();
        }
      };
      const deleteCaret = (editor, forward) => {
        const isNearMedia = forward ? isBeforeMedia : isAfterMedia;
        const direction = forward ? 1 : -1;
        const fromPos = getNormalizedRangeEndPoint(direction, editor.getBody(), editor.selection.getRng());
        if (isNearMedia(fromPos)) {
          return deleteElement(editor, forward, fromPos.getNode(!forward));
        } else {
          return Optional.from(normalizePosition(forward, fromPos)).filter((pos) => isNearMedia(pos) && isMoveInsideSameBlock(fromPos, pos)).bind((pos) => deleteElement(editor, forward, pos.getNode(!forward)));
        }
      };
      const deleteRange = (editor, forward) => {
        const selectedNode = editor.selection.getNode();
        return isMedia$2(selectedNode) ? deleteElement(editor, forward, selectedNode) : Optional.none();
      };
      const backspaceDelete$2 = (editor, forward) => editor.selection.isCollapsed() ? deleteCaret(editor, forward) : deleteRange(editor, forward);
      const isEditable = (target) => closest$4(target, (elm) => isContentEditableTrue$3(elm.dom) || isContentEditableFalse$b(elm.dom)).exists((elm) => isContentEditableTrue$3(elm.dom));
      const parseIndentValue = (value2) => toInt(value2 !== null && value2 !== void 0 ? value2 : "").getOr(0);
      const getIndentStyleName = (useMargin, element) => {
        const indentStyleName = useMargin || isTable$1(element) ? "margin" : "padding";
        const suffix = get$7(element, "direction") === "rtl" ? "-right" : "-left";
        return indentStyleName + suffix;
      };
      const indentElement = (dom2, command, useMargin, value2, unit, element) => {
        const indentStyleName = getIndentStyleName(useMargin, SugarElement.fromDom(element));
        const parsedValue = parseIndentValue(dom2.getStyle(element, indentStyleName));
        if (command === "outdent") {
          const styleValue = Math.max(0, parsedValue - value2);
          dom2.setStyle(element, indentStyleName, styleValue ? styleValue + unit : "");
        } else {
          const styleValue = parsedValue + value2 + unit;
          dom2.setStyle(element, indentStyleName, styleValue);
        }
      };
      const validateBlocks = (editor, blocks) => forall(blocks, (block) => {
        const indentStyleName = getIndentStyleName(shouldIndentUseMargin(editor), block);
        const intentValue = getRaw(block, indentStyleName).map(parseIndentValue).getOr(0);
        const contentEditable = editor.dom.getContentEditable(block.dom);
        return contentEditable !== "false" && intentValue > 0;
      });
      const canOutdent = (editor) => {
        const blocks = getBlocksToIndent(editor);
        return !editor.mode.isReadOnly() && (blocks.length > 1 || validateBlocks(editor, blocks));
      };
      const isListComponent = (el) => isList(el) || isListItem$1(el);
      const parentIsListComponent = (el) => parent(el).exists(isListComponent);
      const getBlocksToIndent = (editor) => filter$5(fromDom$1(editor.selection.getSelectedBlocks()), (el) => !isListComponent(el) && !parentIsListComponent(el) && isEditable(el));
      const handle = (editor, command) => {
        var _a, _b;
        if (editor.mode.isReadOnly()) {
          return;
        }
        const { dom: dom2 } = editor;
        const indentation = getIndentation(editor);
        const indentUnit = (_b = (_a = /[a-z%]+$/i.exec(indentation)) === null || _a === void 0 ? void 0 : _a[0]) !== null && _b !== void 0 ? _b : "px";
        const indentValue = parseIndentValue(indentation);
        const useMargin = shouldIndentUseMargin(editor);
        each$e(getBlocksToIndent(editor), (block) => {
          indentElement(dom2, command, useMargin, indentValue, indentUnit, block.dom);
        });
      };
      const indent = (editor) => handle(editor, "indent");
      const outdent = (editor) => handle(editor, "outdent");
      const backspaceDelete$1 = (editor) => {
        if (editor.selection.isCollapsed() && canOutdent(editor)) {
          const dom2 = editor.dom;
          const rng = editor.selection.getRng();
          const pos = CaretPosition.fromRangeStart(rng);
          const block = dom2.getParent(rng.startContainer, dom2.isBlock);
          if (block !== null && isAtStartOfBlock(SugarElement.fromDom(block), pos, editor.schema)) {
            return Optional.some(() => outdent(editor));
          }
        }
        return Optional.none();
      };
      const findAction = (editor, caret, forward) => findMap([
        backspaceDelete$1,
        backspaceDelete$7,
        backspaceDelete$8,
        (editor2, forward2) => backspaceDelete$4(editor2, caret, forward2),
        backspaceDelete$a,
        backspaceDelete$b,
        backspaceDelete$5,
        backspaceDelete$2,
        backspaceDelete$9,
        backspaceDelete$3,
        backspaceDelete$6
      ], (item) => item(editor, forward)).filter((_) => editor.selection.isEditable());
      const deleteCommand = (editor, caret) => {
        const result = findAction(editor, caret, false);
        result.fold(() => {
          if (editor.selection.isEditable()) {
            execNativeDeleteCommand(editor);
            paddEmptyBody(editor);
          }
        }, call);
      };
      const forwardDeleteCommand = (editor, caret) => {
        const result = findAction(editor, caret, true);
        result.fold(() => {
          if (editor.selection.isEditable()) {
            execNativeForwardDeleteCommand(editor);
          }
        }, call);
      };
      const setup$q = (editor, caret) => {
        editor.addCommand("delete", () => {
          deleteCommand(editor, caret);
        });
        editor.addCommand("forwardDelete", () => {
          forwardDeleteCommand(editor, caret);
        });
      };
      const SIGNIFICANT_MOVE = 5;
      const LONGPRESS_DELAY = 400;
      const getTouch = (event) => {
        if (event.touches === void 0 || event.touches.length !== 1) {
          return Optional.none();
        }
        return Optional.some(event.touches[0]);
      };
      const isFarEnough = (touch, data2) => {
        const distX = Math.abs(touch.clientX - data2.x);
        const distY = Math.abs(touch.clientY - data2.y);
        return distX > SIGNIFICANT_MOVE || distY > SIGNIFICANT_MOVE;
      };
      const setup$p = (editor) => {
        const startData = value$2();
        const longpressFired = Cell(false);
        const debounceLongpress = last((e) => {
          editor.dispatch("longpress", {
            ...e,
            type: "longpress"
          });
          longpressFired.set(true);
        }, LONGPRESS_DELAY);
        editor.on("touchstart", (e) => {
          getTouch(e).each((touch) => {
            debounceLongpress.cancel();
            const data2 = {
              x: touch.clientX,
              y: touch.clientY,
              target: e.target
            };
            debounceLongpress.throttle(e);
            longpressFired.set(false);
            startData.set(data2);
          });
        }, true);
        editor.on("touchmove", (e) => {
          debounceLongpress.cancel();
          getTouch(e).each((touch) => {
            startData.on((data2) => {
              if (isFarEnough(touch, data2)) {
                startData.clear();
                longpressFired.set(false);
                editor.dispatch("longpresscancel");
              }
            });
          });
        }, true);
        editor.on("touchend touchcancel", (e) => {
          debounceLongpress.cancel();
          if (e.type === "touchcancel") {
            return;
          }
          startData.get().filter((data2) => data2.target.isEqualNode(e.target)).each(() => {
            if (longpressFired.get()) {
              e.preventDefault();
            } else {
              editor.dispatch("tap", {
                ...e,
                type: "tap"
              });
            }
          });
        }, true);
      };
      const isBlockElement = (blockElements, node) => has$2(blockElements, node.nodeName);
      const isValidTarget = (schema, node) => {
        if (isText$b(node)) {
          return true;
        } else if (isElement$6(node)) {
          return !isBlockElement(schema.getBlockElements(), node) && !isBookmarkNode$1(node) && !isTransparentBlock(schema, node) && !isNonHtmlElementRoot(node);
        } else {
          return false;
        }
      };
      const hasBlockParent = (blockElements, root, node) => {
        return exists(parents(SugarElement.fromDom(node), SugarElement.fromDom(root)), (elm) => {
          return isBlockElement(blockElements, elm.dom);
        });
      };
      const shouldRemoveTextNode = (blockElements, node) => {
        if (isText$b(node)) {
          if (node.data.length === 0) {
            return true;
          } else if (/^\s+$/.test(node.data)) {
            return !node.nextSibling || isBlockElement(blockElements, node.nextSibling) || isNonHtmlElementRoot(node.nextSibling);
          }
        }
        return false;
      };
      const createRootBlock = (editor) => editor.dom.create(getForcedRootBlock(editor), getForcedRootBlockAttrs(editor));
      const addRootBlocks = (editor) => {
        const dom2 = editor.dom, selection = editor.selection;
        const schema = editor.schema;
        const blockElements = schema.getBlockElements();
        const startNode = selection.getStart();
        const rootNode = editor.getBody();
        let rootBlockNode;
        let tempNode;
        let bm = null;
        const forcedRootBlock = getForcedRootBlock(editor);
        if (!startNode || !isElement$6(startNode)) {
          return;
        }
        const rootNodeName = rootNode.nodeName.toLowerCase();
        if (!schema.isValidChild(rootNodeName, forcedRootBlock.toLowerCase()) || hasBlockParent(blockElements, rootNode, startNode)) {
          return;
        }
        if (rootNode.firstChild === rootNode.lastChild && isBr$6(rootNode.firstChild)) {
          rootBlockNode = createRootBlock(editor);
          rootBlockNode.appendChild(createPaddingBr().dom);
          rootNode.replaceChild(rootBlockNode, rootNode.firstChild);
          editor.selection.setCursorLocation(rootBlockNode, 0);
          editor.nodeChanged();
          return;
        }
        let node = rootNode.firstChild;
        while (node) {
          if (isElement$6(node)) {
            updateElement(schema, node);
          }
          if (isValidTarget(schema, node)) {
            if (shouldRemoveTextNode(blockElements, node)) {
              tempNode = node;
              node = node.nextSibling;
              dom2.remove(tempNode);
              continue;
            }
            if (!rootBlockNode) {
              if (!bm && editor.hasFocus()) {
                bm = getBookmark(editor.selection.getRng(), () => document.createElement("span"));
              }
              if (!node.parentNode) {
                node = null;
                break;
              }
              rootBlockNode = createRootBlock(editor);
              rootNode.insertBefore(rootBlockNode, node);
            }
            tempNode = node;
            node = node.nextSibling;
            rootBlockNode.appendChild(tempNode);
          } else {
            rootBlockNode = null;
            node = node.nextSibling;
          }
        }
        if (bm) {
          editor.selection.setRng(resolveBookmark(bm));
          editor.nodeChanged();
        }
      };
      const insertEmptyLine = (editor, root, insertBlock2) => {
        const block = SugarElement.fromDom(createRootBlock(editor));
        const br = createPaddingBr();
        append$1(block, br);
        insertBlock2(root, block);
        const rng = document.createRange();
        rng.setStartBefore(br.dom);
        rng.setEndBefore(br.dom);
        return rng;
      };
      const setup$o = (editor) => {
        editor.on("NodeChange", () => addRootBlocks(editor));
      };
      const hasClass = (checkClassName) => (node) => (" " + node.attr("class") + " ").indexOf(checkClassName) !== -1;
      const replaceMatchWithSpan = (editor, content, cls) => {
        return function(match2) {
          const args = arguments, index = args[args.length - 2];
          const prevChar = index > 0 ? content.charAt(index - 1) : "";
          if (prevChar === '"') {
            return match2;
          }
          if (prevChar === ">") {
            const findStartTagIndex = content.lastIndexOf("<", index);
            if (findStartTagIndex !== -1) {
              const tagHtml = content.substring(findStartTagIndex, index);
              if (tagHtml.indexOf('contenteditable="false"') !== -1) {
                return match2;
              }
            }
          }
          return '<span class="' + cls + '" data-mce-content="' + editor.dom.encode(args[0]) + '">' + editor.dom.encode(typeof args[1] === "string" ? args[1] : args[0]) + "</span>";
        };
      };
      const convertRegExpsToNonEditable = (editor, nonEditableRegExps, e) => {
        let i = nonEditableRegExps.length, content = e.content;
        if (e.format === "raw") {
          return;
        }
        while (i--) {
          content = content.replace(nonEditableRegExps[i], replaceMatchWithSpan(editor, content, getNonEditableClass(editor)));
        }
        e.content = content;
      };
      const isValidContent = (nonEditableRegExps, content) => {
        return forall(nonEditableRegExps, (re) => {
          const matches = content.match(re);
          return matches !== null && matches[0].length === content.length;
        });
      };
      const setup$n = (editor) => {
        const contentEditableAttrName = "contenteditable";
        const editClass = " " + Tools.trim(getEditableClass(editor)) + " ";
        const nonEditClass = " " + Tools.trim(getNonEditableClass(editor)) + " ";
        const hasEditClass = hasClass(editClass);
        const hasNonEditClass = hasClass(nonEditClass);
        const nonEditableRegExps = getNonEditableRegExps(editor);
        if (nonEditableRegExps.length > 0) {
          editor.on("BeforeSetContent", (e) => {
            convertRegExpsToNonEditable(editor, nonEditableRegExps, e);
          });
        }
        editor.parser.addAttributeFilter("class", (nodes) => {
          let i = nodes.length;
          while (i--) {
            const node = nodes[i];
            if (hasEditClass(node)) {
              node.attr(contentEditableAttrName, "true");
            } else if (hasNonEditClass(node)) {
              node.attr(contentEditableAttrName, "false");
            }
          }
        });
        editor.serializer.addAttributeFilter(contentEditableAttrName, (nodes) => {
          let i = nodes.length;
          while (i--) {
            const node = nodes[i];
            if (!hasEditClass(node) && !hasNonEditClass(node)) {
              continue;
            }
            const content = node.attr("data-mce-content");
            if (nonEditableRegExps.length > 0 && content) {
              if (isValidContent(nonEditableRegExps, content)) {
                node.name = "#text";
                node.type = 3;
                node.raw = true;
                node.value = content;
              } else {
                node.remove();
              }
            } else {
              node.attr(contentEditableAttrName, null);
            }
          }
        });
      };
      const findBlockCaretContainer = (editor) => descendant$1(SugarElement.fromDom(editor.getBody()), "*[data-mce-caret]").map((elm) => elm.dom).getOrNull();
      const showBlockCaretContainer = (editor, blockCaretContainer) => {
        if (blockCaretContainer.hasAttribute("data-mce-caret")) {
          showCaretContainerBlock(blockCaretContainer);
          editor.selection.setRng(editor.selection.getRng());
          editor.selection.scrollIntoView(blockCaretContainer);
        }
      };
      const handleBlockContainer = (editor, e) => {
        const blockCaretContainer = findBlockCaretContainer(editor);
        if (!blockCaretContainer) {
          return;
        }
        if (e.type === "compositionstart") {
          e.preventDefault();
          e.stopPropagation();
          showBlockCaretContainer(editor, blockCaretContainer);
          return;
        }
        if (hasContent(blockCaretContainer)) {
          showBlockCaretContainer(editor, blockCaretContainer);
          editor.undoManager.add();
        }
      };
      const setup$m = (editor) => {
        editor.on("keyup compositionstart", curry(handleBlockContainer, editor));
      };
      const isContentEditableFalse$4 = isContentEditableFalse$b;
      const moveToCeFalseHorizontally = (direction, editor, range2) => moveHorizontally(editor, direction, range2, isBeforeContentEditableFalse, isAfterContentEditableFalse, isContentEditableFalse$4);
      const moveToCeFalseVertically = (direction, editor, range2) => {
        const isBefore = (caretPosition) => isBeforeContentEditableFalse(caretPosition) || isBeforeTable(caretPosition);
        const isAfter = (caretPosition) => isAfterContentEditableFalse(caretPosition) || isAfterTable(caretPosition);
        return moveVertically(editor, direction, range2, isBefore, isAfter, isContentEditableFalse$4);
      };
      const createTextBlock = (editor) => {
        const textBlock = editor.dom.create(getForcedRootBlock(editor));
        textBlock.innerHTML = '<br data-mce-bogus="1">';
        return textBlock;
      };
      const exitPreBlock = (editor, direction, range2) => {
        const caretWalker = CaretWalker(editor.getBody());
        const getVisualCaretPosition$1 = curry(getVisualCaretPosition, direction === 1 ? caretWalker.next : caretWalker.prev);
        if (range2.collapsed) {
          const pre = editor.dom.getParent(range2.startContainer, "PRE");
          if (!pre) {
            return;
          }
          const caretPos = getVisualCaretPosition$1(CaretPosition.fromRangeStart(range2));
          if (!caretPos) {
            const newBlock = SugarElement.fromDom(createTextBlock(editor));
            if (direction === 1) {
              after$4(SugarElement.fromDom(pre), newBlock);
            } else {
              before$3(SugarElement.fromDom(pre), newBlock);
            }
            editor.selection.select(newBlock.dom, true);
            editor.selection.collapse();
          }
        }
      };
      const getHorizontalRange = (editor, forward) => {
        const direction = forward ? 1 : -1;
        const range2 = editor.selection.getRng();
        return moveToCeFalseHorizontally(direction, editor, range2).orThunk(() => {
          exitPreBlock(editor, direction, range2);
          return Optional.none();
        });
      };
      const getVerticalRange = (editor, down) => {
        const direction = down ? 1 : -1;
        const range2 = editor.selection.getRng();
        return moveToCeFalseVertically(direction, editor, range2).orThunk(() => {
          exitPreBlock(editor, direction, range2);
          return Optional.none();
        });
      };
      const flipDirection = (selection, forward) => {
        const elm = forward ? selection.getEnd(true) : selection.getStart(true);
        return isRtl(elm) ? !forward : forward;
      };
      const moveH$2 = (editor, forward) => getHorizontalRange(editor, flipDirection(editor.selection, forward)).exists((newRange) => {
        moveToRange(editor, newRange);
        return true;
      });
      const moveV$4 = (editor, down) => getVerticalRange(editor, down).exists((newRange) => {
        moveToRange(editor, newRange);
        return true;
      });
      const moveToLineEndPoint$1 = (editor, forward) => {
        const isCefPosition = forward ? isAfterContentEditableFalse : isBeforeContentEditableFalse;
        return moveToLineEndPoint$3(editor, forward, isCefPosition);
      };
      const selectToEndPoint = (editor, forward) => getEdgeCefPosition(editor, !forward).map((pos) => {
        const rng = pos.toRange();
        const curRng = editor.selection.getRng();
        if (forward) {
          rng.setStart(curRng.startContainer, curRng.startOffset);
        } else {
          rng.setEnd(curRng.endContainer, curRng.endOffset);
        }
        return rng;
      }).exists((rng) => {
        moveToRange(editor, rng);
        return true;
      });
      const isTarget = (node) => contains$2(["figcaption"], name(node));
      const getClosestTargetBlock = (pos, root, schema) => {
        const isRoot2 = curry(eq, root);
        return closest$4(SugarElement.fromDom(pos.container()), (el) => schema.isBlock(name(el)), isRoot2).filter(isTarget);
      };
      const isAtFirstOrLastLine = (root, forward, pos) => forward ? isAtLastLine(root.dom, pos) : isAtFirstLine(root.dom, pos);
      const moveCaretToNewEmptyLine = (editor, forward) => {
        const root = SugarElement.fromDom(editor.getBody());
        const pos = CaretPosition.fromRangeStart(editor.selection.getRng());
        return getClosestTargetBlock(pos, root, editor.schema).exists(() => {
          if (isAtFirstOrLastLine(root, forward, pos)) {
            const insertFn = forward ? append$1 : prepend;
            const rng = insertEmptyLine(editor, root, insertFn);
            editor.selection.setRng(rng);
            return true;
          } else {
            return false;
          }
        });
      };
      const moveV$3 = (editor, forward) => {
        if (editor.selection.isCollapsed()) {
          return moveCaretToNewEmptyLine(editor, forward);
        } else {
          return false;
        }
      };
      const moveUp = (editor, details, summary) => {
        const rng = editor.selection.getRng();
        const pos = CaretPosition.fromRangeStart(rng);
        const root = editor.getBody();
        if (root.firstChild === details && isAtFirstLine(summary, pos)) {
          editor.execCommand("InsertNewBlockBefore");
          return true;
        } else {
          return false;
        }
      };
      const moveDown = (editor, details) => {
        const rng = editor.selection.getRng();
        const pos = CaretPosition.fromRangeStart(rng);
        const root = editor.getBody();
        if (root.lastChild === details && isAtLastLine(details, pos)) {
          editor.execCommand("InsertNewBlockAfter");
          return true;
        } else {
          return false;
        }
      };
      const move$2 = (editor, forward) => {
        if (forward) {
          return Optional.from(editor.dom.getParent(editor.selection.getNode(), "details")).map((details) => moveDown(editor, details)).getOr(false);
        } else {
          return Optional.from(editor.dom.getParent(editor.selection.getNode(), "summary")).bind((summary) => Optional.from(editor.dom.getParent(summary, "details")).map((details) => moveUp(editor, details, summary))).getOr(false);
        }
      };
      const moveV$2 = (editor, forward) => move$2(editor, forward);
      const baseKeyPattern = {
        shiftKey: false,
        altKey: false,
        ctrlKey: false,
        metaKey: false,
        keyCode: 0
      };
      const defaultPatterns = (patterns) => map$3(patterns, (pattern) => ({
        ...baseKeyPattern,
        ...pattern
      }));
      const defaultDelayedPatterns = (patterns) => map$3(patterns, (pattern) => ({
        ...baseKeyPattern,
        ...pattern
      }));
      const matchesEvent = (pattern, evt) => evt.keyCode === pattern.keyCode && evt.shiftKey === pattern.shiftKey && evt.altKey === pattern.altKey && evt.ctrlKey === pattern.ctrlKey && evt.metaKey === pattern.metaKey;
      const match$1 = (patterns, evt) => bind$3(defaultPatterns(patterns), (pattern) => matchesEvent(pattern, evt) ? [pattern] : []);
      const matchDelayed = (patterns, evt) => bind$3(defaultDelayedPatterns(patterns), (pattern) => matchesEvent(pattern, evt) ? [pattern] : []);
      const action = (f, ...x) => () => f.apply(null, x);
      const execute = (patterns, evt) => find$2(match$1(patterns, evt), (pattern) => pattern.action());
      const executeWithDelayedAction = (patterns, evt) => findMap(matchDelayed(patterns, evt), (pattern) => pattern.action());
      const moveH$1 = (editor, forward) => {
        const direction = forward ? 1 : -1;
        const range2 = editor.selection.getRng();
        return moveHorizontally(editor, direction, range2, isBeforeMedia, isAfterMedia, isMedia$2).exists((newRange) => {
          moveToRange(editor, newRange);
          return true;
        });
      };
      const moveV$1 = (editor, down) => {
        const direction = down ? 1 : -1;
        const range2 = editor.selection.getRng();
        return moveVertically(editor, direction, range2, isBeforeMedia, isAfterMedia, isMedia$2).exists((newRange) => {
          moveToRange(editor, newRange);
          return true;
        });
      };
      const moveToLineEndPoint = (editor, forward) => {
        const isNearMedia = forward ? isAfterMedia : isBeforeMedia;
        return moveToLineEndPoint$3(editor, forward, isNearMedia);
      };
      const adt = Adt.generate([
        { none: ["current"] },
        { first: ["current"] },
        {
          middle: [
            "current",
            "target"
          ]
        },
        { last: ["current"] }
      ]);
      const none = (current) => adt.none(current);
      const CellLocation = {
        ...adt,
        none
      };
      const firstLayer = (scope, selector) => {
        return filterFirstLayer(scope, selector, always);
      };
      const filterFirstLayer = (scope, selector, predicate) => {
        return bind$3(children$1(scope), (x) => {
          if (is$1(x, selector)) {
            return predicate(x) ? [x] : [];
          } else {
            return filterFirstLayer(x, selector, predicate);
          }
        });
      };
      const lookup$1 = (tags, element, isRoot2 = never) => {
        if (isRoot2(element)) {
          return Optional.none();
        }
        if (contains$2(tags, name(element))) {
          return Optional.some(element);
        }
        const isRootOrUpperTable = (elm) => is$1(elm, "table") || isRoot2(elm);
        return ancestor$3(element, tags.join(","), isRootOrUpperTable);
      };
      const cell = (element, isRoot2) => lookup$1([
        "td",
        "th"
      ], element, isRoot2);
      const cells = (ancestor2) => firstLayer(ancestor2, "th,td");
      const table = (element, isRoot2) => closest$3(element, "table", isRoot2);
      const walk = (all2, current, index, direction, isEligible = always) => {
        const forwards = direction === 1;
        if (!forwards && index <= 0) {
          return CellLocation.first(all2[0]);
        } else if (forwards && index >= all2.length - 1) {
          return CellLocation.last(all2[all2.length - 1]);
        } else {
          const newIndex = index + direction;
          const elem = all2[newIndex];
          return isEligible(elem) ? CellLocation.middle(current, elem) : walk(all2, current, newIndex, direction, isEligible);
        }
      };
      const detect = (current, isRoot2) => {
        return table(current, isRoot2).bind((table2) => {
          const all2 = cells(table2);
          const index = findIndex$2(all2, (x) => eq(current, x));
          return index.map((index2) => ({
            index: index2,
            all: all2
          }));
        });
      };
      const next = (current, isEligible, isRoot2) => {
        const detection = detect(current, isRoot2);
        return detection.fold(() => {
          return CellLocation.none(current);
        }, (info) => {
          return walk(info.all, current, info.index, 1, isEligible);
        });
      };
      const prev = (current, isEligible, isRoot2) => {
        const detection = detect(current, isRoot2);
        return detection.fold(() => {
          return CellLocation.none();
        }, (info) => {
          return walk(info.all, current, info.index, -1, isEligible);
        });
      };
      const isTextNodeWithCursorPosition = (el) => getOption(el).filter((text2) => text2.trim().length !== 0 || text2.indexOf(nbsp) > -1).isSome();
      const isContentEditableFalse$3 = (elem) => isHTMLElement$1(elem) && get$9(elem, "contenteditable") === "false";
      const elementsWithCursorPosition = [
        "img",
        "br"
      ];
      const isCursorPosition = (elem) => {
        const hasCursorPosition = isTextNodeWithCursorPosition(elem);
        return hasCursorPosition || contains$2(elementsWithCursorPosition, name(elem)) || isContentEditableFalse$3(elem);
      };
      const first = (element) => descendant$2(element, isCursorPosition);
      const deflate = (rect, delta) => ({
        left: rect.left - delta,
        top: rect.top - delta,
        right: rect.right + delta * 2,
        bottom: rect.bottom + delta * 2,
        width: rect.width + delta,
        height: rect.height + delta
      });
      const getCorners = (getYAxisValue, tds) => bind$3(tds, (td) => {
        const rect = deflate(clone$1(td.getBoundingClientRect()), -1);
        return [
          {
            x: rect.left,
            y: getYAxisValue(rect),
            cell: td
          },
          {
            x: rect.right,
            y: getYAxisValue(rect),
            cell: td
          }
        ];
      });
      const findClosestCorner = (corners, x, y) => foldl(corners, (acc, newCorner) => acc.fold(() => Optional.some(newCorner), (oldCorner) => {
        const oldDist = Math.sqrt(Math.abs(oldCorner.x - x) + Math.abs(oldCorner.y - y));
        const newDist = Math.sqrt(Math.abs(newCorner.x - x) + Math.abs(newCorner.y - y));
        return Optional.some(newDist < oldDist ? newCorner : oldCorner);
      }), Optional.none());
      const getClosestCell = (getYAxisValue, isTargetCorner, table2, x, y) => {
        const cells2 = descendants(SugarElement.fromDom(table2), "td,th,caption").map((e) => e.dom);
        const corners = filter$5(getCorners(getYAxisValue, cells2), (corner) => isTargetCorner(corner, y));
        return findClosestCorner(corners, x, y).map((corner) => corner.cell);
      };
      const getBottomValue = (rect) => rect.bottom;
      const getTopValue = (rect) => rect.top;
      const isAbove = (corner, y) => corner.y < y;
      const isBelow = (corner, y) => corner.y > y;
      const getClosestCellAbove = curry(getClosestCell, getBottomValue, isAbove);
      const getClosestCellBelow = curry(getClosestCell, getTopValue, isBelow);
      const findClosestPositionInAboveCell = (table2, pos) => head(pos.getClientRects()).bind((rect) => getClosestCellAbove(table2, rect.left, rect.top)).bind((cell2) => findClosestHorizontalPosition(getLastLinePositions(cell2), pos));
      const findClosestPositionInBelowCell = (table2, pos) => last$2(pos.getClientRects()).bind((rect) => getClosestCellBelow(table2, rect.left, rect.top)).bind((cell2) => findClosestHorizontalPosition(getFirstLinePositions(cell2), pos));
      const hasNextBreak = (getPositionsUntil2, scope, lineInfo) => lineInfo.breakAt.exists((breakPos) => getPositionsUntil2(scope, breakPos).breakAt.isSome());
      const startsWithWrapBreak = (lineInfo) => lineInfo.breakType === BreakType.Wrap && lineInfo.positions.length === 0;
      const startsWithBrBreak = (lineInfo) => lineInfo.breakType === BreakType.Br && lineInfo.positions.length === 1;
      const isAtTableCellLine = (getPositionsUntil2, scope, pos) => {
        const lineInfo = getPositionsUntil2(scope, pos);
        if (startsWithWrapBreak(lineInfo) || !isBr$6(pos.getNode()) && startsWithBrBreak(lineInfo)) {
          return !hasNextBreak(getPositionsUntil2, scope, lineInfo);
        } else {
          return lineInfo.breakAt.isNone();
        }
      };
      const isAtFirstTableCellLine = curry(isAtTableCellLine, getPositionsUntilPreviousLine);
      const isAtLastTableCellLine = curry(isAtTableCellLine, getPositionsUntilNextLine);
      const isCaretAtStartOrEndOfTable = (forward, rng, table2) => {
        const caretPos = CaretPosition.fromRangeStart(rng);
        return positionIn(!forward, table2).exists((pos) => pos.isEqual(caretPos));
      };
      const navigateHorizontally = (editor, forward, table2, _td) => {
        const rng = editor.selection.getRng();
        const direction = forward ? 1 : -1;
        if (isFakeCaretTableBrowser() && isCaretAtStartOrEndOfTable(forward, rng, table2)) {
          showCaret(direction, editor, table2, !forward, false).each((newRng) => {
            moveToRange(editor, newRng);
          });
          return true;
        }
        return false;
      };
      const getClosestAbovePosition = (root, table2, start2) => findClosestPositionInAboveCell(table2, start2).orThunk(() => head(start2.getClientRects()).bind((rect) => findClosestHorizontalPositionFromPoint(getPositionsAbove(root, CaretPosition.before(table2)), rect.left))).getOr(CaretPosition.before(table2));
      const getClosestBelowPosition = (root, table2, start2) => findClosestPositionInBelowCell(table2, start2).orThunk(() => head(start2.getClientRects()).bind((rect) => findClosestHorizontalPositionFromPoint(getPositionsBelow(root, CaretPosition.after(table2)), rect.left))).getOr(CaretPosition.after(table2));
      const getTable = (previous, pos) => {
        const node = pos.getNode(previous);
        return isTable$2(node) ? Optional.some(node) : Optional.none();
      };
      const renderBlock = (down, editor, table2) => {
        editor.undoManager.transact(() => {
          const insertFn = down ? after$4 : before$3;
          const rng = insertEmptyLine(editor, SugarElement.fromDom(table2), insertFn);
          moveToRange(editor, rng);
        });
      };
      const moveCaret = (editor, down, pos) => {
        const table2 = down ? getTable(true, pos) : getTable(false, pos);
        const last2 = down === false;
        table2.fold(() => moveToRange(editor, pos.toRange()), (table3) => positionIn(last2, editor.getBody()).filter((lastPos) => lastPos.isEqual(pos)).fold(() => moveToRange(editor, pos.toRange()), (_) => renderBlock(down, editor, table3)));
      };
      const navigateVertically = (editor, down, table2, td) => {
        const rng = editor.selection.getRng();
        const pos = CaretPosition.fromRangeStart(rng);
        const root = editor.getBody();
        if (!down && isAtFirstTableCellLine(td, pos)) {
          const newPos = getClosestAbovePosition(root, table2, pos);
          moveCaret(editor, down, newPos);
          return true;
        } else if (down && isAtLastTableCellLine(td, pos)) {
          const newPos = getClosestBelowPosition(root, table2, pos);
          moveCaret(editor, down, newPos);
          return true;
        } else {
          return false;
        }
      };
      const move$1 = (editor, forward, mover) => Optional.from(editor.dom.getParent(editor.selection.getNode(), "td,th")).bind((td) => Optional.from(editor.dom.getParent(td, "table")).map((table2) => mover(editor, forward, table2, td))).getOr(false);
      const moveH = (editor, forward) => move$1(editor, forward, navigateHorizontally);
      const moveV = (editor, forward) => move$1(editor, forward, navigateVertically);
      const getCellFirstCursorPosition = (cell2) => {
        const selection = SimSelection.exact(cell2, 0, cell2, 0);
        return toNative(selection);
      };
      const tabGo = (editor, isRoot2, cell2) => {
        return cell2.fold(Optional.none, Optional.none, (_current, next2) => {
          return first(next2).map((cell3) => {
            return getCellFirstCursorPosition(cell3);
          });
        }, (current) => {
          if (editor.mode.isReadOnly() || !isCellInEditableTable(current)) {
            return Optional.none();
          }
          editor.execCommand("mceTableInsertRowAfter");
          return tabForward(editor, isRoot2, current);
        });
      };
      const isCellInEditableTable = (cell2) => closest$4(cell2, isTag("table")).exists(isEditable$2);
      const tabForward = (editor, isRoot2, cell2) => tabGo(editor, isRoot2, next(cell2, isCellEditable));
      const tabBackward = (editor, isRoot2, cell2) => tabGo(editor, isRoot2, prev(cell2, isCellEditable));
      const isCellEditable = (cell2) => isEditable$2(cell2) || descendant(cell2, isEditableHTMLElement);
      const isEditableHTMLElement = (node) => isHTMLElement$1(node) && isEditable$2(node);
      const handleTab = (editor, forward) => {
        const rootElements = [
          "table",
          "li",
          "dl"
        ];
        const body = SugarElement.fromDom(editor.getBody());
        const isRoot2 = (element) => {
          const name$1 = name(element);
          return eq(element, body) || contains$2(rootElements, name$1);
        };
        const rng = editor.selection.getRng();
        const container = SugarElement.fromDom(!forward ? rng.startContainer : rng.endContainer);
        return cell(container, isRoot2).map((cell2) => {
          table(cell2, isRoot2).each((table2) => {
            editor.model.table.clearSelectedCells(table2.dom);
          });
          editor.selection.collapse(!forward);
          const navigation = !forward ? tabBackward : tabForward;
          const rng2 = navigation(editor, isRoot2, cell2);
          rng2.each((range2) => {
            editor.selection.setRng(range2);
          });
          return true;
        }).getOr(false);
      };
      const executeKeydownOverride$4 = (editor, caret, evt) => {
        const isMac = Env.os.isMacOS() || Env.os.isiOS();
        execute([
          {
            keyCode: VK.RIGHT,
            action: action(moveH$2, editor, true)
          },
          {
            keyCode: VK.LEFT,
            action: action(moveH$2, editor, false)
          },
          {
            keyCode: VK.UP,
            action: action(moveV$4, editor, false)
          },
          {
            keyCode: VK.DOWN,
            action: action(moveV$4, editor, true)
          },
          ...isMac ? [
            {
              keyCode: VK.UP,
              action: action(selectToEndPoint, editor, false),
              metaKey: true,
              shiftKey: true
            },
            {
              keyCode: VK.DOWN,
              action: action(selectToEndPoint, editor, true),
              metaKey: true,
              shiftKey: true
            }
          ] : [],
          {
            keyCode: VK.RIGHT,
            action: action(moveH, editor, true)
          },
          {
            keyCode: VK.LEFT,
            action: action(moveH, editor, false)
          },
          {
            keyCode: VK.UP,
            action: action(moveV, editor, false)
          },
          {
            keyCode: VK.DOWN,
            action: action(moveV, editor, true)
          },
          {
            keyCode: VK.UP,
            action: action(moveV, editor, false)
          },
          {
            keyCode: VK.UP,
            action: action(moveV$2, editor, false)
          },
          {
            keyCode: VK.DOWN,
            action: action(moveV$2, editor, true)
          },
          {
            keyCode: VK.RIGHT,
            action: action(moveH$1, editor, true)
          },
          {
            keyCode: VK.LEFT,
            action: action(moveH$1, editor, false)
          },
          {
            keyCode: VK.UP,
            action: action(moveV$1, editor, false)
          },
          {
            keyCode: VK.DOWN,
            action: action(moveV$1, editor, true)
          },
          {
            keyCode: VK.RIGHT,
            action: action(move$3, editor, caret, true)
          },
          {
            keyCode: VK.LEFT,
            action: action(move$3, editor, caret, false)
          },
          {
            keyCode: VK.RIGHT,
            ctrlKey: !isMac,
            altKey: isMac,
            action: action(moveNextWord, editor, caret)
          },
          {
            keyCode: VK.LEFT,
            ctrlKey: !isMac,
            altKey: isMac,
            action: action(movePrevWord, editor, caret)
          },
          {
            keyCode: VK.UP,
            action: action(moveV$3, editor, false)
          },
          {
            keyCode: VK.DOWN,
            action: action(moveV$3, editor, true)
          }
        ], evt).each((_) => {
          evt.preventDefault();
        });
      };
      const setup$l = (editor, caret) => {
        editor.on("keydown", (evt) => {
          if (!evt.isDefaultPrevented()) {
            executeKeydownOverride$4(editor, caret, evt);
          }
        });
      };
      const point = (container, offset) => ({
        container,
        offset
      });
      const DOM$7 = DOMUtils.DOM;
      const alwaysNext = (startNode) => (node) => startNode === node ? -1 : 0;
      const isBoundary = (dom2) => (node) => dom2.isBlock(node) || contains$2([
        "BR",
        "IMG",
        "HR",
        "INPUT"
      ], node.nodeName) || dom2.getContentEditable(node) === "false";
      const textBefore = (node, offset, rootNode) => {
        if (isText$b(node) && offset >= 0) {
          return Optional.some(point(node, offset));
        } else {
          const textSeeker = TextSeeker(DOM$7);
          return Optional.from(textSeeker.backwards(node, offset, alwaysNext(node), rootNode)).map((prev2) => point(prev2.container, prev2.container.data.length));
        }
      };
      const textAfter = (node, offset, rootNode) => {
        if (isText$b(node) && offset >= node.length) {
          return Optional.some(point(node, offset));
        } else {
          const textSeeker = TextSeeker(DOM$7);
          return Optional.from(textSeeker.forwards(node, offset, alwaysNext(node), rootNode)).map((prev2) => point(prev2.container, 0));
        }
      };
      const scanLeft = (node, offset, rootNode) => {
        if (!isText$b(node)) {
          return Optional.none();
        }
        const text2 = node.data;
        if (offset >= 0 && offset <= text2.length) {
          return Optional.some(point(node, offset));
        } else {
          const textSeeker = TextSeeker(DOM$7);
          return Optional.from(textSeeker.backwards(node, offset, alwaysNext(node), rootNode)).bind((prev2) => {
            const prevText = prev2.container.data;
            return scanLeft(prev2.container, offset + prevText.length, rootNode);
          });
        }
      };
      const scanRight = (node, offset, rootNode) => {
        if (!isText$b(node)) {
          return Optional.none();
        }
        const text2 = node.data;
        if (offset <= text2.length) {
          return Optional.some(point(node, offset));
        } else {
          const textSeeker = TextSeeker(DOM$7);
          return Optional.from(textSeeker.forwards(node, offset, alwaysNext(node), rootNode)).bind((next2) => scanRight(next2.container, offset - text2.length, rootNode));
        }
      };
      const repeatLeft = (dom2, node, offset, process2, rootNode) => {
        const search2 = TextSeeker(dom2, isBoundary(dom2));
        return Optional.from(search2.backwards(node, offset, process2, rootNode));
      };
      const isValidTextRange = (rng) => rng.collapsed && isText$b(rng.startContainer);
      const getText = (rng) => trim$2(rng.toString().replace(/\u00A0/g, " "));
      const isWhitespace = (chr) => chr !== "" && "  \uFEFF\f\n\r	\v".indexOf(chr) !== -1;
      const stripTrigger = (text2, trigger) => text2.substring(trigger.length);
      const findTrigger = (text2, index, trigger, includeWhitespace = false) => {
        let i;
        const firstChar = trigger.charAt(0);
        for (i = index - 1; i >= 0; i--) {
          const char = text2.charAt(i);
          if (!includeWhitespace && isWhitespace(char)) {
            return Optional.none();
          }
          if (firstChar === char && contains$1(text2, trigger, i, index)) {
            break;
          }
        }
        return Optional.some(i);
      };
      const getContext = (dom2, initRange, trigger, includeWhitespace = false) => {
        if (!isValidTextRange(initRange)) {
          return Optional.none();
        }
        const buffer = {
          text: "",
          offset: 0
        };
        const findTriggerIndex = (element, offset, text2) => {
          buffer.text = text2 + buffer.text;
          buffer.offset += offset;
          return findTrigger(buffer.text, buffer.offset, trigger, includeWhitespace).getOr(offset);
        };
        const root = dom2.getParent(initRange.startContainer, dom2.isBlock) || dom2.getRoot();
        return repeatLeft(dom2, initRange.startContainer, initRange.startOffset, findTriggerIndex, root).bind((spot) => {
          const range2 = initRange.cloneRange();
          range2.setStart(spot.container, spot.offset);
          range2.setEnd(initRange.endContainer, initRange.endOffset);
          if (range2.collapsed) {
            return Optional.none();
          }
          const text2 = getText(range2);
          const triggerIndex = text2.lastIndexOf(trigger);
          if (triggerIndex !== 0) {
            return Optional.none();
          } else {
            return Optional.some({
              text: stripTrigger(text2, trigger),
              range: range2,
              trigger
            });
          }
        });
      };
      const isText$1 = (node) => node.nodeType === TEXT;
      const isElement = (node) => node.nodeType === ELEMENT;
      const toLast = (node) => {
        if (isText$1(node)) {
          return point(node, node.data.length);
        } else {
          const children2 = node.childNodes;
          return children2.length > 0 ? toLast(children2[children2.length - 1]) : point(node, children2.length);
        }
      };
      const toLeaf = (node, offset) => {
        const children2 = node.childNodes;
        if (children2.length > 0 && offset < children2.length) {
          return toLeaf(children2[offset], 0);
        } else if (children2.length > 0 && isElement(node) && children2.length === offset) {
          return toLast(children2[children2.length - 1]);
        } else {
          return point(node, offset);
        }
      };
      const isPreviousCharContent = (dom2, leaf) => {
        var _a;
        const root = (_a = dom2.getParent(leaf.container, dom2.isBlock)) !== null && _a !== void 0 ? _a : dom2.getRoot();
        return repeatLeft(dom2, leaf.container, leaf.offset, (_element, offset) => offset === 0 ? -1 : offset, root).filter((spot) => {
          const char = spot.container.data.charAt(spot.offset - 1);
          return !isWhitespace(char);
        }).isSome();
      };
      const isStartOfWord = (dom2) => (rng) => {
        const leaf = toLeaf(rng.startContainer, rng.startOffset);
        return !isPreviousCharContent(dom2, leaf);
      };
      const getTriggerContext = (dom2, initRange, database) => findMap(database.triggers, (trigger) => getContext(dom2, initRange, trigger));
      const lookup = (editor, getDatabase) => {
        const database = getDatabase();
        const rng = editor.selection.getRng();
        return getTriggerContext(editor.dom, rng, database).bind((context2) => lookupWithContext(editor, getDatabase, context2));
      };
      const lookupWithContext = (editor, getDatabase, context2, fetchOptions = {}) => {
        var _a;
        const database = getDatabase();
        const rng = editor.selection.getRng();
        const startText = (_a = rng.startContainer.nodeValue) !== null && _a !== void 0 ? _a : "";
        const autocompleters = filter$5(database.lookupByTrigger(context2.trigger), (autocompleter) => context2.text.length >= autocompleter.minChars && autocompleter.matches.getOrThunk(() => isStartOfWord(editor.dom))(context2.range, startText, context2.text));
        if (autocompleters.length === 0) {
          return Optional.none();
        }
        const lookupData = Promise.all(map$3(autocompleters, (ac) => {
          const fetchResult = ac.fetch(context2.text, ac.maxResults, fetchOptions);
          return fetchResult.then((results) => ({
            matchText: context2.text,
            items: results,
            columns: ac.columns,
            onAction: ac.onAction,
            highlightOn: ac.highlightOn
          }));
        }));
        return Optional.some({
          lookupData,
          context: context2
        });
      };
      var SimpleResultType;
      (function(SimpleResultType2) {
        SimpleResultType2[SimpleResultType2["Error"] = 0] = "Error";
        SimpleResultType2[SimpleResultType2["Value"] = 1] = "Value";
      })(SimpleResultType || (SimpleResultType = {}));
      const fold$1 = (res, onError, onValue) => res.stype === SimpleResultType.Error ? onError(res.serror) : onValue(res.svalue);
      const partition = (results) => {
        const values2 = [];
        const errors = [];
        each$e(results, (obj) => {
          fold$1(obj, (err) => errors.push(err), (val) => values2.push(val));
        });
        return {
          values: values2,
          errors
        };
      };
      const mapError = (res, f) => {
        if (res.stype === SimpleResultType.Error) {
          return {
            stype: SimpleResultType.Error,
            serror: f(res.serror)
          };
        } else {
          return res;
        }
      };
      const map = (res, f) => {
        if (res.stype === SimpleResultType.Value) {
          return {
            stype: SimpleResultType.Value,
            svalue: f(res.svalue)
          };
        } else {
          return res;
        }
      };
      const bind$1 = (res, f) => {
        if (res.stype === SimpleResultType.Value) {
          return f(res.svalue);
        } else {
          return res;
        }
      };
      const bindError = (res, f) => {
        if (res.stype === SimpleResultType.Error) {
          return f(res.serror);
        } else {
          return res;
        }
      };
      const svalue = (v) => ({
        stype: SimpleResultType.Value,
        svalue: v
      });
      const serror = (e) => ({
        stype: SimpleResultType.Error,
        serror: e
      });
      const toResult = (res) => fold$1(res, Result.error, Result.value);
      const fromResult = (res) => res.fold(serror, svalue);
      const SimpleResult = {
        fromResult,
        toResult,
        svalue,
        partition,
        serror,
        bind: bind$1,
        bindError,
        map,
        mapError,
        fold: fold$1
      };
      const formatObj = (input) => {
        return isObject(input) && keys(input).length > 100 ? " removed due to size" : JSON.stringify(input, null, 2);
      };
      const formatErrors = (errors) => {
        const es = errors.length > 10 ? errors.slice(0, 10).concat([{
          path: [],
          getErrorInfo: constant("... (only showing first ten failures)")
        }]) : errors;
        return map$3(es, (e) => {
          return "Failed path: (" + e.path.join(" > ") + ")\n" + e.getErrorInfo();
        });
      };
      const nu = (path2, getErrorInfo) => {
        return SimpleResult.serror([{
          path: path2,
          getErrorInfo
        }]);
      };
      const missingRequired = (path2, key, obj) => nu(path2, () => 'Could not find valid *required* value for "' + key + '" in ' + formatObj(obj));
      const missingKey = (path2, key) => nu(path2, () => 'Choice schema did not contain choice key: "' + key + '"');
      const missingBranch = (path2, branches, branch) => nu(path2, () => 'The chosen schema: "' + branch + '" did not exist in branches: ' + formatObj(branches));
      const custom = (path2, err) => nu(path2, constant(err));
      const chooseFrom = (path2, input, branches, ch) => {
        const fields = get$a(branches, ch);
        return fields.fold(() => missingBranch(path2, branches, ch), (vp) => vp.extract(path2.concat(["branch: " + ch]), input));
      };
      const choose$1 = (key, branches) => {
        const extract = (path2, input) => {
          const choice = get$a(input, key);
          return choice.fold(() => missingKey(path2, key), (chosen) => chooseFrom(path2, input, branches, chosen));
        };
        const toString2 = () => "chooseOn(" + key + "). Possible values: " + keys(branches);
        return {
          extract,
          toString: toString2
        };
      };
      const shallow = (old, nu2) => {
        return nu2;
      };
      const deep = (old, nu2) => {
        const bothObjects = isPlainObject(old) && isPlainObject(nu2);
        return bothObjects ? deepMerge(old, nu2) : nu2;
      };
      const baseMerge = (merger) => {
        return (...objects) => {
          if (objects.length === 0) {
            throw new Error(`Can't merge zero objects`);
          }
          const ret = {};
          for (let j = 0; j < objects.length; j++) {
            const curObject = objects[j];
            for (const key in curObject) {
              if (has$2(curObject, key)) {
                ret[key] = merger(ret[key], curObject[key]);
              }
            }
          }
          return ret;
        };
      };
      const deepMerge = baseMerge(deep);
      const merge = baseMerge(shallow);
      const required = () => ({
        tag: "required",
        process: {}
      });
      const defaultedThunk = (fallbackThunk) => ({
        tag: "defaultedThunk",
        process: fallbackThunk
      });
      const defaulted$1 = (fallback2) => defaultedThunk(constant(fallback2));
      const asOption = () => ({
        tag: "option",
        process: {}
      });
      const mergeValues = (values2, base) => values2.length > 0 ? SimpleResult.svalue(deepMerge(base, merge.apply(void 0, values2))) : SimpleResult.svalue(base);
      const mergeErrors = (errors) => compose(SimpleResult.serror, flatten)(errors);
      const consolidateObj = (objects, base) => {
        const partition2 = SimpleResult.partition(objects);
        return partition2.errors.length > 0 ? mergeErrors(partition2.errors) : mergeValues(partition2.values, base);
      };
      const consolidateArr = (objects) => {
        const partitions = SimpleResult.partition(objects);
        return partitions.errors.length > 0 ? mergeErrors(partitions.errors) : SimpleResult.svalue(partitions.values);
      };
      const ResultCombine = {
        consolidateObj,
        consolidateArr
      };
      const field$1 = (key, newKey, presence, prop) => ({
        tag: "field",
        key,
        newKey,
        presence,
        prop
      });
      const customField$1 = (newKey, instantiator) => ({
        tag: "custom",
        newKey,
        instantiator
      });
      const fold = (value2, ifField, ifCustom) => {
        switch (value2.tag) {
          case "field":
            return ifField(value2.key, value2.newKey, value2.presence, value2.prop);
          case "custom":
            return ifCustom(value2.newKey, value2.instantiator);
        }
      };
      const value = (validator) => {
        const extract = (path2, val) => {
          return SimpleResult.bindError(validator(val), (err) => custom(path2, err));
        };
        const toString2 = constant("val");
        return {
          extract,
          toString: toString2
        };
      };
      const anyValue$1 = value(SimpleResult.svalue);
      const requiredAccess = (path2, obj, key, bundle) => get$a(obj, key).fold(() => missingRequired(path2, key, obj), bundle);
      const fallbackAccess = (obj, key, fallback2, bundle) => {
        const v = get$a(obj, key).getOrThunk(() => fallback2(obj));
        return bundle(v);
      };
      const optionAccess = (obj, key, bundle) => bundle(get$a(obj, key));
      const optionDefaultedAccess = (obj, key, fallback2, bundle) => {
        const opt = get$a(obj, key).map((val) => val === true ? fallback2(obj) : val);
        return bundle(opt);
      };
      const extractField = (field2, path2, obj, key, prop) => {
        const bundle = (av) => prop.extract(path2.concat([key]), av);
        const bundleAsOption = (optValue) => optValue.fold(() => SimpleResult.svalue(Optional.none()), (ov) => {
          const result = prop.extract(path2.concat([key]), ov);
          return SimpleResult.map(result, Optional.some);
        });
        switch (field2.tag) {
          case "required":
            return requiredAccess(path2, obj, key, bundle);
          case "defaultedThunk":
            return fallbackAccess(obj, key, field2.process, bundle);
          case "option":
            return optionAccess(obj, key, bundleAsOption);
          case "defaultedOptionThunk":
            return optionDefaultedAccess(obj, key, field2.process, bundleAsOption);
          case "mergeWithThunk": {
            return fallbackAccess(obj, key, constant({}), (v) => {
              const result = deepMerge(field2.process(obj), v);
              return bundle(result);
            });
          }
        }
      };
      const extractFields = (path2, obj, fields) => {
        const success = {};
        const errors = [];
        for (const field2 of fields) {
          fold(field2, (key, newKey, presence, prop) => {
            const result = extractField(presence, path2, obj, key, prop);
            SimpleResult.fold(result, (err) => {
              errors.push(...err);
            }, (res) => {
              success[newKey] = res;
            });
          }, (newKey, instantiator) => {
            success[newKey] = instantiator(obj);
          });
        }
        return errors.length > 0 ? SimpleResult.serror(errors) : SimpleResult.svalue(success);
      };
      const objOf = (values2) => {
        const extract = (path2, o) => extractFields(path2, o, values2);
        const toString2 = () => {
          const fieldStrings = map$3(values2, (value2) => fold(value2, (key, _okey, _presence, prop) => key + " -> " + prop.toString(), (newKey, _instantiator) => "state(" + newKey + ")"));
          return "obj{\n" + fieldStrings.join("\n") + "}";
        };
        return {
          extract,
          toString: toString2
        };
      };
      const arrOf = (prop) => {
        const extract = (path2, array) => {
          const results = map$3(array, (a, i) => prop.extract(path2.concat(["[" + i + "]"]), a));
          return ResultCombine.consolidateArr(results);
        };
        const toString2 = () => "array(" + prop.toString() + ")";
        return {
          extract,
          toString: toString2
        };
      };
      const oneOf = (props, rawF) => {
        const f = rawF !== void 0 ? rawF : identity;
        const extract = (path2, val) => {
          const errors = [];
          for (const prop of props) {
            const res = prop.extract(path2, val);
            if (res.stype === SimpleResultType.Value) {
              return {
                stype: SimpleResultType.Value,
                svalue: f(res.svalue)
              };
            }
            errors.push(res);
          }
          return ResultCombine.consolidateArr(errors);
        };
        const toString2 = () => "oneOf(" + map$3(props, (prop) => prop.toString()).join(", ") + ")";
        return {
          extract,
          toString: toString2
        };
      };
      const arrOfObj = compose(arrOf, objOf);
      const valueOf = (validator) => value((v) => validator(v).fold(SimpleResult.serror, SimpleResult.svalue));
      const extractValue = (label, prop, obj) => {
        const res = prop.extract([label], obj);
        return SimpleResult.mapError(res, (errs) => ({
          input: obj,
          errors: errs
        }));
      };
      const asRaw = (label, prop, obj) => SimpleResult.toResult(extractValue(label, prop, obj));
      const formatError = (errInfo) => {
        return "Errors: \n" + formatErrors(errInfo.errors).join("\n") + "\n\nInput object: " + formatObj(errInfo.input);
      };
      const choose = (key, branches) => choose$1(key, map$2(branches, objOf));
      const anyValue = constant(anyValue$1);
      const typedValue = (validator, expectedType) => value((a) => {
        const actualType = typeof a;
        return validator(a) ? SimpleResult.svalue(a) : SimpleResult.serror(`Expected type: ${expectedType} but got: ${actualType}`);
      });
      const number = typedValue(isNumber, "number");
      const string = typedValue(isString, "string");
      const boolean = typedValue(isBoolean, "boolean");
      const functionProcessor = typedValue(isFunction, "function");
      const field = field$1;
      const customField = customField$1;
      const validateEnum = (values2) => valueOf((value2) => contains$2(values2, value2) ? Result.value(value2) : Result.error(`Unsupported value: "${value2}", choose one of "${values2.join(", ")}".`));
      const requiredOf = (key, schema) => field(key, key, required(), schema);
      const requiredString = (key) => requiredOf(key, string);
      const requiredStringEnum = (key, values2) => field(key, key, required(), validateEnum(values2));
      const requiredFunction = (key) => requiredOf(key, functionProcessor);
      const requiredArrayOf = (key, schema) => field(key, key, required(), arrOf(schema));
      const optionOf = (key, schema) => field(key, key, asOption(), schema);
      const optionString = (key) => optionOf(key, string);
      const optionFunction = (key) => optionOf(key, functionProcessor);
      const optionObjOf = (key, objSchema) => optionOf(key, objOf(objSchema));
      const defaulted = (key, fallback2) => field(key, key, defaulted$1(fallback2), anyValue());
      const defaultedOf = (key, fallback2, schema) => field(key, key, defaulted$1(fallback2), schema);
      const defaultedNumber = (key, fallback2) => defaultedOf(key, fallback2, number);
      const defaultedString = (key, fallback2) => defaultedOf(key, fallback2, string);
      const defaultedStringEnum = (key, fallback2, values2) => defaultedOf(key, fallback2, validateEnum(values2));
      const defaultedBoolean = (key, fallback2) => defaultedOf(key, fallback2, boolean);
      const defaultedFunction = (key, fallback2) => defaultedOf(key, fallback2, functionProcessor);
      const defaultedArrayOf = (key, fallback2, schema) => defaultedOf(key, fallback2, arrOf(schema));
      const type = requiredString("type");
      const fetch$1 = requiredFunction("fetch");
      const onAction = requiredFunction("onAction");
      const onSetup = defaultedFunction("onSetup", () => noop);
      const optionalText = optionString("text");
      const optionalIcon = optionString("icon");
      const optionalTooltip = optionString("tooltip");
      const optionalLabel = optionString("label");
      const active = defaultedBoolean("active", false);
      const enabled = defaultedBoolean("enabled", true);
      const primary = defaultedBoolean("primary", false);
      const defaultedColumns = (num) => defaulted("columns", num);
      const defaultedType = (type2) => defaultedString("type", type2);
      const autocompleterSchema = objOf([
        type,
        requiredString("trigger"),
        defaultedNumber("minChars", 1),
        defaultedColumns(1),
        defaultedNumber("maxResults", 10),
        optionFunction("matches"),
        fetch$1,
        onAction,
        defaultedArrayOf("highlightOn", [], string)
      ]);
      const createAutocompleter = (spec) => asRaw("Autocompleter", autocompleterSchema, spec);
      const baseToolbarButtonFields = [
        enabled,
        optionalTooltip,
        optionalIcon,
        optionalText,
        onSetup,
        defaultedString("context", "mode:design")
      ];
      const baseToolbarToggleButtonFields = [active].concat(baseToolbarButtonFields);
      const contextBarFields = [
        defaultedFunction("predicate", never),
        defaultedStringEnum("scope", "node", [
          "node",
          "editor"
        ]),
        defaultedStringEnum("position", "selection", [
          "node",
          "selection",
          "line"
        ])
      ];
      const contextButtonFields = baseToolbarButtonFields.concat([
        defaultedType("contextformbutton"),
        defaultedString("align", "end"),
        primary,
        onAction,
        customField("original", identity)
      ]);
      const contextToggleButtonFields = baseToolbarToggleButtonFields.concat([
        defaultedType("contextformbutton"),
        defaultedString("align", "end"),
        primary,
        onAction,
        customField("original", identity)
      ]);
      const launchButtonFields$1 = baseToolbarButtonFields.concat([defaultedType("contextformbutton")]);
      const launchToggleButtonFields = baseToolbarToggleButtonFields.concat([defaultedType("contextformtogglebutton")]);
      const toggleOrNormal = choose("type", {
        contextformbutton: contextButtonFields,
        contextformtogglebutton: contextToggleButtonFields
      });
      const baseContextFormFields = [
        optionalLabel,
        requiredArrayOf("commands", toggleOrNormal),
        optionOf("launch", choose("type", {
          contextformbutton: launchButtonFields$1,
          contextformtogglebutton: launchToggleButtonFields
        })),
        defaultedFunction("onInput", noop),
        defaultedFunction("onSetup", noop)
      ];
      const contextFormFields = [
        ...contextBarFields,
        ...baseContextFormFields,
        requiredStringEnum("type", ["contextform"]),
        defaultedFunction("initValue", constant("")),
        optionString("placeholder")
      ];
      const contextSliderFormFields = [
        ...contextBarFields,
        ...baseContextFormFields,
        requiredStringEnum("type", ["contextsliderform"]),
        defaultedFunction("initValue", constant(0)),
        defaultedFunction("min", constant(0)),
        defaultedFunction("max", constant(100))
      ];
      const contextSizeInputFormFields = [
        ...contextBarFields,
        ...baseContextFormFields,
        requiredStringEnum("type", ["contextsizeinputform"]),
        defaultedFunction("initValue", constant({
          width: "",
          height: ""
        }))
      ];
      choose("type", {
        contextform: contextFormFields,
        contextsliderform: contextSliderFormFields,
        contextsizeinputform: contextSizeInputFormFields
      });
      const launchButtonFields = baseToolbarButtonFields.concat([defaultedType("contexttoolbarbutton")]);
      objOf([
        defaultedType("contexttoolbar"),
        optionObjOf("launch", launchButtonFields),
        requiredOf("items", oneOf([
          string,
          arrOfObj([
            optionString("name"),
            optionString("label"),
            requiredArrayOf("items", string)
          ])
        ]))
      ].concat(contextBarFields));
      const register$2 = (editor) => {
        const popups = editor.ui.registry.getAll().popups;
        const dataset = map$2(popups, (popup) => createAutocompleter(popup).fold((err) => {
          throw new Error(formatError(err));
        }, identity));
        const triggers = stringArray(mapToArray(dataset, (v) => v.trigger));
        const datasetValues = values(dataset);
        const lookupByTrigger = (trigger) => filter$5(datasetValues, (dv) => dv.trigger === trigger);
        return {
          dataset,
          triggers,
          lookupByTrigger
        };
      };
      const setupEditorInput = (editor, api2) => {
        const update = last(api2.load, 50);
        editor.on("input", (e) => {
          if (e.inputType === "insertCompositionText" && !editor.composing) {
            return;
          }
          update.throttle();
        });
        editor.on("keydown", (e) => {
          const keyCode = e.which;
          if (keyCode === 8) {
            update.throttle();
          } else if (keyCode === 27) {
            update.cancel();
            api2.cancelIfNecessary();
          } else if (keyCode === 38 || keyCode === 40) {
            update.cancel();
          }
        }, true);
        editor.on("remove", update.cancel);
      };
      const setup$k = (editor) => {
        const activeAutocompleter = value$2();
        const uiActive = Cell(false);
        const isActive = activeAutocompleter.isSet;
        const cancelIfNecessary = () => {
          if (isActive()) {
            fireAutocompleterEnd(editor);
            uiActive.set(false);
            activeAutocompleter.clear();
          }
        };
        const commenceIfNecessary = (context2) => {
          if (!isActive()) {
            activeAutocompleter.set({
              trigger: context2.trigger,
              matchLength: context2.text.length
            });
          }
        };
        const getAutocompleters = cached(() => register$2(editor));
        const doLookup = (fetchOptions) => activeAutocompleter.get().map((ac) => getContext(editor.dom, editor.selection.getRng(), ac.trigger, true).bind((newContext) => lookupWithContext(editor, getAutocompleters, newContext, fetchOptions))).getOrThunk(() => lookup(editor, getAutocompleters));
        const load = (fetchOptions) => {
          doLookup(fetchOptions).fold(cancelIfNecessary, (lookupInfo) => {
            commenceIfNecessary(lookupInfo.context);
            lookupInfo.lookupData.then((lookupData) => {
              activeAutocompleter.get().map((ac) => {
                const context2 = lookupInfo.context;
                if (ac.trigger !== context2.trigger) {
                  return;
                }
                activeAutocompleter.set({
                  ...ac,
                  matchLength: context2.text.length
                });
                if (uiActive.get()) {
                  fireAutocompleterUpdateActiveRange(editor, { range: context2.range });
                  fireAutocompleterUpdate(editor, { lookupData });
                } else {
                  uiActive.set(true);
                  fireAutocompleterUpdateActiveRange(editor, { range: context2.range });
                  fireAutocompleterStart(editor, { lookupData });
                }
              });
            });
          });
        };
        const isRangeInsideOrEqual = (innerRange, outerRange) => {
          const startComparison = innerRange.compareBoundaryPoints(window.Range.START_TO_START, outerRange);
          const endComparison = innerRange.compareBoundaryPoints(window.Range.END_TO_END, outerRange);
          return startComparison >= 0 && endComparison <= 0;
        };
        const readActiveRange = () => {
          return activeAutocompleter.get().bind(({ trigger }) => {
            const selRange = editor.selection.getRng();
            return getContext(editor.dom, selRange, trigger, uiActive.get()).filter(({ range: range2 }) => isRangeInsideOrEqual(selRange, range2)).map(({ range: range2 }) => range2);
          });
        };
        editor.addCommand("mceAutocompleterReload", (_ui, value2) => {
          const fetchOptions = isObject(value2) ? value2.fetchOptions : {};
          load(fetchOptions);
        });
        editor.addCommand("mceAutocompleterClose", cancelIfNecessary);
        editor.addCommand("mceAutocompleterRefreshActiveRange", () => {
          readActiveRange().each((range2) => {
            fireAutocompleterUpdateActiveRange(editor, { range: range2 });
          });
        });
        editor.editorCommands.addQueryStateHandler("mceAutoCompleterInRange", () => readActiveRange().isSome());
        setupEditorInput(editor, {
          cancelIfNecessary,
          load
        });
      };
      const browser$1 = detect$1().browser;
      const isSafari = browser$1.isSafari();
      const emptyNodeContents = (node) => fillWithPaddingBr(SugarElement.fromDom(node));
      const isEntireNodeSelected = (rng, node) => {
        var _a;
        return rng.startOffset === 0 && rng.endOffset === ((_a = node.textContent) === null || _a === void 0 ? void 0 : _a.length);
      };
      const getParentDetailsElementAtPos = (dom2, pos) => Optional.from(dom2.getParent(pos.container(), "details"));
      const isInDetailsElement = (dom2, pos) => getParentDetailsElementAtPos(dom2, pos).isSome();
      const getDetailsElements = (dom2, rng) => {
        const startDetails = Optional.from(dom2.getParent(rng.startContainer, "details"));
        const endDetails = Optional.from(dom2.getParent(rng.endContainer, "details"));
        if (startDetails.isSome() || endDetails.isSome()) {
          const startSummary = startDetails.bind((details) => Optional.from(dom2.select("summary", details)[0]));
          return Optional.some({
            startSummary,
            startDetails,
            endDetails
          });
        } else {
          return Optional.none();
        }
      };
      const isCaretInTheBeginningOf = (caretPos, element) => firstPositionIn(element).exists((pos) => pos.isEqual(caretPos));
      const isCaretInTheEndOf = (caretPos, element) => {
        return lastPositionIn(element).exists((pos) => {
          if (isBr$6(pos.getNode())) {
            return prevPosition(element, pos).exists((pos2) => pos2.isEqual(caretPos)) || pos.isEqual(caretPos);
          } else {
            return pos.isEqual(caretPos);
          }
        });
      };
      const isCaretAtStartOfSummary = (caretPos, detailsElements) => detailsElements.startSummary.exists((summary) => isCaretInTheBeginningOf(caretPos, summary));
      const isCaretAtEndOfSummary = (caretPos, detailsElements) => detailsElements.startSummary.exists((summary) => isCaretInTheEndOf(caretPos, summary));
      const isCaretInFirstPositionInBody = (caretPos, detailsElements) => detailsElements.startDetails.exists((details) => prevPosition(details, caretPos).forall((pos) => detailsElements.startSummary.exists((summary) => !summary.contains(caretPos.container()) && summary.contains(pos.container()))));
      const isCaretInLastPositionInBody = (root, caretPos, detailsElements) => detailsElements.startDetails.exists((details) => nextPosition(root, caretPos).forall((pos) => !details.contains(pos.container())));
      const setCaretToPosition = (editor, position) => {
        const node = position.getNode();
        if (!isUndefined(node)) {
          editor.selection.setCursorLocation(node, position.offset());
        }
      };
      const moveCaretToDetailsPos = (editor, pos, forward) => {
        const details = editor.dom.getParent(pos.container(), "details");
        if (details && !details.open) {
          const summary = editor.dom.select("summary", details)[0];
          if (summary) {
            const newPos = forward ? firstPositionIn(summary) : lastPositionIn(summary);
            newPos.each((pos2) => setCaretToPosition(editor, pos2));
          }
        } else {
          setCaretToPosition(editor, pos);
        }
      };
      const isPartialDelete = (rng, detailsElements) => {
        const containsStart = (element) => element.contains(rng.startContainer);
        const containsEnd = (element) => element.contains(rng.endContainer);
        const startInSummary = detailsElements.startSummary.exists(containsStart);
        const endInSummary = detailsElements.startSummary.exists(containsEnd);
        const isPartiallySelectedDetailsElements = detailsElements.startDetails.forall((startDetails) => detailsElements.endDetails.forall((endDetails) => startDetails !== endDetails));
        const isInPartiallySelectedSummary = (startInSummary || endInSummary) && !(startInSummary && endInSummary);
        return isInPartiallySelectedSummary || isPartiallySelectedDetailsElements;
      };
      const shouldPreventDeleteIntoDetails = (editor, forward, granularity) => {
        const { dom: dom2, selection } = editor;
        const root = editor.getBody();
        if (granularity === "character") {
          const caretPos = CaretPosition.fromRangeStart(selection.getRng());
          const parentBlock = dom2.getParent(caretPos.container(), dom2.isBlock);
          const parentDetailsAtCaret = getParentDetailsElementAtPos(dom2, caretPos);
          const inEmptyParentBlock = parentBlock && dom2.isEmpty(parentBlock);
          const isFirstBlock = isNull(parentBlock === null || parentBlock === void 0 ? void 0 : parentBlock.previousSibling);
          const isLastBlock = isNull(parentBlock === null || parentBlock === void 0 ? void 0 : parentBlock.nextSibling);
          if (inEmptyParentBlock) {
            const firstOrLast = forward ? isLastBlock : isFirstBlock;
            if (firstOrLast) {
              const isBeforeAfterDetails = navigate(!forward, root, caretPos).exists((pos) => {
                return isInDetailsElement(dom2, pos) && !equals(parentDetailsAtCaret, getParentDetailsElementAtPos(dom2, pos));
              });
              if (isBeforeAfterDetails) {
                return true;
              }
            }
          }
          return navigate(forward, root, caretPos).fold(never, (pos) => {
            const parentDetailsAtNewPos = getParentDetailsElementAtPos(dom2, pos);
            if (isInDetailsElement(dom2, pos) && !equals(parentDetailsAtCaret, parentDetailsAtNewPos)) {
              if (!forward) {
                moveCaretToDetailsPos(editor, pos, false);
              }
              if (parentBlock && inEmptyParentBlock) {
                if (forward && isFirstBlock) {
                  return true;
                } else if (!forward && isLastBlock) {
                  return true;
                }
                moveCaretToDetailsPos(editor, pos, forward);
                editor.dom.remove(parentBlock);
              }
              return true;
            } else {
              return false;
            }
          });
        } else {
          return false;
        }
      };
      const shouldPreventDeleteSummaryAction = (editor, detailElements, forward, granularity) => {
        const selection = editor.selection;
        const rng = selection.getRng();
        const caretPos = CaretPosition.fromRangeStart(rng);
        const root = editor.getBody();
        if (granularity === "selection") {
          return isPartialDelete(rng, detailElements);
        } else if (forward) {
          return isCaretAtEndOfSummary(caretPos, detailElements) || isCaretInLastPositionInBody(root, caretPos, detailElements);
        } else {
          return isCaretAtStartOfSummary(caretPos, detailElements) || isCaretInFirstPositionInBody(caretPos, detailElements);
        }
      };
      const shouldPreventDeleteAction = (editor, forward, granularity) => getDetailsElements(editor.dom, editor.selection.getRng()).fold(() => shouldPreventDeleteIntoDetails(editor, forward, granularity), (detailsElements) => shouldPreventDeleteSummaryAction(editor, detailsElements, forward, granularity) || shouldPreventDeleteIntoDetails(editor, forward, granularity));
      const handleDeleteActionSafari = (editor, forward, granularity) => {
        const selection = editor.selection;
        const node = selection.getNode();
        const rng = selection.getRng();
        const caretPos = CaretPosition.fromRangeStart(rng);
        if (isSummary$1(node)) {
          if (granularity === "selection" && isEntireNodeSelected(rng, node) || willDeleteLastPositionInElement(forward, caretPos, node)) {
            emptyNodeContents(node);
          } else {
            editor.undoManager.transact(() => {
              const sel = selection.getSel();
              let { anchorNode, anchorOffset, focusNode, focusOffset } = sel !== null && sel !== void 0 ? sel : {};
              const applySelection = () => {
                if (isNonNullable(anchorNode) && isNonNullable(anchorOffset) && isNonNullable(focusNode) && isNonNullable(focusOffset)) {
                  sel === null || sel === void 0 ? void 0 : sel.setBaseAndExtent(anchorNode, anchorOffset, focusNode, focusOffset);
                }
              };
              const updateSelection = () => {
                anchorNode = sel === null || sel === void 0 ? void 0 : sel.anchorNode;
                anchorOffset = sel === null || sel === void 0 ? void 0 : sel.anchorOffset;
                focusNode = sel === null || sel === void 0 ? void 0 : sel.focusNode;
                focusOffset = sel === null || sel === void 0 ? void 0 : sel.focusOffset;
              };
              const appendAllChildNodes = (from2, to2) => {
                each$e(from2.childNodes, (child2) => {
                  if (isNode(child2)) {
                    to2.appendChild(child2);
                  }
                });
              };
              const container = editor.dom.create("span", { "data-mce-bogus": "1" });
              appendAllChildNodes(node, container);
              node.appendChild(container);
              applySelection();
              if (granularity === "word" || granularity === "line") {
                sel === null || sel === void 0 ? void 0 : sel.modify("extend", forward ? "right" : "left", granularity);
              }
              if (!selection.isCollapsed() && isEntireNodeSelected(selection.getRng(), container)) {
                emptyNodeContents(node);
              } else {
                editor.execCommand(forward ? "ForwardDelete" : "Delete");
                updateSelection();
                appendAllChildNodes(container, node);
                applySelection();
              }
              editor.dom.remove(container);
            });
          }
          return true;
        } else {
          return false;
        }
      };
      const backspaceDelete = (editor, forward, granularity) => shouldPreventDeleteAction(editor, forward, granularity) || isSafari && handleDeleteActionSafari(editor, forward, granularity) ? Optional.some(noop) : Optional.none();
      const createAndFireInputEvent = (eventType) => (editor, inputType, specifics = {}) => {
        const target = editor.getBody();
        const overrides = {
          bubbles: true,
          composed: true,
          data: null,
          isComposing: false,
          detail: 0,
          view: null,
          target,
          currentTarget: target,
          eventPhase: Event.AT_TARGET,
          originalTarget: target,
          explicitOriginalTarget: target,
          isTrusted: false,
          srcElement: target,
          cancelable: false,
          preventDefault: noop,
          inputType
        };
        const input = clone$3(new InputEvent(eventType));
        return editor.dispatch(eventType, {
          ...input,
          ...overrides,
          ...specifics
        });
      };
      const fireInputEvent = createAndFireInputEvent("input");
      const fireBeforeInputEvent = createAndFireInputEvent("beforeinput");
      const platform$2 = detect$1();
      const os = platform$2.os;
      const isMacOSOriOS = os.isMacOS() || os.isiOS();
      const browser = platform$2.browser;
      const isFirefox = browser.isFirefox();
      const executeKeydownOverride$3 = (editor, caret, evt) => {
        const inputType = evt.keyCode === VK.BACKSPACE ? "deleteContentBackward" : "deleteContentForward";
        const isCollapsed = editor.selection.isCollapsed();
        const unmodifiedGranularity = isCollapsed ? "character" : "selection";
        const getModifiedGranularity = (isWord) => {
          if (isCollapsed) {
            return isWord ? "word" : "line";
          } else {
            return "selection";
          }
        };
        executeWithDelayedAction([
          {
            keyCode: VK.BACKSPACE,
            action: action(backspaceDelete$1, editor)
          },
          {
            keyCode: VK.BACKSPACE,
            action: action(backspaceDelete$7, editor, false)
          },
          {
            keyCode: VK.DELETE,
            action: action(backspaceDelete$7, editor, true)
          },
          {
            keyCode: VK.BACKSPACE,
            action: action(backspaceDelete$8, editor, false)
          },
          {
            keyCode: VK.DELETE,
            action: action(backspaceDelete$8, editor, true)
          },
          {
            keyCode: VK.BACKSPACE,
            action: action(backspaceDelete$4, editor, caret, false)
          },
          {
            keyCode: VK.DELETE,
            action: action(backspaceDelete$4, editor, caret, true)
          },
          {
            keyCode: VK.BACKSPACE,
            action: action(backspaceDelete$b, editor, false)
          },
          {
            keyCode: VK.DELETE,
            action: action(backspaceDelete$b, editor, true)
          },
          {
            keyCode: VK.BACKSPACE,
            action: action(backspaceDelete, editor, false, unmodifiedGranularity)
          },
          {
            keyCode: VK.DELETE,
            action: action(backspaceDelete, editor, true, unmodifiedGranularity)
          },
          ...isMacOSOriOS ? [
            {
              keyCode: VK.BACKSPACE,
              altKey: true,
              action: action(backspaceDelete, editor, false, getModifiedGranularity(true))
            },
            {
              keyCode: VK.DELETE,
              altKey: true,
              action: action(backspaceDelete, editor, true, getModifiedGranularity(true))
            },
            {
              keyCode: VK.BACKSPACE,
              metaKey: true,
              action: action(backspaceDelete, editor, false, getModifiedGranularity(false))
            }
          ] : [
            {
              keyCode: VK.BACKSPACE,
              ctrlKey: true,
              action: action(backspaceDelete, editor, false, getModifiedGranularity(true))
            },
            {
              keyCode: VK.DELETE,
              ctrlKey: true,
              action: action(backspaceDelete, editor, true, getModifiedGranularity(true))
            }
          ],
          {
            keyCode: VK.BACKSPACE,
            action: action(backspaceDelete$5, editor, false)
          },
          {
            keyCode: VK.DELETE,
            action: action(backspaceDelete$5, editor, true)
          },
          {
            keyCode: VK.BACKSPACE,
            action: action(backspaceDelete$2, editor, false)
          },
          {
            keyCode: VK.DELETE,
            action: action(backspaceDelete$2, editor, true)
          },
          {
            keyCode: VK.BACKSPACE,
            action: action(backspaceDelete$9, editor, false)
          },
          {
            keyCode: VK.DELETE,
            action: action(backspaceDelete$9, editor, true)
          },
          {
            keyCode: VK.BACKSPACE,
            action: action(backspaceDelete$a, editor, false)
          },
          {
            keyCode: VK.DELETE,
            action: action(backspaceDelete$a, editor, true)
          },
          {
            keyCode: VK.BACKSPACE,
            action: action(backspaceDelete$3, editor, false)
          },
          {
            keyCode: VK.DELETE,
            action: action(backspaceDelete$3, editor, true)
          },
          {
            keyCode: VK.BACKSPACE,
            action: action(backspaceDelete$6, editor, false)
          },
          {
            keyCode: VK.DELETE,
            action: action(backspaceDelete$6, editor, true)
          }
        ], evt).filter((_) => editor.selection.isEditable()).each((applyAction) => {
          evt.preventDefault();
          const beforeInput = fireBeforeInputEvent(editor, inputType);
          if (!beforeInput.isDefaultPrevented()) {
            applyAction();
            fireInputEvent(editor, inputType);
          }
        });
      };
      const executeKeyupOverride = (editor, evt, isBackspaceKeydown) => execute([
        {
          keyCode: VK.BACKSPACE,
          action: action(paddEmptyElement, editor)
        },
        {
          keyCode: VK.DELETE,
          action: action(paddEmptyElement, editor)
        },
        ...isMacOSOriOS ? [
          {
            keyCode: VK.BACKSPACE,
            altKey: true,
            action: action(refreshCaret, editor)
          },
          {
            keyCode: VK.DELETE,
            altKey: true,
            action: action(refreshCaret, editor)
          },
          ...isBackspaceKeydown ? [{
            keyCode: isFirefox ? 224 : 91,
            action: action(refreshCaret, editor)
          }] : []
        ] : [
          {
            keyCode: VK.BACKSPACE,
            ctrlKey: true,
            action: action(refreshCaret, editor)
          },
          {
            keyCode: VK.DELETE,
            ctrlKey: true,
            action: action(refreshCaret, editor)
          }
        ]
      ], evt);
      const setup$j = (editor, caret) => {
        let isBackspaceKeydown = false;
        editor.on("keydown", (evt) => {
          isBackspaceKeydown = evt.keyCode === VK.BACKSPACE;
          if (!evt.isDefaultPrevented()) {
            executeKeydownOverride$3(editor, caret, evt);
          }
        });
        editor.on("keyup", (evt) => {
          if (!evt.isDefaultPrevented()) {
            executeKeyupOverride(editor, evt, isBackspaceKeydown);
          }
          isBackspaceKeydown = false;
        });
      };
      const firstNonWhiteSpaceNodeSibling = (node) => {
        while (node) {
          if (isElement$6(node) || isText$b(node) && node.data && /[\r\n\s]/.test(node.data)) {
            return node;
          }
          node = node.nextSibling;
        }
        return null;
      };
      const moveToCaretPosition = (editor, root) => {
        const dom2 = editor.dom;
        const moveCaretBeforeOnEnterElementsMap = editor.schema.getMoveCaretBeforeOnEnterElements();
        if (!root) {
          return;
        }
        if (/^(LI|DT|DD)$/.test(root.nodeName)) {
          const firstChild2 = firstNonWhiteSpaceNodeSibling(ro