document.addEventListener('DOMContentLoaded', function () {
    setTimeout(initTabs, 500);
});

function initTabs() {
    let currentTabIndex = 0;
    const tabs = document.querySelectorAll('.tab-content');
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabSlider = document.getElementById('tab-slider');

    tabButtons.forEach((button, index) => {
        button.addEventListener('click', () => {
            currentTabIndex = index;
            updateTabSlider();
            updateTabButtons();
            // updateTabContent();
        });
    });

    function updateTabSlider() {
        tabSlider.style.transform = `translateX(-${currentTabIndex * 100}%)`;
    }

    function updateTabButtons() {
        tabButtons.forEach((button, index) => {
            if (index === currentTabIndex) {
                button.classList.add('active');
            } else {
                button.classList.remove('active');
            }
        });
    }

    // Swipe functionality
    let touchstartX = 0;
    let touchendX = 0;

    function handleGesture() {
        if (touchendX < touchstartX) {
            // Swipe left, go to next tab
            if (currentTabIndex < tabs.length - 1) {
                currentTabIndex++;
            } else {
                currentTabIndex = 0;
            }
        }
        if (touchendX > touchstartX) {
            // Swipe right, go to previous tab
            if (currentTabIndex > 0) {
                currentTabIndex--;
            } else {
                currentTabIndex = tabs.length - 1;
            }
        }
        updateTabSlider();
        updateTabButtons();
    }

    document.addEventListener('touchstart', e => {
        touchstartX = e.changedTouches[0].screenX;
    });

    document.addEventListener('touchend', e => {
        touchendX = e.changedTouches[0].screenX;
        handleGesture();
    });

    // Initialize the tab slider
    updateTabSlider();
    updateTabButtons();
}
