<div class="z-20 fixed sm:w-7/12 md:w-6/12 lg:w-4/12 mx-auto bottom-0 left-0 right-0 bg-white dark:bg-zinc-800 shadow-lg transform translate-y-full transition-transform duration-300 px-8 py-10 rounded-t-2xl"
    :class="{ 'translate-y-full': !editSocial, 'translate-y-0': editSocial }" x-data="{ submitting: false }"
    x-on:set-submitting.window="submitting = $event.detail.value">

    <div x-show="social_skool">
        <span class="flex rounded-full bg-white p-2 size-20 border-0 mx-auto justify-center items-center">
            <skool-icon class="size-10" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Skool</h3>
    </div>

    {{-- If social selected is linkedin --}}
    <div x-show="social_linkedin">
        <span class="flex rounded-full text-white p-2 size-20 border-0 mx-auto justify-center items-center"
            style="background-color: #0077B5">
            <x-fab-linkedin class="size-10" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">LinkedIn</h3>
    </div>

    {{-- If social selected is facebook --}}
    <div x-show="social_facebook">
        <span class="flex rounded-full text-white p-2 size-20 border-0 mx-auto justify-center items-center"
            style="background-color: #1877F2">
            <x-fab-facebook class="size-10" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Facebook</h3>
    </div>

    {{-- If social selected is twitter x --}}
    <div x-show="social_x">
        <span class="flex rounded-full text-white p-2 size-20 border-0 mx-auto justify-center items-center"
            style="background-color: #000000">
            <x-ri-twitter-x-fill class="size-10" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Twitter X</h3>
    </div>


    <div x-show="social_threads">
        <span class="flex rounded-full text-white p-2 size-20 border-0 mx-auto justify-center items-center"
            style="background-color: #000000">
            <x-fab-threads class="size-10" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Threads</h3>
    </div>

    {{-- If social selected is instagram --}}
    <div x-show="social_instagram">
        <span class="flex rounded-full text-[#E1306C]  p-2 size-20 border-0 mx-auto justify-center items-center"
            style="background-color: #ffffff">
            <x-fab-instagram class="size-10" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Instagram</h3>
    </div>

    {{-- If social selected is tiktok --}}
    <div x-show="social_tiktok">
        <span class="flex rounded-full text-white p-2 size-20 border-0 mx-auto justify-center items-center"
            style="background-color: #000000">
            <x-fab-tiktok class="size-10" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Tiktok</h3>
    </div>

    {{-- If social selected is youtube --}}
    <div x-show="social_youtube">
        <span class="flex rounded-full text-white p-2 size-20 border-0 mx-auto justify-center items-center"
            style="background-color: #ff0000">
            <x-fab-youtube class="size-10" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Youtube</h3>
    </div>

    {{-- If social selected is clubhouse --}}
    <div x-show="social_clubhouse">
        <span class="flex rounded-full text-[#ffe558] p-2 size-20 border-0 mx-auto justify-center items-center"
            style="background-color: #ffffff">
            <x-si-clubhouse class="size-10" style="stroke: black; stroke-width: 0.5px;" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Clubhouse</h3>
    </div>


    {{-- If social selected is fanbase --}}
    <div x-show="social_fanbase">
        <span class="flex rounded-full text-white p-2 size-20 border-0 mx-auto justify-center items-center"
            style="background-color: #9829FF">
            <fanbase-icon class="size-10" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Fanbase</h3>
    </div>

    <div x-show="social_snapchat">
        <span
            class="flex rounded-full text-[#FFFC00] bg-white p-2 size-20 border-0 mx-auto justify-center items-center">
            <x-fab-snapchat-ghost class="size-10" style="stroke: black; stroke-width: 20px;" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Snapchat</h3>
    </div>

    <div x-show="social_pinterest">
        <span class="flex rounded-full text-white p-2 size-20 border-0 mx-auto justify-center items-center"
            style="background-color: #E60023">
            <x-fab-pinterest-p class="size-10" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Pinterest</h3>
    </div>

    <div x-show="social_soundcloud">
        <span class="flex rounded-full text-white p-2 size-20 border-0 mx-auto justify-center items-center"
            style="background-color: #ff7700">
            <x-fab-soundcloud class="size-10" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Sound Cloud</h3>
    </div>

    <div x-show="social_apple_podcasts">
        <span class="flex rounded-full text-white p-2 size-20 border-0 mx-auto justify-center items-center"
            style="background-color: #872EC4">
            <x-si-applepodcasts class="size-10" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Apple Podcasts</h3>
    </div>

    <div x-show="social_spotify">
        <span class="flex rounded-full text-white p-2 size-20 border-0 mx-auto justify-center items-center"
            style="background-color: #1ED760">
            <x-fab-spotify class="size-10" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Spotify</h3>
    </div>

    <div x-show="social_discord">
        <span class="flex rounded-full text-white p-2 size-20 border-0 mx-auto justify-center items-center"
            style="background-color: #7785cc">
            <x-fab-discord class="size-10" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Discord</h3>
    </div>

    <form wire:submit="store(selected_social)" @submit="submitting=true">
        <div class="mt-5">

            {{-- Custom error validation --}}
            @if (session('error'))
                <ul class="px-4 py-2 bg-red-300 my-5">
                    <li class="mt-1 text-sm/6 text-red-600">{{ session('error') }}</li>
                </ul>
            @endif

            @if ($errors->any())
                <ul class="px-4 py-2 bg-red-300 my-5">
                    @foreach ($errors->all() as $error)
                        <p class="mt-1 text-sm/6 text-red-600">{{ $error }}</p>
                    @endforeach
                </ul>
            @endif

            <label for="link" class="block text-base font-medium text-gray-900 dark:text-slate-300">Social
                link</label>
            {{-- <div
                class="mt-2 flex items-center rounded-full bg-gray-100 dark:bg-white pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-indigo-600">
                <div class="shrink-0 text-sm font-normal text-gray-900 select-none">
                    www.facebook.com/</div>
                <input type="text" name="link" id="link"
                    class="block min-w-0 grow py-2 pr-3 text-sm text-gray-900 bg-gray-100 dark:bg-white placeholder:text-gray-400 focus:outline-none rounded-full"
                    placeholder="@username">
            </div> --}}

            <div
                class="mt-2 flex items-center rounded-full bg-gray-100 dark:bg-white pl-5 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600">

                {{-- Social Link --}}
                <input type="text" name="link" wire:model="link"
                    class="block min-w-0 grow py-2 text-base text-gray-900 bg-gray-100 dark:bg-white placeholder:text-gray-400 focus:outline-none rounded-full"
                    :placeholder="social_facebook ? 'https://www.facebook.com/@username' :
                        (social_instagram ? 'https://www.instagram.com/@username' :
                            (social_skool ? 'https://www.skool.com/join/' :
                                (social_linkedin ? 'https://www.linkedin.com/in/@username' :
                                    (social_x ? 'https://www.x.com/@username' :
                                        (social_tiktok ? 'https://www.tiktok.com/@username' :
                                            (social_youtube ? 'https://www.youtube.com/@username' :
                                                (social_clubhouse ? 'https://www.clubhouse.com/@username' :
                                                    (social_threads ?
                                                        'https://www.threads.net/@username' : (social_snapchat ?
                                                            'https://www.snapchat.com/add/' :
                                                            (social_fanbase ?
                                                                'https://fanbase.app/@username' :
                                                                (social_pinterest ?
                                                                    'https://www.pinterest.com/username' :
                                                                    (social_soundcloud ?
                                                                        'https://soundcloud.com/username' :
                                                                        (social_apple_podcasts ?
                                                                            'https://podcasts.apple.com/podcast/id' :
                                                                            (social_spotify ?
                                                                                'https://open.spotify.com/user/username' :
                                                                                (social_discord ?
                                                                                    'https://discord.gg/invitecode' :
                                                                                    '')))))))))))))))">



                {{-- Social Type --}}
                <input type="hidden" name="type" x-model="selected_social">

                {{-- <input type="hidden" wire:model="type"
                    :value="social_facebook ? 'facebook' :
                        (social_instagram ? 'instagram' :
                            (social_linkedin ? 'linkedin' :
                                (social_x ? 'x' :
                                    (social_tiktok ? 'tiktok' :
                                        (social_youtube ? 'youtube' : '')))))"> --}}
            </div>

        </div>

        <div class="mt-5 col-span-full">
            <button type="submit" :disabled="submitting"
                class="block bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 px-3 py-2 rounded-full w-full text-sm text-black text-center mx-auto font-medium">
                <!-- Normal text -->
                <span x-show="!submitting">Update
                    Link</span>

                <!-- Saving text -->
                <span x-show="submitting" class="inline-flex items-center justify-center space-x-2">
                    <span class="text-white">Saving...</span>
                    <svg class="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none"
                        viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor"
                            stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path>
                    </svg>
                </span>
            </button>
        </div>
    </form>
</div>
