{{-- <x-filament-panels::page>
    <div class="p-6">
        {{ $this->table }}
    </div>
</x-filament-panels::page> --}}

<x-filament::page>
    {{-- Tabs --}}
    <div class="flex items-center gap-2 mb-4 border-b border-gray-200 dark:border-gray-700">
        @foreach ($this->getTabs() as $key => $tab)
            <a href="{{ $tab['url'] }}" @class([
                'px-4 py-2 rounded-t-md font-medium',
                // Active tab: green color
                'text-green-600 border-b-2 border-green-600' => $activeTab === $key,
                // Inactive tab: gray text with hover green
                'text-gray-600 hover:text-green-600' => $activeTab !== $key,
            ])>
                @if (!empty($tab['icon']))
                    <x-filament::icon :icon="$tab['icon']" class="w-4 h-4 inline-block mr-1" />
                @endif
                <span class="text-sm">{{ $tab['label'] }}</span>
            </a>
        @endforeach
    </div>

    {{ $this->table }}
</x-filament::page>
