 <div>
     @foreach ($ads as $index => $ad)
         {{-- <div x-data="{ index: {{ $index }} }">
             <div x-show="activeIndex === index" x-transition:enter="transition-opacity duration-500"
                 x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
                 x-transition:leave="transition-opacity duration-500" x-transition:leave-start="opacity-100"
                 x-transition:leave-end="opacity-0" class="absolute inset-0">
                 <a href="{{ $ad->link }}" target="_blank" class="adClickTracker" data-ad-id="{{ $ad->id }}">
                     <img src="{{ asset($ad->image) }}" alt="{{ $ad->caption }}" class="w-full h-full object-cover">
                 </a>
             </div>
         </div> --}}

         <div x-data="{ index: {{ $index }} }">
             <div x-show="activeIndex === index" x-transition:enter="transition-opacity duration-500"
                 x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
                 x-transition:leave="transition-opacity duration-500" x-transition:leave-start="opacity-100"
                 x-transition:leave-end="opacity-0" class="absolute inset-0">
                 <a href="{{ $ad['link'] }}" target="_blank" class="adClickTracker" data-ad-id="{{ $ad['id'] }}">
                     <img src="{{ asset($ad['image']) }}" alt="{{ $ad['caption'] }}" class="w-full h-full object-cover">
                 </a>
             </div>
         </div>
     @endforeach
 </div>

 @push('scripts')
     <script>
         document.addEventListener('DOMContentLoaded', function() {
             function getDeviceType() {
                 const ua = navigator.userAgent;
                 if (/mobile/i.test(ua)) return "Mobile";
                 if (/tablet/i.test(ua)) return "Tablet";
                 if (/iPad|Android(?!.*Mobile)/i.test(ua)) return "Tablet";
                 return "Desktop";
             }

             const deviceType = getDeviceType();

             fetch('https://get.geojs.io/v1/ip/geo.json')
                 .then(res => res.json())
                 .then(data => {
                     const location = {
                         city: data.city,
                         region: data.region,
                         country: data.country,
                         ip: data.ip
                     };

                     const ads = document.getElementsByClassName('adClickTracker');
                     Array.from(ads).forEach(ad => {
                         ad.addEventListener('click', function(e) {
                             const adId = this.getAttribute('data-ad-id');
                             // const title = this.getAttribute('data-title');
                             console.log(adId);
                             @this.adClicked(adId, deviceType, location);
                         });
                     });
                 })
                 .catch(() => {
                     const ads = document.getElementsByClassName('adClickTracker');
                     Array.from(ads).forEach(ad => {
                         ad.addEventListener('click', function(e) {
                             const adId = this.getAttribute('data-ad-id');
                             // const title = this.getAttribute('data-title');
                             console.log(adId);
                             @this.adClicked(adId, deviceType, null);
                         });
                     });
                 });
         });
     </script>
 @endpush
