<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('payments.index') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6 inline-block">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M2.25 8.25h19.5M2.25 9h19.5m-16.5 5.25h6m-6 2.25h3m-3.75 3h15a2.25 2.25 0 0 0 2.25-2.25V6.75A2.25 2.25 0 0 0 19.5 4.5h-15a2.25 2.25 0 0 0-2.25 2.25v10.5A2.25 2.25 0 0 0 4.5 19.5Z" />
                </svg>

                &nbsp;&nbsp;Add Payment Link
            </p>
        </div>
    </div>


    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600 px-5">

            <!-- Credit Card -->
            <li class="flex justify-between gap-x-6 py-3"
                @click="addButton=!addButton;button_credit=true;selected_button='credit'">
                <div class="flex min-w-0 gap-x-4 items-center">

                    {{-- <img src="{{ asset('/img/credit_card_icon.svg') }}" class="size-10 rounded-full border-0"> --}}
                    <span class="rounded-full text-white p-2" style="background-color: #000000">
                        <x-heroicon-s-credit-card class="size-5" />
                    </span>

                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-medium text-gray-900 dark:text-slate-300">Credit Card</p>
                    </div>
                </div>

                <div class="flex items-center">
                    <span class="rounded-full text-gray-600">
                        <button
                            class="rounded-full bg-slate-200 dark:bg-white dark:g-slate-100 p-0.5 hover:shadow-lg toggleAddSocialActionSheet">
                            <span class="text-zinc-900">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                    class="size-4">
                                    <path fill-rule="evenodd"
                                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                        clip-rule="evenodd" />
                                </svg>

                            </span>
                        </button>
                    </span>
                </div>
            </li>

            <!-- Zelle -->
            <li class="flex justify-between gap-x-6 py-3"
                @click="addButton=!addButton;button_zelle=true;selected_button='zelle'">
                <div class="flex min-w-0 gap-x-4 items-center">

                    {{-- <img src="{{ asset('/img/zelle_icon.svg') }}" class="size-10 rounded-full border-0"> --}}
                    <span class="rounded-full text-white p-2" style="background-color: #6534D1">
                        <x-si-zelle class="size-5" />
                    </span>

                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-medium text-gray-900 dark:text-slate-300">Zelle</p>
                    </div>
                </div>

                <div class="flex items-center">
                    <span class="rounded-full text-gray-600">
                        <button
                            class="rounded-full bg-slate-200 dark:bg-white dark:g-slate-100 p-0.5 hover:shadow-lg toggleAddSocialActionSheet">
                            <span class="text-zinc-900">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                    class="size-4">
                                    <path fill-rule="evenodd"
                                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                        clip-rule="evenodd" />
                                </svg>

                            </span>
                        </button>
                    </span>
                </div>
            </li>

            <!-- Apple Pay -->
            <li class="flex justify-between gap-x-6 py-3"
                @click="addButton=!addButton;button_apple_pay=true;selected_button='apple_pay'">
                <div class="flex min-w-0 gap-x-4 items-center">

                    {{-- <img src="{{ asset('/img/applepay_icon.svg') }}" class="size-10 rounded-full border-0"> --}}
                    <span class="rounded-full text-white p-2" style="background-color: #A2AAAD">
                        <x-fab-apple class="size-5" />
                    </span>

                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-medium text-gray-900 dark:text-slate-300">Apple Pay</p>
                    </div>
                </div>

                <div class="flex items-center">
                    <span class="rounded-full text-gray-600">
                        <button
                            class="rounded-full bg-slate-200 dark:bg-white dark:g-slate-100 p-0.5 hover:shadow-lg toggleAddSocialActionSheet">
                            <span class="text-zinc-900">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                    class="size-4">
                                    <path fill-rule="evenodd"
                                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                        clip-rule="evenodd" />
                                </svg>

                            </span>
                        </button>
                    </span>
                </div>
            </li>

            <!-- Venmo -->
            <li class="flex justify-between gap-x-6 py-3"
                @click="addButton=!addButton;button_venmo=true;selected_button='venmo'">
                <div class="flex min-w-0 gap-x-4 items-center">

                    {{-- <img src="{{ asset('/img/venmo_icon.svg') }}" class="size-10 rounded-full border-0"> --}}
                    <span class="rounded-full text-white p-2" style="background-color: #008CFF">
                        <x-bxl-venmo class="size-5" />
                    </span>

                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-medium text-gray-900 dark:text-slate-300">Venmo</p>
                    </div>
                </div>

                <div class="flex items-center">
                    <span class="rounded-full text-gray-600">
                        <button
                            class="rounded-full bg-slate-200 dark:bg-white dark:g-slate-100 p-0.5 hover:shadow-lg toggleAddSocialActionSheet">
                            <span class="text-zinc-900">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                    class="size-4">
                                    <path fill-rule="evenodd"
                                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                        clip-rule="evenodd" />
                                </svg>

                            </span>
                        </button>
                    </span>
                </div>
            </li>

            <!-- CashApp -->
            <li class="flex justify-between gap-x-6 py-3"
                @click="addButton=!addButton;button_cashapp=true;selected_button='cashapp'">
                <div class="flex min-w-0 gap-x-4 items-center">

                    {{-- <img src="{{ asset('/img/cashapp-icon.svg') }}" class="size-10 rounded-full border-0"> --}}
                    <span class="rounded-full text-white p-2" style="background-color: #00CF31">
                        <x-tabler-brand-cashapp class="size-5" />
                    </span>

                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-medium text-gray-900 dark:text-slate-300">CashApp</p>
                    </div>
                </div>

                <div class="flex items-center">
                    <span class="rounded-full text-gray-600">
                        <button
                            class="rounded-full bg-slate-200 dark:bg-white dark:g-slate-100 p-0.5 hover:shadow-lg toggleAddSocialActionSheet">
                            <span class="text-zinc-900">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                    class="size-4">
                                    <path fill-rule="evenodd"
                                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                        clip-rule="evenodd" />
                                </svg>

                            </span>
                        </button>
                    </span>
                </div>
            </li>

            <!-- Paypal Link -->
            <li class="flex justify-between gap-x-6 py-3"
                @click="addButton=!addButton;button_paypal_link=true;selected_button='paypal_link'">
                <div class="flex min-w-0 gap-x-4 items-center">

                    {{-- <img src="{{ asset('/img/paypal-icon.svg') }}" class="size-10 rounded-full border-0"> --}}
                    <span class="rounded-full text-white p-2" style="background-color: #253B80">
                        <x-fab-paypal class="size-5" />
                    </span>

                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-medium text-gray-900 dark:text-slate-300">Paypal Link</p>
                    </div>
                </div>

                <div class="flex items-center">
                    <span class="rounded-full text-gray-600">
                        <button
                            class="rounded-full bg-slate-200 dark:bg-white dark:g-slate-100 p-0.5 hover:shadow-lg toggleAddSocialActionSheet">
                            <span class="text-zinc-900">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                    class="size-4">
                                    <path fill-rule="evenodd"
                                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                        clip-rule="evenodd" />
                                </svg>

                            </span>
                        </button>
                    </span>
                </div>
            </li>

            {{-- Paypal Email --}}
            <li class="flex justify-between gap-x-6 py-3"
                @click="addButton=!addButton;button_paypal_email=true;selected_button='paypal_email'">
                <div class="flex min-w-0 gap-x-4 items-center">

                    {{-- <img src="{{ asset('/img/paypal-icon.svg') }}" class="size-10 rounded-full border-0"> --}}
                    <span class="rounded-full text-white p-2" style="background-color: #253B80">
                        <x-fab-paypal class="size-5" />
                    </span>

                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-medium text-gray-900 dark:text-slate-300">Paypal Email</p>
                    </div>
                </div>

                <div class="flex items-center">
                    <span class="rounded-full text-gray-600">
                        <button
                            class="rounded-full bg-slate-200 dark:bg-white dark:g-slate-100 p-0.5 hover:shadow-lg toggleAddSocialActionSheet">
                            <span class="text-zinc-900">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                    class="size-4">
                                    <path fill-rule="evenodd"
                                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                        clip-rule="evenodd" />
                                </svg>

                            </span>
                        </button>
                    </span>
                </div>
            </li>

            {{-- Chime --}}
            <li class="flex justify-between gap-x-6 py-3"
                @click="addButton=!addButton;button_chime=true;selected_button='chime'">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <span class="rounded-full text-white px-2 pt-2 pb-0.5 bg-white" style="background-color: #1EC677">
                        <chime-icon class="size-5" />
                    </span>

                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-medium text-gray-900 dark:text-slate-300">Chime</p>
                    </div>
                </div>

                <div class="flex items-center">
                    <span class="rounded-full text-gray-600">
                        <button
                            class="rounded-full bg-slate-200 dark:bg-white dark:g-slate-100 p-0.5 hover:shadow-lg toggleAddSocialActionSheet">
                            <span class="text-zinc-900">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                    class="size-4">
                                    <path fill-rule="evenodd"
                                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                        clip-rule="evenodd" />
                                </svg>

                            </span>
                        </button>
                    </span>
                </div>
            </li>

            {{-- Square --}}
            <li class="flex justify-between gap-x-6 py-3"
                @click="addButton=!addButton;button_square=true;selected_button='square'">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <span class="rounded-full text-black p-2 bg-white">
                        <x-si-square class="size-5" />
                    </span>

                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-medium text-gray-900 dark:text-slate-300">Square</p>
                    </div>
                </div>

                <div class="flex items-center">
                    <span class="rounded-full text-gray-600">
                        <button
                            class="rounded-full bg-slate-200 dark:bg-white dark:g-slate-100 p-0.5 hover:shadow-lg toggleAddSocialActionSheet">
                            <span class="text-zinc-900">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                    class="size-4">
                                    <path fill-rule="evenodd"
                                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                        clip-rule="evenodd" />
                                </svg>
                            </span>
                        </button>
                    </span>
                </div>
            </li>

            {{-- Payment Others --}}
            <li class="flex justify-between gap-x-6 py-3"
                @click="addButton=!addButton;button_payment_other=true;selected_button='payment_other'">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <span class="rounded-full text-white p-2 bg-red-500">
                        <x-fas-dollar-sign class="size-5" />
                    </span>

                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-medium text-gray-900 dark:text-slate-300">Payment (Other)</p>
                    </div>
                </div>

                <div class="flex items-center">
                    <span class="rounded-full text-gray-600">
                        <button
                            class="rounded-full bg-slate-200 dark:bg-white dark:g-slate-100 p-0.5 hover:shadow-lg toggleAddSocialActionSheet">
                            <span class="text-zinc-900">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                    class="size-4">
                                    <path fill-rule="evenodd"
                                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                        clip-rule="evenodd" />
                                </svg>

                            </span>
                        </button>
                    </span>
                </div>
            </li>

        </ul>
    </div>

</div>
