<div>
    @if ($check_if_product_is_from_user)
        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

            <div class="grid grid-cols-5 gap-4">
                {{-- Back Button to Profile Page --}}
                <div class="flex items-center col-span-1">
                    <a wire:navigate
                        href="{{ $is_subscription ? route('subscriptions.edit', $product_id) : route('product.edit', $product_id) }}"
                        class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                        <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                            </svg>
                        </span>
                    </a>
                </div>

                <p
                    class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">
                    <x-heroicon-o-video-camera class="size-6 inline-block" />
                    &nbsp;&nbsp;Add Videos
                </p>
            </div>
        </div>

        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

            <form wire:submit.prevent="saveVideo" class="px-5">
                <div class="space-y-12">

                    <div class="border-b border-gray-900/10  dark:border-gray-400 pb-12">

                        <div class="grid gap-x-6 gap-y-8">
                            <div class="col-span-full">
                                <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Video
                                    Links</label>

                                @foreach ($video_link as $index => $link)
                                    <div class="flex items-center mt-2 gap-2">
                                        <input wire:model="video_link.{{ $index }}" type="text"
                                            class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900
                       @error('video_link.' . $index) border border-red-600 @enderror"
                                            placeholder="Youtube or Vimeo link">

                                        {{-- Remove Button --}}
                                        @if ($index > 0)
                                            <button type="button" wire:click="removeVideoLink({{ $index }})"
                                                class="text-red-600 hover:text-red-800 font-bold px-2">✕</button>
                                        @endif
                                    </div>

                                    @error('video_link.' . $index)
                                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                    @enderror
                                @endforeach

                                {{-- Add More Button --}}
                                <button type="button" wire:click="addVideoLink"
                                    class="mt-3 inline-flex items-center gap-1 rounded-md bg-green-500 px-3 py-1 text-white text-sm hover:bg-green-600">
                                    ➕ Add another
                                </button>
                            </div>

                        </div>

                    </div>

                </div>


                <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                    <button type="submit"
                        class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">Add
                        Video</button>
                </div>
            </form>
        </div>
    @else
        <div id="custom_bg" class="h-screen flex justify-center items-center">
            <div>
                <p class="mx-auto font-medium text-center text-xl">Invalid action. </p>

                <a href="{{ route('dashboard.product') }}"
                    class="inline-flex mt-5 px-4 py-3 rounded-full text-center text-l font-bold"
                    style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                    Back to Products Page
                </a>

            </div>
        </div>
    @endif
</div>
