<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('dashboard.sales') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6 inline-block">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M15.75 10.5V6a3.75 3.75 0 1 0-7.5 0v4.5m11.356-1.993 1.263 12c.07.665-.45 1.243-1.119 1.243H4.25a1.125 1.125 0 0 1-1.12-1.243l1.264-12A1.125 1.125 0 0 1 5.513 7.5h12.974c.576 0 1.059.435 1.119 1.007ZM8.625 10.5a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm7.5 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z" />
                </svg>

                &nbsp;&nbsp;Add Sales Page
            </p>

        </div>

    </div>


    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        <form wire:submit.prevent="savePage" class="px-5">
            <div class="space-y-12">

                <div class="border-b border-gray-900/10  dark:border-gray-400 pb-12">

                    <div class="mt-10 grid gap-x-6 gap-y-8">

                        {{-- Sales Image Field --}}
                        <div>
                            <livewire:sales-page-thumbnail-field />

                            @error('image')
                                <p class="text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            <label for="title"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Title
                            </label>
                            <div class="mt-2">
                                <div
                                    class="flex  items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('title') border border-red-600 @enderror">

                                    <input type="text" wire:model="title"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                        placeholder="ex: Gym Equipments Sale" value="{{ old('title') }}">
                                </div>
                            </div>
                            @error('title')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full" x-data="{
                            maxChars: 2000,
                            text: '{{ old('description') }}',
                            currentChar: '{{ old('description') }}'.length,
                            updateCount() {
                                this.currentChar = this.text.length;
                            },
                        }">
                            <label for="description"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Description</label>
                            <div class="mt-2">
                                <textarea wire:model="description" rows="3" x-model="text" x-on:input="updateCount" :maxlength="maxChars"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('description') border border-red-600 @enderror">{{ old('description') }}</textarea>
                            </div>

                            @error('description')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror

                            <p class="mt-3 text-sm/6 text-gray-600">Write a few sentences about this page. Max character
                                2000.
                                (<span x-text="`${currentChar}/${maxChars}`" class="text-sm/6 text-gray-600"></span>)
                            </p>
                        </div>


                        <div x-data="{ isActive: @entangle('is_active') }">
                            <label for="is_active" class="text-sm/6 font-medium text-gray-900 dark:text-gray-400">Sales
                                Page Active</label>
                            <span class="rounded-full text-gray-600">
                                <button type="button" id="is_active" @click="isActive =!isActive"
                                    class="mt-2 flex w-8 flex-none cursor-pointer rounded-full"
                                    :class="isActive ? 'bg-green-400' : 'bg-gray-200'" role="switch"
                                    aria-checked="false" aria-labelledby="switch-1-label">
                                    <span aria-hidden="true"
                                        class="size-4 transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"
                                        :class="isActive ? 'translate-x-3.5' : 'translate-x-0'"></span>
                                </button>
                            </span>
                        </div>

                        {{-- <div class="col-span-full" x-data="richTextEditor()">
                            <label for="description"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">
                                Description
                            </label>
                            <div class="mt-2" wire:ignore>
                                <textarea wire:model="description" x-ref="editor" rows="3" @change="updateCount" :maxlength="maxChars"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6">{{ old('description') }}</textarea>
                            </div>

                            @error('description')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror

                            <p class="mt-3 text-sm/6 text-gray-600">
                                Write a few sentences about the product.
                                (<span x-text="`${charCount}/${maxChars}`"></span>)
                            </p>
                        </div> --}}

                    </div>

                </div>

            </div>


            <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                <button type="submit"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">
                    Create</button>
            </div>
        </form>
    </div>

</div>
