<div x-data="{ submitting: false }" x-on:set-submitting.window="submitting = $event.detail.value">
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('dashboard.service') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6 inline-block">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M20.25 14.15v4.25c0 1.094-.787 2.036-1.872 2.18-2.087.277-4.216.42-6.378.42s-4.291-.143-6.378-.42c-1.085-.144-1.872-1.086-1.872-2.18v-4.25m16.5 0a2.18 2.18 0 0 0 .75-1.661V8.706c0-1.081-.768-2.015-1.837-2.175a48.114 48.114 0 0 0-3.413-.387m4.5 8.006c-.194.165-.42.295-.673.38A23.978 23.978 0 0 1 12 15.75c-2.648 0-5.195-.429-7.577-1.22a2.016 2.016 0 0 1-.673-.38m0 0A2.18 2.18 0 0 1 3 12.489V8.706c0-1.081.768-2.015 1.837-2.175a48.111 48.111 0 0 1 3.413-.387m7.5 0V5.25A2.25 2.25 0 0 0 13.5 3h-3a2.25 2.25 0 0 0-2.25 2.25v.894m7.5 0a48.667 48.667 0 0 0-7.5 0M12 12.75h.008v.008H12v-.008Z" />
                </svg>

                &nbsp;&nbsp;Add Service
            </p>

        </div>

    </div>


    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        <form wire:submit.prevent="saveService()" class="px-5" @submit="submitting=true">
            <div class="space-y-12">

                <div class="border-b border-gray-900/10  dark:border-gray-400 pb-12">

                    <div class="grid gap-x-6 gap-y-8">

                        <div class="col-span-full">
                            <label for="button_title"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Service Image
                            </label>

                            <div class="mt-2">
                                {{-- Service Image Field --}}
                                <livewire:service-image-field />
                            </div>
                        </div>

                        <div class="col-span-full">
                            <label for="title"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Service
                                Title</label>
                            <div class="mt-2">
                                <div
                                    class="flex  items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('title') border border-red-600 @enderror">

                                    <input type="text" wire:model="title"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                        placeholder="Web Development" value="{{ old('title') }}">
                                </div>
                            </div>
                            @error('title')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            <label for="price"
                                class="block text-sm/6 font-semibold text-gray-900 dark:text-gray-400">Service
                                Price</label>
                            <div class="mt-2">
                                <input wire:model="price" type="number"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('price') border border-red-600 @enderror"
                                    placeholder="$100" value="{{ old('price') }}">
                            </div>

                            @error('price')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            <label for="payment_link"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Payment Link
                            </label>
                            <div class="mt-2">
                                <input wire:model="payment_link"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('payment_link') border border-red-600 @enderror"
                                    placeholder="https://www.paypal.com/paypalme/giojitsumma"
                                    value="{{ old('payment_link') }}">
                            </div>

                            @error('payment_link')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- <div class="col-span-full" x-data="{
                            maxChars: 1000,
                            text: '{{ old('description') }}',
                            currentChar: '{{ old('description') }}'.length,
                            updateCount() {
                                this.currentChar = this.text.length;
                            },
                        }">
                            <label for="description"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Description</label>
                            <div class="mt-2">
                                <textarea wire:model="description" rows="3" x-model="text" x-on:input="updateCount" :maxlength="maxChars"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('payment_link') border border-red-600 @enderror"
                                    placeholder="I'm Awesome and you know it.">{{ old('description') }}</textarea>
                            </div>

                            @error('description')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror

                            <p class="mt-3 text-sm/6 text-gray-600">Write a few sentences about the service.
                                (<span x-text="`${currentChar}/${maxChars}`" class="text-sm/6 text-gray-600"></span>)
                            </p>
                        </div> --}}

                        <div class="col-span-full" x-data="richTextEditor()">
                            <label for="description"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">
                                Description
                            </label>
                            <div class="mt-2" wire:ignore>
                                <textarea wire:model="description" x-ref="editor" rows="3" @change="updateCount" :maxlength="maxChars"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6">{{ old('description') }}</textarea>
                            </div>

                            @error('description')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror

                            <p class="mt-3 text-sm/6 text-gray-600">
                                Write a few sentences about the service.
                                (<span x-text="`${charCount}/${maxChars}`"></span>)
                            </p>
                        </div>

                    </div>

                </div>

            </div>


            <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                <button type="submit" :disabled="submitting"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">

                    <!-- Normal text -->
                    <span x-show="!submitting">Add Service
                    </span>

                    <!-- Saving text -->
                    <span x-show="submitting" class="inline-flex items-center justify-center space-x-2">
                        <span class="text-white">Saving...</span>
                        <svg class="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none"
                            viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor"
                                stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z">
                            </path>
                        </svg>
                    </span>

                </button>
            </div>
        </form>
    </div>

</div>
