<div x-cloak class="m-0 p-0">
    @if ($user && $is_active && $user->user_type != null)
        <livewire:card-view-tracker :username="$user->username" />
        {{-- @if ($ads_top->count() > 0) --}}
        @if (count($ads_top) > 0)

            <div wire:ignore x-data="carouselData_top()" x-cloak x-init="init"
                @touchstart.window="startTouch($event)" @touchend.window="endTouch($event)"
                class="sticky top-0 left-0 right-0 sm:w-7/12 md:w-6/12 lg:w-4/12 w-full m-0 p-0 mx-auto flex flex-col content-center rounded-2xl z-50"
                style="margin-top: 0 !important; padding-top: 0 !important;">

                <!-- Carousel -->
                @if ($ad_banner_w && $ad_banner_h)
                    <div class="relative overflow-hidden w-full"
                        style="padding-top: {{ ($ad_banner_h / $ad_banner_w) * 100 }}%;">

                        <livewire:ad-component x-cloak :ads="$ads_top" :username="$user->username" />

                    </div>
                @endif
            </div>

            <!-- Alpine Component -->
            @push('scripts')
                <script>
                    function carouselData_top() {
                        return {
                            activeIndex: 0,
                            ads: @js($ads_top),
                            timer: null,
                            startX: 0,

                            next() {
                                this.activeIndex = (this.activeIndex + 1) % this.ads.length;
                            },

                            prev() {
                                this.activeIndex = (this.activeIndex - 1 + this.ads.length) % this.ads.length;
                            },

                            goTo(index) {
                                this.activeIndex = index;
                            },

                            init() {
                                if (this.timer) clearInterval(this.timer);
                                this.timer = setInterval(() => this.next(), 5000);
                            },

                            startTouch(event) {
                                this.startX = event.touches[0].clientX;
                            },

                            endTouch(event) {
                                let endX = event.changedTouches[0].clientX;
                                let diffX = this.startX - endX;

                                if (Math.abs(diffX) > 50) {
                                    if (diffX > 0) {
                                        this.next(); // swipe left
                                    } else {
                                        this.prev(); // swipe right
                                    }
                                }
                            }
                        }
                    }
                </script>
            @endpush
        @endif

        {{-- <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative {{ auth()->user() && !auth()->user()->is_admin && $ads_bottom->count() == 0 ? 'mb-20' : 'mb-2' }}"> --}}

        <div id="custom_bg"
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative {{ auth()->user() && !auth()->user()->is_admin && count($ads_bottom) < 1 ? 'mb-20' : 'mb-2' }}">


            {{-- Search bar --}}
            <livewire:search-user />

            <div
                class="grid grid-cols-4 gap-4 mb-5 {{ $profile_layout == 'default_cover' || $profile_layout == 'cover_only' || $profile_layout == 'full_width' ? 'left-0 w-full' : '' }} ">

                <!-- Download VCF -->
                <div class="ml-5 flex items-center col-span-2" x-data>
                    <livewire:download-vcf-button username="{{ $user->username }}" type="icon" />

                    {{-- bookmark network will only show to cards that is not yours --}}
                    @if (auth()->user() &&
                            in_array(auth()->user()->user_type, ['Sponsored', 'Influencer', 'Basic', 'Gold', 'Platinum']) &&
                            $user->username != auth()->user()->username &&
                            !auth()->user()->is_admin &&
                            !auth()->user()->subcards()->where('username', $user->username)->exists())
                        <livewire:save-to-network-button username="{{ $user->username }}" />
                    @endif


                    <button id="languageButton"
                        class="flex items-center justify-center rounded-full bg-slate-100 dark:bg-white w-[42px] h-[42px] text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-language class="size-5" id="heroIcon" />
                    </button>

                    <div id="languageModal"
                        class="flex fixed inset-0 bg-black bg-opacity-50 items-center justify-center hidden z-[9999] notranslate"
                        translate="no">

                        <div class="rounded-2xl p-5 w-64 shadow-lg" id="custom_bg">
                            <h2 class="text-lg font-semibold mb-4 text-center">Select Language</h2>
                            <div class="space-y-3">

                                <button
                                    class="lang-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-slate-100 dark:hover:bg-slate-700"
                                    data-lang="en" data-flag="🇺🇸">🇺🇸 English</button>
                                <button
                                    class="lang-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-slate-100 dark:hover:bg-slate-700"
                                    data-lang="es" data-flag="🇪🇸">🇪🇸 Español</button>

                                <button
                                    class="lang-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-slate-100 dark:hover:bg-slate-700"
                                    data-lang="tr" data-flag="🇹🇷">🇹🇷 Türkçe</button>

                                <button
                                    class="lang-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-slate-100 dark:hover:bg-slate-700"
                                    data-lang="fr" data-flag="🇫🇷">🇫🇷 Français</button>

                                <button
                                    class="lang-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-slate-100 dark:hover:bg-slate-700"
                                    data-lang="ar" data-flag="🇸🇦">🇸🇦 Arabic</button>


                                <button
                                    class="lang-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-slate-100 dark:hover:bg-slate-700"
                                    data-lang="he" data-flag="🇮🇱">🇮🇱 עברית</button>

                                {{-- <button
                                    class="lang-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-slate-100 dark:hover:bg-slate-700"
                                    data-lang="ar" data-flag="🇸🇦">🇸🇦 العربية</button> --}}
                            </div>

                            <div class="mt-4 text-center">
                                <button id="closeModal"
                                    style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                    class="px-4 py-2 rounded-lg">
                                    Close
                                </button>
                            </div>
                        </div>
                    </div>

                </div>

                <!-- Share Card -->
                <div class="mr-5 flex items-center col-span-2 place-content-end" x-data="{
                    urlTitle: `{{ $page_title ?: $card_title }} | {{ $job_title }}`,
                    shareUrl: '{{ route('card.show', $username) }}',
                    shareCard() {
                        if (navigator.share) {
                            navigator.share({
                                title: this.urlTitle,
                                url: this.shareUrl,
                            }).then(() => {
                                console.log('Thanks for sharing!');
                            }).catch(console.error);
                        } else {
                            console.log('Web Share API not supported');
                        }
                    }
                }">

                    <button type="button" @click="showQRCode=!showQRCode"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                        <x-heroicon-o-qr-code class="size-5" />
                    </button>

                    <a href="#" id="share_my_card" x-on:click.prevent="shareCard"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-arrow-up-tray class="size-5" />
                    </a>
                </div>
            </div>

            {{-- Display Profile Picture --}}
            {{-- cover photo --}}
            @if ($profile_layout == 'default_cover')
                <img loading="lazy"
                    src="{{ $user->cover_pic ? asset($user->cover_pic) : asset('/img/cover-placeholder.jpg') }}"
                    alt="{{ $firstname . ' ' . $lastname }}" class="w-full rounded-t-2xl mx-auto ">

                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $firstname . ' ' . $lastname }}" class="rounded-full w-6/12 mx-auto -mt-28"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
            @endif

            {{-- Cover Only --}}
            @if ($profile_layout == 'cover_only')
                <img loading="lazy"
                    src="{{ $user->cover_pic ? asset($user->cover_pic) : asset('/img/cover-placeholder.jpg') }}"
                    alt="{{ $firstname . ' ' . $lastname }}" class="w-full rounded-t-2xl mx-auto ">
            @endif

            {{-- circled profile pic --}}
            @if ($profile_layout == 'default')
                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $firstname . ' ' . $lastname }}" class="rounded-full w-6/12 mx-auto p-2 static"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
            @endif

            {{-- rounded profile pic --}}
            @if ($profile_layout == 'rounded')
                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $firstname . ' ' . $lastname }}" class="w-6/12 mx-auto p-2 static"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important; border-radius: 50px;">
            @endif

            {{-- full width profile pic --}}
            @if ($profile_layout == 'full_width')
                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $firstname . ' ' . $lastname }}" class="w-full rounded-t-2xl mx-auto ">
            @endif

            {{-- Display Full Name --}}
            <h1 class="flex items-center justify-center text-2xl md:text-3xl font-medium text-center mt-5 mx-5">
                <span>
                    {{ isset($card_title) ? $card_title : $firstname . ' ' . $lastname }}
                    @if ($user->user_type == 'Gold')
                        {{-- <x-gmdi-verified class="size-4 inline text-yellow-400" /> --}}
                        <x-gmdi-verified class="size-4 inline" style="color: #0053db !important;" />
                    @elseif($user->user_type == 'Platinum')
                        <x-gmdi-verified class="size-4 inline text-blue-500" />
                    @endif
                </span>
            </h1>

            @if ($username_enabled == true)
                <p class="rounded-full bg-yellow-400 py-1 px-2 text-[10px] text-black mx-auto w-fit my-2">
                    {{ '@' . $user->username }}
                </p>
            @endif

            {{-- Display Bio --}}
            @if ($bio && $short_bio_enabled == true)
                <p class="mx-auto w-10/12 text-center text-l py-1">
                    {{ $bio }}
                </p>
            @endif

            {{-- Display Job Title --}}
            @if (!empty($user->job_title) && empty($user->company))
                <p class="text-center text-base py-1 mx-8">
                    <span class="inline-flex items-start gap-2">
                        <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                        <span>{{ $user->job_title }}</span>
                    </span>
                </p>
            @endif

            {{-- Display Job Title and company --}}
            @if (!empty($user->job_title) && !empty($user->company))

                <p class="text-center text-base py-1 mx-8">
                    <span class="inline-flex items-start gap-2">
                        <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                        <span>{{ $user->job_title }}

                            @if (!empty($user->company_website))
                                at <a
                                    href="{{ filter_var($user->company_website, FILTER_VALIDATE_URL) ? $user->company_website : '#' }}"
                                    class="font-medium"
                                    style="color: {{ $color_settings_link }} !important;">{{ $user->company }}</a>
                            @else
                                at <span class="font-medium">{{ $user->company }}</span>
                            @endif

                        </span>
                    </span>
                </p>
            @endif

            @if (($user->address || $user->country) && $display_country)
                <p class="flex items-center justify-center text-center text-l py-1 space-x-2">
                    <x-heroicon-o-map-pin class="size-5" />
                    <x-country-flag :country="$user->country" :state="$user->state" />
                </p>
            @endif

            @if ($contacts || $user->user_type != 'Free')
                <p class="flex items-center justify-center text-center pt-5">
                    {{ $contact_text }}
                </p>
            @endif

            <div class="pt-2 container mx-auto flex flex-wrap items-center justify-center">

                @if (in_array($user->user_type, ['Basic', 'Sponsored', 'Influencer', 'Gold', 'Platinum']) && $connect_icon == true)
                    <a wire:navigate href="{{ route('card.exchange', $user->username) }}">
                        <x-fas-handshake class="size-6 mx-2 my-2" />
                    </a>
                @endif

                @if (in_array($user->user_type, ['Free', 'Basic', 'Sponsored', 'Influencer', 'Gold', 'Platinum']) && $communities)
                    <button @click="openCommunitiesModal=!openCommunitiesModal">
                        <x-fas-users class="size-6 mx-2 my-2" />
                    </button>
                @endif

                @if (in_array($user->user_type, ['Sponsored', 'Basic', 'Gold', 'Platinum', 'Free']) && $directions)
                    <button @click="openDrivingDirectionModal=!openDrivingDirectionModal">
                        <x-fas-map-location-dot class="size-6 mx-2 my-2" />
                    </button>
                @endif

                {{-- Other contact points here --}}
                @if ($contacts)
                    <livewire:contact-points-component :username="$user->username" />
                @endif
            </div>

            @if ($socials)
                <p class="flex items-center justify-center text-center pt-5">
                    {{ $follow_text }}
                </p>

                <!-- Social Media Buttons -->
                <div class="pt-2 container mx-auto flex  flex-wrap items-center justify-center">
                    @foreach ($socials as $social)
                        {{-- @php
                            dd($social->id);
                        @endphp --}}
                        <livewire:social-icon-component :username="$user->username" :social_id="$social->id" :link="$social->link"
                            :social_type="$social->type" />
                    @endforeach
                </div>

            @endif


            @if ($videos && in_array($user->user_type, ['Basic', 'Gold', 'Sponsored', 'Influencer', 'Platinum']))
                <div class="mb-5" style="z-index: 0 !important;">
                    {{-- <livewire:videos-component :username="$user->username" /> --}}
                    <livewire:new-videos-component :username="$user->username" :showOnlyFirstVideo="true" />
                </div>

                @if ($video_count > 1)
                    <div class="flex justify-center">
                        <a href="{{ route('morevideos.show', $user->username) }}"
                            class="inline-flex mb-10 px-4 py-3 {{ $button_style === 'squared' ? 'rounded-md' : 'rounded-full' }} text-center text-l font-bold items-center justify-center max-w-[83.333333%]"
                            style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                            More Videos
                        </a>
                    </div>
                @endif
            @endif


            {{-- Gallery --}}
            {{-- @if ($images_count > 0 && $gallery_main == true) --}}
            @if (in_array($user->user_type, ['Sponsored', 'Gold', 'Platinum']) && $gallery_main == true && $images_count > 0)
                <div class="mb-5" style="z-index: 0 !important;">
                    <livewire:gallery-component :username="$user->username" />
                </div>
            @endif

            {{-- <div class="items-center mt-5"> --}}
            <div
                class="items-center {{ in_array($user->user_type, ['Free', 'Basic', 'Sponsored', 'Influencer']) ? 'pt-5' : '' }}">

                @if ($buttons)
                    @foreach ($buttons as $button)
                        @php $type = $button['type']; @endphp

                        {{-- VCF button --}}
                        @if ($type === 'vcf')
                            <livewire:download-vcf-button title="{{ $button->title }}"
                                username="{{ $user->username }}" type="button" />
                            @continue
                        @endif

                        {{-- HELP --}}
                        @php
                            if ($type === 'help') {
                                if (
                                    !in_array($user->user_type, [
                                        'Basic',
                                        'Sponsored',
                                        'Influencer',
                                        'Gold',
                                        'Platinum',
                                    ]) ||
                                    !$connect_main
                                ) {
                                    continue;
                                }
                            }
                        @endphp

                        @if ($type === 'help')
                            <a wire:navigate href="{{ route('card.connect', $user->username) }}"
                                class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                href="sms:{{ $button['link'] }}" target="_blank">

                                <x-fas-handshake class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button->title }}
                            </a>
                            @continue
                        @endif

                        {{-- Exchange Contacts --}}
                        @php
                            if ($type === 'exchange') {
                                if (
                                    !in_array($user->user_type, [
                                        'Basic',
                                        'Sponsored',
                                        'Influencer',
                                        'Gold',
                                        'Platinum',
                                    ])
                                ) {
                                    continue;
                                }
                            }
                        @endphp

                        @if ($type === 'exchange')
                            <a wire:navigate href="{{ route('card.exchange', $user->username) }}"
                                class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                href="sms:{{ $button['link'] }}" target="_blank">
                                <x-fas-handshake class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button->title }}
                            </a>
                            @continue
                        @endif

                        {{-- Payments --}}
                        @php
                            if ($type === 'payments') {
                                if (
                                    !in_array($user->user_type, [
                                        'Basic',
                                        'Sponsored',
                                        'Influencer',
                                        'Gold',
                                        'Platinum',
                                    ]) ||
                                    !$payments
                                ) {
                                    continue;
                                }
                            }
                        @endphp

                        @if ($type === 'payments')
                            <a wire:navigate href="{{ route('card.pay', $user->username) }}"
                                class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif
                        w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                href="sms:{{ $button['link'] }}" target="_blank">
                                <x-heroicon-s-banknotes class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button->title }}
                            </a>
                            @continue
                        @endif

                        @php
                            if ($type === 'feedback') {
                                if (
                                    !in_array($user->user_type, [
                                        'Basic',
                                        'Sponsored',
                                        'Influencer',
                                        'Gold',
                                        'Platinum',
                                    ])
                                ) {
                                    continue;
                                }
                            }
                        @endphp

                        @if ($type === 'feedback')
                            <a wire:navigate href="{{ route('card.feedback', $user->username) }}"
                                class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                href="sms:{{ $button['link'] }}" target="_blank">
                                <x-ri-feedback-fill class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button->title }}
                            </a>
                            @continue
                        @endif

                        {{-- BIO --}}
                        @php
                            if ($type === 'bio') {
                                if (!in_array($user->user_type, ['Gold', 'Platinum']) || !$user->bio_long) {
                                    continue;
                                }
                            }
                        @endphp

                        @if ($type === 'bio')
                            <a wire:navigate href="{{ route('bio.show', $user->username) }}"
                                class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                href="sms:{{ $button['link'] }}" target="_blank">
                                <x-heroicon-s-user class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{-- {{ $bio_text }} --}}
                                {{ $button->title }}
                            </a>
                            @continue
                        @endif

                        {{-- SHOP --}}
                        @php
                            if ($type === 'shop') {
                                if (!in_array($user->user_type, ['Gold', 'Platinum']) || !$products) {
                                    continue;
                                }
                            }
                        @endphp

                        @if ($type === 'shop')
                            <a wire:navigate href="{{ route('card.products', $user->username) }}"
                                class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                href="sms:{{ $button['link'] }}" target="_blank">
                                <x-heroicon-s-shopping-bag class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{-- {{ $shop_text }} --}}
                                {{ $button->title }}
                            </a>
                            @continue
                        @endif

                        {{-- SALES --}}
                        {{-- @php
                            if ($type === 'sales') {
                                if (!in_array($user->user_type, ['Gold', 'Platinum']) || !$sales) {
                                    continue;
                                }
                            }
                        @endphp --}}

                        {{-- @if ($type === 'sales')
                            <a wire:navigate href="{{ route('card.sales', $user->username) }}"
                                class="flex items-center justify-center gap-2 p-3 rounded-full w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                href="sms:{{ $button['link'] }}" target="_blank">
                                <x-heroicon-s-shopping-bag class="size-4 inline" />
                                &nbsp;&nbsp;
                        {{ $button->title }}
                        </a>
                        @continue
                    @endif --}}

                        {{-- Events --}}
                        @php
                            if ($type === 'events') {
                                if (
                                    !in_array($user->user_type, ['Basic', 'Gold', 'Platinum']) ||
                                    !$events->isNotEmpty()
                                ) {
                                    continue;
                                }
                            }
                        @endphp

                        @if ($type === 'events')
                            <a wire:navigate href="{{ route('card.events', $user->username) }}"
                                class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                href="sms:{{ $button['link'] }}" target="_blank">
                                <x-heroicon-o-calendar-days class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button->title }}
                            </a>
                            @continue
                        @endif

                        @if ($type === 'team')
                            <a wire:navigate href="{{ route('card.team', [$user->username, $button->id]) }}"
                                class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                                <x-heroicon-s-users class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button->title }}
                            </a>
                            @continue
                        @endif

                        @php
                            if ($type === 'driving') {
                                if (
                                    !in_array($user->user_type, ['Sponsored', 'Gold', 'Platinum', 'Basic', 'Free']) ||
                                    !$directions
                                ) {
                                    continue;
                                }
                            }
                        @endphp

                        {{-- ZOOM REPLAYS --}}
                        @if ($type === 'zoom_replay' && $replays)
                            <a wire:navigate href="{{ route('card.zoomreplay', $user->username) }}"
                                class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                                <x-bxl-zoom class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button->title }}
                            </a>
                            @continue
                        @endif

                        @php
                            if ($type === 'zoom_replay') {
                                if (!in_array($user->user_type, ['Gold', 'Platinum']) || !$replays) {
                                    continue;
                                }
                            }
                        @endphp

                        {{-- TRUSTED NETWORK --}}
                        {{-- @if ($type === 'trusted_network' && $trusted_network) --}}
                        @if ($type === 'trusted_network' && $trusted_network && $user->user_type === 'Platinum')
                            <a wire:navigate href="{{ route('card.trustednetwork', $user->username) }}"
                                class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                                <x-heroicon-s-users class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button->title }}
                            </a>
                            @continue
                        @endif

                        @php
                            if ($type === 'trusted_network' && ($user->user_type !== 'Platinum' || !$trusted_network)) {
                                continue;
                            }
                        @endphp


                        @if ($type === 'reviews' && $reviews)
                            <a wire:navigate href="{{ route('card.reviews', $user->username) }}"
                                class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                                <x-heroicon-s-star class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button->title }}
                            </a>
                            @continue
                        @endif

                        @php
                            if ($type === 'reviews') {
                                if (!in_array($user->user_type, ['Gold', 'Platinum']) || !$reviews) {
                                    continue;
                                }
                            }
                        @endphp

                        @if ($type === 'driving')
                            <button @click="openDrivingDirectionModal=!openDrivingDirectionModal"
                                class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                                <x-fas-map-location-dot class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button->title }}
                            </button>
                            @continue
                        @endif

                        {{-- SERVICES --}}
                        @php
                            if ($type === 'services') {
                                if (!in_array($user->user_type, ['Gold', 'Platinum']) || !$services) {
                                    continue;
                                }
                            }
                        @endphp

                        @if ($type === 'services')
                            <a wire:navigate href="{{ route('card.services', $user->username) }}"
                                class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                href="sms:{{ $button['link'] }}" target="_blank">
                                <x-heroicon-s-briefcase class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{-- {{ $services_text }} --}}
                                {{ $button->title }}
                            </a>
                            @continue
                        @endif

                        @if ($type === 'zelle')
                            <a class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                @click.prevent="openPaymentLinkModal=!openPaymentLinkModal;button_zelle=true;payment_value='{{ $button['link'] }}'">
                                <x-si-zelle class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button['title'] }}</a>
                            @continue
                        @endif

                        {{-- APPLE PAY --}}
                        @if ($type === 'apple_pay')
                            <a class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                @click.prevent="openPaymentLinkModal=!openPaymentLinkModal;button_apple_pay=true;payment_value='{{ $button['link'] }}'">
                                <x-fab-apple class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button['title'] }}</a>
                            @continue
                        @endif

                        {{-- PAYPAL EMAIL --}}
                        @if ($type === 'paypal_email')
                            <a class="flex items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                @click.prevent="openPaymentLinkModal=!openPaymentLinkModal;button_paypal_email=true;payment_value='{{ $button['link'] }}'">
                                <x-fab-paypal class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button['title'] }}
                            </a>
                            @continue
                        @endif

                        {{-- FALLBACK BUTTON (for all other types) --}}
                        <livewire:button-component :username="$user->username" :link="$button->link" :button_id="$button->id"
                            :button_type="$button->type" :title="$button->title" />
                    @endforeach
                @endif

                @php
                    // use Illuminate\Support\Str;

                    $displayName = $card_title && Str::length($card_title) > 10 ? 'this' : ($card_title ?: $firstname);
                @endphp

                @if ($getacard_enabled === true)
                    @if (in_array($user->user_type, ['Sponsored', 'Influencer', 'Gold', 'Platinum']) && !auth()->user())
                        {{-- @if (in_array($user->user_type, ['Sponsored', 'Influencer', 'Gold', 'Platinum']) && $mainCard == true && !auth()->user()) --}}

                        @if ($affiliate_functionality === true)
                            @php
                                if ($user->user_type == 'Sponsored') {
                                    $affiliate_username = $sponsor_username;
                                } else {
                                    $affiliate_username = $user->username;
                                }
                            @endphp

                            <a wire:navigate href="{{ route('affiliate', $affiliate_username) }}"
                                class="flex p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold items-center justify-center"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                                <x-heroicon-s-heart class="size-4 inline" />
                                &nbsp;&nbsp;
                                Get a card like {{ $displayName }}</a>
                        @else
                            <a wire:navigate href="{{ route('register') }}"
                                class="flex p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold items-center justify-center"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                                <x-heroicon-s-heart class="size-4 inline" />
                                &nbsp;&nbsp;
                                Get a card like {{ $displayName }}</a>
                        @endif
                    @endif

                    @if ($user->user_type == 'Basic' && !auth()->user() && $referral)
                        {{-- @if (in_array($user->user_type, ['Sponsored', 'Influencer', 'Gold', 'Platinum']) && $mainCard == true && !auth()->user()) --}}

                        <a wire:navigate href="{{ route('affiliate', $referrer_username) }}"
                            class="flex p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold items-center justify-center"
                            style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                            <x-heroicon-s-heart class="size-4 inline" />
                            &nbsp;&nbsp;
                            Get a card like {{ $displayName }}</a>
                    @endif
                @endif

                @if (in_array($user->user_type, ['Basic', 'Gold', 'Platinum', 'Influencer', 'Sponsored']))
                    @if ($payments)
                        <p class="flex items-center justify-center text-center pt-5">
                            {{ $payment_text }}
                        </p>

                        <div class="pt-2 container mx-auto flex flex-wrap items-center justify-center">
                            @foreach ($payments as $payment)
                                @if ($payment['type'] === 'credit')
                                    <a href="{{ $payment['link'] }}" target="_blank">
                                        <x-heroicon-s-credit-card class="size-7 mx-2 my-2" />
                                    </a>
                                @elseif ($payment['type'] === 'payment_other')
                                    <a href="{{ $payment['link'] }}" target="_blank">
                                        <x-fas-dollar-sign class="size-7 mx-2 my-2" />
                                    </a>
                                @elseif ($payment['type'] === 'chime')
                                    <a href="{{ $payment['link'] }}" target="_blank">
                                        <chime-icon class="size-7 mx-2 my-2"></chime-icon>
                                    </a>
                                @elseif($payment['type'] == 'zelle')
                                    <button
                                        @click="openPaymentLinkModal=!openPaymentLinkModal;button_zelle=true;payment_value='{{ $payment['link'] }}'">
                                        <x-si-zelle class="size-7 mx-2 my-2" />
                                    </button>
                                @elseif($payment['type'] == 'apple_pay')
                                    <button
                                        @click="openPaymentLinkModal=!openPaymentLinkModal;button_apple_pay=true;payment_value='{{ $payment['link'] }}'">
                                        <x-fab-apple class="size-7 mx-2 my-2" />
                                    </button>
                                @elseif($payment['type'] == 'venmo')
                                    <a href="{{ $payment['link'] }}" target="_blank">
                                        <x-bxl-venmo class="size-7 mx-2 my-2" />
                                    </a>
                                @elseif($payment['type'] == 'cashapp')
                                    <a href="{{ $payment['link'] }}" target="_blank">
                                        <x-si-cashapp class="size-7 mx-2 my-2" />
                                    </a>
                                @elseif($payment['type'] == 'paypal_email')
                                    <button
                                        @click="openPaymentLinkModal=!openPaymentLinkModal;button_paypal_email=true;payment_value='{{ $payment['link'] }}'">
                                        <x-fab-paypal class="size-7 mx-2 my-2" />
                                    </button>
                                @elseif($payment['type'] == 'paypal_link')
                                    <a href="{{ $payment['link'] }}" target="_blank">
                                        <x-fab-paypal class="size-7 mx-2 my-2" />
                                    </a>
                                @elseif($payment['type'] == 'square')
                                    <a href="{{ $payment['link'] }}" target="_blank">
                                        <x-si-square class="size-7 mx-2 my-2" />
                                    </a>
                                @endif
                            @endforeach
                        </div>

                    @endif
                @endif
            </div>

            {{-- check if footer is enabled, has custom footer and is basic, gold or platinum --}}
            @if (
                $footer_enabled &&
                    $customFooter &&
                    in_array($user->user_type, ['Sponsored', 'Influencer', 'Basic', 'Gold', 'Platinum']))
                <p class="flex items-center justify-center text-center text-l pt-5 py-1">
                    <a href="{{ $footer_link }}" target="_blank"
                        style="color: {{ $color_settings_link }} !important;">{{ $footer_text }}</a>
                </p>
                {{-- check if footer enable, but dont have custom footer but have admin footer text and link --}}
            @elseif ($footer_enabled && !$customFooter && $default_footer_text && $default_footer_link)
                <p class="flex items-center justify-center text-center text-l pt-5 py-1">
                    <a href="{{ $default_footer_link }}" target="_blank"
                        style="color: {{ $color_settings_link }} !important;">{{ $default_footer_text }}</a>
                </p>
                {{-- check if footer not enabled and in basic, gold and platinum or footer just disabled --}}
            @elseif ((!$footer_enabled && in_array($user->user_type, ['Basic', 'Gold', 'Platinum'])) || !$footer_enabled)
                <p> </p>
            @else
                <p class="flex items-center justify-center text-center text-l pt-5 py-1">
                    <a href="{{ $site_url }}" target="_blank"
                        style="color: {{ $color_settings_link }} !important;">Get
                        your card
                        today!</a>
                </p>
            @endif

        </div>

        {{-- @if ($ads_bottom->count() > 0) --}}
        @if (count($ads_bottom) > 0)
            <div wire:ignore x-data="carouselData_bottom()" x-init="init" @touchstart.window="startTouch($event)"
                @touchend.window="endTouch($event)" {{-- class="left-0 right-0 sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto flex flex-col content-center rounded-2xl relative {{ auth()->user() ? 'mb-20' : 'mb-5' }}" --}}
                class="top-0 left-0 right-0 sm:w-7/12 md:w-6/12 lg:w-4/12 w-full m-0 p-0 mx-auto flex flex-col content-center rounded-2xl z-50 {{ auth()->user() && !auth()->user()->is_admin ? 'mb-20' : 'mb-2' }}"
                style="margin-top: 0 !important; padding-top: 0 !important;">

                <!-- Carousel -->
                @if ($ad_banner_w && $ad_banner_h)
                    {{-- <div class="relative overflow-hidden aspect-[{{ $ad_banner_w . '/' . $ad_banner_h }}]"> --}}
                    <div class="relative overflow-hidden w-full"
                        style="padding-top: {{ ($ad_banner_h / $ad_banner_w) * 100 }}%;">

                        <livewire:ad-component x-cloak :ads="$ads_bottom" :username="$user->username" />
                    </div>
                @endif

            </div>

            <!-- Alpine Component -->
            @push('scripts')
                <script>
                    function carouselData_bottom() {
                        return {
                            activeIndex: 0,
                            ads: @js($ads_bottom),
                            timer: null,
                            startX: 0,

                            next() {
                                this.activeIndex = (this.activeIndex + 1) % this.ads.length;
                            },

                            prev() {
                                this.activeIndex = (this.activeIndex - 1 + this.ads.length) % this.ads.length;
                            },

                            goTo(index) {
                                this.activeIndex = index;
                            },

                            init() {
                                // this.timer = setInterval(() => {
                                //     this.next();
                                // }, 3000);

                                if (this.timer) clearInterval(this.timer);
                                this.timer = setInterval(() => this.next(), 5000);
                            },

                            startTouch(event) {
                                this.startX = event.touches[0].clientX;
                            },

                            endTouch(event) {
                                let endX = event.changedTouches[0].clientX;
                                let diffX = this.startX - endX;

                                if (Math.abs(diffX) > 50) {
                                    if (diffX > 0) {
                                        this.next(); // swipe left
                                    } else {
                                        this.prev(); // swipe right
                                    }
                                }
                            }
                        }
                    }
                </script>
            @endpush
        @endif
</div>
</div>
@else
<div class="h-screen flex justify-center items-center">
    <div>
        <p class="mx-auto text-yellow-500 text-center text-l p-10">
            <x-ionicon-warning-sharp class=" size-32 sm:size-40" />
        </p>
        <p class="mx-auto font-bold text-center text-2xl text-gray-500 dark:text-white">User not found.
        </p>

        <p class="flex items-center justify-center text-center text-l py-1">
            <a href="{{ $site_url }}" target="_blank" class="text-yellow-600">Get your card
                today!</a>
        </p>
    </div>
</div>


@endif
</div>
