<div>
    @if ($user && $sale_image)
        @guest
            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl my-5">
            @endguest
            @auth
                <div id="custom_bg"
                    class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl mb-20 mt-5">
                @endauth
                <div class="grid grid-cols-2 gap-4 mb-5">
                    <!-- back -->
                    <div class="ml-5  flex items-center">
                        <a href="{{ route('sales.content', ['username' => $user->username, 'sales' => $sales_id]) }}"
                            class="rounded-full bg-slate-100
                            dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-chevron-left class="size-4" />
                        </a>
                    </div>

                    <!-- Share Card -->
                    <div class="mr-5 flex items-center place-content-end" x-data="{
                        urlTitle: `{{ $user['firstname'] }} {{ $user['lastname'] }} | {{ $user['job_title'] }}`,
                        shareUrl: '{{ $site_url . $user['username'] }}',
                        shareCard() {
                            if (navigator.share) {
                                navigator.share({
                                    title: this.urlTitle,
                                    url: this.shareUrl,
                                }).then(() => {
                                    console.log('Thanks for sharing!');
                                }).catch(console.error);
                            } else {
                                console.log('Web Share API not supported');
                            }
                        }
                    }">

                        <button type="button" @click="showQRCode=!showQRCode"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                            <x-heroicon-o-qr-code class="size-5" />
                        </button>

                        <a href="#" id="share_my_card" x-on:click.prevent="shareCard"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-arrow-up-tray class="size-5" />
                        </a>
                    </div>
                </div>

                <img src="{{ $sale_image->image_path ? asset($sale_image->image_path) : asset('/img/product-placeholder.jpg') }}"
                    class="rounded-t-md">

                {{-- <img src="{{ $sale_image->image_path ? asset($sale_image->image_path) : asset('/img/product-placeholder.jpg') }}"
                    alt="{{ $sale_image->title }}" class="rounded-t-md"> --}}

                {{-- <h1 class="text-xl md:text-2xl font-medium text-center mt-5">
                    {{ $sale_image->title }}</h1> --}}

                {{-- <div class="mt-5 px-5">
                    <div class="">
                        <span>{!! Purifier::clean($sale_image->description) !!}</span>
                    </div>
                </div> --}}

                {{-- <a class="w-11/12 block p-1.5 sm:p-2 rounded-full text-black text-center mx-auto mt-5 mb-2 text-xs sm:text-sm font-semibold"
                    style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                    href="{{ $sale_image['payment_link'] }}" target="_blank">Buy Now
                    @if ($product_price_enabled == true)
                        <span>
                            ${{ $product->price }}
                        </span>
                    @endif
                </a> --}}

                @if ($payments)
                    <p class="flex items-center justify-center text-center pt-5">
                        Payment links
                    </p>

                    <div class="pt-2 container mx-auto flex flex-wrap items-center justify-center">
                        @foreach ($payments as $payment)
                            @if ($payment['type'] === 'credit')
                                <a href="{{ $payment['link'] }}" target="_blank">
                                    <x-heroicon-s-credit-card class="size-7 mx-2 my-2" />
                                </a>
                            @elseif($payment['type'] == 'zelle')
                                <button
                                    @click="openPaymentLinkModal=!openPaymentLinkModal;button_zelle=true;payment_value='{{ $payment['link'] }}'">
                                    <x-si-zelle class="size-7 mx-2 my-2" />
                                </button>
                            @elseif($payment['type'] == 'apple_pay')
                                <button
                                    @click="openPaymentLinkModal=!openPaymentLinkModal;button_apple_pay=true;payment_value='{{ $payment['link'] }}'">
                                    <x-fab-apple class="size-7 mx-2 my-2" />
                                </button>
                            @elseif($payment['type'] == 'venmo')
                                <a href="{{ $payment['link'] }}" target="_blank">
                                    <x-bxl-venmo class="size-7 mx-2 my-2" />
                                </a>
                            @elseif($payment['type'] == 'cashapp')
                                <a href="{{ $payment['link'] }}" target="_blank">
                                    <x-si-cashapp class="size-7 mx-2 my-2" />
                                </a>
                            @elseif($payment['type'] == 'paypal_email')
                                <button
                                    @click="openPaymentLinkModal=!openPaymentLinkModal;button_paypal_email=true;payment_value='{{ $payment['link'] }}'">
                                    <x-fab-paypal class="size-7 mx-2 my-2" />
                                </button>
                            @elseif($payment['type'] == 'paypal_link')
                                <a href="{{ $payment['link'] }}" target="_blank">
                                    <x-fab-paypal class="size-7 mx-2 my-2" />
                                </a>
                            @endif
                        @endforeach
                    </div>

                @endif

                <div class="px-5">
                    <form wire:submit.prevent="cashCarryForm" class="w-full">

                        <div class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">

                            <div class="col-span-full sm:col-span-2">
                                <label for="firstname" class="block text-sm/6 font-medium">First
                                    name</label>
                                <div class="mt-2">
                                    <input type="text" id="firstname" wire:model="firstname"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('firstname') border border-red-600 @enderror"
                                        value="{{ old('firstname') }}">
                                </div>

                                @error('firstname')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full sm:col-span-2">
                                <label for="lastname" class="block text-sm/6 font-medium">Last
                                    name</label>
                                <div class="mt-2">
                                    <input type="text" id="lastname" wire:model="lastname"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('lastname') border border-red-600 @enderror"
                                        value="{{ old('lastname') }}">
                                </div>

                                @error('lastname')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            {{-- <div class="col-span-full">

                                <label for="lastname" class="block text-sm/6 font-medium">Last
                                    name</label>
                                <div>
                                    <div class="mt-2">
                                        <select id="event_type" x-model="type" name="event_type" wire:model="event_type"
                                            class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3">
                                            <option value="">Select Type</option>
                                            <option value="Photo">Photo</option>
                                            <option value="Video">Video</option>
                                        </select>
                                    </div>
                                </div>
                            </div> --}}

                            <div class="col-span-full">

                                <label for="phone" class="block text-sm/6 font-medium">Phone
                                </label>

                                <div class="mt-2">
                                    <input type="text" id="phone" wire:model="phone"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('phone') border border-red-600 @enderror"
                                        value="{{ old('phone') }}">
                                </div>

                                @error('phone')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">

                                <label for="phone" class="block text-sm/6 font-medium">Email
                                </label>

                                <div class="mt-2">
                                    <input type="text" id="sender_email" wire:model="sender_email"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('sender_email') border border-red-600 @enderror"
                                        value="{{ old('sender_email') }}">
                                </div>

                                @error('sender_email')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <label for="receipt" class="block text-sm/6 font-medium">After Payment, Upload
                                    Receipt</label>
                                <div class="mt-2">
                                    <input type="file" id="receipt" wire:model="receipt"
                                        class="block w-full text-sm text-gray-900 border border-gray-300 rounded-md cursor-pointer bg-slate-100 focus:outline-none focus:ring-2 focus:ring-yellow-600 @error('receipt') border-red-600 @enderror">
                                </div>

                                @error('receipt')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror

                                <!-- Livewire upload progress -->
                                <div wire:loading wire:target="receipt" class="text-sm text-gray-500 mt-1">
                                    Uploading receipt...
                                </div>
                            </div>

                            <div class="col-span-full">
                                <label class="block text-sm/6 font-medium">What’s your best way to connect?</label>
                                <div class="mt-3 space-y-2">
                                    <label class="flex items-center space-x-2">
                                        <input type="radio" wire:model="preferred_contact" value="Text" checked
                                            class="h-4 w-4 text-yellow-600 focus:ring-yellow-600 border-gray-300">
                                        <span class="text-sm">Text</span>
                                    </label>

                                    <label class="flex items-center space-x-2">
                                        <input type="radio" wire:model="preferred_contact" value="WhatsApp"
                                            class="h-4 w-4 text-yellow-600 focus:ring-yellow-600 border-gray-300">
                                        <span class="text-sm">WhatsApp</span>
                                    </label>

                                    <label class="flex items-center space-x-2">
                                        <input type="radio" wire:model="preferred_contact" value="Email"
                                            class="h-4 w-4 text-yellow-600 focus:ring-yellow-600 border-gray-300">
                                        <span class="text-sm">Email</span>
                                    </label>
                                </div>
                                @error('preferred_contact')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <button type="submit"
                                    class="mt-5 w-full rounded-md px-3 py-2 text-sm font-semibold shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 "
                                    style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">Send</button>
                            </div>
                        </div>
                    </form>
                </div>

                {{-- Direction Links --}}
                @if (in_array($user['user_type'], ['Basic', 'Gold', 'Platinum', 'Influencer', 'Sponsored']))
                    @if ($directions)
                        <p class="flex items-center justify-center text-center pt-10">
                            Driving Directions
                        </p>

                        <div class="pt-2 container mx-auto flex flex-wrap items-center justify-center">
                            @foreach ($directions as $direction)
                                @if ($direction['type'] == 'google_map')
                                    <a href="{{ $direction['link'] }}" target="_blank">
                                        <x-mdi-google-maps class="size-7 mx-2 my-2" />
                                    </a>
                                @elseif($direction['type'] == 'apple_map')
                                    <a href="{{ $direction['link'] }}" target="_blank">
                                        <x-fab-apple class="size-7 mx-2 my-2" />
                                    </a>
                                @elseif($direction['type'] == 'waze')
                                    <a href="{{ $direction['link'] }}" target="_blank">
                                        <x-fab-waze class="size-7 mx-2 my-2" />
                                    </a>
                                @endif
                            @endforeach
                        </div>

                    @endif
                @endif

            </div>
        @else
            <div class="h-screen flex justify-center items-center">
                <div>
                    <p class="mx-auto text-yellow-500 text-center text-l p-10">
                        <x-ionicon-warning-sharp class=" size-32 sm:size-40" />
                    </p>
                    <p class="mx-auto font-bold text-center text-2xl">Product not found
                    </p>
                    {{-- <p class="flex items-center justify-center text-center text-l py-1">
                    Get your&nbsp;<a href="https://10kcards.com" target="_blank" class="text-yellow-600">10k
                        card</a>&nbsp;today!
                </p> --}}
                </div>
            </div>
    @endif
</div>
