<div class="m-0 p-0">
    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl py-5 mt-5 mb-20">

        <div class="grid grid-cols-2 gap-4 mb-5">
            <!-- Download VCF -->
            {{-- <div class="ml-5 flex items-center" x-data>
                    <livewire:download-vcf-button username="{{ $contact_info->username }}" />
                </div> --}}
        </div>

        {{-- Display Profile Picture --}}
        <img loading="lazy"
            src="{{ $contact_info['profile_pic'] ? asset($contact_info['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
            alt="{{ $contact_info['firstname'] . ' ' . $contact_info['lastname'] }}"
            class="rounded-full w-6/12 mx-auto border-2 border-yellow-600 p-2 static">

        {{-- Display Full Name --}}
        <h1
            class="flex items-center justify-center text-2xl md:text-3xl font-medium text-center text-slate-800 dark:text-slate-300 mt-5">
            {{ $contact_info['firstname'] . ' ' . $contact_info['lastname'] }}&nbsp;

        </h1>

        {{-- Display Bio --}}
        @if ($contact_info['we_met_at'])
            <p class="mx-auto w-10/12 text-slate-800 dark:text-slate-300 text-center text-l py-1">
                We met at: {{ $contact_info['we_met_at'] }}
            </p>
        @endif

        @if ($contact_info['help'])
            <p class="mx-auto w-10/12 text-slate-800 dark:text-slate-300 text-center text-l py-1">
                How may I help: {{ $contact_info['help'] }}
            </p>
        @endif

        {{-- Display Job Title --}}
        @if (!empty($contact_info['job_title']) && empty($contact_info['company']))
            <p class="text-slate-800 dark:text-slate-300 text-center text-base py-1 mx-8">
                <span class="inline-flex items-start gap-2">
                    <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                    <span>{{ $contact_info['job_title'] }}</span>
                </span>
            </p>
        @endif

        {{-- Display Job Title and company --}}
        @if (!empty($contact_info['job_title']) && !empty($contact_info['company']))

            <p class="text-slate-800 dark:text-slate-300 text-center text-base py-1 mx-8">
                <span class="inline-flex items-start gap-2">
                    <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                    <span>{{ $contact_info['job_title'] }}

                        @if (!empty($contact_info['company_website']))
                            at <a
                                href="{{ filter_var($contact_info['company_website'], FILTER_VALIDATE_URL) ? $contact_info['company_website'] : '#' }}"
                                class="text-yellow-600 font-medium">{{ $contact_info['company'] }}</a>
                        @else
                            at <span class="font-medium">{{ $contact_info['company'] }}</span>
                        @endif

                    </span>
                </span>
            </p>
        @endif

        {{-- Display Address --}}
        @if ($contact_info['country'])
            <p class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1">
                <x-heroicon-o-map-pin class="size-5" />
                &nbsp;&nbsp;{{ $contact_info['country'] }}
            </p>
        @endif

        <p class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center pt-5">
            Contact me
        </p>

        <div class="pt-2 container mx-auto flex items-center justify-center">
            <a href="mailto:{{ $contact_info['email'] }}" target="_blank" class="text-slate-800 dark:text-slate-300">
                <x-fas-envelope class="size-6 mx-2" />
            </a>
            <a href="tel:{{ $contact_info['phone'] }}" target="_blank" class="text-slate-800 dark:text-slate-300">
                <x-heroicon-s-phone class="size-6 mx-2" />
            </a>
            <a href="sms:{{ $contact_info['phone'] }}" target="_blank" class="text-slate-800 dark:text-slate-300">
                <x-fas-sms class="size-6 mx-2" />
            </a>
        </div>

        <div class="items-center">

            <a class="block bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 p-3 rounded-full w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                href="mailto:{{ $contact_info['email'] }}" target="_blank">Personal Email</a>

            <a class="block bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 p-3 rounded-full w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                href="tel:{{ $contact_info['phone'] }}" target="_blank">Direct Call</a>

            <a class="block bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 p-3 rounded-full w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                href="sms:{{ $contact_info['phone'] }}" target="_blank">SMS/Text</a>
        </div>
    </div>
</div>
