<div class="flex flex-row items-center whitespace-nowrap">
    @foreach ($contacts as $contact)
        @if ($contact['type'] === 'sms')
            <a href="sms:{{ $contact['link'] }}" target="_blank">
                <x-fas-sms class="size-6 mx-2 my-2" />
            </a>
        @elseif ($contact['type'] === 'phone')
            <a href="tel:{{ $contact['link'] }}" target="_blank">
                <x-heroicon-s-phone class="size-6 mx-2 my-2" />
            </a>
        @elseif ($contact['type'] === 'email')
            <a href="mailto:{{ $contact['link'] }}" target="_blank">
                <x-fas-envelope class="size-6 mx-2 my-2" />
            </a>
        @elseif ($contact['type'] === 'whatsapp')
            <a href="{{ $contact['link'] }}" target="_blank">
                <x-ri-whatsapp-fill class="size-6 mx-2 my-2" />
            </a>
        @elseif ($contact['type'] === 'wechat')
            <a href="{{ $contact['link'] }}" target="_blank">
                <x-ri-wechat-fill class="size-6 mx-2 my-2" />
            </a>
        @elseif ($contact['type'] === 'zalo')
            <a href="{{ $contact['link'] }}" target="_blank">
                <x-si-zalo class="size-6 mx-2 my-2" />
            </a>
        @elseif ($contact['type'] === 'telegram')
            <a href="{{ $contact['link'] }}" target="_blank">
                <x-fileicon-telegram class="size-6 mx-2 my-2" />
            </a>
        @elseif ($contact['type'] === 'zoom')
            <a href="{{ $contact['link'] }}" target="_blank">
                {{-- <x-bxl-zoom class="size-6 mx-2 my-2" /> --}}
                <x-si-zoom class="size-12 mx-2 my-2" />
            </a>
        @elseif ($contact['type'] === 'community')
            <a href="{{ $contact['link'] }}" target="_blank">
                <x-fas-users class="size-6 mx-2 my-2" />
            </a>
        @elseif ($contact['type'] === 'amazon_shop')
            <a href="{{ $contact['link'] }}" target="_blank">
                <x-fab-amazon class="size-6 mx-2 my-2" />
            </a>
        @endif
    @endforeach
</div>
