<div class="z-20 fixed sm:w-7/12 md:w-6/12 lg:w-4/12 mx-auto bottom-0 left-0 right-0 bg-white dark:bg-zinc-800 shadow-lg transform translate-y-full transition-transform duration-300 px-8 py-10 rounded-t-2xl"
    :class="{ 'translate-y-full': !showCopyReferCodeModal, 'translate-y-0': showCopyReferCodeModal }">

    <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Referral Code</h3>

    <div x-data="{ showToast: false }" class="mx-auto">
        {{-- <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">Use
            this to start earning:</h3> --}}
        <p class="text-base text-center font-sans text-yellow-500 py-2">{{ $affiliate_link }}
        </p>

        <button type="button"
            @click="navigator.clipboard.writeText(@js($affiliate_link));showToast=true;setTimeout(()=> showToast = false, 2000);"
            class="flex rounded-md bg-yellow-400 px-3.5 py-2.5 text-sm font-semibold shadow-xs hover:bg-yellow-400 focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-yellow-400 text-black mx-auto mt-5 mb-5 w-7/12 sm:w-6/12 justify-center"><x-fas-copy
                class="w-4" />&nbsp;&nbsp;Copy
            to clipboard</button>

        {{-- <a :href="'sms:' + payment_value" x-show="button_apple_pay"
            class="flex rounded-md bg-yellow-400 px-3.5 py-2.5 text-sm font-semibold shadow-xs hover:bg-yellow-400 focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-yellow-400 text-black mx-auto mt-5 mb-5 w-7/12 sm:w-6/12 justify-center"><x-heroicon-s-paper-airplane
                class="w-4" />&nbsp;&nbsp;Send by text</a> --}}

        <!-- Toast Notification -->
        <div x-show="showToast" x-transition:enter="transition transform ease-out duration-300"
            x-transition:enter-start="opacity-0 translate-y-2" x-transition:enter-end="opacity-100 translate-y-0"
            x-transition:leave="transition transform ease-in duration-200"
            x-transition:leave-start="opacity-100 translate-y-0" x-transition:leave-end="opacity-0 translate-y-2"
            class="fixed bottom-5 left-1/2 transform -translate-x-1/2 bg-green-500 text-white text-sm font-semibold px-4 py-2 rounded-md shadow-lg">
            Copied to clipboard.
        </div>
    </div>

    {{-- <button @click="showCopyReferCodeModal=!showCopyReferCodeModal"
        class="w-full px-4 py-2 text-center text-red-600 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 mt-10">Close</button> --}}
</div>
