<div x-data="{
    activeTab: 'all_network'
}">
    @guest
        <div id="custom_bg"
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative my-5 mb-20">
        @endguest

        @auth
            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative {{ auth()->user() && !auth()->user()->is_admin ? 'mb-20' : 'mb-2' }}">
            @endauth

            {{-- Top Navigation --}}
            <div
                class="grid grid-cols-4 gap-4 mb-5 pt-5 z-10 {{ $profile_layout == 'default_cover' || $profile_layout == 'cover_only' || $profile_layout == 'full_width' ? 'absolute top-0 left-0 w-full' : '' }}">
                <div class="ml-5 flex items-center col-span-2">
                    <a href="{{ route('card.show', $user->username) }}"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-home class="size-5" />
                    </a>
                </div>

                <div class="mr-5 flex items-center col-span-2 place-content-end" x-data="{
                    urlTitle: `{{ $trusted_network_title }} | {{ $page_title ?: $card_title }}`,
                    shareUrl: '{{ route('card.trustednetwork', $user->username) }}',
                    shareCard() {
                        if (navigator.share) {
                            navigator.share({
                                title: this.urlTitle,
                                url: this.shareUrl,
                            }).catch(console.error);
                        } else {
                            console.log('Web Share API not supported');
                        }
                    }
                }">
                    <button type="button" @click="showQRCode=!showQRCode"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                        <x-heroicon-o-qr-code class="size-5" />
                    </button>
                    <a href="#" x-on:click.prevent="shareCard"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-arrow-up-tray class="size-5" />
                    </a>
                </div>
            </div>

            {{-- Profile Layouts --}}
            @if ($profile_layout == 'default_cover')
                <img loading="lazy"
                    src="{{ $user['cover_pic'] ? asset($user['cover_pic']) : asset('/img/cover-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto">
                <img loading="lazy"
                    src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}"
                    class="rounded-full w-6/12 mx-auto -mt-28 border-2"
                    style="border-color: {{ $color_settings_profile_pic_border }} !important;">
            @elseif ($profile_layout == 'cover_only')
                <img loading="lazy"
                    src="{{ $user['cover_pic'] ? asset($user['cover_pic']) : asset('/img/cover-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto">
            @elseif ($profile_layout == 'default')
                <img loading="lazy"
                    src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}"
                    class="rounded-full w-6/12 mx-auto p-2 border-2"
                    style="border-color: {{ $color_settings_profile_pic_border }} !important;">
            @elseif ($profile_layout == 'rounded')
                <img loading="lazy"
                    src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}"
                    class="w-6/12 mx-auto p-2 border-2 rounded-[50px]"
                    style="border-color: {{ $color_settings_profile_pic_border }} !important;">
            @elseif ($profile_layout == 'full_width')
                <img loading="lazy"
                    src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto">
            @endif

            <h1 class="text-2xl font-medium text-center mt-5">{{ $trusted_network_title }}</h1>

            @if ($members->isNotEmpty())
                {{-- Toggle Buttons --}}
                <div class="flex flex-wrap justify-center items-center gap-2 mt-10 p-2 rounded-full">
                    @if ($members)
                        <button @click="activeTab = 'all_network'"
                            class="mx-1 px-4 py-2 text-sm rounded-full font-medium border border-current transition-all"
                            :style="activeTab === 'all_network'
                                ?
                                'background-color: #facc15; color: black;' :
                                'background-color: white; color: black;'">
                            All
                        </button>
                    @endif

                    @if ($state->isNotEmpty())
                        <button @click="activeTab = 'state'"
                            class="mx-1 px-4 py-2 text-sm rounded-full font-medium border border-current transition-all flex items-center"
                            :style="activeTab === 'state'
                                ?
                                'background-color: #facc15; color: black;' :
                                'background-color: white; color: black;'">

                            <span>State</span>
                            {{-- <x-heroicon-s-flag class="w-3 h-3 ml-1" /> --}}
                        </button>
                    @endif

                    @if ($global->isNotEmpty())
                        <button @click="activeTab = 'global'"
                            class="mx-1 px-4 py-2 text-sm rounded-full font-medium border border-current transition-all flex items-center"
                            :style="activeTab === 'global'
                                ?
                                'background-color: #facc15; color: black;' :
                                'background-color: white; color: black;'">

                            <span>Global</span>
                            {{-- <x-heroicon-s-globe-alt class="w-3 h-3 ml-1" /> --}}
                        </button>
                    @endif

                    @if ($eat->isNotEmpty())
                        <button @click="activeTab = 'eat'"
                            class="mx-1 px-4 py-2 text-sm rounded-full font-medium border border-current transition-all flex items-center"
                            :style="activeTab === 'eat'
                                ?
                                'background-color: #facc15; color: black;' :
                                'background-color: white; color: black;'">

                            <span>Eat</span>
                            {{-- <x-gmdi-restaurant class="w-3 h-3 ml-1" /> --}}
                        </button>
                    @endif

                    @if ($expert->isNotEmpty())
                        <button @click="activeTab = 'expert'"
                            class="mx-1 px-4 py-2 text-sm rounded-full font-medium border border-current transition-all flex items-center"
                            :style="activeTab === 'expert'
                                ?
                                'background-color: #facc15; color: black;' :
                                'background-color: white; color: black;'">

                            <span>Experts</span>
                            {{-- <x-heroicon-s-briefcase class="w-3 h-3 ml-1" /> --}}
                        </button>
                    @endif

                    @if ($event->isNotEmpty())
                        <button @click="activeTab = 'event'"
                            class="mx-1 px-4 py-2 text-sm rounded-full font-medium border border-current transition-all flex items-center"
                            :style="activeTab === 'event'
                                ?
                                'background-color: #facc15; color: black;' :
                                'background-color: white; color: black;'">

                            <span>Events</span>
                            {{-- <x-heroicon-s-calendar class="w-3 h-3 ml-1" /> --}}
                        </button>
                    @endif

                    {{-- Button will only show if user is logged in, is not admin,  and is not the owner of the card --}}
                    @if (auth()->user() && !auth()->user()->is_admin && auth()->user()->id != $owner_id)
                        <button @click="showRequestAddTrustedNetworkModal=!showRequestAddTrustedNetworkModal"
                            class="mx-1 px-4 py-2 text-sm rounded-full font-medium border border-current transition-all flex items-center"
                            style="background-color: white; color: black;">

                            <span>Add Me</span>
                        </button>
                    @endif

                    @guest
                        <button
                            @click="showRequestAddTrustedNetworkModalLoggedOut=!showRequestAddTrustedNetworkModalLoggedOut"
                            class="mx-1 px-4 py-2 text-sm rounded-full font-medium border border-current transition-all flex items-center"
                            style="background-color: white; color: black;">

                            <span>Add Me</span>
                        </button>
                    @endguest

                </div>

                {{-- CONTENTS --}}
                @if ($members)
                    {{-- All Products --}}
                    <div id="all_network" x-cloak x-show="activeTab === 'all_network'" x-transition>
                        {{-- Search --}}
                        {{-- <div
                        class="my-5 mx-5 flex items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600">
                        <div class="shrink-0 text-sm/6 font-medium text-gray-500 select-none sm:text-sm/6">
                            <x-heroicon-s-magnifying-glass class="size-7" />
                        </div>

                        <input type="text" wire:model.debounce.400ms="keyword"
                            wire:input.debounce.500ms="onKeywordUpdated"
                            class="block py-1.5 pr-3 pl-1 bg-gray-100 text-gray-900 placeholder:text-gray-400 focus:outline-none text-sm rounded-md w-full"
                            placeholder="name, company, job title, state or country" />
                    </div> --}}


                        {{-- <div x-data="{
                        loading: false,
                        observe() {
                            let observer = new IntersectionObserver((entries) => {
                                entries.forEach(entry => {
                                    if (entry.isIntersecting && !this.loading) {
                                        this.loading = true;
                                        $wire.loadMore().then(() => this.loading = false);
                                    }
                                });
                            });
                            observer.observe(this.$refs.infiniteScrollTrigger);
                        }
                    }" x-init="observe"> --}}

                        <div class="grid gap-4 mt-10 px-5 transition-opacity duration-200"
                            wire:loading.class="opacity-50">
                            @forelse ($members as $member)
                                <a href="{{ route('card.show', $member->username) }}">
                                    <div
                                        class="grid grid-cols-12 gap-4 bg-slate-100 dark:bg-zinc-800 rounded-md p-6 transition-all duration-300 hover:shadow-md">
                                        <div class="col-span-3 flex justify-center items-start">
                                            <img src="{{ asset($member->profile_pic) }}"
                                                alt="{{ $member->firstname . ' ' . $member->lastname }}"
                                                class="rounded-md w-16 h-16 object-cover">
                                        </div>
                                        <div class="col-span-9 px-2">
                                            <h1 class="text-xl font-medium truncate">
                                                {{ $member->firstname . ' ' . $member->lastname }}
                                            </h1>
                                            @if ($member->bio)
                                                <p class="text-base text-gray-600 dark:text-gray-300 mt-1">
                                                    {{ $member->bio }}</p>
                                            @endif
                                            @if (!empty($member->job_title))
                                                <p class="text-sm text-gray-700 dark:text-gray-400 py-1">
                                                    {{ $member->job_title }}
                                                    @if (!empty($member->company))
                                                        at <span class="font-medium">{{ $member->company }}</span>
                                                    @endif
                                                </p>
                                            @endif
                                            @if ($member->country)
                                                <p
                                                    class="flex items-center gap-2 text-sm text-gray-700 dark:text-gray-400 mt-2">
                                                    {{-- <x-country-flag :country="$member->country" /> --}}
                                                    <x-country-flag :country="$member->country" :state="$member->state" />
                                                </p>
                                            @endif
                                        </div>
                                    </div>
                                </a>
                            @empty
                                <div class="text-center text-gray-500 dark:text-gray-300 py-10 col-span-12">
                                    No result(s) found.
                                </div>
                            @endforelse
                        </div>

                        {{-- Infinite Scroll Trigger --}}
                        {{-- <div x-ref="infiniteScrollTrigger" class="mt-10 flex justify-center items-center">
                            @if ($members?->hasMorePages())
                                <span class="text-gray-500 dark:text-gray-300" wire:loading.remove>Loading
                                    more...</span>
                            @endif
                        </div>

                        <div wire:loading.flex wire:target="loadMore" class="justify-center py-5">
                            <svg class="animate-spin h-6 w-6 text-yellow-500" xmlns="http://www.w3.org/2000/svg"
                                fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor"
                                    stroke-width="4">
                                </circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v8z"></path>
                            </svg>
                        </div>
                    </div> --}}

                    </div>
                @endif

                @if ($state)
                    <div x-cloak x-show="activeTab === 'state'" x-transition>
                        @foreach ($this->state as $state => $members)
                            @php
                                $members = collect($members);
                                $first = $members->first();
                            @endphp

                            <h2 class="text-xl font-bold mt-6 text-center">
                                {{ $state !== '—' && trim($state) !== '' ? "$state, $first->country" : $first->country }}
                            </h2>

                            <div class="grid gap-4 mt-10 px-5 transition-opacity duration-200"
                                wire:loading.class="opacity-50">
                                @forelse ($members as $member)
                                    <a href="{{ route('card.show', $member->username) }}">
                                        <div
                                            class="grid grid-cols-12 gap-4 bg-slate-100 dark:bg-zinc-800 rounded-md p-6 transition-all duration-300 hover:shadow-md">
                                            <div class="col-span-3 flex justify-center items-start">
                                                <img src="{{ asset($member->profile_pic) }}"
                                                    alt="{{ $member->firstname . ' ' . $member->lastname }}"
                                                    class="rounded-md w-16 h-16 object-cover">
                                            </div>
                                            <div class="col-span-9 px-2">
                                                <h1 class="text-xl font-medium truncate">
                                                    {{ $member->firstname . ' ' . $member->lastname }}
                                                </h1>
                                                @if ($member->bio)
                                                    <p class="text-base text-gray-600 dark:text-gray-300 mt-1">
                                                        {{ $member->bio }}</p>
                                                @endif
                                                @if (!empty($member->job_title))
                                                    <p class="text-sm text-gray-700 dark:text-gray-400 py-1">
                                                        {{ $member->job_title }}
                                                        @if (!empty($member->company))
                                                            at <span class="font-medium">{{ $member->company }}</span>
                                                        @endif
                                                    </p>
                                                @endif
                                                @if ($member->country)
                                                    <p
                                                        class="flex items-center gap-2 text-sm text-gray-700 dark:text-gray-400 mt-2">
                                                        {{-- <x-country-flag :country="$member->country" /> --}}
                                                        <x-country-flag :country="$member->country" :state="$member->state" />
                                                    </p>
                                                @endif
                                            </div>
                                        </div>
                                    </a>
                                @empty
                                    <div class="text-center text-gray-500 dark:text-gray-300 py-10 col-span-12">
                                        No result(s) found.
                                    </div>
                                @endforelse
                            </div>
                        @endforeach

                    </div>
                @endif

                @if ($global)
                    <div x-cloak x-show="activeTab === 'global'" x-transition>
                        @foreach ($this->global as $country => $members)
                            <h2 class="text-xl font-bold mt-6 text-center">
                                {{ $country }}
                            </h2>

                            <div class="grid gap-4 mt-10 px-5 transition-opacity duration-200"
                                wire:loading.class="opacity-50">
                                @forelse ($members as $member)
                                    <a href="{{ route('card.show', $member->username) }}">
                                        <div
                                            class="grid grid-cols-12 gap-4 bg-slate-100 dark:bg-zinc-800 rounded-md p-6 transition-all duration-300 hover:shadow-md">
                                            <div class="col-span-3 flex justify-center items-start">
                                                <img src="{{ asset($member->profile_pic) }}"
                                                    alt="{{ $member->firstname . ' ' . $member->lastname }}"
                                                    class="rounded-md w-16 h-16 object-cover">
                                            </div>
                                            <div class="col-span-9 px-2">
                                                <h1 class="text-xl font-medium truncate">
                                                    {{ $member->firstname . ' ' . $member->lastname }}
                                                </h1>
                                                @if ($member->bio)
                                                    <p class="text-base text-gray-600 dark:text-gray-300 mt-1">
                                                        {{ $member->bio }}</p>
                                                @endif
                                                @if (!empty($member->job_title))
                                                    <p class="text-sm text-gray-700 dark:text-gray-400 py-1">
                                                        {{ $member->job_title }}
                                                        @if (!empty($member->company))
                                                            at <span class="font-medium">{{ $member->company }}</span>
                                                        @endif
                                                    </p>
                                                @endif
                                                @if ($member->country)
                                                    <p
                                                        class="flex items-center gap-2 text-sm text-gray-700 dark:text-gray-400 mt-2">
                                                        {{-- <x-country-flag :country="$member->country" /> --}}
                                                        <x-country-flag :country="$member->country" :state="$member->state" />
                                                    </p>
                                                @endif
                                            </div>
                                        </div>
                                    </a>
                                @empty
                                    <div class="text-center text-gray-500 dark:text-gray-300 py-10 col-span-12">
                                        No result(s) found.
                                    </div>
                                @endforelse
                            </div>
                        @endforeach

                    </div>
                @endif

                @if ($eat)
                    <div x-cloak x-show="activeTab === 'eat'" x-transition>
                        <h2 class="text-xl font-bold mt-6 text-center">
                            Places to Eat
                        </h2>

                        <div class="grid gap-4 mt-10 px-5 transition-opacity duration-200"
                            wire:loading.class="opacity-50">
                            @forelse ($eat as $member)
                                <a href="{{ route('card.show', $member->username) }}">
                                    <div
                                        class="grid grid-cols-12 gap-4 bg-slate-100 dark:bg-zinc-800 rounded-md p-6 transition-all duration-300 hover:shadow-md">
                                        <div class="col-span-3 flex justify-center items-start">
                                            <img src="{{ asset($member->profile_pic) }}"
                                                alt="{{ $member->firstname . ' ' . $member->lastname }}"
                                                class="rounded-md w-16 h-16 object-cover">
                                        </div>
                                        <div class="col-span-9 px-2">
                                            <h1 class="text-xl font-medium truncate">
                                                {{ $member->firstname . ' ' . $member->lastname }}
                                            </h1>
                                            @if ($member->bio)
                                                <p class="text-base text-gray-600 dark:text-gray-300 mt-1">
                                                    {{ $member->bio }}</p>
                                            @endif
                                            @if (!empty($member->job_title))
                                                <p class="text-sm text-gray-700 dark:text-gray-400 py-1">
                                                    {{ $member->job_title }}
                                                    @if (!empty($member->company))
                                                        at <span class="font-medium">{{ $member->company }}</span>
                                                    @endif
                                                </p>
                                            @endif

                                            @if ($member->country)
                                                <p
                                                    class="flex items-center gap-2 text-sm text-gray-700 dark:text-gray-400 mt-2">
                                                    <x-country-flag :country="$member->country" :state="$member->state" />
                                                </p>
                                            @endif
                                        </div>
                                    </div>
                                </a>
                            @empty
                                <div class="text-center text-gray-500 dark:text-gray-300 py-10 col-span-12">
                                    No result(s) found.
                                </div>
                            @endforelse

                        </div>
                    </div>
                @endif

                @if ($expert)
                    <div x-cloak x-show="activeTab === 'expert'" x-transition>
                        <h2 class="text-xl font-bold mt-6 text-center">
                            Experts
                        </h2>

                        <div class="grid gap-4 mt-10 px-5 transition-opacity duration-200"
                            wire:loading.class="opacity-50">
                            @forelse ($expert as $member)
                                <a href="{{ route('card.show', $member->username) }}">
                                    <div
                                        class="grid grid-cols-12 gap-4 bg-slate-100 dark:bg-zinc-800 rounded-md p-6 transition-all duration-300 hover:shadow-md">
                                        <div class="col-span-3 flex justify-center items-start">
                                            <img src="{{ asset($member->profile_pic) }}"
                                                alt="{{ $member->firstname . ' ' . $member->lastname }}"
                                                class="rounded-md w-16 h-16 object-cover">
                                        </div>
                                        <div class="col-span-9 px-2">
                                            <h1 class="text-xl font-medium truncate">
                                                {{ $member->firstname . ' ' . $member->lastname }}
                                            </h1>
                                            @if ($member->bio)
                                                <p class="text-base text-gray-600 dark:text-gray-300 mt-1">
                                                    {{ $member->bio }}</p>
                                            @endif
                                            @if (!empty($member->job_title))
                                                <p class="text-sm text-gray-700 dark:text-gray-400 py-1">
                                                    {{ $member->job_title }}
                                                    @if (!empty($member->company))
                                                        at <span class="font-medium">{{ $member->company }}</span>
                                                    @endif
                                                </p>
                                            @endif

                                            @if ($member->country)
                                                <p
                                                    class="flex items-center gap-2 text-sm text-gray-700 dark:text-gray-400 mt-2">
                                                    <x-country-flag :country="$member->country" :state="$member->state" />
                                                </p>
                                            @endif
                                        </div>
                                    </div>
                                </a>
                            @empty
                                <div class="text-center text-gray-500 dark:text-gray-300 py-10 col-span-12">
                                    No result(s) found.
                                </div>
                            @endforelse

                        </div>
                    </div>
                @endif

                @if ($event)
                    <div x-cloak x-show="activeTab === 'event'" x-transition>
                        <h2 class="text-xl font-bold mt-6 text-center">
                            Events
                        </h2>

                        <div class="grid gap-4 mt-10 px-5 transition-opacity duration-200"
                            wire:loading.class="opacity-50">
                            @forelse ($event as $member)
                                <a href="{{ route('card.show', $member->username) }}">
                                    <div
                                        class="grid grid-cols-12 gap-4 bg-slate-100 dark:bg-zinc-800 rounded-md p-6 transition-all duration-300 hover:shadow-md">
                                        <div class="col-span-3 flex justify-center items-start">
                                            <img src="{{ asset($member->profile_pic) }}"
                                                alt="{{ $member->firstname . ' ' . $member->lastname }}"
                                                class="rounded-md w-16 h-16 object-cover">
                                        </div>
                                        <div class="col-span-9 px-2">
                                            <h1 class="text-xl font-medium truncate">
                                                {{ $member->firstname . ' ' . $member->lastname }}
                                            </h1>
                                            @if ($member->bio)
                                                <p class="text-base text-gray-600 dark:text-gray-300 mt-1">
                                                    {{ $member->bio }}</p>
                                            @endif
                                            @if (!empty($member->job_title))
                                                <p class="text-sm text-gray-700 dark:text-gray-400 py-1">
                                                    {{ $member->job_title }}
                                                    @if (!empty($member->company))
                                                        at <span class="font-medium">{{ $member->company }}</span>
                                                    @endif
                                                </p>
                                            @endif

                                            @if ($member->country)
                                                <p
                                                    class="flex items-center gap-2 text-sm text-gray-700 dark:text-gray-400 mt-2">
                                                    <x-country-flag :country="$member->country" :state="$member->state" />
                                                </p>
                                            @endif
                                        </div>
                                    </div>
                                </a>
                            @empty
                                <div class="text-center text-gray-500 dark:text-gray-300 py-10 col-span-12">
                                    No result(s) found.
                                </div>
                            @endforelse

                        </div>
                    </div>
                @endif
            @else
                <div class="text-center text-gray-500 dark:text-gray-300 py-10 col-span-12">
                    No trusted network.
                </div>
            @endif

            {{-- Button will only show if user is logged in, is not admin,  and is not the owner of the card --}}
            @if (auth()->user() && !auth()->user()->is_admin && auth()->user()->id != $owner_id)
                <div class="flex justify-center mt-5">
                    <a @click="showRequestAddTrustedNetworkModal=!showRequestAddTrustedNetworkModal"
                        class="cursor-pointer mx-1 px-5 py-2 @if ($button_style === 'squared') rounded-md @else rounded-full @endif text-base font-medium border border-current transition-all text-center w-fit"
                        style="background-color: #facc15 !important; color: black !important;">
                        Add Me
                    </a>
                </div>
            @endif

            @guest
                <div class="flex justify-center mt-5">
                    <a @click="showRequestAddTrustedNetworkModalLoggedOut=!showRequestAddTrustedNetworkModalLoggedOut"
                        class="cursor-pointer mx-1 px-5 py-2 @if ($button_style === 'squared') rounded-md @else rounded-full @endif text-base font-medium border border-current transition-all text-center w-fit"
                        style="background-color: #facc15 !important; color: black !important;">
                        Add Me
                    </a>
                </div>
            @endguest

        </div>

    </div>
</div>
