<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                {{-- <a wire:navigate href="{{ route('dashboard.product') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a> --}}
            </div>

            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <x-heroicon-o-megaphone class="size-6 inline-block" />

                &nbsp;&nbsp;Ad Management
            </p>

            <div class="flex items-center col-span-1 place-content-end">

                <a href="{{ route('card.show', auth()->user()->username) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                    View Card
                    {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                </a>
            </div>
        </div>
    </div>


    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        {{-- <form wire:submit.prevent="saveLinks()" class="px-5">
            <div class="space-y-12">

                <div class="border-b border-gray-900/10  dark:border-gray-400 pb-12">

                    <div class="grid gap-x-6 gap-y-8">

                        <div class="col-span-full">
                            <label for="test"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Product
                                Name</label>
                            <div class="mt-2">
                                <div
                                    class="flex  items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('test') border border-red-600 @enderror">
                                    <input type="text" wire:model="test"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                        placeholder="Boxing Gloves" value="{{ old('test') }}">
                                </div>
                            </div>
                            @error('test')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>


            <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                <button type="submit"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">Add
                    Product</button>
            </div>
        </form> --}}

        <form wire:submit.prevent="saveLinks">

            <div class="space-y-12 px-5">
                @foreach ($ad_items as $item)
                    @if ($item['is_active'] === true)
                        <div class="col-span-full">

                            <p class="text-sm text-gray-800 dark:text-white">
                                {{ $item['caption'] }}
                            </p>

                            <div class="mt-2">
                                <input type="text" wire:model="ads.{{ $loop->index }}.user_link"
                                    class="block w-full rounded-md bg-white px-3 py-1.5 text-gray-900 outline outline-1 outline-gray-300 focus:outline-yellow-600 text-sm">
                            </div>

                        </div>
                    @endif
                @endforeach

                <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                    <button type="submit"
                        class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">Update
                        Links</button>
                </div>
            </div>
        </form>

    </div>

</div>
