<div>
    <livewire:card-view-tracker :username="$username" />
    @if ($ads_top->count() > 0 && $event->ad_active)
        <div wire:ignore x-data="carouselData_top()" x-cloak x-init="init" @touchstart.window="startTouch($event)"
            @touchend.window="endTouch($event)"
            class="sticky top-0 left-0 right-0 sm:w-7/12 md:w-6/12 lg:w-4/12 w-full m-0 p-0 mx-auto flex flex-col content-center rounded-2xl z-50"
            style="margin-top: 0 !important; padding-top: 0 !important;">

            <!-- Carousel -->
            @if ($ad_banner_w && $ad_banner_h)
                <div class="relative overflow-hidden w-full"
                    style="padding-top: {{ ($ad_banner_h / $ad_banner_w) * 100 }}%;">

                    <livewire:ad-component :ads="$ads_top" :username="$user->username" />
                </div>
            @endif
        </div>


        <!-- Alpine Component -->
        @push('scripts')
            <script>
                function carouselData_top() {
                    return {
                        activeIndex: 0,
                        ads: @js($ads_top),
                        timer: null,
                        startX: 0,

                        next() {
                            this.activeIndex = (this.activeIndex + 1) % this.ads.length;
                        },

                        prev() {
                            this.activeIndex = (this.activeIndex - 1 + this.ads.length) % this.ads.length;
                        },

                        goTo(index) {
                            this.activeIndex = index;
                        },

                        init() {
                            // this.timer = setInterval(() => {
                            //     this.next();
                            // }, 3000);

                            if (this.timer) clearInterval(this.timer);
                            this.timer = setInterval(() => this.next(), 5000);
                        },

                        startTouch(event) {
                            this.startX = event.touches[0].clientX;
                        },

                        endTouch(event) {
                            let endX = event.changedTouches[0].clientX;
                            let diffX = this.startX - endX;

                            if (Math.abs(diffX) > 50) {
                                if (diffX > 0) {
                                    this.next(); // swipe left
                                } else {
                                    this.prev(); // swipe right
                                }
                            }
                        }
                    }
                }
            </script>
        @endpush
    @endif

    @guest
        {{-- <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl my-5"> --}}

        <div id="custom_bg"
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative {{ (auth()->user() && !auth()->user()->is_admin && !$event->ad_active) || $ads_bottom->count() == 0 ? 'mb-20' : 'mb-2' }}">

        @endguest
        @auth
            {{-- <div id="custom_bg"
                    class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl mb-20 mt-5"> --}}

            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative {{ (auth()->user() && !auth()->user()->is_admin && !$event->ad_active) || $ads_bottom->count() == 0 ? 'mb-20' : 'mb-2' }}">

            @endauth
            <div
                class="grid grid-cols-2 gap-4 mb-5 pt-5 {{ $profile_layout == 'default_cover' || $profile_layout == 'full_width' ? 'absolute top-0 left-0 w-full' : '' }}">
                <!-- back -->
                <div class="ml-5 flex items-center">
                    <a href="{{ route('card.events', $user->username) }}"
                        class="rounded-full bg-slate-100
                            dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-chevron-left class="size-4" />
                    </a>
                </div>

                <!-- Share Card -->
                <div class="mr-5 flex items-center place-content-end" x-data="{
                    urlTitle: `{{ $event_title }} | {{ $page_title ?: $card_title }}`,
                    shareUrl: '{{ route('events.show', [$user->username, $slug]) }}',
                    shareCard() {
                        if (navigator.share) {
                            navigator.share({
                                title: this.urlTitle,
                                url: this.shareUrl,
                            }).then(() => {
                                console.log('Thanks for sharing!');
                            }).catch(console.error);
                        } else {
                            console.log('Web Share API not supported');
                        }
                    }
                }">

                    <button type="button" @click="showQRCode=!showQRCode"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                        <x-heroicon-o-qr-code class="size-5" />
                    </button>

                    <a href="#" id="share_my_card" x-on:click.prevent="shareCard"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-arrow-up-tray class="size-5" />
                    </a>
                </div>
            </div>


            {{-- Display Profile Picture --}}
            {{-- cover photo --}}
            @if ($profile_layout == 'default_cover')
                <img loading="lazy"
                    src="{{ $user->cover_pic ? asset($user->cover_pic) : asset('/img/cover-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto ">

                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="rounded-full w-6/12 mx-auto -mt-28"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
            @endif

            {{-- Cover Only --}}
            @if ($profile_layout == 'cover_only')
                <img loading="lazy"
                    src="{{ $user->cover_pic ? asset($user->cover_pic) : asset('/img/cover-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto ">
            @endif

            {{-- circled profile pic --}}
            @if ($profile_layout == 'default')
                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="rounded-full w-6/12 mx-auto p-2 static"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
            @endif

            {{-- rounded profile pic --}}
            @if ($profile_layout == 'rounded')
                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-6/12 mx-auto p-2 static"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important; border-radius: 50px;">
            @endif

            {{-- full width profile pic --}}
            @if ($profile_layout == 'full_width')
                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto ">
            @endif

            {{-- Display Full Name --}}
            <h1 class="flex items-center justify-center text-2xl md:text-3xl font-medium text-center mt-5 mx-5">
                <span>
                    {{ isset($card_title) ? $card_title : $firstname . ' ' . $lastname }}
                    @if ($user->user_type == 'Gold')
                        {{-- <x-gmdi-verified class="size-4 inline text-yellow-400" /> --}}
                        <x-gmdi-verified class="size-4 inline" style="color: #0053db !important;" />
                    @elseif($user->user_type == 'Platinum')
                        <x-gmdi-verified class="size-4 inline text-blue-500" />
                    @endif
                </span>
            </h1>

            @if ($username_enabled == true)
                <p class="rounded-full bg-yellow-400 py-1 px-2 text-[10px] text-black mx-auto w-fit my-2">
                    {{ '@' . $user->username }}
                </p>
            @endif

            {{-- Display Bio --}}
            @if ($user->bio && $short_bio_enabled == true)
                <p class="mx-auto w-10/12 text-center text-l py-1">
                    {{ $user->bio }}
                </p>
            @endif

            {{-- Display Job Title --}}
            @if (!empty($user->job_title) && empty($user->company))
                <p class="text-center text-base py-1 mx-8">
                    <span class="inline-flex items-start gap-2">
                        <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                        <span>{{ $user->job_title }}</span>
                    </span>
                </p>
            @endif

            {{-- Display Job Title and company --}}
            @if (!empty($user->job_title) && !empty($user->company))

                <p class="text-center text-base py-1 mx-8">
                    <span class="inline-flex items-start gap-2">
                        <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                        <span>{{ $user->job_title }}

                            @if (!empty($user->company_website))
                                at <a
                                    href="{{ filter_var($user->company_website, FILTER_VALIDATE_URL) ? $user->company_website : '#' }}"
                                    class="font-medium"
                                    style="color: {{ $color_settings_link }} !important;">{{ $user->company }}</a>
                            @else
                                at <span class="font-medium">{{ $user->company }}</span>
                            @endif

                        </span>
                    </span>
                </p>
            @endif

            @if (($user->address || $user->country) && $display_country)
                <p class="flex items-center justify-center text-center text-l py-1 space-x-2">
                    <x-heroicon-o-map-pin class="size-5" />
                    <x-country-flag :country="$user->country" />
                </p>
            @endif

            <div class="mt-5 px-5">
                {{-- @if ($event->event_type === 'Photo') --}}
                @if ($event->event_poster && $event->poster_active)
                    <a href="{{ $event->button_link }}" target="_blank">
                        <img src="{{ $event->event_poster ? asset($event->event_poster) : asset('/img/product-placeholder.jpg') }}"
                            alt="{{ $event->title }}" class="rounded-md"
                            style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
                    </a>
                @endif
            </div>


            @if ($videos && in_array($user->user_type, ['Basic', 'Gold', 'Sponsored', 'Influencer', 'Platinum']))
                <div class="w-full relative mx-auto px-5 mt-10" style="z-index: 0; position: relative;"
                    x-data="initSwiper()">

                    {{-- <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            document.querySelectorAll('.swiper-slide').forEach((slide) => {
                                const iframe = slide.querySelector('iframe');
                                const playButton = slide.querySelector('.play-button');
                                const thumbnailOverlay = slide.querySelector('.thumbnail-overlay');

                                playButton.addEventListener('click', () => {
                                    if (iframe.src.includes('youtube')) {
                                        iframe.contentWindow.postMessage(JSON.stringify({
                                            event: 'command',
                                            func: 'playVideo',
                                            args: []
                                        }), '*');
                                    } else if (iframe.src.includes('vimeo')) {
                                        const player = new Vimeo.Player(iframe);
                                        player.play();
                                    }

                                    // Hide the thumbnail overlay after clicking the play button
                                    thumbnailOverlay.style.display = 'none';
                                });
                            });
                        });

                        function initSwiper() {
                            return {
                                swiper: null,
                                videoIsPlaying: false,
                                userPausedByInteraction: false,
                                awaitingPlayFromInteraction: false,
                                autoplayDelay: 5000,
                                _autoplayTimer: null,
                                _awaitTimer: null,
                                lastIndex: 0,
                                _resumeTimer: null,

                                _pauseAutoplayFor(ms = 5000) {
                                    this._stopAutoplayNow();
                                    this.userPausedByInteraction = true;

                                    if (this._resumeTimer) {
                                        clearTimeout(this._resumeTimer);
                                        this._resumeTimer = null;
                                    }

                                    this._resumeTimer = setTimeout(() => {
                                        this.userPausedByInteraction = false;
                                        this._scheduleAutoplay();
                                    }, ms);
                                },
                                _stopAutoplayNow() {
                                    if (this._autoplayTimer) {
                                        clearTimeout(this._autoplayTimer);
                                        this._autoplayTimer = null;
                                    }
                                },

                                _scheduleAutoplay() {
                                    this._stopAutoplayNow();
                                    if (this.videoIsPlaying || this.userPausedByInteraction) return;
                                    const self = this;
                                    this._autoplayTimer = setTimeout(() => {
                                        if (!self.videoIsPlaying && !self.userPausedByInteraction && self.swiper) {
                                            try {
                                                self.swiper.slideNext();
                                            } catch {}
                                        }
                                        self._scheduleAutoplay();
                                    }, this.autoplayDelay);
                                },

                                _clearAwaiting() {
                                    if (this._awaitTimer) {
                                        clearTimeout(this._awaitTimer);
                                        this._awaitTimer = null;
                                    }
                                    this.awaitingPlayFromInteraction = false;
                                },

                                pauseAllVideos() {
                                    // Pause HTML5 videos
                                    document.querySelectorAll('.default-carousel video').forEach(v => {
                                        try {
                                            v.pause();
                                        } catch {}
                                    });

                                    // Pause Vimeo videos via SDK
                                    if (typeof Vimeo !== 'undefined') {
                                        document.querySelectorAll('.default-carousel iframe[src*="vimeo.com"]').forEach(iframe => {
                                            try {
                                                new Vimeo.Player(iframe).pause();
                                            } catch {}
                                        });
                                    }

                                    // Pause YouTube videos via postMessage
                                    document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                                        try {
                                            iframe.contentWindow.postMessage(
                                                JSON.stringify({
                                                    event: 'command',
                                                    func: 'pauseVideo',
                                                    args: []
                                                }),
                                                "https://www.youtube.com" // ✅ correct target origin
                                            );
                                        } catch {}
                                    });
                                },

                                init() {
                                    const self = this;
                                    const isLoop = {{ $video_count > 1 ? 'true' : 'false' }};
                                    const container = document.querySelector('.default-carousel');
                                    if (!container) {
                                        console.warn('initSwiper: .default-carousel not found');
                                    }

                                    // ⬇️ interaction handler — updated here
                                    const onMediaInteraction = (ev) => {
                                        const slide = ev.target && ev.target.closest ? ev.target.closest('.swiper-slide') : null;
                                        if (!slide) return;

                                        if (slide.querySelector('video, iframe')) {
                                            self.userPausedByInteraction = true;
                                            self.awaitingPlayFromInteraction = true;
                                            self._clearAwaiting();
                                            self._stopAutoplayNow();
                                        }
                                    };

                                    document.addEventListener('pointerdown', onMediaInteraction, true);
                                    document.addEventListener('touchstart', onMediaInteraction, true);
                                    document.addEventListener('mousedown', onMediaInteraction, true);
                                    document.addEventListener('click', onMediaInteraction, true);
                                    document.addEventListener('focusin', onMediaInteraction, true);

                                    // === Video event listeners ===
                                    document.querySelectorAll('.default-carousel video').forEach(video => {
                                        video.addEventListener('play', () => {
                                            self._clearAwaiting();
                                            self.videoIsPlaying = true;
                                            self.userPausedByInteraction = true;
                                            self._stopAutoplayNow();
                                        }, {
                                            passive: true
                                        });

                                        video.addEventListener('pause', () => {
                                            self.videoIsPlaying = false;
                                            self.userPausedByInteraction = false;
                                            self._clearAwaiting();
                                            self._scheduleAutoplay();
                                        }, {
                                            passive: true
                                        });

                                        video.addEventListener('ended', () => {
                                            self.videoIsPlaying = false;
                                            self.userPausedByInteraction = false;
                                            self._clearAwaiting();
                                            try {
                                                self.swiper.slideNext();
                                            } catch {}
                                            self._scheduleAutoplay();
                                        }, {
                                            passive: true
                                        });
                                    });

                                    // YouTube: ensure enablejsapi=1
                                    document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                                        try {
                                            const src = iframe.getAttribute('src') || '';
                                            if (!/enablejsapi=1/.test(src)) {
                                                const sep = src.includes('?') ? '&' : '?';
                                                iframe.setAttribute('src', src + sep + 'enablejsapi=1');
                                            }
                                        } catch {}
                                    });

                                    // Vimeo API events
                                    if (typeof Vimeo !== 'undefined') {
                                        document.querySelectorAll('.default-carousel iframe[src*="vimeo.com"]').forEach(iframe => {
                                            try {
                                                const player = new Vimeo.Player(iframe);
                                                player.on('play', () => {
                                                    self._clearAwaiting();
                                                    self.videoIsPlaying = true;
                                                    self.userPausedByInteraction = true;
                                                    self._stopAutoplayNow();
                                                });
                                                player.on('pause', () => {
                                                    self.videoIsPlaying = false;
                                                    self.userPausedByInteraction = false;
                                                    self._scheduleAutoplay();
                                                });
                                                player.on('ended', () => {
                                                    self.videoIsPlaying = false;
                                                    self.userPausedByInteraction = false;
                                                    try {
                                                        self.swiper.slideNext();
                                                    } catch {}
                                                    self._scheduleAutoplay();
                                                });
                                            } catch {}
                                        });
                                    }

                                    // YouTube API events
                                    const buildYT = () => {
                                        document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                                            try {
                                                new YT.Player(iframe, {
                                                    events: {
                                                        onStateChange: (e) => {
                                                            if (e.data === YT.PlayerState.PLAYING || e.data === YT
                                                                .PlayerState.BUFFERING) {
                                                                self._clearAwaiting();
                                                                self.videoIsPlaying = true;
                                                                self.userPausedByInteraction = true;
                                                                self._stopAutoplayNow();
                                                            } else if (e.data === YT.PlayerState.PAUSED) {
                                                                self.videoIsPlaying = false;
                                                                self.userPausedByInteraction = false;
                                                                self._scheduleAutoplay();
                                                            } else if (e.data === YT.PlayerState.ENDED) {
                                                                self.videoIsPlaying = false;
                                                                self.userPausedByInteraction = false;
                                                                try {
                                                                    self.swiper.slideNext();
                                                                } catch {}
                                                                self._scheduleAutoplay();
                                                            }
                                                        }
                                                    }
                                                });
                                            } catch {}
                                        });
                                    };
                                    if (window.YT && YT.Player) buildYT();
                                    else window.onYouTubeIframeAPIReady = buildYT;

                                    // Swiper init
                                    this.swiper = new Swiper('.default-carousel', {
                                        loop: isLoop,
                                        pagination: {
                                            el: '.swiper-pagination',
                                            clickable: true,
                                            dynamicBullets: false,
                                        },
                                        on: {
                                            init() {
                                                updatePaginationActive(this);
                                            },
                                            slideChange() {
                                                self.pauseAllVideos();
                                                self._stopAutoplayNow();

                                                if (!self.userPausedByInteraction && !self.videoIsPlaying) {
                                                    self._scheduleAutoplay();
                                                }

                                                updatePaginationActive(this);
                                            }
                                        }
                                    });

                                    // ✅ Fixed pagination handler
                                    function updatePaginationActive(swiper) {
                                        if (!swiper || !swiper.pagination || !swiper.pagination.el) return;
                                        const bullets = Array.from(swiper.pagination.el.querySelectorAll('.swiper-pagination-bullet'));
                                        const activeIndex = (typeof swiper.realIndex !== 'undefined') ? swiper.realIndex : (swiper
                                            .activeIndex || 0);
                                        bullets.forEach((bullet, i) => {
                                            bullet.classList.toggle('swiper-pagination-bullet-active', i === activeIndex);
                                        });
                                    }

                                    const paginationEl = this.swiper.pagination && this.swiper.pagination.el;
                                    if (paginationEl) {
                                        paginationEl.addEventListener('click', (e) => {
                                            const bullet = e.target.closest('.swiper-pagination-bullet');
                                            if (!bullet) return;

                                            const bullets = Array.from(paginationEl.querySelectorAll('.swiper-pagination-bullet'));
                                            const index = bullets.indexOf(bullet);
                                            if (index === -1) return;

                                            try {
                                                self.swiper.slideToLoop(index);
                                            } catch {}

                                            updatePaginationActive(self.swiper);
                                            self._pauseAutoplayFor(5000);
                                        }, {
                                            passive: true
                                        });
                                    }

                                    this._scheduleAutoplay();
                                }

                            };
                        }
                    </script>

                    <script src="https://www.youtube.com/iframe_api"></script>
                    <script src="https://player.vimeo.com/api/player.js"></script> --}}

                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            document.querySelectorAll('.swiper-slide').forEach((slide) => {
                                const iframe = slide.querySelector('iframe');
                                const playButton = slide.querySelector('.play-button');
                                const thumbnailOverlay = slide.querySelector('.thumbnail-overlay');

                                if (playButton) {
                                    playButton.addEventListener('click', () => {
                                        if (iframe.src.includes('youtube')) {
                                            iframe.contentWindow.postMessage(JSON.stringify({
                                                event: 'command',
                                                func: 'playVideo',
                                                args: []
                                            }), '*');
                                        } else if (iframe.src.includes('vimeo')) {
                                            const player = new Vimeo.Player(iframe);
                                            player.play();
                                        }

                                        if (thumbnailOverlay) thumbnailOverlay.style.display = 'none';
                                    });
                                }
                            });
                        });

                        function initSwiper() {
                            return {
                                swiper: null,

                                pauseAllVideos() {
                                    // Pause HTML5 videos
                                    document.querySelectorAll('.default-carousel video').forEach(v => {
                                        try {
                                            v.pause();
                                        } catch {}
                                    });

                                    // Pause Vimeo videos
                                    if (typeof Vimeo !== 'undefined') {
                                        document.querySelectorAll('.default-carousel iframe[src*="vimeo.com"]').forEach(iframe => {
                                            try {
                                                new Vimeo.Player(iframe).pause();
                                            } catch {}
                                        });
                                    }

                                    // Pause YouTube videos
                                    document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                                        try {
                                            iframe.contentWindow.postMessage(
                                                JSON.stringify({
                                                    event: 'command',
                                                    func: 'pauseVideo',
                                                    args: []
                                                }),
                                                "https://www.youtube.com"
                                            );
                                        } catch {}
                                    });
                                },

                                init() {
                                    const self = this;
                                    const isLoop = {{ $video_count > 1 ? 'true' : 'false' }};

                                    // ============= VIDEO EVENT LISTENERS =============
                                    // HTML5 videos
                                    document.querySelectorAll('.default-carousel video').forEach(video => {
                                        video.addEventListener('play', () => {}, {
                                            passive: true
                                        });
                                        video.addEventListener('pause', () => {}, {
                                            passive: true
                                        });
                                        video.addEventListener('ended', () => {}, {
                                            passive: true
                                        });
                                    });

                                    // Ensure YouTube enablejsapi is set
                                    document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                                        try {
                                            const src = iframe.getAttribute('src') || '';
                                            if (!/enablejsapi=1/.test(src)) {
                                                const sep = src.includes('?') ? '&' : '?';
                                                iframe.setAttribute('src', src + sep + 'enablejsapi=1');
                                            }
                                        } catch {}
                                    });

                                    // Vimeo events
                                    if (typeof Vimeo !== 'undefined') {
                                        document.querySelectorAll('.default-carousel iframe[src*="vimeo.com"]').forEach(iframe => {
                                            try {
                                                const player = new Vimeo.Player(iframe);
                                                player.on('play', () => {});
                                                player.on('pause', () => {});
                                                player.on('ended', () => {});
                                            } catch {}
                                        });
                                    }

                                    // YouTube events
                                    const buildYT = () => {
                                        document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                                            try {
                                                new YT.Player(iframe, {
                                                    events: {
                                                        onStateChange: (e) => {
                                                            // No autoplay logic needed anymore
                                                        }
                                                    }
                                                });
                                            } catch {}
                                        });
                                    };
                                    if (window.YT && YT.Player) buildYT();
                                    else window.onYouTubeIframeAPIReady = buildYT;

                                    // ============= SWIPER INIT (no autoplay) =============
                                    this.swiper = new Swiper('.default-carousel', {
                                        loop: isLoop,
                                        pagination: {
                                            el: '.swiper-pagination',
                                            clickable: true,
                                            dynamicBullets: false,
                                        },
                                        on: {
                                            init() {
                                                updatePaginationActive(this);
                                            },
                                            slideChange() {
                                                self.pauseAllVideos();
                                                updatePaginationActive(this);
                                            }
                                        }
                                    });

                                    // Fix pagination handler
                                    function updatePaginationActive(swiper) {
                                        if (!swiper || !swiper.pagination || !swiper.pagination.el) return;
                                        const bullets = Array.from(swiper.pagination.el.querySelectorAll('.swiper-pagination-bullet'));
                                        const activeIndex = swiper.realIndex ?? swiper.activeIndex ?? 0;

                                        bullets.forEach((bullet, i) => {
                                            bullet.classList.toggle('swiper-pagination-bullet-active', i === activeIndex);
                                        });
                                    }

                                    const paginationEl = this.swiper.pagination && this.swiper.pagination.el;
                                    if (paginationEl) {
                                        paginationEl.addEventListener('click', (e) => {
                                            const bullet = e.target.closest('.swiper-pagination-bullet');
                                            if (!bullet) return;

                                            const bullets = Array.from(paginationEl.querySelectorAll('.swiper-pagination-bullet'));
                                            const index = bullets.indexOf(bullet);
                                            if (index === -1) return;

                                            try {
                                                self.swiper.slideToLoop(index);
                                            } catch {}
                                            updatePaginationActive(self.swiper);
                                        }, {
                                            passive: true
                                        });
                                    }
                                }
                            };
                        }
                    </script>

                    <script src="https://www.youtube.com/iframe_api"></script>
                    <script src="https://player.vimeo.com/api/player.js"></script>


                    <div class="swiper default-carousel mb-5" x-init="init()">
                        <div class="swiper-wrapper {{ $video_count > 1 ? 'mb-12' : 'mb-5' }}">

                            @php
                                if (!function_exists('vimeo_aspect_ratio')) {
                                    function vimeo_aspect_ratio(string $videoId, ?string $videoHash = null): string
                                    {
                                        $cacheKey = 'vimeo_oembed_ar_' . $videoId . '_' . ($videoHash ?? 'nohash');

                                        return cache()->remember($cacheKey, 86400, function () use (
                                            $videoId,
                                            $videoHash,
                                        ) {
                                            try {
                                                $playerUrl =
                                                    'https://player.vimeo.com/video/' .
                                                    $videoId .
                                                    ($videoHash ? '?h=' . $videoHash : '');
                                                $oembedUrl =
                                                    'https://vimeo.com/api/oembed.json?url=' . urlencode($playerUrl);

                                                $resp = \Illuminate\Support\Facades\Http::timeout(5)
                                                    ->retry(2, 100)
                                                    ->get($oembedUrl);
                                                if ($resp->ok()) {
                                                    $data = $resp->json();
                                                    if (!empty($data['width']) && !empty($data['height'])) {
                                                        return $data['height'] > $data['width'] ? '9/16' : '16/9';
                                                    }
                                                }
                                            } catch (\Throwable $e) {
                                                // fallback
                                            }
                                            return '16/9';
                                        });
                                    }
                                }
                            @endphp

                            @foreach ($videos as $index => $video)
                                @php
                                    $videoUrl = $video;
                                    $videoId = null;
                                    $videoHash = null;

                                    $isVimeo = false;
                                    $isInstagram = false;
                                    $isTikTok = false;
                                    $isShorts = false;
                                    $instagramType = null;

                                    $aspectRatio = '16/9';
                                    $maxWidth = '800px';

                                    // -----------------------------
                                    // YOUTUBE
                                    // -----------------------------
                                    if (preg_match('#youtu\.be/([a-zA-Z0-9_-]+)#', $videoUrl, $m)) {
                                        $videoId = $m[1];
                                    } elseif (preg_match('#youtube\.com/watch\?v=([a-zA-Z0-9_-]+)#', $videoUrl, $m)) {
                                        $videoId = $m[1];
                                    } elseif (preg_match('#youtube\.com/shorts/([a-zA-Z0-9_-]{11})#', $videoUrl, $m)) {
                                        $videoId = $m[1];
                                        $isShorts = true;
                                    } elseif (preg_match('#youtu\.be/([a-zA-Z0-9_-]{11})#', $videoUrl, $m)) {
                                        $videoId = $m[1];
                                    }

                                    if ($isShorts) {
                                        $aspectRatio = '9/16';
                                        $maxWidth = '450px';
                                    }

                                    // -----------------------------
                                    // VIMEO (all formats)
                                    // -----------------------------
                                    if (str_contains($videoUrl, 'vimeo.com')) {
                                        $isVimeo = true;

                                        if (preg_match('#vimeo\.com/(?:video/)?(\d+)#', $videoUrl, $m)) {
                                            $videoId = $m[1];
                                        }

                                        if (preg_match('#vimeo\.com/\d+/([a-zA-Z0-9]+)#', $videoUrl, $m)) {
                                            $videoHash = $m[1];
                                        }

                                        parse_str(parse_url($videoUrl, PHP_URL_QUERY) ?? '', $q);
                                        if (!empty($q['h'])) {
                                            $videoHash = $q['h'];
                                        }

                                        // Aspect ratio helper (your existing function)
                                        if ($videoId) {
                                            $aspectRatio = vimeo_aspect_ratio($videoId, $videoHash);
                                            if ($aspectRatio === '9/16') {
                                                $maxWidth = '450px';
                                            }
                                        }
                                    }

                                    // -----------------------------
                                    // INSTAGRAM (reels, posts, IGTV)
                                    // -----------------------------
                                    if (str_contains($videoUrl, 'instagram.com')) {
                                        if (preg_match('#instagram\.com/(reel|p|tv)/([^/?]+)#', $videoUrl, $m)) {
                                            $instagramType = $m[1];
                                            $videoId = $m[2];

                                            $isInstagram = true;
                                            $aspectRatio = '9/16';
                                            $maxWidth = '450px';
                                        }
                                    }

                                    // -----------------------------
                                    // TIKTOK
                                    // -----------------------------
                                    if (str_contains($videoUrl, 'tiktok.com')) {
                                        if (preg_match('#/video/(\d+)#', $videoUrl, $m)) {
                                            $videoId = $m[1];

                                            $isTikTok = true;
                                            $aspectRatio = '9/16';
                                            $maxWidth = '450px';
                                        }
                                    }

                                @endphp

                                <div class="swiper-slide w-full rounded-xl" data-slide-index="{{ $index }}">
                                    <div class="rounded-xl flex justify-center items-center bg-black"
                                        style="width:100%; border: 2px solid {{ $color_settings_profile_pic_border }} !important;">

                                        @if ($isVimeo && $videoId)
                                            <iframe
                                                src="https://player.vimeo.com/video/{{ $videoId }}{{ $videoHash ? '?h=' . $videoHash : '' }}"
                                                class="rounded-xl" allow="autoplay; fullscreen; picture-in-picture"
                                                frameborder="0" allowfullscreen
                                                style="width:100%; aspect-ratio: {{ $aspectRatio }}; max-width: {{ $maxWidth }};">
                                            </iframe>
                                        @elseif ($isInstagram && $videoId)
                                            <iframe
                                                src="https://www.instagram.com/{{ $instagramType }}/{{ $videoId }}/embed"
                                                class="rounded-xl" frameborder="0" allowfullscreen
                                                style="width:100%; aspect-ratio: {{ $aspectRatio }}; max-width: {{ $maxWidth }};">
                                            </iframe>
                                        @elseif ($isTikTok && $videoId)
                                            <iframe src="https://www.tiktok.com/embed/{{ $videoId }}"
                                                class="rounded-xl" frameborder="0" allowfullscreen
                                                style="width:100%; aspect-ratio: {{ $aspectRatio }}; max-width: {{ $maxWidth }};">
                                            </iframe>
                                        @elseif ($videoId)
                                            <iframe
                                                src="https://www.youtube.com/embed/{{ $videoId }}?enablejsapi=1"
                                                class="rounded-xl" frameborder="0"
                                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                                allowfullscreen
                                                style="width:100%; aspect-ratio: {{ $aspectRatio }}; max-width: {{ $maxWidth }};">
                                            </iframe>
                                        @endif

                                    </div>
                                </div>
                            @endforeach

                        </div>

                        <div class="swiper-pagination"></div>
                    </div>

                </div>
            @endif

            @if ($event->title_active)
                <h1 class="text-xl md:text-2xl font-medium text-center mt-5 px-2">
                    {{ $event->title }}</h1>
            @endif

            @if ($event->start_datetime)
                <div class="px-5 mt-1 text-center">
                    <p class="flex items-center justify-center text-black dark:text-white">
                        <x-heroicon-o-calendar-days class="size-5 inline-block" />
                        &nbsp;&nbsp;{{ \Carbon\Carbon::parse($event->start_datetime)->format('M j, Y') }}
                    </p>
                </div>
            @endif

            @if ($event->description)
                <div class="px-5 mt-5">
                    <div
                        class="text-center prose dark:prose-invert max-w-none text-black dark:text-white [&_strong]:text-black dark:[&_strong]:text-white">
                        {!! Purifier::clean($event->description) !!}
                    </div>
                </div>
            @endif

            {{-- <div class="mt-5 px-5">
                    <div class="">
                        <span>{!! Purifier::clean($event->description) !!}</span>
                    </div>
                </div> --}}

            {{-- Small Button --}}
            {{-- <a class="inline-flex max-w-[83.333333%] py-2 mt-5 px-5 rounded-full text-black text-center mx-auto text-base font-semibold"
                    style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                    href="{{ $event->button_link }}" target="_blank">
                    {{ $event->button_title }}
                </a> --}}
            @if ($event->button_link)
                <div class="w-full px-5">
                    <a href="{{ $event->button_link }}" target="_blank"
                        class="customButton block p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-full text-black text-center mx-auto mt-5 text-l font-bold"
                        style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                        {{ $event->button_title }}
                    </a>
                </div>
            @endif

            {{-- @if ($event->optional_cta) --}}
            @php
                $validCtas = array_filter((array) $event->optional_cta, function ($cta) {
                    return !empty($cta['title']) || !empty($cta['link']);
                });
            @endphp

            @if (count($validCtas) > 0)
                <div class="w-full px-5">
                    @foreach ($event->optional_cta as $cta)
                        <a href="{{ $cta['link'] }}" target="_blank"
                            class="customButton block p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-full text-black text-center mx-auto mt-5 text-l font-bold"
                            style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                            {{ $cta['title'] }}
                        </a>
                    @endforeach
                </div>
            @endif

            {{-- Partner Link --}}
            @if ($event->partner_link)
                <div class="w-full px-5">
                    <a href="{{ $event->partner_link }}" target="_blank"
                        class="customButton block p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-full text-black text-center mx-auto mt-5 text-l font-bold"
                        style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                        Partner with Me
                    </a>
                </div>
            @endif

            {{-- Shopping Cart --}}
            @if ($event->shop_active)
                @if ($event->shop_link)
                    <div class="w-full px-5">
                        <a href="{{ $event->shop_link }}" target="_blank"
                            class="customButton block p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-full text-black text-center mt-5 text-l font-bold"
                            style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                            Shop Now
                        </a>
                    </div>
                @endif

                @if (!$event->shop_link && $products->isNotEmpty())
                    <div class="w-full px-5">
                        <a href="{{ route('card.products', $username) }}" target="_blank"
                            class="customButton block p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif text-black text-center mt-5 text-l font-bold"
                            style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                            Shop Now
                        </a>
                    </div>
                @endif
            @endif


            @if ($contacts && $event->contact_active)
                <p class="flex items-center justify-center text-center pt-5">
                    Contact me
                </p>

                <div class="pt-2 container mx-auto flex items-center justify-center mb-3">

                    @foreach ($contacts as $contact)
                        @if ($contact_settings[$contact->id] ?? false)
                            @switch($contact->type)
                                @case('sms')
                                    <a href="sms:{{ $contact->link }}" target="_blank">
                                        <x-fas-sms class="size-6 mx-2" />
                                    </a>
                                @break

                                @case('phone')
                                    <a href="tel:{{ $contact->link }}" target="_blank">
                                        <x-heroicon-s-phone class="size-6 mx-2" />
                                    </a>
                                @break

                                @case('email')
                                    <a href="mailto:{{ $contact->link }}" target="_blank">
                                        <x-fas-envelope class="size-6 mx-2" />
                                    </a>
                                @break

                                @case('whatsapp')
                                    <a href="{{ $contact->link }}" target="_blank">
                                        <x-ri-whatsapp-fill class="size-6 mx-2" />
                                    </a>
                                @break

                                @case('telegram')
                                    <a href="{{ $contact->link }}" target="_blank">
                                        <x-fileicon-telegram class="size-6 mx-2" />
                                    </a>
                                @break

                                @case('zoom')
                                    <a href="{{ $contact->link }}" target="_blank">
                                        <x-si-zoom class="size-12 mx-2" />
                                    </a>
                                @break

                                @case('wechat')
                                    <a href="{{ $contact->link }}" target="_blank">
                                        <x-ri-wechat-fill class="size-6 mx-2 my-2" />
                                    </a>
                                @break

                                @case('zalo')
                                    <a href="{{ $contact->link }}" target="_blank">
                                        <x-si-zalo class="size-6 mx-2 my-2" />
                                    </a>
                                @break

                                @case('amazon_shop')
                                    <a href="{{ $contact->link }}" target="_blank">
                                        <x-fab-amazon class="size-6 mx-2 my-2" />
                                    </a>
                                @break
                            @endswitch
                        @endif
                    @endforeach

                    {{-- Partner Link --}}
                    @if ($event->partner_link)
                        <a href="{{ $event['partner_link'] }}" target="_blank">
                            <x-fas-handshake class="size-6 mx-2" />
                        </a>
                    @endif

                    {{-- Shopping Cart --}}
                    @if ($event->shop_active)
                        @if ($event->shop_link)
                            <a href="{{ $event['shop_link'] }}" target="_blank">
                                <x-heroicon-s-shopping-bag class="size-6 mx-2" />
                            </a>
                        @endif

                        @if (!$event->shop_link && $products->isNotEmpty())
                            <a href="{{ route('card.products', $username) }}" target="_blank">
                                <x-heroicon-s-shopping-bag class="size-6 mx-2" />
                            </a>
                        @endif
                    @endif
                </div>

            @endif


            {{-- Direction Links --}}
            @if (in_array($user['user_type'], ['Basic', 'Gold', 'Platinum', 'Influencer', 'Sponsored']))
                @if ($directions)
                    <p class="flex items-center justify-center text-center pt-10">
                        Driving Directions
                    </p>

                    <div class="pt-2 container mx-auto flex flex-wrap items-center justify-center">
                        @foreach ($directions as $direction)
                            @if ($direction['type'] == 'google_map')
                                <a href="{{ $direction['link'] }}" target="_blank">
                                    <x-mdi-google-maps class="size-7 mx-2 my-2" />
                                </a>
                            @elseif($direction['type'] == 'apple_map')
                                <a href="{{ $direction['link'] }}" target="_blank">
                                    <x-fab-apple class="size-7 mx-2 my-2" />
                                </a>
                            @elseif($direction['type'] == 'waze')
                                <a href="{{ $direction['link'] }}" target="_blank">
                                    <x-fab-waze class="size-7 mx-2 my-2" />
                                </a>
                            @endif
                        @endforeach
                    </div>

                @endif
            @endif

            {{-- PAY WITH PAYPAL --}}
            {{-- <form action="https://www.paypal.com/cgi-bin/webscr" method="post"
                    class="w-11/12 block bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 p-1.5 sm:p-2 rounded-full text-black text-center mx-auto mt-5 mb-2 text-xs sm:text-sm font-semibold">
                    <input type="hidden" name="cmd" value="_xclick">
                    <input type="hidden" name="business" value="contact@giobrasileno.com">
                    <input type="hidden" name="item_name" value="{{ $event->title }}">
                    <input type="hidden" name="amount" value="{{ $product->price }}">
                    <input type="submit" value="Pay with PayPal">
                </form> --}}
        </div>
        @if ($ads_bottom->count() > 0 && $event->ad_active)
            <div wire:ignore x-data="carouselData_bottom()" x-init="init" @touchstart.window="startTouch($event)"
                @touchend.window="endTouch($event)" {{-- class="left-0 right-0 sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto flex flex-col content-center rounded-2xl relative {{ auth()->user() ? 'mb-20' : 'mb-5' }}" --}}
                class="top-0 left-0 right-0 sm:w-7/12 md:w-6/12 lg:w-4/12 w-full m-0 p-0 mx-auto flex flex-col content-center rounded-2xl z-50 {{ auth()->user() && !auth()->user()->is_admin ? 'mb-20' : 'mb-2' }}"
                style="margin-top: 0 !important; padding-top: 0 !important;">

                <!-- Carousel -->
                @if ($ad_banner_w && $ad_banner_h)
                    {{-- <div class="relative overflow-hidden aspect-[{{ $ad_banner_w . '/' . $ad_banner_h }}]"> --}}
                    <div class="relative overflow-hidden w-full"
                        style="padding-top: {{ ($ad_banner_h / $ad_banner_w) * 100 }}%;">

                        <livewire:ad-component :ads="$ads_bottom" :username="$user->username" />

                        {{-- <template x-for="(ad, index) in ads" :key="index">
                            <div x-show="activeIndex === index" x-transition:enter="transition-opacity duration-500"
                                x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
                                x-transition:leave="transition-opacity duration-500"
                                x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
                                class="absolute inset-0">
                                <a :href="ad.link" target="_blank" class="adClickTracker"
                                    :data-ad-id="ad.id">
                                    <img :src="'/storage/' + ad.image" :alt="ad.caption"
                                        class="w-full h-full object-cover">
                                </a>
                            </div>
                        </template> --}}
                    </div>
                @endif
                {{-- @if ($ads_bottom->count() > 1)
                    <!-- Dots Pagination -->
                    <div class="left-0 right-0 flex justify-center gap-2 z-30">
                        <template x-for="(ad, index) in ads" :key="'dot-' + index">
                            <button class="w-2 h-2 rounded-full"
                                :class="activeIndex === index ? 'bg-yellow-400' : 'bg-yellow-100'"
                                @click="goTo(index)"></button>
                        </template>
                    </div>
                @endif --}}
            </div>

            <!-- Alpine Component -->
            @push('scripts')
                <script>
                    function carouselData_bottom() {
                        return {
                            activeIndex: 0,
                            ads: @js($ads_bottom),
                            timer: null,
                            startX: 0,

                            next() {
                                this.activeIndex = (this.activeIndex + 1) % this.ads.length;
                            },

                            prev() {
                                this.activeIndex = (this.activeIndex - 1 + this.ads.length) % this.ads.length;
                            },

                            goTo(index) {
                                this.activeIndex = index;
                            },

                            init() {
                                // this.timer = setInterval(() => {
                                //     this.next();
                                // }, 3000);

                                if (this.timer) clearInterval(this.timer);
                                this.timer = setInterval(() => this.next(), 5000);
                            },

                            startTouch(event) {
                                this.startX = event.touches[0].clientX;
                            },

                            endTouch(event) {
                                let endX = event.changedTouches[0].clientX;
                                let diffX = this.startX - endX;

                                if (Math.abs(diffX) > 50) {
                                    if (diffX > 0) {
                                        this.next(); // swipe left
                                    } else {
                                        this.prev(); // swipe right
                                    }
                                }
                            }
                        }
                    }
                </script>
            @endpush
        @endif
    </div>

</div>
